/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.testutil;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.cloudplatform.tenant.Tenant;
import com.sap.cloud.sdk.testutil.MockUtil;
import com.sap.cloud.sdk.testutil.TenantMocker;
import com.sap.cloud.sdk.testutil.TestConfigurationError;
import java.beans.ConstructorProperties;
import java.util.Map;
import javax.annotation.Nullable;
import org.mockito.Mockito;

class DefaultTenantMocker
implements TenantMocker {
    private final MockUtil mockUtil;
    private final Map<String, Tenant> tenants = Maps.newHashMap();
    @Nullable
    private Tenant currentTenant;

    @Override
    public Tenant mockTenant(String tenantId) {
        this.mockUtil.resetTenantFacade();
        Tenant tenant = (Tenant)Mockito.mock(Tenant.class);
        Mockito.when((Object)tenant.getTenantId()).thenReturn((Object)tenantId);
        this.tenants.put(tenantId, tenant);
        return tenant;
    }

    @Override
    public Tenant mockCurrentTenant() {
        return this.mockCurrentTenant("00000000-0000-0000-0000-000000000000");
    }

    @Override
    public Tenant mockCurrentTenant(String tenantId) {
        Tenant tenant;
        this.currentTenant = tenant = this.mockTenant(tenantId);
        return tenant;
    }

    @Override
    public void setCurrentTenant(@Nullable String tenantId) {
        if (tenantId == null) {
            this.currentTenant = null;
        } else {
            Tenant tenant = this.tenants.get(tenantId);
            if (tenant == null) {
                throw new TestConfigurationError("No tenant mocked with id " + tenantId + ". Make sure to mock the respective tenant before calling this method.");
            }
            this.currentTenant = tenant;
        }
    }

    @Override
    public void clearTenants() {
        this.mockUtil.resetTenantFacade();
        this.currentTenant = null;
        this.tenants.clear();
    }

    @ConstructorProperties(value={"mockUtil"})
    public DefaultTenantMocker(MockUtil mockUtil) {
        this.mockUtil = mockUtil;
    }

    Map<String, Tenant> getTenants() {
        return this.tenants;
    }

    @Nullable
    Tenant getCurrentTenant() {
        return this.currentTenant;
    }
}

