/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.testutil;

import com.sap.cloud.sdk.cloudplatform.security.Credentials;
import com.sap.cloud.sdk.cloudplatform.security.NoCredentials;
import com.sap.cloud.sdk.s4hana.serialization.SapClient;
import com.sap.cloud.sdk.testutil.ErpSystem;
import com.sap.cloud.sdk.testutil.MockUtil;
import com.sap.cloud.sdk.testutil.ServerMocker;
import java.beans.ConstructorProperties;
import java.net.URI;
import javax.annotation.Nullable;
import org.mockserver.integration.ClientAndServer;

class DefaultServerMocker
implements ServerMocker {
    private final MockUtil mockUtil;

    @Override
    public ClientAndServer mockServer(String destinationName, @Nullable String relativePath) {
        ClientAndServer server = ClientAndServer.startClientAndServer((Integer)0);
        this.mockUtil.mockDestination(destinationName, URI.create("http://localhost:" + server.getPort() + (relativePath != null ? relativePath : "")));
        return server;
    }

    @Override
    public ClientAndServer mockServer(String destinationName) {
        return this.mockServer(destinationName, null);
    }

    @Override
    public ClientAndServer mockErpServer(SapClient sapClient, @Nullable String relativePath) {
        ClientAndServer erpServer = ClientAndServer.startClientAndServer((Integer)0);
        this.mockUtil.mockSigningService();
        this.mockUtil.mockErpDestination(ErpSystem.builder().alias("").uri(URI.create("http://localhost:" + erpServer.getPort() + (relativePath != null ? relativePath : ""))).systemId("").sapClient(sapClient).build(), (Credentials)new NoCredentials());
        return erpServer;
    }

    @Override
    public ClientAndServer mockErpServer(SapClient sapClient) {
        return this.mockErpServer(sapClient, null);
    }

    @ConstructorProperties(value={"mockUtil"})
    public DefaultServerMocker(MockUtil mockUtil) {
        this.mockUtil = mockUtil;
    }
}

