/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.testutil;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.sap.cloud.sdk.cloudplatform.security.secret.SecretStore;
import com.sap.cloud.sdk.testutil.MockUtil;
import com.sap.cloud.sdk.testutil.MockedSecretStore;
import com.sap.cloud.sdk.testutil.SecretStoreMocker;
import com.sap.cloud.sdk.testutil.TestConfigurationError;
import java.beans.ConstructorProperties;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.Map;

class DefaultSecretStoreMocker
implements SecretStoreMocker {
    private final MockUtil mockUtil;
    private final Map<String, SecretStore> secretStores = Maps.newHashMap();
    private final Table<String, SecretStore, KeyStore> keyStores = HashBasedTable.create();

    @Override
    public void mockSecretStore(String name, SecretStore secretStore) {
        this.mockUtil.resetSecretStoreFacade();
        this.secretStores.put(name, secretStore);
    }

    @Override
    public void mockSecretStore(String name, String password) {
        this.mockUtil.resetSecretStoreFacade();
        this.secretStores.put(name, new MockedSecretStore(password));
    }

    @Override
    public void mockKeyStore(String name, SecretStore password, KeyStore keyStore) {
        this.mockUtil.resetSecretStoreFacade();
        this.keyStores.put((Object)name, (Object)password, (Object)keyStore);
    }

    @Override
    public void mockKeyStore(String name, String password, KeyStore keyStore) {
        this.mockKeyStore(name, new MockedSecretStore(password), keyStore);
    }

    @Override
    public void mockKeyStore(String name, SecretStore password, String keyStoreFileName, String keyStoreType) {
        this.mockUtil.resetSecretStoreFacade();
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader == null) {
            throw new TestConfigurationError("Failed to get ClassLoader in " + this.getClass().getName() + " for accessing local resources.");
        }
        try (InputStream inputStream = classLoader.getResourceAsStream(keyStoreFileName);){
            KeyStore keyStore = KeyStore.getInstance(keyStoreType);
            keyStore.load(inputStream, password.getSecret());
            this.keyStores.put((Object)name, (Object)password, (Object)keyStore);
        }
        catch (Exception e) {
            throw new TestConfigurationError(e);
        }
    }

    @Override
    public void mockKeyStore(String name, String password, String keyStoreFileName, String keyStoreType) {
        this.mockKeyStore(name, new MockedSecretStore(password), keyStoreFileName, keyStoreType);
    }

    @Override
    public void clearSecretStores() {
        this.mockUtil.resetSecretStoreFacade();
        this.secretStores.clear();
    }

    @Override
    public void clearKeyStores() {
        this.mockUtil.resetSecretStoreFacade();
        this.keyStores.clear();
    }

    @ConstructorProperties(value={"mockUtil"})
    public DefaultSecretStoreMocker(MockUtil mockUtil) {
        this.mockUtil = mockUtil;
    }

    Map<String, SecretStore> getSecretStores() {
        return this.secretStores;
    }

    Table<String, SecretStore, KeyStore> getKeyStores() {
        return this.keyStores;
    }
}

