/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.testutil;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.cloudplatform.cache.CacheManager;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationType;
import com.sap.cloud.sdk.cloudplatform.connectivity.GenericDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.RfcDestination;
import com.sap.cloud.sdk.cloudplatform.security.BasicCredentials;
import com.sap.cloud.sdk.cloudplatform.security.Credentials;
import com.sap.cloud.sdk.s4hana.connectivity.ErpDestination;
import com.sap.cloud.sdk.s4hana.serialization.SapClient;
import com.sap.cloud.sdk.testutil.ErpSystem;
import com.sap.cloud.sdk.testutil.MockRfcDestination;
import com.sap.cloud.sdk.testutil.MockUtil;
import com.sap.cloud.sdk.testutil.MockedJCoDestinationDataProvider;
import com.sap.cloud.sdk.testutil.RfcDestinationMocker;
import com.sap.cloud.sdk.testutil.TestConfigurationError;
import com.sap.conn.jco.rt.DefaultDestinationManager;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.mockito.Mockito;

class DefaultRfcDestinationMocker
implements RfcDestinationMocker {
    private static final String JCO_VERSION;
    private final MockUtil mockUtil;
    @Nullable
    private MockedJCoDestinationDataProvider mockedJCoDestinationDataProvider = null;

    private void resetJCoRuntime() {
        try {
            Class<?> runtimeFactoryClass = Class.forName("com.sap.conn.jco.rt.JCoRuntimeFactory");
            Object runtime = runtimeFactoryClass.getMethod("getRuntime", new Class[0]).invoke(null, new Object[0]);
            Class<?> defaultJCoRuntimeClass = Class.forName("com.sap.conn.jco.rt.DefaultJCoRuntime");
            Field destinationManagerField = defaultJCoRuntimeClass.getDeclaredField("destinationManager");
            destinationManagerField.setAccessible(true);
            Object defaultJCoRuntime = defaultJCoRuntimeClass.cast(runtime);
            DefaultDestinationManager destinationManager = (DefaultDestinationManager)destinationManagerField.get(defaultJCoRuntime);
            if (this.mockedJCoDestinationDataProvider == null) {
                this.mockedJCoDestinationDataProvider = new MockedJCoDestinationDataProvider(this.mockUtil);
            }
            Field providerField = DefaultDestinationManager.class.getDeclaredField("provider");
            providerField.setAccessible(true);
            providerField.set(destinationManager, this.mockedJCoDestinationDataProvider);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            throw new TestConfigurationError("Failed to initialize the JCo runtime. This usually indicates a missing or incorrect configuration.\n\nYou can solve this issue by performing one of the following tasks.\n\n1) Add a dependency to the SAP Java Connector (JCo) library. Since this library is not available via Maven, download version " + JCO_VERSION + " from https://service.sap.com/connectors and add the following dependency:\n\n" + "       <dependency>\n" + "           <groupId>com.sap.conn.jco</groupId>\n" + "           <artifactId>sapjco3</artifactId>\n" + "           <version>" + JCO_VERSION + "</artifactId>\n" + "           <scope>system</scope>\n" + "           <systemPath>${sapjco3.path}/sapjco3.jar</systemPath>\n" + "       </dependency>\n\n" + "   Finally, set the property \"sapjco3.path\" to point to your respective JCo directory. " + "Be aware that using scope \"system\" is discouraged since it can lead to issues in multi-module projects.\n\n" + "2) Install JCo in your local Maven repository. " + "This option is recommended as it avoids dependency issues with the \"system\" scope in multi-module projects. " + "First, download JCo as described in the previous step. " + "Then, install the dependency with:\n\n" + "       mvn install:install-file -Dfile=sapjco3.jar -DgroupId=com.sap.conn.jco -DartifactId=com.sap.conn.jco.sapjco3 -Dversion=" + JCO_VERSION + " -Dpackaging=jar\n\n" + "   Finally, add the following dependency to your project:\n\n" + "       <dependency>\n" + "           <groupId>com.sap.conn.jco</groupId>\n" + "           <artifactId>com.sap.conn.jco.sapjco3</artifactId>\n" + "           <version>" + JCO_VERSION + "</version>\n" + "           <scope>test</scope>\n" + "       </dependency>\n\n" + "Note that the use of scope \"test\" enables the clean use of this module from within other modules.", e);
        }
    }

    @Override
    public RfcDestination mockRfcDestination() {
        return this.mockRfcDestination(this.mockUtil.getErpSystem());
    }

    @Override
    public RfcDestination mockRfcDestination(@NonNull String systemAlias) {
        if (systemAlias == null) {
            throw new NullPointerException("systemAlias");
        }
        return this.mockRfcDestination(this.mockUtil.getErpSystem(systemAlias));
    }

    @Override
    public RfcDestination mockRfcDestination(@Nullable ErpSystem erpSystem) {
        return this.mockRfcDestination(erpSystem, null);
    }

    @Override
    public RfcDestination mockRfcDestination(@Nullable ErpSystem erpSystem, @Nullable Credentials credentials) {
        return this.mockRfcDestination(ErpDestination.getDefaultName(), erpSystem, credentials, null);
    }

    @Override
    public RfcDestination mockRfcDestination(@Nullable String destinationName, @NonNull String systemAlias) {
        if (systemAlias == null) {
            throw new NullPointerException("systemAlias");
        }
        return this.mockRfcDestination(destinationName, this.mockUtil.getErpSystem(systemAlias));
    }

    @Override
    public RfcDestination mockRfcDestination(@Nullable String destinationName, @Nullable ErpSystem erpSystem) {
        return this.mockRfcDestination(destinationName, erpSystem, null, null);
    }

    @Override
    public RfcDestination mockRfcDestination(@Nullable String destinationName, @Nullable ErpSystem erpSystem, @Nullable Credentials credentials) {
        return this.mockRfcDestination(destinationName, erpSystem, credentials, null);
    }

    @Override
    public RfcDestination mockRfcDestination(@Nullable String destinationName, @Nullable ErpSystem erpSystem, @Nullable Credentials credentials, @Nullable Map<String, String> propertiesByName) {
        CacheManager.invalidateAll();
        this.mockUtil.resetDestinationFacade();
        this.resetJCoRuntime();
        String name = destinationName == null ? ErpDestination.getDefaultName() : destinationName;
        ErpSystem erpSystemOrDefault = erpSystem != null ? erpSystem : this.mockUtil.getErpSystem();
        String applicationServer = erpSystemOrDefault.getApplicationServer();
        String instanceNumber = erpSystemOrDefault.getInstanceNumber();
        SapClient sapClient = erpSystemOrDefault.getSapClient();
        Locale locale = erpSystemOrDefault.getLocale();
        Credentials erpCredentials = this.mockUtil.getCredentialsProvider().getErpCredentials(erpSystemOrDefault, credentials);
        HashMap properties = Maps.newHashMap();
        properties.put("jco.client.ashost", applicationServer);
        properties.put("jco.client.sysnr", instanceNumber);
        properties.put("jco.client.client", sapClient.getValue());
        properties.put("jco.client.lang", locale.getLanguage());
        if (erpCredentials instanceof BasicCredentials) {
            properties.put("jco.client.user", ((BasicCredentials)erpCredentials).getUsername());
            properties.put("jco.client.passwd", ((BasicCredentials)erpCredentials).getPassword());
        }
        if (propertiesByName != null) {
            properties.putAll(propertiesByName);
        }
        RfcDestination destination = (RfcDestination)Mockito.mock(RfcDestination.class);
        Mockito.when((Object)destination.getDestinationType()).thenReturn((Object)DestinationType.RFC);
        Mockito.when((Object)destination.getName()).thenReturn((Object)name);
        Mockito.when((Object)destination.getPropertiesByName()).thenReturn((Object)properties);
        this.mockUtil.getDestinationMocker().getDestinations().put(name, (GenericDestination)destination);
        return destination;
    }

    @Override
    public RfcDestination mockRfcDestination(MockRfcDestination destination) {
        return this.mockRfcDestination(destination.getName(), destination.getErpSystem(), destination.getCredentials(), destination.getProperties());
    }

    @ConstructorProperties(value={"mockUtil"})
    public DefaultRfcDestinationMocker(MockUtil mockUtil) {
        this.mockUtil = mockUtil;
    }

    static {
        Properties properties = new Properties();
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            properties.load(classLoader.getResourceAsStream("sapjco3.properties"));
        }
        catch (IOException e) {
            throw new TestConfigurationError(e);
        }
        JCO_VERSION = properties.getProperty("version");
    }
}

