/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.testutil;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.cloudplatform.connectivity.AuthenticationType;
import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.cloudplatform.connectivity.Header;
import com.sap.cloud.sdk.cloudplatform.connectivity.ProxyConfiguration;
import com.sap.cloud.sdk.cloudplatform.connectivity.ProxyType;
import com.sap.cloud.sdk.cloudplatform.security.BasicCredentials;
import com.sap.cloud.sdk.cloudplatform.security.Credentials;
import com.sap.cloud.sdk.s4hana.connectivity.ErpDestination;
import com.sap.cloud.sdk.s4hana.connectivity.ErpEdition;
import com.sap.cloud.sdk.s4hana.connectivity.ErpServiceUriBuilder;
import com.sap.cloud.sdk.s4hana.serialization.SapClient;
import com.sap.cloud.sdk.testutil.ErpDestinationMocker;
import com.sap.cloud.sdk.testutil.ErpSystem;
import com.sap.cloud.sdk.testutil.MockErpDestination;
import com.sap.cloud.sdk.testutil.MockUtil;
import com.sap.cloud.sdk.testutil.SecurityUtil;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.assertj.core.util.Lists;

class DefaultErpDestinationMocker
implements ErpDestinationMocker {
    private final MockUtil mockUtil;

    @Override
    public Destination mockErpDestination() {
        return this.mockErpDestination(this.mockUtil.getErpSystem());
    }

    @Override
    public Destination mockErpDestination(@NonNull String systemAlias) {
        if (systemAlias == null) {
            throw new NullPointerException("systemAlias");
        }
        return this.mockErpDestination(this.mockUtil.getErpSystem(systemAlias));
    }

    @Override
    public Destination mockErpDestination(@Nullable ErpSystem erpSystem) {
        return this.mockErpDestination(erpSystem, null);
    }

    @Override
    public Destination mockErpDestination(@Nullable ErpSystem erpSystem, @Nullable Credentials credentials) {
        return this.mockErpDestination(ErpDestination.getDefaultName(), erpSystem, credentials);
    }

    @Override
    public Destination mockErpDestination(@Nullable String destinationName, @NonNull String systemAlias) {
        if (systemAlias == null) {
            throw new NullPointerException("systemAlias");
        }
        return this.mockErpDestination(destinationName, this.mockUtil.getErpSystem(systemAlias));
    }

    @Override
    public Destination mockErpDestination(@Nullable String destinationName, @Nullable ErpSystem erpSystem) {
        return this.mockErpDestination(destinationName, erpSystem, null);
    }

    @Override
    public Destination mockErpDestination(@Nullable String destinationName, @Nullable ErpSystem erpSystem, @Nullable Credentials credentials) {
        return this.mockErpDestination(destinationName, erpSystem, credentials, null, null, null, null, null, null, null, null, null);
    }

    @Override
    public Destination mockErpDestination(@Nullable String destinationName, @Nullable ErpSystem erpSystem, @Nullable Credentials credentials, @Nullable AuthenticationType authenticationType, @Nullable ProxyType proxyType, @Nullable ProxyConfiguration proxyConfiguration, @Nullable List<Header> headers, @Nullable KeyStore trustStore, @Nullable Boolean isTrustingAllCertificates, @Nullable KeyStore keyStore, @Nullable String keyStorePassword, @Nullable Map<String, String> propertiesByName) {
        Credentials erpCredentials;
        ErpSystem erpSystemOrDefault = erpSystem == null ? this.mockUtil.getErpSystem() : erpSystem;
        URI uri = erpSystemOrDefault.getUri();
        SapClient sapClient = erpSystemOrDefault.getSapClient();
        ErpEdition erpEdition = erpSystemOrDefault.getErpEdition();
        Locale locale = erpSystemOrDefault.getLocale();
        ProxyConfiguration erpSystemProxy = (ProxyConfiguration)erpSystemOrDefault.getProxyConfiguration().orNull();
        ErpServiceUriBuilder.registerTestSystem((URI)uri);
        this.mockUtil.mockSigningService();
        HashMap properties = Maps.newHashMap();
        properties.put("sap-client", sapClient.getValue());
        properties.put("sap-language", locale.getLanguage());
        if (propertiesByName != null) {
            properties.putAll(propertiesByName);
        }
        ArrayList headerList = Lists.newArrayList();
        if (headers != null) {
            headerList.addAll(headers);
        }
        if (!sapClient.isDefault()) {
            Header sapClientHeader = new Header("sap-client", sapClient.getValue());
            boolean hasHeader = false;
            for (Header header : headerList) {
                if (!header.equals((Object)sapClientHeader)) continue;
                hasHeader = true;
                break;
            }
            if (!hasHeader) {
                headerList.add(sapClientHeader);
            }
        }
        if ((erpCredentials = this.mockUtil.getCredentialsProvider().getErpCredentials(erpSystemOrDefault, credentials)) instanceof BasicCredentials) {
            Header authorizationHeader = SecurityUtil.newBasicHeader((BasicCredentials)erpCredentials);
            boolean hasHeader = false;
            for (Header header : headerList) {
                if (!header.equals((Object)authorizationHeader)) continue;
                hasHeader = true;
                break;
            }
            if (!hasHeader) {
                headerList.add(authorizationHeader);
            }
        }
        return this.mockUtil.mockDestination(destinationName == null ? ErpDestination.getDefaultName() : destinationName, uri, authenticationType, proxyType != null ? proxyType : (erpEdition == ErpEdition.ON_PREMISE ? ProxyType.ON_PREMISE : ProxyType.INTERNET), erpSystemProxy != null ? erpSystemProxy : proxyConfiguration, headerList, trustStore, isTrustingAllCertificates, keyStore, keyStorePassword, properties);
    }

    @Override
    public Destination mockErpDestination(MockErpDestination destination) {
        return this.mockErpDestination(destination.getName(), destination.getErpSystem(), destination.getCredentials(), destination.getAuthenticationType(), destination.getProxyType(), destination.getProxyConfiguration(), destination.getHeaders(), destination.getTrustStore(), destination.getIsTrustingAllCertificates(), destination.getKeyStore(), destination.getKeyStorePassword(), destination.getProperties());
    }

    @ConstructorProperties(value={"mockUtil"})
    public DefaultErpDestinationMocker(MockUtil mockUtil) {
        this.mockUtil = mockUtil;
    }
}

