/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.testutil;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.sap.cloud.sdk.cloudplatform.cache.CacheManager;
import com.sap.cloud.sdk.cloudplatform.connectivity.AuthenticationType;
import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationType;
import com.sap.cloud.sdk.cloudplatform.connectivity.GenericDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.Header;
import com.sap.cloud.sdk.cloudplatform.connectivity.ProxyConfiguration;
import com.sap.cloud.sdk.cloudplatform.connectivity.ProxyType;
import com.sap.cloud.sdk.cloudplatform.security.BasicCredentials;
import com.sap.cloud.sdk.cloudplatform.security.Credentials;
import com.sap.cloud.sdk.cloudplatform.security.NoCredentials;
import com.sap.cloud.sdk.testutil.DestinationMocker;
import com.sap.cloud.sdk.testutil.MockDestination;
import com.sap.cloud.sdk.testutil.MockUtil;
import com.sap.cloud.sdk.testutil.SecurityUtil;
import com.sap.cloud.sdk.testutil.TestConfigurationError;
import com.sap.cloud.sdk.testutil.TestSystem;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.security.KeyStore;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class DefaultDestinationMocker
implements DestinationMocker {
    private final MockUtil mockUtil;
    private final Map<String, GenericDestination> destinations = Maps.newHashMap();

    <DestinationT extends GenericDestination> DestinationT getDestinationAsType(Class<DestinationT> destinationClass, String destinationName) {
        GenericDestination destination = this.destinations.get(destinationName);
        if (destination == null) {
            throw new TestConfigurationError("Failed to find destination \"" + destinationName + "\". Have you mocked this destination?");
        }
        Class<?> actualClass = destination.getClass();
        if (!destinationClass.isAssignableFrom(actualClass)) {
            throw new TestConfigurationError("Mocked destination is not of type " + destinationClass.getSimpleName() + ". Actual type: " + actualClass.getSimpleName() + ".");
        }
        GenericDestination result = destination;
        return (DestinationT)result;
    }

    <DestinationT extends GenericDestination> Map<String, DestinationT> getDestinationsAsType(Class<DestinationT> destinationClass) {
        HashMap result = Maps.newHashMap();
        for (Map.Entry<String, GenericDestination> entry : this.destinations.entrySet()) {
            String name = entry.getKey();
            GenericDestination destination = entry.getValue();
            Class<?> actualClass = destination.getClass();
            if (!destinationClass.isAssignableFrom(actualClass)) {
                throw new TestConfigurationError("Mocked destination is not of type " + destinationClass.getSimpleName() + ". Actual type: " + actualClass.getSimpleName() + ".");
            }
            GenericDestination dest = destination;
            result.put(name, dest);
        }
        return result;
    }

    @Override
    public Destination mockDestination(String name, String systemAlias) {
        return this.mockDestination(name, this.mockUtil.getTestSystem(systemAlias));
    }

    @Override
    public Destination mockDestination(String name, TestSystem<?> testSystem) {
        return this.mockDestination(name, testSystem.getUri(), this.mockUtil.getCredentials(testSystem), (ProxyConfiguration)testSystem.getProxyConfiguration().orNull());
    }

    @Override
    public Destination mockDestination(String name, URI uri) {
        return this.mockDestination(name, uri, null);
    }

    @Override
    public Destination mockDestination(String name, URI uri, @Nullable Credentials credentials) {
        return this.mockDestination(name, uri, credentials, null);
    }

    @Override
    public Destination mockDestination(String name, URI uri, @Nullable Credentials credentials, @Nullable ProxyConfiguration proxyConfiguration) {
        if (credentials == null || credentials instanceof NoCredentials) {
            return this.mockDestination(name, uri, null, null, null, null, null, null, null, null, null);
        }
        if (credentials instanceof BasicCredentials) {
            return this.mockDestination(name, uri, AuthenticationType.BASIC_AUTHENTICATION, null, proxyConfiguration, Collections.singletonList(SecurityUtil.newBasicHeader((BasicCredentials)credentials)), null, null, null, null, null);
        }
        throw new TestConfigurationError("Unsupported credentials of type " + credentials.getClass().getSimpleName() + ": " + credentials + ".");
    }

    @Override
    public Destination mockDestination(@NonNull String name, @NonNull URI uri, @Nullable AuthenticationType authenticationType, @Nullable ProxyType proxyType, @Nullable ProxyConfiguration proxyConfiguration, @Nullable List<Header> headers, @Nullable KeyStore trustStore, @Nullable Boolean isTrustingAllCertificates, @Nullable KeyStore keyStore, @Nullable String keyStorePassword, @Nullable Map<String, String> propertiesByName) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (uri == null) {
            throw new NullPointerException("uri");
        }
        CacheManager.invalidateAll();
        this.mockUtil.resetDestinationFacade();
        Destination destination = (Destination)Mockito.mock(Destination.class);
        Mockito.when((Object)destination.getDestinationType()).thenReturn((Object)DestinationType.HTTP);
        Mockito.when((Object)destination.getName()).thenReturn((Object)name);
        Mockito.when((Object)destination.getUri()).thenReturn((Object)uri);
        if (authenticationType == null) {
            Mockito.when((Object)destination.getAuthenticationType()).thenReturn((Object)AuthenticationType.NO_AUTHENTICATION);
        } else {
            Mockito.when((Object)destination.getAuthenticationType()).thenReturn((Object)authenticationType);
        }
        if (proxyType == null) {
            Mockito.when((Object)destination.getProxyType()).thenReturn((Object)ProxyType.INTERNET);
        } else {
            Mockito.when((Object)destination.getProxyType()).thenReturn((Object)proxyType);
        }
        Mockito.when((Object)destination.getProxyConfiguration()).thenReturn((Object)Optional.fromNullable((Object)(proxyConfiguration != null ? proxyConfiguration : this.mockUtil.getProxyConfiguration())));
        if (headers == null) {
            Mockito.when((Object)destination.getHeaders((URI)ArgumentMatchers.nullable(URI.class))).thenReturn(Collections.emptyList());
        } else {
            Mockito.when((Object)destination.getHeaders((URI)ArgumentMatchers.nullable(URI.class))).thenReturn(headers);
        }
        if (isTrustingAllCertificates == null) {
            Mockito.when((Object)destination.isTrustingAllCertificates()).thenReturn((Object)true);
        } else {
            Mockito.when((Object)destination.isTrustingAllCertificates()).thenReturn((Object)isTrustingAllCertificates);
        }
        Mockito.when((Object)destination.getTrustStore()).thenReturn((Object)Optional.fromNullable((Object)trustStore));
        Mockito.when((Object)destination.getKeyStore()).thenReturn((Object)Optional.fromNullable((Object)keyStore));
        Mockito.when((Object)destination.getKeyStorePassword()).thenReturn((Object)Optional.fromNullable((Object)keyStorePassword));
        if (propertiesByName == null) {
            Mockito.when((Object)destination.getPropertiesByName()).thenReturn(Collections.emptyMap());
        } else {
            Mockito.when((Object)destination.getPropertiesByName()).thenReturn(propertiesByName);
        }
        this.destinations.put(name, (GenericDestination)destination);
        return destination;
    }

    @Override
    public Destination mockDestination(MockDestination destination) {
        return this.mockDestination(destination.getName(), destination.getUri(), destination.getAuthenticationType(), destination.getProxyType(), destination.getProxyConfiguration(), destination.getHeaders(), destination.getTrustStore(), destination.getIsTrustingAllCertificates(), destination.getKeyStore(), destination.getKeyStorePassword(), destination.getProperties());
    }

    @Override
    public void clearDestinations() {
        this.mockUtil.resetDestinationFacade();
        this.destinations.clear();
    }

    @ConstructorProperties(value={"mockUtil"})
    public DefaultDestinationMocker(MockUtil mockUtil) {
        this.mockUtil = mockUtil;
    }

    Map<String, GenericDestination> getDestinations() {
        return this.destinations;
    }
}

