/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.testutil;

import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.sap.cloud.sdk.cloudplatform.security.BasicCredentials;
import com.sap.cloud.sdk.cloudplatform.security.Credentials;
import com.sap.cloud.sdk.cloudplatform.security.NoCredentials;
import com.sap.cloud.sdk.testutil.ConfigFileUtil;
import com.sap.cloud.sdk.testutil.CredentialsProvider;
import com.sap.cloud.sdk.testutil.ErpSystem;
import com.sap.cloud.sdk.testutil.SerializedCredentials;
import com.sap.cloud.sdk.testutil.SerializedCredentialsList;
import com.sap.cloud.sdk.testutil.TestConfigurationError;
import com.sap.cloud.sdk.testutil.TestSystem;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

class DefaultCredentialsProvider
implements CredentialsProvider {
    private final Map<String, Credentials> credentials = Maps.newHashMap();
    @Nullable
    private String erpUsername = null;
    @Nullable
    private String erpPassword = null;

    DefaultCredentialsProvider() {
    }

    @Override
    public Credentials getCredentials(@NonNull TestSystem<?> testSystem) {
        if (testSystem == null) {
            throw new NullPointerException("testSystem");
        }
        return this.getCredentials(testSystem.getAlias());
    }

    @Override
    public Credentials getCredentials(@NonNull String systemAlias) {
        if (systemAlias == null) {
            throw new NullPointerException("systemAlias");
        }
        Credentials credentials = this.credentials.get(systemAlias);
        if (credentials == null) {
            throw new TestConfigurationError("No credentials found for alias \"" + systemAlias + "\". Make sure to specify credentials in the Java system property \"" + "test.credentials" + "\" or in " + ConfigFileUtil.buildMissingResourceFileMessage("credentials") + ": \n\n" + this.getCredentialsExampleYaml(systemAlias) + "\n\n" + this.getCredentialsExampleJson(systemAlias));
        }
        return credentials;
    }

    @Override
    public void loadCredentials(@NonNull String resourceFileName) {
        if (resourceFileName == null) {
            throw new NullPointerException("resourceFileName");
        }
        this.loadCredentials(ConfigFileUtil.getResourceFile(resourceFileName));
    }

    @Override
    public void loadCredentials(@Nullable File file) {
        if (file != null) {
            try {
                this.parseCredentials(Files.toString((File)file, (Charset)Charset.defaultCharset()));
            }
            catch (IOException e) {
                throw new TestConfigurationError(e);
            }
        }
    }

    @Override
    public void addCredentials(@NonNull String systemAlias, @NonNull Credentials credentials) {
        if (systemAlias == null) {
            throw new NullPointerException("systemAlias");
        }
        if (credentials == null) {
            throw new NullPointerException("credentials");
        }
        this.credentials.put(systemAlias, credentials);
    }

    @Override
    public void removeCredentials(@NonNull String systemAlias) {
        if (systemAlias == null) {
            throw new NullPointerException("systemAlias");
        }
        this.credentials.remove(systemAlias);
    }

    @Override
    public void clearCredentials() {
        this.erpUsername = null;
        this.erpPassword = null;
        this.credentials.clear();
    }

    Credentials getErpCredentials(@NonNull ErpSystem erpSystem, @Nullable Credentials credentials) {
        if (erpSystem == null) {
            throw new NullPointerException("erpSystem");
        }
        Object erpCredentials = credentials;
        if (erpCredentials == null) {
            erpCredentials = this.erpUsername != null && this.erpPassword != null ? new BasicCredentials(this.erpUsername, this.erpPassword) : this.getCredentials(erpSystem);
        }
        if (!(erpCredentials instanceof NoCredentials) && !(erpCredentials instanceof BasicCredentials)) {
            throw new TestConfigurationError("Unsupported credentials of type " + erpCredentials.getClass().getSimpleName() + ": " + erpCredentials + ".");
        }
        return erpCredentials;
    }

    void readErpCredentialsProperties() {
        String password;
        String username = System.getProperty("erp.username");
        if (username != null) {
            this.erpUsername = username;
        }
        if ((password = System.getProperty("erp.password")) != null) {
            this.erpPassword = password;
        }
    }

    void loadCredentials() {
        String property = System.getProperty("test.credentials");
        if (StringUtils.isNotBlank((CharSequence)property)) {
            File file = ConfigFileUtil.getUniqueFileForExtensions(new File(property));
            if (file != null && file.exists()) {
                this.loadCredentials(file);
            } else if (property.trim().startsWith("{") || property.trim().startsWith("---")) {
                this.parseCredentials(property);
            } else {
                ConfigFileUtil.throwFailedToParseProperty("test.credentials", property);
            }
        } else {
            this.loadCredentials(ConfigFileUtil.getUniqueResourceFileForExtensions("credentials"));
        }
    }

    private String getCredentialsExampleYaml(String systemAlias) {
        return "Example (YAML, recommended for hand-written files):\n---\ncredentials:\n\n- alias: \"" + systemAlias + "\"\n" + "  username: \"(username)\"\n" + "  password: \"(password)\"\n";
    }

    private String getCredentialsExampleJson(String systemAlias) {
        return "Example (JSON, recommended for generated files):\n{\n  \"credentials\": [\n    {\n      \"alias\": \"" + systemAlias + "\",\n" + "      \"username\": \"(username)\",\n" + "      \"password\": \"(password)\"\n" + "    }\n" + "  ]\n" + "}\n";
    }

    private void parseCredentials(@NonNull String str) {
        if (str == null) {
            throw new NullPointerException("str");
        }
        try {
            SerializedCredentialsList serializedCredentialsList = (SerializedCredentialsList)ConfigFileUtil.newObjectMapper(str).readValue(str, SerializedCredentialsList.class);
            List<SerializedCredentials> serializedCredentials = serializedCredentialsList.getCredentials();
            if (serializedCredentials != null) {
                for (SerializedCredentials credentials : serializedCredentials) {
                    String alias = credentials.getAlias();
                    String username = credentials.getUsername();
                    String password = credentials.getPassword();
                    if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{alias, username, password})) {
                        this.credentials.put(alias, (Credentials)new BasicCredentials(username, password));
                        continue;
                    }
                    this.credentials.put(alias, (Credentials)new NoCredentials());
                }
            }
        }
        catch (IOException e) {
            throw new TestConfigurationError(e);
        }
    }
}

