/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.testutil;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.sap.cloud.sdk.testutil.MockUtil;
import com.sap.cloud.sdk.testutil.TestConfigurationError;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.assertj.core.util.Lists;

class ConfigFileUtil {
    ConfigFileUtil() {
    }

    static ObjectMapper newObjectMapper(String value) {
        ObjectMapper objectMapper;
        if (value.trim().startsWith("{")) {
            objectMapper = new ObjectMapper();
        } else if (value.trim().startsWith("---")) {
            objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        } else {
            throw new TestConfigurationError("Failed to read value \"" + value + "\". Make sure to use JSON or YAML format.");
        }
        return objectMapper;
    }

    @Nullable
    static File getResourceFile(@NonNull String resourceFileName) {
        if (resourceFileName == null) {
            throw new NullPointerException("resourceFileName");
        }
        ClassLoader classLoader = MockUtil.class.getClassLoader();
        return classLoader == null ? null : FileUtils.toFile((URL)classLoader.getResource(resourceFileName));
    }

    @Nullable
    static File getUniqueResourceFileForExtensions(@Nullable String resourceFileName) {
        if (resourceFileName == null) {
            return null;
        }
        ArrayList existingFiles = Lists.newArrayList();
        String fileNameWithoutExtension = FilenameUtils.removeExtension((String)resourceFileName);
        for (String fileExtension : MockUtil.CONFIG_FILE_EXTENSIONS) {
            File candidate = ConfigFileUtil.getResourceFile(fileNameWithoutExtension + fileExtension);
            if (candidate == null || !candidate.exists()) continue;
            existingFiles.add(candidate);
        }
        if (existingFiles.size() > 1) {
            throw new TestConfigurationError("Found multiple equivalent resource files: " + existingFiles + ". Make sure to specify only one file.");
        }
        if (existingFiles.size() == 1) {
            return (File)existingFiles.get(0);
        }
        return null;
    }

    @Nullable
    static File getUniqueFileForExtensions(@Nullable File file) {
        if (file == null) {
            return null;
        }
        ArrayList existingFiles = Lists.newArrayList();
        String filePathWithoutExtension = FilenameUtils.removeExtension((String)file.getPath());
        for (String fileExtension : MockUtil.CONFIG_FILE_EXTENSIONS) {
            File candidate = new File(filePathWithoutExtension + fileExtension);
            if (!candidate.exists()) continue;
            existingFiles.add(candidate);
        }
        if (existingFiles.size() > 1) {
            throw new TestConfigurationError("Found multiple equivalent files: " + existingFiles + ". Make sure to specify only one file.");
        }
        if (existingFiles.size() == 1) {
            return (File)existingFiles.get(0);
        }
        return null;
    }

    static void throwFailedToParseProperty(String propertyName, String propertyValue) {
        throw new TestConfigurationError("Failed to parse property \"" + propertyName + "\" with value \"" + propertyValue + "\". " + "Have you specified an existing file or configuration in either JSON or YAML format?");
    }

    static String buildMissingResourceFileMessage(@NonNull String fileName) {
        if (fileName == null) {
            throw new NullPointerException("fileName");
        }
        StringBuilder sb = new StringBuilder("src/test/resources/" + fileName + MockUtil.CONFIG_FILE_EXTENSIONS.get(0) + " (alternatively: ");
        for (int i = 1; i < MockUtil.CONFIG_FILE_EXTENSIONS.size(); ++i) {
            sb.append(fileName).append(MockUtil.CONFIG_FILE_EXTENSIONS.get(i));
            if (i < MockUtil.CONFIG_FILE_EXTENSIONS.size() - 1) {
                sb.append(", ");
                continue;
            }
            sb.append(")");
        }
        return sb.toString();
    }
}

