/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.rfc;

import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionQuery;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Fields;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Table;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Value;
import com.sap.cloud.sdk.s4hana.serialization.BigDecimalConverter;
import com.sap.cloud.sdk.s4hana.serialization.BigIntegerConverter;
import com.sap.cloud.sdk.s4hana.serialization.BooleanConverter;
import com.sap.cloud.sdk.s4hana.serialization.ByteConverter;
import com.sap.cloud.sdk.s4hana.serialization.CharacterConverter;
import com.sap.cloud.sdk.s4hana.serialization.DoubleConverter;
import com.sap.cloud.sdk.s4hana.serialization.ErpType;
import com.sap.cloud.sdk.s4hana.serialization.ErpTypeConverter;
import com.sap.cloud.sdk.s4hana.serialization.FloatConverter;
import com.sap.cloud.sdk.s4hana.serialization.IntegerConverter;
import com.sap.cloud.sdk.s4hana.serialization.LocalDateConverter;
import com.sap.cloud.sdk.s4hana.serialization.LocalTimeConverter;
import com.sap.cloud.sdk.s4hana.serialization.LocaleConverter;
import com.sap.cloud.sdk.s4hana.serialization.LongConverter;
import com.sap.cloud.sdk.s4hana.serialization.ShortConverter;
import com.sap.cloud.sdk.s4hana.serialization.YearConverter;
import com.sap.cloud.sdk.s4hana.types.Year;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Locale;
import javax.annotation.Nonnull;

public class TableRow<QueryT extends AbstractRemoteFunctionQuery<QueryT, ?>> {
    private final Table<QueryT> table;
    private int fieldId = 0;

    TableRow(Table<QueryT> table) {
        this.table = table;
    }

    public int size() {
        return this.fieldId;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Nonnull
    private <T> TableRow<QueryT> field(Value<T> value) {
        ++this.fieldId;
        this.table.getValueList().add(value);
        return this;
    }

    @Nonnull
    private <T> Value<T> copyValueWithoutRowId(Value<T> value) {
        return new Value<T>(this.table.getRowId(), value.getName(), value.getDataType(), value.getValue(), value.getTypeConverter());
    }

    @Nonnull
    public <T extends ErpType<T>> TableRow<QueryT> field(String name, String dataType, T value) {
        return this.field(new Value<T>(this.table.getRowId(), name, dataType, value, null));
    }

    @Nonnull
    public <T> TableRow<QueryT> field(String name, String dataType, T value, ErpTypeConverter<T> typeConverter) {
        return this.field(new Value<T>(this.table.getRowId(), name, dataType, value, typeConverter));
    }

    @Nonnull
    public TableRow<QueryT> field(String name, String dataType, Boolean value) {
        return this.field(name, dataType, (Object)value, (ErpTypeConverter)BooleanConverter.INSTANCE);
    }

    @Nonnull
    public TableRow<QueryT> field(String name, String dataType, Byte value) {
        return this.field(name, dataType, (Object)value, (ErpTypeConverter)ByteConverter.INSTANCE);
    }

    @Nonnull
    public TableRow<QueryT> field(String name, String dataType, Character value) {
        return this.field(name, dataType, (Object)value, (ErpTypeConverter)CharacterConverter.INSTANCE);
    }

    @Nonnull
    public TableRow<QueryT> field(String name, String dataType, String value) {
        return this.field(name, dataType, value, null);
    }

    @Nonnull
    public TableRow<QueryT> field(String name, String dataType, Short value) {
        return this.field(name, dataType, (Object)value, (ErpTypeConverter)ShortConverter.INSTANCE);
    }

    @Nonnull
    public TableRow<QueryT> field(String name, String dataType, Integer value) {
        return this.field(name, dataType, (Object)value, (ErpTypeConverter)IntegerConverter.INSTANCE);
    }

    @Nonnull
    public TableRow<QueryT> field(String name, String dataType, Long value) {
        return this.field(name, dataType, (Object)value, (ErpTypeConverter)LongConverter.INSTANCE);
    }

    @Nonnull
    public TableRow<QueryT> field(String name, String dataType, Float value) {
        return this.field(name, dataType, (Object)value, (ErpTypeConverter)FloatConverter.INSTANCE);
    }

    @Nonnull
    public TableRow<QueryT> field(String name, String dataType, Double value) {
        return this.field(name, dataType, (Object)value, (ErpTypeConverter)DoubleConverter.INSTANCE);
    }

    @Nonnull
    public TableRow<QueryT> field(String name, String dataType, BigInteger value) {
        return this.field(name, dataType, (Object)value, (ErpTypeConverter)BigIntegerConverter.INSTANCE);
    }

    @Nonnull
    public TableRow<QueryT> field(String name, String dataType, BigDecimal value) {
        return this.field(name, dataType, (Object)value, (ErpTypeConverter)BigDecimalConverter.INSTANCE);
    }

    @Nonnull
    public TableRow<QueryT> field(String name, String dataType, Year value) {
        return this.field(name, dataType, (Object)value, (ErpTypeConverter)YearConverter.INSTANCE);
    }

    @Nonnull
    public TableRow<QueryT> field(String name, String dataType, LocalDate value) {
        return this.field(name, dataType, (Object)value, (ErpTypeConverter)LocalDateConverter.INSTANCE);
    }

    @Nonnull
    public TableRow<QueryT> field(String name, String dataType, LocalTime value) {
        return this.field(name, dataType, (Object)value, (ErpTypeConverter)LocalTimeConverter.INSTANCE);
    }

    @Nonnull
    public TableRow<QueryT> field(String name, String dataType, Locale value) {
        return this.field(name, dataType, (Object)value, (ErpTypeConverter)LocaleConverter.INSTANCE);
    }

    @Nonnull
    public TableRow<QueryT> fields(Fields other, Fields ... others) {
        for (Value<?> value : other.valueList) {
            this.field(this.copyValueWithoutRowId(value));
        }
        for (Fields fields : others) {
            for (Value<?> value : fields.valueList) {
                this.field(this.copyValueWithoutRowId(value));
            }
        }
        return this;
    }

    @Nonnull
    public TableRow<QueryT> row() {
        return this.table.row();
    }

    public QueryT end() {
        return this.table.end();
    }

    Table<QueryT> getTable() {
        return this.table;
    }

    int getFieldId() {
        return this.fieldId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableRow)) {
            return false;
        }
        TableRow other = (TableRow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Table<QueryT> this$table = this.getTable();
        Table<QueryT> other$table = other.getTable();
        if (this$table == null ? other$table != null : !((Object)this$table).equals(other$table)) {
            return false;
        }
        return this.getFieldId() == other.getFieldId();
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableRow;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Table<QueryT> $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : ((Object)$table).hashCode());
        result = result * 59 + this.getFieldId();
        return result;
    }

    public String toString() {
        return "TableRow(table=" + this.getTable() + ", fieldId=" + this.getFieldId() + ")";
    }
}

