/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.rfc;

import com.google.common.collect.Lists;
import com.sap.cloud.sdk.cloudplatform.connectivity.Header;
import com.sap.cloud.sdk.s4hana.connectivity.RequestMethod;
import com.sap.cloud.sdk.s4hana.connectivity.SerializedQuery;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbapToSoapNameConverter;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionQuery;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionQueryResult;
import java.util.LinkedList;
import java.util.List;

class SoapSerializedQueryBuilder<QueryT extends AbstractRemoteFunctionQuery<QueryT, QueryResultT>, QueryResultT extends AbstractRemoteFunctionQueryResult<QueryT, QueryResultT>> {
    private final QueryT query;
    private final String requestBody;
    private final AbapToSoapNameConverter nameConverter = new AbapToSoapNameConverter();

    private List<Header> getHeaders() {
        LinkedList headers = Lists.newLinkedList();
        headers.addAll(this.query.getCustomHttpHeaders());
        headers.add(new Header("Content-Type", "text/xml"));
        headers.add(new Header("SOAPAction", "urn:sap-com:document:sap:soap:functions:mc-style:_--37" + ((AbstractRemoteFunctionQuery)((Object)this.query)).getFunctionName() + ":" + this.nameConverter.abapFunctionNameToSoapMessageName(((AbstractRemoteFunctionQuery)((Object)this.query)).getFunctionName())));
        return headers;
    }

    SerializedQuery<QueryT> build() {
        return new SerializedQuery(this.query, RequestMethod.POST, "/sap/bc/srt/scs_ext/sap/" + this.nameConverter.abapFunctionNameToSoapServiceName(((AbstractRemoteFunctionQuery)((Object)this.query)).getFunctionName()), this.getHeaders(), this.requestBody);
    }

    public SoapSerializedQueryBuilder(QueryT query, String requestBody) {
        this.query = query;
        this.requestBody = requestBody;
    }

    public QueryT getQuery() {
        return this.query;
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    public AbapToSoapNameConverter getNameConverter() {
        return this.nameConverter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SoapSerializedQueryBuilder)) {
            return false;
        }
        SoapSerializedQueryBuilder other = (SoapSerializedQueryBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        QueryT this$query = this.getQuery();
        QueryT other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        String this$requestBody = this.getRequestBody();
        String other$requestBody = other.getRequestBody();
        if (this$requestBody == null ? other$requestBody != null : !this$requestBody.equals(other$requestBody)) {
            return false;
        }
        AbapToSoapNameConverter this$nameConverter = this.getNameConverter();
        AbapToSoapNameConverter other$nameConverter = other.getNameConverter();
        return !(this$nameConverter == null ? other$nameConverter != null : !this$nameConverter.equals(other$nameConverter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SoapSerializedQueryBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        QueryT $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        String $requestBody = this.getRequestBody();
        result = result * 59 + ($requestBody == null ? 43 : $requestBody.hashCode());
        AbapToSoapNameConverter $nameConverter = this.getNameConverter();
        result = result * 59 + ($nameConverter == null ? 43 : $nameConverter.hashCode());
        return result;
    }

    public String toString() {
        return "SoapSerializedQueryBuilder(query=" + this.getQuery() + ", requestBody=" + this.getRequestBody() + ", nameConverter=" + this.getNameConverter() + ")";
    }
}

