/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.rfc;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.json.JsonSanitizer;
import com.sap.cloud.sdk.result.ResultElement;
import com.sap.cloud.sdk.s4hana.connectivity.AbstractQuerySerializer;
import com.sap.cloud.sdk.s4hana.connectivity.ErpTypeSerializer;
import com.sap.cloud.sdk.s4hana.connectivity.SerializedQuery;
import com.sap.cloud.sdk.s4hana.connectivity.SerializedQueryResult;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbapToSoapNameConverter;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionQuery;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionQueryResult;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.MessageResultReader;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Parameter;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.RemoteFunctionGsonBuilder;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.SoapSerializedQueryBuilder;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Value;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.ValueType;
import com.sap.cloud.sdk.s4hana.serialization.ErpTypeConverter;
import com.sap.cloud.sdk.s4hana.serialization.LocalDateConverter;
import com.sap.cloud.sdk.s4hana.serialization.LocalTimeConverter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.json.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SoapRemoteFunctionQuerySerializer<QueryT extends AbstractRemoteFunctionQuery<QueryT, QueryResultT>, QueryResultT extends AbstractRemoteFunctionQueryResult<QueryT, QueryResultT>>
extends AbstractQuerySerializer<QueryT, QueryResultT> {
    private final Class<QueryResultT> resultType;
    private static final String SOAP_NAMESPACE_URI = "http://schemas.xmlsoap.org/soap/envelope/";
    private static final String FEATURE_EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    private static final String FEATURE_EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    private final ErpTypeSerializer erpTypeSerializer = new ErpTypeSerializer().withTypeConverters(new ErpTypeConverter[]{new LocalDateConverter("yyyy-MM-dd"), new LocalTimeConverter("HH:mm:ss")});

    private Document createNewSoapDocument() throws ParserConfigurationException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(true);
        docBuilderFactory.setExpandEntityReferences(false);
        docBuilderFactory.setFeature(FEATURE_EXTERNAL_GENERAL_ENTITIES, false);
        docBuilderFactory.setFeature(FEATURE_EXTERNAL_PARAMETER_ENTITIES, false);
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        return docBuilder.newDocument();
    }

    private Element createSoapServiceMessageElement(Document soapDocument, String functionName) {
        AbapToSoapNameConverter nameConverter = new AbapToSoapNameConverter();
        Element envelopeRootElement = this.createEnvelopeRootDocument(soapDocument);
        soapDocument.appendChild(envelopeRootElement);
        Element envelopeHeaderElement = this.createElementInSoapNamespace(soapDocument, "soapenv:Header");
        envelopeRootElement.appendChild(envelopeHeaderElement);
        Element envelopeBodyElement = this.createElementInSoapNamespace(soapDocument, "soapenv:Body");
        envelopeRootElement.appendChild(envelopeBodyElement);
        String functionNameInSoapFormat = nameConverter.abapFunctionNameToSoapMessageName(functionName);
        Element soapServiceMessageElement = soapDocument.createElement("urn:" + functionNameInSoapFormat);
        envelopeBodyElement.appendChild(soapServiceMessageElement);
        return soapServiceMessageElement;
    }

    private Element getParentElement(Document soapDocument, Parameter<?> parameter, Element currentParameterElement) {
        Element currentParent;
        if (parameter.getValueType() == ValueType.TABLE) {
            currentParent = soapDocument.createElement("item");
            currentParameterElement.appendChild(currentParent);
        } else {
            currentParent = currentParameterElement;
        }
        return currentParent;
    }

    private String serializeSoapEnvelopeWithoutXmlHeaderLine(Document soapDocument) throws TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance("com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl", null);
        tf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(soapDocument), new StreamResult(writer));
        return writer.toString();
    }

    private Element createEnvelopeRootDocument(Document doc) {
        Element envelopeRootElement = doc.createElementNS(SOAP_NAMESPACE_URI, "soapenv:Envelope");
        envelopeRootElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:urn", "urn:sap-com:document:sap:soap:functions:mc-style");
        return envelopeRootElement;
    }

    private Element createElementInSoapNamespace(Document soapDocument, String elementName) {
        return soapDocument.createElementNS(SOAP_NAMESPACE_URI, elementName);
    }

    protected List<AbstractRemoteFunctionQueryResult.Result> getReturnParameterResults(QueryResultT result) {
        LinkedHashSet<String> returnParameterNames = ((AbstractRemoteFunctionQuery)((Object)((AbstractRemoteFunctionQueryResult)result).getQuery())).getReturnParameterNames();
        ArrayList<AbstractRemoteFunctionQueryResult.Result> returnParameterResults = new ArrayList<AbstractRemoteFunctionQueryResult.Result>();
        ArrayList<AbstractRemoteFunctionQueryResult.Result> resultList = ((AbstractRemoteFunctionQueryResult)result).getResultList();
        if (resultList != null) {
            for (AbstractRemoteFunctionQueryResult.Result resultItem : resultList) {
                if (!returnParameterNames.contains(resultItem.getName())) continue;
                returnParameterResults.add(resultItem);
            }
        }
        return returnParameterResults;
    }

    @Nonnull
    protected SerializedQuery<QueryT> serializeQuery(@Nonnull QueryT query) throws ParserConfigurationException, TransformerException {
        AbapToSoapNameConverter nameConverter = new AbapToSoapNameConverter();
        Document soapDocument = this.createNewSoapDocument();
        Element soapServiceMessageElement = this.createSoapServiceMessageElement(soapDocument, ((AbstractRemoteFunctionQuery)((Object)query)).getFunctionName());
        for (Map.Entry<String, Parameter<?>> entry : ((AbstractRemoteFunctionQuery)((Object)query)).getParametersByName().entrySet()) {
            String currentParameterNameInSoapNamePattern = nameConverter.abapParameterNameToSoapParameterName(entry.getKey());
            Element currentParameterElement = soapDocument.createElement(currentParameterNameInSoapNamePattern);
            soapServiceMessageElement.appendChild(currentParameterElement);
            Parameter<?> currentParameter = entry.getValue();
            if (currentParameter.getValueList() == null) {
                currentParameterElement.setTextContent((String)this.erpTypeSerializer.toErp(currentParameter.getValue()).orNull());
                continue;
            }
            int previousRowId = -1;
            Element currentParent = null;
            for (Value<?> currentValue : currentParameter.getValueList()) {
                if (previousRowId < currentValue.getRowId()) {
                    previousRowId = currentValue.getRowId();
                    currentParent = this.getParentElement(soapDocument, currentParameter, currentParameterElement);
                }
                String fieldNameInSoapNamePattern = nameConverter.abapParameterNameToSoapParameterName(currentValue.getName());
                Element valueListElement = soapDocument.createElement(fieldNameInSoapNamePattern);
                String textContent = (String)this.erpTypeSerializer.toErp(currentValue.getValue()).orNull();
                valueListElement.setTextContent(textContent);
                if (currentParent == null) continue;
                currentParent.appendChild(valueListElement);
            }
        }
        return new SoapSerializedQueryBuilder(query, this.serializeSoapEnvelopeWithoutXmlHeaderLine(soapDocument)).build();
    }

    private JsonElement unpackNestedArrays(JsonElement jsonElement) {
        if (jsonElement.isJsonObject()) {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            JsonElement nestedArray = jsonObject.get("item");
            if (nestedArray == null) {
                JsonObject rewrittenObject = new JsonObject();
                for (Map.Entry entry : jsonObject.entrySet()) {
                    JsonElement attribute = (JsonElement)entry.getValue();
                    JsonElement unpacked = this.unpackNestedArrays(attribute);
                    rewrittenObject.add(new AbapToSoapNameConverter().soapParameterNameToAbapParameterName((String)entry.getKey()), unpacked);
                }
                return rewrittenObject;
            }
            if (nestedArray.isJsonArray()) {
                return this.unpackNestedArrays((JsonElement)nestedArray.getAsJsonArray());
            }
            if (nestedArray.isJsonObject()) {
                JsonArray jsonArray = new JsonArray();
                jsonArray.add(this.unpackNestedArrays(nestedArray));
                return jsonArray;
            }
        }
        if (jsonElement.isJsonArray()) {
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonElement elementInArray = jsonArray.get(i);
                JsonElement unpacked = this.unpackNestedArrays(elementInArray);
                if (unpacked == elementInArray) continue;
                jsonArray.set(i, unpacked);
            }
        }
        return jsonElement;
    }

    @Nonnull
    protected QueryResultT deserializeQueryResult(@Nonnull SerializedQueryResult<QueryT> serializedQueryResult) throws ParserConfigurationException {
        AbstractRemoteFunctionQuery query = (AbstractRemoteFunctionQuery)serializedQueryResult.getQuery();
        JsonElement bodyAsJson = new JsonParser().parse(JsonSanitizer.sanitize((String)XML.toJSONObject((String)serializedQueryResult.getBody(), (boolean)true).toString()));
        String resultSoapElementName = "n0:" + new AbapToSoapNameConverter().abapFunctionNameToSoapMessageName(query.getFunctionName()) + "Response";
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setExpandEntityReferences(false);
        factory.setValidating(true);
        factory.setFeature(FEATURE_EXTERNAL_GENERAL_ENTITIES, false);
        factory.setFeature(FEATURE_EXTERNAL_PARAMETER_ENTITIES, false);
        JsonElement json = this.unpackNestedArrays(bodyAsJson.getAsJsonObject().get("soap-env:Envelope").getAsJsonObject().get("soap-env:Body").getAsJsonObject().get(resultSoapElementName));
        JsonObject resultObj = new JsonObject();
        JsonArray array = new JsonArray();
        resultObj.add("RESULT", (JsonElement)array);
        for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
            if ("XMLNS:N0".equals(entry.getKey())) continue;
            String parameterName = (String)entry.getKey();
            JsonElement parameterValue = (JsonElement)entry.getValue();
            JsonObject obj = new JsonObject();
            obj.addProperty("NAME", parameterName);
            obj.add("VALUE", parameterValue);
            array.add((JsonElement)obj);
        }
        ArrayList typeConverters = Lists.newArrayList(query.getTypeConverters());
        typeConverters.add(new LocalDateConverter("yyyy-MM-dd"));
        typeConverters.add(new LocalTimeConverter("HH:mm:ss"));
        GsonBuilder gsonBuilder = RemoteFunctionGsonBuilder.newSoapQueryResultGsonBuilder(typeConverters);
        AbstractRemoteFunctionQueryResult result = (AbstractRemoteFunctionQueryResult)gsonBuilder.create().fromJson((JsonElement)resultObj, this.resultType);
        result.setQuery(query);
        AbstractRemoteFunctionQueryResult.ExceptionResult exceptionResult = result.getException();
        if (exceptionResult != null) {
            MessageResultReader.addMessageToResult(result, exceptionResult);
        }
        for (AbstractRemoteFunctionQueryResult.Result returnParameterResult : this.getReturnParameterResults(result)) {
            ResultElement resultElement = returnParameterResult.getValue();
            ArrayList<ResultElement> elements = new ArrayList<ResultElement>();
            if (resultElement.isResultCollection()) {
                Iterables.addAll(elements, (Iterable)resultElement.getAsCollection());
            } else {
                elements.add(resultElement);
            }
            for (ResultElement element : elements) {
                if (!element.isResultObject()) continue;
                MessageResultReader.addMessageToResult(result, (AbstractRemoteFunctionQueryResult.MessageResult)element.getAsObject().as(AbstractRemoteFunctionQueryResult.MessageResult.class));
            }
        }
        return (QueryResultT)result;
    }

    public SoapRemoteFunctionQuerySerializer(Class<QueryResultT> resultType) {
        this.resultType = resultType;
    }
}

