/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.rfc;

import com.google.common.collect.Sets;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationNotFoundException;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.s4hana.connectivity.ErpConfigContext;
import com.sap.cloud.sdk.s4hana.connectivity.exception.QueryExecutionException;
import com.sap.cloud.sdk.s4hana.connectivity.exception.QuerySerializationException;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionQuery;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.BapiQuery;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.CommitStrategy;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Fields;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.ParameterFields;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.ParameterType;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.RemoteFunctionQueryErrorHandler;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.RemoteFunctionQueryExecutor;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.RfcQueryResult;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.RfcTransactionFactory;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Table;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.ValueType;
import com.sap.cloud.sdk.s4hana.serialization.BigDecimalConverter;
import com.sap.cloud.sdk.s4hana.serialization.BigIntegerConverter;
import com.sap.cloud.sdk.s4hana.serialization.BooleanConverter;
import com.sap.cloud.sdk.s4hana.serialization.ByteConverter;
import com.sap.cloud.sdk.s4hana.serialization.CharacterConverter;
import com.sap.cloud.sdk.s4hana.serialization.DoubleConverter;
import com.sap.cloud.sdk.s4hana.serialization.ErpType;
import com.sap.cloud.sdk.s4hana.serialization.ErpTypeConverter;
import com.sap.cloud.sdk.s4hana.serialization.FloatConverter;
import com.sap.cloud.sdk.s4hana.serialization.IntegerConverter;
import com.sap.cloud.sdk.s4hana.serialization.LocalDateConverter;
import com.sap.cloud.sdk.s4hana.serialization.LocalTimeConverter;
import com.sap.cloud.sdk.s4hana.serialization.LocaleConverter;
import com.sap.cloud.sdk.s4hana.serialization.LongConverter;
import com.sap.cloud.sdk.s4hana.serialization.ShortConverter;
import com.sap.cloud.sdk.s4hana.serialization.YearConverter;
import com.sap.cloud.sdk.s4hana.types.Year;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;

public class RfcQuery
extends AbstractRemoteFunctionQuery<RfcQuery, RfcQueryResult> {
    private static final Logger logger = CloudLoggerFactory.getLogger(RfcQuery.class);
    private final Set<String> exceptionNames = Sets.newHashSet();
    private RfcTransactionFactory transactionFactory = new RfcTransactionFactory();

    @Nonnull
    public RfcQueryResult execute(@Nonnull ErpConfigContext configContext) throws QuerySerializationException, QueryExecutionException, DestinationNotFoundException, DestinationAccessException {
        return new RemoteFunctionQueryExecutor<RfcQuery, RfcQueryResult>(this.transactionFactory).execute(configContext, this);
    }

    @Override
    @Nonnull
    protected RfcQuery instance() {
        return this;
    }

    public RfcQuery(String functionName) throws IllegalArgumentException {
        super(functionName, CommitStrategy.COMMIT_SYNC, Thread.currentThread().getStackTrace()[3].toString());
        this.assertFunctionIsNotBapi(functionName);
    }

    public RfcQuery(String functionName, boolean commit) throws IllegalArgumentException {
        super(functionName, commit ? CommitStrategy.COMMIT_SYNC : CommitStrategy.NO_COMMIT, Thread.currentThread().getStackTrace()[3].toString());
        this.assertFunctionIsNotBapi(functionName);
    }

    public RfcQuery(String functionName, @Nonnull CommitStrategy commitStrategy) throws IllegalArgumentException {
        super(functionName, commitStrategy, Thread.currentThread().getStackTrace()[3].toString());
        this.assertFunctionIsNotBapi(functionName);
    }

    private void assertFunctionIsNotBapi(String functionName) throws IllegalArgumentException {
        if (functionName.toLowerCase(Locale.ENGLISH).startsWith("bapi")) {
            throw new IllegalArgumentException("The given function '" + functionName + "' refers to a BAPI. For calling BAPIs, use " + BapiQuery.class.getSimpleName() + " instead.");
        }
    }

    @Nonnull
    public RfcQuery withTypeConverters(Iterable<ErpTypeConverter<?>> typeConverters) {
        return (RfcQuery)super.withTypeConverters(typeConverters);
    }

    @Nonnull
    public RfcQuery withTypeConverters(ErpTypeConverter<?> ... typeConverters) {
        return (RfcQuery)super.withTypeConverters(typeConverters);
    }

    @Nonnull
    public RfcQuery withExporting(String name, String dataType) {
        return (RfcQuery)super.withExporting(name, dataType);
    }

    @Nonnull
    public <T extends ErpType<T>> RfcQuery withExporting(String name, String dataType, T value) {
        return (RfcQuery)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public <T> RfcQuery withExporting(String name, String dataType, T value, ErpTypeConverter<T> typeConverter) {
        return (RfcQuery)super.withExporting(name, dataType, value, typeConverter);
    }

    @Nonnull
    public RfcQuery withExporting(String name, String dataType, Boolean value) {
        return (RfcQuery)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public RfcQuery withExporting(String name, String dataType, Byte value) {
        return (RfcQuery)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public RfcQuery withExporting(String name, String dataType, Character value) {
        return (RfcQuery)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public RfcQuery withExporting(String name, String dataType, String value) {
        return (RfcQuery)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public RfcQuery withExporting(String name, String dataType, Short value) {
        return (RfcQuery)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public RfcQuery withExporting(String name, String dataType, Integer value) {
        return (RfcQuery)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public RfcQuery withExporting(String name, String dataType, Long value) {
        return (RfcQuery)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public RfcQuery withExporting(String name, String dataType, Float value) {
        return (RfcQuery)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public RfcQuery withExporting(String name, String dataType, Double value) {
        return (RfcQuery)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public RfcQuery withExporting(String name, String dataType, BigInteger value) {
        return (RfcQuery)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public RfcQuery withExporting(String name, String dataType, BigDecimal value) {
        return (RfcQuery)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public RfcQuery withExporting(String name, String dataType, Locale value) {
        return (RfcQuery)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public RfcQuery withExporting(String name, String dataType, Year value) {
        return (RfcQuery)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public RfcQuery withExporting(String name, String dataType, LocalDate value) {
        return (RfcQuery)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public RfcQuery withExporting(String name, String dataType, LocalTime value) {
        return (RfcQuery)super.withExporting(name, dataType, value);
    }

    @Override
    @Nonnull
    public ParameterFields<RfcQuery> withExportingFields(String name, String dataType) {
        return super.withExportingFields(name, dataType);
    }

    @Nonnull
    public RfcQuery withExportingFields(String name, String dataType, Fields fields) {
        return (RfcQuery)super.withExportingFields(name, dataType, fields);
    }

    @Override
    @Nonnull
    public Table<RfcQuery> withExportingTable(String name, String dataType) {
        return super.withExportingTable(name, dataType);
    }

    @Nonnull
    public RfcQuery withImporting(String name, String dataType) {
        return (RfcQuery)super.withImporting(name, dataType);
    }

    @Nonnull
    public <T extends ErpType<T>> RfcQuery withImporting(String name, String dataType, T value) {
        return (RfcQuery)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public <T> RfcQuery withImporting(String name, String dataType, T value, ErpTypeConverter<T> typeConverter) {
        return (RfcQuery)super.withImporting(name, dataType, value, typeConverter);
    }

    @Nonnull
    public RfcQuery withImporting(String name, String dataType, Boolean value) {
        return (RfcQuery)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public RfcQuery withImporting(String name, String dataType, Byte value) {
        return (RfcQuery)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public RfcQuery withImporting(String name, String dataType, Character value) {
        return (RfcQuery)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public RfcQuery withImporting(String name, String dataType, String value) {
        return (RfcQuery)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public RfcQuery withImporting(String name, String dataType, Short value) {
        return (RfcQuery)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public RfcQuery withImporting(String name, String dataType, Integer value) {
        return (RfcQuery)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public RfcQuery withImporting(String name, String dataType, Long value) {
        return (RfcQuery)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public RfcQuery withImporting(String name, String dataType, Float value) {
        return (RfcQuery)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public RfcQuery withImporting(String name, String dataType, Double value) {
        return (RfcQuery)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public RfcQuery withImporting(String name, String dataType, BigInteger value) {
        return (RfcQuery)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public RfcQuery withImporting(String name, String dataType, BigDecimal value) {
        return (RfcQuery)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public RfcQuery withImporting(String name, String dataType, Locale value) {
        return (RfcQuery)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public RfcQuery withImporting(String name, String dataType, Year value) {
        return (RfcQuery)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public RfcQuery withImporting(String name, String dataType, LocalDate value) {
        return (RfcQuery)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public RfcQuery withImporting(String name, String dataType, LocalTime value) {
        return (RfcQuery)super.withImporting(name, dataType, value);
    }

    @Override
    @Nonnull
    public ParameterFields<RfcQuery> withImportingFields(String name, String dataType) {
        return super.withImportingFields(name, dataType);
    }

    @Nonnull
    public RfcQuery withImportingFields(String name, String dataType, Fields fields) {
        return (RfcQuery)super.withImportingFields(name, dataType, fields);
    }

    @Override
    @Nonnull
    public Table<RfcQuery> withImportingTable(String name, String dataType) {
        return super.withImportingTable(name, dataType);
    }

    @Nonnull
    public RfcQuery withImportingAsReturn(String dataType) {
        return (RfcQuery)super.withImportingAsReturn(dataType);
    }

    @Nonnull
    public RfcQuery withImportingAsReturn(String name, String dataType) {
        return (RfcQuery)super.withImportingAsReturn(name, dataType);
    }

    @Override
    @Nonnull
    public Table<RfcQuery> withTable(String name, String dataType) {
        return super.withTable(name, dataType);
    }

    @Nonnull
    public RfcQuery withTableAsReturn(String dataType) {
        return (RfcQuery)super.withTableAsReturn(dataType);
    }

    @Nonnull
    public RfcQuery withTableAsReturn(String name, String dataType) {
        return (RfcQuery)super.withTableAsReturn(name, dataType);
    }

    @Nonnull
    public RfcQuery withChanging(String name, String dataType) {
        this.newParameter(name, dataType, ParameterType.CHANGING, ValueType.FIELD);
        return this;
    }

    @Nonnull
    public <T extends ErpType<T>> RfcQuery withChanging(String name, String dataType, T value) {
        this.newParameterWithValue(name, dataType, ParameterType.CHANGING, ValueType.FIELD, value, null);
        return this;
    }

    @Nonnull
    public <T> RfcQuery withChanging(String name, String dataType, T value, ErpTypeConverter<T> typeConverter) {
        this.newParameterWithValue(name, dataType, ParameterType.CHANGING, ValueType.FIELD, value, typeConverter);
        return this;
    }

    @Nonnull
    public RfcQuery withChanging(String name, String dataType, Boolean value) {
        return this.withChanging(name, dataType, (Object)value, (ErpTypeConverter)BooleanConverter.INSTANCE);
    }

    @Nonnull
    public RfcQuery withChanging(String name, String dataType, Byte value) {
        return this.withChanging(name, dataType, (Object)value, (ErpTypeConverter)ByteConverter.INSTANCE);
    }

    @Nonnull
    public RfcQuery withChanging(String name, String dataType, Character value) {
        return this.withChanging(name, dataType, (Object)value, (ErpTypeConverter)CharacterConverter.INSTANCE);
    }

    @Nonnull
    public RfcQuery withChanging(String name, String dataType, String value) {
        return this.withChanging(name, dataType, value, null);
    }

    @Nonnull
    public RfcQuery withChanging(String name, String dataType, Short value) {
        return this.withChanging(name, dataType, (Object)value, (ErpTypeConverter)ShortConverter.INSTANCE);
    }

    @Nonnull
    public RfcQuery withChanging(String name, String dataType, Integer value) {
        return this.withChanging(name, dataType, (Object)value, (ErpTypeConverter)IntegerConverter.INSTANCE);
    }

    @Nonnull
    public RfcQuery withChanging(String name, String dataType, Long value) {
        return this.withChanging(name, dataType, (Object)value, (ErpTypeConverter)LongConverter.INSTANCE);
    }

    @Nonnull
    public RfcQuery withChanging(String name, String dataType, Float value) {
        return this.withChanging(name, dataType, (Object)value, (ErpTypeConverter)FloatConverter.INSTANCE);
    }

    @Nonnull
    public RfcQuery withChanging(String name, String dataType, Double value) {
        return this.withChanging(name, dataType, (Object)value, (ErpTypeConverter)DoubleConverter.INSTANCE);
    }

    @Nonnull
    public RfcQuery withChanging(String name, String dataType, BigInteger value) {
        return this.withChanging(name, dataType, (Object)value, (ErpTypeConverter)BigIntegerConverter.INSTANCE);
    }

    @Nonnull
    public RfcQuery withChanging(String name, String dataType, BigDecimal value) {
        return this.withChanging(name, dataType, (Object)value, (ErpTypeConverter)BigDecimalConverter.INSTANCE);
    }

    @Nonnull
    public RfcQuery withChanging(String name, String dataType, Locale value) {
        return this.withChanging(name, dataType, (Object)value, (ErpTypeConverter)LocaleConverter.INSTANCE);
    }

    @Nonnull
    public RfcQuery withChanging(String name, String dataType, Year value) {
        return this.withChanging(name, dataType, (Object)value, (ErpTypeConverter)YearConverter.INSTANCE);
    }

    @Nonnull
    public RfcQuery withChanging(String name, String dataType, LocalDate value) {
        return this.withChanging(name, dataType, (Object)value, (ErpTypeConverter)LocalDateConverter.INSTANCE);
    }

    @Nonnull
    public RfcQuery withChanging(String name, String dataType, LocalTime value) {
        return this.withChanging(name, dataType, (Object)value, (ErpTypeConverter)LocalTimeConverter.INSTANCE);
    }

    @Nonnull
    public ParameterFields<RfcQuery> withChangingFields(String name, String dataType) {
        return new ParameterFields<RfcQuery>(this.instance(), this.newParameterWithValueList(name, dataType, ParameterType.CHANGING, ValueType.STRUCTURE));
    }

    @Nonnull
    public RfcQuery withChangingFields(String name, String dataType, Fields fields) {
        return this.withChangingFields(name, dataType).fields(fields, new Fields[0]).end();
    }

    @Nonnull
    public Table<RfcQuery> withChangingTable(String name, String dataType) {
        return new Table<RfcQuery>(this.instance(), this.newParameterWithValueList(name, dataType, ParameterType.CHANGING, ValueType.TABLE));
    }

    @Nonnull
    public RfcQuery withException(String name) {
        this.exceptionNames.add(name);
        return this;
    }

    @Nonnull
    public RfcQuery withErrorHandler(@Nonnull RemoteFunctionQueryErrorHandler remoteFunctionQueryErrorHandler) {
        return (RfcQuery)super.withErrorHandler(remoteFunctionQueryErrorHandler);
    }

    @Nonnull
    public RfcQuery ignoringErrors() {
        return (RfcQuery)super.ignoringErrors();
    }

    @Nonnull
    public RfcQuery propagatingErrorsAsExceptions() {
        return (RfcQuery)super.propagatingErrorsAsExceptions();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RfcQuery)) {
            return false;
        }
        RfcQuery other = (RfcQuery)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Set<String> this$exceptionNames = this.getExceptionNames();
        Set<String> other$exceptionNames = other.getExceptionNames();
        if (this$exceptionNames == null ? other$exceptionNames != null : !((Object)this$exceptionNames).equals(other$exceptionNames)) {
            return false;
        }
        RfcTransactionFactory this$transactionFactory = this.getTransactionFactory();
        RfcTransactionFactory other$transactionFactory = other.getTransactionFactory();
        return !(this$transactionFactory == null ? other$transactionFactory != null : !this$transactionFactory.equals(other$transactionFactory));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RfcQuery;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Set<String> $exceptionNames = this.getExceptionNames();
        result = result * 59 + ($exceptionNames == null ? 43 : ((Object)$exceptionNames).hashCode());
        RfcTransactionFactory $transactionFactory = this.getTransactionFactory();
        result = result * 59 + ($transactionFactory == null ? 43 : $transactionFactory.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "RfcQuery(super=" + super.toString() + ", exceptionNames=" + this.getExceptionNames() + ", transactionFactory=" + this.getTransactionFactory() + ")";
    }

    public Set<String> getExceptionNames() {
        return this.exceptionNames;
    }

    public RfcTransactionFactory getTransactionFactory() {
        return this.transactionFactory;
    }

    void setTransactionFactory(RfcTransactionFactory transactionFactory) {
        this.transactionFactory = transactionFactory;
    }
}

