/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.rfc;

import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.s4hana.connectivity.ErpConfigContext;
import com.sap.cloud.sdk.s4hana.connectivity.QueryExecutor;
import com.sap.cloud.sdk.s4hana.connectivity.exception.QueryExecutionException;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionQuery;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionQueryResult;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractTransactionFactory;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Transaction;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.exception.RemoteFunctionException;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.slf4j.Logger;

public class RemoteFunctionQueryExecutor<QueryT extends AbstractRemoteFunctionQuery<QueryT, QueryResultT>, QueryResultT extends AbstractRemoteFunctionQueryResult<QueryT, QueryResultT>>
implements QueryExecutor<QueryT, QueryResultT> {
    private static final Logger logger = CloudLoggerFactory.getLogger(RemoteFunctionQueryExecutor.class);
    private final AbstractTransactionFactory<QueryT, QueryResultT> transactionFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public QueryResultT execute(@Nonnull ErpConfigContext configContext, @Nonnull QueryT query) throws QueryExecutionException {
        Transaction<QueryT, QueryResultT> transactionLogic = this.transactionFactory.createTransaction(configContext);
        transactionLogic.before(configContext, query);
        try {
            QueryResultT queryResult = transactionLogic.execute(configContext, query);
            if (((AbstractRemoteFunctionQueryResult)queryResult).hasFailed()) {
                this.handleFailedQueryResult(configContext, query, transactionLogic, queryResult);
            } else {
                this.handleSuccessfulQueryResult(configContext, query, transactionLogic);
            }
            QueryResultT QueryResultT = queryResult;
            return QueryResultT;
        }
        finally {
            transactionLogic.after();
        }
    }

    private void handleSuccessfulQueryResult(@Nonnull ErpConfigContext configContext, @Nonnull QueryT query, @Nonnull Transaction<QueryT, QueryResultT> transactionLogic) throws QueryExecutionException {
        if (((AbstractRemoteFunctionQuery)((Object)query)).isPerformingTransactionalCommit()) {
            try {
                transactionLogic.commit(configContext, query);
            }
            catch (QueryExecutionException e) {
                transactionLogic.rollback(configContext, query);
                throw e;
            }
        }
    }

    private void handleFailedQueryResult(@Nonnull ErpConfigContext configContext, @Nonnull QueryT query, @Nonnull Transaction<QueryT, QueryResultT> transactionLogic, @Nonnull QueryResultT queryResult) throws QueryExecutionException {
        Optional<RemoteFunctionException> exception = ((AbstractRemoteFunctionQuery)((Object)query)).getRemoteFunctionQueryErrorHandler().handleQueryResult(queryResult);
        if (exception.isPresent()) {
            if (logger.isDebugEnabled()) {
                logger.debug(query.getClass().getSimpleName() + " failed. Triggering rollback for query: " + query + ".", exception);
            }
            if (((AbstractRemoteFunctionQuery)((Object)query)).isPerformingTransactionalCommit()) {
                transactionLogic.rollback(configContext, query);
            }
            throw exception.get();
        }
    }

    public RemoteFunctionQueryExecutor(AbstractTransactionFactory<QueryT, QueryResultT> transactionFactory) {
        this.transactionFactory = transactionFactory;
    }
}

