/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.rfc;

import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionQuery;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Fields;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Value;
import com.sap.cloud.sdk.s4hana.serialization.BigDecimalConverter;
import com.sap.cloud.sdk.s4hana.serialization.BigIntegerConverter;
import com.sap.cloud.sdk.s4hana.serialization.BooleanConverter;
import com.sap.cloud.sdk.s4hana.serialization.ByteConverter;
import com.sap.cloud.sdk.s4hana.serialization.CharacterConverter;
import com.sap.cloud.sdk.s4hana.serialization.DoubleConverter;
import com.sap.cloud.sdk.s4hana.serialization.ErpType;
import com.sap.cloud.sdk.s4hana.serialization.ErpTypeConverter;
import com.sap.cloud.sdk.s4hana.serialization.FloatConverter;
import com.sap.cloud.sdk.s4hana.serialization.IntegerConverter;
import com.sap.cloud.sdk.s4hana.serialization.LocalDateConverter;
import com.sap.cloud.sdk.s4hana.serialization.LocalTimeConverter;
import com.sap.cloud.sdk.s4hana.serialization.LocaleConverter;
import com.sap.cloud.sdk.s4hana.serialization.LongConverter;
import com.sap.cloud.sdk.s4hana.serialization.ShortConverter;
import com.sap.cloud.sdk.s4hana.serialization.YearConverter;
import com.sap.cloud.sdk.s4hana.types.Year;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ParameterFields<QueryT extends AbstractRemoteFunctionQuery<QueryT, ?>> {
    @Nonnull
    private final QueryT query;
    @Nonnull
    private final ArrayList<Value<?>> valueList;

    ParameterFields(@Nonnull QueryT query, @Nonnull ArrayList<Value<?>> valueList) {
        this.query = query;
        this.valueList = valueList;
    }

    public int size() {
        return this.valueList.size();
    }

    public boolean isEmpty() {
        return this.valueList.isEmpty();
    }

    @Nonnull
    private <T> ParameterFields<QueryT> field(@Nonnull Value<T> value) {
        this.valueList.add(new Value<T>(1, value.getName(), value.getDataType(), value.getValue(), value.getTypeConverter()));
        return this;
    }

    @Nonnull
    public <T extends ErpType<T>> ParameterFields<QueryT> field(String name, String dataType, T value) {
        return this.field(new Value<T>(1, name, dataType, value, null));
    }

    @Nonnull
    public <T> ParameterFields<QueryT> field(String name, String dataType, T value, @Nullable ErpTypeConverter<T> typeConverter) {
        return this.field(new Value<T>(1, name, dataType, value, typeConverter));
    }

    @Nonnull
    public ParameterFields<QueryT> field(String name, String dataType, Boolean value) {
        return this.field(name, dataType, (Object)value, (ErpTypeConverter)BooleanConverter.INSTANCE);
    }

    @Nonnull
    public ParameterFields<QueryT> field(String name, String dataType, Byte value) {
        return this.field(name, dataType, (Object)value, (ErpTypeConverter)ByteConverter.INSTANCE);
    }

    @Nonnull
    public ParameterFields<QueryT> field(String name, String dataType, Character value) {
        return this.field(name, dataType, (Object)value, (ErpTypeConverter)CharacterConverter.INSTANCE);
    }

    @Nonnull
    public ParameterFields<QueryT> field(String name, String dataType, String value) {
        return this.field(name, dataType, value, null);
    }

    @Nonnull
    public ParameterFields<QueryT> field(String name, String dataType, Short value) {
        return this.field(name, dataType, (Object)value, (ErpTypeConverter)ShortConverter.INSTANCE);
    }

    @Nonnull
    public ParameterFields<QueryT> field(String name, String dataType, Integer value) {
        return this.field(name, dataType, (Object)value, (ErpTypeConverter)IntegerConverter.INSTANCE);
    }

    @Nonnull
    public ParameterFields<QueryT> field(String name, String dataType, Long value) {
        return this.field(name, dataType, (Object)value, (ErpTypeConverter)LongConverter.INSTANCE);
    }

    @Nonnull
    public ParameterFields<QueryT> field(String name, String dataType, Float value) {
        return this.field(name, dataType, (Object)value, (ErpTypeConverter)FloatConverter.INSTANCE);
    }

    @Nonnull
    public ParameterFields<QueryT> field(String name, String dataType, Double value) {
        return this.field(name, dataType, (Object)value, (ErpTypeConverter)DoubleConverter.INSTANCE);
    }

    @Nonnull
    public ParameterFields<QueryT> field(String name, String dataType, BigInteger value) {
        return this.field(name, dataType, (Object)value, (ErpTypeConverter)BigIntegerConverter.INSTANCE);
    }

    @Nonnull
    public ParameterFields<QueryT> field(String name, String dataType, BigDecimal value) {
        return this.field(name, dataType, (Object)value, (ErpTypeConverter)BigDecimalConverter.INSTANCE);
    }

    @Nonnull
    public ParameterFields<QueryT> field(String name, String dataType, Year value) {
        return this.field(name, dataType, (Object)value, (ErpTypeConverter)YearConverter.INSTANCE);
    }

    @Nonnull
    public ParameterFields<QueryT> field(String name, String dataType, LocalDate value) {
        return this.field(name, dataType, (Object)value, (ErpTypeConverter)LocalDateConverter.INSTANCE);
    }

    @Nonnull
    public ParameterFields<QueryT> field(String name, String dataType, LocalTime value) {
        return this.field(name, dataType, (Object)value, (ErpTypeConverter)LocalTimeConverter.INSTANCE);
    }

    @Nonnull
    public ParameterFields<QueryT> field(String name, String dataType, Locale value) {
        return this.field(name, dataType, (Object)value, (ErpTypeConverter)LocaleConverter.INSTANCE);
    }

    @Nonnull
    public ParameterFields<QueryT> fields(@Nonnull Fields other, Fields ... others) {
        for (Value<?> value : other.valueList) {
            this.field(value);
        }
        for (Fields fields : others) {
            for (Value<?> value : fields.valueList) {
                this.field(value);
            }
        }
        return this;
    }

    @Nonnull
    public QueryT end() {
        return this.query;
    }

    @Nonnull
    QueryT getQuery() {
        return this.query;
    }

    @Nonnull
    ArrayList<Value<?>> getValueList() {
        return this.valueList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParameterFields)) {
            return false;
        }
        ParameterFields other = (ParameterFields)o;
        if (!other.canEqual(this)) {
            return false;
        }
        QueryT this$query = this.getQuery();
        QueryT other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        ArrayList<Value<?>> this$valueList = this.getValueList();
        ArrayList<Value<?>> other$valueList = other.getValueList();
        return !(this$valueList == null ? other$valueList != null : !((Object)this$valueList).equals(other$valueList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ParameterFields;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        QueryT $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        ArrayList<Value<?>> $valueList = this.getValueList();
        result = result * 59 + ($valueList == null ? 43 : ((Object)$valueList).hashCode());
        return result;
    }

    public String toString() {
        return "ParameterFields(query=" + this.getQuery() + ", valueList=" + this.getValueList() + ")";
    }
}

