/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.rfc;

import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionQueryResult;
import com.sap.cloud.sdk.s4hana.serialization.RemoteFunctionMessage;
import org.slf4j.Logger;

class MessageResultReader {
    private static final Logger logger = CloudLoggerFactory.getLogger(MessageResultReader.class);

    MessageResultReader() {
    }

    static <QueryResultT extends AbstractRemoteFunctionQueryResult<?, QueryResultT>> void addMessageToResult(QueryResultT result, AbstractRemoteFunctionQueryResult.MessageResult messageResult) {
        if (messageResult.getMessageType() == null) {
            if (logger.isWarnEnabled()) {
                logger.warn("Ignoring remote function message with unknown type: " + messageResult + ".");
            }
            return;
        }
        RemoteFunctionMessage message = new RemoteFunctionMessage(messageResult.getMessageType(), messageResult.getMessageClass(), messageResult.getMessageNumber(), messageResult.getMessageText());
        switch (messageResult.getMessageType()) {
            case SUCCESS: {
                result.addSuccessMessage(message);
                break;
            }
            case INFORMATION: {
                result.addInformationMessage(message);
                break;
            }
            case WARNING: {
                result.addWarningMessage(message);
                break;
            }
            case ERROR: 
            case ABORT: 
            case EXIT: {
                result.addErrorMessage(message);
                break;
            }
        }
    }
}

