/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.rfc;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.cloudplatform.util.FacadeLocator;
import com.sap.cloud.sdk.result.GsonResultElementFactory;
import com.sap.cloud.sdk.result.ResultElement;
import com.sap.cloud.sdk.s4hana.connectivity.ErpConfigContext;
import com.sap.cloud.sdk.s4hana.connectivity.ErpEndpointMonitor;
import com.sap.cloud.sdk.s4hana.connectivity.ErpTypeSerializer;
import com.sap.cloud.sdk.s4hana.connectivity.exception.QueryExecutionException;
import com.sap.cloud.sdk.s4hana.connectivity.exception.QuerySerializationException;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionQuery;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionQueryResult;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.JCoClientPassportManagerProvider;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.JCoErpNoopConverter;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.JCoFieldToResultReader;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.MessageResultReader;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Parameter;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.ParameterType;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.RemoteFunctionGsonBuilder;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Transaction;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Value;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.ValueType;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.exception.RemoteFunctionCommitFailedException;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.exception.RemoteFunctionException;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.exception.RemoteFunctionRollbackFailedException;
import com.sap.cloud.sdk.s4hana.serialization.ErpBoolean;
import com.sap.cloud.sdk.s4hana.serialization.LocalDateConverter;
import com.sap.cloud.sdk.s4hana.serialization.LocalTimeConverter;
import com.sap.cloud.sdk.s4hana.serialization.MessageType;
import com.sap.conn.jco.AbapException;
import com.sap.conn.jco.JCoContext;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoDestinationManager;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoField;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoParameterList;
import com.sap.conn.jco.JCoRepository;
import com.sap.conn.jco.JCoStructure;
import com.sap.conn.jco.JCoTable;
import com.sap.conn.jco.ext.ClientPassportManager;
import com.sap.conn.jco.ext.Environment;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.slf4j.Logger;

public class JCoTransaction<QueryT extends AbstractRemoteFunctionQuery<QueryT, QueryResultT>, QueryResultT extends AbstractRemoteFunctionQueryResult<QueryT, QueryResultT>>
implements Transaction<QueryT, QueryResultT> {
    private static final Logger logger = CloudLoggerFactory.getLogger(JCoTransaction.class);
    private final JCoDestination destination;
    private final Supplier<QueryResultT> queryResultFactory;
    private static final String ROLLBACK_FUNCTION_NAME = "BAPI_TRANSACTION_ROLLBACK";
    private static final String COMMIT_FUNCTION_NAME = "BAPI_TRANSACTION_COMMIT";
    private static final String DATE_TIME_PATTERN = "yyyyMMdd HHmmss";
    private final ErpTypeSerializer erpTypeSerializer = JCoErpNoopConverter.overrideNumbers(new ErpTypeSerializer());

    public JCoTransaction(@Nonnull String destinationName, @Nonnull Supplier<QueryResultT> queryResultFactory) throws RemoteFunctionException {
        this.queryResultFactory = queryResultFactory;
        try {
            this.destination = JCoDestinationManager.getDestination((String)destinationName);
        }
        catch (JCoException e) {
            throw new RemoteFunctionException(e);
        }
        JCoTransaction.registerClientPassportManager();
    }

    private static void registerClientPassportManager() {
        JCoClientPassportManagerProvider provider = (JCoClientPassportManagerProvider)FacadeLocator.getFacade(JCoClientPassportManagerProvider.class);
        if (provider != null) {
            ClientPassportManager manager = provider.getClientPassportManager();
            Environment.registerClientPassportManager((ClientPassportManager)manager);
        }
    }

    @Override
    public void before(@Nonnull ErpConfigContext configContext, @Nonnull QueryT query) {
        ErpEndpointMonitor.getInstance().incrementErpQueryCount(query);
        if (((AbstractRemoteFunctionQuery)((Object)query)).isPerformingTransactionalCommit()) {
            JCoContext.begin((JCoDestination)this.destination);
        }
    }

    @Override
    @Nonnull
    public QueryResultT execute(@Nonnull ErpConfigContext configContext, @Nonnull QueryT query) throws RemoteFunctionException {
        try {
            JCoFunction functionToInvoke = this.getJCoFunctionToInvoke(query, this.destination);
            this.passQueryParameterToJCoFunction(query, functionToInvoke);
            functionToInvoke.execute(this.destination);
            return this.getQueryResultAfterFunctionInvocation(query, functionToInvoke);
        }
        catch (JCoException e) {
            throw new RemoteFunctionException(e);
        }
    }

    private JCoFunction getJCoFunctionToInvoke(QueryT query, JCoDestination destination) throws JCoException {
        JCoRepository repo = destination.getRepository();
        return repo.getFunction(((AbstractRemoteFunctionQuery)((Object)query)).getFunctionName());
    }

    private void passQueryParameterToJCoFunction(QueryT query, JCoFunction function) {
        block11: for (Parameter<?> parameter : ((AbstractRemoteFunctionQuery)((Object)query)).getParametersByName().values()) {
            JCoParameterList parameterList;
            ParameterType parameterType = parameter.getParameterType();
            ValueType valueType = parameter.getValueType();
            switch (parameterType) {
                case EXPORTING: {
                    parameterList = function.getImportParameterList();
                    break;
                }
                case IMPORTING: {
                    parameterList = function.getExportParameterList();
                    break;
                }
                case TABLES: {
                    parameterList = function.getTableParameterList();
                    break;
                }
                case CHANGING: {
                    parameterList = function.getChangingParameterList();
                    break;
                }
                default: {
                    if (!logger.isWarnEnabled()) continue block11;
                    logger.warn("Parameter '" + parameter.getName() + "' of function '" + function.getName() + "' has an unsupported type '" + (Object)((Object)parameterType) + "'. Ignoring parameter.");
                    continue block11;
                }
            }
            if (parameterList == null) {
                if (!logger.isWarnEnabled()) continue;
                logger.warn("Parameter '" + parameter.getName() + "' of function '" + function.getName() + "' has no parameter list. Ignoring parameter.");
                continue;
            }
            switch (valueType) {
                case FIELD: {
                    parameterList.setValue(parameter.getName(), (String)this.erpTypeSerializer.toErp(parameter.getValue()).get());
                    break;
                }
                case TABLE: {
                    JCoTable table = parameterList.getTable(parameter.getName());
                    if (parameter.getValueList() == null) break;
                    int currentRowId = 0;
                    for (Value<?> value : parameter.getValueList()) {
                        if (value.getRowId() > currentRowId) {
                            currentRowId = value.getRowId();
                            table.appendRow();
                        }
                        table.setValue(value.getName(), (String)this.erpTypeSerializer.toErp(value.getValue()).get());
                    }
                    continue block11;
                }
                case STRUCTURE: {
                    JCoStructure structure = parameterList.getStructure(parameter.getName());
                    if (parameter.getValueList() == null) break;
                    for (Value<?> value : parameter.getValueList()) {
                        structure.setValue(value.getName(), (String)this.erpTypeSerializer.toErp(value.getValue()).get());
                    }
                    continue block11;
                }
            }
        }
    }

    private QueryResultT getQueryResultAfterFunctionInvocation(QueryT query, JCoFunction functionToInvoke) {
        AbstractRemoteFunctionQueryResult queryResult = (AbstractRemoteFunctionQueryResult)this.queryResultFactory.get();
        queryResult.setQuery(query);
        ArrayList<AbstractRemoteFunctionQueryResult.Result> resultList = new ArrayList<AbstractRemoteFunctionQueryResult.Result>();
        ArrayList typeConverters = Lists.newArrayList(((AbstractRemoteFunctionQuery)((Object)query)).getTypeConverters());
        typeConverters.add(new LocalDateConverter(DATE_TIME_PATTERN));
        typeConverters.add(new LocalTimeConverter(DATE_TIME_PATTERN));
        GsonResultElementFactory resultElementFactory = new GsonResultElementFactory(RemoteFunctionGsonBuilder.newJCoQueryResultGsonBuilder(typeConverters));
        JCoFieldToResultReader resultReader = new JCoFieldToResultReader();
        JCoParameterList exportParameterList = functionToInvoke.getExportParameterList();
        JCoParameterList importParameterList = functionToInvoke.getImportParameterList();
        JCoParameterList changingParameterList = functionToInvoke.getChangingParameterList();
        JCoParameterList tableParameterList = functionToInvoke.getTableParameterList();
        AbapException[] exceptionList = functionToInvoke.getExceptionList();
        if (exportParameterList != null) {
            for (JCoField field : exportParameterList) {
                resultList.add(resultReader.newResult(field, resultElementFactory));
            }
        }
        if (importParameterList != null) {
            for (JCoField field : importParameterList) {
                resultList.add(resultReader.newResult(field, resultElementFactory));
            }
        }
        if (changingParameterList != null) {
            for (JCoField field : changingParameterList) {
                resultList.add(resultReader.newResult(field, resultElementFactory));
            }
        }
        if (tableParameterList != null) {
            for (JCoField field : tableParameterList) {
                resultList.add(resultReader.newResult(field, resultElementFactory));
            }
        }
        queryResult.setResultList(resultList);
        for (AbstractRemoteFunctionQueryResult.Result returnParameterResult : this.getReturnParameterResults(queryResult)) {
            ResultElement resultElement = returnParameterResult.getValue();
            ArrayList<ResultElement> elements = new ArrayList<ResultElement>();
            if (resultElement.isResultCollection()) {
                Iterables.addAll(elements, (Iterable)resultElement.getAsCollection());
            } else {
                elements.add(resultElement);
            }
            for (ResultElement element : elements) {
                if (!element.isResultObject()) continue;
                MessageResultReader.addMessageToResult(queryResult, (AbstractRemoteFunctionQueryResult.MessageResult)element.getAsObject().as(AbstractRemoteFunctionQueryResult.MessageResult.class));
            }
        }
        return (QueryResultT)queryResult;
    }

    protected List<AbstractRemoteFunctionQueryResult.Result> getReturnParameterResults(QueryResultT result) {
        LinkedHashSet<String> returnParameterNames = ((AbstractRemoteFunctionQuery)((Object)((AbstractRemoteFunctionQueryResult)result).getQuery())).getReturnParameterNames();
        ArrayList<AbstractRemoteFunctionQueryResult.Result> returnParameterResults = new ArrayList<AbstractRemoteFunctionQueryResult.Result>();
        ArrayList<AbstractRemoteFunctionQueryResult.Result> resultList = ((AbstractRemoteFunctionQueryResult)result).getResultList();
        if (resultList != null) {
            for (AbstractRemoteFunctionQueryResult.Result resultItem : resultList) {
                if (!returnParameterNames.contains(resultItem.getName())) continue;
                returnParameterResults.add(resultItem);
            }
        }
        return returnParameterResults;
    }

    @Override
    public void commit(@Nonnull ErpConfigContext configContext, @Nonnull QueryT query) throws QueryExecutionException {
        ErpBoolean waitValue = ErpBoolean.of((Boolean)((AbstractRemoteFunctionQuery)((Object)query)).getCommitStrategy().isWaitingForCommitToFinish());
        try {
            JCoRepository repo = this.destination.getRepository();
            JCoFunction commitFunction = repo.getFunction(COMMIT_FUNCTION_NAME);
            commitFunction.getImportParameterList().setValue("WAIT", waitValue.toString());
            commitFunction.execute(this.destination);
            this.evaluateQueryCommitResult(commitFunction, query);
        }
        catch (JCoException e) {
            throw new QueryExecutionException((Throwable)e);
        }
    }

    private void evaluateQueryCommitResult(JCoFunction commitFunction, QueryT query) throws RemoteFunctionCommitFailedException {
        JCoParameterList exportParameterList = commitFunction.getExportParameterList();
        JCoStructure bapiReturnStructure = exportParameterList.getStructure("RETURN");
        String bapiReturnType = bapiReturnStructure.getString("TYPE");
        if (MessageType.ERROR.getIdentifier().equals(bapiReturnType)) {
            throw new RemoteFunctionCommitFailedException("Failed to commit BAPI transaction due to an unknown error on ERP side. Please investigate the respective ABAP logs.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Successfully committed BAPI transaction for query: " + query + ".");
        }
    }

    @Override
    public void rollback(@Nonnull ErpConfigContext configContext, @Nonnull QueryT query) throws QuerySerializationException, QueryExecutionException {
        try {
            JCoRepository repo = this.destination.getRepository();
            JCoFunction rollbackFunction = repo.getFunction(ROLLBACK_FUNCTION_NAME);
            rollbackFunction.execute(this.destination);
        }
        catch (JCoException e) {
            throw new RemoteFunctionRollbackFailedException(e);
        }
    }

    @Override
    public void after() throws RemoteFunctionException {
        if (JCoContext.isStateful((JCoDestination)this.destination)) {
            try {
                JCoContext.end((JCoDestination)this.destination);
            }
            catch (JCoException e) {
                throw new RemoteFunctionException(e);
            }
        }
    }

    JCoTransaction(JCoDestination destination, Supplier<QueryResultT> queryResultFactory) {
        this.destination = destination;
        this.queryResultFactory = queryResultFactory;
    }
}

