/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.rfc;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionQuery;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionQueryResult;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.DefaultRemoteFunctionErrorMapper;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.RemoteFunctionErrorMapper;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.RemoteFunctionExceptionPriority;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.RemoteFunctionQueryErrorHandler;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.exception.RemoteFunctionException;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.exception.RemoteFunctionExceptionFactory;
import com.sap.cloud.sdk.s4hana.serialization.MessageClass;
import com.sap.cloud.sdk.s4hana.serialization.MessageNumber;
import com.sap.cloud.sdk.s4hana.serialization.RemoteFunctionError;
import com.sap.cloud.sdk.s4hana.serialization.RemoteFunctionMessage;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import javax.annotation.Nonnull;

class ExceptionPropagatingRemoteFunctionQueryErrorHandler
implements RemoteFunctionQueryErrorHandler {
    private RemoteFunctionErrorMapper remoteFunctionErrorMapper = new DefaultRemoteFunctionErrorMapper();

    ExceptionPropagatingRemoteFunctionQueryErrorHandler() {
    }

    @Override
    @Nonnull
    public <QueryT extends AbstractRemoteFunctionQuery<QueryT, QueryResultT>, QueryResultT extends AbstractRemoteFunctionQueryResult<QueryT, QueryResultT>> Optional<RemoteFunctionException> handleQueryResult(@Nonnull QueryResultT queryResult) {
        List<RemoteFunctionMessage> errors = queryResult.getErrorMessages();
        List<RemoteFunctionMessage> warnings = queryResult.getWarningMessages();
        List<RemoteFunctionMessage> informations = queryResult.getInformationMessages();
        TreeMap<RemoteFunctionExceptionPriority, RemoteFunctionException> prioritizedExceptions = this.getPrioritizedExceptionsFromMessages(errors);
        if (prioritizedExceptions.isEmpty()) {
            TreeMap<RemoteFunctionExceptionPriority, RemoteFunctionException> prioritizedWarnings = this.getPrioritizedExceptionsFromMessages(warnings);
            if (prioritizedWarnings.isEmpty()) {
                RemoteFunctionException exception = new RemoteFunctionException(Iterables.concat(errors, warnings, informations));
                return Optional.of(exception);
            }
            return Optional.of(ExceptionPropagatingRemoteFunctionQueryErrorHandler.getWithHighestPriority(prioritizedWarnings));
        }
        return Optional.of(ExceptionPropagatingRemoteFunctionQueryErrorHandler.getWithHighestPriority(prioritizedExceptions));
    }

    private static RemoteFunctionException getWithHighestPriority(TreeMap<RemoteFunctionExceptionPriority, RemoteFunctionException> prioritizedExceptions) {
        return prioritizedExceptions.firstEntry().getValue();
    }

    private TreeMap<RemoteFunctionExceptionPriority, RemoteFunctionException> getPrioritizedExceptionsFromMessages(List<RemoteFunctionMessage> messages) {
        TreeMap prioritizedExceptions = Maps.newTreeMap();
        for (RemoteFunctionMessage message : messages) {
            MessageClass messageClass = message.getMessageClass();
            MessageNumber messageNumber = message.getMessageNumber();
            RemoteFunctionError error = new RemoteFunctionError(messageClass, messageNumber);
            RemoteFunctionExceptionFactory<?> exceptionFactory = this.remoteFunctionErrorMapper.getMapping().get(error);
            RemoteFunctionExceptionPriority priority = this.remoteFunctionErrorMapper.getPriorities().get(error);
            if (exceptionFactory == null) continue;
            Object exceptionSupplier = exceptionFactory.create(message);
            prioritizedExceptions.put(priority, exceptionSupplier);
        }
        return prioritizedExceptions;
    }

    public RemoteFunctionErrorMapper getRemoteFunctionErrorMapper() {
        return this.remoteFunctionErrorMapper;
    }

    public void setRemoteFunctionErrorMapper(RemoteFunctionErrorMapper remoteFunctionErrorMapper) {
        this.remoteFunctionErrorMapper = remoteFunctionErrorMapper;
    }
}

