/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.rfc;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.sap.cloud.sdk.s4hana.connectivity.ErpTypeSerializer;
import com.sap.cloud.sdk.s4hana.connectivity.Query;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionQueryResult;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.CommitStrategy;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.ExceptionPropagatingRemoteFunctionQueryErrorHandler;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Fields;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.IgnoringErrorsRemoteFunctionQueryErrorHandler;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Parameter;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.ParameterFields;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.ParameterType;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.RemoteFunctionQueryErrorHandler;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Table;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Value;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.ValueType;
import com.sap.cloud.sdk.s4hana.serialization.BigDecimalConverter;
import com.sap.cloud.sdk.s4hana.serialization.BigIntegerConverter;
import com.sap.cloud.sdk.s4hana.serialization.BooleanConverter;
import com.sap.cloud.sdk.s4hana.serialization.ByteConverter;
import com.sap.cloud.sdk.s4hana.serialization.CharacterConverter;
import com.sap.cloud.sdk.s4hana.serialization.DoubleConverter;
import com.sap.cloud.sdk.s4hana.serialization.ErpType;
import com.sap.cloud.sdk.s4hana.serialization.ErpTypeConverter;
import com.sap.cloud.sdk.s4hana.serialization.FloatConverter;
import com.sap.cloud.sdk.s4hana.serialization.IntegerConverter;
import com.sap.cloud.sdk.s4hana.serialization.LocalDateConverter;
import com.sap.cloud.sdk.s4hana.serialization.LocalTimeConverter;
import com.sap.cloud.sdk.s4hana.serialization.LocaleConverter;
import com.sap.cloud.sdk.s4hana.serialization.LongConverter;
import com.sap.cloud.sdk.s4hana.serialization.ShortConverter;
import com.sap.cloud.sdk.s4hana.serialization.YearConverter;
import com.sap.cloud.sdk.s4hana.types.Year;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;

public abstract class AbstractRemoteFunctionQuery<QueryT extends AbstractRemoteFunctionQuery<QueryT, QueryResultT>, QueryResultT extends AbstractRemoteFunctionQueryResult<QueryT, QueryResultT>>
extends Query<QueryT, QueryResultT> {
    private static final String RETURN_PARAMETER = "RETURN";
    protected final String functionName;
    protected final CommitStrategy commitStrategy;
    protected RemoteFunctionQueryErrorHandler remoteFunctionQueryErrorHandler;
    private final LinkedHashMap<String, Parameter<?>> parametersByName = Maps.newLinkedHashMap();
    private final LinkedHashSet<String> returnParameterNames = Sets.newLinkedHashSet();
    protected final String constructedByMethod;
    private final Map<Class<?>, ErpTypeConverter<?>> typeConverters = Maps.newIdentityHashMap();

    protected AbstractRemoteFunctionQuery(@Nonnull String functionName, @Nonnull CommitStrategy commitStrategy, String constructedByMethod) {
        this.functionName = functionName;
        this.commitStrategy = commitStrategy;
        this.constructedByMethod = constructedByMethod;
        this.remoteFunctionQueryErrorHandler = new ExceptionPropagatingRemoteFunctionQueryErrorHandler();
        this.withTypeConverters(new ErpTypeSerializer().getTypeConverters());
    }

    @Nonnull
    protected abstract QueryT instance();

    @Nonnull
    public Collection<ErpTypeConverter<?>> getTypeConverters() {
        return this.typeConverters.values();
    }

    @Nonnull
    public AbstractRemoteFunctionQuery<QueryT, QueryResultT> withTypeConverters(Iterable<ErpTypeConverter<?>> typeConverters) {
        for (ErpTypeConverter<?> typeConverter : typeConverters) {
            this.typeConverters.put(typeConverter.getType(), typeConverter);
        }
        return this;
    }

    @Nonnull
    public AbstractRemoteFunctionQuery<QueryT, QueryResultT> withTypeConverters(ErpTypeConverter<?> ... typeConverters) {
        return this.withTypeConverters(Arrays.asList(typeConverters));
    }

    @Nonnull
    public String getFunctionName() {
        return this.functionName;
    }

    @Nonnull
    public CommitStrategy getCommitStrategy() {
        return this.commitStrategy;
    }

    RemoteFunctionQueryErrorHandler getRemoteFunctionQueryErrorHandler() {
        return this.remoteFunctionQueryErrorHandler;
    }

    @Deprecated
    public boolean doCommit() {
        return this.commitStrategy.isPerformingCommit();
    }

    public boolean isPerformingTransactionalCommit() {
        return this.commitStrategy.isPerformingCommit();
    }

    @Nonnull
    protected Parameter<?> newParameter(String name, String dataType, ParameterType parameterType, ValueType valueType) {
        Parameter<Object> parameter = new Parameter<Object>(name, dataType, parameterType, valueType, null, null, null);
        this.parametersByName.put(name, parameter);
        return parameter;
    }

    protected <T> void newParameterWithValue(String name, String dataType, ParameterType parameterType, ValueType valueType, T value, ErpTypeConverter<T> typeConverter) {
        Parameter<T> parameter = new Parameter<T>(name, dataType, parameterType, valueType, value, null, typeConverter);
        this.parametersByName.put(name, parameter);
    }

    protected void newParameterWithValueList(String name, String dataType, ParameterType parameterType, ValueType valueType, ArrayList<Value<?>> valueList) {
        Parameter<Object> parameter = new Parameter<Object>(name, dataType, parameterType, valueType, null, valueList, null);
        this.parametersByName.put(name, parameter);
    }

    @Nonnull
    protected ArrayList<Value<?>> newParameterWithValueList(String name, String dataType, ParameterType parameterType, ValueType valueType) {
        ArrayList valueList = new ArrayList();
        this.newParameterWithValueList(name, dataType, parameterType, valueType, valueList);
        return valueList;
    }

    @Nonnull
    public AbstractRemoteFunctionQuery<QueryT, QueryResultT> withExporting(String name, String dataType) {
        this.newParameter(name, dataType, ParameterType.EXPORTING, ValueType.FIELD);
        return this;
    }

    @Nonnull
    public <T extends ErpType<T>> AbstractRemoteFunctionQuery<QueryT, QueryResultT> withExporting(String name, String dataType, T value) {
        this.newParameterWithValue(name, dataType, ParameterType.EXPORTING, ValueType.FIELD, value, null);
        return this;
    }

    @Nonnull
    public <T> AbstractRemoteFunctionQuery<QueryT, QueryResultT> withExporting(String name, String dataType, T value, ErpTypeConverter<T> typeConverter) {
        this.newParameterWithValue(name, dataType, ParameterType.EXPORTING, ValueType.FIELD, value, typeConverter);
        return this;
    }

    @Nonnull
    public AbstractRemoteFunctionQuery<QueryT, QueryResultT> withExporting(String name, String dataType, Boolean value) {
        return this.withExporting(name, dataType, (Object)value, (ErpTypeConverter)BooleanConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionQuery<QueryT, QueryResultT> withExporting(String name, String dataType, Byte value) {
        return this.withExporting(name, dataType, (Object)value, (ErpTypeConverter)ByteConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionQuery<QueryT, QueryResultT> withExporting(String name, String dataType, Character value) {
        return this.withExporting(name, dataType, (Object)value, (ErpTypeConverter)CharacterConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionQuery<QueryT, QueryResultT> withExporting(String name, String dataType, String value) {
        return this.withExporting(name, dataType, value, null);
    }

    @Nonnull
    public AbstractRemoteFunctionQuery<QueryT, QueryResultT> withExporting(String name, String dataType, Short value) {
        return this.withExporting(name, dataType, (Object)value, (ErpTypeConverter)ShortConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionQuery<QueryT, QueryResultT> withExporting(String name, String dataType, Integer value) {
        return this.withExporting(name, dataType, (Object)value, (ErpTypeConverter)IntegerConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionQuery<QueryT, QueryResultT> withExporting(String name, String dataType, Long value) {
        return this.withExporting(name, dataType, (Object)value, (ErpTypeConverter)LongConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionQuery<QueryT, QueryResultT> withExporting(String name, String dataType, Float value) {
        return this.withExporting(name, dataType, (Object)value, (ErpTypeConverter)FloatConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionQuery<QueryT, QueryResultT> withExporting(String name, String dataType, Double value) {
        return this.withExporting(name, dataType, (Object)value, (ErpTypeConverter)DoubleConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionQuery<QueryT, QueryResultT> withExporting(String name, String dataType, BigInteger value) {
        return this.withExporting(name, dataType, (Object)value, (ErpTypeConverter)BigIntegerConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionQuery<QueryT, QueryResultT> withExporting(String name, String dataType, BigDecimal value) {
        return this.withExporting(name, dataType, (Object)value, (ErpTypeConverter)BigDecimalConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionQuery<QueryT, QueryResultT> withExporting(String name, String dataType, Locale value) {
        return this.withExporting(name, dataType, (Object)value, (ErpTypeConverter)LocaleConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionQuery<QueryT, QueryResultT> withExporting(String name, String dataType, Year value) {
        return this.withExporting(name, dataType, (Object)value, (ErpTypeConverter)YearConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionQuery<QueryT, QueryResultT> withExporting(String name, String dataType, LocalDate value) {
        return this.withExporting(name, dataType, (Object)value, (ErpTypeConverter)LocalDateConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionQuery<QueryT, QueryResultT> withExporting(String name, String dataType, LocalTime value) {
        return this.withExporting(name, dataType, (Object)value, (ErpTypeConverter)LocalTimeConverter.INSTANCE);
    }

    @Nonnull
    public ParameterFields<QueryT> withExportingFields(String name, String dataType) {
        return new ParameterFields<QueryT>(this.instance(), this.newParameterWithValueList(name, dataType, ParameterType.EXPORTING, ValueType.STRUCTURE));
    }

    @Nonnull
    public AbstractRemoteFunctionQuery<QueryT, QueryResultT> withExportingFields(String name, String dataType, Fields fields) {
        return this.withExportingFields(name, dataType).fields(fields, new Fields[0]).end();
    }

    @Nonnull
    public Table<QueryT> withExportingTable(String name, String dataType) {
        return new Table<QueryT>(this.instance(), this.newParameterWithValueList(name, dataType, ParameterType.EXPORTING, ValueType.TABLE));
    }

    @Nonnull
    public AbstractRemoteFunctionQuery<QueryT, QueryResultT> withImporting(String name, String dataType) {
        this.newParameter(name, dataType, ParameterType.IMPORTING, ValueType.FIELD);
        return this;
    }

    @Nonnull
    public <T extends ErpType<T>> AbstractRemoteFunctionQuery<QueryT, QueryResultT> withImporting(String name, String dataType, T value) {
        this.newParameterWithValue(name, dataType, ParameterType.IMPORTING, ValueType.FIELD, value, null);
        return this;
    }

    @Nonnull
    public <T> AbstractRemoteFunctionQuery<QueryT, QueryResultT> withImporting(String name, String dataType, T value, ErpTypeConverter<T> typeConverter) {
        this.newParameterWithValue(name, dataType, ParameterType.IMPORTING, ValueType.FIELD, value, typeConverter);
        return this;
    }

    @Nonnull
    public AbstractRemoteFunctionQuery<QueryT, QueryResultT> withImporting(String name, String dataType, Boolean value) {
        return this.withImporting(name, dataType, (Object)value, (ErpTypeConverter)BooleanConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionQuery<QueryT, QueryResultT> withImporting(String name, String dataType, Byte value) {
        return this.withImporting(name, dataType, (Object)value, (ErpTypeConverter)ByteConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionQuery<QueryT, QueryResultT> withImporting(String name, String dataType, Character value) {
        return this.withImporting(name, dataType, (Object)value, (ErpTypeConverter)CharacterConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionQuery<QueryT, QueryResultT> withImporting(String name, String dataType, String value) {
        return this.withImporting(name, dataType, value, null);
    }

    @Nonnull
    public AbstractRemoteFunctionQuery<QueryT, QueryResultT> withImporting(String name, String dataType, Short value) {
        return this.withImporting(name, dataType, (Object)value, (ErpTypeConverter)ShortConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionQuery<QueryT, QueryResultT> withImporting(String name, String dataType, Integer value) {
        return this.withImporting(name, dataType, (Object)value, (ErpTypeConverter)IntegerConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionQuery<QueryT, QueryResultT> withImporting(String name, String dataType, Long value) {
        return this.withImporting(name, dataType, (Object)value, (ErpTypeConverter)LongConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionQuery<QueryT, QueryResultT> withImporting(String name, String dataType, Float value) {
        return this.withImporting(name, dataType, (Object)value, (ErpTypeConverter)FloatConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionQuery<QueryT, QueryResultT> withImporting(String name, String dataType, Double value) {
        return this.withImporting(name, dataType, (Object)value, (ErpTypeConverter)DoubleConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionQuery<QueryT, QueryResultT> withImporting(String name, String dataType, BigInteger value) {
        return this.withImporting(name, dataType, (Object)value, (ErpTypeConverter)BigIntegerConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionQuery<QueryT, QueryResultT> withImporting(String name, String dataType, BigDecimal value) {
        return this.withImporting(name, dataType, (Object)value, (ErpTypeConverter)BigDecimalConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionQuery<QueryT, QueryResultT> withImporting(String name, String dataType, Locale value) {
        return this.withImporting(name, dataType, (Object)value, (ErpTypeConverter)LocaleConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionQuery<QueryT, QueryResultT> withImporting(String name, String dataType, Year value) {
        return this.withImporting(name, dataType, (Object)value, (ErpTypeConverter)YearConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionQuery<QueryT, QueryResultT> withImporting(String name, String dataType, LocalDate value) {
        return this.withImporting(name, dataType, (Object)value, (ErpTypeConverter)LocalDateConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionQuery<QueryT, QueryResultT> withImporting(String name, String dataType, LocalTime value) {
        return this.withImporting(name, dataType, (Object)value, (ErpTypeConverter)LocalTimeConverter.INSTANCE);
    }

    @Nonnull
    public ParameterFields<QueryT> withImportingFields(String name, String dataType) {
        return new ParameterFields<QueryT>(this.instance(), this.newParameterWithValueList(name, dataType, ParameterType.IMPORTING, ValueType.STRUCTURE));
    }

    @Nonnull
    public AbstractRemoteFunctionQuery<QueryT, QueryResultT> withImportingFields(String name, String dataType, Fields fields) {
        return this.withImportingFields(name, dataType).fields(fields, new Fields[0]).end();
    }

    @Nonnull
    public Table<QueryT> withImportingTable(String name, String dataType) {
        return new Table<QueryT>(this.instance(), this.newParameterWithValueList(name, dataType, ParameterType.IMPORTING, ValueType.TABLE));
    }

    @Nonnull
    public AbstractRemoteFunctionQuery<QueryT, QueryResultT> withImportingAsReturn(String dataType) {
        return this.withImportingAsReturn(RETURN_PARAMETER, dataType);
    }

    @Nonnull
    public AbstractRemoteFunctionQuery<QueryT, QueryResultT> withImportingAsReturn(String name, String dataType) {
        this.newParameter(name, dataType, ParameterType.IMPORTING, ValueType.FIELD);
        this.returnParameterNames.add(name);
        return this;
    }

    @Nonnull
    public Table<QueryT> withTable(String name, String dataType) {
        return new Table<QueryT>(this.instance(), this.newParameterWithValueList(name, dataType, ParameterType.TABLES, ValueType.TABLE));
    }

    @Nonnull
    public AbstractRemoteFunctionQuery<QueryT, QueryResultT> withTableAsReturn(String dataType) {
        return this.withTableAsReturn(RETURN_PARAMETER, dataType);
    }

    @Nonnull
    public AbstractRemoteFunctionQuery<QueryT, QueryResultT> withTableAsReturn(String name, String dataType) {
        this.newParameter(name, dataType, ParameterType.TABLES, ValueType.TABLE);
        this.returnParameterNames.add(name);
        return this;
    }

    @Nonnull
    public AbstractRemoteFunctionQuery<QueryT, QueryResultT> withErrorHandler(@Nonnull RemoteFunctionQueryErrorHandler remoteFunctionQueryErrorHandler) {
        this.remoteFunctionQueryErrorHandler = remoteFunctionQueryErrorHandler;
        return this;
    }

    @Nonnull
    public AbstractRemoteFunctionQuery<QueryT, QueryResultT> ignoringErrors() {
        this.remoteFunctionQueryErrorHandler = new IgnoringErrorsRemoteFunctionQueryErrorHandler();
        return this;
    }

    @Nonnull
    public AbstractRemoteFunctionQuery<QueryT, QueryResultT> propagatingErrorsAsExceptions() {
        this.remoteFunctionQueryErrorHandler = new ExceptionPropagatingRemoteFunctionQueryErrorHandler();
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractRemoteFunctionQuery)) {
            return false;
        }
        AbstractRemoteFunctionQuery other = (AbstractRemoteFunctionQuery)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$functionName = this.getFunctionName();
        String other$functionName = other.getFunctionName();
        if (this$functionName == null ? other$functionName != null : !this$functionName.equals(other$functionName)) {
            return false;
        }
        CommitStrategy this$commitStrategy = this.getCommitStrategy();
        CommitStrategy other$commitStrategy = other.getCommitStrategy();
        if (this$commitStrategy == null ? other$commitStrategy != null : !((Object)((Object)this$commitStrategy)).equals((Object)other$commitStrategy)) {
            return false;
        }
        RemoteFunctionQueryErrorHandler this$remoteFunctionQueryErrorHandler = this.getRemoteFunctionQueryErrorHandler();
        RemoteFunctionQueryErrorHandler other$remoteFunctionQueryErrorHandler = other.getRemoteFunctionQueryErrorHandler();
        if (this$remoteFunctionQueryErrorHandler == null ? other$remoteFunctionQueryErrorHandler != null : !this$remoteFunctionQueryErrorHandler.equals(other$remoteFunctionQueryErrorHandler)) {
            return false;
        }
        LinkedHashMap<String, Parameter<?>> this$parametersByName = this.getParametersByName();
        LinkedHashMap<String, Parameter<?>> other$parametersByName = other.getParametersByName();
        if (this$parametersByName == null ? other$parametersByName != null : !((Object)this$parametersByName).equals(other$parametersByName)) {
            return false;
        }
        LinkedHashSet<String> this$returnParameterNames = this.getReturnParameterNames();
        LinkedHashSet<String> other$returnParameterNames = other.getReturnParameterNames();
        if (this$returnParameterNames == null ? other$returnParameterNames != null : !((Object)this$returnParameterNames).equals(other$returnParameterNames)) {
            return false;
        }
        String this$constructedByMethod = this.getConstructedByMethod();
        String other$constructedByMethod = other.getConstructedByMethod();
        if (this$constructedByMethod == null ? other$constructedByMethod != null : !this$constructedByMethod.equals(other$constructedByMethod)) {
            return false;
        }
        Collection<ErpTypeConverter<?>> this$typeConverters = this.getTypeConverters();
        Collection<ErpTypeConverter<?>> other$typeConverters = other.getTypeConverters();
        return !(this$typeConverters == null ? other$typeConverters != null : !((Object)this$typeConverters).equals(other$typeConverters));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractRemoteFunctionQuery;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $functionName = this.getFunctionName();
        result = result * 59 + ($functionName == null ? 43 : $functionName.hashCode());
        CommitStrategy $commitStrategy = this.getCommitStrategy();
        result = result * 59 + ($commitStrategy == null ? 43 : ((Object)((Object)$commitStrategy)).hashCode());
        RemoteFunctionQueryErrorHandler $remoteFunctionQueryErrorHandler = this.getRemoteFunctionQueryErrorHandler();
        result = result * 59 + ($remoteFunctionQueryErrorHandler == null ? 43 : $remoteFunctionQueryErrorHandler.hashCode());
        LinkedHashMap<String, Parameter<?>> $parametersByName = this.getParametersByName();
        result = result * 59 + ($parametersByName == null ? 43 : ((Object)$parametersByName).hashCode());
        LinkedHashSet<String> $returnParameterNames = this.getReturnParameterNames();
        result = result * 59 + ($returnParameterNames == null ? 43 : ((Object)$returnParameterNames).hashCode());
        String $constructedByMethod = this.getConstructedByMethod();
        result = result * 59 + ($constructedByMethod == null ? 43 : $constructedByMethod.hashCode());
        Collection<ErpTypeConverter<?>> $typeConverters = this.getTypeConverters();
        result = result * 59 + ($typeConverters == null ? 43 : ((Object)$typeConverters).hashCode());
        return result;
    }

    public String toString() {
        return "AbstractRemoteFunctionQuery(functionName=" + this.getFunctionName() + ", commitStrategy=" + (Object)((Object)this.getCommitStrategy()) + ", remoteFunctionQueryErrorHandler=" + this.getRemoteFunctionQueryErrorHandler() + ", parametersByName=" + this.getParametersByName() + ", returnParameterNames=" + this.getReturnParameterNames() + ", constructedByMethod=" + this.getConstructedByMethod() + ", typeConverters=" + this.getTypeConverters() + ")";
    }

    LinkedHashMap<String, Parameter<?>> getParametersByName() {
        return this.parametersByName;
    }

    LinkedHashSet<String> getReturnParameterNames() {
        return this.returnParameterNames;
    }

    public String getConstructedByMethod() {
        return this.constructedByMethod;
    }
}

