/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.rfc;

import com.sap.cloud.sdk.s4hana.serialization.ErpTypeConverter;
import java.util.Map;
import javax.annotation.Nullable;

final class Value<T> {
    private final int rowId;
    private final String name;
    private final String dataType;
    private final T value;
    @Nullable
    private final ErpTypeConverter<T> typeConverter;

    Value(int rowId, String name, String dataType, T value, @Nullable ErpTypeConverter<T> typeConverter) {
        Value.checkNotIterableOrMap(value);
        this.rowId = rowId;
        this.name = name;
        this.dataType = dataType;
        this.value = value;
        this.typeConverter = typeConverter;
    }

    static <T> void checkNotIterableOrMap(@Nullable T value) throws IllegalArgumentException {
        if (value == null) {
            return;
        }
        if (value instanceof Iterable) {
            throw new IllegalArgumentException("Instance of Iterable<?> is not allowed as value: " + value);
        }
        if (value instanceof Map) {
            throw new IllegalArgumentException("Instance of Map<?,?> is not allowed as value: " + value);
        }
    }

    int getRowId() {
        return this.rowId;
    }

    String getName() {
        return this.name;
    }

    String getDataType() {
        return this.dataType;
    }

    T getValue() {
        return this.value;
    }

    @Nullable
    ErpTypeConverter<T> getTypeConverter() {
        return this.typeConverter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Value)) {
            return false;
        }
        Value other = (Value)o;
        if (this.getRowId() != other.getRowId()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$dataType = this.getDataType();
        String other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType)) {
            return false;
        }
        T this$value = this.getValue();
        T other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        ErpTypeConverter<T> this$typeConverter = this.getTypeConverter();
        ErpTypeConverter<T> other$typeConverter = other.getTypeConverter();
        return !(this$typeConverter == null ? other$typeConverter != null : !this$typeConverter.equals(other$typeConverter));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRowId();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
        T $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        ErpTypeConverter<T> $typeConverter = this.getTypeConverter();
        result = result * 59 + ($typeConverter == null ? 43 : $typeConverter.hashCode());
        return result;
    }

    public String toString() {
        return "Value(rowId=" + this.getRowId() + ", name=" + this.getName() + ", dataType=" + this.getDataType() + ", value=" + this.getValue() + ", typeConverter=" + this.getTypeConverter() + ")";
    }
}

