/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.rfc;

import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.s4hana.connectivity.ErpEndpoint;
import com.sap.cloud.sdk.s4hana.connectivity.QueryExecutor;
import com.sap.cloud.sdk.s4hana.connectivity.SerializedQueryResult;
import com.sap.cloud.sdk.s4hana.connectivity.exception.QueryExecutionException;
import com.sap.cloud.sdk.s4hana.connectivity.exception.QuerySerializationException;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionQuery;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionQueryResult;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.BapiQuery;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.QueryNotifier;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.RemoteFunctionErrorHandler;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.SoapRemoteFunctionQuerySerializer;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.SoapSerializedQueryBuilder;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.exception.RemoteFunctionCommitFailedException;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.exception.RemoteFunctionException;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.exception.RemoteFunctionRollbackFailedException;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import org.slf4j.Logger;

class SoapRemoteFunctionQueryExecutor<QueryT extends AbstractRemoteFunctionQuery<QueryT, QueryResultT>, QueryResultT extends AbstractRemoteFunctionQueryResult<QueryT, QueryResultT>>
implements QueryExecutor<QueryT, QueryResultT> {
    private static final Logger logger = CloudLoggerFactory.getLogger(SoapRemoteFunctionQueryExecutor.class);
    private final Class<QueryResultT> resultType;

    private void commitSoap(ErpEndpoint erpEndpoint) throws QuerySerializationException, QueryExecutionException {
        if (logger.isDebugEnabled()) {
            logger.debug("Committing BAPI transaction for query: " + this + ".");
        }
        try {
            SerializedQueryResult commitResult = erpEndpoint.executeQuery(new SoapSerializedQueryBuilder(new BapiQuery("BAPI_TRANSACTION_COMMIT"), "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:urn=\"urn:sap-com:document:sap:soap:functions:mc-style\"><soapenv:Header/><soapenv:Body><urn:TransactionCommit><Wait>?</Wait></urn:TransactionCommit></soapenv:Body></soapenv:Envelope>").build());
            if (commitResult.getBody().contains("150")) {
                throw new RemoteFunctionCommitFailedException("Failed to commit BAPI transaction due to an unknown error on ERP side. Please investigate the respective ABAP logs.");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Successfully committed BAPI transaction for query: " + this + ".");
            }
        }
        catch (QueryExecutionException | QuerySerializationException e) {
            this.rollbackSoap(erpEndpoint);
            throw new RemoteFunctionCommitFailedException(e);
        }
    }

    private void rollbackSoap(ErpEndpoint erpEndpoint) throws QuerySerializationException, QueryExecutionException {
        if (logger.isDebugEnabled()) {
            logger.debug("Rolling back BAPI transaction for query: " + this + ".");
        }
        try {
            erpEndpoint.executeQuery(new SoapSerializedQueryBuilder(new BapiQuery("BAPI_TRANSACTION_ROLLBACK"), "<x:Envelope xmlns:x=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:urn1=\"urn:sap-com:document:sap:soap:functions:mc-style\"><x:Header/><x:Body><urn1:TransactionRollback/></x:Body></x:Envelope>").build());
            if (logger.isDebugEnabled()) {
                logger.debug("Successfully rolled back BAPI transaction for query: " + this + ".");
            }
        }
        catch (QueryExecutionException | QuerySerializationException e) {
            throw new RemoteFunctionRollbackFailedException(e);
        }
    }

    public QueryResultT execute(QueryT query, ErpEndpoint erpEndpoint) throws QuerySerializationException, QueryExecutionException {
        QueryNotifier.notifyQueryListeners(query, erpEndpoint.getDestinationName(), logger);
        SoapRemoteFunctionQuerySerializer serializer = new SoapRemoteFunctionQuerySerializer(this.resultType);
        AbstractRemoteFunctionQueryResult result = (AbstractRemoteFunctionQueryResult)erpEndpoint.executeQuery(query, serializer);
        if (result.hasFailed()) {
            try {
                new RemoteFunctionErrorHandler().handle(result);
            }
            catch (RemoteFunctionException e) {
                if (query instanceof BapiQuery) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(this.resultType.getSimpleName() + " failed. Triggering rollback for query: " + this + ".", (Throwable)((Object)e));
                    }
                    this.rollbackSoap(erpEndpoint);
                }
                throw e;
            }
        }
        if (query instanceof BapiQuery && ((AbstractRemoteFunctionQuery)((Object)query)).doCommit()) {
            this.commitSoap(erpEndpoint);
        }
        if (logger.isInfoEnabled()) {
            ArrayList<AbstractRemoteFunctionQueryResult.Result> resultList = result.getResultList();
            logger.info(query.getClass().getSimpleName() + " " + ((AbstractRemoteFunctionQuery)((Object)query)).getConstructedByMethod() + " successfully returned " + (resultList == null ? " a null result." : resultList.size() + " result(s)."));
        }
        return (QueryResultT)result;
    }

    @ConstructorProperties(value={"resultType"})
    SoapRemoteFunctionQueryExecutor(Class<QueryResultT> resultType) {
        this.resultType = resultType;
    }
}

