/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.rfc;

import com.google.common.collect.Sets;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationType;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.s4hana.connectivity.ErpEndpoint;
import com.sap.cloud.sdk.s4hana.connectivity.Query;
import com.sap.cloud.sdk.s4hana.connectivity.exception.QueryExecutionException;
import com.sap.cloud.sdk.s4hana.connectivity.exception.QuerySerializationException;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionQuery;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.BapiQuery;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Fields;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.ParameterFields;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.ParameterType;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.RemoteFunctionQueryExecutorFactory;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.RfcQueryResult;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.RfcQueryResultFactory;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Table;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.ValueType;
import com.sap.cloud.sdk.s4hana.serialization.BigDecimalConverter;
import com.sap.cloud.sdk.s4hana.serialization.BigIntegerConverter;
import com.sap.cloud.sdk.s4hana.serialization.BooleanConverter;
import com.sap.cloud.sdk.s4hana.serialization.ByteConverter;
import com.sap.cloud.sdk.s4hana.serialization.CharacterConverter;
import com.sap.cloud.sdk.s4hana.serialization.DoubleConverter;
import com.sap.cloud.sdk.s4hana.serialization.ErpType;
import com.sap.cloud.sdk.s4hana.serialization.ErpTypeConverter;
import com.sap.cloud.sdk.s4hana.serialization.FloatConverter;
import com.sap.cloud.sdk.s4hana.serialization.IntegerConverter;
import com.sap.cloud.sdk.s4hana.serialization.LocalDateConverter;
import com.sap.cloud.sdk.s4hana.serialization.LocalTimeConverter;
import com.sap.cloud.sdk.s4hana.serialization.LocaleConverter;
import com.sap.cloud.sdk.s4hana.serialization.LongConverter;
import com.sap.cloud.sdk.s4hana.serialization.ShortConverter;
import com.sap.cloud.sdk.s4hana.serialization.YearConverter;
import com.sap.cloud.sdk.s4hana.types.Year;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.slf4j.Logger;

public class RfcQuery
extends AbstractRemoteFunctionQuery<RfcQuery, RfcQueryResult> {
    private static final Logger logger = CloudLoggerFactory.getLogger(RfcQuery.class);
    private final DynamicStringProperty serializationStrategy = DynamicPropertyFactory.getInstance().getStringProperty("s4hana.rfc.serializationStrategy", "soap");
    private final Set<String> exceptionNames = Sets.newHashSet();

    public RfcQueryResult execute(ErpEndpoint erpEndpoint) throws QuerySerializationException, QueryExecutionException {
        DestinationType destinationType = DestinationAccessor.getDestinationType((String)erpEndpoint.getDestinationName());
        return (RfcQueryResult)new RemoteFunctionQueryExecutorFactory(new RfcQueryResultFactory(), destinationType, this.serializationStrategy).create().execute((Query)this, erpEndpoint);
    }

    @Override
    protected RfcQuery instance() {
        return this;
    }

    public RfcQuery(String functionName) throws IllegalArgumentException {
        super(functionName, true, Thread.currentThread().getStackTrace()[3].toString());
        this.assertFunctionIsNotBapi(functionName);
    }

    public RfcQuery(String functionName, boolean commit) throws IllegalArgumentException {
        super(functionName, commit, Thread.currentThread().getStackTrace()[3].toString());
        this.assertFunctionIsNotBapi(functionName);
    }

    private void assertFunctionIsNotBapi(String functionName) throws IllegalArgumentException {
        if (StringUtils.startsWithIgnoreCase((CharSequence)functionName, (CharSequence)"bapi")) {
            throw new IllegalArgumentException("The given function \"" + functionName + "\" refers to a BAPI. For calling BAPIs, use " + BapiQuery.class.getSimpleName() + " instead.");
        }
    }

    public RfcQuery withTypeConverters(Iterable<ErpTypeConverter<?>> typeConverters) {
        return (RfcQuery)super.withTypeConverters(typeConverters);
    }

    public RfcQuery withTypeConverters(ErpTypeConverter<?> ... typeConverters) {
        return (RfcQuery)super.withTypeConverters(typeConverters);
    }

    public RfcQuery withExporting(String name, String dataType) {
        return (RfcQuery)super.withExporting(name, dataType);
    }

    public <T extends ErpType<T>> RfcQuery withExporting(String name, String dataType, T value) {
        return (RfcQuery)super.withExporting(name, dataType, value);
    }

    public <T> RfcQuery withExporting(String name, String dataType, T value, ErpTypeConverter<T> typeConverter) {
        return (RfcQuery)super.withExporting(name, dataType, value, typeConverter);
    }

    public RfcQuery withExporting(String name, String dataType, Boolean value) {
        return (RfcQuery)super.withExporting(name, dataType, value);
    }

    public RfcQuery withExporting(String name, String dataType, Byte value) {
        return (RfcQuery)super.withExporting(name, dataType, value);
    }

    public RfcQuery withExporting(String name, String dataType, Character value) {
        return (RfcQuery)super.withExporting(name, dataType, value);
    }

    public RfcQuery withExporting(String name, String dataType, String value) {
        return (RfcQuery)super.withExporting(name, dataType, value);
    }

    public RfcQuery withExporting(String name, String dataType, Short value) {
        return (RfcQuery)super.withExporting(name, dataType, value);
    }

    public RfcQuery withExporting(String name, String dataType, Integer value) {
        return (RfcQuery)super.withExporting(name, dataType, value);
    }

    public RfcQuery withExporting(String name, String dataType, Long value) {
        return (RfcQuery)super.withExporting(name, dataType, value);
    }

    public RfcQuery withExporting(String name, String dataType, Float value) {
        return (RfcQuery)super.withExporting(name, dataType, value);
    }

    public RfcQuery withExporting(String name, String dataType, Double value) {
        return (RfcQuery)super.withExporting(name, dataType, value);
    }

    public RfcQuery withExporting(String name, String dataType, BigInteger value) {
        return (RfcQuery)super.withExporting(name, dataType, value);
    }

    public RfcQuery withExporting(String name, String dataType, BigDecimal value) {
        return (RfcQuery)super.withExporting(name, dataType, value);
    }

    public RfcQuery withExporting(String name, String dataType, Locale value) {
        return (RfcQuery)super.withExporting(name, dataType, value);
    }

    public RfcQuery withExporting(String name, String dataType, Year value) {
        return (RfcQuery)super.withExporting(name, dataType, value);
    }

    public RfcQuery withExporting(String name, String dataType, LocalDate value) {
        return (RfcQuery)super.withExporting(name, dataType, value);
    }

    public RfcQuery withExporting(String name, String dataType, LocalTime value) {
        return (RfcQuery)super.withExporting(name, dataType, value);
    }

    @Override
    public ParameterFields<RfcQuery> withExportingFields(String name, String dataType) {
        return super.withExportingFields(name, dataType);
    }

    public RfcQuery withExportingFields(String name, String dataType, Fields fields) {
        return (RfcQuery)super.withExportingFields(name, dataType, fields);
    }

    @Override
    public Table<RfcQuery> withExportingTable(String name, String dataType) {
        return super.withExportingTable(name, dataType);
    }

    public RfcQuery withImporting(String name, String dataType) {
        return (RfcQuery)super.withImporting(name, dataType);
    }

    public <T extends ErpType<T>> RfcQuery withImporting(String name, String dataType, T value) {
        return (RfcQuery)super.withImporting(name, dataType, value);
    }

    public <T> RfcQuery withImporting(String name, String dataType, T value, ErpTypeConverter<T> typeConverter) {
        return (RfcQuery)super.withImporting(name, dataType, value, typeConverter);
    }

    public RfcQuery withImporting(String name, String dataType, Boolean value) {
        return (RfcQuery)super.withImporting(name, dataType, value);
    }

    public RfcQuery withImporting(String name, String dataType, Byte value) {
        return (RfcQuery)super.withImporting(name, dataType, value);
    }

    public RfcQuery withImporting(String name, String dataType, Character value) {
        return (RfcQuery)super.withImporting(name, dataType, value);
    }

    public RfcQuery withImporting(String name, String dataType, String value) {
        return (RfcQuery)super.withImporting(name, dataType, value);
    }

    public RfcQuery withImporting(String name, String dataType, Short value) {
        return (RfcQuery)super.withImporting(name, dataType, value);
    }

    public RfcQuery withImporting(String name, String dataType, Integer value) {
        return (RfcQuery)super.withImporting(name, dataType, value);
    }

    public RfcQuery withImporting(String name, String dataType, Long value) {
        return (RfcQuery)super.withImporting(name, dataType, value);
    }

    public RfcQuery withImporting(String name, String dataType, Float value) {
        return (RfcQuery)super.withImporting(name, dataType, value);
    }

    public RfcQuery withImporting(String name, String dataType, Double value) {
        return (RfcQuery)super.withImporting(name, dataType, value);
    }

    public RfcQuery withImporting(String name, String dataType, BigInteger value) {
        return (RfcQuery)super.withImporting(name, dataType, value);
    }

    public RfcQuery withImporting(String name, String dataType, BigDecimal value) {
        return (RfcQuery)super.withImporting(name, dataType, value);
    }

    public RfcQuery withImporting(String name, String dataType, Locale value) {
        return (RfcQuery)super.withImporting(name, dataType, value);
    }

    public RfcQuery withImporting(String name, String dataType, Year value) {
        return (RfcQuery)super.withImporting(name, dataType, value);
    }

    public RfcQuery withImporting(String name, String dataType, LocalDate value) {
        return (RfcQuery)super.withImporting(name, dataType, value);
    }

    public RfcQuery withImporting(String name, String dataType, LocalTime value) {
        return (RfcQuery)super.withImporting(name, dataType, value);
    }

    @Override
    public ParameterFields<RfcQuery> withImportingFields(String name, String dataType) {
        return super.withImportingFields(name, dataType);
    }

    public RfcQuery withImportingFields(String name, String dataType, Fields fields) {
        return (RfcQuery)super.withImportingFields(name, dataType, fields);
    }

    @Override
    public Table<RfcQuery> withImportingTable(String name, String dataType) {
        return super.withImportingTable(name, dataType);
    }

    public RfcQuery withImportingAsReturn(String dataType) {
        return (RfcQuery)super.withImportingAsReturn(dataType);
    }

    public RfcQuery withImportingAsReturn(String name, String dataType) {
        return (RfcQuery)super.withImportingAsReturn(name, dataType);
    }

    @Override
    public Table<RfcQuery> withTable(String name, String dataType) {
        return super.withTable(name, dataType);
    }

    public RfcQuery withTableAsReturn(String dataType) {
        return (RfcQuery)super.withTableAsReturn(dataType);
    }

    public RfcQuery withTableAsReturn(String name, String dataType) {
        return (RfcQuery)super.withTableAsReturn(name, dataType);
    }

    public RfcQuery withChanging(String name, String dataType) {
        this.newParameter(name, dataType, ParameterType.CHANGING, ValueType.FIELD);
        return this;
    }

    public <T extends ErpType<T>> RfcQuery withChanging(String name, String dataType, T value) {
        this.newParameterWithValue(name, dataType, ParameterType.CHANGING, ValueType.FIELD, value, null);
        return this;
    }

    public <T> RfcQuery withChanging(String name, String dataType, T value, ErpTypeConverter<T> typeConverter) {
        this.newParameterWithValue(name, dataType, ParameterType.CHANGING, ValueType.FIELD, value, typeConverter);
        return this;
    }

    public RfcQuery withChanging(String name, String dataType, Boolean value) {
        return this.withChanging(name, dataType, (Object)value, (ErpTypeConverter)BooleanConverter.INSTANCE);
    }

    public RfcQuery withChanging(String name, String dataType, Byte value) {
        return this.withChanging(name, dataType, (Object)value, (ErpTypeConverter)ByteConverter.INSTANCE);
    }

    public RfcQuery withChanging(String name, String dataType, Character value) {
        return this.withChanging(name, dataType, (Object)value, (ErpTypeConverter)CharacterConverter.INSTANCE);
    }

    public RfcQuery withChanging(String name, String dataType, String value) {
        return this.withChanging(name, dataType, value, null);
    }

    public RfcQuery withChanging(String name, String dataType, Short value) {
        return this.withChanging(name, dataType, (Object)value, (ErpTypeConverter)ShortConverter.INSTANCE);
    }

    public RfcQuery withChanging(String name, String dataType, Integer value) {
        return this.withChanging(name, dataType, (Object)value, (ErpTypeConverter)IntegerConverter.INSTANCE);
    }

    public RfcQuery withChanging(String name, String dataType, Long value) {
        return this.withChanging(name, dataType, (Object)value, (ErpTypeConverter)LongConverter.INSTANCE);
    }

    public RfcQuery withChanging(String name, String dataType, Float value) {
        return this.withChanging(name, dataType, (Object)value, (ErpTypeConverter)FloatConverter.INSTANCE);
    }

    public RfcQuery withChanging(String name, String dataType, Double value) {
        return this.withChanging(name, dataType, (Object)value, (ErpTypeConverter)DoubleConverter.INSTANCE);
    }

    public RfcQuery withChanging(String name, String dataType, BigInteger value) {
        return this.withChanging(name, dataType, (Object)value, (ErpTypeConverter)BigIntegerConverter.INSTANCE);
    }

    public RfcQuery withChanging(String name, String dataType, BigDecimal value) {
        return this.withChanging(name, dataType, (Object)value, (ErpTypeConverter)BigDecimalConverter.INSTANCE);
    }

    public RfcQuery withChanging(String name, String dataType, Locale value) {
        return this.withChanging(name, dataType, (Object)value, (ErpTypeConverter)LocaleConverter.INSTANCE);
    }

    public RfcQuery withChanging(String name, String dataType, Year value) {
        return this.withChanging(name, dataType, (Object)value, (ErpTypeConverter)YearConverter.INSTANCE);
    }

    public RfcQuery withChanging(String name, String dataType, LocalDate value) {
        return this.withChanging(name, dataType, (Object)value, (ErpTypeConverter)LocalDateConverter.INSTANCE);
    }

    public RfcQuery withChanging(String name, String dataType, LocalTime value) {
        return this.withChanging(name, dataType, (Object)value, (ErpTypeConverter)LocalTimeConverter.INSTANCE);
    }

    public ParameterFields<RfcQuery> withChangingFields(String name, String dataType) {
        return new ParameterFields<RfcQuery>(this.instance(), this.newParameterWithValueList(name, dataType, ParameterType.CHANGING, ValueType.STRUCTURE));
    }

    public RfcQuery withChangingFields(String name, String dataType, Fields fields) {
        return this.withChangingFields(name, dataType).fields(fields, new Fields[0]).end();
    }

    public Table<RfcQuery> withChangingTable(String name, String dataType) {
        return new Table<RfcQuery>(this.instance(), this.newParameterWithValueList(name, dataType, ParameterType.CHANGING, ValueType.TABLE));
    }

    public RfcQuery withException(String name) {
        this.exceptionNames.add(name);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RfcQuery)) {
            return false;
        }
        RfcQuery other = (RfcQuery)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DynamicStringProperty this$serializationStrategy = this.serializationStrategy;
        DynamicStringProperty other$serializationStrategy = other.serializationStrategy;
        if (this$serializationStrategy == null ? other$serializationStrategy != null : !this$serializationStrategy.equals(other$serializationStrategy)) {
            return false;
        }
        Set<String> this$exceptionNames = this.getExceptionNames();
        Set<String> other$exceptionNames = other.getExceptionNames();
        return !(this$exceptionNames == null ? other$exceptionNames != null : !((Object)this$exceptionNames).equals(other$exceptionNames));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RfcQuery;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        DynamicStringProperty $serializationStrategy = this.serializationStrategy;
        result = result * 59 + ($serializationStrategy == null ? 43 : $serializationStrategy.hashCode());
        Set<String> $exceptionNames = this.getExceptionNames();
        result = result * 59 + ($exceptionNames == null ? 43 : ((Object)$exceptionNames).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "RfcQuery(super=" + super.toString() + ", serializationStrategy=" + this.serializationStrategy + ", exceptionNames=" + this.getExceptionNames() + ")";
    }

    public Set<String> getExceptionNames() {
        return this.exceptionNames;
    }
}

