/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.rfc;

import com.netflix.config.DynamicStringProperty;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationType;
import com.sap.cloud.sdk.s4hana.config.S4HanaConfig;
import com.sap.cloud.sdk.s4hana.connectivity.QueryExecutor;
import com.sap.cloud.sdk.s4hana.connectivity.exception.QuerySerializationException;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionQuery;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionQueryResult;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.JCoRemoteFunctionQueryExecutor;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.JsonRemoteFunctionQueryExecutor;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.RemoteFunctionQueryResultFactory;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.SoapRemoteFunctionQueryExecutor;
import java.beans.ConstructorProperties;
import lombok.NonNull;

class RemoteFunctionQueryExecutorFactory<QueryT extends AbstractRemoteFunctionQuery<QueryT, QueryResultT>, QueryResultT extends AbstractRemoteFunctionQueryResult<QueryT, QueryResultT>> {
    @NonNull
    private final RemoteFunctionQueryResultFactory<QueryResultT> queryResultFactory;
    @NonNull
    private final DestinationType destinationType;
    @NonNull
    private final DynamicStringProperty serializationStrategy;

    public QueryExecutor<QueryT, QueryResultT> create() {
        if (DestinationType.HTTP.equals((Object)this.destinationType)) {
            String strategyName = this.serializationStrategy.get();
            if ("soap".equalsIgnoreCase(strategyName)) {
                return new SoapRemoteFunctionQueryExecutor(this.queryResultFactory.getResultType());
            }
            if ("json".equalsIgnoreCase(strategyName)) {
                return new JsonRemoteFunctionQueryExecutor(this.queryResultFactory.getResultType());
            }
            throw new QuerySerializationException("Failed to create " + QueryExecutor.class.getSimpleName() + ": " + S4HanaConfig.RemoteFunctionSerializationStrategy.class.getSimpleName() + " \"" + strategyName + "\" is not supported.");
        }
        if (DestinationType.RFC.equals((Object)this.destinationType)) {
            return new JCoRemoteFunctionQueryExecutor(this.queryResultFactory);
        }
        throw new QuerySerializationException("Failed to create " + QueryExecutor.class.getSimpleName() + ": " + DestinationType.class.getSimpleName() + " \"" + this.destinationType + "\" is not supported.");
    }

    @ConstructorProperties(value={"queryResultFactory", "destinationType", "serializationStrategy"})
    public RemoteFunctionQueryExecutorFactory(@NonNull RemoteFunctionQueryResultFactory<QueryResultT> queryResultFactory, @NonNull DestinationType destinationType, @NonNull DynamicStringProperty serializationStrategy) {
        if (queryResultFactory == null) {
            throw new NullPointerException("queryResultFactory");
        }
        if (destinationType == null) {
            throw new NullPointerException("destinationType");
        }
        if (serializationStrategy == null) {
            throw new NullPointerException("serializationStrategy");
        }
        this.queryResultFactory = queryResultFactory;
        this.destinationType = destinationType;
        this.serializationStrategy = serializationStrategy;
    }

    @NonNull
    public RemoteFunctionQueryResultFactory<QueryResultT> getQueryResultFactory() {
        return this.queryResultFactory;
    }

    @NonNull
    public DestinationType getDestinationType() {
        return this.destinationType;
    }

    @NonNull
    public DynamicStringProperty getSerializationStrategy() {
        return this.serializationStrategy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoteFunctionQueryExecutorFactory)) {
            return false;
        }
        RemoteFunctionQueryExecutorFactory other = (RemoteFunctionQueryExecutorFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RemoteFunctionQueryResultFactory<QueryResultT> this$queryResultFactory = this.getQueryResultFactory();
        RemoteFunctionQueryResultFactory<QueryResultT> other$queryResultFactory = other.getQueryResultFactory();
        if (this$queryResultFactory == null ? other$queryResultFactory != null : !this$queryResultFactory.equals(other$queryResultFactory)) {
            return false;
        }
        DestinationType this$destinationType = this.getDestinationType();
        DestinationType other$destinationType = other.getDestinationType();
        if (this$destinationType == null ? other$destinationType != null : !this$destinationType.equals(other$destinationType)) {
            return false;
        }
        DynamicStringProperty this$serializationStrategy = this.getSerializationStrategy();
        DynamicStringProperty other$serializationStrategy = other.getSerializationStrategy();
        return !(this$serializationStrategy == null ? other$serializationStrategy != null : !this$serializationStrategy.equals(other$serializationStrategy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RemoteFunctionQueryExecutorFactory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RemoteFunctionQueryResultFactory<QueryResultT> $queryResultFactory = this.getQueryResultFactory();
        result = result * 59 + ($queryResultFactory == null ? 43 : $queryResultFactory.hashCode());
        DestinationType $destinationType = this.getDestinationType();
        result = result * 59 + ($destinationType == null ? 43 : $destinationType.hashCode());
        DynamicStringProperty $serializationStrategy = this.getSerializationStrategy();
        result = result * 59 + ($serializationStrategy == null ? 43 : $serializationStrategy.hashCode());
        return result;
    }

    public String toString() {
        return "RemoteFunctionQueryExecutorFactory(queryResultFactory=" + this.getQueryResultFactory() + ", destinationType=" + this.getDestinationType() + ", serializationStrategy=" + this.getSerializationStrategy() + ")";
    }
}

