/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.rfc;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionQuery;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionQueryResult;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.DefaultRemoteFunctionErrorMapper;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.RemoteFunctionErrorMapper;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.RemoteFunctionExceptionPriority;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.exception.RemoteFunctionException;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.exception.RemoteFunctionExceptionFactory;
import com.sap.cloud.sdk.s4hana.serialization.MessageClass;
import com.sap.cloud.sdk.s4hana.serialization.MessageNumber;
import com.sap.cloud.sdk.s4hana.serialization.RemoteFunctionError;
import com.sap.cloud.sdk.s4hana.serialization.RemoteFunctionMessage;
import java.util.List;
import java.util.TreeMap;

class RemoteFunctionErrorHandler {
    private RemoteFunctionErrorMapper remoteFunctionErrorMapper = new DefaultRemoteFunctionErrorMapper();

    RemoteFunctionErrorHandler() {
    }

    <QueryT extends AbstractRemoteFunctionQuery<QueryT, QueryResultT>, QueryResultT extends AbstractRemoteFunctionQueryResult<QueryT, QueryResultT>> void handle(QueryResultT queryResult) throws RemoteFunctionException {
        List<RemoteFunctionMessage> errors = queryResult.getErrorMessages();
        List<RemoteFunctionMessage> warnings = queryResult.getWarningMessages();
        List<RemoteFunctionMessage> informations = queryResult.getInformationMessages();
        TreeMap<RemoteFunctionExceptionPriority, RemoteFunctionException> prioritizedExceptions = this.getPrioritizedExceptionsFromMessages(errors);
        if (prioritizedExceptions.isEmpty()) {
            TreeMap<RemoteFunctionExceptionPriority, RemoteFunctionException> prioritizedWarnings = this.getPrioritizedExceptionsFromMessages(warnings);
            if (prioritizedWarnings.isEmpty()) {
                throw new RemoteFunctionException(Iterables.concat(errors, warnings, informations));
            }
            throw RemoteFunctionErrorHandler.getWithHighestPriority(prioritizedWarnings);
        }
        throw RemoteFunctionErrorHandler.getWithHighestPriority(prioritizedExceptions);
    }

    private static RemoteFunctionException getWithHighestPriority(TreeMap<RemoteFunctionExceptionPriority, RemoteFunctionException> prioritizedExceptions) {
        return prioritizedExceptions.firstEntry().getValue();
    }

    private TreeMap<RemoteFunctionExceptionPriority, RemoteFunctionException> getPrioritizedExceptionsFromMessages(List<RemoteFunctionMessage> messages) {
        TreeMap prioritizedExceptions = Maps.newTreeMap();
        for (RemoteFunctionMessage message : messages) {
            MessageClass messageClass = message.getMessageClass();
            MessageNumber messageNumber = message.getMessageNumber();
            RemoteFunctionError error = new RemoteFunctionError(messageClass, messageNumber);
            RemoteFunctionExceptionFactory<?> exceptionFactory = this.remoteFunctionErrorMapper.getMapping().get(error);
            RemoteFunctionExceptionPriority priority = this.remoteFunctionErrorMapper.getPriorities().get(error);
            if (exceptionFactory == null) continue;
            Object exception = exceptionFactory.create(message);
            prioritizedExceptions.put(priority, exception);
        }
        return prioritizedExceptions;
    }

    public RemoteFunctionErrorMapper getRemoteFunctionErrorMapper() {
        return this.remoteFunctionErrorMapper;
    }

    public void setRemoteFunctionErrorMapper(RemoteFunctionErrorMapper remoteFunctionErrorMapper) {
        this.remoteFunctionErrorMapper = remoteFunctionErrorMapper;
    }
}

