/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.rfc;

import com.sap.cloud.sdk.s4hana.connectivity.rfc.ParameterType;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Value;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.ValueType;
import com.sap.cloud.sdk.s4hana.serialization.ErpTypeConverter;
import java.util.ArrayList;
import javax.annotation.Nullable;

final class Parameter<T> {
    private final String name;
    private final String dataType;
    private final ParameterType parameterType;
    private final ValueType valueType;
    @Nullable
    private final T value;
    @Nullable
    private final ArrayList<Value<?>> valueList;
    @Nullable
    private final ErpTypeConverter<T> typeConverter;

    Parameter(String name, String dataType, ParameterType parameterType, ValueType valueType, @Nullable T value, @Nullable ArrayList<Value<?>> valueList, @Nullable ErpTypeConverter<T> typeConverter) {
        Value.checkNotIterableOrMap(value);
        this.name = name;
        this.dataType = dataType;
        this.parameterType = parameterType;
        this.valueType = valueType;
        this.value = value;
        this.valueList = valueList;
        this.typeConverter = typeConverter;
    }

    String getName() {
        return this.name;
    }

    String getDataType() {
        return this.dataType;
    }

    ParameterType getParameterType() {
        return this.parameterType;
    }

    ValueType getValueType() {
        return this.valueType;
    }

    @Nullable
    T getValue() {
        return this.value;
    }

    @Nullable
    ArrayList<Value<?>> getValueList() {
        return this.valueList;
    }

    @Nullable
    ErpTypeConverter<T> getTypeConverter() {
        return this.typeConverter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Parameter)) {
            return false;
        }
        Parameter other = (Parameter)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$dataType = this.getDataType();
        String other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType)) {
            return false;
        }
        ParameterType this$parameterType = this.getParameterType();
        ParameterType other$parameterType = other.getParameterType();
        if (this$parameterType == null ? other$parameterType != null : !((Object)((Object)this$parameterType)).equals((Object)other$parameterType)) {
            return false;
        }
        ValueType this$valueType = this.getValueType();
        ValueType other$valueType = other.getValueType();
        if (this$valueType == null ? other$valueType != null : !((Object)((Object)this$valueType)).equals((Object)other$valueType)) {
            return false;
        }
        T this$value = this.getValue();
        T other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        ArrayList<Value<?>> this$valueList = this.getValueList();
        ArrayList<Value<?>> other$valueList = other.getValueList();
        if (this$valueList == null ? other$valueList != null : !((Object)this$valueList).equals(other$valueList)) {
            return false;
        }
        ErpTypeConverter<T> this$typeConverter = this.getTypeConverter();
        ErpTypeConverter<T> other$typeConverter = other.getTypeConverter();
        return !(this$typeConverter == null ? other$typeConverter != null : !this$typeConverter.equals(other$typeConverter));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
        ParameterType $parameterType = this.getParameterType();
        result = result * 59 + ($parameterType == null ? 43 : ((Object)((Object)$parameterType)).hashCode());
        ValueType $valueType = this.getValueType();
        result = result * 59 + ($valueType == null ? 43 : ((Object)((Object)$valueType)).hashCode());
        T $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        ArrayList<Value<?>> $valueList = this.getValueList();
        result = result * 59 + ($valueList == null ? 43 : ((Object)$valueList).hashCode());
        ErpTypeConverter<T> $typeConverter = this.getTypeConverter();
        result = result * 59 + ($typeConverter == null ? 43 : $typeConverter.hashCode());
        return result;
    }

    public String toString() {
        return "Parameter(name=" + this.getName() + ", dataType=" + this.getDataType() + ", parameterType=" + (Object)((Object)this.getParameterType()) + ", valueType=" + (Object)((Object)this.getValueType()) + ", value=" + this.getValue() + ", valueList=" + this.getValueList() + ", typeConverter=" + this.getTypeConverter() + ")";
    }
}

