/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.rfc;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gson.GsonBuilder;
import com.sap.cloud.sdk.result.ResultElement;
import com.sap.cloud.sdk.s4hana.connectivity.AbstractQuerySerializer;
import com.sap.cloud.sdk.s4hana.connectivity.SerializedQuery;
import com.sap.cloud.sdk.s4hana.connectivity.SerializedQueryResult;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionQuery;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionQueryResult;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.MessageResultReader;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.RemoteFunctionGsonBuilder;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.RemoteFunctionQueryBody;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;

class JsonRemoteFunctionQuerySerializer<QueryT extends AbstractRemoteFunctionQuery<QueryT, QueryResultT>, QueryResultT extends AbstractRemoteFunctionQueryResult<QueryT, QueryResultT>>
extends AbstractQuerySerializer<QueryT, QueryResultT> {
    private final Class<QueryResultT> resultType;

    private Iterable<AbstractRemoteFunctionQueryResult.Result> getReturnParameterResults(QueryResultT result) {
        LinkedHashSet<String> returnParameterNames = ((AbstractRemoteFunctionQuery)((Object)((AbstractRemoteFunctionQueryResult)result).getQuery())).getReturnParameterNames();
        ArrayList returnParameterResults = Lists.newArrayList();
        ArrayList<AbstractRemoteFunctionQueryResult.Result> resultList = ((AbstractRemoteFunctionQueryResult)result).getResultList();
        if (resultList != null) {
            for (AbstractRemoteFunctionQueryResult.Result resultItem : resultList) {
                if (!returnParameterNames.contains(resultItem.getName())) continue;
                returnParameterResults.add(resultItem);
            }
        }
        return returnParameterResults;
    }

    protected SerializedQuery<QueryT> serializeQuery(QueryT query) {
        return SerializedQuery.ofAbapInterfaceQuery(query, (String)RemoteFunctionGsonBuilder.newQueryGsonBuilder(((AbstractRemoteFunctionQuery)((Object)query)).getTypeConverters()).create().toJson((Object)new RemoteFunctionQueryBody(query)));
    }

    protected QueryResultT deserializeQueryResult(SerializedQueryResult<QueryT> serializedQueryResult) {
        AbstractRemoteFunctionQuery query = (AbstractRemoteFunctionQuery)serializedQueryResult.getQuery();
        GsonBuilder gsonBuilder = RemoteFunctionGsonBuilder.newQueryResultGsonBuilder(query.getTypeConverters());
        AbstractRemoteFunctionQueryResult result = (AbstractRemoteFunctionQueryResult)gsonBuilder.create().fromJson(serializedQueryResult.getBody(), this.resultType);
        result.setQuery(query);
        AbstractRemoteFunctionQueryResult.ExceptionResult exceptionResult = result.getException();
        if (exceptionResult != null) {
            MessageResultReader.addMessageToResult(result, exceptionResult);
        }
        for (AbstractRemoteFunctionQueryResult.Result returnParameterResult : this.getReturnParameterResults(result)) {
            ResultElement resultElement = returnParameterResult.getValue();
            ArrayList elements = Lists.newArrayList();
            if (resultElement.isResultCollection()) {
                Iterables.addAll((Collection)elements, (Iterable)resultElement.getAsCollection());
            } else {
                elements.add(resultElement);
            }
            for (ResultElement element : elements) {
                if (!element.isResultObject()) continue;
                MessageResultReader.addMessageToResult(result, (AbstractRemoteFunctionQueryResult.MessageResult)element.getAsObject().as(AbstractRemoteFunctionQueryResult.MessageResult.class));
            }
        }
        return (QueryResultT)result;
    }

    @ConstructorProperties(value={"resultType"})
    JsonRemoteFunctionQuerySerializer(Class<QueryResultT> resultType) {
        this.resultType = resultType;
    }
}

