/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.rfc;

import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.s4hana.connectivity.ErpEndpoint;
import com.sap.cloud.sdk.s4hana.connectivity.QueryExecutor;
import com.sap.cloud.sdk.s4hana.connectivity.exception.QueryExecutionException;
import com.sap.cloud.sdk.s4hana.connectivity.exception.QuerySerializationException;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionQuery;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionQueryResult;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.BapiQuery;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.JsonRemoteFunctionQuerySerializer;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.QueryNotifier;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.RemoteFunctionErrorHandler;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.RfcQuery;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import org.slf4j.Logger;

class JsonRemoteFunctionQueryExecutor<QueryT extends AbstractRemoteFunctionQuery<QueryT, QueryResultT>, QueryResultT extends AbstractRemoteFunctionQueryResult<QueryT, QueryResultT>>
implements QueryExecutor<QueryT, QueryResultT> {
    private static final Logger logger = CloudLoggerFactory.getLogger(JsonRemoteFunctionQueryExecutor.class);
    private final Class<QueryResultT> resultType;

    public QueryResultT execute(QueryT query, ErpEndpoint erpEndpoint) throws QuerySerializationException, QueryExecutionException {
        if (query instanceof BapiQuery) {
            erpEndpoint.assertMinInterfaceVersion(5);
        } else if (query instanceof RfcQuery) {
            erpEndpoint.assertMinInterfaceVersion(11);
        }
        QueryNotifier.notifyQueryListeners(query, erpEndpoint.getDestinationName(), logger);
        JsonRemoteFunctionQuerySerializer serializer = new JsonRemoteFunctionQuerySerializer(this.resultType);
        AbstractRemoteFunctionQueryResult result = (AbstractRemoteFunctionQueryResult)erpEndpoint.executeQuery(query, serializer);
        if (result.hasFailed()) {
            new RemoteFunctionErrorHandler().handle(result);
        }
        if (logger.isInfoEnabled()) {
            ArrayList<AbstractRemoteFunctionQueryResult.Result> resultList = result.getResultList();
            logger.info(query.getClass().getSimpleName() + " " + ((AbstractRemoteFunctionQuery)((Object)query)).getConstructedByMethod() + " successfully returned " + (resultList == null ? " a null result." : resultList.size() + " result(s)."));
        }
        return (QueryResultT)result;
    }

    @ConstructorProperties(value={"resultType"})
    JsonRemoteFunctionQueryExecutor(Class<QueryResultT> resultType) {
        this.resultType = resultType;
    }
}

