/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.rfc;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.sap.cloud.sdk.result.GsonResultElementFactory;
import com.sap.cloud.sdk.result.ResultElement;
import com.sap.cloud.sdk.s4hana.connectivity.ErpEndpoint;
import com.sap.cloud.sdk.s4hana.connectivity.ErpEndpointMonitor;
import com.sap.cloud.sdk.s4hana.connectivity.ErpTypeSerializer;
import com.sap.cloud.sdk.s4hana.connectivity.QueryExecutor;
import com.sap.cloud.sdk.s4hana.connectivity.exception.QueryExecutionException;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionQuery;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionQueryResult;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.MessageResultReader;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Parameter;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.ParameterType;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.RemoteFunctionErrorHandler;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.RemoteFunctionGsonBuilder;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.RemoteFunctionQueryResultFactory;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Value;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.ValueType;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.exception.RemoteFunctionException;
import com.sap.cloud.sdk.s4hana.serialization.LocalDateConverter;
import com.sap.cloud.sdk.s4hana.serialization.LocalTimeConverter;
import com.sap.conn.jco.AbapException;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoDestinationManager;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoField;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoParameterList;
import com.sap.conn.jco.JCoRecordFieldIterator;
import com.sap.conn.jco.JCoRepository;
import com.sap.conn.jco.JCoStructure;
import com.sap.conn.jco.JCoTable;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nullable;
import lombok.NonNull;

class JCoRemoteFunctionQueryExecutor<QueryT extends AbstractRemoteFunctionQuery<QueryT, QueryResultT>, QueryResultT extends AbstractRemoteFunctionQueryResult<QueryT, QueryResultT>>
implements QueryExecutor<QueryT, QueryResultT> {
    @NonNull
    private final RemoteFunctionQueryResultFactory<QueryResultT> queryResultFactory;
    private final ErpTypeSerializer erpTypeSerializer = new ErpTypeSerializer();

    @Nullable
    private JsonElement toJsonPrimitive(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return new JsonPrimitive((Boolean)value);
        }
        if (value instanceof Number) {
            return new JsonPrimitive((Number)value);
        }
        if (value instanceof Character) {
            return new JsonPrimitive((Character)value);
        }
        return new JsonPrimitive(value.toString());
    }

    private JsonObject toJsonObject(JCoStructure structure) {
        JsonObject jsonObject = new JsonObject();
        JCoRecordFieldIterator it = structure.getRecordFieldIterator();
        while (it.hasNextField()) {
            JCoField nestedField = it.nextField();
            JsonElement nested = this.toJsonElement(nestedField);
            jsonObject.add(nestedField.getName(), nested);
        }
        return jsonObject;
    }

    private JsonArray toJsonArray(JCoTable table) {
        JsonArray jsonArray = new JsonArray();
        for (int rowId = 0; rowId < table.getNumRows(); ++rowId) {
            table.setRow(rowId);
            JsonObject jsonObject = new JsonObject();
            JCoRecordFieldIterator it = table.getRecordFieldIterator();
            while (it.hasNextField()) {
                JCoField nestedField = it.nextField();
                JsonElement nested = this.toJsonElement(nestedField);
                jsonObject.add(nestedField.getName(), nested);
            }
            jsonArray.add((JsonElement)jsonObject);
        }
        return jsonArray;
    }

    @Nullable
    private JsonElement toJsonElement(JCoField field) {
        if (field.isStructure()) {
            return this.toJsonObject(field.getStructure());
        }
        if (field.isTable()) {
            return this.toJsonArray(field.getTable());
        }
        return this.toJsonPrimitive(field.getValue());
    }

    private AbstractRemoteFunctionQueryResult.Result newResult(JCoField field, GsonResultElementFactory resultElementFactory) {
        return new AbstractRemoteFunctionQueryResult.Result(field.getName(), resultElementFactory.create(this.toJsonElement(field)));
    }

    public QueryResultT execute(QueryT query, ErpEndpoint erpEndpoint) throws QueryExecutionException {
        try {
            JCoDestination destination = JCoDestinationManager.getDestination((String)erpEndpoint.getDestinationName());
            JCoRepository repository = destination.getRepository();
            JCoFunction function = repository.getFunction(((AbstractRemoteFunctionQuery)((Object)query)).getFunctionName());
            block13: for (Parameter<?> parameter : ((AbstractRemoteFunctionQuery)((Object)query)).getParametersByName().values()) {
                JCoParameterList parameterList;
                ParameterType parameterType = parameter.getParameterType();
                ValueType valueType = parameter.getValueType();
                switch (parameterType) {
                    case EXPORTING: {
                        parameterList = function.getImportParameterList();
                        break;
                    }
                    case IMPORTING: {
                        parameterList = function.getExportParameterList();
                        break;
                    }
                    case TABLES: {
                        parameterList = function.getTableParameterList();
                        break;
                    }
                    case CHANGING: {
                        parameterList = function.getChangingParameterList();
                        break;
                    }
                    default: {
                        continue block13;
                    }
                }
                if (parameterList == null) continue;
                switch (valueType) {
                    case FIELD: {
                        parameterList.setValue(parameter.getName(), (String)this.erpTypeSerializer.toErp(parameter.getValue()).get());
                        break;
                    }
                    case TABLE: {
                        JCoTable table = parameterList.getTable(parameter.getName());
                        if (parameter.getValueList() == null) break;
                        int currentRowId = 0;
                        for (Value<?> value : parameter.getValueList()) {
                            if (value.getRowId() > currentRowId) {
                                currentRowId = value.getRowId();
                                table.appendRow();
                            }
                            table.setValue(value.getName(), (String)this.erpTypeSerializer.toErp(value.getValue()).get());
                        }
                        continue block13;
                    }
                    case STRUCTURE: {
                        JCoStructure structure = parameterList.getStructure(parameter.getName());
                        if (parameter.getValueList() == null) break;
                        for (Value<?> value : parameter.getValueList()) {
                            structure.setValue(value.getName(), (String)this.erpTypeSerializer.toErp(value.getValue()).get());
                        }
                        continue block13;
                    }
                }
            }
            ErpEndpointMonitor.getInstance().incrementErpQueryCount(query);
            function.execute(destination);
            QueryResultT queryResult = this.queryResultFactory.create();
            ((AbstractRemoteFunctionQueryResult)queryResult).setQuery(query);
            ArrayList resultList = Lists.newArrayList();
            ArrayList typeConverters = Lists.newArrayList(((AbstractRemoteFunctionQuery)((Object)query)).getTypeConverters());
            typeConverters.add(new LocalDateConverter("EEE MMM dd HH:mm:ss zzz yyyy"));
            typeConverters.add(new LocalTimeConverter("EEE MMM dd HH:mm:ss zzz yyyy"));
            GsonResultElementFactory resultElementFactory = new GsonResultElementFactory(RemoteFunctionGsonBuilder.newJCoQueryResultGsonBuilder(typeConverters));
            JCoParameterList exportParameterList = function.getExportParameterList();
            JCoParameterList importParameterList = function.getImportParameterList();
            JCoParameterList changingParameterList = function.getChangingParameterList();
            JCoParameterList tableParameterList = function.getTableParameterList();
            AbapException[] exceptionList = function.getExceptionList();
            if (exportParameterList != null) {
                for (JCoField field : exportParameterList) {
                    resultList.add(this.newResult(field, resultElementFactory));
                }
            }
            if (importParameterList != null) {
                for (JCoField field : importParameterList) {
                    resultList.add(this.newResult(field, resultElementFactory));
                }
            }
            if (changingParameterList != null) {
                for (JCoField field : changingParameterList) {
                    resultList.add(this.newResult(field, resultElementFactory));
                }
            }
            if (tableParameterList != null) {
                for (JCoField field : tableParameterList) {
                    resultList.add(this.newResult(field, resultElementFactory));
                }
            }
            ((AbstractRemoteFunctionQueryResult)queryResult).setResultList(resultList);
            for (AbstractRemoteFunctionQueryResult.Result returnParameterResult : this.getReturnParameterResults(queryResult)) {
                ResultElement resultElement = returnParameterResult.getValue();
                ArrayList elements = Lists.newArrayList();
                if (resultElement.isResultCollection()) {
                    Iterables.addAll((Collection)elements, (Iterable)resultElement.getAsCollection());
                } else {
                    elements.add(resultElement);
                }
                for (ResultElement element : elements) {
                    if (!element.isResultObject()) continue;
                    MessageResultReader.addMessageToResult(queryResult, (AbstractRemoteFunctionQueryResult.MessageResult)element.getAsObject().as(AbstractRemoteFunctionQueryResult.MessageResult.class));
                }
            }
            if (((AbstractRemoteFunctionQueryResult)queryResult).hasFailed()) {
                new RemoteFunctionErrorHandler().handle(queryResult);
            }
            return queryResult;
        }
        catch (JCoException e) {
            throw new RemoteFunctionException(e);
        }
    }

    protected List<AbstractRemoteFunctionQueryResult.Result> getReturnParameterResults(QueryResultT result) {
        LinkedHashSet<String> returnParameterNames = ((AbstractRemoteFunctionQuery)((Object)((AbstractRemoteFunctionQueryResult)result).getQuery())).getReturnParameterNames();
        ArrayList returnParameterResults = Lists.newArrayList();
        ArrayList<AbstractRemoteFunctionQueryResult.Result> resultList = ((AbstractRemoteFunctionQueryResult)result).getResultList();
        if (resultList != null) {
            for (AbstractRemoteFunctionQueryResult.Result resultItem : resultList) {
                if (!returnParameterNames.contains(resultItem.getName())) continue;
                returnParameterResults.add(resultItem);
            }
        }
        return returnParameterResults;
    }

    @ConstructorProperties(value={"queryResultFactory"})
    public JCoRemoteFunctionQueryExecutor(@NonNull RemoteFunctionQueryResultFactory<QueryResultT> queryResultFactory) {
        if (queryResultFactory == null) {
            throw new NullPointerException("queryResultFactory");
        }
        this.queryResultFactory = queryResultFactory;
    }
}

