/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.rfc;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.RemoteFunctionErrorMapper;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.RemoteFunctionExceptionPriority;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.exception.AccessDeniedExceptionFactory;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.exception.InvalidParameterExceptionFactory;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.exception.MissingErpConfigurationExceptionFactory;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.exception.MissingParameterFactory;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.exception.NotImplementedExceptionFactory;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.exception.ParameterNotFoundFactory;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.exception.RemoteFunctionExceptionFactory;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.exception.WrongCustomizingExceptionFactory;
import com.sap.cloud.sdk.s4hana.serialization.MessageClass;
import com.sap.cloud.sdk.s4hana.serialization.MessageNumber;
import com.sap.cloud.sdk.s4hana.serialization.RemoteFunctionError;
import java.util.Map;

class DefaultRemoteFunctionErrorMapper
implements RemoteFunctionErrorMapper {
    private final Map<RemoteFunctionError, RemoteFunctionExceptionFactory<?>> errorToException = Maps.newHashMap();
    private final Map<RemoteFunctionError, RemoteFunctionExceptionPriority> errorToPriority = Maps.newHashMap();

    @Override
    public Map<RemoteFunctionError, RemoteFunctionExceptionFactory<?>> getMapping() {
        return this.errorToException;
    }

    @Override
    public Map<RemoteFunctionError, RemoteFunctionExceptionPriority> getPriorities() {
        return this.errorToPriority;
    }

    public DefaultRemoteFunctionErrorMapper() {
        this.addMapping(MessageClass.KI, new MessageNumber("280"), new RemoteFunctionExceptionPriority(1), new ParameterNotFoundFactory("account"));
        this.addMapping(MessageClass.BK, new MessageNumber("031"), new RemoteFunctionExceptionPriority(3), new MissingParameterFactory(null));
        this.addMapping(MessageClass.KI, new MessageNumber("222"), new RemoteFunctionExceptionPriority(1), new ParameterNotFoundFactory("cost center"));
        this.addMapping(MessageClass.KI, new MessageNumber("235"), new RemoteFunctionExceptionPriority(1), new ParameterNotFoundFactory("CO object"));
        this.addMapping(MessageClass.BK, new MessageNumber("048"), new RemoteFunctionExceptionPriority(3), new MissingParameterFactory(null));
        this.addMapping(MessageClass.BK, new MessageNumber("057"), new RemoteFunctionExceptionPriority(1), new MissingParameterFactory("activity prices"));
        this.addMapping(MessageClass.F5, new MessageNumber("814"), new RemoteFunctionExceptionPriority(1), new ParameterNotFoundFactory("document type"));
        this.addMapping(MessageClass.SG, new MessageNumber("105"), new RemoteFunctionExceptionPriority(1), new MissingParameterFactory("rate"));
        this.addMapping(MessageClass.KI, new MessageNumber("154"), new RemoteFunctionExceptionPriority(2), new MissingParameterFactory("cost center"));
        this.addMapping(MessageClass.BM, new MessageNumber("312"), new RemoteFunctionExceptionPriority(1), new ParameterNotFoundFactory("unit"));
        this.addMapping(MessageClass.BM, new MessageNumber("311"), new RemoteFunctionExceptionPriority(2), new InvalidParameterExceptionFactory("unit"));
        this.addMapping(MessageClass.KI, new MessageNumber("101"), new RemoteFunctionExceptionPriority(1), new ParameterNotFoundFactory("controlling area"));
        this.addMapping(MessageClass.KI, new MessageNumber("152"), new RemoteFunctionExceptionPriority(1), new MissingParameterFactory("activity type"));
        this.addMapping(MessageClass.BK, new MessageNumber("025"), new RemoteFunctionExceptionPriority(1), new MissingParameterFactory("quantity"));
        this.addMapping(MessageClass.KW, new MessageNumber("407"), new RemoteFunctionExceptionPriority(1), new MissingParameterFactory("activity prices"));
        this.addMapping(MessageClass.FAGL_LEDGER_CUST, new MessageNumber("025"), new RemoteFunctionExceptionPriority(2), new ParameterNotFoundFactory("ledger group"));
        this.addMapping(MessageClass.BAPI4499, new MessageNumber("005"), new RemoteFunctionExceptionPriority(1), new MissingParameterFactory("bank statement date"));
        this.addMapping(MessageClass.BAPI4499, new MessageNumber("005"), new RemoteFunctionExceptionPriority(1), new MissingParameterFactory("bank statement date"));
        this.addMapping(MessageClass.B1, new MessageNumber("537"), new RemoteFunctionExceptionPriority(1), new MissingParameterFactory("bank statement currency"));
        this.addMapping(MessageClass.AA, new MessageNumber("040"), new RemoteFunctionExceptionPriority(1), new NotImplementedExceptionFactory("this feature is not enabled for FIN Cloud API 1702"));
        this.addMapping(MessageClass.AA, new MessageNumber("072"), new RemoteFunctionExceptionPriority(1), new AccessDeniedExceptionFactory("company code"));
        this.addMapping(MessageClass.AA, new MessageNumber("073"), new RemoteFunctionExceptionPriority(1), new AccessDeniedExceptionFactory("company code"));
        this.addMapping(MessageClass.AA, new MessageNumber("074"), new RemoteFunctionExceptionPriority(1), new AccessDeniedExceptionFactory("company code"));
        this.addMapping(MessageClass.AA, new MessageNumber("075"), new RemoteFunctionExceptionPriority(1), new AccessDeniedExceptionFactory("company code"));
        this.addMapping(MessageClass.F5, new MessageNumber("083"), new RemoteFunctionExceptionPriority(1), new AccessDeniedExceptionFactory("company code"));
        this.addMapping(MessageClass.AA, new MessageNumber("882"), new RemoteFunctionExceptionPriority(1), new AccessDeniedExceptionFactory("company code"));
        this.addMapping(MessageClass.AA, new MessageNumber("883"), new RemoteFunctionExceptionPriority(1), new AccessDeniedExceptionFactory("company code"));
        this.addMapping(MessageClass.AA, new MessageNumber("888"), new RemoteFunctionExceptionPriority(1), new AccessDeniedExceptionFactory("company code"));
        this.addMapping(MessageClass.AA, new MessageNumber("001"), new RemoteFunctionExceptionPriority(1), new ParameterNotFoundFactory("asset"));
        this.addMapping(MessageClass.BAPI1022, new MessageNumber("021"), new RemoteFunctionExceptionPriority(1), new InvalidParameterExceptionFactory("selection field"));
        this.addMapping(MessageClass.BAPI1022, new MessageNumber("003"), new RemoteFunctionExceptionPriority(1), new InvalidParameterExceptionFactory("master data field"));
        this.addMapping(MessageClass.BAPI1022, new MessageNumber("004"), new RemoteFunctionExceptionPriority(1), new InvalidParameterExceptionFactory("depreciation area field"));
        this.addMapping(MessageClass.BAPI1022, new MessageNumber("005"), new RemoteFunctionExceptionPriority(1), new ParameterNotFoundFactory("depreciation area"));
        this.addMapping(MessageClass.FDC_POSTING_001, new MessageNumber("128"), new RemoteFunctionExceptionPriority(1), new MissingErpConfigurationExceptionFactory("workflow not enabled"));
        this.addMapping(MessageClass.KI, new MessageNumber("591"), new RemoteFunctionExceptionPriority(1), new AccessDeniedExceptionFactory("controlling area"));
        this.addMapping(MessageClass.KE, new MessageNumber("081"), new RemoteFunctionExceptionPriority(1), new WrongCustomizingExceptionFactory("operating concern"));
    }

    private void addMapping(MessageClass messageClass, MessageNumber messageNumber, RemoteFunctionExceptionPriority priority, RemoteFunctionExceptionFactory<?> exceptionFactory) {
        RemoteFunctionError error = new RemoteFunctionError(messageClass, messageNumber);
        this.errorToException.put(error, exceptionFactory);
        this.errorToPriority.put(error, priority);
    }
}

