/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.rfc;

import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationType;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.s4hana.connectivity.ErpEndpoint;
import com.sap.cloud.sdk.s4hana.connectivity.Query;
import com.sap.cloud.sdk.s4hana.connectivity.exception.QueryExecutionException;
import com.sap.cloud.sdk.s4hana.connectivity.exception.QuerySerializationException;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionQuery;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.BapiQueryResult;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.BapiQueryResultFactory;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Fields;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.ParameterFields;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.RemoteFunctionQueryExecutorFactory;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.RfcQuery;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Table;
import com.sap.cloud.sdk.s4hana.serialization.ErpType;
import com.sap.cloud.sdk.s4hana.serialization.ErpTypeConverter;
import com.sap.cloud.sdk.s4hana.types.Year;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.slf4j.Logger;

public class BapiQuery
extends AbstractRemoteFunctionQuery<BapiQuery, BapiQueryResult> {
    private static final Logger logger = CloudLoggerFactory.getLogger(BapiQuery.class);
    private final DynamicStringProperty serializationStrategy = DynamicPropertyFactory.getInstance().getStringProperty("s4hana.bapi.serializationStrategy", "soap");

    public BapiQueryResult execute(ErpEndpoint erpEndpoint) throws QuerySerializationException, QueryExecutionException {
        DestinationType destinationType = DestinationAccessor.getDestinationType((String)erpEndpoint.getDestinationName());
        return (BapiQueryResult)new RemoteFunctionQueryExecutorFactory(new BapiQueryResultFactory(), destinationType, this.serializationStrategy).create().execute((Query)this, erpEndpoint);
    }

    @Override
    protected BapiQuery instance() {
        return this;
    }

    public BapiQuery(String functionName) throws IllegalArgumentException {
        super(functionName, true, Thread.currentThread().getStackTrace()[2].toString());
        this.assertFunctionIsBapi(functionName);
    }

    public BapiQuery(String functionName, boolean commit) throws IllegalArgumentException {
        super(functionName, commit, Thread.currentThread().getStackTrace()[2].toString());
        this.assertFunctionIsBapi(functionName);
    }

    private void assertFunctionIsBapi(String functionName) throws IllegalArgumentException {
        if (!StringUtils.startsWithIgnoreCase((CharSequence)functionName, (CharSequence)"bapi")) {
            throw new IllegalArgumentException("The given function \"" + functionName + "\" is not a valid BAPI. For calling remote-enabled functions, use " + RfcQuery.class.getSimpleName() + " instead.");
        }
    }

    public BapiQuery withTypeConverters(Iterable<ErpTypeConverter<?>> typeConverters) {
        return (BapiQuery)super.withTypeConverters(typeConverters);
    }

    public BapiQuery withTypeConverters(ErpTypeConverter<?> ... typeConverters) {
        return (BapiQuery)super.withTypeConverters(typeConverters);
    }

    public BapiQuery withExporting(String name, String dataType) {
        return (BapiQuery)super.withExporting(name, dataType);
    }

    public <T extends ErpType<T>> BapiQuery withExporting(String name, String dataType, T value) {
        return (BapiQuery)super.withExporting(name, dataType, value);
    }

    public <T> BapiQuery withExporting(String name, String dataType, T value, ErpTypeConverter<T> typeConverter) {
        return (BapiQuery)super.withExporting(name, dataType, value, typeConverter);
    }

    public BapiQuery withExporting(String name, String dataType, Boolean value) {
        return (BapiQuery)super.withExporting(name, dataType, value);
    }

    public BapiQuery withExporting(String name, String dataType, Byte value) {
        return (BapiQuery)super.withExporting(name, dataType, value);
    }

    public BapiQuery withExporting(String name, String dataType, Character value) {
        return (BapiQuery)super.withExporting(name, dataType, value);
    }

    public BapiQuery withExporting(String name, String dataType, String value) {
        return (BapiQuery)super.withExporting(name, dataType, value);
    }

    public BapiQuery withExporting(String name, String dataType, Short value) {
        return (BapiQuery)super.withExporting(name, dataType, value);
    }

    public BapiQuery withExporting(String name, String dataType, Integer value) {
        return (BapiQuery)super.withExporting(name, dataType, value);
    }

    public BapiQuery withExporting(String name, String dataType, Long value) {
        return (BapiQuery)super.withExporting(name, dataType, value);
    }

    public BapiQuery withExporting(String name, String dataType, Float value) {
        return (BapiQuery)super.withExporting(name, dataType, value);
    }

    public BapiQuery withExporting(String name, String dataType, Double value) {
        return (BapiQuery)super.withExporting(name, dataType, value);
    }

    public BapiQuery withExporting(String name, String dataType, BigInteger value) {
        return (BapiQuery)super.withExporting(name, dataType, value);
    }

    public BapiQuery withExporting(String name, String dataType, BigDecimal value) {
        return (BapiQuery)super.withExporting(name, dataType, value);
    }

    public BapiQuery withExporting(String name, String dataType, Locale value) {
        return (BapiQuery)super.withExporting(name, dataType, value);
    }

    public BapiQuery withExporting(String name, String dataType, Year value) {
        return (BapiQuery)super.withExporting(name, dataType, value);
    }

    public BapiQuery withExporting(String name, String dataType, LocalDate value) {
        return (BapiQuery)super.withExporting(name, dataType, value);
    }

    public BapiQuery withExporting(String name, String dataType, LocalTime value) {
        return (BapiQuery)super.withExporting(name, dataType, value);
    }

    @Override
    public ParameterFields<BapiQuery> withExportingFields(String name, String dataType) {
        return super.withExportingFields(name, dataType);
    }

    public BapiQuery withExportingFields(String name, String dataType, Fields fields) {
        return (BapiQuery)super.withExportingFields(name, dataType, fields);
    }

    @Override
    public Table<BapiQuery> withExportingTable(String name, String dataType) {
        return super.withExportingTable(name, dataType);
    }

    public BapiQuery withImporting(String name, String dataType) {
        return (BapiQuery)super.withImporting(name, dataType);
    }

    public <T extends ErpType<T>> BapiQuery withImporting(String name, String dataType, T value) {
        return (BapiQuery)super.withImporting(name, dataType, value);
    }

    public <T> BapiQuery withImporting(String name, String dataType, T value, ErpTypeConverter<T> typeConverter) {
        return (BapiQuery)super.withImporting(name, dataType, value, typeConverter);
    }

    public BapiQuery withImporting(String name, String dataType, Boolean value) {
        return (BapiQuery)super.withImporting(name, dataType, value);
    }

    public BapiQuery withImporting(String name, String dataType, Byte value) {
        return (BapiQuery)super.withImporting(name, dataType, value);
    }

    public BapiQuery withImporting(String name, String dataType, Character value) {
        return (BapiQuery)super.withImporting(name, dataType, value);
    }

    public BapiQuery withImporting(String name, String dataType, String value) {
        return (BapiQuery)super.withImporting(name, dataType, value);
    }

    public BapiQuery withImporting(String name, String dataType, Short value) {
        return (BapiQuery)super.withImporting(name, dataType, value);
    }

    public BapiQuery withImporting(String name, String dataType, Integer value) {
        return (BapiQuery)super.withImporting(name, dataType, value);
    }

    public BapiQuery withImporting(String name, String dataType, Long value) {
        return (BapiQuery)super.withImporting(name, dataType, value);
    }

    public BapiQuery withImporting(String name, String dataType, Float value) {
        return (BapiQuery)super.withImporting(name, dataType, value);
    }

    public BapiQuery withImporting(String name, String dataType, Double value) {
        return (BapiQuery)super.withImporting(name, dataType, value);
    }

    public BapiQuery withImporting(String name, String dataType, BigInteger value) {
        return (BapiQuery)super.withImporting(name, dataType, value);
    }

    public BapiQuery withImporting(String name, String dataType, BigDecimal value) {
        return (BapiQuery)super.withImporting(name, dataType, value);
    }

    public BapiQuery withImporting(String name, String dataType, Locale value) {
        return (BapiQuery)super.withImporting(name, dataType, value);
    }

    public BapiQuery withImporting(String name, String dataType, Year value) {
        return (BapiQuery)super.withImporting(name, dataType, value);
    }

    public BapiQuery withImporting(String name, String dataType, LocalDate value) {
        return (BapiQuery)super.withImporting(name, dataType, value);
    }

    public BapiQuery withImporting(String name, String dataType, LocalTime value) {
        return (BapiQuery)super.withImporting(name, dataType, value);
    }

    @Override
    public ParameterFields<BapiQuery> withImportingFields(String name, String dataType) {
        return super.withImportingFields(name, dataType);
    }

    public BapiQuery withImportingFields(String name, String dataType, Fields fields) {
        return (BapiQuery)super.withImportingFields(name, dataType, fields);
    }

    @Override
    public Table<BapiQuery> withImportingTable(String name, String dataType) {
        return super.withImportingTable(name, dataType);
    }

    public BapiQuery withImportingAsReturn(String dataType) {
        return (BapiQuery)super.withImportingAsReturn(dataType);
    }

    public BapiQuery withImportingAsReturn(String name, String dataType) {
        return (BapiQuery)super.withImportingAsReturn(name, dataType);
    }

    @Override
    public Table<BapiQuery> withTable(String name, String dataType) {
        return super.withTable(name, dataType);
    }

    public BapiQuery withTableAsReturn(String dataType) {
        return (BapiQuery)super.withTableAsReturn(dataType);
    }

    public BapiQuery withTableAsReturn(String name, String dataType) {
        return (BapiQuery)super.withTableAsReturn(name, dataType);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BapiQuery)) {
            return false;
        }
        BapiQuery other = (BapiQuery)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DynamicStringProperty this$serializationStrategy = this.serializationStrategy;
        DynamicStringProperty other$serializationStrategy = other.serializationStrategy;
        return !(this$serializationStrategy == null ? other$serializationStrategy != null : !this$serializationStrategy.equals(other$serializationStrategy));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BapiQuery;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        DynamicStringProperty $serializationStrategy = this.serializationStrategy;
        result = result * 59 + ($serializationStrategy == null ? 43 : $serializationStrategy.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "BapiQuery(super=" + super.toString() + ", serializationStrategy=" + this.serializationStrategy + ")";
    }
}

