/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.rfc;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.result.CollectedResultCollection;
import com.sap.cloud.sdk.result.DefaultCollectedResultCollection;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.result.ResultElement;
import com.sap.cloud.sdk.s4hana.connectivity.Query;
import com.sap.cloud.sdk.s4hana.connectivity.QueryResult;
import com.sap.cloud.sdk.s4hana.serialization.MessageClass;
import com.sap.cloud.sdk.s4hana.serialization.MessageNumber;
import com.sap.cloud.sdk.s4hana.serialization.MessageType;
import com.sap.cloud.sdk.s4hana.serialization.RemoteFunctionMessage;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.slf4j.Logger;

abstract class AbstractRemoteFunctionQueryResult<QueryT extends Query<QueryT, QueryResultT>, QueryResultT extends AbstractRemoteFunctionQueryResult<QueryT, QueryResultT>>
implements QueryResult<QueryT, QueryResultT>,
Iterable<ResultElement> {
    private static final Logger logger = CloudLoggerFactory.getLogger(AbstractRemoteFunctionQueryResult.class);
    private QueryT query;
    @Nullable
    @ElementName(value="RESULT")
    private ArrayList<Result> resultList;
    @Nullable
    @ElementName(value="EXCEPTION")
    private ExceptionResult exception;
    private final List<RemoteFunctionMessage> successMessages = Lists.newArrayList();
    private final List<RemoteFunctionMessage> informationMessages = Lists.newArrayList();
    private final List<RemoteFunctionMessage> warningMessages = Lists.newArrayList();
    private final List<RemoteFunctionMessage> errorMessages = Lists.newArrayList();

    AbstractRemoteFunctionQueryResult() {
    }

    void addSuccessMessage(RemoteFunctionMessage successMessage) {
        this.successMessages.add(successMessage);
    }

    void addInformationMessage(RemoteFunctionMessage informationMessage) {
        this.informationMessages.add(informationMessage);
    }

    void addWarningMessage(RemoteFunctionMessage warningMessage) {
        this.warningMessages.add(warningMessage);
    }

    void addErrorMessage(RemoteFunctionMessage errorMessage) {
        this.errorMessages.add(errorMessage);
    }

    public boolean hasSuccessMessages() {
        return this.successMessages != null && !this.successMessages.isEmpty();
    }

    public boolean hasInformationMessages() {
        return this.informationMessages != null && !this.informationMessages.isEmpty();
    }

    public boolean hasWarningMessages() {
        return this.warningMessages != null && !this.warningMessages.isEmpty();
    }

    public boolean hasFailed() {
        return !this.wasSuccessful();
    }

    public boolean wasSuccessful() {
        return !this.hasErrorMessages();
    }

    public boolean hasErrorMessages() {
        return this.errorMessages != null && !this.errorMessages.isEmpty();
    }

    private ResultElement newResultElement(Result result) {
        return result.getValue();
    }

    public int size() {
        if (this.resultList == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Result list is null, returning 0 for size().");
            }
            return 0;
        }
        return this.resultList.size();
    }

    public boolean isEmpty() {
        if (this.resultList == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Result list is null, returning true for isEmpty().");
            }
            return true;
        }
        return this.resultList.isEmpty();
    }

    public boolean has(String elementName) {
        return this.getIfPresent(elementName).isPresent();
    }

    public Optional<ResultElement> getIfPresent(String elementName) throws IllegalArgumentException {
        ResultElement resultElement = this.getResultElement(elementName);
        if (resultElement == null) {
            return Optional.absent();
        }
        return Optional.of((Object)resultElement);
    }

    @Nullable
    private ResultElement getResultElement(String elementName) throws IllegalArgumentException {
        if (this.resultList == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Result list is null, returning null element.");
            }
            return null;
        }
        for (Result result : this.resultList) {
            if (!elementName.equals(result.getName())) continue;
            return result.getValue();
        }
        return null;
    }

    public ResultElement get(int index) throws IndexOutOfBoundsException {
        if (this.resultList == null) {
            throw new IndexOutOfBoundsException("Failed to return element: result list is null.");
        }
        return this.resultList.get(index).getValue();
    }

    public ResultElement get(String elementName) throws IllegalArgumentException {
        Optional<ResultElement> resultElement = this.getIfPresent(elementName);
        if (!resultElement.isPresent()) {
            throw new IllegalArgumentException("Unable to find element with name \"" + elementName + "\".");
        }
        return (ResultElement)resultElement.get();
    }

    public CollectedResultCollection collect(String elementName) {
        if (this.resultList == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Result list is null, returning null element.");
            }
            return null;
        }
        return new DefaultCollectedResultCollection(elementName, this.getResultElements());
    }

    public ArrayList<ResultElement> getResultElements() {
        if (this.resultList == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Result list is null, returning empty list of elements.");
            }
            return Lists.newArrayList();
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)this.resultList.size());
        for (Result currentResult : this.resultList) {
            result.add(currentResult.getValue());
        }
        return result;
    }

    @Override
    public Iterator<ResultElement> iterator() {
        return new ResultElementIterator();
    }

    public String toString() {
        return "AbstractRemoteFunctionQueryResult(query=" + this.getQuery() + ", resultList=" + this.getResultList() + ", exception=" + this.getException() + ", successMessages=" + this.getSuccessMessages() + ", informationMessages=" + this.getInformationMessages() + ", warningMessages=" + this.getWarningMessages() + ", errorMessages=" + this.getErrorMessages() + ")";
    }

    public QueryT getQuery() {
        return this.query;
    }

    void setQuery(QueryT query) {
        this.query = query;
    }

    @Nullable
    ArrayList<Result> getResultList() {
        return this.resultList;
    }

    void setResultList(@Nullable ArrayList<Result> resultList) {
        this.resultList = resultList;
    }

    @Nullable
    ExceptionResult getException() {
        return this.exception;
    }

    void setException(@Nullable ExceptionResult exception) {
        this.exception = exception;
    }

    public List<RemoteFunctionMessage> getSuccessMessages() {
        return this.successMessages;
    }

    public List<RemoteFunctionMessage> getInformationMessages() {
        return this.informationMessages;
    }

    public List<RemoteFunctionMessage> getWarningMessages() {
        return this.warningMessages;
    }

    public List<RemoteFunctionMessage> getErrorMessages() {
        return this.errorMessages;
    }

    private class ResultElementIterator
    implements Iterator<ResultElement> {
        private int index = 0;

        private ResultElementIterator() {
        }

        @Override
        public boolean hasNext() {
            if (AbstractRemoteFunctionQueryResult.this.resultList == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Result list is null, returning false for hasNext().");
                }
                return false;
            }
            return this.index < AbstractRemoteFunctionQueryResult.this.resultList.size();
        }

        @Override
        public ResultElement next() {
            if (AbstractRemoteFunctionQueryResult.this.resultList == null) {
                throw new NoSuchElementException("Cannot return next element, result list is null.");
            }
            return AbstractRemoteFunctionQueryResult.this.newResultElement((Result)AbstractRemoteFunctionQueryResult.this.resultList.get(this.index++));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove elements from remote function result.");
        }
    }

    static class ExceptionResult
    extends MessageResult {
        @ElementName(value="NAME")
        String name;
        @ElementName(value="VALUE")
        long parameterType;

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExceptionResult)) {
                return false;
            }
            ExceptionResult other = (ExceptionResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            return this.getParameterType() == other.getParameterType();
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ExceptionResult;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + super.hashCode();
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            long $parameterType = this.getParameterType();
            result = result * 59 + (int)($parameterType >>> 32 ^ $parameterType);
            return result;
        }

        public String getName() {
            return this.name;
        }

        public long getParameterType() {
            return this.parameterType;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setParameterType(long parameterType) {
            this.parameterType = parameterType;
        }

        @Override
        public String toString() {
            return "AbstractRemoteFunctionQueryResult.ExceptionResult(name=" + this.getName() + ", parameterType=" + this.getParameterType() + ")";
        }
    }

    static class MessageResult {
        @ElementName(value="TYPE")
        MessageType messageType;
        @ElementName(value="ID")
        MessageClass messageClass;
        @ElementName(value="NUMBER")
        MessageNumber messageNumber;
        @ElementName(value="MESSAGE")
        String messageText;
        @ElementName(value="MESSAGE_V1")
        String messageVariable1;
        @ElementName(value="MESSAGE_V2")
        String messageVariable2;
        @ElementName(value="MESSAGE_V3")
        String messageVariable3;
        @ElementName(value="MESSAGE_V4")
        String messageVariable4;

        public MessageType getMessageType() {
            return this.messageType;
        }

        public MessageClass getMessageClass() {
            return this.messageClass;
        }

        public MessageNumber getMessageNumber() {
            return this.messageNumber;
        }

        public String getMessageText() {
            return this.messageText;
        }

        public String getMessageVariable1() {
            return this.messageVariable1;
        }

        public String getMessageVariable2() {
            return this.messageVariable2;
        }

        public String getMessageVariable3() {
            return this.messageVariable3;
        }

        public String getMessageVariable4() {
            return this.messageVariable4;
        }

        public void setMessageType(MessageType messageType) {
            this.messageType = messageType;
        }

        public void setMessageClass(MessageClass messageClass) {
            this.messageClass = messageClass;
        }

        public void setMessageNumber(MessageNumber messageNumber) {
            this.messageNumber = messageNumber;
        }

        public void setMessageText(String messageText) {
            this.messageText = messageText;
        }

        public void setMessageVariable1(String messageVariable1) {
            this.messageVariable1 = messageVariable1;
        }

        public void setMessageVariable2(String messageVariable2) {
            this.messageVariable2 = messageVariable2;
        }

        public void setMessageVariable3(String messageVariable3) {
            this.messageVariable3 = messageVariable3;
        }

        public void setMessageVariable4(String messageVariable4) {
            this.messageVariable4 = messageVariable4;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageResult)) {
                return false;
            }
            MessageResult other = (MessageResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            MessageType this$messageType = this.getMessageType();
            MessageType other$messageType = other.getMessageType();
            if (this$messageType == null ? other$messageType != null : !this$messageType.equals(other$messageType)) {
                return false;
            }
            MessageClass this$messageClass = this.getMessageClass();
            MessageClass other$messageClass = other.getMessageClass();
            if (this$messageClass == null ? other$messageClass != null : !this$messageClass.equals(other$messageClass)) {
                return false;
            }
            MessageNumber this$messageNumber = this.getMessageNumber();
            MessageNumber other$messageNumber = other.getMessageNumber();
            if (this$messageNumber == null ? other$messageNumber != null : !this$messageNumber.equals(other$messageNumber)) {
                return false;
            }
            String this$messageText = this.getMessageText();
            String other$messageText = other.getMessageText();
            if (this$messageText == null ? other$messageText != null : !this$messageText.equals(other$messageText)) {
                return false;
            }
            String this$messageVariable1 = this.getMessageVariable1();
            String other$messageVariable1 = other.getMessageVariable1();
            if (this$messageVariable1 == null ? other$messageVariable1 != null : !this$messageVariable1.equals(other$messageVariable1)) {
                return false;
            }
            String this$messageVariable2 = this.getMessageVariable2();
            String other$messageVariable2 = other.getMessageVariable2();
            if (this$messageVariable2 == null ? other$messageVariable2 != null : !this$messageVariable2.equals(other$messageVariable2)) {
                return false;
            }
            String this$messageVariable3 = this.getMessageVariable3();
            String other$messageVariable3 = other.getMessageVariable3();
            if (this$messageVariable3 == null ? other$messageVariable3 != null : !this$messageVariable3.equals(other$messageVariable3)) {
                return false;
            }
            String this$messageVariable4 = this.getMessageVariable4();
            String other$messageVariable4 = other.getMessageVariable4();
            return !(this$messageVariable4 == null ? other$messageVariable4 != null : !this$messageVariable4.equals(other$messageVariable4));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MessageResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            MessageType $messageType = this.getMessageType();
            result = result * 59 + ($messageType == null ? 43 : $messageType.hashCode());
            MessageClass $messageClass = this.getMessageClass();
            result = result * 59 + ($messageClass == null ? 43 : $messageClass.hashCode());
            MessageNumber $messageNumber = this.getMessageNumber();
            result = result * 59 + ($messageNumber == null ? 43 : $messageNumber.hashCode());
            String $messageText = this.getMessageText();
            result = result * 59 + ($messageText == null ? 43 : $messageText.hashCode());
            String $messageVariable1 = this.getMessageVariable1();
            result = result * 59 + ($messageVariable1 == null ? 43 : $messageVariable1.hashCode());
            String $messageVariable2 = this.getMessageVariable2();
            result = result * 59 + ($messageVariable2 == null ? 43 : $messageVariable2.hashCode());
            String $messageVariable3 = this.getMessageVariable3();
            result = result * 59 + ($messageVariable3 == null ? 43 : $messageVariable3.hashCode());
            String $messageVariable4 = this.getMessageVariable4();
            result = result * 59 + ($messageVariable4 == null ? 43 : $messageVariable4.hashCode());
            return result;
        }

        public String toString() {
            return "AbstractRemoteFunctionQueryResult.MessageResult(messageType=" + this.getMessageType() + ", messageClass=" + this.getMessageClass() + ", messageNumber=" + this.getMessageNumber() + ", messageText=" + this.getMessageText() + ", messageVariable1=" + this.getMessageVariable1() + ", messageVariable2=" + this.getMessageVariable2() + ", messageVariable3=" + this.getMessageVariable3() + ", messageVariable4=" + this.getMessageVariable4() + ")";
        }
    }

    static class Result {
        @ElementName(value="NAME")
        private final String name;
        @ElementName(value="VALUE")
        private final ResultElement value;

        @ConstructorProperties(value={"name", "value"})
        public Result(String name, ResultElement value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public ResultElement getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Result)) {
                return false;
            }
            Result other = (Result)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            ResultElement this$value = this.getValue();
            ResultElement other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Result;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            ResultElement $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "AbstractRemoteFunctionQueryResult.Result(name=" + this.getName() + ", value=" + this.getValue() + ")";
        }
    }
}

