/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.s4hana.quality;

import com.sap.cloud.s4hana.quality.QualityListenerException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class FileWritingQueryListenerUtil {
    private static final String REPORTS_DIR = "../s4hana_pipeline/reports/service_audits";

    static boolean assureReportFolderExists() {
        boolean result;
        File baseDirAsFile = new File("../s4hana_pipeline/reports/service_audits/");
        if (!(baseDirAsFile.exists() || (result = baseDirAsFile.mkdirs()) || baseDirAsFile.exists())) {
            System.out.println("Error: Creating " + baseDirAsFile.getAbsolutePath() + " failed.");
            return false;
        }
        return true;
    }

    static Path uniqueReportPathFor(String type) {
        return Paths.get("../s4hana_pipeline/reports/service_audits/" + type + "_" + UUID.randomUUID() + ".log", new String[0]);
    }

    static void createEmptyFile(Path filepath) {
        try {
            Files.createFile(filepath, new FileAttribute[0]);
        }
        catch (IOException e) {
            System.out.println("Error: Creating file " + filepath + " failed with Exception: \n" + e);
        }
    }

    static void writeLine(Path filepath, List<String> lineItems) {
        String line = "";
        for (String lineItem : lineItems) {
            line = line + "\"" + lineItem.replaceAll("\"", "\"\"") + "\", ";
        }
        line = line.substring(0, line.length() - 2);
        try {
            Files.write(filepath, Collections.singletonList(line), Charset.forName("UTF-8"), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            throw new QualityListenerException(e);
        }
    }
}

