/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.frameworks.hystrix;

import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import com.sap.cloud.sdk.cloudplatform.security.user.UserAccessor;
import com.sap.cloud.sdk.cloudplatform.security.user.exception.UserNotAuthenticatedException;
import com.sap.cloud.sdk.cloudplatform.tenant.TenantAccessor;
import com.sap.cloud.sdk.cloudplatform.tenant.exception.TenantNotAvailableException;
import javax.annotation.Nullable;

public final class HystrixUtil {
    public static String getDelimiter() {
        return "#";
    }

    public static String getCommandKey(Class<?> commandClass, @Nullable String tenantId, @Nullable String userName) {
        if (tenantId != null && tenantId.contains(HystrixUtil.getDelimiter())) {
            throw new ShouldNotHappenException("A tenant identifier must not contain the delimiting character '" + HystrixUtil.getDelimiter() + "'.");
        }
        if (userName != null && userName.contains(HystrixUtil.getDelimiter())) {
            throw new ShouldNotHappenException("A user name must not contain the delimiting character '" + HystrixUtil.getDelimiter() + "'.");
        }
        return commandClass.getName() + HystrixUtil.getDelimiter() + "t=" + (tenantId != null ? tenantId : "") + HystrixUtil.getDelimiter() + "u=" + (userName != null ? userName : "");
    }

    public static String getGlobalKey(Class<?> commandClass) {
        return HystrixUtil.getCommandKey(commandClass, null, null);
    }

    public static String getTenantAndUserIsolatedKey(Class<?> commandClass) throws UserNotAuthenticatedException {
        return HystrixUtil.getCommandKey(commandClass, TenantAccessor.getCurrentTenant().getTenantId(), UserAccessor.getCurrentUser().getName());
    }

    public static String getTenantIsolatedKey(Class<?> commandClass) throws TenantNotAvailableException {
        return HystrixUtil.getCommandKey(commandClass, TenantAccessor.getCurrentTenant().getTenantId(), null);
    }

    public static HystrixCommand.Setter getDefaultErpCommandSetter(Class<?> type) {
        return HystrixUtil.getDefaultErpCommandSetter(type, HystrixUtil.getDefaultErpCommandProperties());
    }

    public static HystrixCommand.Setter getDefaultErpCommandSetter(Class<?> commandClass, HystrixCommandProperties.Setter commandProperties) {
        String groupKey = HystrixUtil.getGlobalKey(commandClass);
        String commandKey = HystrixUtil.getTenantAndUserIsolatedKey(commandClass);
        return HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)groupKey)).andThreadPoolKey(HystrixThreadPoolKey.Factory.asKey((String)groupKey)).andCommandKey(HystrixCommandKey.Factory.asKey((String)commandKey)).andThreadPoolPropertiesDefaults(HystrixThreadPoolProperties.Setter().withCoreSize(10).withQueueSizeRejectionThreshold(100).withMaxQueueSize(100)).andCommandPropertiesDefaults(commandProperties);
    }

    public static HystrixCommandProperties.Setter getDefaultErpCommandProperties() {
        return HystrixCommandProperties.Setter().withExecutionTimeoutInMilliseconds(40000).withCircuitBreakerEnabled(true).withCircuitBreakerSleepWindowInMilliseconds(10000).withFallbackEnabled(true);
    }
}

