/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.frameworks.hystrix;

import com.netflix.hystrix.Hystrix;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.slf4j.Logger;

@WebListener
public class HystrixBootstrapListener
implements ServletContextListener {
    private static final Logger logger = CloudLoggerFactory.getLogger(HystrixBootstrapListener.class);
    static boolean isInitialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bootstrap() {
        Class<HystrixBootstrapListener> clazz = HystrixBootstrapListener.class;
        synchronized (HystrixBootstrapListener.class) {
            if (!isInitialized) {
                if (logger.isInfoEnabled()) {
                    logger.info("Boostrapping Hystrix.");
                }
                isInitialized = true;
            } else if (logger.isInfoEnabled()) {
                logger.info("Hystrix already bootstrapped.");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Class<HystrixBootstrapListener> clazz = HystrixBootstrapListener.class;
        synchronized (HystrixBootstrapListener.class) {
            if (isInitialized) {
                if (logger.isInfoEnabled()) {
                    logger.info("Shutting down Hystrix.");
                }
                Hystrix.reset();
                isInitialized = false;
            } else if (logger.isInfoEnabled()) {
                logger.info("Hystrix already shut down.");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        this.bootstrap();
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        this.shutdown();
    }
}

