/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.result;

import com.sap.cloud.sdk.result.ObjectExtractor;
import com.sap.cloud.sdk.result.PrimitiveBasedObjectExtractor;
import com.sap.cloud.sdk.result.ResultElement;
import javax.annotation.Nonnull;

public class GenericObjectExtractor<T>
implements ObjectExtractor<T> {
    @Nonnull
    private final Class<T> objectType;

    @Override
    @Nonnull
    public T extract(@Nonnull ResultElement resultElement) throws UnsupportedOperationException {
        if (resultElement.isResultObject()) {
            return resultElement.getAsObject().as(this.objectType);
        }
        if (resultElement.isResultPrimitive()) {
            return new PrimitiveBasedObjectExtractor<T>(this.objectType).extract(resultElement);
        }
        throw new UnsupportedOperationException("Failed to convert " + ResultElement.class.getSimpleName() + " to type " + this.objectType.getName() + ": " + resultElement + ".");
    }

    public GenericObjectExtractor(@Nonnull Class<T> objectType) {
        if (objectType == null) {
            throw new NullPointerException("objectType is marked @NonNull but is null");
        }
        this.objectType = objectType;
    }
}

