/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.typeconverter;

import com.sap.cloud.sdk.typeconverter.exception.ObjectNotConvertableException;
import java.beans.ConstructorProperties;
import javax.annotation.Nullable;

public class ConvertedObject<T> {
    private final boolean notConvertable;
    @Nullable
    private final T object;

    @Nullable
    public T get() throws ObjectNotConvertableException {
        if (this.notConvertable) {
            throw new ObjectNotConvertableException("Object is not convertable.");
        }
        return this.object;
    }

    public T orNull() {
        return this.or(null);
    }

    public T or(T defaultValue) {
        if (this.notConvertable) {
            return defaultValue;
        }
        return this.object;
    }

    public static <T> ConvertedObject<T> fromConverted(@Nullable T convertedObject) {
        return new ConvertedObject<T>(false, convertedObject);
    }

    public static <T> ConvertedObject<T> fromNull() {
        return ConvertedObject.fromConverted(null);
    }

    public static <T> ConvertedObject<T> notConvertable() {
        return new ConvertedObject<Object>(true, null);
    }

    @ConstructorProperties(value={"notConvertable", "object"})
    protected ConvertedObject(boolean notConvertable, @Nullable T object) {
        this.notConvertable = notConvertable;
        this.object = object;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConvertedObject)) {
            return false;
        }
        ConvertedObject other = (ConvertedObject)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.notConvertable != other.notConvertable) {
            return false;
        }
        T this$object = this.object;
        T other$object = other.object;
        return !(this$object == null ? other$object != null : !this$object.equals(other$object));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConvertedObject;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.notConvertable ? 79 : 97);
        T $object = this.object;
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        return result;
    }

    public String toString() {
        return "ConvertedObject(notConvertable=" + this.notConvertable + ", object=" + this.object + ")";
    }
}

