/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.typeconverter;

import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.typeconverter.ConvertedObject;
import com.sap.cloud.sdk.typeconverter.TypeConverter;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.slf4j.Logger;

public abstract class AbstractTypeConverter<T, DomainT>
implements TypeConverter<T, DomainT> {
    private static final Logger logger = CloudLoggerFactory.getLogger(AbstractTypeConverter.class);

    @Override
    public final ConvertedObject<DomainT> toDomain(@Nullable T object) {
        if (object == null) {
            return ConvertedObject.fromNull();
        }
        try {
            return this.toDomainNonNull(object);
        }
        catch (Exception e) {
            if (logger.isWarnEnabled()) {
                logger.warn("Failed to convert to domain object: " + object + ".", (Throwable)e);
            }
            return ConvertedObject.notConvertable();
        }
    }

    @Override
    public final ConvertedObject<T> fromDomain(@Nullable DomainT domainObject) {
        if (domainObject == null) {
            return ConvertedObject.fromNull();
        }
        try {
            return this.fromDomainNonNull(domainObject);
        }
        catch (Exception e) {
            if (logger.isWarnEnabled()) {
                logger.warn("Failed to convert domain object of type " + this.getDomainType().getName() + " to " + this.getType().getName() + ": " + domainObject + ".", (Throwable)e);
            }
            return ConvertedObject.notConvertable();
        }
    }

    public abstract ConvertedObject<DomainT> toDomainNonNull(@NonNull T var1) throws Exception;

    public abstract ConvertedObject<T> fromDomainNonNull(@NonNull DomainT var1) throws Exception;
}

