/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.result;

import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.result.ObjectExtractor;
import com.sap.cloud.sdk.result.ResultElement;
import com.sap.cloud.sdk.result.ResultPrimitive;
import java.beans.ConstructorProperties;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

public class PrimitiveBasedObjectExtractor<T>
implements ObjectExtractor<T> {
    private static final Logger logger = CloudLoggerFactory.getLogger(PrimitiveBasedObjectExtractor.class);
    private final Class<T> objectType;

    @Override
    public T extract(ResultElement resultElement) {
        if (!(resultElement instanceof ResultPrimitive)) {
            throw new UnsupportedOperationException("Failed to instantiate " + this.objectType.getName() + " with non-primitive value " + resultElement + ".");
        }
        try {
            Pair construction = null;
            for (Constructor<?> constructor : this.objectType.getDeclaredConstructors()) {
                Object parameterValue;
                Class<?>[] parameters = constructor.getParameterTypes();
                if (parameters.length != 1 || (parameterValue = this.getParameterValue(resultElement, parameters[0])) == null || construction != null && !parameters[0].isPrimitive()) continue;
                try {
                    constructor.setAccessible(true);
                    construction = Pair.of(constructor, (Object)parameterValue);
                }
                catch (SecurityException e) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Constructor for " + this.objectType.getName() + " with " + parameters[0].getSimpleName() + " parameter is not accessible. Please check the active Java Security Manager.", (Throwable)e);
                }
            }
            if (construction != null) {
                return this.objectType.cast(((Constructor)construction.getKey()).newInstance(construction.getValue()));
            }
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Failed to instantiate " + this.objectType.getName() + " with constructor by value " + resultElement + " - " + e.getMessage() + ".");
        }
        throw new UnsupportedOperationException("Unsupported constructor of " + this.objectType.getName() + " to value " + resultElement + ".");
    }

    private Object getParameterValue(ResultElement resultElement, Class<?> parameter) {
        if (parameter.isAssignableFrom(String.class)) {
            return resultElement.asString();
        }
        if (parameter.isAssignableFrom(BigDecimal.class)) {
            return resultElement.asBigDecimal();
        }
        if (parameter.isAssignableFrom(BigInteger.class)) {
            return resultElement.asBigInteger();
        }
        if (ClassUtils.isAssignable(parameter, Character.class, (boolean)true)) {
            return Character.valueOf(resultElement.asCharacter());
        }
        if (ClassUtils.isAssignable(parameter, Double.class, (boolean)true)) {
            return resultElement.asDouble();
        }
        if (ClassUtils.isAssignable(parameter, Float.class, (boolean)true)) {
            return Float.valueOf(resultElement.asFloat());
        }
        if (ClassUtils.isAssignable(parameter, Long.class, (boolean)true)) {
            return resultElement.asLong();
        }
        if (ClassUtils.isAssignable(parameter, Integer.class, (boolean)true)) {
            return resultElement.asInteger();
        }
        if (ClassUtils.isAssignable(parameter, Short.class, (boolean)true)) {
            return resultElement.asShort();
        }
        if (ClassUtils.isAssignable(parameter, Byte.class, (boolean)true)) {
            return resultElement.asByte();
        }
        if (ClassUtils.isAssignable(parameter, Boolean.class, (boolean)true)) {
            return resultElement.asBoolean();
        }
        return null;
    }

    @ConstructorProperties(value={"objectType"})
    public PrimitiveBasedObjectExtractor(Class<T> objectType) {
        this.objectType = objectType;
    }
}

