/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.result;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sap.cloud.sdk.result.GsonResultElementFactory;
import com.sap.cloud.sdk.result.ResultCollection;
import com.sap.cloud.sdk.result.ResultElement;
import com.sap.cloud.sdk.result.ResultObject;
import com.sap.cloud.sdk.result.ResultPrimitive;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.math.BigInteger;

public class GsonResultObject
implements ResultObject {
    protected final JsonObject jsonObject;
    protected final GsonResultElementFactory resultElementFactory;

    @Override
    public boolean isResultPrimitive() {
        return false;
    }

    @Override
    public boolean isResultCollection() {
        return false;
    }

    @Override
    public boolean isResultObject() {
        return true;
    }

    @Override
    public ResultPrimitive getAsPrimitive() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot get an object as primitive.");
    }

    @Override
    public ResultCollection getAsCollection() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot get an object as collection.");
    }

    @Override
    public ResultObject getAsObject() {
        return this;
    }

    @Override
    public boolean asBoolean() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot get an object as primitive.");
    }

    @Override
    public byte asByte() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot get an object as primitive.");
    }

    @Override
    public char asCharacter() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot get an object as primitive.");
    }

    @Override
    public String asString() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot get an object as primitive.");
    }

    @Override
    public int asInteger() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot get an object as primitive.");
    }

    @Override
    public short asShort() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot get an object as primitive.");
    }

    @Override
    public long asLong() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot get an object as primitive.");
    }

    @Override
    public float asFloat() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot get an object as primitive.");
    }

    @Override
    public double asDouble() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot get an object as primitive.");
    }

    @Override
    public BigInteger asBigInteger() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot get an object as primitive.");
    }

    @Override
    public BigDecimal asBigDecimal() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot get an object as primitive.");
    }

    @Override
    public ResultElement get(String elementName) throws UnsupportedOperationException {
        try {
            return this.resultElementFactory.create(this.jsonObject.get(elementName));
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Failed to get element with name " + elementName + ".", e);
        }
    }

    @Override
    public <T> T as(Class<T> objectType) throws UnsupportedOperationException {
        try {
            return (T)this.resultElementFactory.getGsonBuilder().create().fromJson((JsonElement)this.jsonObject, objectType);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Failed to get element as object of type " + objectType.getName() + ".", e);
        }
    }

    @ConstructorProperties(value={"jsonObject", "resultElementFactory"})
    public GsonResultObject(JsonObject jsonObject, GsonResultElementFactory resultElementFactory) {
        this.jsonObject = jsonObject;
        this.resultElementFactory = resultElementFactory;
    }

    public JsonObject getJsonObject() {
        return this.jsonObject;
    }

    public GsonResultElementFactory getResultElementFactory() {
        return this.resultElementFactory;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GsonResultObject)) {
            return false;
        }
        GsonResultObject other = (GsonResultObject)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JsonObject this$jsonObject = this.getJsonObject();
        JsonObject other$jsonObject = other.getJsonObject();
        if (this$jsonObject == null ? other$jsonObject != null : !this$jsonObject.equals(other$jsonObject)) {
            return false;
        }
        GsonResultElementFactory this$resultElementFactory = this.getResultElementFactory();
        GsonResultElementFactory other$resultElementFactory = other.getResultElementFactory();
        return !(this$resultElementFactory == null ? other$resultElementFactory != null : !((Object)this$resultElementFactory).equals(other$resultElementFactory));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GsonResultObject;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JsonObject $jsonObject = this.getJsonObject();
        result = result * 59 + ($jsonObject == null ? 43 : $jsonObject.hashCode());
        GsonResultElementFactory $resultElementFactory = this.getResultElementFactory();
        result = result * 59 + ($resultElementFactory == null ? 43 : ((Object)$resultElementFactory).hashCode());
        return result;
    }

    public String toString() {
        return "GsonResultObject(jsonObject=" + this.getJsonObject() + ", resultElementFactory=" + this.getResultElementFactory() + ")";
    }
}

