/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.result;

import com.sap.cloud.sdk.result.ObjectExtractor;
import com.sap.cloud.sdk.result.PrimitiveBasedObjectExtractor;
import com.sap.cloud.sdk.result.ResultElement;
import java.beans.ConstructorProperties;

public class GenericObjectExtractor<T>
implements ObjectExtractor<T> {
    private final Class<T> objectType;

    @Override
    public T extract(ResultElement resultElement) {
        if (resultElement.isResultObject()) {
            return resultElement.getAsObject().as(this.objectType);
        }
        if (resultElement.isResultPrimitive()) {
            return new PrimitiveBasedObjectExtractor<T>(this.objectType).extract(resultElement);
        }
        throw new UnsupportedOperationException("Failed to convert " + ResultElement.class.getSimpleName() + " to type " + this.objectType.getName() + ": " + resultElement + ".");
    }

    @ConstructorProperties(value={"objectType"})
    public GenericObjectExtractor(Class<T> objectType) {
        this.objectType = objectType;
    }
}

