/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.result;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.sap.cloud.sdk.result.BigDecimalExtractor;
import com.sap.cloud.sdk.result.BigIntegerExtractor;
import com.sap.cloud.sdk.result.BooleanExtractor;
import com.sap.cloud.sdk.result.ByteExtractor;
import com.sap.cloud.sdk.result.CharacterExtractor;
import com.sap.cloud.sdk.result.CollectedResultCollection;
import com.sap.cloud.sdk.result.CollectionExtractor;
import com.sap.cloud.sdk.result.DefaultCollectedResultCollection;
import com.sap.cloud.sdk.result.DoubleExtractor;
import com.sap.cloud.sdk.result.FloatExtractor;
import com.sap.cloud.sdk.result.GenericCollectionExtractor;
import com.sap.cloud.sdk.result.GenericObjectExtractor;
import com.sap.cloud.sdk.result.IntegerExtractor;
import com.sap.cloud.sdk.result.LongExtractor;
import com.sap.cloud.sdk.result.ObjectExtractor;
import com.sap.cloud.sdk.result.ResultCollection;
import com.sap.cloud.sdk.result.ResultElement;
import com.sap.cloud.sdk.result.ResultObject;
import com.sap.cloud.sdk.result.ResultPrimitive;
import com.sap.cloud.sdk.result.ShortExtractor;
import com.sap.cloud.sdk.result.StringExtractor;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DefaultResultCollection
implements ResultCollection {
    private final Iterable<ResultElement> resultElements;

    @Override
    public CollectedResultCollection collect(String elementName) {
        return new DefaultCollectedResultCollection(elementName, this.resultElements);
    }

    @Override
    public <T> List<T> asList(Class<T> objectType) throws UnsupportedOperationException {
        return this.collectListFromObject(new GenericObjectExtractor<T>(objectType));
    }

    private <T> List<T> collectListFromObject(ObjectExtractor<T> extractor) throws UnsupportedOperationException {
        return this.collectListFromCollection(new GenericCollectionExtractor<T>(extractor));
    }

    private <T> List<T> collectListFromCollection(CollectionExtractor<List<T>, T> extractor) throws UnsupportedOperationException {
        return this.getCollection(extractor, Lists.newArrayList());
    }

    private <CollectionT extends Collection<T>, T> CollectionT getCollection(CollectionExtractor<CollectionT, T> extractor, CollectionT collection) throws UnsupportedOperationException {
        try {
            for (ResultElement element : this.resultElements) {
                if (!element.isResultObject()) continue;
                collection.addAll(extractor.extract(element));
            }
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Failed to collect nested elements.", e);
        }
        return collection;
    }

    @Override
    public <T> Set<T> asSet(Class<T> objectType) throws UnsupportedOperationException {
        return this.collectSetFromObject(new GenericObjectExtractor<T>(objectType));
    }

    private <T> Set<T> collectSetFromObject(final ObjectExtractor<T> extractor) throws UnsupportedOperationException {
        return this.collectSetFromCollection(new CollectionExtractor<Set<T>, T>(){

            @Override
            public Set<T> extract(ResultElement resultElement) {
                return Collections.singleton(extractor.extract(resultElement));
            }
        });
    }

    private <T> Set<T> collectSetFromCollection(CollectionExtractor<Set<T>, T> extractor) throws UnsupportedOperationException {
        return this.getCollection(extractor, Sets.newHashSet());
    }

    @Override
    public List<Boolean> asBooleanList() throws UnsupportedOperationException {
        return this.collectListFromObject(new BooleanExtractor());
    }

    @Override
    public Set<Boolean> asBooleanSet() throws UnsupportedOperationException {
        return this.collectSetFromObject(new BooleanExtractor());
    }

    @Override
    public List<Byte> asByteList() throws UnsupportedOperationException {
        return this.collectListFromObject(new ByteExtractor());
    }

    @Override
    public Set<Byte> asByteSet() throws UnsupportedOperationException {
        return this.collectSetFromObject(new ByteExtractor());
    }

    @Override
    public List<Character> asCharacterList() throws UnsupportedOperationException {
        return this.collectListFromObject(new CharacterExtractor());
    }

    @Override
    public Set<Character> asCharacterSet() throws UnsupportedOperationException {
        return this.collectSetFromObject(new CharacterExtractor());
    }

    @Override
    public List<String> asStringList() throws UnsupportedOperationException {
        return this.collectListFromObject(new StringExtractor());
    }

    @Override
    public Set<String> asStringSet() throws UnsupportedOperationException {
        return this.collectSetFromObject(new StringExtractor());
    }

    @Override
    public List<Integer> asIntegerList() throws UnsupportedOperationException {
        return this.collectListFromObject(new IntegerExtractor());
    }

    @Override
    public Set<Integer> asIntegerSet() throws UnsupportedOperationException {
        return this.collectSetFromObject(new IntegerExtractor());
    }

    @Override
    public List<Short> asShortList() throws UnsupportedOperationException {
        return this.collectListFromObject(new ShortExtractor());
    }

    @Override
    public Set<Short> asShortSet() throws UnsupportedOperationException {
        return this.collectSetFromObject(new ShortExtractor());
    }

    @Override
    public List<Long> asLongList() throws UnsupportedOperationException {
        return this.collectListFromObject(new LongExtractor());
    }

    @Override
    public Set<Long> asLongSet() throws UnsupportedOperationException {
        return this.collectSetFromObject(new LongExtractor());
    }

    @Override
    public List<Float> asFloatList() throws UnsupportedOperationException {
        return this.collectListFromObject(new FloatExtractor());
    }

    @Override
    public Set<Float> asFloatSet() throws UnsupportedOperationException {
        return this.collectSetFromObject(new FloatExtractor());
    }

    @Override
    public List<Double> asDoubleList() throws UnsupportedOperationException {
        return this.collectListFromObject(new DoubleExtractor());
    }

    @Override
    public Set<Double> asDoubleSet() throws UnsupportedOperationException {
        return this.collectSetFromObject(new DoubleExtractor());
    }

    @Override
    public List<BigInteger> asBigIntegerList() throws UnsupportedOperationException {
        return this.collectListFromObject(new BigIntegerExtractor());
    }

    @Override
    public Set<BigInteger> asBigIntegerSet() throws UnsupportedOperationException {
        return this.collectSetFromObject(new BigIntegerExtractor());
    }

    @Override
    public List<BigDecimal> asBigDecimalList() throws UnsupportedOperationException {
        return this.collectListFromObject(new BigDecimalExtractor());
    }

    @Override
    public Set<BigDecimal> asBigDecimalSet() throws UnsupportedOperationException {
        return this.collectSetFromObject(new BigDecimalExtractor());
    }

    @Override
    public boolean isResultPrimitive() {
        return false;
    }

    @Override
    public boolean isResultCollection() {
        return true;
    }

    @Override
    public boolean isResultObject() {
        return false;
    }

    @Override
    public ResultPrimitive getAsPrimitive() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot get collection as primitive.");
    }

    @Override
    public ResultCollection getAsCollection() {
        return this;
    }

    @Override
    public ResultObject getAsObject() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot get collection as object.");
    }

    @Override
    public boolean asBoolean() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot get collection as primitive.");
    }

    @Override
    public byte asByte() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot get collection as primitive.");
    }

    @Override
    public char asCharacter() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot get collection as primitive.");
    }

    @Override
    public String asString() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot get collection as primitive.");
    }

    @Override
    public int asInteger() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot get collection as primitive.");
    }

    @Override
    public short asShort() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot get collection as primitive.");
    }

    @Override
    public long asLong() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot get collection as primitive.");
    }

    @Override
    public float asFloat() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot get collection as primitive.");
    }

    @Override
    public double asDouble() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot get collection as primitive.");
    }

    @Override
    public BigInteger asBigInteger() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot get collection as primitive.");
    }

    @Override
    public BigDecimal asBigDecimal() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot get collection as primitive.");
    }

    @Override
    public Iterator<ResultElement> iterator() {
        return this.resultElements.iterator();
    }

    @ConstructorProperties(value={"resultElements"})
    public DefaultResultCollection(Iterable<ResultElement> resultElements) {
        this.resultElements = resultElements;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultResultCollection)) {
            return false;
        }
        DefaultResultCollection other = (DefaultResultCollection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Iterable<ResultElement> this$resultElements = this.getResultElements();
        Iterable<ResultElement> other$resultElements = other.getResultElements();
        return !(this$resultElements == null ? other$resultElements != null : !this$resultElements.equals(other$resultElements));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultResultCollection;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Iterable<ResultElement> $resultElements = this.getResultElements();
        result = result * 59 + ($resultElements == null ? 43 : $resultElements.hashCode());
        return result;
    }

    public String toString() {
        return "DefaultResultCollection(resultElements=" + this.getResultElements() + ")";
    }

    public Iterable<ResultElement> getResultElements() {
        return this.resultElements;
    }
}

