/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.serialization;

import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import com.sap.cloud.sdk.s4hana.serialization.AbstractErpTypeConverter;
import com.sap.cloud.sdk.s4hana.serialization.StringBasedErpType;
import com.sap.cloud.sdk.typeconverter.ConvertedObject;
import java.beans.ConstructorProperties;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class StringBasedErpTypeConverter<T extends StringBasedErpType<T>>
extends AbstractErpTypeConverter<T> {
    private final Class<T> type;

    public Class<T> getType() {
        return this.type;
    }

    public ConvertedObject<String> toDomainNonNull(@Nullable T object) {
        return object == null || object.getValue() == null ? ConvertedObject.fromNull() : ConvertedObject.fromConverted((Object)object.toString());
    }

    public ConvertedObject<T> fromDomainNonNull(@Nullable String domainObjectValue) {
        if (StringUtils.isEmpty((CharSequence)domainObjectValue)) {
            return ConvertedObject.fromNull();
        }
        StringBasedErpType object = null;
        try {
            object = (StringBasedErpType)this.type.getConstructor(String.class).newInstance(domainObjectValue);
            switch (object.getFillCharStrategy()) {
                case FILL_LEADING: 
                case FILL_LEADING_IF_NUMERIC: {
                    if (!StringUtils.containsOnly((CharSequence)domainObjectValue, (char[])new char[]{object.getFillChar()})) break;
                    object = null;
                    break;
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new ShouldNotHappenException("Failed to instantiate object from " + this.type.getName() + ": No constructor with String parameter available.", (Throwable)e);
        }
        return ConvertedObject.fromConverted((Object)object);
    }

    @ConstructorProperties(value={"type"})
    public StringBasedErpTypeConverter(Class<T> type) {
        this.type = type;
    }
}

