/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.serialization;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.gson.annotations.Expose;
import com.sap.cloud.sdk.s4hana.serialization.ErpType;
import com.sap.cloud.sdk.s4hana.serialization.ErpTypeConverter;
import com.sap.cloud.sdk.typeconverter.ConvertedObject;
import java.beans.ConstructorProperties;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public abstract class IntegerBasedErpType<T extends IntegerBasedErpType<T>>
implements ErpType<T> {
    private static final long serialVersionUID = 6553092035796586330L;
    @Expose
    @Nullable
    private final BigInteger value;

    protected abstract Class<T> getType();

    protected abstract boolean isSigned();

    protected abstract int getMaxLength();

    @JsonCreator
    public IntegerBasedErpType(String str) {
        this(IntegerBasedErpType.fromErpToJavaInteger(str));
    }

    public IntegerBasedErpType(byte value) {
        this(BigInteger.valueOf(value));
    }

    public IntegerBasedErpType(short value) {
        this(BigInteger.valueOf(value));
    }

    public IntegerBasedErpType(int value) {
        this(BigInteger.valueOf(value));
    }

    public IntegerBasedErpType(long value) {
        this(BigInteger.valueOf(value));
    }

    public Byte byteValue() {
        return this.value != null ? Byte.valueOf(this.value.byteValue()) : null;
    }

    public Short shortValue() {
        return this.value != null ? Short.valueOf(this.value.shortValue()) : null;
    }

    public Integer intValue() {
        return this.value != null ? Integer.valueOf(this.value.intValue()) : null;
    }

    public Long longValue() {
        return this.value != null ? Long.valueOf(this.value.longValue()) : null;
    }

    private static BigInteger fromErpToJavaInteger(String str) {
        if (str == null || StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        char signChar = str.charAt(str.length() - 1);
        if (signChar == '-' || signChar == ' ') {
            str = str.substring(0, str.length() - 1);
            return new BigInteger((signChar == '-' ? "-" : "") + str);
        }
        return new BigInteger(str);
    }

    public String toString() {
        return this.toErpString();
    }

    private String toErpString() {
        if (this.value == null) {
            return this.isSigned() ? "" : " ";
        }
        String sign = this.isSigned() ? (this.value.signum() < 0 ? "-" : " ") : "";
        return this.value + sign;
    }

    public ErpTypeConverter<T> getTypeConverter() {
        return new IntegerBasedErpTypeConverter(this);
    }

    @ConstructorProperties(value={"value"})
    public IntegerBasedErpType(@Nullable BigInteger value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IntegerBasedErpType)) {
            return false;
        }
        IntegerBasedErpType other = (IntegerBasedErpType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigInteger this$value = this.getValue();
        BigInteger other$value = other.getValue();
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IntegerBasedErpType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigInteger $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }

    @Nullable
    public BigInteger getValue() {
        return this.value;
    }

    private static class IntegerBasedErpTypeConverter<T extends IntegerBasedErpType<T>>
    implements ErpTypeConverter<T> {
        private final IntegerBasedErpType<T> obj;

        public Class<T> getType() {
            return this.obj.getType();
        }

        public Class<String> getDomainType() {
            return String.class;
        }

        public ConvertedObject<String> toDomain(@Nullable T object) {
            return object == null || ((IntegerBasedErpType)object).getValue() == null ? ConvertedObject.fromNull() : ConvertedObject.fromConverted((Object)((IntegerBasedErpType)this.obj).toErpString());
        }

        public ConvertedObject<T> fromDomain(@Nullable String domainObject) {
            try {
                return StringUtils.isEmpty((CharSequence)domainObject) ? ConvertedObject.fromNull() : ConvertedObject.fromConverted(this.getType().getConstructor(String.class).newInstance(domainObject));
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                return ConvertedObject.fromNull();
            }
        }

        @ConstructorProperties(value={"obj"})
        public IntegerBasedErpTypeConverter(IntegerBasedErpType<T> obj) {
            this.obj = obj;
        }
    }
}

