/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.serialization;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.gson.annotations.Expose;
import com.sap.cloud.sdk.s4hana.serialization.ErpType;
import com.sap.cloud.sdk.s4hana.serialization.ErpTypeConverter;
import com.sap.cloud.sdk.typeconverter.ConvertedObject;
import java.beans.ConstructorProperties;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public abstract class DecimalBasedErpType<T extends DecimalBasedErpType<T>>
implements ErpType<T> {
    private static final long serialVersionUID = 5572827427883235410L;
    @Expose
    @Nullable
    private final BigDecimal value;

    protected abstract Class<T> getType();

    protected abstract boolean isSigned();

    protected abstract int getDecimals();

    protected abstract int getMaxLength();

    @JsonCreator
    public DecimalBasedErpType(String str) {
        this(DecimalBasedErpType.fromErpToJavaDecimal(str));
    }

    public DecimalBasedErpType(Double value) {
        this(BigDecimal.valueOf(value));
    }

    public DecimalBasedErpType(Float value) {
        this(BigDecimal.valueOf(value.floatValue()));
    }

    private static BigDecimal fromErpToJavaDecimal(String str) {
        if (str == null || StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        char signChar = str.charAt(str.length() - 1);
        if (signChar == '-' || signChar == ' ') {
            str = str.substring(0, str.length() - 1);
            BigDecimal result = new BigDecimal(str);
            if (signChar == '-') {
                return result.negate();
            }
            return result;
        }
        return new BigDecimal(str);
    }

    private String toErpString() {
        if (this.value == null) {
            return this.isSigned() ? "" : " ";
        }
        String sign = this.isSigned() ? (this.value.signum() < 0 ? "-" : " ") : "";
        return this.value.abs().setScale(this.getDecimals(), RoundingMode.UNNECESSARY).toPlainString() + sign;
    }

    public ErpTypeConverter<T> getTypeConverter() {
        return new DecimalBasedErpTypeConverter(this);
    }

    @ConstructorProperties(value={"value"})
    public DecimalBasedErpType(@Nullable BigDecimal value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DecimalBasedErpType)) {
            return false;
        }
        DecimalBasedErpType other = (DecimalBasedErpType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigDecimal this$value = this.getValue();
        BigDecimal other$value = other.getValue();
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DecimalBasedErpType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigDecimal $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }

    public String toString() {
        return "DecimalBasedErpType(value=" + this.getValue() + ")";
    }

    @Nullable
    public BigDecimal getValue() {
        return this.value;
    }

    private static class DecimalBasedErpTypeConverter<T extends DecimalBasedErpType<T>>
    implements ErpTypeConverter<T> {
        private final DecimalBasedErpType<T> obj;

        public Class<T> getType() {
            return this.obj.getType();
        }

        public Class<String> getDomainType() {
            return String.class;
        }

        public ConvertedObject<String> toDomain(@Nullable T object) {
            return object == null || ((DecimalBasedErpType)object).getValue() == null ? ConvertedObject.fromNull() : ConvertedObject.fromConverted((Object)((DecimalBasedErpType)this.obj).toErpString());
        }

        public ConvertedObject<T> fromDomain(@Nullable String domainObject) {
            try {
                return StringUtils.isEmpty((CharSequence)domainObject) ? ConvertedObject.fromNull() : ConvertedObject.fromConverted(this.getType().getConstructor(String.class).newInstance(domainObject));
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                return ConvertedObject.fromNull();
            }
        }

        @ConstructorProperties(value={"obj"})
        public DecimalBasedErpTypeConverter(DecimalBasedErpType<T> obj) {
            this.obj = obj;
        }
    }
}

