/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces;

import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.WithDestinationName;
import com.sap.cloud.sdk.odatav2.connectivity.ErrorResultHandler;
import com.sap.cloud.sdk.odatav2.connectivity.FilterExpression;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;
import com.sap.cloud.sdk.odatav2.connectivity.ODataExceptionType;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQuery;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQueryBuilder;
import com.sap.cloud.sdk.odatav2.connectivity.ODataType;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.connectivity.ErpConfigContext;
import com.sap.cloud.sdk.s4hana.connectivity.ErpEndpoint;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.EntityField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ExpressionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.FilterExpressionWrapper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.FunctionImportResponseParser;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ODataTypeValueSerializer;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ODataVdmErrorResultHandler;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.Order;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public class UpdateOfMaterialPriceNamespace {

    public static class PriceChangeDocument {
        @ElementName(value="MaterialLedgerDocument")
        private String materialLedgerDocument;
        @ElementName(value="MaterialLedgerDocumentYear")
        private String materialLedgerDocumentYear;

        public String getMaterialLedgerDocument() {
            return this.materialLedgerDocument;
        }

        public String getMaterialLedgerDocumentYear() {
            return this.materialLedgerDocumentYear;
        }

        public PriceChangeDocument setMaterialLedgerDocument(String materialLedgerDocument) {
            this.materialLedgerDocument = materialLedgerDocument;
            return this;
        }

        public PriceChangeDocument setMaterialLedgerDocumentYear(String materialLedgerDocumentYear) {
            this.materialLedgerDocumentYear = materialLedgerDocumentYear;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PriceChangeDocument)) {
                return false;
            }
            PriceChangeDocument other = (PriceChangeDocument)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$materialLedgerDocument = this.getMaterialLedgerDocument();
            String other$materialLedgerDocument = other.getMaterialLedgerDocument();
            if (this$materialLedgerDocument == null ? other$materialLedgerDocument != null : !this$materialLedgerDocument.equals(other$materialLedgerDocument)) {
                return false;
            }
            String this$materialLedgerDocumentYear = this.getMaterialLedgerDocumentYear();
            String other$materialLedgerDocumentYear = other.getMaterialLedgerDocumentYear();
            return !(this$materialLedgerDocumentYear == null ? other$materialLedgerDocumentYear != null : !this$materialLedgerDocumentYear.equals(other$materialLedgerDocumentYear));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PriceChangeDocument;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $materialLedgerDocument = this.getMaterialLedgerDocument();
            result = result * 59 + ($materialLedgerDocument == null ? 43 : $materialLedgerDocument.hashCode());
            String $materialLedgerDocumentYear = this.getMaterialLedgerDocumentYear();
            result = result * 59 + ($materialLedgerDocumentYear == null ? 43 : $materialLedgerDocumentYear.hashCode());
            return result;
        }

        public String toString() {
            return "UpdateOfMaterialPriceNamespace.PriceChangeDocument(materialLedgerDocument=" + this.getMaterialLedgerDocument() + ", materialLedgerDocumentYear=" + this.getMaterialLedgerDocumentYear() + ")";
        }
    }

    public static class MaterialValuationFluentHelper {
        private ODataQueryBuilder queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_MATERIAL_VALUATION_SRV", (String)"MaterialValuationSet");
        private ErrorResultHandler<?> errorResultHandler = new ODataVdmErrorResultHandler();

        public MaterialValuationFluentHelper filter(ExpressionFluentHelper<MaterialValuation> expression) {
            for (FilterExpressionWrapper<?> filterExpressionWrapper : expression.evaluate()) {
                Object comparisonValue = filterExpressionWrapper.getComparisonValue();
                if (comparisonValue instanceof Integer) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Integer)((Integer)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof String) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((String)((String)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Long) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Long)((Long)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Double) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Double)((Double)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Float) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Float)((Float)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDate) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDate)((LocalDate)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDateTime)((LocalDateTime)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Date) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Date)((Date)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof DateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((DateTime)((DateTime)comparisonValue))));
                    continue;
                }
                this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of(comparisonValue)));
            }
            return this;
        }

        public MaterialValuationFluentHelper orderBy(EntityField<?, MaterialValuation> field, Order order) {
            String orderingDirection = order == Order.ASC ? " asc" : " desc";
            this.queryBuilder.param("orderby", (Object)(field.getFieldName() + orderingDirection));
            return this;
        }

        @SafeVarargs
        public final MaterialValuationFluentHelper select(EntityField<?, MaterialValuation> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public MaterialValuationFluentHelper top(Number top) {
            this.queryBuilder.top(top);
            return this;
        }

        public MaterialValuationFluentHelper skip(Number skip) {
            this.queryBuilder.skip(skip);
            return this;
        }

        public MaterialValuationFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.errorHandler(this.errorResultHandler).build();
        }

        public List<MaterialValuation> execute(ErpConfigContext erpConfigContext) throws ODataException {
            List entityList = this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).asList(MaterialValuation.class);
            for (MaterialValuation entity : entityList) {
                entity.setErpConfigContext(erpConfigContext);
            }
            return entityList;
        }
    }

    public static class MaterialValuationByKeyFluentHelper {
        private ODataQueryBuilder queryBuilder;
        private ErrorResultHandler<?> errorResultHandler;
        private List<Object> values = new LinkedList<Object>();

        public MaterialValuationByKeyFluentHelper(String costEstimate) {
            this.values.add(costEstimate);
            this.queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_MATERIAL_VALUATION_SRV", (String)"MaterialValuationSet");
            HashMap<String, Object> keys = new HashMap<String, Object>();
            keys.put("CostEstimate", this.values.get(0));
            this.queryBuilder.keys(keys);
        }

        @SafeVarargs
        public final MaterialValuationByKeyFluentHelper select(EntityField<?, MaterialValuation> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.build();
        }

        public MaterialValuationByKeyFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public MaterialValuation execute(ErpConfigContext erpConfigContext) throws ODataException {
            MaterialValuation entity = (MaterialValuation)this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).as(MaterialValuation.class);
            entity.setErpConfigContext(erpConfigContext);
            return entity;
        }
    }

    public static class MaterialValuation {
        @ElementName(value="CostEstimate")
        private String costEstimate;
        public static EntityField<String, MaterialValuation> COST_ESTIMATE = new EntityField("CostEstimate");
        private static final transient String ODATA_ENDPOINT_URL = "/sap/opu/odata/sap/API_MATERIAL_VALUATION_SRV";
        private static final transient String ODATA_ENTITY_COLLECTION = "MaterialValuationSet";
        private transient ErpConfigContext erpConfigContext;

        public String toString() {
            return "UpdateOfMaterialPriceNamespace.MaterialValuation(costEstimate=" + this.costEstimate + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MaterialValuation)) {
                return false;
            }
            MaterialValuation other = (MaterialValuation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$costEstimate = this.costEstimate;
            String other$costEstimate = other.costEstimate;
            return !(this$costEstimate == null ? other$costEstimate != null : !this$costEstimate.equals(other$costEstimate));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MaterialValuation;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $costEstimate = this.costEstimate;
            result = result * 59 + ($costEstimate == null ? 43 : $costEstimate.hashCode());
            return result;
        }

        public String getCostEstimate() {
            return this.costEstimate;
        }

        public MaterialValuation setCostEstimate(String costEstimate) {
            this.costEstimate = costEstimate;
            return this;
        }

        public MaterialValuation setErpConfigContext(ErpConfigContext erpConfigContext) {
            this.erpConfigContext = erpConfigContext;
            return this;
        }
    }

    public static class InventoryPriceChangeFluentHelper {
        private List<Object> values = new LinkedList<Object>();

        public InventoryPriceChangeFluentHelper(String inventoryValuationType, String valuationArea, BigDecimal materialPriceUnitQty, Calendar postingDate, BigDecimal inventoryPrice, String material, String currencyRole, String currency) {
            this.values.add(inventoryValuationType);
            this.values.add(valuationArea);
            this.values.add(materialPriceUnitQty);
            this.values.add(postingDate);
            this.values.add(inventoryPrice);
            this.values.add(material);
            this.values.add(currencyRole);
            this.values.add(currency);
        }

        public PriceChangeDocument execute(ErpConfigContext erpConfigContext) throws ODataException, IOException {
            String uriString;
            URI uri;
            HttpResponse response;
            Integer statusCode;
            Integer destinationUriStringLastIndex;
            String destinationName = erpConfigContext.getDestinationName();
            HttpClient httpClient = HttpClientAccessor.getHttpClient((String)destinationName);
            String destinationUriString = DestinationAccessor.getDestination((String)destinationName).getUri().toString();
            if (destinationUriString.charAt(destinationUriStringLastIndex = Integer.valueOf(destinationUriString.length() - 1)) == '/') {
                destinationUriString = destinationUriString.substring(0, destinationUriStringLastIndex);
            }
            if ((statusCode = Integer.valueOf((response = httpClient.execute((HttpUriRequest)new HttpPost(uri = URI.create(uriString = destinationUriString + String.format("/sap/opu/odata/sap/API_MATERIAL_VALUATION_SRV/InventoryPriceChange?InventoryValuationType=%s&ValuationArea=%s&MaterialPriceUnitQty=%s&PostingDate=%s&InventoryPrice=%s&Material=%s&CurrencyRole=%s&Currency=%s&$format=json", ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri((String)this.values.get(0)), ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri((String)this.values.get(1)), ODataTypeValueSerializer.of(EdmSimpleTypeKind.Decimal).toUri((BigDecimal)this.values.get(2)), ODataTypeValueSerializer.of(EdmSimpleTypeKind.DateTime).toUri((Calendar)this.values.get(3)), ODataTypeValueSerializer.of(EdmSimpleTypeKind.Decimal).toUri((BigDecimal)this.values.get(4)), ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri((String)this.values.get(5)), ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri((String)this.values.get(6)), ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri((String)this.values.get(7))))))).getStatusLine().getStatusCode())) >= 400 & statusCode <= 599) {
                throw new ODataException(ODataExceptionType.ODATA_OPERATION_EXECUTION_FAILED, "Execution of the function import returned HTTP error code " + statusCode, null);
            }
            InputStream content = response.getEntity().getContent();
            return (PriceChangeDocument)FunctionImportResponseParser.getResultElementFromContent(content, "InventoryPriceChange").getAsObject().as(PriceChangeDocument.class);
        }
    }
}

