/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.cloudplatform.connectivity.WithDestinationName;
import com.sap.cloud.sdk.odatav2.connectivity.ErrorResultHandler;
import com.sap.cloud.sdk.odatav2.connectivity.FilterExpression;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQuery;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQueryBuilder;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQueryResult;
import com.sap.cloud.sdk.odatav2.connectivity.ODataType;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.connectivity.ErpConfigContext;
import com.sap.cloud.sdk.s4hana.connectivity.ErpEndpoint;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.EntityField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ExpressionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.FilterExpressionWrapper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ODataBooleanAdapter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ODataCalendarAdapter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ODataTypeValueSerializer;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ODataVdmErrorResultHandler;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.Order;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public class RetrieveMaterialDocumentsNamespace {

    public static class MaterialDocumentItemFluentHelper {
        private ODataQueryBuilder queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_MATERIAL_DOCUMENT_SRV", (String)"A_MaterialDocumentItem");
        private ErrorResultHandler<?> errorResultHandler = new ODataVdmErrorResultHandler();

        public MaterialDocumentItemFluentHelper filter(ExpressionFluentHelper<MaterialDocumentItem> expression) {
            for (FilterExpressionWrapper<?> filterExpressionWrapper : expression.evaluate()) {
                Object comparisonValue = filterExpressionWrapper.getComparisonValue();
                if (comparisonValue instanceof Integer) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Integer)((Integer)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof String) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((String)((String)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Long) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Long)((Long)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Double) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Double)((Double)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Float) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Float)((Float)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDate) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDate)((LocalDate)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDateTime)((LocalDateTime)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Date) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Date)((Date)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof DateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((DateTime)((DateTime)comparisonValue))));
                    continue;
                }
                this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of(comparisonValue)));
            }
            return this;
        }

        public MaterialDocumentItemFluentHelper orderBy(EntityField<?, MaterialDocumentItem> field, Order order) {
            String orderingDirection = order == Order.ASC ? " asc" : " desc";
            this.queryBuilder.param("orderby", (Object)(field.getFieldName() + orderingDirection));
            return this;
        }

        @SafeVarargs
        public final MaterialDocumentItemFluentHelper select(EntityField<?, MaterialDocumentItem> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public MaterialDocumentItemFluentHelper top(Number top) {
            this.queryBuilder.top(top);
            return this;
        }

        public MaterialDocumentItemFluentHelper skip(Number skip) {
            this.queryBuilder.skip(skip);
            return this;
        }

        public MaterialDocumentItemFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.errorHandler(this.errorResultHandler).build();
        }

        public List<MaterialDocumentItem> execute(ErpConfigContext erpConfigContext) throws ODataException {
            List entityList = this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).asList(MaterialDocumentItem.class);
            for (MaterialDocumentItem entity : entityList) {
                entity.setErpConfigContext(erpConfigContext);
            }
            return entityList;
        }
    }

    public static class MaterialDocumentItemByKeyFluentHelper {
        private ODataQueryBuilder queryBuilder;
        private ErrorResultHandler<?> errorResultHandler;
        private List<Object> values = new LinkedList<Object>();

        public MaterialDocumentItemByKeyFluentHelper(String materialDocumentYear, String materialDocument, String materialDocumentItem) {
            this.values.add(materialDocumentYear);
            this.values.add(materialDocument);
            this.values.add(materialDocumentItem);
            this.queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_MATERIAL_DOCUMENT_SRV", (String)"A_MaterialDocumentItem");
            HashMap<String, Object> keys = new HashMap<String, Object>();
            keys.put("MaterialDocumentYear", this.values.get(0));
            keys.put("MaterialDocument", this.values.get(1));
            keys.put("MaterialDocumentItem", this.values.get(2));
            this.queryBuilder.keys(keys);
        }

        @SafeVarargs
        public final MaterialDocumentItemByKeyFluentHelper select(EntityField<?, MaterialDocumentItem> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.build();
        }

        public MaterialDocumentItemByKeyFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public MaterialDocumentItem execute(ErpConfigContext erpConfigContext) throws ODataException {
            MaterialDocumentItem entity = (MaterialDocumentItem)this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).as(MaterialDocumentItem.class);
            entity.setErpConfigContext(erpConfigContext);
            return entity;
        }
    }

    public static class MaterialDocumentItem {
        @ElementName(value="MaterialDocumentYear")
        private String materialDocumentYear;
        public static EntityField<String, MaterialDocumentItem> MATERIAL_DOCUMENT_YEAR = new EntityField("MaterialDocumentYear");
        @ElementName(value="InventoryValuationType")
        private String inventoryValuationType;
        public static EntityField<String, MaterialDocumentItem> INVENTORY_VALUATION_TYPE = new EntityField("InventoryValuationType");
        @ElementName(value="InventorySpecialStockType")
        private String inventorySpecialStockType;
        public static EntityField<String, MaterialDocumentItem> INVENTORY_SPECIAL_STOCK_TYPE = new EntityField("InventorySpecialStockType");
        @ElementName(value="Supplier")
        private String supplier;
        public static EntityField<String, MaterialDocumentItem> SUPPLIER = new EntityField("Supplier");
        @ElementName(value="Customer")
        private String customer;
        public static EntityField<String, MaterialDocumentItem> CUSTOMER = new EntityField("Customer");
        @ElementName(value="SalesOrder")
        private String salesOrder;
        public static EntityField<String, MaterialDocumentItem> SALES_ORDER = new EntityField("SalesOrder");
        @ElementName(value="SalesOrderItem")
        private String salesOrderItem;
        public static EntityField<String, MaterialDocumentItem> SALES_ORDER_ITEM = new EntityField("SalesOrderItem");
        @ElementName(value="SalesOrderScheduleLine")
        private String salesOrderScheduleLine;
        public static EntityField<String, MaterialDocumentItem> SALES_ORDER_SCHEDULE_LINE = new EntityField("SalesOrderScheduleLine");
        @ElementName(value="PurchaseOrder")
        private String purchaseOrder;
        public static EntityField<String, MaterialDocumentItem> PURCHASE_ORDER = new EntityField("PurchaseOrder");
        @ElementName(value="PurchaseOrderItem")
        private String purchaseOrderItem;
        public static EntityField<String, MaterialDocumentItem> PURCHASE_ORDER_ITEM = new EntityField("PurchaseOrderItem");
        @ElementName(value="WBSElement")
        private String wBSElement;
        public static EntityField<String, MaterialDocumentItem> W_B_S_ELEMENT = new EntityField("WBSElement");
        @ElementName(value="MaterialDocument")
        private String materialDocument;
        public static EntityField<String, MaterialDocumentItem> MATERIAL_DOCUMENT = new EntityField("MaterialDocument");
        @ElementName(value="ManufacturingOrder")
        private String manufacturingOrder;
        public static EntityField<String, MaterialDocumentItem> MANUFACTURING_ORDER = new EntityField("ManufacturingOrder");
        @ElementName(value="ManufacturingOrderItem")
        private String manufacturingOrderItem;
        public static EntityField<String, MaterialDocumentItem> MANUFACTURING_ORDER_ITEM = new EntityField("ManufacturingOrderItem");
        @ElementName(value="GoodsMovementRefDocType")
        private String goodsMovementRefDocType;
        public static EntityField<String, MaterialDocumentItem> GOODS_MOVEMENT_REF_DOC_TYPE = new EntityField("GoodsMovementRefDocType");
        @ElementName(value="GoodsMovementReasonCode")
        private String goodsMovementReasonCode;
        public static EntityField<String, MaterialDocumentItem> GOODS_MOVEMENT_REASON_CODE = new EntityField("GoodsMovementReasonCode");
        @ElementName(value="AccountAssignmentCategory")
        private String accountAssignmentCategory;
        public static EntityField<String, MaterialDocumentItem> ACCOUNT_ASSIGNMENT_CATEGORY = new EntityField("AccountAssignmentCategory");
        @ElementName(value="CostCenter")
        private String costCenter;
        public static EntityField<String, MaterialDocumentItem> COST_CENTER = new EntityField("CostCenter");
        @ElementName(value="ControllingArea")
        private String controllingArea;
        public static EntityField<String, MaterialDocumentItem> CONTROLLING_AREA = new EntityField("ControllingArea");
        @ElementName(value="CostObject")
        private String costObject;
        public static EntityField<String, MaterialDocumentItem> COST_OBJECT = new EntityField("CostObject");
        @ElementName(value="ProfitabilitySegment")
        private String profitabilitySegment;
        public static EntityField<String, MaterialDocumentItem> PROFITABILITY_SEGMENT = new EntityField("ProfitabilitySegment");
        @ElementName(value="ProfitCenter")
        private String profitCenter;
        public static EntityField<String, MaterialDocumentItem> PROFIT_CENTER = new EntityField("ProfitCenter");
        @ElementName(value="MaterialDocumentItem")
        private String materialDocumentItem;
        public static EntityField<String, MaterialDocumentItem> MATERIAL_DOCUMENT_ITEM = new EntityField("MaterialDocumentItem");
        @ElementName(value="GLAccount")
        private String gLAccount;
        public static EntityField<String, MaterialDocumentItem> G_L_ACCOUNT = new EntityField("GLAccount");
        @ElementName(value="FunctionalArea")
        private String functionalArea;
        public static EntityField<String, MaterialDocumentItem> FUNCTIONAL_AREA = new EntityField("FunctionalArea");
        @ElementName(value="MaterialBaseUnit")
        private String materialBaseUnit;
        public static EntityField<String, MaterialDocumentItem> MATERIAL_BASE_UNIT = new EntityField("MaterialBaseUnit");
        @ElementName(value="QuantityInBaseUnit")
        private BigDecimal quantityInBaseUnit;
        public static EntityField<BigDecimal, MaterialDocumentItem> QUANTITY_IN_BASE_UNIT = new EntityField("QuantityInBaseUnit");
        @ElementName(value="EntryUnit")
        private String entryUnit;
        public static EntityField<String, MaterialDocumentItem> ENTRY_UNIT = new EntityField("EntryUnit");
        @ElementName(value="QuantityInEntryUnit")
        private BigDecimal quantityInEntryUnit;
        public static EntityField<BigDecimal, MaterialDocumentItem> QUANTITY_IN_ENTRY_UNIT = new EntityField("QuantityInEntryUnit");
        @ElementName(value="CompanyCodeCurrency")
        private String companyCodeCurrency;
        public static EntityField<String, MaterialDocumentItem> COMPANY_CODE_CURRENCY = new EntityField("CompanyCodeCurrency");
        @ElementName(value="GdsMvtExtAmtInCoCodeCrcy")
        private BigDecimal gdsMvtExtAmtInCoCodeCrcy;
        public static EntityField<BigDecimal, MaterialDocumentItem> GDS_MVT_EXT_AMT_IN_CO_CODE_CRCY = new EntityField("GdsMvtExtAmtInCoCodeCrcy");
        @ElementName(value="SlsPrcAmtInclVATInCoCodeCrcy")
        private BigDecimal slsPrcAmtInclVATInCoCodeCrcy;
        public static EntityField<BigDecimal, MaterialDocumentItem> SLS_PRC_AMT_INCL_V_A_T_IN_CO_CODE_CRCY = new EntityField("SlsPrcAmtInclVATInCoCodeCrcy");
        @ElementName(value="FiscalYear")
        private String fiscalYear;
        public static EntityField<String, MaterialDocumentItem> FISCAL_YEAR = new EntityField("FiscalYear");
        @ElementName(value="Material")
        private String material;
        public static EntityField<String, MaterialDocumentItem> MATERIAL = new EntityField("Material");
        @ElementName(value="FiscalYearPeriod")
        private String fiscalYearPeriod;
        public static EntityField<String, MaterialDocumentItem> FISCAL_YEAR_PERIOD = new EntityField("FiscalYearPeriod");
        @ElementName(value="FiscalYearVariant")
        private String fiscalYearVariant;
        public static EntityField<String, MaterialDocumentItem> FISCAL_YEAR_VARIANT = new EntityField("FiscalYearVariant");
        @ElementName(value="IssgOrRcvgMaterial")
        private String issgOrRcvgMaterial;
        public static EntityField<String, MaterialDocumentItem> ISSG_OR_RCVG_MATERIAL = new EntityField("IssgOrRcvgMaterial");
        @ElementName(value="IssgOrRcvgBatch")
        private String issgOrRcvgBatch;
        public static EntityField<String, MaterialDocumentItem> ISSG_OR_RCVG_BATCH = new EntityField("IssgOrRcvgBatch");
        @ElementName(value="IssuingOrReceivingPlant")
        private String issuingOrReceivingPlant;
        public static EntityField<String, MaterialDocumentItem> ISSUING_OR_RECEIVING_PLANT = new EntityField("IssuingOrReceivingPlant");
        @ElementName(value="IssuingOrReceivingStorageLoc")
        private String issuingOrReceivingStorageLoc;
        public static EntityField<String, MaterialDocumentItem> ISSUING_OR_RECEIVING_STORAGE_LOC = new EntityField("IssuingOrReceivingStorageLoc");
        @ElementName(value="IssuingOrReceivingStockType")
        private String issuingOrReceivingStockType;
        public static EntityField<String, MaterialDocumentItem> ISSUING_OR_RECEIVING_STOCK_TYPE = new EntityField("IssuingOrReceivingStockType");
        @ElementName(value="IssgOrRcvgSpclStockInd")
        private String issgOrRcvgSpclStockInd;
        public static EntityField<String, MaterialDocumentItem> ISSG_OR_RCVG_SPCL_STOCK_IND = new EntityField("IssgOrRcvgSpclStockInd");
        @ElementName(value="IssuingOrReceivingValType")
        private String issuingOrReceivingValType;
        public static EntityField<String, MaterialDocumentItem> ISSUING_OR_RECEIVING_VAL_TYPE = new EntityField("IssuingOrReceivingValType");
        @ElementName(value="IsCompletelyDelivered")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean isCompletelyDelivered;
        public static EntityField<Boolean, MaterialDocumentItem> IS_COMPLETELY_DELIVERED = new EntityField("IsCompletelyDelivered");
        @ElementName(value="Plant")
        private String plant;
        public static EntityField<String, MaterialDocumentItem> PLANT = new EntityField("Plant");
        @ElementName(value="MaterialDocumentItemText")
        private String materialDocumentItemText;
        public static EntityField<String, MaterialDocumentItem> MATERIAL_DOCUMENT_ITEM_TEXT = new EntityField("MaterialDocumentItemText");
        @ElementName(value="UnloadingPointName")
        private String unloadingPointName;
        public static EntityField<String, MaterialDocumentItem> UNLOADING_POINT_NAME = new EntityField("UnloadingPointName");
        @ElementName(value="ShelfLifeExpirationDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar shelfLifeExpirationDate;
        public static EntityField<Calendar, MaterialDocumentItem> SHELF_LIFE_EXPIRATION_DATE = new EntityField("ShelfLifeExpirationDate");
        @ElementName(value="ManufactureDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar manufactureDate;
        public static EntityField<Calendar, MaterialDocumentItem> MANUFACTURE_DATE = new EntityField("ManufactureDate");
        @ElementName(value="Reservation")
        private String reservation;
        public static EntityField<String, MaterialDocumentItem> RESERVATION = new EntityField("Reservation");
        @ElementName(value="ReservationItem")
        private String reservationItem;
        public static EntityField<String, MaterialDocumentItem> RESERVATION_ITEM = new EntityField("ReservationItem");
        @ElementName(value="ReservationIsFinallyIssued")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean reservationIsFinallyIssued;
        public static EntityField<Boolean, MaterialDocumentItem> RESERVATION_IS_FINALLY_ISSUED = new EntityField("ReservationIsFinallyIssued");
        @ElementName(value="SpecialStockIdfgSalesOrder")
        private String specialStockIdfgSalesOrder;
        public static EntityField<String, MaterialDocumentItem> SPECIAL_STOCK_IDFG_SALES_ORDER = new EntityField("SpecialStockIdfgSalesOrder");
        @ElementName(value="SpecialStockIdfgSalesOrderItem")
        private String specialStockIdfgSalesOrderItem;
        public static EntityField<String, MaterialDocumentItem> SPECIAL_STOCK_IDFG_SALES_ORDER_ITEM = new EntityField("SpecialStockIdfgSalesOrderItem");
        @ElementName(value="SpecialStockIdfgWBSElement")
        private String specialStockIdfgWBSElement;
        public static EntityField<String, MaterialDocumentItem> SPECIAL_STOCK_IDFG_W_B_S_ELEMENT = new EntityField("SpecialStockIdfgWBSElement");
        @ElementName(value="StorageLocation")
        private String storageLocation;
        public static EntityField<String, MaterialDocumentItem> STORAGE_LOCATION = new EntityField("StorageLocation");
        @ElementName(value="IsAutomaticallyCreated")
        private String isAutomaticallyCreated;
        public static EntityField<String, MaterialDocumentItem> IS_AUTOMATICALLY_CREATED = new EntityField("IsAutomaticallyCreated");
        @ElementName(value="MaterialDocumentLine")
        private String materialDocumentLine;
        public static EntityField<String, MaterialDocumentItem> MATERIAL_DOCUMENT_LINE = new EntityField("MaterialDocumentLine");
        @ElementName(value="MaterialDocumentParentLine")
        private String materialDocumentParentLine;
        public static EntityField<String, MaterialDocumentItem> MATERIAL_DOCUMENT_PARENT_LINE = new EntityField("MaterialDocumentParentLine");
        @ElementName(value="HierarchyNodeLevel")
        private String hierarchyNodeLevel;
        public static EntityField<String, MaterialDocumentItem> HIERARCHY_NODE_LEVEL = new EntityField("HierarchyNodeLevel");
        @ElementName(value="GoodsMovementIsCancelled")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean goodsMovementIsCancelled;
        public static EntityField<Boolean, MaterialDocumentItem> GOODS_MOVEMENT_IS_CANCELLED = new EntityField("GoodsMovementIsCancelled");
        @ElementName(value="ReversedMaterialDocumentYear")
        private String reversedMaterialDocumentYear;
        public static EntityField<String, MaterialDocumentItem> REVERSED_MATERIAL_DOCUMENT_YEAR = new EntityField("ReversedMaterialDocumentYear");
        @ElementName(value="ReversedMaterialDocument")
        private String reversedMaterialDocument;
        public static EntityField<String, MaterialDocumentItem> REVERSED_MATERIAL_DOCUMENT = new EntityField("ReversedMaterialDocument");
        @ElementName(value="ReversedMaterialDocumentItem")
        private String reversedMaterialDocumentItem;
        public static EntityField<String, MaterialDocumentItem> REVERSED_MATERIAL_DOCUMENT_ITEM = new EntityField("ReversedMaterialDocumentItem");
        @ElementName(value="Batch")
        private String batch;
        public static EntityField<String, MaterialDocumentItem> BATCH = new EntityField("Batch");
        @ElementName(value="GoodsMovementType")
        private String goodsMovementType;
        public static EntityField<String, MaterialDocumentItem> GOODS_MOVEMENT_TYPE = new EntityField("GoodsMovementType");
        @ElementName(value="InventoryStockType")
        private String inventoryStockType;
        public static EntityField<String, MaterialDocumentItem> INVENTORY_STOCK_TYPE = new EntityField("InventoryStockType");
        private static final transient String ODATA_ENDPOINT_URL = "/sap/opu/odata/sap/API_MATERIAL_DOCUMENT_SRV";
        private static final transient String ODATA_ENTITY_COLLECTION = "A_MaterialDocumentItem";
        private transient ErpConfigContext erpConfigContext;

        @JsonIgnore
        public MaterialDocumentHeader fetchMaterialDocumentHeader() throws ODataException {
            StringBuilder odataResourceUrl = new StringBuilder(ODATA_ENTITY_COLLECTION);
            odataResourceUrl.append("(");
            odataResourceUrl.append("MaterialDocumentYear=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.materialDocumentYear));
            odataResourceUrl.append(",MaterialDocument=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.materialDocument));
            odataResourceUrl.append(",MaterialDocumentItem=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.materialDocumentItem));
            odataResourceUrl.append(")/");
            odataResourceUrl.append("to_MaterialDocumentHeader");
            ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)ODATA_ENDPOINT_URL, (String)odataResourceUrl.toString());
            ODataQuery query = builder.build();
            ErpEndpoint erpEndpoint = new ErpEndpoint(this.erpConfigContext);
            ODataQueryResult result = query.execute((WithDestinationName)erpEndpoint);
            MaterialDocumentHeader entityList = (MaterialDocumentHeader)result.as(MaterialDocumentHeader.class);
            entityList.setErpConfigContext(this.erpConfigContext);
            return entityList;
        }

        public String toString() {
            return "RetrieveMaterialDocumentsNamespace.MaterialDocumentItem(materialDocumentYear=" + this.materialDocumentYear + ", inventoryValuationType=" + this.inventoryValuationType + ", inventorySpecialStockType=" + this.inventorySpecialStockType + ", supplier=" + this.supplier + ", customer=" + this.customer + ", salesOrder=" + this.salesOrder + ", salesOrderItem=" + this.salesOrderItem + ", salesOrderScheduleLine=" + this.salesOrderScheduleLine + ", purchaseOrder=" + this.purchaseOrder + ", purchaseOrderItem=" + this.purchaseOrderItem + ", wBSElement=" + this.wBSElement + ", materialDocument=" + this.materialDocument + ", manufacturingOrder=" + this.manufacturingOrder + ", manufacturingOrderItem=" + this.manufacturingOrderItem + ", goodsMovementRefDocType=" + this.goodsMovementRefDocType + ", goodsMovementReasonCode=" + this.goodsMovementReasonCode + ", accountAssignmentCategory=" + this.accountAssignmentCategory + ", costCenter=" + this.costCenter + ", controllingArea=" + this.controllingArea + ", costObject=" + this.costObject + ", profitabilitySegment=" + this.profitabilitySegment + ", profitCenter=" + this.profitCenter + ", materialDocumentItem=" + this.materialDocumentItem + ", gLAccount=" + this.gLAccount + ", functionalArea=" + this.functionalArea + ", materialBaseUnit=" + this.materialBaseUnit + ", quantityInBaseUnit=" + this.quantityInBaseUnit + ", entryUnit=" + this.entryUnit + ", quantityInEntryUnit=" + this.quantityInEntryUnit + ", companyCodeCurrency=" + this.companyCodeCurrency + ", gdsMvtExtAmtInCoCodeCrcy=" + this.gdsMvtExtAmtInCoCodeCrcy + ", slsPrcAmtInclVATInCoCodeCrcy=" + this.slsPrcAmtInclVATInCoCodeCrcy + ", fiscalYear=" + this.fiscalYear + ", material=" + this.material + ", fiscalYearPeriod=" + this.fiscalYearPeriod + ", fiscalYearVariant=" + this.fiscalYearVariant + ", issgOrRcvgMaterial=" + this.issgOrRcvgMaterial + ", issgOrRcvgBatch=" + this.issgOrRcvgBatch + ", issuingOrReceivingPlant=" + this.issuingOrReceivingPlant + ", issuingOrReceivingStorageLoc=" + this.issuingOrReceivingStorageLoc + ", issuingOrReceivingStockType=" + this.issuingOrReceivingStockType + ", issgOrRcvgSpclStockInd=" + this.issgOrRcvgSpclStockInd + ", issuingOrReceivingValType=" + this.issuingOrReceivingValType + ", isCompletelyDelivered=" + this.isCompletelyDelivered + ", plant=" + this.plant + ", materialDocumentItemText=" + this.materialDocumentItemText + ", unloadingPointName=" + this.unloadingPointName + ", shelfLifeExpirationDate=" + this.shelfLifeExpirationDate + ", manufactureDate=" + this.manufactureDate + ", reservation=" + this.reservation + ", reservationItem=" + this.reservationItem + ", reservationIsFinallyIssued=" + this.reservationIsFinallyIssued + ", specialStockIdfgSalesOrder=" + this.specialStockIdfgSalesOrder + ", specialStockIdfgSalesOrderItem=" + this.specialStockIdfgSalesOrderItem + ", specialStockIdfgWBSElement=" + this.specialStockIdfgWBSElement + ", storageLocation=" + this.storageLocation + ", isAutomaticallyCreated=" + this.isAutomaticallyCreated + ", materialDocumentLine=" + this.materialDocumentLine + ", materialDocumentParentLine=" + this.materialDocumentParentLine + ", hierarchyNodeLevel=" + this.hierarchyNodeLevel + ", goodsMovementIsCancelled=" + this.goodsMovementIsCancelled + ", reversedMaterialDocumentYear=" + this.reversedMaterialDocumentYear + ", reversedMaterialDocument=" + this.reversedMaterialDocument + ", reversedMaterialDocumentItem=" + this.reversedMaterialDocumentItem + ", batch=" + this.batch + ", goodsMovementType=" + this.goodsMovementType + ", inventoryStockType=" + this.inventoryStockType + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MaterialDocumentItem)) {
                return false;
            }
            MaterialDocumentItem other = (MaterialDocumentItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$materialDocumentYear = this.materialDocumentYear;
            String other$materialDocumentYear = other.materialDocumentYear;
            if (this$materialDocumentYear == null ? other$materialDocumentYear != null : !this$materialDocumentYear.equals(other$materialDocumentYear)) {
                return false;
            }
            String this$inventoryValuationType = this.inventoryValuationType;
            String other$inventoryValuationType = other.inventoryValuationType;
            if (this$inventoryValuationType == null ? other$inventoryValuationType != null : !this$inventoryValuationType.equals(other$inventoryValuationType)) {
                return false;
            }
            String this$inventorySpecialStockType = this.inventorySpecialStockType;
            String other$inventorySpecialStockType = other.inventorySpecialStockType;
            if (this$inventorySpecialStockType == null ? other$inventorySpecialStockType != null : !this$inventorySpecialStockType.equals(other$inventorySpecialStockType)) {
                return false;
            }
            String this$supplier = this.supplier;
            String other$supplier = other.supplier;
            if (this$supplier == null ? other$supplier != null : !this$supplier.equals(other$supplier)) {
                return false;
            }
            String this$customer = this.customer;
            String other$customer = other.customer;
            if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
                return false;
            }
            String this$salesOrder = this.salesOrder;
            String other$salesOrder = other.salesOrder;
            if (this$salesOrder == null ? other$salesOrder != null : !this$salesOrder.equals(other$salesOrder)) {
                return false;
            }
            String this$salesOrderItem = this.salesOrderItem;
            String other$salesOrderItem = other.salesOrderItem;
            if (this$salesOrderItem == null ? other$salesOrderItem != null : !this$salesOrderItem.equals(other$salesOrderItem)) {
                return false;
            }
            String this$salesOrderScheduleLine = this.salesOrderScheduleLine;
            String other$salesOrderScheduleLine = other.salesOrderScheduleLine;
            if (this$salesOrderScheduleLine == null ? other$salesOrderScheduleLine != null : !this$salesOrderScheduleLine.equals(other$salesOrderScheduleLine)) {
                return false;
            }
            String this$purchaseOrder = this.purchaseOrder;
            String other$purchaseOrder = other.purchaseOrder;
            if (this$purchaseOrder == null ? other$purchaseOrder != null : !this$purchaseOrder.equals(other$purchaseOrder)) {
                return false;
            }
            String this$purchaseOrderItem = this.purchaseOrderItem;
            String other$purchaseOrderItem = other.purchaseOrderItem;
            if (this$purchaseOrderItem == null ? other$purchaseOrderItem != null : !this$purchaseOrderItem.equals(other$purchaseOrderItem)) {
                return false;
            }
            String this$wBSElement = this.wBSElement;
            String other$wBSElement = other.wBSElement;
            if (this$wBSElement == null ? other$wBSElement != null : !this$wBSElement.equals(other$wBSElement)) {
                return false;
            }
            String this$materialDocument = this.materialDocument;
            String other$materialDocument = other.materialDocument;
            if (this$materialDocument == null ? other$materialDocument != null : !this$materialDocument.equals(other$materialDocument)) {
                return false;
            }
            String this$manufacturingOrder = this.manufacturingOrder;
            String other$manufacturingOrder = other.manufacturingOrder;
            if (this$manufacturingOrder == null ? other$manufacturingOrder != null : !this$manufacturingOrder.equals(other$manufacturingOrder)) {
                return false;
            }
            String this$manufacturingOrderItem = this.manufacturingOrderItem;
            String other$manufacturingOrderItem = other.manufacturingOrderItem;
            if (this$manufacturingOrderItem == null ? other$manufacturingOrderItem != null : !this$manufacturingOrderItem.equals(other$manufacturingOrderItem)) {
                return false;
            }
            String this$goodsMovementRefDocType = this.goodsMovementRefDocType;
            String other$goodsMovementRefDocType = other.goodsMovementRefDocType;
            if (this$goodsMovementRefDocType == null ? other$goodsMovementRefDocType != null : !this$goodsMovementRefDocType.equals(other$goodsMovementRefDocType)) {
                return false;
            }
            String this$goodsMovementReasonCode = this.goodsMovementReasonCode;
            String other$goodsMovementReasonCode = other.goodsMovementReasonCode;
            if (this$goodsMovementReasonCode == null ? other$goodsMovementReasonCode != null : !this$goodsMovementReasonCode.equals(other$goodsMovementReasonCode)) {
                return false;
            }
            String this$accountAssignmentCategory = this.accountAssignmentCategory;
            String other$accountAssignmentCategory = other.accountAssignmentCategory;
            if (this$accountAssignmentCategory == null ? other$accountAssignmentCategory != null : !this$accountAssignmentCategory.equals(other$accountAssignmentCategory)) {
                return false;
            }
            String this$costCenter = this.costCenter;
            String other$costCenter = other.costCenter;
            if (this$costCenter == null ? other$costCenter != null : !this$costCenter.equals(other$costCenter)) {
                return false;
            }
            String this$controllingArea = this.controllingArea;
            String other$controllingArea = other.controllingArea;
            if (this$controllingArea == null ? other$controllingArea != null : !this$controllingArea.equals(other$controllingArea)) {
                return false;
            }
            String this$costObject = this.costObject;
            String other$costObject = other.costObject;
            if (this$costObject == null ? other$costObject != null : !this$costObject.equals(other$costObject)) {
                return false;
            }
            String this$profitabilitySegment = this.profitabilitySegment;
            String other$profitabilitySegment = other.profitabilitySegment;
            if (this$profitabilitySegment == null ? other$profitabilitySegment != null : !this$profitabilitySegment.equals(other$profitabilitySegment)) {
                return false;
            }
            String this$profitCenter = this.profitCenter;
            String other$profitCenter = other.profitCenter;
            if (this$profitCenter == null ? other$profitCenter != null : !this$profitCenter.equals(other$profitCenter)) {
                return false;
            }
            String this$materialDocumentItem = this.materialDocumentItem;
            String other$materialDocumentItem = other.materialDocumentItem;
            if (this$materialDocumentItem == null ? other$materialDocumentItem != null : !this$materialDocumentItem.equals(other$materialDocumentItem)) {
                return false;
            }
            String this$gLAccount = this.gLAccount;
            String other$gLAccount = other.gLAccount;
            if (this$gLAccount == null ? other$gLAccount != null : !this$gLAccount.equals(other$gLAccount)) {
                return false;
            }
            String this$functionalArea = this.functionalArea;
            String other$functionalArea = other.functionalArea;
            if (this$functionalArea == null ? other$functionalArea != null : !this$functionalArea.equals(other$functionalArea)) {
                return false;
            }
            String this$materialBaseUnit = this.materialBaseUnit;
            String other$materialBaseUnit = other.materialBaseUnit;
            if (this$materialBaseUnit == null ? other$materialBaseUnit != null : !this$materialBaseUnit.equals(other$materialBaseUnit)) {
                return false;
            }
            BigDecimal this$quantityInBaseUnit = this.quantityInBaseUnit;
            BigDecimal other$quantityInBaseUnit = other.quantityInBaseUnit;
            if (this$quantityInBaseUnit == null ? other$quantityInBaseUnit != null : !((Object)this$quantityInBaseUnit).equals(other$quantityInBaseUnit)) {
                return false;
            }
            String this$entryUnit = this.entryUnit;
            String other$entryUnit = other.entryUnit;
            if (this$entryUnit == null ? other$entryUnit != null : !this$entryUnit.equals(other$entryUnit)) {
                return false;
            }
            BigDecimal this$quantityInEntryUnit = this.quantityInEntryUnit;
            BigDecimal other$quantityInEntryUnit = other.quantityInEntryUnit;
            if (this$quantityInEntryUnit == null ? other$quantityInEntryUnit != null : !((Object)this$quantityInEntryUnit).equals(other$quantityInEntryUnit)) {
                return false;
            }
            String this$companyCodeCurrency = this.companyCodeCurrency;
            String other$companyCodeCurrency = other.companyCodeCurrency;
            if (this$companyCodeCurrency == null ? other$companyCodeCurrency != null : !this$companyCodeCurrency.equals(other$companyCodeCurrency)) {
                return false;
            }
            BigDecimal this$gdsMvtExtAmtInCoCodeCrcy = this.gdsMvtExtAmtInCoCodeCrcy;
            BigDecimal other$gdsMvtExtAmtInCoCodeCrcy = other.gdsMvtExtAmtInCoCodeCrcy;
            if (this$gdsMvtExtAmtInCoCodeCrcy == null ? other$gdsMvtExtAmtInCoCodeCrcy != null : !((Object)this$gdsMvtExtAmtInCoCodeCrcy).equals(other$gdsMvtExtAmtInCoCodeCrcy)) {
                return false;
            }
            BigDecimal this$slsPrcAmtInclVATInCoCodeCrcy = this.slsPrcAmtInclVATInCoCodeCrcy;
            BigDecimal other$slsPrcAmtInclVATInCoCodeCrcy = other.slsPrcAmtInclVATInCoCodeCrcy;
            if (this$slsPrcAmtInclVATInCoCodeCrcy == null ? other$slsPrcAmtInclVATInCoCodeCrcy != null : !((Object)this$slsPrcAmtInclVATInCoCodeCrcy).equals(other$slsPrcAmtInclVATInCoCodeCrcy)) {
                return false;
            }
            String this$fiscalYear = this.fiscalYear;
            String other$fiscalYear = other.fiscalYear;
            if (this$fiscalYear == null ? other$fiscalYear != null : !this$fiscalYear.equals(other$fiscalYear)) {
                return false;
            }
            String this$material = this.material;
            String other$material = other.material;
            if (this$material == null ? other$material != null : !this$material.equals(other$material)) {
                return false;
            }
            String this$fiscalYearPeriod = this.fiscalYearPeriod;
            String other$fiscalYearPeriod = other.fiscalYearPeriod;
            if (this$fiscalYearPeriod == null ? other$fiscalYearPeriod != null : !this$fiscalYearPeriod.equals(other$fiscalYearPeriod)) {
                return false;
            }
            String this$fiscalYearVariant = this.fiscalYearVariant;
            String other$fiscalYearVariant = other.fiscalYearVariant;
            if (this$fiscalYearVariant == null ? other$fiscalYearVariant != null : !this$fiscalYearVariant.equals(other$fiscalYearVariant)) {
                return false;
            }
            String this$issgOrRcvgMaterial = this.issgOrRcvgMaterial;
            String other$issgOrRcvgMaterial = other.issgOrRcvgMaterial;
            if (this$issgOrRcvgMaterial == null ? other$issgOrRcvgMaterial != null : !this$issgOrRcvgMaterial.equals(other$issgOrRcvgMaterial)) {
                return false;
            }
            String this$issgOrRcvgBatch = this.issgOrRcvgBatch;
            String other$issgOrRcvgBatch = other.issgOrRcvgBatch;
            if (this$issgOrRcvgBatch == null ? other$issgOrRcvgBatch != null : !this$issgOrRcvgBatch.equals(other$issgOrRcvgBatch)) {
                return false;
            }
            String this$issuingOrReceivingPlant = this.issuingOrReceivingPlant;
            String other$issuingOrReceivingPlant = other.issuingOrReceivingPlant;
            if (this$issuingOrReceivingPlant == null ? other$issuingOrReceivingPlant != null : !this$issuingOrReceivingPlant.equals(other$issuingOrReceivingPlant)) {
                return false;
            }
            String this$issuingOrReceivingStorageLoc = this.issuingOrReceivingStorageLoc;
            String other$issuingOrReceivingStorageLoc = other.issuingOrReceivingStorageLoc;
            if (this$issuingOrReceivingStorageLoc == null ? other$issuingOrReceivingStorageLoc != null : !this$issuingOrReceivingStorageLoc.equals(other$issuingOrReceivingStorageLoc)) {
                return false;
            }
            String this$issuingOrReceivingStockType = this.issuingOrReceivingStockType;
            String other$issuingOrReceivingStockType = other.issuingOrReceivingStockType;
            if (this$issuingOrReceivingStockType == null ? other$issuingOrReceivingStockType != null : !this$issuingOrReceivingStockType.equals(other$issuingOrReceivingStockType)) {
                return false;
            }
            String this$issgOrRcvgSpclStockInd = this.issgOrRcvgSpclStockInd;
            String other$issgOrRcvgSpclStockInd = other.issgOrRcvgSpclStockInd;
            if (this$issgOrRcvgSpclStockInd == null ? other$issgOrRcvgSpclStockInd != null : !this$issgOrRcvgSpclStockInd.equals(other$issgOrRcvgSpclStockInd)) {
                return false;
            }
            String this$issuingOrReceivingValType = this.issuingOrReceivingValType;
            String other$issuingOrReceivingValType = other.issuingOrReceivingValType;
            if (this$issuingOrReceivingValType == null ? other$issuingOrReceivingValType != null : !this$issuingOrReceivingValType.equals(other$issuingOrReceivingValType)) {
                return false;
            }
            Boolean this$isCompletelyDelivered = this.isCompletelyDelivered;
            Boolean other$isCompletelyDelivered = other.isCompletelyDelivered;
            if (this$isCompletelyDelivered == null ? other$isCompletelyDelivered != null : !((Object)this$isCompletelyDelivered).equals(other$isCompletelyDelivered)) {
                return false;
            }
            String this$plant = this.plant;
            String other$plant = other.plant;
            if (this$plant == null ? other$plant != null : !this$plant.equals(other$plant)) {
                return false;
            }
            String this$materialDocumentItemText = this.materialDocumentItemText;
            String other$materialDocumentItemText = other.materialDocumentItemText;
            if (this$materialDocumentItemText == null ? other$materialDocumentItemText != null : !this$materialDocumentItemText.equals(other$materialDocumentItemText)) {
                return false;
            }
            String this$unloadingPointName = this.unloadingPointName;
            String other$unloadingPointName = other.unloadingPointName;
            if (this$unloadingPointName == null ? other$unloadingPointName != null : !this$unloadingPointName.equals(other$unloadingPointName)) {
                return false;
            }
            Calendar this$shelfLifeExpirationDate = this.shelfLifeExpirationDate;
            Calendar other$shelfLifeExpirationDate = other.shelfLifeExpirationDate;
            if (this$shelfLifeExpirationDate == null ? other$shelfLifeExpirationDate != null : !((Object)this$shelfLifeExpirationDate).equals(other$shelfLifeExpirationDate)) {
                return false;
            }
            Calendar this$manufactureDate = this.manufactureDate;
            Calendar other$manufactureDate = other.manufactureDate;
            if (this$manufactureDate == null ? other$manufactureDate != null : !((Object)this$manufactureDate).equals(other$manufactureDate)) {
                return false;
            }
            String this$reservation = this.reservation;
            String other$reservation = other.reservation;
            if (this$reservation == null ? other$reservation != null : !this$reservation.equals(other$reservation)) {
                return false;
            }
            String this$reservationItem = this.reservationItem;
            String other$reservationItem = other.reservationItem;
            if (this$reservationItem == null ? other$reservationItem != null : !this$reservationItem.equals(other$reservationItem)) {
                return false;
            }
            Boolean this$reservationIsFinallyIssued = this.reservationIsFinallyIssued;
            Boolean other$reservationIsFinallyIssued = other.reservationIsFinallyIssued;
            if (this$reservationIsFinallyIssued == null ? other$reservationIsFinallyIssued != null : !((Object)this$reservationIsFinallyIssued).equals(other$reservationIsFinallyIssued)) {
                return false;
            }
            String this$specialStockIdfgSalesOrder = this.specialStockIdfgSalesOrder;
            String other$specialStockIdfgSalesOrder = other.specialStockIdfgSalesOrder;
            if (this$specialStockIdfgSalesOrder == null ? other$specialStockIdfgSalesOrder != null : !this$specialStockIdfgSalesOrder.equals(other$specialStockIdfgSalesOrder)) {
                return false;
            }
            String this$specialStockIdfgSalesOrderItem = this.specialStockIdfgSalesOrderItem;
            String other$specialStockIdfgSalesOrderItem = other.specialStockIdfgSalesOrderItem;
            if (this$specialStockIdfgSalesOrderItem == null ? other$specialStockIdfgSalesOrderItem != null : !this$specialStockIdfgSalesOrderItem.equals(other$specialStockIdfgSalesOrderItem)) {
                return false;
            }
            String this$specialStockIdfgWBSElement = this.specialStockIdfgWBSElement;
            String other$specialStockIdfgWBSElement = other.specialStockIdfgWBSElement;
            if (this$specialStockIdfgWBSElement == null ? other$specialStockIdfgWBSElement != null : !this$specialStockIdfgWBSElement.equals(other$specialStockIdfgWBSElement)) {
                return false;
            }
            String this$storageLocation = this.storageLocation;
            String other$storageLocation = other.storageLocation;
            if (this$storageLocation == null ? other$storageLocation != null : !this$storageLocation.equals(other$storageLocation)) {
                return false;
            }
            String this$isAutomaticallyCreated = this.isAutomaticallyCreated;
            String other$isAutomaticallyCreated = other.isAutomaticallyCreated;
            if (this$isAutomaticallyCreated == null ? other$isAutomaticallyCreated != null : !this$isAutomaticallyCreated.equals(other$isAutomaticallyCreated)) {
                return false;
            }
            String this$materialDocumentLine = this.materialDocumentLine;
            String other$materialDocumentLine = other.materialDocumentLine;
            if (this$materialDocumentLine == null ? other$materialDocumentLine != null : !this$materialDocumentLine.equals(other$materialDocumentLine)) {
                return false;
            }
            String this$materialDocumentParentLine = this.materialDocumentParentLine;
            String other$materialDocumentParentLine = other.materialDocumentParentLine;
            if (this$materialDocumentParentLine == null ? other$materialDocumentParentLine != null : !this$materialDocumentParentLine.equals(other$materialDocumentParentLine)) {
                return false;
            }
            String this$hierarchyNodeLevel = this.hierarchyNodeLevel;
            String other$hierarchyNodeLevel = other.hierarchyNodeLevel;
            if (this$hierarchyNodeLevel == null ? other$hierarchyNodeLevel != null : !this$hierarchyNodeLevel.equals(other$hierarchyNodeLevel)) {
                return false;
            }
            Boolean this$goodsMovementIsCancelled = this.goodsMovementIsCancelled;
            Boolean other$goodsMovementIsCancelled = other.goodsMovementIsCancelled;
            if (this$goodsMovementIsCancelled == null ? other$goodsMovementIsCancelled != null : !((Object)this$goodsMovementIsCancelled).equals(other$goodsMovementIsCancelled)) {
                return false;
            }
            String this$reversedMaterialDocumentYear = this.reversedMaterialDocumentYear;
            String other$reversedMaterialDocumentYear = other.reversedMaterialDocumentYear;
            if (this$reversedMaterialDocumentYear == null ? other$reversedMaterialDocumentYear != null : !this$reversedMaterialDocumentYear.equals(other$reversedMaterialDocumentYear)) {
                return false;
            }
            String this$reversedMaterialDocument = this.reversedMaterialDocument;
            String other$reversedMaterialDocument = other.reversedMaterialDocument;
            if (this$reversedMaterialDocument == null ? other$reversedMaterialDocument != null : !this$reversedMaterialDocument.equals(other$reversedMaterialDocument)) {
                return false;
            }
            String this$reversedMaterialDocumentItem = this.reversedMaterialDocumentItem;
            String other$reversedMaterialDocumentItem = other.reversedMaterialDocumentItem;
            if (this$reversedMaterialDocumentItem == null ? other$reversedMaterialDocumentItem != null : !this$reversedMaterialDocumentItem.equals(other$reversedMaterialDocumentItem)) {
                return false;
            }
            String this$batch = this.batch;
            String other$batch = other.batch;
            if (this$batch == null ? other$batch != null : !this$batch.equals(other$batch)) {
                return false;
            }
            String this$goodsMovementType = this.goodsMovementType;
            String other$goodsMovementType = other.goodsMovementType;
            if (this$goodsMovementType == null ? other$goodsMovementType != null : !this$goodsMovementType.equals(other$goodsMovementType)) {
                return false;
            }
            String this$inventoryStockType = this.inventoryStockType;
            String other$inventoryStockType = other.inventoryStockType;
            return !(this$inventoryStockType == null ? other$inventoryStockType != null : !this$inventoryStockType.equals(other$inventoryStockType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MaterialDocumentItem;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $materialDocumentYear = this.materialDocumentYear;
            result = result * 59 + ($materialDocumentYear == null ? 43 : $materialDocumentYear.hashCode());
            String $inventoryValuationType = this.inventoryValuationType;
            result = result * 59 + ($inventoryValuationType == null ? 43 : $inventoryValuationType.hashCode());
            String $inventorySpecialStockType = this.inventorySpecialStockType;
            result = result * 59 + ($inventorySpecialStockType == null ? 43 : $inventorySpecialStockType.hashCode());
            String $supplier = this.supplier;
            result = result * 59 + ($supplier == null ? 43 : $supplier.hashCode());
            String $customer = this.customer;
            result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
            String $salesOrder = this.salesOrder;
            result = result * 59 + ($salesOrder == null ? 43 : $salesOrder.hashCode());
            String $salesOrderItem = this.salesOrderItem;
            result = result * 59 + ($salesOrderItem == null ? 43 : $salesOrderItem.hashCode());
            String $salesOrderScheduleLine = this.salesOrderScheduleLine;
            result = result * 59 + ($salesOrderScheduleLine == null ? 43 : $salesOrderScheduleLine.hashCode());
            String $purchaseOrder = this.purchaseOrder;
            result = result * 59 + ($purchaseOrder == null ? 43 : $purchaseOrder.hashCode());
            String $purchaseOrderItem = this.purchaseOrderItem;
            result = result * 59 + ($purchaseOrderItem == null ? 43 : $purchaseOrderItem.hashCode());
            String $wBSElement = this.wBSElement;
            result = result * 59 + ($wBSElement == null ? 43 : $wBSElement.hashCode());
            String $materialDocument = this.materialDocument;
            result = result * 59 + ($materialDocument == null ? 43 : $materialDocument.hashCode());
            String $manufacturingOrder = this.manufacturingOrder;
            result = result * 59 + ($manufacturingOrder == null ? 43 : $manufacturingOrder.hashCode());
            String $manufacturingOrderItem = this.manufacturingOrderItem;
            result = result * 59 + ($manufacturingOrderItem == null ? 43 : $manufacturingOrderItem.hashCode());
            String $goodsMovementRefDocType = this.goodsMovementRefDocType;
            result = result * 59 + ($goodsMovementRefDocType == null ? 43 : $goodsMovementRefDocType.hashCode());
            String $goodsMovementReasonCode = this.goodsMovementReasonCode;
            result = result * 59 + ($goodsMovementReasonCode == null ? 43 : $goodsMovementReasonCode.hashCode());
            String $accountAssignmentCategory = this.accountAssignmentCategory;
            result = result * 59 + ($accountAssignmentCategory == null ? 43 : $accountAssignmentCategory.hashCode());
            String $costCenter = this.costCenter;
            result = result * 59 + ($costCenter == null ? 43 : $costCenter.hashCode());
            String $controllingArea = this.controllingArea;
            result = result * 59 + ($controllingArea == null ? 43 : $controllingArea.hashCode());
            String $costObject = this.costObject;
            result = result * 59 + ($costObject == null ? 43 : $costObject.hashCode());
            String $profitabilitySegment = this.profitabilitySegment;
            result = result * 59 + ($profitabilitySegment == null ? 43 : $profitabilitySegment.hashCode());
            String $profitCenter = this.profitCenter;
            result = result * 59 + ($profitCenter == null ? 43 : $profitCenter.hashCode());
            String $materialDocumentItem = this.materialDocumentItem;
            result = result * 59 + ($materialDocumentItem == null ? 43 : $materialDocumentItem.hashCode());
            String $gLAccount = this.gLAccount;
            result = result * 59 + ($gLAccount == null ? 43 : $gLAccount.hashCode());
            String $functionalArea = this.functionalArea;
            result = result * 59 + ($functionalArea == null ? 43 : $functionalArea.hashCode());
            String $materialBaseUnit = this.materialBaseUnit;
            result = result * 59 + ($materialBaseUnit == null ? 43 : $materialBaseUnit.hashCode());
            BigDecimal $quantityInBaseUnit = this.quantityInBaseUnit;
            result = result * 59 + ($quantityInBaseUnit == null ? 43 : ((Object)$quantityInBaseUnit).hashCode());
            String $entryUnit = this.entryUnit;
            result = result * 59 + ($entryUnit == null ? 43 : $entryUnit.hashCode());
            BigDecimal $quantityInEntryUnit = this.quantityInEntryUnit;
            result = result * 59 + ($quantityInEntryUnit == null ? 43 : ((Object)$quantityInEntryUnit).hashCode());
            String $companyCodeCurrency = this.companyCodeCurrency;
            result = result * 59 + ($companyCodeCurrency == null ? 43 : $companyCodeCurrency.hashCode());
            BigDecimal $gdsMvtExtAmtInCoCodeCrcy = this.gdsMvtExtAmtInCoCodeCrcy;
            result = result * 59 + ($gdsMvtExtAmtInCoCodeCrcy == null ? 43 : ((Object)$gdsMvtExtAmtInCoCodeCrcy).hashCode());
            BigDecimal $slsPrcAmtInclVATInCoCodeCrcy = this.slsPrcAmtInclVATInCoCodeCrcy;
            result = result * 59 + ($slsPrcAmtInclVATInCoCodeCrcy == null ? 43 : ((Object)$slsPrcAmtInclVATInCoCodeCrcy).hashCode());
            String $fiscalYear = this.fiscalYear;
            result = result * 59 + ($fiscalYear == null ? 43 : $fiscalYear.hashCode());
            String $material = this.material;
            result = result * 59 + ($material == null ? 43 : $material.hashCode());
            String $fiscalYearPeriod = this.fiscalYearPeriod;
            result = result * 59 + ($fiscalYearPeriod == null ? 43 : $fiscalYearPeriod.hashCode());
            String $fiscalYearVariant = this.fiscalYearVariant;
            result = result * 59 + ($fiscalYearVariant == null ? 43 : $fiscalYearVariant.hashCode());
            String $issgOrRcvgMaterial = this.issgOrRcvgMaterial;
            result = result * 59 + ($issgOrRcvgMaterial == null ? 43 : $issgOrRcvgMaterial.hashCode());
            String $issgOrRcvgBatch = this.issgOrRcvgBatch;
            result = result * 59 + ($issgOrRcvgBatch == null ? 43 : $issgOrRcvgBatch.hashCode());
            String $issuingOrReceivingPlant = this.issuingOrReceivingPlant;
            result = result * 59 + ($issuingOrReceivingPlant == null ? 43 : $issuingOrReceivingPlant.hashCode());
            String $issuingOrReceivingStorageLoc = this.issuingOrReceivingStorageLoc;
            result = result * 59 + ($issuingOrReceivingStorageLoc == null ? 43 : $issuingOrReceivingStorageLoc.hashCode());
            String $issuingOrReceivingStockType = this.issuingOrReceivingStockType;
            result = result * 59 + ($issuingOrReceivingStockType == null ? 43 : $issuingOrReceivingStockType.hashCode());
            String $issgOrRcvgSpclStockInd = this.issgOrRcvgSpclStockInd;
            result = result * 59 + ($issgOrRcvgSpclStockInd == null ? 43 : $issgOrRcvgSpclStockInd.hashCode());
            String $issuingOrReceivingValType = this.issuingOrReceivingValType;
            result = result * 59 + ($issuingOrReceivingValType == null ? 43 : $issuingOrReceivingValType.hashCode());
            Boolean $isCompletelyDelivered = this.isCompletelyDelivered;
            result = result * 59 + ($isCompletelyDelivered == null ? 43 : ((Object)$isCompletelyDelivered).hashCode());
            String $plant = this.plant;
            result = result * 59 + ($plant == null ? 43 : $plant.hashCode());
            String $materialDocumentItemText = this.materialDocumentItemText;
            result = result * 59 + ($materialDocumentItemText == null ? 43 : $materialDocumentItemText.hashCode());
            String $unloadingPointName = this.unloadingPointName;
            result = result * 59 + ($unloadingPointName == null ? 43 : $unloadingPointName.hashCode());
            Calendar $shelfLifeExpirationDate = this.shelfLifeExpirationDate;
            result = result * 59 + ($shelfLifeExpirationDate == null ? 43 : ((Object)$shelfLifeExpirationDate).hashCode());
            Calendar $manufactureDate = this.manufactureDate;
            result = result * 59 + ($manufactureDate == null ? 43 : ((Object)$manufactureDate).hashCode());
            String $reservation = this.reservation;
            result = result * 59 + ($reservation == null ? 43 : $reservation.hashCode());
            String $reservationItem = this.reservationItem;
            result = result * 59 + ($reservationItem == null ? 43 : $reservationItem.hashCode());
            Boolean $reservationIsFinallyIssued = this.reservationIsFinallyIssued;
            result = result * 59 + ($reservationIsFinallyIssued == null ? 43 : ((Object)$reservationIsFinallyIssued).hashCode());
            String $specialStockIdfgSalesOrder = this.specialStockIdfgSalesOrder;
            result = result * 59 + ($specialStockIdfgSalesOrder == null ? 43 : $specialStockIdfgSalesOrder.hashCode());
            String $specialStockIdfgSalesOrderItem = this.specialStockIdfgSalesOrderItem;
            result = result * 59 + ($specialStockIdfgSalesOrderItem == null ? 43 : $specialStockIdfgSalesOrderItem.hashCode());
            String $specialStockIdfgWBSElement = this.specialStockIdfgWBSElement;
            result = result * 59 + ($specialStockIdfgWBSElement == null ? 43 : $specialStockIdfgWBSElement.hashCode());
            String $storageLocation = this.storageLocation;
            result = result * 59 + ($storageLocation == null ? 43 : $storageLocation.hashCode());
            String $isAutomaticallyCreated = this.isAutomaticallyCreated;
            result = result * 59 + ($isAutomaticallyCreated == null ? 43 : $isAutomaticallyCreated.hashCode());
            String $materialDocumentLine = this.materialDocumentLine;
            result = result * 59 + ($materialDocumentLine == null ? 43 : $materialDocumentLine.hashCode());
            String $materialDocumentParentLine = this.materialDocumentParentLine;
            result = result * 59 + ($materialDocumentParentLine == null ? 43 : $materialDocumentParentLine.hashCode());
            String $hierarchyNodeLevel = this.hierarchyNodeLevel;
            result = result * 59 + ($hierarchyNodeLevel == null ? 43 : $hierarchyNodeLevel.hashCode());
            Boolean $goodsMovementIsCancelled = this.goodsMovementIsCancelled;
            result = result * 59 + ($goodsMovementIsCancelled == null ? 43 : ((Object)$goodsMovementIsCancelled).hashCode());
            String $reversedMaterialDocumentYear = this.reversedMaterialDocumentYear;
            result = result * 59 + ($reversedMaterialDocumentYear == null ? 43 : $reversedMaterialDocumentYear.hashCode());
            String $reversedMaterialDocument = this.reversedMaterialDocument;
            result = result * 59 + ($reversedMaterialDocument == null ? 43 : $reversedMaterialDocument.hashCode());
            String $reversedMaterialDocumentItem = this.reversedMaterialDocumentItem;
            result = result * 59 + ($reversedMaterialDocumentItem == null ? 43 : $reversedMaterialDocumentItem.hashCode());
            String $batch = this.batch;
            result = result * 59 + ($batch == null ? 43 : $batch.hashCode());
            String $goodsMovementType = this.goodsMovementType;
            result = result * 59 + ($goodsMovementType == null ? 43 : $goodsMovementType.hashCode());
            String $inventoryStockType = this.inventoryStockType;
            result = result * 59 + ($inventoryStockType == null ? 43 : $inventoryStockType.hashCode());
            return result;
        }

        public String getMaterialDocumentYear() {
            return this.materialDocumentYear;
        }

        public MaterialDocumentItem setMaterialDocumentYear(String materialDocumentYear) {
            this.materialDocumentYear = materialDocumentYear;
            return this;
        }

        public String getInventoryValuationType() {
            return this.inventoryValuationType;
        }

        public MaterialDocumentItem setInventoryValuationType(String inventoryValuationType) {
            this.inventoryValuationType = inventoryValuationType;
            return this;
        }

        public String getInventorySpecialStockType() {
            return this.inventorySpecialStockType;
        }

        public MaterialDocumentItem setInventorySpecialStockType(String inventorySpecialStockType) {
            this.inventorySpecialStockType = inventorySpecialStockType;
            return this;
        }

        public String getSupplier() {
            return this.supplier;
        }

        public MaterialDocumentItem setSupplier(String supplier) {
            this.supplier = supplier;
            return this;
        }

        public String getCustomer() {
            return this.customer;
        }

        public MaterialDocumentItem setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public String getSalesOrder() {
            return this.salesOrder;
        }

        public MaterialDocumentItem setSalesOrder(String salesOrder) {
            this.salesOrder = salesOrder;
            return this;
        }

        public String getSalesOrderItem() {
            return this.salesOrderItem;
        }

        public MaterialDocumentItem setSalesOrderItem(String salesOrderItem) {
            this.salesOrderItem = salesOrderItem;
            return this;
        }

        public String getSalesOrderScheduleLine() {
            return this.salesOrderScheduleLine;
        }

        public MaterialDocumentItem setSalesOrderScheduleLine(String salesOrderScheduleLine) {
            this.salesOrderScheduleLine = salesOrderScheduleLine;
            return this;
        }

        public String getPurchaseOrder() {
            return this.purchaseOrder;
        }

        public MaterialDocumentItem setPurchaseOrder(String purchaseOrder) {
            this.purchaseOrder = purchaseOrder;
            return this;
        }

        public String getPurchaseOrderItem() {
            return this.purchaseOrderItem;
        }

        public MaterialDocumentItem setPurchaseOrderItem(String purchaseOrderItem) {
            this.purchaseOrderItem = purchaseOrderItem;
            return this;
        }

        public String getWBSElement() {
            return this.wBSElement;
        }

        public MaterialDocumentItem setWBSElement(String wBSElement) {
            this.wBSElement = wBSElement;
            return this;
        }

        public String getMaterialDocument() {
            return this.materialDocument;
        }

        public MaterialDocumentItem setMaterialDocument(String materialDocument) {
            this.materialDocument = materialDocument;
            return this;
        }

        public String getManufacturingOrder() {
            return this.manufacturingOrder;
        }

        public MaterialDocumentItem setManufacturingOrder(String manufacturingOrder) {
            this.manufacturingOrder = manufacturingOrder;
            return this;
        }

        public String getManufacturingOrderItem() {
            return this.manufacturingOrderItem;
        }

        public MaterialDocumentItem setManufacturingOrderItem(String manufacturingOrderItem) {
            this.manufacturingOrderItem = manufacturingOrderItem;
            return this;
        }

        public String getGoodsMovementRefDocType() {
            return this.goodsMovementRefDocType;
        }

        public MaterialDocumentItem setGoodsMovementRefDocType(String goodsMovementRefDocType) {
            this.goodsMovementRefDocType = goodsMovementRefDocType;
            return this;
        }

        public String getGoodsMovementReasonCode() {
            return this.goodsMovementReasonCode;
        }

        public MaterialDocumentItem setGoodsMovementReasonCode(String goodsMovementReasonCode) {
            this.goodsMovementReasonCode = goodsMovementReasonCode;
            return this;
        }

        public String getAccountAssignmentCategory() {
            return this.accountAssignmentCategory;
        }

        public MaterialDocumentItem setAccountAssignmentCategory(String accountAssignmentCategory) {
            this.accountAssignmentCategory = accountAssignmentCategory;
            return this;
        }

        public String getCostCenter() {
            return this.costCenter;
        }

        public MaterialDocumentItem setCostCenter(String costCenter) {
            this.costCenter = costCenter;
            return this;
        }

        public String getControllingArea() {
            return this.controllingArea;
        }

        public MaterialDocumentItem setControllingArea(String controllingArea) {
            this.controllingArea = controllingArea;
            return this;
        }

        public String getCostObject() {
            return this.costObject;
        }

        public MaterialDocumentItem setCostObject(String costObject) {
            this.costObject = costObject;
            return this;
        }

        public String getProfitabilitySegment() {
            return this.profitabilitySegment;
        }

        public MaterialDocumentItem setProfitabilitySegment(String profitabilitySegment) {
            this.profitabilitySegment = profitabilitySegment;
            return this;
        }

        public String getProfitCenter() {
            return this.profitCenter;
        }

        public MaterialDocumentItem setProfitCenter(String profitCenter) {
            this.profitCenter = profitCenter;
            return this;
        }

        public String getMaterialDocumentItem() {
            return this.materialDocumentItem;
        }

        public MaterialDocumentItem setMaterialDocumentItem(String materialDocumentItem) {
            this.materialDocumentItem = materialDocumentItem;
            return this;
        }

        public String getGLAccount() {
            return this.gLAccount;
        }

        public MaterialDocumentItem setGLAccount(String gLAccount) {
            this.gLAccount = gLAccount;
            return this;
        }

        public String getFunctionalArea() {
            return this.functionalArea;
        }

        public MaterialDocumentItem setFunctionalArea(String functionalArea) {
            this.functionalArea = functionalArea;
            return this;
        }

        public String getMaterialBaseUnit() {
            return this.materialBaseUnit;
        }

        public MaterialDocumentItem setMaterialBaseUnit(String materialBaseUnit) {
            this.materialBaseUnit = materialBaseUnit;
            return this;
        }

        public BigDecimal getQuantityInBaseUnit() {
            return this.quantityInBaseUnit;
        }

        public MaterialDocumentItem setQuantityInBaseUnit(BigDecimal quantityInBaseUnit) {
            this.quantityInBaseUnit = quantityInBaseUnit;
            return this;
        }

        public String getEntryUnit() {
            return this.entryUnit;
        }

        public MaterialDocumentItem setEntryUnit(String entryUnit) {
            this.entryUnit = entryUnit;
            return this;
        }

        public BigDecimal getQuantityInEntryUnit() {
            return this.quantityInEntryUnit;
        }

        public MaterialDocumentItem setQuantityInEntryUnit(BigDecimal quantityInEntryUnit) {
            this.quantityInEntryUnit = quantityInEntryUnit;
            return this;
        }

        public String getCompanyCodeCurrency() {
            return this.companyCodeCurrency;
        }

        public MaterialDocumentItem setCompanyCodeCurrency(String companyCodeCurrency) {
            this.companyCodeCurrency = companyCodeCurrency;
            return this;
        }

        public BigDecimal getGdsMvtExtAmtInCoCodeCrcy() {
            return this.gdsMvtExtAmtInCoCodeCrcy;
        }

        public MaterialDocumentItem setGdsMvtExtAmtInCoCodeCrcy(BigDecimal gdsMvtExtAmtInCoCodeCrcy) {
            this.gdsMvtExtAmtInCoCodeCrcy = gdsMvtExtAmtInCoCodeCrcy;
            return this;
        }

        public BigDecimal getSlsPrcAmtInclVATInCoCodeCrcy() {
            return this.slsPrcAmtInclVATInCoCodeCrcy;
        }

        public MaterialDocumentItem setSlsPrcAmtInclVATInCoCodeCrcy(BigDecimal slsPrcAmtInclVATInCoCodeCrcy) {
            this.slsPrcAmtInclVATInCoCodeCrcy = slsPrcAmtInclVATInCoCodeCrcy;
            return this;
        }

        public String getFiscalYear() {
            return this.fiscalYear;
        }

        public MaterialDocumentItem setFiscalYear(String fiscalYear) {
            this.fiscalYear = fiscalYear;
            return this;
        }

        public String getMaterial() {
            return this.material;
        }

        public MaterialDocumentItem setMaterial(String material) {
            this.material = material;
            return this;
        }

        public String getFiscalYearPeriod() {
            return this.fiscalYearPeriod;
        }

        public MaterialDocumentItem setFiscalYearPeriod(String fiscalYearPeriod) {
            this.fiscalYearPeriod = fiscalYearPeriod;
            return this;
        }

        public String getFiscalYearVariant() {
            return this.fiscalYearVariant;
        }

        public MaterialDocumentItem setFiscalYearVariant(String fiscalYearVariant) {
            this.fiscalYearVariant = fiscalYearVariant;
            return this;
        }

        public String getIssgOrRcvgMaterial() {
            return this.issgOrRcvgMaterial;
        }

        public MaterialDocumentItem setIssgOrRcvgMaterial(String issgOrRcvgMaterial) {
            this.issgOrRcvgMaterial = issgOrRcvgMaterial;
            return this;
        }

        public String getIssgOrRcvgBatch() {
            return this.issgOrRcvgBatch;
        }

        public MaterialDocumentItem setIssgOrRcvgBatch(String issgOrRcvgBatch) {
            this.issgOrRcvgBatch = issgOrRcvgBatch;
            return this;
        }

        public String getIssuingOrReceivingPlant() {
            return this.issuingOrReceivingPlant;
        }

        public MaterialDocumentItem setIssuingOrReceivingPlant(String issuingOrReceivingPlant) {
            this.issuingOrReceivingPlant = issuingOrReceivingPlant;
            return this;
        }

        public String getIssuingOrReceivingStorageLoc() {
            return this.issuingOrReceivingStorageLoc;
        }

        public MaterialDocumentItem setIssuingOrReceivingStorageLoc(String issuingOrReceivingStorageLoc) {
            this.issuingOrReceivingStorageLoc = issuingOrReceivingStorageLoc;
            return this;
        }

        public String getIssuingOrReceivingStockType() {
            return this.issuingOrReceivingStockType;
        }

        public MaterialDocumentItem setIssuingOrReceivingStockType(String issuingOrReceivingStockType) {
            this.issuingOrReceivingStockType = issuingOrReceivingStockType;
            return this;
        }

        public String getIssgOrRcvgSpclStockInd() {
            return this.issgOrRcvgSpclStockInd;
        }

        public MaterialDocumentItem setIssgOrRcvgSpclStockInd(String issgOrRcvgSpclStockInd) {
            this.issgOrRcvgSpclStockInd = issgOrRcvgSpclStockInd;
            return this;
        }

        public String getIssuingOrReceivingValType() {
            return this.issuingOrReceivingValType;
        }

        public MaterialDocumentItem setIssuingOrReceivingValType(String issuingOrReceivingValType) {
            this.issuingOrReceivingValType = issuingOrReceivingValType;
            return this;
        }

        public Boolean getIsCompletelyDelivered() {
            return this.isCompletelyDelivered;
        }

        public MaterialDocumentItem setIsCompletelyDelivered(Boolean isCompletelyDelivered) {
            this.isCompletelyDelivered = isCompletelyDelivered;
            return this;
        }

        public String getPlant() {
            return this.plant;
        }

        public MaterialDocumentItem setPlant(String plant) {
            this.plant = plant;
            return this;
        }

        public String getMaterialDocumentItemText() {
            return this.materialDocumentItemText;
        }

        public MaterialDocumentItem setMaterialDocumentItemText(String materialDocumentItemText) {
            this.materialDocumentItemText = materialDocumentItemText;
            return this;
        }

        public String getUnloadingPointName() {
            return this.unloadingPointName;
        }

        public MaterialDocumentItem setUnloadingPointName(String unloadingPointName) {
            this.unloadingPointName = unloadingPointName;
            return this;
        }

        public Calendar getShelfLifeExpirationDate() {
            return this.shelfLifeExpirationDate;
        }

        public MaterialDocumentItem setShelfLifeExpirationDate(Calendar shelfLifeExpirationDate) {
            this.shelfLifeExpirationDate = shelfLifeExpirationDate;
            return this;
        }

        public Calendar getManufactureDate() {
            return this.manufactureDate;
        }

        public MaterialDocumentItem setManufactureDate(Calendar manufactureDate) {
            this.manufactureDate = manufactureDate;
            return this;
        }

        public String getReservation() {
            return this.reservation;
        }

        public MaterialDocumentItem setReservation(String reservation) {
            this.reservation = reservation;
            return this;
        }

        public String getReservationItem() {
            return this.reservationItem;
        }

        public MaterialDocumentItem setReservationItem(String reservationItem) {
            this.reservationItem = reservationItem;
            return this;
        }

        public Boolean getReservationIsFinallyIssued() {
            return this.reservationIsFinallyIssued;
        }

        public MaterialDocumentItem setReservationIsFinallyIssued(Boolean reservationIsFinallyIssued) {
            this.reservationIsFinallyIssued = reservationIsFinallyIssued;
            return this;
        }

        public String getSpecialStockIdfgSalesOrder() {
            return this.specialStockIdfgSalesOrder;
        }

        public MaterialDocumentItem setSpecialStockIdfgSalesOrder(String specialStockIdfgSalesOrder) {
            this.specialStockIdfgSalesOrder = specialStockIdfgSalesOrder;
            return this;
        }

        public String getSpecialStockIdfgSalesOrderItem() {
            return this.specialStockIdfgSalesOrderItem;
        }

        public MaterialDocumentItem setSpecialStockIdfgSalesOrderItem(String specialStockIdfgSalesOrderItem) {
            this.specialStockIdfgSalesOrderItem = specialStockIdfgSalesOrderItem;
            return this;
        }

        public String getSpecialStockIdfgWBSElement() {
            return this.specialStockIdfgWBSElement;
        }

        public MaterialDocumentItem setSpecialStockIdfgWBSElement(String specialStockIdfgWBSElement) {
            this.specialStockIdfgWBSElement = specialStockIdfgWBSElement;
            return this;
        }

        public String getStorageLocation() {
            return this.storageLocation;
        }

        public MaterialDocumentItem setStorageLocation(String storageLocation) {
            this.storageLocation = storageLocation;
            return this;
        }

        public String getIsAutomaticallyCreated() {
            return this.isAutomaticallyCreated;
        }

        public MaterialDocumentItem setIsAutomaticallyCreated(String isAutomaticallyCreated) {
            this.isAutomaticallyCreated = isAutomaticallyCreated;
            return this;
        }

        public String getMaterialDocumentLine() {
            return this.materialDocumentLine;
        }

        public MaterialDocumentItem setMaterialDocumentLine(String materialDocumentLine) {
            this.materialDocumentLine = materialDocumentLine;
            return this;
        }

        public String getMaterialDocumentParentLine() {
            return this.materialDocumentParentLine;
        }

        public MaterialDocumentItem setMaterialDocumentParentLine(String materialDocumentParentLine) {
            this.materialDocumentParentLine = materialDocumentParentLine;
            return this;
        }

        public String getHierarchyNodeLevel() {
            return this.hierarchyNodeLevel;
        }

        public MaterialDocumentItem setHierarchyNodeLevel(String hierarchyNodeLevel) {
            this.hierarchyNodeLevel = hierarchyNodeLevel;
            return this;
        }

        public Boolean getGoodsMovementIsCancelled() {
            return this.goodsMovementIsCancelled;
        }

        public MaterialDocumentItem setGoodsMovementIsCancelled(Boolean goodsMovementIsCancelled) {
            this.goodsMovementIsCancelled = goodsMovementIsCancelled;
            return this;
        }

        public String getReversedMaterialDocumentYear() {
            return this.reversedMaterialDocumentYear;
        }

        public MaterialDocumentItem setReversedMaterialDocumentYear(String reversedMaterialDocumentYear) {
            this.reversedMaterialDocumentYear = reversedMaterialDocumentYear;
            return this;
        }

        public String getReversedMaterialDocument() {
            return this.reversedMaterialDocument;
        }

        public MaterialDocumentItem setReversedMaterialDocument(String reversedMaterialDocument) {
            this.reversedMaterialDocument = reversedMaterialDocument;
            return this;
        }

        public String getReversedMaterialDocumentItem() {
            return this.reversedMaterialDocumentItem;
        }

        public MaterialDocumentItem setReversedMaterialDocumentItem(String reversedMaterialDocumentItem) {
            this.reversedMaterialDocumentItem = reversedMaterialDocumentItem;
            return this;
        }

        public String getBatch() {
            return this.batch;
        }

        public MaterialDocumentItem setBatch(String batch) {
            this.batch = batch;
            return this;
        }

        public String getGoodsMovementType() {
            return this.goodsMovementType;
        }

        public MaterialDocumentItem setGoodsMovementType(String goodsMovementType) {
            this.goodsMovementType = goodsMovementType;
            return this;
        }

        public String getInventoryStockType() {
            return this.inventoryStockType;
        }

        public MaterialDocumentItem setInventoryStockType(String inventoryStockType) {
            this.inventoryStockType = inventoryStockType;
            return this;
        }

        public MaterialDocumentItem setErpConfigContext(ErpConfigContext erpConfigContext) {
            this.erpConfigContext = erpConfigContext;
            return this;
        }
    }

    public static class MaterialDocumentHeaderFluentHelper {
        private ODataQueryBuilder queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_MATERIAL_DOCUMENT_SRV", (String)"A_MaterialDocumentHeader");
        private ErrorResultHandler<?> errorResultHandler = new ODataVdmErrorResultHandler();

        public MaterialDocumentHeaderFluentHelper filter(ExpressionFluentHelper<MaterialDocumentHeader> expression) {
            for (FilterExpressionWrapper<?> filterExpressionWrapper : expression.evaluate()) {
                Object comparisonValue = filterExpressionWrapper.getComparisonValue();
                if (comparisonValue instanceof Integer) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Integer)((Integer)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof String) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((String)((String)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Long) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Long)((Long)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Double) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Double)((Double)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Float) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Float)((Float)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDate) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDate)((LocalDate)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDateTime)((LocalDateTime)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Date) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Date)((Date)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof DateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((DateTime)((DateTime)comparisonValue))));
                    continue;
                }
                this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of(comparisonValue)));
            }
            return this;
        }

        public MaterialDocumentHeaderFluentHelper orderBy(EntityField<?, MaterialDocumentHeader> field, Order order) {
            String orderingDirection = order == Order.ASC ? " asc" : " desc";
            this.queryBuilder.param("orderby", (Object)(field.getFieldName() + orderingDirection));
            return this;
        }

        @SafeVarargs
        public final MaterialDocumentHeaderFluentHelper select(EntityField<?, MaterialDocumentHeader> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public MaterialDocumentHeaderFluentHelper top(Number top) {
            this.queryBuilder.top(top);
            return this;
        }

        public MaterialDocumentHeaderFluentHelper skip(Number skip) {
            this.queryBuilder.skip(skip);
            return this;
        }

        public MaterialDocumentHeaderFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.errorHandler(this.errorResultHandler).build();
        }

        public List<MaterialDocumentHeader> execute(ErpConfigContext erpConfigContext) throws ODataException {
            List entityList = this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).asList(MaterialDocumentHeader.class);
            for (MaterialDocumentHeader entity : entityList) {
                entity.setErpConfigContext(erpConfigContext);
            }
            return entityList;
        }
    }

    public static class MaterialDocumentHeaderByKeyFluentHelper {
        private ODataQueryBuilder queryBuilder;
        private ErrorResultHandler<?> errorResultHandler;
        private List<Object> values = new LinkedList<Object>();

        public MaterialDocumentHeaderByKeyFluentHelper(String materialDocumentYear, String materialDocument) {
            this.values.add(materialDocumentYear);
            this.values.add(materialDocument);
            this.queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_MATERIAL_DOCUMENT_SRV", (String)"A_MaterialDocumentHeader");
            HashMap<String, Object> keys = new HashMap<String, Object>();
            keys.put("MaterialDocumentYear", this.values.get(0));
            keys.put("MaterialDocument", this.values.get(1));
            this.queryBuilder.keys(keys);
        }

        @SafeVarargs
        public final MaterialDocumentHeaderByKeyFluentHelper select(EntityField<?, MaterialDocumentHeader> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.build();
        }

        public MaterialDocumentHeaderByKeyFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public MaterialDocumentHeader execute(ErpConfigContext erpConfigContext) throws ODataException {
            MaterialDocumentHeader entity = (MaterialDocumentHeader)this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).as(MaterialDocumentHeader.class);
            entity.setErpConfigContext(erpConfigContext);
            return entity;
        }
    }

    public static class MaterialDocumentHeader {
        @ElementName(value="MaterialDocumentYear")
        private String materialDocumentYear;
        public static EntityField<String, MaterialDocumentHeader> MATERIAL_DOCUMENT_YEAR = new EntityField("MaterialDocumentYear");
        @ElementName(value="ReferenceDocument")
        private String referenceDocument;
        public static EntityField<String, MaterialDocumentHeader> REFERENCE_DOCUMENT = new EntityField("ReferenceDocument");
        @ElementName(value="MaterialDocument")
        private String materialDocument;
        public static EntityField<String, MaterialDocumentHeader> MATERIAL_DOCUMENT = new EntityField("MaterialDocument");
        @ElementName(value="InventoryTransactionType")
        private String inventoryTransactionType;
        public static EntityField<String, MaterialDocumentHeader> INVENTORY_TRANSACTION_TYPE = new EntityField("InventoryTransactionType");
        @ElementName(value="DocumentDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar documentDate;
        public static EntityField<Calendar, MaterialDocumentHeader> DOCUMENT_DATE = new EntityField("DocumentDate");
        @ElementName(value="PostingDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar postingDate;
        public static EntityField<Calendar, MaterialDocumentHeader> POSTING_DATE = new EntityField("PostingDate");
        @ElementName(value="CreationDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar creationDate;
        public static EntityField<Calendar, MaterialDocumentHeader> CREATION_DATE = new EntityField("CreationDate");
        @ElementName(value="CreationTime")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar creationTime;
        public static EntityField<Calendar, MaterialDocumentHeader> CREATION_TIME = new EntityField("CreationTime");
        @ElementName(value="CreatedByUser")
        private String createdByUser;
        public static EntityField<String, MaterialDocumentHeader> CREATED_BY_USER = new EntityField("CreatedByUser");
        @ElementName(value="MaterialDocumentHeaderText")
        private String materialDocumentHeaderText;
        public static EntityField<String, MaterialDocumentHeader> MATERIAL_DOCUMENT_HEADER_TEXT = new EntityField("MaterialDocumentHeaderText");
        private static final transient String ODATA_ENDPOINT_URL = "/sap/opu/odata/sap/API_MATERIAL_DOCUMENT_SRV";
        private static final transient String ODATA_ENTITY_COLLECTION = "A_MaterialDocumentHeader";
        private transient ErpConfigContext erpConfigContext;

        @JsonIgnore
        public List<MaterialDocumentItem> fetchMaterialDocumentItem() throws ODataException {
            StringBuilder odataResourceUrl = new StringBuilder(ODATA_ENTITY_COLLECTION);
            odataResourceUrl.append("(");
            odataResourceUrl.append("MaterialDocumentYear=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.materialDocumentYear));
            odataResourceUrl.append(",MaterialDocument=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.materialDocument));
            odataResourceUrl.append(")/");
            odataResourceUrl.append("to_MaterialDocumentItem");
            ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)ODATA_ENDPOINT_URL, (String)odataResourceUrl.toString());
            ODataQuery query = builder.build();
            ErpEndpoint erpEndpoint = new ErpEndpoint(this.erpConfigContext);
            ODataQueryResult result = query.execute((WithDestinationName)erpEndpoint);
            List entityList = result.asList(MaterialDocumentItem.class);
            for (MaterialDocumentItem entity : entityList) {
                entity.setErpConfigContext(this.erpConfigContext);
            }
            return entityList;
        }

        public String toString() {
            return "RetrieveMaterialDocumentsNamespace.MaterialDocumentHeader(materialDocumentYear=" + this.materialDocumentYear + ", referenceDocument=" + this.referenceDocument + ", materialDocument=" + this.materialDocument + ", inventoryTransactionType=" + this.inventoryTransactionType + ", documentDate=" + this.documentDate + ", postingDate=" + this.postingDate + ", creationDate=" + this.creationDate + ", creationTime=" + this.creationTime + ", createdByUser=" + this.createdByUser + ", materialDocumentHeaderText=" + this.materialDocumentHeaderText + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MaterialDocumentHeader)) {
                return false;
            }
            MaterialDocumentHeader other = (MaterialDocumentHeader)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$materialDocumentYear = this.materialDocumentYear;
            String other$materialDocumentYear = other.materialDocumentYear;
            if (this$materialDocumentYear == null ? other$materialDocumentYear != null : !this$materialDocumentYear.equals(other$materialDocumentYear)) {
                return false;
            }
            String this$referenceDocument = this.referenceDocument;
            String other$referenceDocument = other.referenceDocument;
            if (this$referenceDocument == null ? other$referenceDocument != null : !this$referenceDocument.equals(other$referenceDocument)) {
                return false;
            }
            String this$materialDocument = this.materialDocument;
            String other$materialDocument = other.materialDocument;
            if (this$materialDocument == null ? other$materialDocument != null : !this$materialDocument.equals(other$materialDocument)) {
                return false;
            }
            String this$inventoryTransactionType = this.inventoryTransactionType;
            String other$inventoryTransactionType = other.inventoryTransactionType;
            if (this$inventoryTransactionType == null ? other$inventoryTransactionType != null : !this$inventoryTransactionType.equals(other$inventoryTransactionType)) {
                return false;
            }
            Calendar this$documentDate = this.documentDate;
            Calendar other$documentDate = other.documentDate;
            if (this$documentDate == null ? other$documentDate != null : !((Object)this$documentDate).equals(other$documentDate)) {
                return false;
            }
            Calendar this$postingDate = this.postingDate;
            Calendar other$postingDate = other.postingDate;
            if (this$postingDate == null ? other$postingDate != null : !((Object)this$postingDate).equals(other$postingDate)) {
                return false;
            }
            Calendar this$creationDate = this.creationDate;
            Calendar other$creationDate = other.creationDate;
            if (this$creationDate == null ? other$creationDate != null : !((Object)this$creationDate).equals(other$creationDate)) {
                return false;
            }
            Calendar this$creationTime = this.creationTime;
            Calendar other$creationTime = other.creationTime;
            if (this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime)) {
                return false;
            }
            String this$createdByUser = this.createdByUser;
            String other$createdByUser = other.createdByUser;
            if (this$createdByUser == null ? other$createdByUser != null : !this$createdByUser.equals(other$createdByUser)) {
                return false;
            }
            String this$materialDocumentHeaderText = this.materialDocumentHeaderText;
            String other$materialDocumentHeaderText = other.materialDocumentHeaderText;
            return !(this$materialDocumentHeaderText == null ? other$materialDocumentHeaderText != null : !this$materialDocumentHeaderText.equals(other$materialDocumentHeaderText));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MaterialDocumentHeader;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $materialDocumentYear = this.materialDocumentYear;
            result = result * 59 + ($materialDocumentYear == null ? 43 : $materialDocumentYear.hashCode());
            String $referenceDocument = this.referenceDocument;
            result = result * 59 + ($referenceDocument == null ? 43 : $referenceDocument.hashCode());
            String $materialDocument = this.materialDocument;
            result = result * 59 + ($materialDocument == null ? 43 : $materialDocument.hashCode());
            String $inventoryTransactionType = this.inventoryTransactionType;
            result = result * 59 + ($inventoryTransactionType == null ? 43 : $inventoryTransactionType.hashCode());
            Calendar $documentDate = this.documentDate;
            result = result * 59 + ($documentDate == null ? 43 : ((Object)$documentDate).hashCode());
            Calendar $postingDate = this.postingDate;
            result = result * 59 + ($postingDate == null ? 43 : ((Object)$postingDate).hashCode());
            Calendar $creationDate = this.creationDate;
            result = result * 59 + ($creationDate == null ? 43 : ((Object)$creationDate).hashCode());
            Calendar $creationTime = this.creationTime;
            result = result * 59 + ($creationTime == null ? 43 : ((Object)$creationTime).hashCode());
            String $createdByUser = this.createdByUser;
            result = result * 59 + ($createdByUser == null ? 43 : $createdByUser.hashCode());
            String $materialDocumentHeaderText = this.materialDocumentHeaderText;
            result = result * 59 + ($materialDocumentHeaderText == null ? 43 : $materialDocumentHeaderText.hashCode());
            return result;
        }

        public String getMaterialDocumentYear() {
            return this.materialDocumentYear;
        }

        public MaterialDocumentHeader setMaterialDocumentYear(String materialDocumentYear) {
            this.materialDocumentYear = materialDocumentYear;
            return this;
        }

        public String getReferenceDocument() {
            return this.referenceDocument;
        }

        public MaterialDocumentHeader setReferenceDocument(String referenceDocument) {
            this.referenceDocument = referenceDocument;
            return this;
        }

        public String getMaterialDocument() {
            return this.materialDocument;
        }

        public MaterialDocumentHeader setMaterialDocument(String materialDocument) {
            this.materialDocument = materialDocument;
            return this;
        }

        public String getInventoryTransactionType() {
            return this.inventoryTransactionType;
        }

        public MaterialDocumentHeader setInventoryTransactionType(String inventoryTransactionType) {
            this.inventoryTransactionType = inventoryTransactionType;
            return this;
        }

        public Calendar getDocumentDate() {
            return this.documentDate;
        }

        public MaterialDocumentHeader setDocumentDate(Calendar documentDate) {
            this.documentDate = documentDate;
            return this;
        }

        public Calendar getPostingDate() {
            return this.postingDate;
        }

        public MaterialDocumentHeader setPostingDate(Calendar postingDate) {
            this.postingDate = postingDate;
            return this;
        }

        public Calendar getCreationDate() {
            return this.creationDate;
        }

        public MaterialDocumentHeader setCreationDate(Calendar creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public Calendar getCreationTime() {
            return this.creationTime;
        }

        public MaterialDocumentHeader setCreationTime(Calendar creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public String getCreatedByUser() {
            return this.createdByUser;
        }

        public MaterialDocumentHeader setCreatedByUser(String createdByUser) {
            this.createdByUser = createdByUser;
            return this;
        }

        public String getMaterialDocumentHeaderText() {
            return this.materialDocumentHeaderText;
        }

        public MaterialDocumentHeader setMaterialDocumentHeaderText(String materialDocumentHeaderText) {
            this.materialDocumentHeaderText = materialDocumentHeaderText;
            return this;
        }

        public MaterialDocumentHeader setErpConfigContext(ErpConfigContext erpConfigContext) {
            this.erpConfigContext = erpConfigContext;
            return this;
        }
    }
}

