/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.cloudplatform.connectivity.WithDestinationName;
import com.sap.cloud.sdk.odatav2.connectivity.ErrorResultHandler;
import com.sap.cloud.sdk.odatav2.connectivity.FilterExpression;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQuery;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQueryBuilder;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQueryResult;
import com.sap.cloud.sdk.odatav2.connectivity.ODataType;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.connectivity.ErpConfigContext;
import com.sap.cloud.sdk.s4hana.connectivity.ErpEndpoint;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.EntityField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ExpressionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.FilterExpressionWrapper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ODataBooleanAdapter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ODataCalendarAdapter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ODataTypeValueSerializer;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ODataVdmErrorResultHandler;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.Order;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public class ReadWorkCenterDataNamespace {

    public static class WorkCentersFluentHelper {
        private ODataQueryBuilder queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_WORK_CENTERS", (String)"A_WorkCenters");
        private ErrorResultHandler<?> errorResultHandler = new ODataVdmErrorResultHandler();

        public WorkCentersFluentHelper filter(ExpressionFluentHelper<WorkCenters> expression) {
            for (FilterExpressionWrapper<?> filterExpressionWrapper : expression.evaluate()) {
                Object comparisonValue = filterExpressionWrapper.getComparisonValue();
                if (comparisonValue instanceof Integer) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Integer)((Integer)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof String) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((String)((String)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Long) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Long)((Long)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Double) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Double)((Double)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Float) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Float)((Float)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDate) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDate)((LocalDate)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDateTime)((LocalDateTime)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Date) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Date)((Date)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof DateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((DateTime)((DateTime)comparisonValue))));
                    continue;
                }
                this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of(comparisonValue)));
            }
            return this;
        }

        public WorkCentersFluentHelper orderBy(EntityField<?, WorkCenters> field, Order order) {
            String orderingDirection = order == Order.ASC ? " asc" : " desc";
            this.queryBuilder.param("orderby", (Object)(field.getFieldName() + orderingDirection));
            return this;
        }

        @SafeVarargs
        public final WorkCentersFluentHelper select(EntityField<?, WorkCenters> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public WorkCentersFluentHelper top(Number top) {
            this.queryBuilder.top(top);
            return this;
        }

        public WorkCentersFluentHelper skip(Number skip) {
            this.queryBuilder.skip(skip);
            return this;
        }

        public WorkCentersFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.errorHandler(this.errorResultHandler).build();
        }

        public List<WorkCenters> execute(ErpConfigContext erpConfigContext) throws ODataException {
            List entityList = this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).asList(WorkCenters.class);
            for (WorkCenters entity : entityList) {
                entity.setErpConfigContext(erpConfigContext);
            }
            return entityList;
        }
    }

    public static class WorkCentersByKeyFluentHelper {
        private ODataQueryBuilder queryBuilder;
        private ErrorResultHandler<?> errorResultHandler;
        private List<Object> values = new LinkedList<Object>();

        public WorkCentersByKeyFluentHelper(String workCenterInternalID, String workCenterTypeCode) {
            this.values.add(workCenterInternalID);
            this.values.add(workCenterTypeCode);
            this.queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_WORK_CENTERS", (String)"A_WorkCenters");
            HashMap<String, Object> keys = new HashMap<String, Object>();
            keys.put("WorkCenterInternalID", this.values.get(0));
            keys.put("WorkCenterTypeCode", this.values.get(1));
            this.queryBuilder.keys(keys);
        }

        @SafeVarargs
        public final WorkCentersByKeyFluentHelper select(EntityField<?, WorkCenters> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.build();
        }

        public WorkCentersByKeyFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public WorkCenters execute(ErpConfigContext erpConfigContext) throws ODataException {
            WorkCenters entity = (WorkCenters)this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).as(WorkCenters.class);
            entity.setErpConfigContext(erpConfigContext);
            return entity;
        }
    }

    public static class WorkCenters {
        @ElementName(value="WorkCenterInternalID")
        private String workCenterInternalID;
        public static EntityField<String, WorkCenters> WORK_CENTER_INTERNAL_I_D = new EntityField("WorkCenterInternalID");
        @ElementName(value="WorkCenterUsage")
        private String workCenterUsage;
        public static EntityField<String, WorkCenters> WORK_CENTER_USAGE = new EntityField("WorkCenterUsage");
        @ElementName(value="CapacityInternalID")
        private String capacityInternalID;
        public static EntityField<String, WorkCenters> CAPACITY_INTERNAL_I_D = new EntityField("CapacityInternalID");
        @ElementName(value="WorkCenterTypeCode")
        private String workCenterTypeCode;
        public static EntityField<String, WorkCenters> WORK_CENTER_TYPE_CODE = new EntityField("WorkCenterTypeCode");
        @ElementName(value="WorkCenter")
        private String workCenter;
        public static EntityField<String, WorkCenters> WORK_CENTER = new EntityField("WorkCenter");
        @ElementName(value="WorkCenterDesc")
        private String workCenterDesc;
        public static EntityField<String, WorkCenters> WORK_CENTER_DESC = new EntityField("WorkCenterDesc");
        @ElementName(value="Plant")
        private String plant;
        public static EntityField<String, WorkCenters> PLANT = new EntityField("Plant");
        @ElementName(value="WorkCenterCategoryCode")
        private String workCenterCategoryCode;
        public static EntityField<String, WorkCenters> WORK_CENTER_CATEGORY_CODE = new EntityField("WorkCenterCategoryCode");
        @ElementName(value="WorkCenterResponsible")
        private String workCenterResponsible;
        public static EntityField<String, WorkCenters> WORK_CENTER_RESPONSIBLE = new EntityField("WorkCenterResponsible");
        @ElementName(value="WorkCenterResponsibleName")
        private String workCenterResponsibleName;
        public static EntityField<String, WorkCenters> WORK_CENTER_RESPONSIBLE_NAME = new EntityField("WorkCenterResponsibleName");
        @ElementName(value="SupplyArea")
        private String supplyArea;
        public static EntityField<String, WorkCenters> SUPPLY_AREA = new EntityField("SupplyArea");
        private static final transient String ODATA_ENDPOINT_URL = "/sap/opu/odata/sap/API_WORK_CENTERS";
        private static final transient String ODATA_ENTITY_COLLECTION = "A_WorkCenters";
        private transient ErpConfigContext erpConfigContext;

        @JsonIgnore
        public WorkCenterCapacity fetchCapacity() throws ODataException {
            StringBuilder odataResourceUrl = new StringBuilder(ODATA_ENTITY_COLLECTION);
            odataResourceUrl.append("(");
            odataResourceUrl.append("WorkCenterInternalID=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.workCenterInternalID));
            odataResourceUrl.append(",WorkCenterTypeCode=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.workCenterTypeCode));
            odataResourceUrl.append(")/");
            odataResourceUrl.append("to_Capacity");
            ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)ODATA_ENDPOINT_URL, (String)odataResourceUrl.toString());
            ODataQuery query = builder.build();
            ErpEndpoint erpEndpoint = new ErpEndpoint(this.erpConfigContext);
            ODataQueryResult result = query.execute((WithDestinationName)erpEndpoint);
            WorkCenterCapacity entityList = (WorkCenterCapacity)result.as(WorkCenterCapacity.class);
            entityList.setErpConfigContext(this.erpConfigContext);
            return entityList;
        }

        @JsonIgnore
        public List<WorkCenterPipeLineOperation> fetchWorkCenterQueuingOp() throws ODataException {
            StringBuilder odataResourceUrl = new StringBuilder(ODATA_ENTITY_COLLECTION);
            odataResourceUrl.append("(");
            odataResourceUrl.append("WorkCenterInternalID=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.workCenterInternalID));
            odataResourceUrl.append(",WorkCenterTypeCode=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.workCenterTypeCode));
            odataResourceUrl.append(")/");
            odataResourceUrl.append("to_WorkCenterQueuingOp");
            ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)ODATA_ENDPOINT_URL, (String)odataResourceUrl.toString());
            ODataQuery query = builder.build();
            ErpEndpoint erpEndpoint = new ErpEndpoint(this.erpConfigContext);
            ODataQueryResult result = query.execute((WithDestinationName)erpEndpoint);
            List entityList = result.asList(WorkCenterPipeLineOperation.class);
            for (WorkCenterPipeLineOperation entity : entityList) {
                entity.setErpConfigContext(this.erpConfigContext);
            }
            return entityList;
        }

        @JsonIgnore
        public List<WorkCenterDayOperation> fetchWorkCenterTodayOp() throws ODataException {
            StringBuilder odataResourceUrl = new StringBuilder(ODATA_ENTITY_COLLECTION);
            odataResourceUrl.append("(");
            odataResourceUrl.append("WorkCenterInternalID=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.workCenterInternalID));
            odataResourceUrl.append(",WorkCenterTypeCode=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.workCenterTypeCode));
            odataResourceUrl.append(")/");
            odataResourceUrl.append("to_WorkCenterTodayOp");
            ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)ODATA_ENDPOINT_URL, (String)odataResourceUrl.toString());
            ODataQuery query = builder.build();
            ErpEndpoint erpEndpoint = new ErpEndpoint(this.erpConfigContext);
            ODataQueryResult result = query.execute((WithDestinationName)erpEndpoint);
            List entityList = result.asList(WorkCenterDayOperation.class);
            for (WorkCenterDayOperation entity : entityList) {
                entity.setErpConfigContext(this.erpConfigContext);
            }
            return entityList;
        }

        public String toString() {
            return "ReadWorkCenterDataNamespace.WorkCenters(workCenterInternalID=" + this.workCenterInternalID + ", workCenterUsage=" + this.workCenterUsage + ", capacityInternalID=" + this.capacityInternalID + ", workCenterTypeCode=" + this.workCenterTypeCode + ", workCenter=" + this.workCenter + ", workCenterDesc=" + this.workCenterDesc + ", plant=" + this.plant + ", workCenterCategoryCode=" + this.workCenterCategoryCode + ", workCenterResponsible=" + this.workCenterResponsible + ", workCenterResponsibleName=" + this.workCenterResponsibleName + ", supplyArea=" + this.supplyArea + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WorkCenters)) {
                return false;
            }
            WorkCenters other = (WorkCenters)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$workCenterInternalID = this.workCenterInternalID;
            String other$workCenterInternalID = other.workCenterInternalID;
            if (this$workCenterInternalID == null ? other$workCenterInternalID != null : !this$workCenterInternalID.equals(other$workCenterInternalID)) {
                return false;
            }
            String this$workCenterUsage = this.workCenterUsage;
            String other$workCenterUsage = other.workCenterUsage;
            if (this$workCenterUsage == null ? other$workCenterUsage != null : !this$workCenterUsage.equals(other$workCenterUsage)) {
                return false;
            }
            String this$capacityInternalID = this.capacityInternalID;
            String other$capacityInternalID = other.capacityInternalID;
            if (this$capacityInternalID == null ? other$capacityInternalID != null : !this$capacityInternalID.equals(other$capacityInternalID)) {
                return false;
            }
            String this$workCenterTypeCode = this.workCenterTypeCode;
            String other$workCenterTypeCode = other.workCenterTypeCode;
            if (this$workCenterTypeCode == null ? other$workCenterTypeCode != null : !this$workCenterTypeCode.equals(other$workCenterTypeCode)) {
                return false;
            }
            String this$workCenter = this.workCenter;
            String other$workCenter = other.workCenter;
            if (this$workCenter == null ? other$workCenter != null : !this$workCenter.equals(other$workCenter)) {
                return false;
            }
            String this$workCenterDesc = this.workCenterDesc;
            String other$workCenterDesc = other.workCenterDesc;
            if (this$workCenterDesc == null ? other$workCenterDesc != null : !this$workCenterDesc.equals(other$workCenterDesc)) {
                return false;
            }
            String this$plant = this.plant;
            String other$plant = other.plant;
            if (this$plant == null ? other$plant != null : !this$plant.equals(other$plant)) {
                return false;
            }
            String this$workCenterCategoryCode = this.workCenterCategoryCode;
            String other$workCenterCategoryCode = other.workCenterCategoryCode;
            if (this$workCenterCategoryCode == null ? other$workCenterCategoryCode != null : !this$workCenterCategoryCode.equals(other$workCenterCategoryCode)) {
                return false;
            }
            String this$workCenterResponsible = this.workCenterResponsible;
            String other$workCenterResponsible = other.workCenterResponsible;
            if (this$workCenterResponsible == null ? other$workCenterResponsible != null : !this$workCenterResponsible.equals(other$workCenterResponsible)) {
                return false;
            }
            String this$workCenterResponsibleName = this.workCenterResponsibleName;
            String other$workCenterResponsibleName = other.workCenterResponsibleName;
            if (this$workCenterResponsibleName == null ? other$workCenterResponsibleName != null : !this$workCenterResponsibleName.equals(other$workCenterResponsibleName)) {
                return false;
            }
            String this$supplyArea = this.supplyArea;
            String other$supplyArea = other.supplyArea;
            return !(this$supplyArea == null ? other$supplyArea != null : !this$supplyArea.equals(other$supplyArea));
        }

        protected boolean canEqual(Object other) {
            return other instanceof WorkCenters;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $workCenterInternalID = this.workCenterInternalID;
            result = result * 59 + ($workCenterInternalID == null ? 43 : $workCenterInternalID.hashCode());
            String $workCenterUsage = this.workCenterUsage;
            result = result * 59 + ($workCenterUsage == null ? 43 : $workCenterUsage.hashCode());
            String $capacityInternalID = this.capacityInternalID;
            result = result * 59 + ($capacityInternalID == null ? 43 : $capacityInternalID.hashCode());
            String $workCenterTypeCode = this.workCenterTypeCode;
            result = result * 59 + ($workCenterTypeCode == null ? 43 : $workCenterTypeCode.hashCode());
            String $workCenter = this.workCenter;
            result = result * 59 + ($workCenter == null ? 43 : $workCenter.hashCode());
            String $workCenterDesc = this.workCenterDesc;
            result = result * 59 + ($workCenterDesc == null ? 43 : $workCenterDesc.hashCode());
            String $plant = this.plant;
            result = result * 59 + ($plant == null ? 43 : $plant.hashCode());
            String $workCenterCategoryCode = this.workCenterCategoryCode;
            result = result * 59 + ($workCenterCategoryCode == null ? 43 : $workCenterCategoryCode.hashCode());
            String $workCenterResponsible = this.workCenterResponsible;
            result = result * 59 + ($workCenterResponsible == null ? 43 : $workCenterResponsible.hashCode());
            String $workCenterResponsibleName = this.workCenterResponsibleName;
            result = result * 59 + ($workCenterResponsibleName == null ? 43 : $workCenterResponsibleName.hashCode());
            String $supplyArea = this.supplyArea;
            result = result * 59 + ($supplyArea == null ? 43 : $supplyArea.hashCode());
            return result;
        }

        public String getWorkCenterInternalID() {
            return this.workCenterInternalID;
        }

        public WorkCenters setWorkCenterInternalID(String workCenterInternalID) {
            this.workCenterInternalID = workCenterInternalID;
            return this;
        }

        public String getWorkCenterUsage() {
            return this.workCenterUsage;
        }

        public WorkCenters setWorkCenterUsage(String workCenterUsage) {
            this.workCenterUsage = workCenterUsage;
            return this;
        }

        public String getCapacityInternalID() {
            return this.capacityInternalID;
        }

        public WorkCenters setCapacityInternalID(String capacityInternalID) {
            this.capacityInternalID = capacityInternalID;
            return this;
        }

        public String getWorkCenterTypeCode() {
            return this.workCenterTypeCode;
        }

        public WorkCenters setWorkCenterTypeCode(String workCenterTypeCode) {
            this.workCenterTypeCode = workCenterTypeCode;
            return this;
        }

        public String getWorkCenter() {
            return this.workCenter;
        }

        public WorkCenters setWorkCenter(String workCenter) {
            this.workCenter = workCenter;
            return this;
        }

        public String getWorkCenterDesc() {
            return this.workCenterDesc;
        }

        public WorkCenters setWorkCenterDesc(String workCenterDesc) {
            this.workCenterDesc = workCenterDesc;
            return this;
        }

        public String getPlant() {
            return this.plant;
        }

        public WorkCenters setPlant(String plant) {
            this.plant = plant;
            return this;
        }

        public String getWorkCenterCategoryCode() {
            return this.workCenterCategoryCode;
        }

        public WorkCenters setWorkCenterCategoryCode(String workCenterCategoryCode) {
            this.workCenterCategoryCode = workCenterCategoryCode;
            return this;
        }

        public String getWorkCenterResponsible() {
            return this.workCenterResponsible;
        }

        public WorkCenters setWorkCenterResponsible(String workCenterResponsible) {
            this.workCenterResponsible = workCenterResponsible;
            return this;
        }

        public String getWorkCenterResponsibleName() {
            return this.workCenterResponsibleName;
        }

        public WorkCenters setWorkCenterResponsibleName(String workCenterResponsibleName) {
            this.workCenterResponsibleName = workCenterResponsibleName;
            return this;
        }

        public String getSupplyArea() {
            return this.supplyArea;
        }

        public WorkCenters setSupplyArea(String supplyArea) {
            this.supplyArea = supplyArea;
            return this;
        }

        public WorkCenters setErpConfigContext(ErpConfigContext erpConfigContext) {
            this.erpConfigContext = erpConfigContext;
            return this;
        }
    }

    public static class WorkCenterPipeLineOperationFluentHelper {
        private ODataQueryBuilder queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_WORK_CENTERS", (String)"A_WorkCenterPipeLineOperation");
        private ErrorResultHandler<?> errorResultHandler = new ODataVdmErrorResultHandler();

        public WorkCenterPipeLineOperationFluentHelper filter(ExpressionFluentHelper<WorkCenterPipeLineOperation> expression) {
            for (FilterExpressionWrapper<?> filterExpressionWrapper : expression.evaluate()) {
                Object comparisonValue = filterExpressionWrapper.getComparisonValue();
                if (comparisonValue instanceof Integer) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Integer)((Integer)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof String) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((String)((String)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Long) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Long)((Long)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Double) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Double)((Double)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Float) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Float)((Float)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDate) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDate)((LocalDate)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDateTime)((LocalDateTime)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Date) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Date)((Date)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof DateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((DateTime)((DateTime)comparisonValue))));
                    continue;
                }
                this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of(comparisonValue)));
            }
            return this;
        }

        public WorkCenterPipeLineOperationFluentHelper orderBy(EntityField<?, WorkCenterPipeLineOperation> field, Order order) {
            String orderingDirection = order == Order.ASC ? " asc" : " desc";
            this.queryBuilder.param("orderby", (Object)(field.getFieldName() + orderingDirection));
            return this;
        }

        @SafeVarargs
        public final WorkCenterPipeLineOperationFluentHelper select(EntityField<?, WorkCenterPipeLineOperation> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public WorkCenterPipeLineOperationFluentHelper top(Number top) {
            this.queryBuilder.top(top);
            return this;
        }

        public WorkCenterPipeLineOperationFluentHelper skip(Number skip) {
            this.queryBuilder.skip(skip);
            return this;
        }

        public WorkCenterPipeLineOperationFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.errorHandler(this.errorResultHandler).build();
        }

        public List<WorkCenterPipeLineOperation> execute(ErpConfigContext erpConfigContext) throws ODataException {
            List entityList = this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).asList(WorkCenterPipeLineOperation.class);
            for (WorkCenterPipeLineOperation entity : entityList) {
                entity.setErpConfigContext(erpConfigContext);
            }
            return entityList;
        }
    }

    public static class WorkCenterPipeLineOperationByKeyFluentHelper {
        private ODataQueryBuilder queryBuilder;
        private ErrorResultHandler<?> errorResultHandler;
        private List<Object> values = new LinkedList<Object>();

        public WorkCenterPipeLineOperationByKeyFluentHelper(String workCenterInternalID, String manufacturingOrder, String manufacturingOrderOperation, String manufacturingOrderCategory) {
            this.values.add(workCenterInternalID);
            this.values.add(manufacturingOrder);
            this.values.add(manufacturingOrderOperation);
            this.values.add(manufacturingOrderCategory);
            this.queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_WORK_CENTERS", (String)"A_WorkCenterPipeLineOperation");
            HashMap<String, Object> keys = new HashMap<String, Object>();
            keys.put("WorkCenterInternalID", this.values.get(0));
            keys.put("ManufacturingOrder", this.values.get(1));
            keys.put("ManufacturingOrderOperation", this.values.get(2));
            keys.put("ManufacturingOrderCategory", this.values.get(3));
            this.queryBuilder.keys(keys);
        }

        @SafeVarargs
        public final WorkCenterPipeLineOperationByKeyFluentHelper select(EntityField<?, WorkCenterPipeLineOperation> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.build();
        }

        public WorkCenterPipeLineOperationByKeyFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public WorkCenterPipeLineOperation execute(ErpConfigContext erpConfigContext) throws ODataException {
            WorkCenterPipeLineOperation entity = (WorkCenterPipeLineOperation)this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).as(WorkCenterPipeLineOperation.class);
            entity.setErpConfigContext(erpConfigContext);
            return entity;
        }
    }

    public static class WorkCenterPipeLineOperation {
        @ElementName(value="WorkCenterInternalID")
        private String workCenterInternalID;
        public static EntityField<String, WorkCenterPipeLineOperation> WORK_CENTER_INTERNAL_I_D = new EntityField("WorkCenterInternalID");
        @ElementName(value="OpErlstSchedldExecEndDte")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar opErlstSchedldExecEndDte;
        public static EntityField<Calendar, WorkCenterPipeLineOperation> OP_ERLST_SCHEDLD_EXEC_END_DTE = new EntityField("OpErlstSchedldExecEndDte");
        @ElementName(value="OpErlstSchedldExecEndTme")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar opErlstSchedldExecEndTme;
        public static EntityField<Calendar, WorkCenterPipeLineOperation> OP_ERLST_SCHEDLD_EXEC_END_TME = new EntityField("OpErlstSchedldExecEndTme");
        @ElementName(value="OpPlannedTotalQuantity")
        private BigDecimal opPlannedTotalQuantity;
        public static EntityField<BigDecimal, WorkCenterPipeLineOperation> OP_PLANNED_TOTAL_QUANTITY = new EntityField("OpPlannedTotalQuantity");
        @ElementName(value="OperationUnit")
        private String operationUnit;
        public static EntityField<String, WorkCenterPipeLineOperation> OPERATION_UNIT = new EntityField("OperationUnit");
        @ElementName(value="ConfirmedQuantity")
        private BigDecimal confirmedQuantity;
        public static EntityField<BigDecimal, WorkCenterPipeLineOperation> CONFIRMED_QUANTITY = new EntityField("ConfirmedQuantity");
        @ElementName(value="ConfirmedQuantityInBaseUnit")
        private String confirmedQuantityInBaseUnit;
        public static EntityField<String, WorkCenterPipeLineOperation> CONFIRMED_QUANTITY_IN_BASE_UNIT = new EntityField("ConfirmedQuantityInBaseUnit");
        @ElementName(value="ErlstSchedldExecDurnInWorkdays")
        private Integer erlstSchedldExecDurnInWorkdays;
        public static EntityField<Integer, WorkCenterPipeLineOperation> ERLST_SCHEDLD_EXEC_DURN_IN_WORKDAYS = new EntityField("ErlstSchedldExecDurnInWorkdays");
        @ElementName(value="RemainingDuration")
        private Integer remainingDuration;
        public static EntityField<Integer, WorkCenterPipeLineOperation> REMAINING_DURATION = new EntityField("RemainingDuration");
        @ElementName(value="ManufacturingOrderSequence")
        private String manufacturingOrderSequence;
        public static EntityField<String, WorkCenterPipeLineOperation> MANUFACTURING_ORDER_SEQUENCE = new EntityField("ManufacturingOrderSequence");
        @ElementName(value="ManufacturingOrder")
        private String manufacturingOrder;
        public static EntityField<String, WorkCenterPipeLineOperation> MANUFACTURING_ORDER = new EntityField("ManufacturingOrder");
        @ElementName(value="ManufacturingOrderOperation")
        private String manufacturingOrderOperation;
        public static EntityField<String, WorkCenterPipeLineOperation> MANUFACTURING_ORDER_OPERATION = new EntityField("ManufacturingOrderOperation");
        @ElementName(value="ManufacturingOrderCategory")
        private String manufacturingOrderCategory;
        public static EntityField<String, WorkCenterPipeLineOperation> MANUFACTURING_ORDER_CATEGORY = new EntityField("ManufacturingOrderCategory");
        @ElementName(value="MfgOrderOperationText")
        private String mfgOrderOperationText;
        public static EntityField<String, WorkCenterPipeLineOperation> MFG_ORDER_OPERATION_TEXT = new EntityField("MfgOrderOperationText");
        @ElementName(value="Material")
        private String material;
        public static EntityField<String, WorkCenterPipeLineOperation> MATERIAL = new EntityField("Material");
        @ElementName(value="OperationIsReleased")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean operationIsReleased;
        public static EntityField<Boolean, WorkCenterPipeLineOperation> OPERATION_IS_RELEASED = new EntityField("OperationIsReleased");
        @ElementName(value="OpErlstSchedldExecStrtDte")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar opErlstSchedldExecStrtDte;
        public static EntityField<Calendar, WorkCenterPipeLineOperation> OP_ERLST_SCHEDLD_EXEC_STRT_DTE = new EntityField("OpErlstSchedldExecStrtDte");
        @ElementName(value="OpErlstSchedldExecStrtTme")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar opErlstSchedldExecStrtTme;
        public static EntityField<Calendar, WorkCenterPipeLineOperation> OP_ERLST_SCHEDLD_EXEC_STRT_TME = new EntityField("OpErlstSchedldExecStrtTme");
        private static final transient String ODATA_ENDPOINT_URL = "/sap/opu/odata/sap/API_WORK_CENTERS";
        private static final transient String ODATA_ENTITY_COLLECTION = "A_WorkCenterPipeLineOperation";
        private transient ErpConfigContext erpConfigContext;

        public String toString() {
            return "ReadWorkCenterDataNamespace.WorkCenterPipeLineOperation(workCenterInternalID=" + this.workCenterInternalID + ", opErlstSchedldExecEndDte=" + this.opErlstSchedldExecEndDte + ", opErlstSchedldExecEndTme=" + this.opErlstSchedldExecEndTme + ", opPlannedTotalQuantity=" + this.opPlannedTotalQuantity + ", operationUnit=" + this.operationUnit + ", confirmedQuantity=" + this.confirmedQuantity + ", confirmedQuantityInBaseUnit=" + this.confirmedQuantityInBaseUnit + ", erlstSchedldExecDurnInWorkdays=" + this.erlstSchedldExecDurnInWorkdays + ", remainingDuration=" + this.remainingDuration + ", manufacturingOrderSequence=" + this.manufacturingOrderSequence + ", manufacturingOrder=" + this.manufacturingOrder + ", manufacturingOrderOperation=" + this.manufacturingOrderOperation + ", manufacturingOrderCategory=" + this.manufacturingOrderCategory + ", mfgOrderOperationText=" + this.mfgOrderOperationText + ", material=" + this.material + ", operationIsReleased=" + this.operationIsReleased + ", opErlstSchedldExecStrtDte=" + this.opErlstSchedldExecStrtDte + ", opErlstSchedldExecStrtTme=" + this.opErlstSchedldExecStrtTme + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WorkCenterPipeLineOperation)) {
                return false;
            }
            WorkCenterPipeLineOperation other = (WorkCenterPipeLineOperation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$workCenterInternalID = this.workCenterInternalID;
            String other$workCenterInternalID = other.workCenterInternalID;
            if (this$workCenterInternalID == null ? other$workCenterInternalID != null : !this$workCenterInternalID.equals(other$workCenterInternalID)) {
                return false;
            }
            Calendar this$opErlstSchedldExecEndDte = this.opErlstSchedldExecEndDte;
            Calendar other$opErlstSchedldExecEndDte = other.opErlstSchedldExecEndDte;
            if (this$opErlstSchedldExecEndDte == null ? other$opErlstSchedldExecEndDte != null : !((Object)this$opErlstSchedldExecEndDte).equals(other$opErlstSchedldExecEndDte)) {
                return false;
            }
            Calendar this$opErlstSchedldExecEndTme = this.opErlstSchedldExecEndTme;
            Calendar other$opErlstSchedldExecEndTme = other.opErlstSchedldExecEndTme;
            if (this$opErlstSchedldExecEndTme == null ? other$opErlstSchedldExecEndTme != null : !((Object)this$opErlstSchedldExecEndTme).equals(other$opErlstSchedldExecEndTme)) {
                return false;
            }
            BigDecimal this$opPlannedTotalQuantity = this.opPlannedTotalQuantity;
            BigDecimal other$opPlannedTotalQuantity = other.opPlannedTotalQuantity;
            if (this$opPlannedTotalQuantity == null ? other$opPlannedTotalQuantity != null : !((Object)this$opPlannedTotalQuantity).equals(other$opPlannedTotalQuantity)) {
                return false;
            }
            String this$operationUnit = this.operationUnit;
            String other$operationUnit = other.operationUnit;
            if (this$operationUnit == null ? other$operationUnit != null : !this$operationUnit.equals(other$operationUnit)) {
                return false;
            }
            BigDecimal this$confirmedQuantity = this.confirmedQuantity;
            BigDecimal other$confirmedQuantity = other.confirmedQuantity;
            if (this$confirmedQuantity == null ? other$confirmedQuantity != null : !((Object)this$confirmedQuantity).equals(other$confirmedQuantity)) {
                return false;
            }
            String this$confirmedQuantityInBaseUnit = this.confirmedQuantityInBaseUnit;
            String other$confirmedQuantityInBaseUnit = other.confirmedQuantityInBaseUnit;
            if (this$confirmedQuantityInBaseUnit == null ? other$confirmedQuantityInBaseUnit != null : !this$confirmedQuantityInBaseUnit.equals(other$confirmedQuantityInBaseUnit)) {
                return false;
            }
            Integer this$erlstSchedldExecDurnInWorkdays = this.erlstSchedldExecDurnInWorkdays;
            Integer other$erlstSchedldExecDurnInWorkdays = other.erlstSchedldExecDurnInWorkdays;
            if (this$erlstSchedldExecDurnInWorkdays == null ? other$erlstSchedldExecDurnInWorkdays != null : !((Object)this$erlstSchedldExecDurnInWorkdays).equals(other$erlstSchedldExecDurnInWorkdays)) {
                return false;
            }
            Integer this$remainingDuration = this.remainingDuration;
            Integer other$remainingDuration = other.remainingDuration;
            if (this$remainingDuration == null ? other$remainingDuration != null : !((Object)this$remainingDuration).equals(other$remainingDuration)) {
                return false;
            }
            String this$manufacturingOrderSequence = this.manufacturingOrderSequence;
            String other$manufacturingOrderSequence = other.manufacturingOrderSequence;
            if (this$manufacturingOrderSequence == null ? other$manufacturingOrderSequence != null : !this$manufacturingOrderSequence.equals(other$manufacturingOrderSequence)) {
                return false;
            }
            String this$manufacturingOrder = this.manufacturingOrder;
            String other$manufacturingOrder = other.manufacturingOrder;
            if (this$manufacturingOrder == null ? other$manufacturingOrder != null : !this$manufacturingOrder.equals(other$manufacturingOrder)) {
                return false;
            }
            String this$manufacturingOrderOperation = this.manufacturingOrderOperation;
            String other$manufacturingOrderOperation = other.manufacturingOrderOperation;
            if (this$manufacturingOrderOperation == null ? other$manufacturingOrderOperation != null : !this$manufacturingOrderOperation.equals(other$manufacturingOrderOperation)) {
                return false;
            }
            String this$manufacturingOrderCategory = this.manufacturingOrderCategory;
            String other$manufacturingOrderCategory = other.manufacturingOrderCategory;
            if (this$manufacturingOrderCategory == null ? other$manufacturingOrderCategory != null : !this$manufacturingOrderCategory.equals(other$manufacturingOrderCategory)) {
                return false;
            }
            String this$mfgOrderOperationText = this.mfgOrderOperationText;
            String other$mfgOrderOperationText = other.mfgOrderOperationText;
            if (this$mfgOrderOperationText == null ? other$mfgOrderOperationText != null : !this$mfgOrderOperationText.equals(other$mfgOrderOperationText)) {
                return false;
            }
            String this$material = this.material;
            String other$material = other.material;
            if (this$material == null ? other$material != null : !this$material.equals(other$material)) {
                return false;
            }
            Boolean this$operationIsReleased = this.operationIsReleased;
            Boolean other$operationIsReleased = other.operationIsReleased;
            if (this$operationIsReleased == null ? other$operationIsReleased != null : !((Object)this$operationIsReleased).equals(other$operationIsReleased)) {
                return false;
            }
            Calendar this$opErlstSchedldExecStrtDte = this.opErlstSchedldExecStrtDte;
            Calendar other$opErlstSchedldExecStrtDte = other.opErlstSchedldExecStrtDte;
            if (this$opErlstSchedldExecStrtDte == null ? other$opErlstSchedldExecStrtDte != null : !((Object)this$opErlstSchedldExecStrtDte).equals(other$opErlstSchedldExecStrtDte)) {
                return false;
            }
            Calendar this$opErlstSchedldExecStrtTme = this.opErlstSchedldExecStrtTme;
            Calendar other$opErlstSchedldExecStrtTme = other.opErlstSchedldExecStrtTme;
            return !(this$opErlstSchedldExecStrtTme == null ? other$opErlstSchedldExecStrtTme != null : !((Object)this$opErlstSchedldExecStrtTme).equals(other$opErlstSchedldExecStrtTme));
        }

        protected boolean canEqual(Object other) {
            return other instanceof WorkCenterPipeLineOperation;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $workCenterInternalID = this.workCenterInternalID;
            result = result * 59 + ($workCenterInternalID == null ? 43 : $workCenterInternalID.hashCode());
            Calendar $opErlstSchedldExecEndDte = this.opErlstSchedldExecEndDte;
            result = result * 59 + ($opErlstSchedldExecEndDte == null ? 43 : ((Object)$opErlstSchedldExecEndDte).hashCode());
            Calendar $opErlstSchedldExecEndTme = this.opErlstSchedldExecEndTme;
            result = result * 59 + ($opErlstSchedldExecEndTme == null ? 43 : ((Object)$opErlstSchedldExecEndTme).hashCode());
            BigDecimal $opPlannedTotalQuantity = this.opPlannedTotalQuantity;
            result = result * 59 + ($opPlannedTotalQuantity == null ? 43 : ((Object)$opPlannedTotalQuantity).hashCode());
            String $operationUnit = this.operationUnit;
            result = result * 59 + ($operationUnit == null ? 43 : $operationUnit.hashCode());
            BigDecimal $confirmedQuantity = this.confirmedQuantity;
            result = result * 59 + ($confirmedQuantity == null ? 43 : ((Object)$confirmedQuantity).hashCode());
            String $confirmedQuantityInBaseUnit = this.confirmedQuantityInBaseUnit;
            result = result * 59 + ($confirmedQuantityInBaseUnit == null ? 43 : $confirmedQuantityInBaseUnit.hashCode());
            Integer $erlstSchedldExecDurnInWorkdays = this.erlstSchedldExecDurnInWorkdays;
            result = result * 59 + ($erlstSchedldExecDurnInWorkdays == null ? 43 : ((Object)$erlstSchedldExecDurnInWorkdays).hashCode());
            Integer $remainingDuration = this.remainingDuration;
            result = result * 59 + ($remainingDuration == null ? 43 : ((Object)$remainingDuration).hashCode());
            String $manufacturingOrderSequence = this.manufacturingOrderSequence;
            result = result * 59 + ($manufacturingOrderSequence == null ? 43 : $manufacturingOrderSequence.hashCode());
            String $manufacturingOrder = this.manufacturingOrder;
            result = result * 59 + ($manufacturingOrder == null ? 43 : $manufacturingOrder.hashCode());
            String $manufacturingOrderOperation = this.manufacturingOrderOperation;
            result = result * 59 + ($manufacturingOrderOperation == null ? 43 : $manufacturingOrderOperation.hashCode());
            String $manufacturingOrderCategory = this.manufacturingOrderCategory;
            result = result * 59 + ($manufacturingOrderCategory == null ? 43 : $manufacturingOrderCategory.hashCode());
            String $mfgOrderOperationText = this.mfgOrderOperationText;
            result = result * 59 + ($mfgOrderOperationText == null ? 43 : $mfgOrderOperationText.hashCode());
            String $material = this.material;
            result = result * 59 + ($material == null ? 43 : $material.hashCode());
            Boolean $operationIsReleased = this.operationIsReleased;
            result = result * 59 + ($operationIsReleased == null ? 43 : ((Object)$operationIsReleased).hashCode());
            Calendar $opErlstSchedldExecStrtDte = this.opErlstSchedldExecStrtDte;
            result = result * 59 + ($opErlstSchedldExecStrtDte == null ? 43 : ((Object)$opErlstSchedldExecStrtDte).hashCode());
            Calendar $opErlstSchedldExecStrtTme = this.opErlstSchedldExecStrtTme;
            result = result * 59 + ($opErlstSchedldExecStrtTme == null ? 43 : ((Object)$opErlstSchedldExecStrtTme).hashCode());
            return result;
        }

        public String getWorkCenterInternalID() {
            return this.workCenterInternalID;
        }

        public WorkCenterPipeLineOperation setWorkCenterInternalID(String workCenterInternalID) {
            this.workCenterInternalID = workCenterInternalID;
            return this;
        }

        public Calendar getOpErlstSchedldExecEndDte() {
            return this.opErlstSchedldExecEndDte;
        }

        public WorkCenterPipeLineOperation setOpErlstSchedldExecEndDte(Calendar opErlstSchedldExecEndDte) {
            this.opErlstSchedldExecEndDte = opErlstSchedldExecEndDte;
            return this;
        }

        public Calendar getOpErlstSchedldExecEndTme() {
            return this.opErlstSchedldExecEndTme;
        }

        public WorkCenterPipeLineOperation setOpErlstSchedldExecEndTme(Calendar opErlstSchedldExecEndTme) {
            this.opErlstSchedldExecEndTme = opErlstSchedldExecEndTme;
            return this;
        }

        public BigDecimal getOpPlannedTotalQuantity() {
            return this.opPlannedTotalQuantity;
        }

        public WorkCenterPipeLineOperation setOpPlannedTotalQuantity(BigDecimal opPlannedTotalQuantity) {
            this.opPlannedTotalQuantity = opPlannedTotalQuantity;
            return this;
        }

        public String getOperationUnit() {
            return this.operationUnit;
        }

        public WorkCenterPipeLineOperation setOperationUnit(String operationUnit) {
            this.operationUnit = operationUnit;
            return this;
        }

        public BigDecimal getConfirmedQuantity() {
            return this.confirmedQuantity;
        }

        public WorkCenterPipeLineOperation setConfirmedQuantity(BigDecimal confirmedQuantity) {
            this.confirmedQuantity = confirmedQuantity;
            return this;
        }

        public String getConfirmedQuantityInBaseUnit() {
            return this.confirmedQuantityInBaseUnit;
        }

        public WorkCenterPipeLineOperation setConfirmedQuantityInBaseUnit(String confirmedQuantityInBaseUnit) {
            this.confirmedQuantityInBaseUnit = confirmedQuantityInBaseUnit;
            return this;
        }

        public Integer getErlstSchedldExecDurnInWorkdays() {
            return this.erlstSchedldExecDurnInWorkdays;
        }

        public WorkCenterPipeLineOperation setErlstSchedldExecDurnInWorkdays(Integer erlstSchedldExecDurnInWorkdays) {
            this.erlstSchedldExecDurnInWorkdays = erlstSchedldExecDurnInWorkdays;
            return this;
        }

        public Integer getRemainingDuration() {
            return this.remainingDuration;
        }

        public WorkCenterPipeLineOperation setRemainingDuration(Integer remainingDuration) {
            this.remainingDuration = remainingDuration;
            return this;
        }

        public String getManufacturingOrderSequence() {
            return this.manufacturingOrderSequence;
        }

        public WorkCenterPipeLineOperation setManufacturingOrderSequence(String manufacturingOrderSequence) {
            this.manufacturingOrderSequence = manufacturingOrderSequence;
            return this;
        }

        public String getManufacturingOrder() {
            return this.manufacturingOrder;
        }

        public WorkCenterPipeLineOperation setManufacturingOrder(String manufacturingOrder) {
            this.manufacturingOrder = manufacturingOrder;
            return this;
        }

        public String getManufacturingOrderOperation() {
            return this.manufacturingOrderOperation;
        }

        public WorkCenterPipeLineOperation setManufacturingOrderOperation(String manufacturingOrderOperation) {
            this.manufacturingOrderOperation = manufacturingOrderOperation;
            return this;
        }

        public String getManufacturingOrderCategory() {
            return this.manufacturingOrderCategory;
        }

        public WorkCenterPipeLineOperation setManufacturingOrderCategory(String manufacturingOrderCategory) {
            this.manufacturingOrderCategory = manufacturingOrderCategory;
            return this;
        }

        public String getMfgOrderOperationText() {
            return this.mfgOrderOperationText;
        }

        public WorkCenterPipeLineOperation setMfgOrderOperationText(String mfgOrderOperationText) {
            this.mfgOrderOperationText = mfgOrderOperationText;
            return this;
        }

        public String getMaterial() {
            return this.material;
        }

        public WorkCenterPipeLineOperation setMaterial(String material) {
            this.material = material;
            return this;
        }

        public Boolean getOperationIsReleased() {
            return this.operationIsReleased;
        }

        public WorkCenterPipeLineOperation setOperationIsReleased(Boolean operationIsReleased) {
            this.operationIsReleased = operationIsReleased;
            return this;
        }

        public Calendar getOpErlstSchedldExecStrtDte() {
            return this.opErlstSchedldExecStrtDte;
        }

        public WorkCenterPipeLineOperation setOpErlstSchedldExecStrtDte(Calendar opErlstSchedldExecStrtDte) {
            this.opErlstSchedldExecStrtDte = opErlstSchedldExecStrtDte;
            return this;
        }

        public Calendar getOpErlstSchedldExecStrtTme() {
            return this.opErlstSchedldExecStrtTme;
        }

        public WorkCenterPipeLineOperation setOpErlstSchedldExecStrtTme(Calendar opErlstSchedldExecStrtTme) {
            this.opErlstSchedldExecStrtTme = opErlstSchedldExecStrtTme;
            return this;
        }

        public WorkCenterPipeLineOperation setErpConfigContext(ErpConfigContext erpConfigContext) {
            this.erpConfigContext = erpConfigContext;
            return this;
        }
    }

    public static class WorkCenterDayOperationFluentHelper {
        private ODataQueryBuilder queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_WORK_CENTERS", (String)"A_WorkCenterDayOperation");
        private ErrorResultHandler<?> errorResultHandler = new ODataVdmErrorResultHandler();

        public WorkCenterDayOperationFluentHelper filter(ExpressionFluentHelper<WorkCenterDayOperation> expression) {
            for (FilterExpressionWrapper<?> filterExpressionWrapper : expression.evaluate()) {
                Object comparisonValue = filterExpressionWrapper.getComparisonValue();
                if (comparisonValue instanceof Integer) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Integer)((Integer)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof String) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((String)((String)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Long) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Long)((Long)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Double) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Double)((Double)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Float) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Float)((Float)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDate) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDate)((LocalDate)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDateTime)((LocalDateTime)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Date) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Date)((Date)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof DateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((DateTime)((DateTime)comparisonValue))));
                    continue;
                }
                this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of(comparisonValue)));
            }
            return this;
        }

        public WorkCenterDayOperationFluentHelper orderBy(EntityField<?, WorkCenterDayOperation> field, Order order) {
            String orderingDirection = order == Order.ASC ? " asc" : " desc";
            this.queryBuilder.param("orderby", (Object)(field.getFieldName() + orderingDirection));
            return this;
        }

        @SafeVarargs
        public final WorkCenterDayOperationFluentHelper select(EntityField<?, WorkCenterDayOperation> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public WorkCenterDayOperationFluentHelper top(Number top) {
            this.queryBuilder.top(top);
            return this;
        }

        public WorkCenterDayOperationFluentHelper skip(Number skip) {
            this.queryBuilder.skip(skip);
            return this;
        }

        public WorkCenterDayOperationFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.errorHandler(this.errorResultHandler).build();
        }

        public List<WorkCenterDayOperation> execute(ErpConfigContext erpConfigContext) throws ODataException {
            List entityList = this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).asList(WorkCenterDayOperation.class);
            for (WorkCenterDayOperation entity : entityList) {
                entity.setErpConfigContext(erpConfigContext);
            }
            return entityList;
        }
    }

    public static class WorkCenterDayOperationByKeyFluentHelper {
        private ODataQueryBuilder queryBuilder;
        private ErrorResultHandler<?> errorResultHandler;
        private List<Object> values = new LinkedList<Object>();

        public WorkCenterDayOperationByKeyFluentHelper(String workCenterInternalID, String manufacturingOrder, String manufacturingOrderOperation, String manufacturingOrderCategory) {
            this.values.add(workCenterInternalID);
            this.values.add(manufacturingOrder);
            this.values.add(manufacturingOrderOperation);
            this.values.add(manufacturingOrderCategory);
            this.queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_WORK_CENTERS", (String)"A_WorkCenterDayOperation");
            HashMap<String, Object> keys = new HashMap<String, Object>();
            keys.put("WorkCenterInternalID", this.values.get(0));
            keys.put("ManufacturingOrder", this.values.get(1));
            keys.put("ManufacturingOrderOperation", this.values.get(2));
            keys.put("ManufacturingOrderCategory", this.values.get(3));
            this.queryBuilder.keys(keys);
        }

        @SafeVarargs
        public final WorkCenterDayOperationByKeyFluentHelper select(EntityField<?, WorkCenterDayOperation> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.build();
        }

        public WorkCenterDayOperationByKeyFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public WorkCenterDayOperation execute(ErpConfigContext erpConfigContext) throws ODataException {
            WorkCenterDayOperation entity = (WorkCenterDayOperation)this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).as(WorkCenterDayOperation.class);
            entity.setErpConfigContext(erpConfigContext);
            return entity;
        }
    }

    public static class WorkCenterDayOperation {
        @ElementName(value="WorkCenterInternalID")
        private String workCenterInternalID;
        public static EntityField<String, WorkCenterDayOperation> WORK_CENTER_INTERNAL_I_D = new EntityField("WorkCenterInternalID");
        @ElementName(value="OpErlstSchedldExecEndDte")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar opErlstSchedldExecEndDte;
        public static EntityField<Calendar, WorkCenterDayOperation> OP_ERLST_SCHEDLD_EXEC_END_DTE = new EntityField("OpErlstSchedldExecEndDte");
        @ElementName(value="OpErlstSchedldExecEndTme")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar opErlstSchedldExecEndTme;
        public static EntityField<Calendar, WorkCenterDayOperation> OP_ERLST_SCHEDLD_EXEC_END_TME = new EntityField("OpErlstSchedldExecEndTme");
        @ElementName(value="OpPlannedTotalQuantity")
        private BigDecimal opPlannedTotalQuantity;
        public static EntityField<BigDecimal, WorkCenterDayOperation> OP_PLANNED_TOTAL_QUANTITY = new EntityField("OpPlannedTotalQuantity");
        @ElementName(value="OperationUnit")
        private String operationUnit;
        public static EntityField<String, WorkCenterDayOperation> OPERATION_UNIT = new EntityField("OperationUnit");
        @ElementName(value="ConfirmedQuantity")
        private BigDecimal confirmedQuantity;
        public static EntityField<BigDecimal, WorkCenterDayOperation> CONFIRMED_QUANTITY = new EntityField("ConfirmedQuantity");
        @ElementName(value="ConfirmedQuantityInBaseUnit")
        private String confirmedQuantityInBaseUnit;
        public static EntityField<String, WorkCenterDayOperation> CONFIRMED_QUANTITY_IN_BASE_UNIT = new EntityField("ConfirmedQuantityInBaseUnit");
        @ElementName(value="ErlstSchedldExecDurnInWorkdays")
        private Integer erlstSchedldExecDurnInWorkdays;
        public static EntityField<Integer, WorkCenterDayOperation> ERLST_SCHEDLD_EXEC_DURN_IN_WORKDAYS = new EntityField("ErlstSchedldExecDurnInWorkdays");
        @ElementName(value="OpActualExecutionDays")
        private Integer opActualExecutionDays;
        public static EntityField<Integer, WorkCenterDayOperation> OP_ACTUAL_EXECUTION_DAYS = new EntityField("OpActualExecutionDays");
        @ElementName(value="ManufacturingOrderSequence")
        private String manufacturingOrderSequence;
        public static EntityField<String, WorkCenterDayOperation> MANUFACTURING_ORDER_SEQUENCE = new EntityField("ManufacturingOrderSequence");
        @ElementName(value="ManufacturingOrder")
        private String manufacturingOrder;
        public static EntityField<String, WorkCenterDayOperation> MANUFACTURING_ORDER = new EntityField("ManufacturingOrder");
        @ElementName(value="ManufacturingOrderOperation")
        private String manufacturingOrderOperation;
        public static EntityField<String, WorkCenterDayOperation> MANUFACTURING_ORDER_OPERATION = new EntityField("ManufacturingOrderOperation");
        @ElementName(value="ManufacturingOrderCategory")
        private String manufacturingOrderCategory;
        public static EntityField<String, WorkCenterDayOperation> MANUFACTURING_ORDER_CATEGORY = new EntityField("ManufacturingOrderCategory");
        @ElementName(value="MfgOrderOperationText")
        private String mfgOrderOperationText;
        public static EntityField<String, WorkCenterDayOperation> MFG_ORDER_OPERATION_TEXT = new EntityField("MfgOrderOperationText");
        @ElementName(value="Material")
        private String material;
        public static EntityField<String, WorkCenterDayOperation> MATERIAL = new EntityField("Material");
        @ElementName(value="OperationIsReleased")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean operationIsReleased;
        public static EntityField<Boolean, WorkCenterDayOperation> OPERATION_IS_RELEASED = new EntityField("OperationIsReleased");
        @ElementName(value="OpErlstSchedldExecStrtDte")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar opErlstSchedldExecStrtDte;
        public static EntityField<Calendar, WorkCenterDayOperation> OP_ERLST_SCHEDLD_EXEC_STRT_DTE = new EntityField("OpErlstSchedldExecStrtDte");
        @ElementName(value="OpErlstSchedldExecStrtTme")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar opErlstSchedldExecStrtTme;
        public static EntityField<Calendar, WorkCenterDayOperation> OP_ERLST_SCHEDLD_EXEC_STRT_TME = new EntityField("OpErlstSchedldExecStrtTme");
        private static final transient String ODATA_ENDPOINT_URL = "/sap/opu/odata/sap/API_WORK_CENTERS";
        private static final transient String ODATA_ENTITY_COLLECTION = "A_WorkCenterDayOperation";
        private transient ErpConfigContext erpConfigContext;

        public String toString() {
            return "ReadWorkCenterDataNamespace.WorkCenterDayOperation(workCenterInternalID=" + this.workCenterInternalID + ", opErlstSchedldExecEndDte=" + this.opErlstSchedldExecEndDte + ", opErlstSchedldExecEndTme=" + this.opErlstSchedldExecEndTme + ", opPlannedTotalQuantity=" + this.opPlannedTotalQuantity + ", operationUnit=" + this.operationUnit + ", confirmedQuantity=" + this.confirmedQuantity + ", confirmedQuantityInBaseUnit=" + this.confirmedQuantityInBaseUnit + ", erlstSchedldExecDurnInWorkdays=" + this.erlstSchedldExecDurnInWorkdays + ", opActualExecutionDays=" + this.opActualExecutionDays + ", manufacturingOrderSequence=" + this.manufacturingOrderSequence + ", manufacturingOrder=" + this.manufacturingOrder + ", manufacturingOrderOperation=" + this.manufacturingOrderOperation + ", manufacturingOrderCategory=" + this.manufacturingOrderCategory + ", mfgOrderOperationText=" + this.mfgOrderOperationText + ", material=" + this.material + ", operationIsReleased=" + this.operationIsReleased + ", opErlstSchedldExecStrtDte=" + this.opErlstSchedldExecStrtDte + ", opErlstSchedldExecStrtTme=" + this.opErlstSchedldExecStrtTme + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WorkCenterDayOperation)) {
                return false;
            }
            WorkCenterDayOperation other = (WorkCenterDayOperation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$workCenterInternalID = this.workCenterInternalID;
            String other$workCenterInternalID = other.workCenterInternalID;
            if (this$workCenterInternalID == null ? other$workCenterInternalID != null : !this$workCenterInternalID.equals(other$workCenterInternalID)) {
                return false;
            }
            Calendar this$opErlstSchedldExecEndDte = this.opErlstSchedldExecEndDte;
            Calendar other$opErlstSchedldExecEndDte = other.opErlstSchedldExecEndDte;
            if (this$opErlstSchedldExecEndDte == null ? other$opErlstSchedldExecEndDte != null : !((Object)this$opErlstSchedldExecEndDte).equals(other$opErlstSchedldExecEndDte)) {
                return false;
            }
            Calendar this$opErlstSchedldExecEndTme = this.opErlstSchedldExecEndTme;
            Calendar other$opErlstSchedldExecEndTme = other.opErlstSchedldExecEndTme;
            if (this$opErlstSchedldExecEndTme == null ? other$opErlstSchedldExecEndTme != null : !((Object)this$opErlstSchedldExecEndTme).equals(other$opErlstSchedldExecEndTme)) {
                return false;
            }
            BigDecimal this$opPlannedTotalQuantity = this.opPlannedTotalQuantity;
            BigDecimal other$opPlannedTotalQuantity = other.opPlannedTotalQuantity;
            if (this$opPlannedTotalQuantity == null ? other$opPlannedTotalQuantity != null : !((Object)this$opPlannedTotalQuantity).equals(other$opPlannedTotalQuantity)) {
                return false;
            }
            String this$operationUnit = this.operationUnit;
            String other$operationUnit = other.operationUnit;
            if (this$operationUnit == null ? other$operationUnit != null : !this$operationUnit.equals(other$operationUnit)) {
                return false;
            }
            BigDecimal this$confirmedQuantity = this.confirmedQuantity;
            BigDecimal other$confirmedQuantity = other.confirmedQuantity;
            if (this$confirmedQuantity == null ? other$confirmedQuantity != null : !((Object)this$confirmedQuantity).equals(other$confirmedQuantity)) {
                return false;
            }
            String this$confirmedQuantityInBaseUnit = this.confirmedQuantityInBaseUnit;
            String other$confirmedQuantityInBaseUnit = other.confirmedQuantityInBaseUnit;
            if (this$confirmedQuantityInBaseUnit == null ? other$confirmedQuantityInBaseUnit != null : !this$confirmedQuantityInBaseUnit.equals(other$confirmedQuantityInBaseUnit)) {
                return false;
            }
            Integer this$erlstSchedldExecDurnInWorkdays = this.erlstSchedldExecDurnInWorkdays;
            Integer other$erlstSchedldExecDurnInWorkdays = other.erlstSchedldExecDurnInWorkdays;
            if (this$erlstSchedldExecDurnInWorkdays == null ? other$erlstSchedldExecDurnInWorkdays != null : !((Object)this$erlstSchedldExecDurnInWorkdays).equals(other$erlstSchedldExecDurnInWorkdays)) {
                return false;
            }
            Integer this$opActualExecutionDays = this.opActualExecutionDays;
            Integer other$opActualExecutionDays = other.opActualExecutionDays;
            if (this$opActualExecutionDays == null ? other$opActualExecutionDays != null : !((Object)this$opActualExecutionDays).equals(other$opActualExecutionDays)) {
                return false;
            }
            String this$manufacturingOrderSequence = this.manufacturingOrderSequence;
            String other$manufacturingOrderSequence = other.manufacturingOrderSequence;
            if (this$manufacturingOrderSequence == null ? other$manufacturingOrderSequence != null : !this$manufacturingOrderSequence.equals(other$manufacturingOrderSequence)) {
                return false;
            }
            String this$manufacturingOrder = this.manufacturingOrder;
            String other$manufacturingOrder = other.manufacturingOrder;
            if (this$manufacturingOrder == null ? other$manufacturingOrder != null : !this$manufacturingOrder.equals(other$manufacturingOrder)) {
                return false;
            }
            String this$manufacturingOrderOperation = this.manufacturingOrderOperation;
            String other$manufacturingOrderOperation = other.manufacturingOrderOperation;
            if (this$manufacturingOrderOperation == null ? other$manufacturingOrderOperation != null : !this$manufacturingOrderOperation.equals(other$manufacturingOrderOperation)) {
                return false;
            }
            String this$manufacturingOrderCategory = this.manufacturingOrderCategory;
            String other$manufacturingOrderCategory = other.manufacturingOrderCategory;
            if (this$manufacturingOrderCategory == null ? other$manufacturingOrderCategory != null : !this$manufacturingOrderCategory.equals(other$manufacturingOrderCategory)) {
                return false;
            }
            String this$mfgOrderOperationText = this.mfgOrderOperationText;
            String other$mfgOrderOperationText = other.mfgOrderOperationText;
            if (this$mfgOrderOperationText == null ? other$mfgOrderOperationText != null : !this$mfgOrderOperationText.equals(other$mfgOrderOperationText)) {
                return false;
            }
            String this$material = this.material;
            String other$material = other.material;
            if (this$material == null ? other$material != null : !this$material.equals(other$material)) {
                return false;
            }
            Boolean this$operationIsReleased = this.operationIsReleased;
            Boolean other$operationIsReleased = other.operationIsReleased;
            if (this$operationIsReleased == null ? other$operationIsReleased != null : !((Object)this$operationIsReleased).equals(other$operationIsReleased)) {
                return false;
            }
            Calendar this$opErlstSchedldExecStrtDte = this.opErlstSchedldExecStrtDte;
            Calendar other$opErlstSchedldExecStrtDte = other.opErlstSchedldExecStrtDte;
            if (this$opErlstSchedldExecStrtDte == null ? other$opErlstSchedldExecStrtDte != null : !((Object)this$opErlstSchedldExecStrtDte).equals(other$opErlstSchedldExecStrtDte)) {
                return false;
            }
            Calendar this$opErlstSchedldExecStrtTme = this.opErlstSchedldExecStrtTme;
            Calendar other$opErlstSchedldExecStrtTme = other.opErlstSchedldExecStrtTme;
            return !(this$opErlstSchedldExecStrtTme == null ? other$opErlstSchedldExecStrtTme != null : !((Object)this$opErlstSchedldExecStrtTme).equals(other$opErlstSchedldExecStrtTme));
        }

        protected boolean canEqual(Object other) {
            return other instanceof WorkCenterDayOperation;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $workCenterInternalID = this.workCenterInternalID;
            result = result * 59 + ($workCenterInternalID == null ? 43 : $workCenterInternalID.hashCode());
            Calendar $opErlstSchedldExecEndDte = this.opErlstSchedldExecEndDte;
            result = result * 59 + ($opErlstSchedldExecEndDte == null ? 43 : ((Object)$opErlstSchedldExecEndDte).hashCode());
            Calendar $opErlstSchedldExecEndTme = this.opErlstSchedldExecEndTme;
            result = result * 59 + ($opErlstSchedldExecEndTme == null ? 43 : ((Object)$opErlstSchedldExecEndTme).hashCode());
            BigDecimal $opPlannedTotalQuantity = this.opPlannedTotalQuantity;
            result = result * 59 + ($opPlannedTotalQuantity == null ? 43 : ((Object)$opPlannedTotalQuantity).hashCode());
            String $operationUnit = this.operationUnit;
            result = result * 59 + ($operationUnit == null ? 43 : $operationUnit.hashCode());
            BigDecimal $confirmedQuantity = this.confirmedQuantity;
            result = result * 59 + ($confirmedQuantity == null ? 43 : ((Object)$confirmedQuantity).hashCode());
            String $confirmedQuantityInBaseUnit = this.confirmedQuantityInBaseUnit;
            result = result * 59 + ($confirmedQuantityInBaseUnit == null ? 43 : $confirmedQuantityInBaseUnit.hashCode());
            Integer $erlstSchedldExecDurnInWorkdays = this.erlstSchedldExecDurnInWorkdays;
            result = result * 59 + ($erlstSchedldExecDurnInWorkdays == null ? 43 : ((Object)$erlstSchedldExecDurnInWorkdays).hashCode());
            Integer $opActualExecutionDays = this.opActualExecutionDays;
            result = result * 59 + ($opActualExecutionDays == null ? 43 : ((Object)$opActualExecutionDays).hashCode());
            String $manufacturingOrderSequence = this.manufacturingOrderSequence;
            result = result * 59 + ($manufacturingOrderSequence == null ? 43 : $manufacturingOrderSequence.hashCode());
            String $manufacturingOrder = this.manufacturingOrder;
            result = result * 59 + ($manufacturingOrder == null ? 43 : $manufacturingOrder.hashCode());
            String $manufacturingOrderOperation = this.manufacturingOrderOperation;
            result = result * 59 + ($manufacturingOrderOperation == null ? 43 : $manufacturingOrderOperation.hashCode());
            String $manufacturingOrderCategory = this.manufacturingOrderCategory;
            result = result * 59 + ($manufacturingOrderCategory == null ? 43 : $manufacturingOrderCategory.hashCode());
            String $mfgOrderOperationText = this.mfgOrderOperationText;
            result = result * 59 + ($mfgOrderOperationText == null ? 43 : $mfgOrderOperationText.hashCode());
            String $material = this.material;
            result = result * 59 + ($material == null ? 43 : $material.hashCode());
            Boolean $operationIsReleased = this.operationIsReleased;
            result = result * 59 + ($operationIsReleased == null ? 43 : ((Object)$operationIsReleased).hashCode());
            Calendar $opErlstSchedldExecStrtDte = this.opErlstSchedldExecStrtDte;
            result = result * 59 + ($opErlstSchedldExecStrtDte == null ? 43 : ((Object)$opErlstSchedldExecStrtDte).hashCode());
            Calendar $opErlstSchedldExecStrtTme = this.opErlstSchedldExecStrtTme;
            result = result * 59 + ($opErlstSchedldExecStrtTme == null ? 43 : ((Object)$opErlstSchedldExecStrtTme).hashCode());
            return result;
        }

        public String getWorkCenterInternalID() {
            return this.workCenterInternalID;
        }

        public WorkCenterDayOperation setWorkCenterInternalID(String workCenterInternalID) {
            this.workCenterInternalID = workCenterInternalID;
            return this;
        }

        public Calendar getOpErlstSchedldExecEndDte() {
            return this.opErlstSchedldExecEndDte;
        }

        public WorkCenterDayOperation setOpErlstSchedldExecEndDte(Calendar opErlstSchedldExecEndDte) {
            this.opErlstSchedldExecEndDte = opErlstSchedldExecEndDte;
            return this;
        }

        public Calendar getOpErlstSchedldExecEndTme() {
            return this.opErlstSchedldExecEndTme;
        }

        public WorkCenterDayOperation setOpErlstSchedldExecEndTme(Calendar opErlstSchedldExecEndTme) {
            this.opErlstSchedldExecEndTme = opErlstSchedldExecEndTme;
            return this;
        }

        public BigDecimal getOpPlannedTotalQuantity() {
            return this.opPlannedTotalQuantity;
        }

        public WorkCenterDayOperation setOpPlannedTotalQuantity(BigDecimal opPlannedTotalQuantity) {
            this.opPlannedTotalQuantity = opPlannedTotalQuantity;
            return this;
        }

        public String getOperationUnit() {
            return this.operationUnit;
        }

        public WorkCenterDayOperation setOperationUnit(String operationUnit) {
            this.operationUnit = operationUnit;
            return this;
        }

        public BigDecimal getConfirmedQuantity() {
            return this.confirmedQuantity;
        }

        public WorkCenterDayOperation setConfirmedQuantity(BigDecimal confirmedQuantity) {
            this.confirmedQuantity = confirmedQuantity;
            return this;
        }

        public String getConfirmedQuantityInBaseUnit() {
            return this.confirmedQuantityInBaseUnit;
        }

        public WorkCenterDayOperation setConfirmedQuantityInBaseUnit(String confirmedQuantityInBaseUnit) {
            this.confirmedQuantityInBaseUnit = confirmedQuantityInBaseUnit;
            return this;
        }

        public Integer getErlstSchedldExecDurnInWorkdays() {
            return this.erlstSchedldExecDurnInWorkdays;
        }

        public WorkCenterDayOperation setErlstSchedldExecDurnInWorkdays(Integer erlstSchedldExecDurnInWorkdays) {
            this.erlstSchedldExecDurnInWorkdays = erlstSchedldExecDurnInWorkdays;
            return this;
        }

        public Integer getOpActualExecutionDays() {
            return this.opActualExecutionDays;
        }

        public WorkCenterDayOperation setOpActualExecutionDays(Integer opActualExecutionDays) {
            this.opActualExecutionDays = opActualExecutionDays;
            return this;
        }

        public String getManufacturingOrderSequence() {
            return this.manufacturingOrderSequence;
        }

        public WorkCenterDayOperation setManufacturingOrderSequence(String manufacturingOrderSequence) {
            this.manufacturingOrderSequence = manufacturingOrderSequence;
            return this;
        }

        public String getManufacturingOrder() {
            return this.manufacturingOrder;
        }

        public WorkCenterDayOperation setManufacturingOrder(String manufacturingOrder) {
            this.manufacturingOrder = manufacturingOrder;
            return this;
        }

        public String getManufacturingOrderOperation() {
            return this.manufacturingOrderOperation;
        }

        public WorkCenterDayOperation setManufacturingOrderOperation(String manufacturingOrderOperation) {
            this.manufacturingOrderOperation = manufacturingOrderOperation;
            return this;
        }

        public String getManufacturingOrderCategory() {
            return this.manufacturingOrderCategory;
        }

        public WorkCenterDayOperation setManufacturingOrderCategory(String manufacturingOrderCategory) {
            this.manufacturingOrderCategory = manufacturingOrderCategory;
            return this;
        }

        public String getMfgOrderOperationText() {
            return this.mfgOrderOperationText;
        }

        public WorkCenterDayOperation setMfgOrderOperationText(String mfgOrderOperationText) {
            this.mfgOrderOperationText = mfgOrderOperationText;
            return this;
        }

        public String getMaterial() {
            return this.material;
        }

        public WorkCenterDayOperation setMaterial(String material) {
            this.material = material;
            return this;
        }

        public Boolean getOperationIsReleased() {
            return this.operationIsReleased;
        }

        public WorkCenterDayOperation setOperationIsReleased(Boolean operationIsReleased) {
            this.operationIsReleased = operationIsReleased;
            return this;
        }

        public Calendar getOpErlstSchedldExecStrtDte() {
            return this.opErlstSchedldExecStrtDte;
        }

        public WorkCenterDayOperation setOpErlstSchedldExecStrtDte(Calendar opErlstSchedldExecStrtDte) {
            this.opErlstSchedldExecStrtDte = opErlstSchedldExecStrtDte;
            return this;
        }

        public Calendar getOpErlstSchedldExecStrtTme() {
            return this.opErlstSchedldExecStrtTme;
        }

        public WorkCenterDayOperation setOpErlstSchedldExecStrtTme(Calendar opErlstSchedldExecStrtTme) {
            this.opErlstSchedldExecStrtTme = opErlstSchedldExecStrtTme;
            return this;
        }

        public WorkCenterDayOperation setErpConfigContext(ErpConfigContext erpConfigContext) {
            this.erpConfigContext = erpConfigContext;
            return this;
        }
    }

    public static class WorkCenterCapacityFluentHelper {
        private ODataQueryBuilder queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_WORK_CENTERS", (String)"A_WorkCenterCapacity");
        private ErrorResultHandler<?> errorResultHandler = new ODataVdmErrorResultHandler();

        public WorkCenterCapacityFluentHelper filter(ExpressionFluentHelper<WorkCenterCapacity> expression) {
            for (FilterExpressionWrapper<?> filterExpressionWrapper : expression.evaluate()) {
                Object comparisonValue = filterExpressionWrapper.getComparisonValue();
                if (comparisonValue instanceof Integer) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Integer)((Integer)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof String) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((String)((String)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Long) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Long)((Long)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Double) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Double)((Double)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Float) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Float)((Float)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDate) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDate)((LocalDate)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDateTime)((LocalDateTime)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Date) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Date)((Date)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof DateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((DateTime)((DateTime)comparisonValue))));
                    continue;
                }
                this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of(comparisonValue)));
            }
            return this;
        }

        public WorkCenterCapacityFluentHelper orderBy(EntityField<?, WorkCenterCapacity> field, Order order) {
            String orderingDirection = order == Order.ASC ? " asc" : " desc";
            this.queryBuilder.param("orderby", (Object)(field.getFieldName() + orderingDirection));
            return this;
        }

        @SafeVarargs
        public final WorkCenterCapacityFluentHelper select(EntityField<?, WorkCenterCapacity> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public WorkCenterCapacityFluentHelper top(Number top) {
            this.queryBuilder.top(top);
            return this;
        }

        public WorkCenterCapacityFluentHelper skip(Number skip) {
            this.queryBuilder.skip(skip);
            return this;
        }

        public WorkCenterCapacityFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.errorHandler(this.errorResultHandler).build();
        }

        public List<WorkCenterCapacity> execute(ErpConfigContext erpConfigContext) throws ODataException {
            List entityList = this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).asList(WorkCenterCapacity.class);
            for (WorkCenterCapacity entity : entityList) {
                entity.setErpConfigContext(erpConfigContext);
            }
            return entityList;
        }
    }

    public static class WorkCenterCapacityByKeyFluentHelper {
        private ODataQueryBuilder queryBuilder;
        private ErrorResultHandler<?> errorResultHandler;
        private List<Object> values = new LinkedList<Object>();

        public WorkCenterCapacityByKeyFluentHelper(String capacityInternalID) {
            this.values.add(capacityInternalID);
            this.queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_WORK_CENTERS", (String)"A_WorkCenterCapacity");
            HashMap<String, Object> keys = new HashMap<String, Object>();
            keys.put("CapacityInternalID", this.values.get(0));
            this.queryBuilder.keys(keys);
        }

        @SafeVarargs
        public final WorkCenterCapacityByKeyFluentHelper select(EntityField<?, WorkCenterCapacity> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.build();
        }

        public WorkCenterCapacityByKeyFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public WorkCenterCapacity execute(ErpConfigContext erpConfigContext) throws ODataException {
            WorkCenterCapacity entity = (WorkCenterCapacity)this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).as(WorkCenterCapacity.class);
            entity.setErpConfigContext(erpConfigContext);
            return entity;
        }
    }

    public static class WorkCenterCapacity {
        @ElementName(value="CapacityInternalID")
        private String capacityInternalID;
        public static EntityField<String, WorkCenterCapacity> CAPACITY_INTERNAL_I_D = new EntityField("CapacityInternalID");
        @ElementName(value="CapacityResponsiblePlanner")
        private String capacityResponsiblePlanner;
        public static EntityField<String, WorkCenterCapacity> CAPACITY_RESPONSIBLE_PLANNER = new EntityField("CapacityResponsiblePlanner");
        @ElementName(value="CapacityPlanUtilizationPercent")
        private String capacityPlanUtilizationPercent;
        public static EntityField<String, WorkCenterCapacity> CAPACITY_PLAN_UTILIZATION_PERCENT = new EntityField("CapacityPlanUtilizationPercent");
        @ElementName(value="CapacityBreakDuration")
        private Integer capacityBreakDuration;
        public static EntityField<Integer, WorkCenterCapacity> CAPACITY_BREAK_DURATION = new EntityField("CapacityBreakDuration");
        @ElementName(value="Plant")
        private String plant;
        public static EntityField<String, WorkCenterCapacity> PLANT = new EntityField("Plant");
        @ElementName(value="FactoryCalendar")
        private String factoryCalendar;
        public static EntityField<String, WorkCenterCapacity> FACTORY_CALENDAR = new EntityField("FactoryCalendar");
        @ElementName(value="AuthorizationGroup")
        private String authorizationGroup;
        public static EntityField<String, WorkCenterCapacity> AUTHORIZATION_GROUP = new EntityField("AuthorizationGroup");
        @ElementName(value="ShiftGroup")
        private String shiftGroup;
        public static EntityField<String, WorkCenterCapacity> SHIFT_GROUP = new EntityField("ShiftGroup");
        @ElementName(value="CapacityStartTime")
        private Integer capacityStartTime;
        public static EntityField<Integer, WorkCenterCapacity> CAPACITY_START_TIME = new EntityField("CapacityStartTime");
        @ElementName(value="CapacityEndTime")
        private Integer capacityEndTime;
        public static EntityField<Integer, WorkCenterCapacity> CAPACITY_END_TIME = new EntityField("CapacityEndTime");
        @ElementName(value="CapacityQuantityUnit")
        private String capacityQuantityUnit;
        public static EntityField<String, WorkCenterCapacity> CAPACITY_QUANTITY_UNIT = new EntityField("CapacityQuantityUnit");
        @ElementName(value="Capacity")
        private String capacity;
        public static EntityField<String, WorkCenterCapacity> CAPACITY = new EntityField("Capacity");
        @ElementName(value="CapacityBaseQtyUnit")
        private String capacityBaseQtyUnit;
        public static EntityField<String, WorkCenterCapacity> CAPACITY_BASE_QTY_UNIT = new EntityField("CapacityBaseQtyUnit");
        @ElementName(value="CapacityCategoryCode")
        private String capacityCategoryCode;
        public static EntityField<String, WorkCenterCapacity> CAPACITY_CATEGORY_CODE = new EntityField("CapacityCategoryCode");
        @ElementName(value="CapacityActiveVersion")
        private String capacityActiveVersion;
        public static EntityField<String, WorkCenterCapacity> CAPACITY_ACTIVE_VERSION = new EntityField("CapacityActiveVersion");
        @ElementName(value="CapacityIsFinite")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean capacityIsFinite;
        public static EntityField<Boolean, WorkCenterCapacity> CAPACITY_IS_FINITE = new EntityField("CapacityIsFinite");
        @ElementName(value="CapacityIsPooled")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean capacityIsPooled;
        public static EntityField<Boolean, WorkCenterCapacity> CAPACITY_IS_POOLED = new EntityField("CapacityIsPooled");
        @ElementName(value="CapacityHasIndivCapacities")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean capacityHasIndivCapacities;
        public static EntityField<Boolean, WorkCenterCapacity> CAPACITY_HAS_INDIV_CAPACITIES = new EntityField("CapacityHasIndivCapacities");
        @ElementName(value="CapacityIsExcldFrmLongTermPlng")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean capacityIsExcldFrmLongTermPlng;
        public static EntityField<Boolean, WorkCenterCapacity> CAPACITY_IS_EXCLD_FRM_LONG_TERM_PLNG = new EntityField("CapacityIsExcldFrmLongTermPlng");
        @ElementName(value="CapacityNumberOfCapacities")
        private Short capacityNumberOfCapacities;
        public static EntityField<Short, WorkCenterCapacity> CAPACITY_NUMBER_OF_CAPACITIES = new EntityField("CapacityNumberOfCapacities");
        private static final transient String ODATA_ENDPOINT_URL = "/sap/opu/odata/sap/API_WORK_CENTERS";
        private static final transient String ODATA_ENTITY_COLLECTION = "A_WorkCenterCapacity";
        private transient ErpConfigContext erpConfigContext;

        public String toString() {
            return "ReadWorkCenterDataNamespace.WorkCenterCapacity(capacityInternalID=" + this.capacityInternalID + ", capacityResponsiblePlanner=" + this.capacityResponsiblePlanner + ", capacityPlanUtilizationPercent=" + this.capacityPlanUtilizationPercent + ", capacityBreakDuration=" + this.capacityBreakDuration + ", plant=" + this.plant + ", factoryCalendar=" + this.factoryCalendar + ", authorizationGroup=" + this.authorizationGroup + ", shiftGroup=" + this.shiftGroup + ", capacityStartTime=" + this.capacityStartTime + ", capacityEndTime=" + this.capacityEndTime + ", capacityQuantityUnit=" + this.capacityQuantityUnit + ", capacity=" + this.capacity + ", capacityBaseQtyUnit=" + this.capacityBaseQtyUnit + ", capacityCategoryCode=" + this.capacityCategoryCode + ", capacityActiveVersion=" + this.capacityActiveVersion + ", capacityIsFinite=" + this.capacityIsFinite + ", capacityIsPooled=" + this.capacityIsPooled + ", capacityHasIndivCapacities=" + this.capacityHasIndivCapacities + ", capacityIsExcldFrmLongTermPlng=" + this.capacityIsExcldFrmLongTermPlng + ", capacityNumberOfCapacities=" + this.capacityNumberOfCapacities + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WorkCenterCapacity)) {
                return false;
            }
            WorkCenterCapacity other = (WorkCenterCapacity)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$capacityInternalID = this.capacityInternalID;
            String other$capacityInternalID = other.capacityInternalID;
            if (this$capacityInternalID == null ? other$capacityInternalID != null : !this$capacityInternalID.equals(other$capacityInternalID)) {
                return false;
            }
            String this$capacityResponsiblePlanner = this.capacityResponsiblePlanner;
            String other$capacityResponsiblePlanner = other.capacityResponsiblePlanner;
            if (this$capacityResponsiblePlanner == null ? other$capacityResponsiblePlanner != null : !this$capacityResponsiblePlanner.equals(other$capacityResponsiblePlanner)) {
                return false;
            }
            String this$capacityPlanUtilizationPercent = this.capacityPlanUtilizationPercent;
            String other$capacityPlanUtilizationPercent = other.capacityPlanUtilizationPercent;
            if (this$capacityPlanUtilizationPercent == null ? other$capacityPlanUtilizationPercent != null : !this$capacityPlanUtilizationPercent.equals(other$capacityPlanUtilizationPercent)) {
                return false;
            }
            Integer this$capacityBreakDuration = this.capacityBreakDuration;
            Integer other$capacityBreakDuration = other.capacityBreakDuration;
            if (this$capacityBreakDuration == null ? other$capacityBreakDuration != null : !((Object)this$capacityBreakDuration).equals(other$capacityBreakDuration)) {
                return false;
            }
            String this$plant = this.plant;
            String other$plant = other.plant;
            if (this$plant == null ? other$plant != null : !this$plant.equals(other$plant)) {
                return false;
            }
            String this$factoryCalendar = this.factoryCalendar;
            String other$factoryCalendar = other.factoryCalendar;
            if (this$factoryCalendar == null ? other$factoryCalendar != null : !this$factoryCalendar.equals(other$factoryCalendar)) {
                return false;
            }
            String this$authorizationGroup = this.authorizationGroup;
            String other$authorizationGroup = other.authorizationGroup;
            if (this$authorizationGroup == null ? other$authorizationGroup != null : !this$authorizationGroup.equals(other$authorizationGroup)) {
                return false;
            }
            String this$shiftGroup = this.shiftGroup;
            String other$shiftGroup = other.shiftGroup;
            if (this$shiftGroup == null ? other$shiftGroup != null : !this$shiftGroup.equals(other$shiftGroup)) {
                return false;
            }
            Integer this$capacityStartTime = this.capacityStartTime;
            Integer other$capacityStartTime = other.capacityStartTime;
            if (this$capacityStartTime == null ? other$capacityStartTime != null : !((Object)this$capacityStartTime).equals(other$capacityStartTime)) {
                return false;
            }
            Integer this$capacityEndTime = this.capacityEndTime;
            Integer other$capacityEndTime = other.capacityEndTime;
            if (this$capacityEndTime == null ? other$capacityEndTime != null : !((Object)this$capacityEndTime).equals(other$capacityEndTime)) {
                return false;
            }
            String this$capacityQuantityUnit = this.capacityQuantityUnit;
            String other$capacityQuantityUnit = other.capacityQuantityUnit;
            if (this$capacityQuantityUnit == null ? other$capacityQuantityUnit != null : !this$capacityQuantityUnit.equals(other$capacityQuantityUnit)) {
                return false;
            }
            String this$capacity = this.capacity;
            String other$capacity = other.capacity;
            if (this$capacity == null ? other$capacity != null : !this$capacity.equals(other$capacity)) {
                return false;
            }
            String this$capacityBaseQtyUnit = this.capacityBaseQtyUnit;
            String other$capacityBaseQtyUnit = other.capacityBaseQtyUnit;
            if (this$capacityBaseQtyUnit == null ? other$capacityBaseQtyUnit != null : !this$capacityBaseQtyUnit.equals(other$capacityBaseQtyUnit)) {
                return false;
            }
            String this$capacityCategoryCode = this.capacityCategoryCode;
            String other$capacityCategoryCode = other.capacityCategoryCode;
            if (this$capacityCategoryCode == null ? other$capacityCategoryCode != null : !this$capacityCategoryCode.equals(other$capacityCategoryCode)) {
                return false;
            }
            String this$capacityActiveVersion = this.capacityActiveVersion;
            String other$capacityActiveVersion = other.capacityActiveVersion;
            if (this$capacityActiveVersion == null ? other$capacityActiveVersion != null : !this$capacityActiveVersion.equals(other$capacityActiveVersion)) {
                return false;
            }
            Boolean this$capacityIsFinite = this.capacityIsFinite;
            Boolean other$capacityIsFinite = other.capacityIsFinite;
            if (this$capacityIsFinite == null ? other$capacityIsFinite != null : !((Object)this$capacityIsFinite).equals(other$capacityIsFinite)) {
                return false;
            }
            Boolean this$capacityIsPooled = this.capacityIsPooled;
            Boolean other$capacityIsPooled = other.capacityIsPooled;
            if (this$capacityIsPooled == null ? other$capacityIsPooled != null : !((Object)this$capacityIsPooled).equals(other$capacityIsPooled)) {
                return false;
            }
            Boolean this$capacityHasIndivCapacities = this.capacityHasIndivCapacities;
            Boolean other$capacityHasIndivCapacities = other.capacityHasIndivCapacities;
            if (this$capacityHasIndivCapacities == null ? other$capacityHasIndivCapacities != null : !((Object)this$capacityHasIndivCapacities).equals(other$capacityHasIndivCapacities)) {
                return false;
            }
            Boolean this$capacityIsExcldFrmLongTermPlng = this.capacityIsExcldFrmLongTermPlng;
            Boolean other$capacityIsExcldFrmLongTermPlng = other.capacityIsExcldFrmLongTermPlng;
            if (this$capacityIsExcldFrmLongTermPlng == null ? other$capacityIsExcldFrmLongTermPlng != null : !((Object)this$capacityIsExcldFrmLongTermPlng).equals(other$capacityIsExcldFrmLongTermPlng)) {
                return false;
            }
            Short this$capacityNumberOfCapacities = this.capacityNumberOfCapacities;
            Short other$capacityNumberOfCapacities = other.capacityNumberOfCapacities;
            return !(this$capacityNumberOfCapacities == null ? other$capacityNumberOfCapacities != null : !((Object)this$capacityNumberOfCapacities).equals(other$capacityNumberOfCapacities));
        }

        protected boolean canEqual(Object other) {
            return other instanceof WorkCenterCapacity;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $capacityInternalID = this.capacityInternalID;
            result = result * 59 + ($capacityInternalID == null ? 43 : $capacityInternalID.hashCode());
            String $capacityResponsiblePlanner = this.capacityResponsiblePlanner;
            result = result * 59 + ($capacityResponsiblePlanner == null ? 43 : $capacityResponsiblePlanner.hashCode());
            String $capacityPlanUtilizationPercent = this.capacityPlanUtilizationPercent;
            result = result * 59 + ($capacityPlanUtilizationPercent == null ? 43 : $capacityPlanUtilizationPercent.hashCode());
            Integer $capacityBreakDuration = this.capacityBreakDuration;
            result = result * 59 + ($capacityBreakDuration == null ? 43 : ((Object)$capacityBreakDuration).hashCode());
            String $plant = this.plant;
            result = result * 59 + ($plant == null ? 43 : $plant.hashCode());
            String $factoryCalendar = this.factoryCalendar;
            result = result * 59 + ($factoryCalendar == null ? 43 : $factoryCalendar.hashCode());
            String $authorizationGroup = this.authorizationGroup;
            result = result * 59 + ($authorizationGroup == null ? 43 : $authorizationGroup.hashCode());
            String $shiftGroup = this.shiftGroup;
            result = result * 59 + ($shiftGroup == null ? 43 : $shiftGroup.hashCode());
            Integer $capacityStartTime = this.capacityStartTime;
            result = result * 59 + ($capacityStartTime == null ? 43 : ((Object)$capacityStartTime).hashCode());
            Integer $capacityEndTime = this.capacityEndTime;
            result = result * 59 + ($capacityEndTime == null ? 43 : ((Object)$capacityEndTime).hashCode());
            String $capacityQuantityUnit = this.capacityQuantityUnit;
            result = result * 59 + ($capacityQuantityUnit == null ? 43 : $capacityQuantityUnit.hashCode());
            String $capacity = this.capacity;
            result = result * 59 + ($capacity == null ? 43 : $capacity.hashCode());
            String $capacityBaseQtyUnit = this.capacityBaseQtyUnit;
            result = result * 59 + ($capacityBaseQtyUnit == null ? 43 : $capacityBaseQtyUnit.hashCode());
            String $capacityCategoryCode = this.capacityCategoryCode;
            result = result * 59 + ($capacityCategoryCode == null ? 43 : $capacityCategoryCode.hashCode());
            String $capacityActiveVersion = this.capacityActiveVersion;
            result = result * 59 + ($capacityActiveVersion == null ? 43 : $capacityActiveVersion.hashCode());
            Boolean $capacityIsFinite = this.capacityIsFinite;
            result = result * 59 + ($capacityIsFinite == null ? 43 : ((Object)$capacityIsFinite).hashCode());
            Boolean $capacityIsPooled = this.capacityIsPooled;
            result = result * 59 + ($capacityIsPooled == null ? 43 : ((Object)$capacityIsPooled).hashCode());
            Boolean $capacityHasIndivCapacities = this.capacityHasIndivCapacities;
            result = result * 59 + ($capacityHasIndivCapacities == null ? 43 : ((Object)$capacityHasIndivCapacities).hashCode());
            Boolean $capacityIsExcldFrmLongTermPlng = this.capacityIsExcldFrmLongTermPlng;
            result = result * 59 + ($capacityIsExcldFrmLongTermPlng == null ? 43 : ((Object)$capacityIsExcldFrmLongTermPlng).hashCode());
            Short $capacityNumberOfCapacities = this.capacityNumberOfCapacities;
            result = result * 59 + ($capacityNumberOfCapacities == null ? 43 : ((Object)$capacityNumberOfCapacities).hashCode());
            return result;
        }

        public String getCapacityInternalID() {
            return this.capacityInternalID;
        }

        public WorkCenterCapacity setCapacityInternalID(String capacityInternalID) {
            this.capacityInternalID = capacityInternalID;
            return this;
        }

        public String getCapacityResponsiblePlanner() {
            return this.capacityResponsiblePlanner;
        }

        public WorkCenterCapacity setCapacityResponsiblePlanner(String capacityResponsiblePlanner) {
            this.capacityResponsiblePlanner = capacityResponsiblePlanner;
            return this;
        }

        public String getCapacityPlanUtilizationPercent() {
            return this.capacityPlanUtilizationPercent;
        }

        public WorkCenterCapacity setCapacityPlanUtilizationPercent(String capacityPlanUtilizationPercent) {
            this.capacityPlanUtilizationPercent = capacityPlanUtilizationPercent;
            return this;
        }

        public Integer getCapacityBreakDuration() {
            return this.capacityBreakDuration;
        }

        public WorkCenterCapacity setCapacityBreakDuration(Integer capacityBreakDuration) {
            this.capacityBreakDuration = capacityBreakDuration;
            return this;
        }

        public String getPlant() {
            return this.plant;
        }

        public WorkCenterCapacity setPlant(String plant) {
            this.plant = plant;
            return this;
        }

        public String getFactoryCalendar() {
            return this.factoryCalendar;
        }

        public WorkCenterCapacity setFactoryCalendar(String factoryCalendar) {
            this.factoryCalendar = factoryCalendar;
            return this;
        }

        public String getAuthorizationGroup() {
            return this.authorizationGroup;
        }

        public WorkCenterCapacity setAuthorizationGroup(String authorizationGroup) {
            this.authorizationGroup = authorizationGroup;
            return this;
        }

        public String getShiftGroup() {
            return this.shiftGroup;
        }

        public WorkCenterCapacity setShiftGroup(String shiftGroup) {
            this.shiftGroup = shiftGroup;
            return this;
        }

        public Integer getCapacityStartTime() {
            return this.capacityStartTime;
        }

        public WorkCenterCapacity setCapacityStartTime(Integer capacityStartTime) {
            this.capacityStartTime = capacityStartTime;
            return this;
        }

        public Integer getCapacityEndTime() {
            return this.capacityEndTime;
        }

        public WorkCenterCapacity setCapacityEndTime(Integer capacityEndTime) {
            this.capacityEndTime = capacityEndTime;
            return this;
        }

        public String getCapacityQuantityUnit() {
            return this.capacityQuantityUnit;
        }

        public WorkCenterCapacity setCapacityQuantityUnit(String capacityQuantityUnit) {
            this.capacityQuantityUnit = capacityQuantityUnit;
            return this;
        }

        public String getCapacity() {
            return this.capacity;
        }

        public WorkCenterCapacity setCapacity(String capacity) {
            this.capacity = capacity;
            return this;
        }

        public String getCapacityBaseQtyUnit() {
            return this.capacityBaseQtyUnit;
        }

        public WorkCenterCapacity setCapacityBaseQtyUnit(String capacityBaseQtyUnit) {
            this.capacityBaseQtyUnit = capacityBaseQtyUnit;
            return this;
        }

        public String getCapacityCategoryCode() {
            return this.capacityCategoryCode;
        }

        public WorkCenterCapacity setCapacityCategoryCode(String capacityCategoryCode) {
            this.capacityCategoryCode = capacityCategoryCode;
            return this;
        }

        public String getCapacityActiveVersion() {
            return this.capacityActiveVersion;
        }

        public WorkCenterCapacity setCapacityActiveVersion(String capacityActiveVersion) {
            this.capacityActiveVersion = capacityActiveVersion;
            return this;
        }

        public Boolean getCapacityIsFinite() {
            return this.capacityIsFinite;
        }

        public WorkCenterCapacity setCapacityIsFinite(Boolean capacityIsFinite) {
            this.capacityIsFinite = capacityIsFinite;
            return this;
        }

        public Boolean getCapacityIsPooled() {
            return this.capacityIsPooled;
        }

        public WorkCenterCapacity setCapacityIsPooled(Boolean capacityIsPooled) {
            this.capacityIsPooled = capacityIsPooled;
            return this;
        }

        public Boolean getCapacityHasIndivCapacities() {
            return this.capacityHasIndivCapacities;
        }

        public WorkCenterCapacity setCapacityHasIndivCapacities(Boolean capacityHasIndivCapacities) {
            this.capacityHasIndivCapacities = capacityHasIndivCapacities;
            return this;
        }

        public Boolean getCapacityIsExcldFrmLongTermPlng() {
            return this.capacityIsExcldFrmLongTermPlng;
        }

        public WorkCenterCapacity setCapacityIsExcldFrmLongTermPlng(Boolean capacityIsExcldFrmLongTermPlng) {
            this.capacityIsExcldFrmLongTermPlng = capacityIsExcldFrmLongTermPlng;
            return this;
        }

        public Short getCapacityNumberOfCapacities() {
            return this.capacityNumberOfCapacities;
        }

        public WorkCenterCapacity setCapacityNumberOfCapacities(Short capacityNumberOfCapacities) {
            this.capacityNumberOfCapacities = capacityNumberOfCapacities;
            return this;
        }

        public WorkCenterCapacity setErpConfigContext(ErpConfigContext erpConfigContext) {
            this.erpConfigContext = erpConfigContext;
            return this;
        }
    }
}

