/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.cloudplatform.connectivity.WithDestinationName;
import com.sap.cloud.sdk.odatav2.connectivity.ErrorResultHandler;
import com.sap.cloud.sdk.odatav2.connectivity.FilterExpression;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQuery;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQueryBuilder;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQueryResult;
import com.sap.cloud.sdk.odatav2.connectivity.ODataType;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.connectivity.ErpConfigContext;
import com.sap.cloud.sdk.s4hana.connectivity.ErpEndpoint;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.EntityField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ExpressionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.FilterExpressionWrapper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ODataBooleanAdapter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ODataCalendarAdapter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ODataTypeValueSerializer;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ODataVdmErrorResultHandler;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.Order;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public class ReadProcessOrdersNamespace {

    public static class ProcessOrderStatusFluentHelper {
        private ODataQueryBuilder queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_PROCESS_ORDERS", (String)"A_ProcessOrderStatus");
        private ErrorResultHandler<?> errorResultHandler = new ODataVdmErrorResultHandler();

        public ProcessOrderStatusFluentHelper filter(ExpressionFluentHelper<ProcessOrderStatus> expression) {
            for (FilterExpressionWrapper<?> filterExpressionWrapper : expression.evaluate()) {
                Object comparisonValue = filterExpressionWrapper.getComparisonValue();
                if (comparisonValue instanceof Integer) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Integer)((Integer)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof String) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((String)((String)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Long) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Long)((Long)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Double) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Double)((Double)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Float) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Float)((Float)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDate) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDate)((LocalDate)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDateTime)((LocalDateTime)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Date) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Date)((Date)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof DateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((DateTime)((DateTime)comparisonValue))));
                    continue;
                }
                this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of(comparisonValue)));
            }
            return this;
        }

        public ProcessOrderStatusFluentHelper orderBy(EntityField<?, ProcessOrderStatus> field, Order order) {
            String orderingDirection = order == Order.ASC ? " asc" : " desc";
            this.queryBuilder.param("orderby", (Object)(field.getFieldName() + orderingDirection));
            return this;
        }

        @SafeVarargs
        public final ProcessOrderStatusFluentHelper select(EntityField<?, ProcessOrderStatus> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public ProcessOrderStatusFluentHelper top(Number top) {
            this.queryBuilder.top(top);
            return this;
        }

        public ProcessOrderStatusFluentHelper skip(Number skip) {
            this.queryBuilder.skip(skip);
            return this;
        }

        public ProcessOrderStatusFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.errorHandler(this.errorResultHandler).build();
        }

        public List<ProcessOrderStatus> execute(ErpConfigContext erpConfigContext) throws ODataException {
            List entityList = this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).asList(ProcessOrderStatus.class);
            for (ProcessOrderStatus entity : entityList) {
                entity.setErpConfigContext(erpConfigContext);
            }
            return entityList;
        }
    }

    public static class ProcessOrderStatusByKeyFluentHelper {
        private ODataQueryBuilder queryBuilder;
        private ErrorResultHandler<?> errorResultHandler;
        private List<Object> values = new LinkedList<Object>();

        public ProcessOrderStatusByKeyFluentHelper(String manufacturingOrder, String statusCode) {
            this.values.add(manufacturingOrder);
            this.values.add(statusCode);
            this.queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_PROCESS_ORDERS", (String)"A_ProcessOrderStatus");
            HashMap<String, Object> keys = new HashMap<String, Object>();
            keys.put("ManufacturingOrder", this.values.get(0));
            keys.put("StatusCode", this.values.get(1));
            this.queryBuilder.keys(keys);
        }

        @SafeVarargs
        public final ProcessOrderStatusByKeyFluentHelper select(EntityField<?, ProcessOrderStatus> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.build();
        }

        public ProcessOrderStatusByKeyFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public ProcessOrderStatus execute(ErpConfigContext erpConfigContext) throws ODataException {
            ProcessOrderStatus entity = (ProcessOrderStatus)this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).as(ProcessOrderStatus.class);
            entity.setErpConfigContext(erpConfigContext);
            return entity;
        }
    }

    public static class ProcessOrderStatus {
        @ElementName(value="ManufacturingOrder")
        private String manufacturingOrder;
        public static EntityField<String, ProcessOrderStatus> MANUFACTURING_ORDER = new EntityField("ManufacturingOrder");
        @ElementName(value="StatusCode")
        private String statusCode;
        public static EntityField<String, ProcessOrderStatus> STATUS_CODE = new EntityField("StatusCode");
        @ElementName(value="IsUserStatus")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean isUserStatus;
        public static EntityField<Boolean, ProcessOrderStatus> IS_USER_STATUS = new EntityField("IsUserStatus");
        @ElementName(value="StatusShortName")
        private String statusShortName;
        public static EntityField<String, ProcessOrderStatus> STATUS_SHORT_NAME = new EntityField("StatusShortName");
        @ElementName(value="StatusName")
        private String statusName;
        public static EntityField<String, ProcessOrderStatus> STATUS_NAME = new EntityField("StatusName");
        private static final transient String ODATA_ENDPOINT_URL = "/sap/opu/odata/sap/API_PROCESS_ORDERS";
        private static final transient String ODATA_ENTITY_COLLECTION = "A_ProcessOrderStatus";
        private transient ErpConfigContext erpConfigContext;

        public String toString() {
            return "ReadProcessOrdersNamespace.ProcessOrderStatus(manufacturingOrder=" + this.manufacturingOrder + ", statusCode=" + this.statusCode + ", isUserStatus=" + this.isUserStatus + ", statusShortName=" + this.statusShortName + ", statusName=" + this.statusName + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProcessOrderStatus)) {
                return false;
            }
            ProcessOrderStatus other = (ProcessOrderStatus)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$manufacturingOrder = this.manufacturingOrder;
            String other$manufacturingOrder = other.manufacturingOrder;
            if (this$manufacturingOrder == null ? other$manufacturingOrder != null : !this$manufacturingOrder.equals(other$manufacturingOrder)) {
                return false;
            }
            String this$statusCode = this.statusCode;
            String other$statusCode = other.statusCode;
            if (this$statusCode == null ? other$statusCode != null : !this$statusCode.equals(other$statusCode)) {
                return false;
            }
            Boolean this$isUserStatus = this.isUserStatus;
            Boolean other$isUserStatus = other.isUserStatus;
            if (this$isUserStatus == null ? other$isUserStatus != null : !((Object)this$isUserStatus).equals(other$isUserStatus)) {
                return false;
            }
            String this$statusShortName = this.statusShortName;
            String other$statusShortName = other.statusShortName;
            if (this$statusShortName == null ? other$statusShortName != null : !this$statusShortName.equals(other$statusShortName)) {
                return false;
            }
            String this$statusName = this.statusName;
            String other$statusName = other.statusName;
            return !(this$statusName == null ? other$statusName != null : !this$statusName.equals(other$statusName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ProcessOrderStatus;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $manufacturingOrder = this.manufacturingOrder;
            result = result * 59 + ($manufacturingOrder == null ? 43 : $manufacturingOrder.hashCode());
            String $statusCode = this.statusCode;
            result = result * 59 + ($statusCode == null ? 43 : $statusCode.hashCode());
            Boolean $isUserStatus = this.isUserStatus;
            result = result * 59 + ($isUserStatus == null ? 43 : ((Object)$isUserStatus).hashCode());
            String $statusShortName = this.statusShortName;
            result = result * 59 + ($statusShortName == null ? 43 : $statusShortName.hashCode());
            String $statusName = this.statusName;
            result = result * 59 + ($statusName == null ? 43 : $statusName.hashCode());
            return result;
        }

        public String getManufacturingOrder() {
            return this.manufacturingOrder;
        }

        public ProcessOrderStatus setManufacturingOrder(String manufacturingOrder) {
            this.manufacturingOrder = manufacturingOrder;
            return this;
        }

        public String getStatusCode() {
            return this.statusCode;
        }

        public ProcessOrderStatus setStatusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Boolean getIsUserStatus() {
            return this.isUserStatus;
        }

        public ProcessOrderStatus setIsUserStatus(Boolean isUserStatus) {
            this.isUserStatus = isUserStatus;
            return this;
        }

        public String getStatusShortName() {
            return this.statusShortName;
        }

        public ProcessOrderStatus setStatusShortName(String statusShortName) {
            this.statusShortName = statusShortName;
            return this;
        }

        public String getStatusName() {
            return this.statusName;
        }

        public ProcessOrderStatus setStatusName(String statusName) {
            this.statusName = statusName;
            return this;
        }

        public ProcessOrderStatus setErpConfigContext(ErpConfigContext erpConfigContext) {
            this.erpConfigContext = erpConfigContext;
            return this;
        }
    }

    public static class ProcessOrderOperationFluentHelper {
        private ODataQueryBuilder queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_PROCESS_ORDERS", (String)"A_ProcessOrderOperation");
        private ErrorResultHandler<?> errorResultHandler = new ODataVdmErrorResultHandler();

        public ProcessOrderOperationFluentHelper filter(ExpressionFluentHelper<ProcessOrderOperation> expression) {
            for (FilterExpressionWrapper<?> filterExpressionWrapper : expression.evaluate()) {
                Object comparisonValue = filterExpressionWrapper.getComparisonValue();
                if (comparisonValue instanceof Integer) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Integer)((Integer)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof String) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((String)((String)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Long) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Long)((Long)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Double) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Double)((Double)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Float) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Float)((Float)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDate) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDate)((LocalDate)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDateTime)((LocalDateTime)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Date) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Date)((Date)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof DateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((DateTime)((DateTime)comparisonValue))));
                    continue;
                }
                this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of(comparisonValue)));
            }
            return this;
        }

        public ProcessOrderOperationFluentHelper orderBy(EntityField<?, ProcessOrderOperation> field, Order order) {
            String orderingDirection = order == Order.ASC ? " asc" : " desc";
            this.queryBuilder.param("orderby", (Object)(field.getFieldName() + orderingDirection));
            return this;
        }

        @SafeVarargs
        public final ProcessOrderOperationFluentHelper select(EntityField<?, ProcessOrderOperation> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public ProcessOrderOperationFluentHelper top(Number top) {
            this.queryBuilder.top(top);
            return this;
        }

        public ProcessOrderOperationFluentHelper skip(Number skip) {
            this.queryBuilder.skip(skip);
            return this;
        }

        public ProcessOrderOperationFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.errorHandler(this.errorResultHandler).build();
        }

        public List<ProcessOrderOperation> execute(ErpConfigContext erpConfigContext) throws ODataException {
            List entityList = this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).asList(ProcessOrderOperation.class);
            for (ProcessOrderOperation entity : entityList) {
                entity.setErpConfigContext(erpConfigContext);
            }
            return entityList;
        }
    }

    public static class ProcessOrderOperationByKeyFluentHelper {
        private ODataQueryBuilder queryBuilder;
        private ErrorResultHandler<?> errorResultHandler;
        private List<Object> values = new LinkedList<Object>();

        public ProcessOrderOperationByKeyFluentHelper(String orderInternalBillOfOperations, String orderIntBillOfOperationsItem) {
            this.values.add(orderInternalBillOfOperations);
            this.values.add(orderIntBillOfOperationsItem);
            this.queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_PROCESS_ORDERS", (String)"A_ProcessOrderOperation");
            HashMap<String, Object> keys = new HashMap<String, Object>();
            keys.put("OrderInternalBillOfOperations", this.values.get(0));
            keys.put("OrderIntBillOfOperationsItem", this.values.get(1));
            this.queryBuilder.keys(keys);
        }

        @SafeVarargs
        public final ProcessOrderOperationByKeyFluentHelper select(EntityField<?, ProcessOrderOperation> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.build();
        }

        public ProcessOrderOperationByKeyFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public ProcessOrderOperation execute(ErpConfigContext erpConfigContext) throws ODataException {
            ProcessOrderOperation entity = (ProcessOrderOperation)this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).as(ProcessOrderOperation.class);
            entity.setErpConfigContext(erpConfigContext);
            return entity;
        }
    }

    public static class ProcessOrderOperation {
        @ElementName(value="OrderInternalBillOfOperations")
        private String orderInternalBillOfOperations;
        public static EntityField<String, ProcessOrderOperation> ORDER_INTERNAL_BILL_OF_OPERATIONS = new EntityField("OrderInternalBillOfOperations");
        @ElementName(value="BusinessProcessEntryUnit")
        private String businessProcessEntryUnit;
        public static EntityField<String, ProcessOrderOperation> BUSINESS_PROCESS_ENTRY_UNIT = new EntityField("BusinessProcessEntryUnit");
        @ElementName(value="ManufacturingOrderCategory")
        private String manufacturingOrderCategory;
        public static EntityField<String, ProcessOrderOperation> MANUFACTURING_ORDER_CATEGORY = new EntityField("ManufacturingOrderCategory");
        @ElementName(value="WorkCenterTypeCode")
        private String workCenterTypeCode;
        public static EntityField<String, ProcessOrderOperation> WORK_CENTER_TYPE_CODE = new EntityField("WorkCenterTypeCode");
        @ElementName(value="WorkCenter")
        private String workCenter;
        public static EntityField<String, ProcessOrderOperation> WORK_CENTER = new EntityField("WorkCenter");
        @ElementName(value="OpErlstSchedldExecStrtDte")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar opErlstSchedldExecStrtDte;
        public static EntityField<Calendar, ProcessOrderOperation> OP_ERLST_SCHEDLD_EXEC_STRT_DTE = new EntityField("OpErlstSchedldExecStrtDte");
        @ElementName(value="OpErlstSchedldExecStrtTme")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar opErlstSchedldExecStrtTme;
        public static EntityField<Calendar, ProcessOrderOperation> OP_ERLST_SCHEDLD_EXEC_STRT_TME = new EntityField("OpErlstSchedldExecStrtTme");
        @ElementName(value="OpErlstSchedldExecEndDte")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar opErlstSchedldExecEndDte;
        public static EntityField<Calendar, ProcessOrderOperation> OP_ERLST_SCHEDLD_EXEC_END_DTE = new EntityField("OpErlstSchedldExecEndDte");
        @ElementName(value="OpErlstSchedldExecEndTme")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar opErlstSchedldExecEndTme;
        public static EntityField<Calendar, ProcessOrderOperation> OP_ERLST_SCHEDLD_EXEC_END_TME = new EntityField("OpErlstSchedldExecEndTme");
        @ElementName(value="OpActualExecutionStartDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar opActualExecutionStartDate;
        public static EntityField<Calendar, ProcessOrderOperation> OP_ACTUAL_EXECUTION_START_DATE = new EntityField("OpActualExecutionStartDate");
        @ElementName(value="OpActualExecutionStartTime")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar opActualExecutionStartTime;
        public static EntityField<Calendar, ProcessOrderOperation> OP_ACTUAL_EXECUTION_START_TIME = new EntityField("OpActualExecutionStartTime");
        @ElementName(value="OrderIntBillOfOperationsItem")
        private String orderIntBillOfOperationsItem;
        public static EntityField<String, ProcessOrderOperation> ORDER_INT_BILL_OF_OPERATIONS_ITEM = new EntityField("OrderIntBillOfOperationsItem");
        @ElementName(value="OpActualExecutionEndDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar opActualExecutionEndDate;
        public static EntityField<Calendar, ProcessOrderOperation> OP_ACTUAL_EXECUTION_END_DATE = new EntityField("OpActualExecutionEndDate");
        @ElementName(value="OpActualExecutionEndTime")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar opActualExecutionEndTime;
        public static EntityField<Calendar, ProcessOrderOperation> OP_ACTUAL_EXECUTION_END_TIME = new EntityField("OpActualExecutionEndTime");
        @ElementName(value="OperationUnit")
        private String operationUnit;
        public static EntityField<String, ProcessOrderOperation> OPERATION_UNIT = new EntityField("OperationUnit");
        @ElementName(value="OpPlannedTotalQuantity")
        private BigDecimal opPlannedTotalQuantity;
        public static EntityField<BigDecimal, ProcessOrderOperation> OP_PLANNED_TOTAL_QUANTITY = new EntityField("OpPlannedTotalQuantity");
        @ElementName(value="ErlstSchedldExecDurnInWorkdays")
        private Integer erlstSchedldExecDurnInWorkdays;
        public static EntityField<Integer, ProcessOrderOperation> ERLST_SCHEDLD_EXEC_DURN_IN_WORKDAYS = new EntityField("ErlstSchedldExecDurnInWorkdays");
        @ElementName(value="OpActualExecutionDays")
        private Integer opActualExecutionDays;
        public static EntityField<Integer, ProcessOrderOperation> OP_ACTUAL_EXECUTION_DAYS = new EntityField("OpActualExecutionDays");
        @ElementName(value="OpTotalConfirmedYieldQty")
        private BigDecimal opTotalConfirmedYieldQty;
        public static EntityField<BigDecimal, ProcessOrderOperation> OP_TOTAL_CONFIRMED_YIELD_QTY = new EntityField("OpTotalConfirmedYieldQty");
        @ElementName(value="WorkCenterInternalID")
        private String workCenterInternalID;
        public static EntityField<String, ProcessOrderOperation> WORK_CENTER_INTERNAL_I_D = new EntityField("WorkCenterInternalID");
        @ElementName(value="ManufacturingOrder")
        private String manufacturingOrder;
        public static EntityField<String, ProcessOrderOperation> MANUFACTURING_ORDER = new EntityField("ManufacturingOrder");
        @ElementName(value="ManufacturingOrderOperation")
        private String manufacturingOrderOperation;
        public static EntityField<String, ProcessOrderOperation> MANUFACTURING_ORDER_OPERATION = new EntityField("ManufacturingOrderOperation");
        @ElementName(value="MfgOrderOperationIsPhase")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean mfgOrderOperationIsPhase;
        public static EntityField<Boolean, ProcessOrderOperation> MFG_ORDER_OPERATION_IS_PHASE = new EntityField("MfgOrderOperationIsPhase");
        @ElementName(value="ManufacturingOrderSequence")
        private String manufacturingOrderSequence;
        public static EntityField<String, ProcessOrderOperation> MANUFACTURING_ORDER_SEQUENCE = new EntityField("ManufacturingOrderSequence");
        @ElementName(value="MfgOrderSequenceText")
        private String mfgOrderSequenceText;
        public static EntityField<String, ProcessOrderOperation> MFG_ORDER_SEQUENCE_TEXT = new EntityField("MfgOrderSequenceText");
        @ElementName(value="MfgOrderOperationText")
        private String mfgOrderOperationText;
        public static EntityField<String, ProcessOrderOperation> MFG_ORDER_OPERATION_TEXT = new EntityField("MfgOrderOperationText");
        @ElementName(value="ManufacturingOrderType")
        private String manufacturingOrderType;
        public static EntityField<String, ProcessOrderOperation> MANUFACTURING_ORDER_TYPE = new EntityField("ManufacturingOrderType");
        private static final transient String ODATA_ENDPOINT_URL = "/sap/opu/odata/sap/API_PROCESS_ORDERS";
        private static final transient String ODATA_ENTITY_COLLECTION = "A_ProcessOrderOperation";
        private transient ErpConfigContext erpConfigContext;

        public String toString() {
            return "ReadProcessOrdersNamespace.ProcessOrderOperation(orderInternalBillOfOperations=" + this.orderInternalBillOfOperations + ", businessProcessEntryUnit=" + this.businessProcessEntryUnit + ", manufacturingOrderCategory=" + this.manufacturingOrderCategory + ", workCenterTypeCode=" + this.workCenterTypeCode + ", workCenter=" + this.workCenter + ", opErlstSchedldExecStrtDte=" + this.opErlstSchedldExecStrtDte + ", opErlstSchedldExecStrtTme=" + this.opErlstSchedldExecStrtTme + ", opErlstSchedldExecEndDte=" + this.opErlstSchedldExecEndDte + ", opErlstSchedldExecEndTme=" + this.opErlstSchedldExecEndTme + ", opActualExecutionStartDate=" + this.opActualExecutionStartDate + ", opActualExecutionStartTime=" + this.opActualExecutionStartTime + ", orderIntBillOfOperationsItem=" + this.orderIntBillOfOperationsItem + ", opActualExecutionEndDate=" + this.opActualExecutionEndDate + ", opActualExecutionEndTime=" + this.opActualExecutionEndTime + ", operationUnit=" + this.operationUnit + ", opPlannedTotalQuantity=" + this.opPlannedTotalQuantity + ", erlstSchedldExecDurnInWorkdays=" + this.erlstSchedldExecDurnInWorkdays + ", opActualExecutionDays=" + this.opActualExecutionDays + ", opTotalConfirmedYieldQty=" + this.opTotalConfirmedYieldQty + ", workCenterInternalID=" + this.workCenterInternalID + ", manufacturingOrder=" + this.manufacturingOrder + ", manufacturingOrderOperation=" + this.manufacturingOrderOperation + ", mfgOrderOperationIsPhase=" + this.mfgOrderOperationIsPhase + ", manufacturingOrderSequence=" + this.manufacturingOrderSequence + ", mfgOrderSequenceText=" + this.mfgOrderSequenceText + ", mfgOrderOperationText=" + this.mfgOrderOperationText + ", manufacturingOrderType=" + this.manufacturingOrderType + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProcessOrderOperation)) {
                return false;
            }
            ProcessOrderOperation other = (ProcessOrderOperation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$orderInternalBillOfOperations = this.orderInternalBillOfOperations;
            String other$orderInternalBillOfOperations = other.orderInternalBillOfOperations;
            if (this$orderInternalBillOfOperations == null ? other$orderInternalBillOfOperations != null : !this$orderInternalBillOfOperations.equals(other$orderInternalBillOfOperations)) {
                return false;
            }
            String this$businessProcessEntryUnit = this.businessProcessEntryUnit;
            String other$businessProcessEntryUnit = other.businessProcessEntryUnit;
            if (this$businessProcessEntryUnit == null ? other$businessProcessEntryUnit != null : !this$businessProcessEntryUnit.equals(other$businessProcessEntryUnit)) {
                return false;
            }
            String this$manufacturingOrderCategory = this.manufacturingOrderCategory;
            String other$manufacturingOrderCategory = other.manufacturingOrderCategory;
            if (this$manufacturingOrderCategory == null ? other$manufacturingOrderCategory != null : !this$manufacturingOrderCategory.equals(other$manufacturingOrderCategory)) {
                return false;
            }
            String this$workCenterTypeCode = this.workCenterTypeCode;
            String other$workCenterTypeCode = other.workCenterTypeCode;
            if (this$workCenterTypeCode == null ? other$workCenterTypeCode != null : !this$workCenterTypeCode.equals(other$workCenterTypeCode)) {
                return false;
            }
            String this$workCenter = this.workCenter;
            String other$workCenter = other.workCenter;
            if (this$workCenter == null ? other$workCenter != null : !this$workCenter.equals(other$workCenter)) {
                return false;
            }
            Calendar this$opErlstSchedldExecStrtDte = this.opErlstSchedldExecStrtDte;
            Calendar other$opErlstSchedldExecStrtDte = other.opErlstSchedldExecStrtDte;
            if (this$opErlstSchedldExecStrtDte == null ? other$opErlstSchedldExecStrtDte != null : !((Object)this$opErlstSchedldExecStrtDte).equals(other$opErlstSchedldExecStrtDte)) {
                return false;
            }
            Calendar this$opErlstSchedldExecStrtTme = this.opErlstSchedldExecStrtTme;
            Calendar other$opErlstSchedldExecStrtTme = other.opErlstSchedldExecStrtTme;
            if (this$opErlstSchedldExecStrtTme == null ? other$opErlstSchedldExecStrtTme != null : !((Object)this$opErlstSchedldExecStrtTme).equals(other$opErlstSchedldExecStrtTme)) {
                return false;
            }
            Calendar this$opErlstSchedldExecEndDte = this.opErlstSchedldExecEndDte;
            Calendar other$opErlstSchedldExecEndDte = other.opErlstSchedldExecEndDte;
            if (this$opErlstSchedldExecEndDte == null ? other$opErlstSchedldExecEndDte != null : !((Object)this$opErlstSchedldExecEndDte).equals(other$opErlstSchedldExecEndDte)) {
                return false;
            }
            Calendar this$opErlstSchedldExecEndTme = this.opErlstSchedldExecEndTme;
            Calendar other$opErlstSchedldExecEndTme = other.opErlstSchedldExecEndTme;
            if (this$opErlstSchedldExecEndTme == null ? other$opErlstSchedldExecEndTme != null : !((Object)this$opErlstSchedldExecEndTme).equals(other$opErlstSchedldExecEndTme)) {
                return false;
            }
            Calendar this$opActualExecutionStartDate = this.opActualExecutionStartDate;
            Calendar other$opActualExecutionStartDate = other.opActualExecutionStartDate;
            if (this$opActualExecutionStartDate == null ? other$opActualExecutionStartDate != null : !((Object)this$opActualExecutionStartDate).equals(other$opActualExecutionStartDate)) {
                return false;
            }
            Calendar this$opActualExecutionStartTime = this.opActualExecutionStartTime;
            Calendar other$opActualExecutionStartTime = other.opActualExecutionStartTime;
            if (this$opActualExecutionStartTime == null ? other$opActualExecutionStartTime != null : !((Object)this$opActualExecutionStartTime).equals(other$opActualExecutionStartTime)) {
                return false;
            }
            String this$orderIntBillOfOperationsItem = this.orderIntBillOfOperationsItem;
            String other$orderIntBillOfOperationsItem = other.orderIntBillOfOperationsItem;
            if (this$orderIntBillOfOperationsItem == null ? other$orderIntBillOfOperationsItem != null : !this$orderIntBillOfOperationsItem.equals(other$orderIntBillOfOperationsItem)) {
                return false;
            }
            Calendar this$opActualExecutionEndDate = this.opActualExecutionEndDate;
            Calendar other$opActualExecutionEndDate = other.opActualExecutionEndDate;
            if (this$opActualExecutionEndDate == null ? other$opActualExecutionEndDate != null : !((Object)this$opActualExecutionEndDate).equals(other$opActualExecutionEndDate)) {
                return false;
            }
            Calendar this$opActualExecutionEndTime = this.opActualExecutionEndTime;
            Calendar other$opActualExecutionEndTime = other.opActualExecutionEndTime;
            if (this$opActualExecutionEndTime == null ? other$opActualExecutionEndTime != null : !((Object)this$opActualExecutionEndTime).equals(other$opActualExecutionEndTime)) {
                return false;
            }
            String this$operationUnit = this.operationUnit;
            String other$operationUnit = other.operationUnit;
            if (this$operationUnit == null ? other$operationUnit != null : !this$operationUnit.equals(other$operationUnit)) {
                return false;
            }
            BigDecimal this$opPlannedTotalQuantity = this.opPlannedTotalQuantity;
            BigDecimal other$opPlannedTotalQuantity = other.opPlannedTotalQuantity;
            if (this$opPlannedTotalQuantity == null ? other$opPlannedTotalQuantity != null : !((Object)this$opPlannedTotalQuantity).equals(other$opPlannedTotalQuantity)) {
                return false;
            }
            Integer this$erlstSchedldExecDurnInWorkdays = this.erlstSchedldExecDurnInWorkdays;
            Integer other$erlstSchedldExecDurnInWorkdays = other.erlstSchedldExecDurnInWorkdays;
            if (this$erlstSchedldExecDurnInWorkdays == null ? other$erlstSchedldExecDurnInWorkdays != null : !((Object)this$erlstSchedldExecDurnInWorkdays).equals(other$erlstSchedldExecDurnInWorkdays)) {
                return false;
            }
            Integer this$opActualExecutionDays = this.opActualExecutionDays;
            Integer other$opActualExecutionDays = other.opActualExecutionDays;
            if (this$opActualExecutionDays == null ? other$opActualExecutionDays != null : !((Object)this$opActualExecutionDays).equals(other$opActualExecutionDays)) {
                return false;
            }
            BigDecimal this$opTotalConfirmedYieldQty = this.opTotalConfirmedYieldQty;
            BigDecimal other$opTotalConfirmedYieldQty = other.opTotalConfirmedYieldQty;
            if (this$opTotalConfirmedYieldQty == null ? other$opTotalConfirmedYieldQty != null : !((Object)this$opTotalConfirmedYieldQty).equals(other$opTotalConfirmedYieldQty)) {
                return false;
            }
            String this$workCenterInternalID = this.workCenterInternalID;
            String other$workCenterInternalID = other.workCenterInternalID;
            if (this$workCenterInternalID == null ? other$workCenterInternalID != null : !this$workCenterInternalID.equals(other$workCenterInternalID)) {
                return false;
            }
            String this$manufacturingOrder = this.manufacturingOrder;
            String other$manufacturingOrder = other.manufacturingOrder;
            if (this$manufacturingOrder == null ? other$manufacturingOrder != null : !this$manufacturingOrder.equals(other$manufacturingOrder)) {
                return false;
            }
            String this$manufacturingOrderOperation = this.manufacturingOrderOperation;
            String other$manufacturingOrderOperation = other.manufacturingOrderOperation;
            if (this$manufacturingOrderOperation == null ? other$manufacturingOrderOperation != null : !this$manufacturingOrderOperation.equals(other$manufacturingOrderOperation)) {
                return false;
            }
            Boolean this$mfgOrderOperationIsPhase = this.mfgOrderOperationIsPhase;
            Boolean other$mfgOrderOperationIsPhase = other.mfgOrderOperationIsPhase;
            if (this$mfgOrderOperationIsPhase == null ? other$mfgOrderOperationIsPhase != null : !((Object)this$mfgOrderOperationIsPhase).equals(other$mfgOrderOperationIsPhase)) {
                return false;
            }
            String this$manufacturingOrderSequence = this.manufacturingOrderSequence;
            String other$manufacturingOrderSequence = other.manufacturingOrderSequence;
            if (this$manufacturingOrderSequence == null ? other$manufacturingOrderSequence != null : !this$manufacturingOrderSequence.equals(other$manufacturingOrderSequence)) {
                return false;
            }
            String this$mfgOrderSequenceText = this.mfgOrderSequenceText;
            String other$mfgOrderSequenceText = other.mfgOrderSequenceText;
            if (this$mfgOrderSequenceText == null ? other$mfgOrderSequenceText != null : !this$mfgOrderSequenceText.equals(other$mfgOrderSequenceText)) {
                return false;
            }
            String this$mfgOrderOperationText = this.mfgOrderOperationText;
            String other$mfgOrderOperationText = other.mfgOrderOperationText;
            if (this$mfgOrderOperationText == null ? other$mfgOrderOperationText != null : !this$mfgOrderOperationText.equals(other$mfgOrderOperationText)) {
                return false;
            }
            String this$manufacturingOrderType = this.manufacturingOrderType;
            String other$manufacturingOrderType = other.manufacturingOrderType;
            return !(this$manufacturingOrderType == null ? other$manufacturingOrderType != null : !this$manufacturingOrderType.equals(other$manufacturingOrderType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ProcessOrderOperation;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $orderInternalBillOfOperations = this.orderInternalBillOfOperations;
            result = result * 59 + ($orderInternalBillOfOperations == null ? 43 : $orderInternalBillOfOperations.hashCode());
            String $businessProcessEntryUnit = this.businessProcessEntryUnit;
            result = result * 59 + ($businessProcessEntryUnit == null ? 43 : $businessProcessEntryUnit.hashCode());
            String $manufacturingOrderCategory = this.manufacturingOrderCategory;
            result = result * 59 + ($manufacturingOrderCategory == null ? 43 : $manufacturingOrderCategory.hashCode());
            String $workCenterTypeCode = this.workCenterTypeCode;
            result = result * 59 + ($workCenterTypeCode == null ? 43 : $workCenterTypeCode.hashCode());
            String $workCenter = this.workCenter;
            result = result * 59 + ($workCenter == null ? 43 : $workCenter.hashCode());
            Calendar $opErlstSchedldExecStrtDte = this.opErlstSchedldExecStrtDte;
            result = result * 59 + ($opErlstSchedldExecStrtDte == null ? 43 : ((Object)$opErlstSchedldExecStrtDte).hashCode());
            Calendar $opErlstSchedldExecStrtTme = this.opErlstSchedldExecStrtTme;
            result = result * 59 + ($opErlstSchedldExecStrtTme == null ? 43 : ((Object)$opErlstSchedldExecStrtTme).hashCode());
            Calendar $opErlstSchedldExecEndDte = this.opErlstSchedldExecEndDte;
            result = result * 59 + ($opErlstSchedldExecEndDte == null ? 43 : ((Object)$opErlstSchedldExecEndDte).hashCode());
            Calendar $opErlstSchedldExecEndTme = this.opErlstSchedldExecEndTme;
            result = result * 59 + ($opErlstSchedldExecEndTme == null ? 43 : ((Object)$opErlstSchedldExecEndTme).hashCode());
            Calendar $opActualExecutionStartDate = this.opActualExecutionStartDate;
            result = result * 59 + ($opActualExecutionStartDate == null ? 43 : ((Object)$opActualExecutionStartDate).hashCode());
            Calendar $opActualExecutionStartTime = this.opActualExecutionStartTime;
            result = result * 59 + ($opActualExecutionStartTime == null ? 43 : ((Object)$opActualExecutionStartTime).hashCode());
            String $orderIntBillOfOperationsItem = this.orderIntBillOfOperationsItem;
            result = result * 59 + ($orderIntBillOfOperationsItem == null ? 43 : $orderIntBillOfOperationsItem.hashCode());
            Calendar $opActualExecutionEndDate = this.opActualExecutionEndDate;
            result = result * 59 + ($opActualExecutionEndDate == null ? 43 : ((Object)$opActualExecutionEndDate).hashCode());
            Calendar $opActualExecutionEndTime = this.opActualExecutionEndTime;
            result = result * 59 + ($opActualExecutionEndTime == null ? 43 : ((Object)$opActualExecutionEndTime).hashCode());
            String $operationUnit = this.operationUnit;
            result = result * 59 + ($operationUnit == null ? 43 : $operationUnit.hashCode());
            BigDecimal $opPlannedTotalQuantity = this.opPlannedTotalQuantity;
            result = result * 59 + ($opPlannedTotalQuantity == null ? 43 : ((Object)$opPlannedTotalQuantity).hashCode());
            Integer $erlstSchedldExecDurnInWorkdays = this.erlstSchedldExecDurnInWorkdays;
            result = result * 59 + ($erlstSchedldExecDurnInWorkdays == null ? 43 : ((Object)$erlstSchedldExecDurnInWorkdays).hashCode());
            Integer $opActualExecutionDays = this.opActualExecutionDays;
            result = result * 59 + ($opActualExecutionDays == null ? 43 : ((Object)$opActualExecutionDays).hashCode());
            BigDecimal $opTotalConfirmedYieldQty = this.opTotalConfirmedYieldQty;
            result = result * 59 + ($opTotalConfirmedYieldQty == null ? 43 : ((Object)$opTotalConfirmedYieldQty).hashCode());
            String $workCenterInternalID = this.workCenterInternalID;
            result = result * 59 + ($workCenterInternalID == null ? 43 : $workCenterInternalID.hashCode());
            String $manufacturingOrder = this.manufacturingOrder;
            result = result * 59 + ($manufacturingOrder == null ? 43 : $manufacturingOrder.hashCode());
            String $manufacturingOrderOperation = this.manufacturingOrderOperation;
            result = result * 59 + ($manufacturingOrderOperation == null ? 43 : $manufacturingOrderOperation.hashCode());
            Boolean $mfgOrderOperationIsPhase = this.mfgOrderOperationIsPhase;
            result = result * 59 + ($mfgOrderOperationIsPhase == null ? 43 : ((Object)$mfgOrderOperationIsPhase).hashCode());
            String $manufacturingOrderSequence = this.manufacturingOrderSequence;
            result = result * 59 + ($manufacturingOrderSequence == null ? 43 : $manufacturingOrderSequence.hashCode());
            String $mfgOrderSequenceText = this.mfgOrderSequenceText;
            result = result * 59 + ($mfgOrderSequenceText == null ? 43 : $mfgOrderSequenceText.hashCode());
            String $mfgOrderOperationText = this.mfgOrderOperationText;
            result = result * 59 + ($mfgOrderOperationText == null ? 43 : $mfgOrderOperationText.hashCode());
            String $manufacturingOrderType = this.manufacturingOrderType;
            result = result * 59 + ($manufacturingOrderType == null ? 43 : $manufacturingOrderType.hashCode());
            return result;
        }

        public String getOrderInternalBillOfOperations() {
            return this.orderInternalBillOfOperations;
        }

        public ProcessOrderOperation setOrderInternalBillOfOperations(String orderInternalBillOfOperations) {
            this.orderInternalBillOfOperations = orderInternalBillOfOperations;
            return this;
        }

        public String getBusinessProcessEntryUnit() {
            return this.businessProcessEntryUnit;
        }

        public ProcessOrderOperation setBusinessProcessEntryUnit(String businessProcessEntryUnit) {
            this.businessProcessEntryUnit = businessProcessEntryUnit;
            return this;
        }

        public String getManufacturingOrderCategory() {
            return this.manufacturingOrderCategory;
        }

        public ProcessOrderOperation setManufacturingOrderCategory(String manufacturingOrderCategory) {
            this.manufacturingOrderCategory = manufacturingOrderCategory;
            return this;
        }

        public String getWorkCenterTypeCode() {
            return this.workCenterTypeCode;
        }

        public ProcessOrderOperation setWorkCenterTypeCode(String workCenterTypeCode) {
            this.workCenterTypeCode = workCenterTypeCode;
            return this;
        }

        public String getWorkCenter() {
            return this.workCenter;
        }

        public ProcessOrderOperation setWorkCenter(String workCenter) {
            this.workCenter = workCenter;
            return this;
        }

        public Calendar getOpErlstSchedldExecStrtDte() {
            return this.opErlstSchedldExecStrtDte;
        }

        public ProcessOrderOperation setOpErlstSchedldExecStrtDte(Calendar opErlstSchedldExecStrtDte) {
            this.opErlstSchedldExecStrtDte = opErlstSchedldExecStrtDte;
            return this;
        }

        public Calendar getOpErlstSchedldExecStrtTme() {
            return this.opErlstSchedldExecStrtTme;
        }

        public ProcessOrderOperation setOpErlstSchedldExecStrtTme(Calendar opErlstSchedldExecStrtTme) {
            this.opErlstSchedldExecStrtTme = opErlstSchedldExecStrtTme;
            return this;
        }

        public Calendar getOpErlstSchedldExecEndDte() {
            return this.opErlstSchedldExecEndDte;
        }

        public ProcessOrderOperation setOpErlstSchedldExecEndDte(Calendar opErlstSchedldExecEndDte) {
            this.opErlstSchedldExecEndDte = opErlstSchedldExecEndDte;
            return this;
        }

        public Calendar getOpErlstSchedldExecEndTme() {
            return this.opErlstSchedldExecEndTme;
        }

        public ProcessOrderOperation setOpErlstSchedldExecEndTme(Calendar opErlstSchedldExecEndTme) {
            this.opErlstSchedldExecEndTme = opErlstSchedldExecEndTme;
            return this;
        }

        public Calendar getOpActualExecutionStartDate() {
            return this.opActualExecutionStartDate;
        }

        public ProcessOrderOperation setOpActualExecutionStartDate(Calendar opActualExecutionStartDate) {
            this.opActualExecutionStartDate = opActualExecutionStartDate;
            return this;
        }

        public Calendar getOpActualExecutionStartTime() {
            return this.opActualExecutionStartTime;
        }

        public ProcessOrderOperation setOpActualExecutionStartTime(Calendar opActualExecutionStartTime) {
            this.opActualExecutionStartTime = opActualExecutionStartTime;
            return this;
        }

        public String getOrderIntBillOfOperationsItem() {
            return this.orderIntBillOfOperationsItem;
        }

        public ProcessOrderOperation setOrderIntBillOfOperationsItem(String orderIntBillOfOperationsItem) {
            this.orderIntBillOfOperationsItem = orderIntBillOfOperationsItem;
            return this;
        }

        public Calendar getOpActualExecutionEndDate() {
            return this.opActualExecutionEndDate;
        }

        public ProcessOrderOperation setOpActualExecutionEndDate(Calendar opActualExecutionEndDate) {
            this.opActualExecutionEndDate = opActualExecutionEndDate;
            return this;
        }

        public Calendar getOpActualExecutionEndTime() {
            return this.opActualExecutionEndTime;
        }

        public ProcessOrderOperation setOpActualExecutionEndTime(Calendar opActualExecutionEndTime) {
            this.opActualExecutionEndTime = opActualExecutionEndTime;
            return this;
        }

        public String getOperationUnit() {
            return this.operationUnit;
        }

        public ProcessOrderOperation setOperationUnit(String operationUnit) {
            this.operationUnit = operationUnit;
            return this;
        }

        public BigDecimal getOpPlannedTotalQuantity() {
            return this.opPlannedTotalQuantity;
        }

        public ProcessOrderOperation setOpPlannedTotalQuantity(BigDecimal opPlannedTotalQuantity) {
            this.opPlannedTotalQuantity = opPlannedTotalQuantity;
            return this;
        }

        public Integer getErlstSchedldExecDurnInWorkdays() {
            return this.erlstSchedldExecDurnInWorkdays;
        }

        public ProcessOrderOperation setErlstSchedldExecDurnInWorkdays(Integer erlstSchedldExecDurnInWorkdays) {
            this.erlstSchedldExecDurnInWorkdays = erlstSchedldExecDurnInWorkdays;
            return this;
        }

        public Integer getOpActualExecutionDays() {
            return this.opActualExecutionDays;
        }

        public ProcessOrderOperation setOpActualExecutionDays(Integer opActualExecutionDays) {
            this.opActualExecutionDays = opActualExecutionDays;
            return this;
        }

        public BigDecimal getOpTotalConfirmedYieldQty() {
            return this.opTotalConfirmedYieldQty;
        }

        public ProcessOrderOperation setOpTotalConfirmedYieldQty(BigDecimal opTotalConfirmedYieldQty) {
            this.opTotalConfirmedYieldQty = opTotalConfirmedYieldQty;
            return this;
        }

        public String getWorkCenterInternalID() {
            return this.workCenterInternalID;
        }

        public ProcessOrderOperation setWorkCenterInternalID(String workCenterInternalID) {
            this.workCenterInternalID = workCenterInternalID;
            return this;
        }

        public String getManufacturingOrder() {
            return this.manufacturingOrder;
        }

        public ProcessOrderOperation setManufacturingOrder(String manufacturingOrder) {
            this.manufacturingOrder = manufacturingOrder;
            return this;
        }

        public String getManufacturingOrderOperation() {
            return this.manufacturingOrderOperation;
        }

        public ProcessOrderOperation setManufacturingOrderOperation(String manufacturingOrderOperation) {
            this.manufacturingOrderOperation = manufacturingOrderOperation;
            return this;
        }

        public Boolean getMfgOrderOperationIsPhase() {
            return this.mfgOrderOperationIsPhase;
        }

        public ProcessOrderOperation setMfgOrderOperationIsPhase(Boolean mfgOrderOperationIsPhase) {
            this.mfgOrderOperationIsPhase = mfgOrderOperationIsPhase;
            return this;
        }

        public String getManufacturingOrderSequence() {
            return this.manufacturingOrderSequence;
        }

        public ProcessOrderOperation setManufacturingOrderSequence(String manufacturingOrderSequence) {
            this.manufacturingOrderSequence = manufacturingOrderSequence;
            return this;
        }

        public String getMfgOrderSequenceText() {
            return this.mfgOrderSequenceText;
        }

        public ProcessOrderOperation setMfgOrderSequenceText(String mfgOrderSequenceText) {
            this.mfgOrderSequenceText = mfgOrderSequenceText;
            return this;
        }

        public String getMfgOrderOperationText() {
            return this.mfgOrderOperationText;
        }

        public ProcessOrderOperation setMfgOrderOperationText(String mfgOrderOperationText) {
            this.mfgOrderOperationText = mfgOrderOperationText;
            return this;
        }

        public String getManufacturingOrderType() {
            return this.manufacturingOrderType;
        }

        public ProcessOrderOperation setManufacturingOrderType(String manufacturingOrderType) {
            this.manufacturingOrderType = manufacturingOrderType;
            return this;
        }

        public ProcessOrderOperation setErpConfigContext(ErpConfigContext erpConfigContext) {
            this.erpConfigContext = erpConfigContext;
            return this;
        }
    }

    public static class ProcessOrderItemFluentHelper {
        private ODataQueryBuilder queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_PROCESS_ORDERS", (String)"A_ProcessOrderItem");
        private ErrorResultHandler<?> errorResultHandler = new ODataVdmErrorResultHandler();

        public ProcessOrderItemFluentHelper filter(ExpressionFluentHelper<ProcessOrderItem> expression) {
            for (FilterExpressionWrapper<?> filterExpressionWrapper : expression.evaluate()) {
                Object comparisonValue = filterExpressionWrapper.getComparisonValue();
                if (comparisonValue instanceof Integer) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Integer)((Integer)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof String) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((String)((String)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Long) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Long)((Long)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Double) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Double)((Double)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Float) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Float)((Float)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDate) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDate)((LocalDate)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDateTime)((LocalDateTime)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Date) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Date)((Date)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof DateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((DateTime)((DateTime)comparisonValue))));
                    continue;
                }
                this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of(comparisonValue)));
            }
            return this;
        }

        public ProcessOrderItemFluentHelper orderBy(EntityField<?, ProcessOrderItem> field, Order order) {
            String orderingDirection = order == Order.ASC ? " asc" : " desc";
            this.queryBuilder.param("orderby", (Object)(field.getFieldName() + orderingDirection));
            return this;
        }

        @SafeVarargs
        public final ProcessOrderItemFluentHelper select(EntityField<?, ProcessOrderItem> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public ProcessOrderItemFluentHelper top(Number top) {
            this.queryBuilder.top(top);
            return this;
        }

        public ProcessOrderItemFluentHelper skip(Number skip) {
            this.queryBuilder.skip(skip);
            return this;
        }

        public ProcessOrderItemFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.errorHandler(this.errorResultHandler).build();
        }

        public List<ProcessOrderItem> execute(ErpConfigContext erpConfigContext) throws ODataException {
            List entityList = this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).asList(ProcessOrderItem.class);
            for (ProcessOrderItem entity : entityList) {
                entity.setErpConfigContext(erpConfigContext);
            }
            return entityList;
        }
    }

    public static class ProcessOrderItemByKeyFluentHelper {
        private ODataQueryBuilder queryBuilder;
        private ErrorResultHandler<?> errorResultHandler;
        private List<Object> values = new LinkedList<Object>();

        public ProcessOrderItemByKeyFluentHelper(String manufacturingOrder, String manufacturingOrderItem) {
            this.values.add(manufacturingOrder);
            this.values.add(manufacturingOrderItem);
            this.queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_PROCESS_ORDERS", (String)"A_ProcessOrderItem");
            HashMap<String, Object> keys = new HashMap<String, Object>();
            keys.put("ManufacturingOrder", this.values.get(0));
            keys.put("ManufacturingOrderItem", this.values.get(1));
            this.queryBuilder.keys(keys);
        }

        @SafeVarargs
        public final ProcessOrderItemByKeyFluentHelper select(EntityField<?, ProcessOrderItem> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.build();
        }

        public ProcessOrderItemByKeyFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public ProcessOrderItem execute(ErpConfigContext erpConfigContext) throws ODataException {
            ProcessOrderItem entity = (ProcessOrderItem)this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).as(ProcessOrderItem.class);
            entity.setErpConfigContext(erpConfigContext);
            return entity;
        }
    }

    public static class ProcessOrderItem {
        @ElementName(value="ManufacturingOrder")
        private String manufacturingOrder;
        public static EntityField<String, ProcessOrderItem> MANUFACTURING_ORDER = new EntityField("ManufacturingOrder");
        @ElementName(value="MfgOrderItemPlannedScrapQty")
        private BigDecimal mfgOrderItemPlannedScrapQty;
        public static EntityField<BigDecimal, ProcessOrderItem> MFG_ORDER_ITEM_PLANNED_SCRAP_QTY = new EntityField("MfgOrderItemPlannedScrapQty");
        @ElementName(value="MfgOrderItemGoodsReceiptQty")
        private BigDecimal mfgOrderItemGoodsReceiptQty;
        public static EntityField<BigDecimal, ProcessOrderItem> MFG_ORDER_ITEM_GOODS_RECEIPT_QTY = new EntityField("MfgOrderItemGoodsReceiptQty");
        @ElementName(value="MfgOrderItemActualDeviationQty")
        private BigDecimal mfgOrderItemActualDeviationQty;
        public static EntityField<BigDecimal, ProcessOrderItem> MFG_ORDER_ITEM_ACTUAL_DEVIATION_QTY = new EntityField("MfgOrderItemActualDeviationQty");
        @ElementName(value="ProductionUnit")
        private String productionUnit;
        public static EntityField<String, ProcessOrderItem> PRODUCTION_UNIT = new EntityField("ProductionUnit");
        @ElementName(value="MRPArea")
        private String mRPArea;
        public static EntityField<String, ProcessOrderItem> M_R_P_AREA = new EntityField("MRPArea");
        @ElementName(value="StorageLocation")
        private String storageLocation;
        public static EntityField<String, ProcessOrderItem> STORAGE_LOCATION = new EntityField("StorageLocation");
        @ElementName(value="MfgOrderItemPlndDeliveryDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar mfgOrderItemPlndDeliveryDate;
        public static EntityField<Calendar, ProcessOrderItem> MFG_ORDER_ITEM_PLND_DELIVERY_DATE = new EntityField("MfgOrderItemPlndDeliveryDate");
        @ElementName(value="ManufacturingOrderItem")
        private String manufacturingOrderItem;
        public static EntityField<String, ProcessOrderItem> MANUFACTURING_ORDER_ITEM = new EntityField("ManufacturingOrderItem");
        @ElementName(value="ManufacturingOrderCategory")
        private String manufacturingOrderCategory;
        public static EntityField<String, ProcessOrderItem> MANUFACTURING_ORDER_CATEGORY = new EntityField("ManufacturingOrderCategory");
        @ElementName(value="ManufacturingOrderType")
        private String manufacturingOrderType;
        public static EntityField<String, ProcessOrderItem> MANUFACTURING_ORDER_TYPE = new EntityField("ManufacturingOrderType");
        @ElementName(value="ProductionPlant")
        private String productionPlant;
        public static EntityField<String, ProcessOrderItem> PRODUCTION_PLANT = new EntityField("ProductionPlant");
        @ElementName(value="Material")
        private String material;
        public static EntityField<String, ProcessOrderItem> MATERIAL = new EntityField("Material");
        @ElementName(value="MRPPlant")
        private String mRPPlant;
        public static EntityField<String, ProcessOrderItem> M_R_P_PLANT = new EntityField("MRPPlant");
        @ElementName(value="MfgOrderItemActualDeliveryDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar mfgOrderItemActualDeliveryDate;
        public static EntityField<Calendar, ProcessOrderItem> MFG_ORDER_ITEM_ACTUAL_DELIVERY_DATE = new EntityField("MfgOrderItemActualDeliveryDate");
        @ElementName(value="MfgOrderItemPlannedTotalQty")
        private BigDecimal mfgOrderItemPlannedTotalQty;
        public static EntityField<BigDecimal, ProcessOrderItem> MFG_ORDER_ITEM_PLANNED_TOTAL_QTY = new EntityField("MfgOrderItemPlannedTotalQty");
        private static final transient String ODATA_ENDPOINT_URL = "/sap/opu/odata/sap/API_PROCESS_ORDERS";
        private static final transient String ODATA_ENTITY_COLLECTION = "A_ProcessOrderItem";
        private transient ErpConfigContext erpConfigContext;

        public String toString() {
            return "ReadProcessOrdersNamespace.ProcessOrderItem(manufacturingOrder=" + this.manufacturingOrder + ", mfgOrderItemPlannedScrapQty=" + this.mfgOrderItemPlannedScrapQty + ", mfgOrderItemGoodsReceiptQty=" + this.mfgOrderItemGoodsReceiptQty + ", mfgOrderItemActualDeviationQty=" + this.mfgOrderItemActualDeviationQty + ", productionUnit=" + this.productionUnit + ", mRPArea=" + this.mRPArea + ", storageLocation=" + this.storageLocation + ", mfgOrderItemPlndDeliveryDate=" + this.mfgOrderItemPlndDeliveryDate + ", manufacturingOrderItem=" + this.manufacturingOrderItem + ", manufacturingOrderCategory=" + this.manufacturingOrderCategory + ", manufacturingOrderType=" + this.manufacturingOrderType + ", productionPlant=" + this.productionPlant + ", material=" + this.material + ", mRPPlant=" + this.mRPPlant + ", mfgOrderItemActualDeliveryDate=" + this.mfgOrderItemActualDeliveryDate + ", mfgOrderItemPlannedTotalQty=" + this.mfgOrderItemPlannedTotalQty + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProcessOrderItem)) {
                return false;
            }
            ProcessOrderItem other = (ProcessOrderItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$manufacturingOrder = this.manufacturingOrder;
            String other$manufacturingOrder = other.manufacturingOrder;
            if (this$manufacturingOrder == null ? other$manufacturingOrder != null : !this$manufacturingOrder.equals(other$manufacturingOrder)) {
                return false;
            }
            BigDecimal this$mfgOrderItemPlannedScrapQty = this.mfgOrderItemPlannedScrapQty;
            BigDecimal other$mfgOrderItemPlannedScrapQty = other.mfgOrderItemPlannedScrapQty;
            if (this$mfgOrderItemPlannedScrapQty == null ? other$mfgOrderItemPlannedScrapQty != null : !((Object)this$mfgOrderItemPlannedScrapQty).equals(other$mfgOrderItemPlannedScrapQty)) {
                return false;
            }
            BigDecimal this$mfgOrderItemGoodsReceiptQty = this.mfgOrderItemGoodsReceiptQty;
            BigDecimal other$mfgOrderItemGoodsReceiptQty = other.mfgOrderItemGoodsReceiptQty;
            if (this$mfgOrderItemGoodsReceiptQty == null ? other$mfgOrderItemGoodsReceiptQty != null : !((Object)this$mfgOrderItemGoodsReceiptQty).equals(other$mfgOrderItemGoodsReceiptQty)) {
                return false;
            }
            BigDecimal this$mfgOrderItemActualDeviationQty = this.mfgOrderItemActualDeviationQty;
            BigDecimal other$mfgOrderItemActualDeviationQty = other.mfgOrderItemActualDeviationQty;
            if (this$mfgOrderItemActualDeviationQty == null ? other$mfgOrderItemActualDeviationQty != null : !((Object)this$mfgOrderItemActualDeviationQty).equals(other$mfgOrderItemActualDeviationQty)) {
                return false;
            }
            String this$productionUnit = this.productionUnit;
            String other$productionUnit = other.productionUnit;
            if (this$productionUnit == null ? other$productionUnit != null : !this$productionUnit.equals(other$productionUnit)) {
                return false;
            }
            String this$mRPArea = this.mRPArea;
            String other$mRPArea = other.mRPArea;
            if (this$mRPArea == null ? other$mRPArea != null : !this$mRPArea.equals(other$mRPArea)) {
                return false;
            }
            String this$storageLocation = this.storageLocation;
            String other$storageLocation = other.storageLocation;
            if (this$storageLocation == null ? other$storageLocation != null : !this$storageLocation.equals(other$storageLocation)) {
                return false;
            }
            Calendar this$mfgOrderItemPlndDeliveryDate = this.mfgOrderItemPlndDeliveryDate;
            Calendar other$mfgOrderItemPlndDeliveryDate = other.mfgOrderItemPlndDeliveryDate;
            if (this$mfgOrderItemPlndDeliveryDate == null ? other$mfgOrderItemPlndDeliveryDate != null : !((Object)this$mfgOrderItemPlndDeliveryDate).equals(other$mfgOrderItemPlndDeliveryDate)) {
                return false;
            }
            String this$manufacturingOrderItem = this.manufacturingOrderItem;
            String other$manufacturingOrderItem = other.manufacturingOrderItem;
            if (this$manufacturingOrderItem == null ? other$manufacturingOrderItem != null : !this$manufacturingOrderItem.equals(other$manufacturingOrderItem)) {
                return false;
            }
            String this$manufacturingOrderCategory = this.manufacturingOrderCategory;
            String other$manufacturingOrderCategory = other.manufacturingOrderCategory;
            if (this$manufacturingOrderCategory == null ? other$manufacturingOrderCategory != null : !this$manufacturingOrderCategory.equals(other$manufacturingOrderCategory)) {
                return false;
            }
            String this$manufacturingOrderType = this.manufacturingOrderType;
            String other$manufacturingOrderType = other.manufacturingOrderType;
            if (this$manufacturingOrderType == null ? other$manufacturingOrderType != null : !this$manufacturingOrderType.equals(other$manufacturingOrderType)) {
                return false;
            }
            String this$productionPlant = this.productionPlant;
            String other$productionPlant = other.productionPlant;
            if (this$productionPlant == null ? other$productionPlant != null : !this$productionPlant.equals(other$productionPlant)) {
                return false;
            }
            String this$material = this.material;
            String other$material = other.material;
            if (this$material == null ? other$material != null : !this$material.equals(other$material)) {
                return false;
            }
            String this$mRPPlant = this.mRPPlant;
            String other$mRPPlant = other.mRPPlant;
            if (this$mRPPlant == null ? other$mRPPlant != null : !this$mRPPlant.equals(other$mRPPlant)) {
                return false;
            }
            Calendar this$mfgOrderItemActualDeliveryDate = this.mfgOrderItemActualDeliveryDate;
            Calendar other$mfgOrderItemActualDeliveryDate = other.mfgOrderItemActualDeliveryDate;
            if (this$mfgOrderItemActualDeliveryDate == null ? other$mfgOrderItemActualDeliveryDate != null : !((Object)this$mfgOrderItemActualDeliveryDate).equals(other$mfgOrderItemActualDeliveryDate)) {
                return false;
            }
            BigDecimal this$mfgOrderItemPlannedTotalQty = this.mfgOrderItemPlannedTotalQty;
            BigDecimal other$mfgOrderItemPlannedTotalQty = other.mfgOrderItemPlannedTotalQty;
            return !(this$mfgOrderItemPlannedTotalQty == null ? other$mfgOrderItemPlannedTotalQty != null : !((Object)this$mfgOrderItemPlannedTotalQty).equals(other$mfgOrderItemPlannedTotalQty));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ProcessOrderItem;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $manufacturingOrder = this.manufacturingOrder;
            result = result * 59 + ($manufacturingOrder == null ? 43 : $manufacturingOrder.hashCode());
            BigDecimal $mfgOrderItemPlannedScrapQty = this.mfgOrderItemPlannedScrapQty;
            result = result * 59 + ($mfgOrderItemPlannedScrapQty == null ? 43 : ((Object)$mfgOrderItemPlannedScrapQty).hashCode());
            BigDecimal $mfgOrderItemGoodsReceiptQty = this.mfgOrderItemGoodsReceiptQty;
            result = result * 59 + ($mfgOrderItemGoodsReceiptQty == null ? 43 : ((Object)$mfgOrderItemGoodsReceiptQty).hashCode());
            BigDecimal $mfgOrderItemActualDeviationQty = this.mfgOrderItemActualDeviationQty;
            result = result * 59 + ($mfgOrderItemActualDeviationQty == null ? 43 : ((Object)$mfgOrderItemActualDeviationQty).hashCode());
            String $productionUnit = this.productionUnit;
            result = result * 59 + ($productionUnit == null ? 43 : $productionUnit.hashCode());
            String $mRPArea = this.mRPArea;
            result = result * 59 + ($mRPArea == null ? 43 : $mRPArea.hashCode());
            String $storageLocation = this.storageLocation;
            result = result * 59 + ($storageLocation == null ? 43 : $storageLocation.hashCode());
            Calendar $mfgOrderItemPlndDeliveryDate = this.mfgOrderItemPlndDeliveryDate;
            result = result * 59 + ($mfgOrderItemPlndDeliveryDate == null ? 43 : ((Object)$mfgOrderItemPlndDeliveryDate).hashCode());
            String $manufacturingOrderItem = this.manufacturingOrderItem;
            result = result * 59 + ($manufacturingOrderItem == null ? 43 : $manufacturingOrderItem.hashCode());
            String $manufacturingOrderCategory = this.manufacturingOrderCategory;
            result = result * 59 + ($manufacturingOrderCategory == null ? 43 : $manufacturingOrderCategory.hashCode());
            String $manufacturingOrderType = this.manufacturingOrderType;
            result = result * 59 + ($manufacturingOrderType == null ? 43 : $manufacturingOrderType.hashCode());
            String $productionPlant = this.productionPlant;
            result = result * 59 + ($productionPlant == null ? 43 : $productionPlant.hashCode());
            String $material = this.material;
            result = result * 59 + ($material == null ? 43 : $material.hashCode());
            String $mRPPlant = this.mRPPlant;
            result = result * 59 + ($mRPPlant == null ? 43 : $mRPPlant.hashCode());
            Calendar $mfgOrderItemActualDeliveryDate = this.mfgOrderItemActualDeliveryDate;
            result = result * 59 + ($mfgOrderItemActualDeliveryDate == null ? 43 : ((Object)$mfgOrderItemActualDeliveryDate).hashCode());
            BigDecimal $mfgOrderItemPlannedTotalQty = this.mfgOrderItemPlannedTotalQty;
            result = result * 59 + ($mfgOrderItemPlannedTotalQty == null ? 43 : ((Object)$mfgOrderItemPlannedTotalQty).hashCode());
            return result;
        }

        public String getManufacturingOrder() {
            return this.manufacturingOrder;
        }

        public ProcessOrderItem setManufacturingOrder(String manufacturingOrder) {
            this.manufacturingOrder = manufacturingOrder;
            return this;
        }

        public BigDecimal getMfgOrderItemPlannedScrapQty() {
            return this.mfgOrderItemPlannedScrapQty;
        }

        public ProcessOrderItem setMfgOrderItemPlannedScrapQty(BigDecimal mfgOrderItemPlannedScrapQty) {
            this.mfgOrderItemPlannedScrapQty = mfgOrderItemPlannedScrapQty;
            return this;
        }

        public BigDecimal getMfgOrderItemGoodsReceiptQty() {
            return this.mfgOrderItemGoodsReceiptQty;
        }

        public ProcessOrderItem setMfgOrderItemGoodsReceiptQty(BigDecimal mfgOrderItemGoodsReceiptQty) {
            this.mfgOrderItemGoodsReceiptQty = mfgOrderItemGoodsReceiptQty;
            return this;
        }

        public BigDecimal getMfgOrderItemActualDeviationQty() {
            return this.mfgOrderItemActualDeviationQty;
        }

        public ProcessOrderItem setMfgOrderItemActualDeviationQty(BigDecimal mfgOrderItemActualDeviationQty) {
            this.mfgOrderItemActualDeviationQty = mfgOrderItemActualDeviationQty;
            return this;
        }

        public String getProductionUnit() {
            return this.productionUnit;
        }

        public ProcessOrderItem setProductionUnit(String productionUnit) {
            this.productionUnit = productionUnit;
            return this;
        }

        public String getMRPArea() {
            return this.mRPArea;
        }

        public ProcessOrderItem setMRPArea(String mRPArea) {
            this.mRPArea = mRPArea;
            return this;
        }

        public String getStorageLocation() {
            return this.storageLocation;
        }

        public ProcessOrderItem setStorageLocation(String storageLocation) {
            this.storageLocation = storageLocation;
            return this;
        }

        public Calendar getMfgOrderItemPlndDeliveryDate() {
            return this.mfgOrderItemPlndDeliveryDate;
        }

        public ProcessOrderItem setMfgOrderItemPlndDeliveryDate(Calendar mfgOrderItemPlndDeliveryDate) {
            this.mfgOrderItemPlndDeliveryDate = mfgOrderItemPlndDeliveryDate;
            return this;
        }

        public String getManufacturingOrderItem() {
            return this.manufacturingOrderItem;
        }

        public ProcessOrderItem setManufacturingOrderItem(String manufacturingOrderItem) {
            this.manufacturingOrderItem = manufacturingOrderItem;
            return this;
        }

        public String getManufacturingOrderCategory() {
            return this.manufacturingOrderCategory;
        }

        public ProcessOrderItem setManufacturingOrderCategory(String manufacturingOrderCategory) {
            this.manufacturingOrderCategory = manufacturingOrderCategory;
            return this;
        }

        public String getManufacturingOrderType() {
            return this.manufacturingOrderType;
        }

        public ProcessOrderItem setManufacturingOrderType(String manufacturingOrderType) {
            this.manufacturingOrderType = manufacturingOrderType;
            return this;
        }

        public String getProductionPlant() {
            return this.productionPlant;
        }

        public ProcessOrderItem setProductionPlant(String productionPlant) {
            this.productionPlant = productionPlant;
            return this;
        }

        public String getMaterial() {
            return this.material;
        }

        public ProcessOrderItem setMaterial(String material) {
            this.material = material;
            return this;
        }

        public String getMRPPlant() {
            return this.mRPPlant;
        }

        public ProcessOrderItem setMRPPlant(String mRPPlant) {
            this.mRPPlant = mRPPlant;
            return this;
        }

        public Calendar getMfgOrderItemActualDeliveryDate() {
            return this.mfgOrderItemActualDeliveryDate;
        }

        public ProcessOrderItem setMfgOrderItemActualDeliveryDate(Calendar mfgOrderItemActualDeliveryDate) {
            this.mfgOrderItemActualDeliveryDate = mfgOrderItemActualDeliveryDate;
            return this;
        }

        public BigDecimal getMfgOrderItemPlannedTotalQty() {
            return this.mfgOrderItemPlannedTotalQty;
        }

        public ProcessOrderItem setMfgOrderItemPlannedTotalQty(BigDecimal mfgOrderItemPlannedTotalQty) {
            this.mfgOrderItemPlannedTotalQty = mfgOrderItemPlannedTotalQty;
            return this;
        }

        public ProcessOrderItem setErpConfigContext(ErpConfigContext erpConfigContext) {
            this.erpConfigContext = erpConfigContext;
            return this;
        }
    }

    public static class ProcessOrderFluentHelper {
        private ODataQueryBuilder queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_PROCESS_ORDERS", (String)"A_ProcessOrder");
        private ErrorResultHandler<?> errorResultHandler = new ODataVdmErrorResultHandler();

        public ProcessOrderFluentHelper filter(ExpressionFluentHelper<ProcessOrder> expression) {
            for (FilterExpressionWrapper<?> filterExpressionWrapper : expression.evaluate()) {
                Object comparisonValue = filterExpressionWrapper.getComparisonValue();
                if (comparisonValue instanceof Integer) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Integer)((Integer)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof String) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((String)((String)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Long) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Long)((Long)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Double) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Double)((Double)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Float) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Float)((Float)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDate) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDate)((LocalDate)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDateTime)((LocalDateTime)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Date) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Date)((Date)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof DateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((DateTime)((DateTime)comparisonValue))));
                    continue;
                }
                this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of(comparisonValue)));
            }
            return this;
        }

        public ProcessOrderFluentHelper orderBy(EntityField<?, ProcessOrder> field, Order order) {
            String orderingDirection = order == Order.ASC ? " asc" : " desc";
            this.queryBuilder.param("orderby", (Object)(field.getFieldName() + orderingDirection));
            return this;
        }

        @SafeVarargs
        public final ProcessOrderFluentHelper select(EntityField<?, ProcessOrder> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public ProcessOrderFluentHelper top(Number top) {
            this.queryBuilder.top(top);
            return this;
        }

        public ProcessOrderFluentHelper skip(Number skip) {
            this.queryBuilder.skip(skip);
            return this;
        }

        public ProcessOrderFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.errorHandler(this.errorResultHandler).build();
        }

        public List<ProcessOrder> execute(ErpConfigContext erpConfigContext) throws ODataException {
            List entityList = this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).asList(ProcessOrder.class);
            for (ProcessOrder entity : entityList) {
                entity.setErpConfigContext(erpConfigContext);
            }
            return entityList;
        }
    }

    public static class ProcessOrderComponentFluentHelper {
        private ODataQueryBuilder queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_PROCESS_ORDERS", (String)"A_ProcessOrderComponent");
        private ErrorResultHandler<?> errorResultHandler = new ODataVdmErrorResultHandler();

        public ProcessOrderComponentFluentHelper filter(ExpressionFluentHelper<ProcessOrderComponent> expression) {
            for (FilterExpressionWrapper<?> filterExpressionWrapper : expression.evaluate()) {
                Object comparisonValue = filterExpressionWrapper.getComparisonValue();
                if (comparisonValue instanceof Integer) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Integer)((Integer)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof String) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((String)((String)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Long) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Long)((Long)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Double) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Double)((Double)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Float) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Float)((Float)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDate) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDate)((LocalDate)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDateTime)((LocalDateTime)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Date) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Date)((Date)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof DateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((DateTime)((DateTime)comparisonValue))));
                    continue;
                }
                this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of(comparisonValue)));
            }
            return this;
        }

        public ProcessOrderComponentFluentHelper orderBy(EntityField<?, ProcessOrderComponent> field, Order order) {
            String orderingDirection = order == Order.ASC ? " asc" : " desc";
            this.queryBuilder.param("orderby", (Object)(field.getFieldName() + orderingDirection));
            return this;
        }

        @SafeVarargs
        public final ProcessOrderComponentFluentHelper select(EntityField<?, ProcessOrderComponent> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public ProcessOrderComponentFluentHelper top(Number top) {
            this.queryBuilder.top(top);
            return this;
        }

        public ProcessOrderComponentFluentHelper skip(Number skip) {
            this.queryBuilder.skip(skip);
            return this;
        }

        public ProcessOrderComponentFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.errorHandler(this.errorResultHandler).build();
        }

        public List<ProcessOrderComponent> execute(ErpConfigContext erpConfigContext) throws ODataException {
            List entityList = this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).asList(ProcessOrderComponent.class);
            for (ProcessOrderComponent entity : entityList) {
                entity.setErpConfigContext(erpConfigContext);
            }
            return entityList;
        }
    }

    public static class ProcessOrderComponentByKeyFluentHelper {
        private ODataQueryBuilder queryBuilder;
        private ErrorResultHandler<?> errorResultHandler;
        private List<Object> values = new LinkedList<Object>();

        public ProcessOrderComponentByKeyFluentHelper(String reservation, String reservationItem) {
            this.values.add(reservation);
            this.values.add(reservationItem);
            this.queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_PROCESS_ORDERS", (String)"A_ProcessOrderComponent");
            HashMap<String, Object> keys = new HashMap<String, Object>();
            keys.put("Reservation", this.values.get(0));
            keys.put("ReservationItem", this.values.get(1));
            this.queryBuilder.keys(keys);
        }

        @SafeVarargs
        public final ProcessOrderComponentByKeyFluentHelper select(EntityField<?, ProcessOrderComponent> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.build();
        }

        public ProcessOrderComponentByKeyFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public ProcessOrderComponent execute(ErpConfigContext erpConfigContext) throws ODataException {
            ProcessOrderComponent entity = (ProcessOrderComponent)this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).as(ProcessOrderComponent.class);
            entity.setErpConfigContext(erpConfigContext);
            return entity;
        }
    }

    public static class ProcessOrderComponent {
        @ElementName(value="Reservation")
        private String reservation;
        public static EntityField<String, ProcessOrderComponent> RESERVATION = new EntityField("Reservation");
        @ElementName(value="RequiredQuantity")
        private BigDecimal requiredQuantity;
        public static EntityField<BigDecimal, ProcessOrderComponent> REQUIRED_QUANTITY = new EntityField("RequiredQuantity");
        @ElementName(value="WithdrawnQuantity")
        private BigDecimal withdrawnQuantity;
        public static EntityField<BigDecimal, ProcessOrderComponent> WITHDRAWN_QUANTITY = new EntityField("WithdrawnQuantity");
        @ElementName(value="BOMItem")
        private String bOMItem;
        public static EntityField<String, ProcessOrderComponent> B_O_M_ITEM = new EntityField("BOMItem");
        @ElementName(value="StorageLocation")
        private String storageLocation;
        public static EntityField<String, ProcessOrderComponent> STORAGE_LOCATION = new EntityField("StorageLocation");
        @ElementName(value="SupplyArea")
        private String supplyArea;
        public static EntityField<String, ProcessOrderComponent> SUPPLY_AREA = new EntityField("SupplyArea");
        @ElementName(value="ManufacturingOrderSequence")
        private String manufacturingOrderSequence;
        public static EntityField<String, ProcessOrderComponent> MANUFACTURING_ORDER_SEQUENCE = new EntityField("ManufacturingOrderSequence");
        @ElementName(value="ManufacturingOrder")
        private String manufacturingOrder;
        public static EntityField<String, ProcessOrderComponent> MANUFACTURING_ORDER = new EntityField("ManufacturingOrder");
        @ElementName(value="ManufacturingOrderOperation")
        private String manufacturingOrderOperation;
        public static EntityField<String, ProcessOrderComponent> MANUFACTURING_ORDER_OPERATION = new EntityField("ManufacturingOrderOperation");
        @ElementName(value="ManufacturingOrderCategory")
        private String manufacturingOrderCategory;
        public static EntityField<String, ProcessOrderComponent> MANUFACTURING_ORDER_CATEGORY = new EntityField("ManufacturingOrderCategory");
        @ElementName(value="ManufacturingOrderType")
        private String manufacturingOrderType;
        public static EntityField<String, ProcessOrderComponent> MANUFACTURING_ORDER_TYPE = new EntityField("ManufacturingOrderType");
        @ElementName(value="ReservationItem")
        private String reservationItem;
        public static EntityField<String, ProcessOrderComponent> RESERVATION_ITEM = new EntityField("ReservationItem");
        @ElementName(value="OrderInternalBillOfOperations")
        private String orderInternalBillOfOperations;
        public static EntityField<String, ProcessOrderComponent> ORDER_INTERNAL_BILL_OF_OPERATIONS = new EntityField("OrderInternalBillOfOperations");
        @ElementName(value="BillOfMaterialItemNumber")
        private String billOfMaterialItemNumber;
        public static EntityField<String, ProcessOrderComponent> BILL_OF_MATERIAL_ITEM_NUMBER = new EntityField("BillOfMaterialItemNumber");
        @ElementName(value="BOMItemDescription")
        private String bOMItemDescription;
        public static EntityField<String, ProcessOrderComponent> B_O_M_ITEM_DESCRIPTION = new EntityField("BOMItemDescription");
        @ElementName(value="Material")
        private String material;
        public static EntityField<String, ProcessOrderComponent> MATERIAL = new EntityField("Material");
        @ElementName(value="Plant")
        private String plant;
        public static EntityField<String, ProcessOrderComponent> PLANT = new EntityField("Plant");
        @ElementName(value="ProductionPlant")
        private String productionPlant;
        public static EntityField<String, ProcessOrderComponent> PRODUCTION_PLANT = new EntityField("ProductionPlant");
        @ElementName(value="MatlCompRequirementDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar matlCompRequirementDate;
        public static EntityField<Calendar, ProcessOrderComponent> MATL_COMP_REQUIREMENT_DATE = new EntityField("MatlCompRequirementDate");
        @ElementName(value="BaseUnit")
        private String baseUnit;
        public static EntityField<String, ProcessOrderComponent> BASE_UNIT = new EntityField("BaseUnit");
        private static final transient String ODATA_ENDPOINT_URL = "/sap/opu/odata/sap/API_PROCESS_ORDERS";
        private static final transient String ODATA_ENTITY_COLLECTION = "A_ProcessOrderComponent";
        private transient ErpConfigContext erpConfigContext;

        public String toString() {
            return "ReadProcessOrdersNamespace.ProcessOrderComponent(reservation=" + this.reservation + ", requiredQuantity=" + this.requiredQuantity + ", withdrawnQuantity=" + this.withdrawnQuantity + ", bOMItem=" + this.bOMItem + ", storageLocation=" + this.storageLocation + ", supplyArea=" + this.supplyArea + ", manufacturingOrderSequence=" + this.manufacturingOrderSequence + ", manufacturingOrder=" + this.manufacturingOrder + ", manufacturingOrderOperation=" + this.manufacturingOrderOperation + ", manufacturingOrderCategory=" + this.manufacturingOrderCategory + ", manufacturingOrderType=" + this.manufacturingOrderType + ", reservationItem=" + this.reservationItem + ", orderInternalBillOfOperations=" + this.orderInternalBillOfOperations + ", billOfMaterialItemNumber=" + this.billOfMaterialItemNumber + ", bOMItemDescription=" + this.bOMItemDescription + ", material=" + this.material + ", plant=" + this.plant + ", productionPlant=" + this.productionPlant + ", matlCompRequirementDate=" + this.matlCompRequirementDate + ", baseUnit=" + this.baseUnit + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProcessOrderComponent)) {
                return false;
            }
            ProcessOrderComponent other = (ProcessOrderComponent)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$reservation = this.reservation;
            String other$reservation = other.reservation;
            if (this$reservation == null ? other$reservation != null : !this$reservation.equals(other$reservation)) {
                return false;
            }
            BigDecimal this$requiredQuantity = this.requiredQuantity;
            BigDecimal other$requiredQuantity = other.requiredQuantity;
            if (this$requiredQuantity == null ? other$requiredQuantity != null : !((Object)this$requiredQuantity).equals(other$requiredQuantity)) {
                return false;
            }
            BigDecimal this$withdrawnQuantity = this.withdrawnQuantity;
            BigDecimal other$withdrawnQuantity = other.withdrawnQuantity;
            if (this$withdrawnQuantity == null ? other$withdrawnQuantity != null : !((Object)this$withdrawnQuantity).equals(other$withdrawnQuantity)) {
                return false;
            }
            String this$bOMItem = this.bOMItem;
            String other$bOMItem = other.bOMItem;
            if (this$bOMItem == null ? other$bOMItem != null : !this$bOMItem.equals(other$bOMItem)) {
                return false;
            }
            String this$storageLocation = this.storageLocation;
            String other$storageLocation = other.storageLocation;
            if (this$storageLocation == null ? other$storageLocation != null : !this$storageLocation.equals(other$storageLocation)) {
                return false;
            }
            String this$supplyArea = this.supplyArea;
            String other$supplyArea = other.supplyArea;
            if (this$supplyArea == null ? other$supplyArea != null : !this$supplyArea.equals(other$supplyArea)) {
                return false;
            }
            String this$manufacturingOrderSequence = this.manufacturingOrderSequence;
            String other$manufacturingOrderSequence = other.manufacturingOrderSequence;
            if (this$manufacturingOrderSequence == null ? other$manufacturingOrderSequence != null : !this$manufacturingOrderSequence.equals(other$manufacturingOrderSequence)) {
                return false;
            }
            String this$manufacturingOrder = this.manufacturingOrder;
            String other$manufacturingOrder = other.manufacturingOrder;
            if (this$manufacturingOrder == null ? other$manufacturingOrder != null : !this$manufacturingOrder.equals(other$manufacturingOrder)) {
                return false;
            }
            String this$manufacturingOrderOperation = this.manufacturingOrderOperation;
            String other$manufacturingOrderOperation = other.manufacturingOrderOperation;
            if (this$manufacturingOrderOperation == null ? other$manufacturingOrderOperation != null : !this$manufacturingOrderOperation.equals(other$manufacturingOrderOperation)) {
                return false;
            }
            String this$manufacturingOrderCategory = this.manufacturingOrderCategory;
            String other$manufacturingOrderCategory = other.manufacturingOrderCategory;
            if (this$manufacturingOrderCategory == null ? other$manufacturingOrderCategory != null : !this$manufacturingOrderCategory.equals(other$manufacturingOrderCategory)) {
                return false;
            }
            String this$manufacturingOrderType = this.manufacturingOrderType;
            String other$manufacturingOrderType = other.manufacturingOrderType;
            if (this$manufacturingOrderType == null ? other$manufacturingOrderType != null : !this$manufacturingOrderType.equals(other$manufacturingOrderType)) {
                return false;
            }
            String this$reservationItem = this.reservationItem;
            String other$reservationItem = other.reservationItem;
            if (this$reservationItem == null ? other$reservationItem != null : !this$reservationItem.equals(other$reservationItem)) {
                return false;
            }
            String this$orderInternalBillOfOperations = this.orderInternalBillOfOperations;
            String other$orderInternalBillOfOperations = other.orderInternalBillOfOperations;
            if (this$orderInternalBillOfOperations == null ? other$orderInternalBillOfOperations != null : !this$orderInternalBillOfOperations.equals(other$orderInternalBillOfOperations)) {
                return false;
            }
            String this$billOfMaterialItemNumber = this.billOfMaterialItemNumber;
            String other$billOfMaterialItemNumber = other.billOfMaterialItemNumber;
            if (this$billOfMaterialItemNumber == null ? other$billOfMaterialItemNumber != null : !this$billOfMaterialItemNumber.equals(other$billOfMaterialItemNumber)) {
                return false;
            }
            String this$bOMItemDescription = this.bOMItemDescription;
            String other$bOMItemDescription = other.bOMItemDescription;
            if (this$bOMItemDescription == null ? other$bOMItemDescription != null : !this$bOMItemDescription.equals(other$bOMItemDescription)) {
                return false;
            }
            String this$material = this.material;
            String other$material = other.material;
            if (this$material == null ? other$material != null : !this$material.equals(other$material)) {
                return false;
            }
            String this$plant = this.plant;
            String other$plant = other.plant;
            if (this$plant == null ? other$plant != null : !this$plant.equals(other$plant)) {
                return false;
            }
            String this$productionPlant = this.productionPlant;
            String other$productionPlant = other.productionPlant;
            if (this$productionPlant == null ? other$productionPlant != null : !this$productionPlant.equals(other$productionPlant)) {
                return false;
            }
            Calendar this$matlCompRequirementDate = this.matlCompRequirementDate;
            Calendar other$matlCompRequirementDate = other.matlCompRequirementDate;
            if (this$matlCompRequirementDate == null ? other$matlCompRequirementDate != null : !((Object)this$matlCompRequirementDate).equals(other$matlCompRequirementDate)) {
                return false;
            }
            String this$baseUnit = this.baseUnit;
            String other$baseUnit = other.baseUnit;
            return !(this$baseUnit == null ? other$baseUnit != null : !this$baseUnit.equals(other$baseUnit));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ProcessOrderComponent;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $reservation = this.reservation;
            result = result * 59 + ($reservation == null ? 43 : $reservation.hashCode());
            BigDecimal $requiredQuantity = this.requiredQuantity;
            result = result * 59 + ($requiredQuantity == null ? 43 : ((Object)$requiredQuantity).hashCode());
            BigDecimal $withdrawnQuantity = this.withdrawnQuantity;
            result = result * 59 + ($withdrawnQuantity == null ? 43 : ((Object)$withdrawnQuantity).hashCode());
            String $bOMItem = this.bOMItem;
            result = result * 59 + ($bOMItem == null ? 43 : $bOMItem.hashCode());
            String $storageLocation = this.storageLocation;
            result = result * 59 + ($storageLocation == null ? 43 : $storageLocation.hashCode());
            String $supplyArea = this.supplyArea;
            result = result * 59 + ($supplyArea == null ? 43 : $supplyArea.hashCode());
            String $manufacturingOrderSequence = this.manufacturingOrderSequence;
            result = result * 59 + ($manufacturingOrderSequence == null ? 43 : $manufacturingOrderSequence.hashCode());
            String $manufacturingOrder = this.manufacturingOrder;
            result = result * 59 + ($manufacturingOrder == null ? 43 : $manufacturingOrder.hashCode());
            String $manufacturingOrderOperation = this.manufacturingOrderOperation;
            result = result * 59 + ($manufacturingOrderOperation == null ? 43 : $manufacturingOrderOperation.hashCode());
            String $manufacturingOrderCategory = this.manufacturingOrderCategory;
            result = result * 59 + ($manufacturingOrderCategory == null ? 43 : $manufacturingOrderCategory.hashCode());
            String $manufacturingOrderType = this.manufacturingOrderType;
            result = result * 59 + ($manufacturingOrderType == null ? 43 : $manufacturingOrderType.hashCode());
            String $reservationItem = this.reservationItem;
            result = result * 59 + ($reservationItem == null ? 43 : $reservationItem.hashCode());
            String $orderInternalBillOfOperations = this.orderInternalBillOfOperations;
            result = result * 59 + ($orderInternalBillOfOperations == null ? 43 : $orderInternalBillOfOperations.hashCode());
            String $billOfMaterialItemNumber = this.billOfMaterialItemNumber;
            result = result * 59 + ($billOfMaterialItemNumber == null ? 43 : $billOfMaterialItemNumber.hashCode());
            String $bOMItemDescription = this.bOMItemDescription;
            result = result * 59 + ($bOMItemDescription == null ? 43 : $bOMItemDescription.hashCode());
            String $material = this.material;
            result = result * 59 + ($material == null ? 43 : $material.hashCode());
            String $plant = this.plant;
            result = result * 59 + ($plant == null ? 43 : $plant.hashCode());
            String $productionPlant = this.productionPlant;
            result = result * 59 + ($productionPlant == null ? 43 : $productionPlant.hashCode());
            Calendar $matlCompRequirementDate = this.matlCompRequirementDate;
            result = result * 59 + ($matlCompRequirementDate == null ? 43 : ((Object)$matlCompRequirementDate).hashCode());
            String $baseUnit = this.baseUnit;
            result = result * 59 + ($baseUnit == null ? 43 : $baseUnit.hashCode());
            return result;
        }

        public String getReservation() {
            return this.reservation;
        }

        public ProcessOrderComponent setReservation(String reservation) {
            this.reservation = reservation;
            return this;
        }

        public BigDecimal getRequiredQuantity() {
            return this.requiredQuantity;
        }

        public ProcessOrderComponent setRequiredQuantity(BigDecimal requiredQuantity) {
            this.requiredQuantity = requiredQuantity;
            return this;
        }

        public BigDecimal getWithdrawnQuantity() {
            return this.withdrawnQuantity;
        }

        public ProcessOrderComponent setWithdrawnQuantity(BigDecimal withdrawnQuantity) {
            this.withdrawnQuantity = withdrawnQuantity;
            return this;
        }

        public String getBOMItem() {
            return this.bOMItem;
        }

        public ProcessOrderComponent setBOMItem(String bOMItem) {
            this.bOMItem = bOMItem;
            return this;
        }

        public String getStorageLocation() {
            return this.storageLocation;
        }

        public ProcessOrderComponent setStorageLocation(String storageLocation) {
            this.storageLocation = storageLocation;
            return this;
        }

        public String getSupplyArea() {
            return this.supplyArea;
        }

        public ProcessOrderComponent setSupplyArea(String supplyArea) {
            this.supplyArea = supplyArea;
            return this;
        }

        public String getManufacturingOrderSequence() {
            return this.manufacturingOrderSequence;
        }

        public ProcessOrderComponent setManufacturingOrderSequence(String manufacturingOrderSequence) {
            this.manufacturingOrderSequence = manufacturingOrderSequence;
            return this;
        }

        public String getManufacturingOrder() {
            return this.manufacturingOrder;
        }

        public ProcessOrderComponent setManufacturingOrder(String manufacturingOrder) {
            this.manufacturingOrder = manufacturingOrder;
            return this;
        }

        public String getManufacturingOrderOperation() {
            return this.manufacturingOrderOperation;
        }

        public ProcessOrderComponent setManufacturingOrderOperation(String manufacturingOrderOperation) {
            this.manufacturingOrderOperation = manufacturingOrderOperation;
            return this;
        }

        public String getManufacturingOrderCategory() {
            return this.manufacturingOrderCategory;
        }

        public ProcessOrderComponent setManufacturingOrderCategory(String manufacturingOrderCategory) {
            this.manufacturingOrderCategory = manufacturingOrderCategory;
            return this;
        }

        public String getManufacturingOrderType() {
            return this.manufacturingOrderType;
        }

        public ProcessOrderComponent setManufacturingOrderType(String manufacturingOrderType) {
            this.manufacturingOrderType = manufacturingOrderType;
            return this;
        }

        public String getReservationItem() {
            return this.reservationItem;
        }

        public ProcessOrderComponent setReservationItem(String reservationItem) {
            this.reservationItem = reservationItem;
            return this;
        }

        public String getOrderInternalBillOfOperations() {
            return this.orderInternalBillOfOperations;
        }

        public ProcessOrderComponent setOrderInternalBillOfOperations(String orderInternalBillOfOperations) {
            this.orderInternalBillOfOperations = orderInternalBillOfOperations;
            return this;
        }

        public String getBillOfMaterialItemNumber() {
            return this.billOfMaterialItemNumber;
        }

        public ProcessOrderComponent setBillOfMaterialItemNumber(String billOfMaterialItemNumber) {
            this.billOfMaterialItemNumber = billOfMaterialItemNumber;
            return this;
        }

        public String getBOMItemDescription() {
            return this.bOMItemDescription;
        }

        public ProcessOrderComponent setBOMItemDescription(String bOMItemDescription) {
            this.bOMItemDescription = bOMItemDescription;
            return this;
        }

        public String getMaterial() {
            return this.material;
        }

        public ProcessOrderComponent setMaterial(String material) {
            this.material = material;
            return this;
        }

        public String getPlant() {
            return this.plant;
        }

        public ProcessOrderComponent setPlant(String plant) {
            this.plant = plant;
            return this;
        }

        public String getProductionPlant() {
            return this.productionPlant;
        }

        public ProcessOrderComponent setProductionPlant(String productionPlant) {
            this.productionPlant = productionPlant;
            return this;
        }

        public Calendar getMatlCompRequirementDate() {
            return this.matlCompRequirementDate;
        }

        public ProcessOrderComponent setMatlCompRequirementDate(Calendar matlCompRequirementDate) {
            this.matlCompRequirementDate = matlCompRequirementDate;
            return this;
        }

        public String getBaseUnit() {
            return this.baseUnit;
        }

        public ProcessOrderComponent setBaseUnit(String baseUnit) {
            this.baseUnit = baseUnit;
            return this;
        }

        public ProcessOrderComponent setErpConfigContext(ErpConfigContext erpConfigContext) {
            this.erpConfigContext = erpConfigContext;
            return this;
        }
    }

    public static class ProcessOrderByKeyFluentHelper {
        private ODataQueryBuilder queryBuilder;
        private ErrorResultHandler<?> errorResultHandler;
        private List<Object> values = new LinkedList<Object>();

        public ProcessOrderByKeyFluentHelper(String processOrder) {
            this.values.add(processOrder);
            this.queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_PROCESS_ORDERS", (String)"A_ProcessOrder");
            HashMap<String, Object> keys = new HashMap<String, Object>();
            keys.put("ProcessOrder", this.values.get(0));
            this.queryBuilder.keys(keys);
        }

        @SafeVarargs
        public final ProcessOrderByKeyFluentHelper select(EntityField<?, ProcessOrder> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.build();
        }

        public ProcessOrderByKeyFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public ProcessOrder execute(ErpConfigContext erpConfigContext) throws ODataException {
            ProcessOrder entity = (ProcessOrder)this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).as(ProcessOrder.class);
            entity.setErpConfigContext(erpConfigContext);
            return entity;
        }
    }

    public static class ProcessOrder {
        @ElementName(value="ProcessOrder")
        private String processOrder;
        public static EntityField<String, ProcessOrder> PROCESS_ORDER = new EntityField("ProcessOrder");
        @ElementName(value="OrderIsDeleted")
        private String orderIsDeleted;
        public static EntityField<String, ProcessOrder> ORDER_IS_DELETED = new EntityField("OrderIsDeleted");
        @ElementName(value="OrderIsPreCosted")
        private String orderIsPreCosted;
        public static EntityField<String, ProcessOrder> ORDER_IS_PRE_COSTED = new EntityField("OrderIsPreCosted");
        @ElementName(value="SettlementRuleIsCreated")
        private String settlementRuleIsCreated;
        public static EntityField<String, ProcessOrder> SETTLEMENT_RULE_IS_CREATED = new EntityField("SettlementRuleIsCreated");
        @ElementName(value="OrderIsPartiallyReleased")
        private String orderIsPartiallyReleased;
        public static EntityField<String, ProcessOrder> ORDER_IS_PARTIALLY_RELEASED = new EntityField("OrderIsPartiallyReleased");
        @ElementName(value="OrderIsLocked")
        private String orderIsLocked;
        public static EntityField<String, ProcessOrder> ORDER_IS_LOCKED = new EntityField("OrderIsLocked");
        @ElementName(value="OrderIsTechnicallyCompleted")
        private String orderIsTechnicallyCompleted;
        public static EntityField<String, ProcessOrder> ORDER_IS_TECHNICALLY_COMPLETED = new EntityField("OrderIsTechnicallyCompleted");
        @ElementName(value="OrderIsClosed")
        private String orderIsClosed;
        public static EntityField<String, ProcessOrder> ORDER_IS_CLOSED = new EntityField("OrderIsClosed");
        @ElementName(value="OrderIsPartiallyDelivered")
        private String orderIsPartiallyDelivered;
        public static EntityField<String, ProcessOrder> ORDER_IS_PARTIALLY_DELIVERED = new EntityField("OrderIsPartiallyDelivered");
        @ElementName(value="OrderIsMarkedForDeletion")
        private String orderIsMarkedForDeletion;
        public static EntityField<String, ProcessOrder> ORDER_IS_MARKED_FOR_DELETION = new EntityField("OrderIsMarkedForDeletion");
        @ElementName(value="SettlementRuleIsCrtedManually")
        private String settlementRuleIsCrtedManually;
        public static EntityField<String, ProcessOrder> SETTLEMENT_RULE_IS_CRTED_MANUALLY = new EntityField("SettlementRuleIsCrtedManually");
        @ElementName(value="ProductionPlant")
        private String productionPlant;
        public static EntityField<String, ProcessOrder> PRODUCTION_PLANT = new EntityField("ProductionPlant");
        @ElementName(value="OrderIsScheduled")
        private String orderIsScheduled;
        public static EntityField<String, ProcessOrder> ORDER_IS_SCHEDULED = new EntityField("OrderIsScheduled");
        @ElementName(value="OrderHasGeneratedOperations")
        private String orderHasGeneratedOperations;
        public static EntityField<String, ProcessOrder> ORDER_HAS_GENERATED_OPERATIONS = new EntityField("OrderHasGeneratedOperations");
        @ElementName(value="OrderIsToBeHandledInBatches")
        private String orderIsToBeHandledInBatches;
        public static EntityField<String, ProcessOrder> ORDER_IS_TO_BE_HANDLED_IN_BATCHES = new EntityField("OrderIsToBeHandledInBatches");
        @ElementName(value="MaterialAvailyIsNotChecked")
        private String materialAvailyIsNotChecked;
        public static EntityField<String, ProcessOrder> MATERIAL_AVAILY_IS_NOT_CHECKED = new EntityField("MaterialAvailyIsNotChecked");
        @ElementName(value="Material")
        private String material;
        public static EntityField<String, ProcessOrder> MATERIAL = new EntityField("Material");
        @ElementName(value="MaterialName")
        private String materialName;
        public static EntityField<String, ProcessOrder> MATERIAL_NAME = new EntityField("MaterialName");
        @ElementName(value="ProductionUnit")
        private String productionUnit;
        public static EntityField<String, ProcessOrder> PRODUCTION_UNIT = new EntityField("ProductionUnit");
        @ElementName(value="TotalQuantity")
        private BigDecimal totalQuantity;
        public static EntityField<BigDecimal, ProcessOrder> TOTAL_QUANTITY = new EntityField("TotalQuantity");
        @ElementName(value="ManufacturingOrderType")
        private String manufacturingOrderType;
        public static EntityField<String, ProcessOrder> MANUFACTURING_ORDER_TYPE = new EntityField("ManufacturingOrderType");
        @ElementName(value="MRPArea")
        private String mRPArea;
        public static EntityField<String, ProcessOrder> M_R_P_AREA = new EntityField("MRPArea");
        @ElementName(value="OrderInternalBillOfOperations")
        private String orderInternalBillOfOperations;
        public static EntityField<String, ProcessOrder> ORDER_INTERNAL_BILL_OF_OPERATIONS = new EntityField("OrderInternalBillOfOperations");
        @ElementName(value="ManufacturingObject")
        private String manufacturingObject;
        public static EntityField<String, ProcessOrder> MANUFACTURING_OBJECT = new EntityField("ManufacturingObject");
        @ElementName(value="Plant")
        private String plant;
        public static EntityField<String, ProcessOrder> PLANT = new EntityField("Plant");
        @ElementName(value="MfgOrderConfirmedYieldQty")
        private BigDecimal mfgOrderConfirmedYieldQty;
        public static EntityField<BigDecimal, ProcessOrder> MFG_ORDER_CONFIRMED_YIELD_QTY = new EntityField("MfgOrderConfirmedYieldQty");
        @ElementName(value="MfgOrderPlannedStartDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar mfgOrderPlannedStartDate;
        public static EntityField<Calendar, ProcessOrder> MFG_ORDER_PLANNED_START_DATE = new EntityField("MfgOrderPlannedStartDate");
        @ElementName(value="MfgOrderPlannedStartTime")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar mfgOrderPlannedStartTime;
        public static EntityField<Calendar, ProcessOrder> MFG_ORDER_PLANNED_START_TIME = new EntityField("MfgOrderPlannedStartTime");
        @ElementName(value="MfgOrderPlannedEndDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar mfgOrderPlannedEndDate;
        public static EntityField<Calendar, ProcessOrder> MFG_ORDER_PLANNED_END_DATE = new EntityField("MfgOrderPlannedEndDate");
        @ElementName(value="MfgOrderPlannedEndTime")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar mfgOrderPlannedEndTime;
        public static EntityField<Calendar, ProcessOrder> MFG_ORDER_PLANNED_END_TIME = new EntityField("MfgOrderPlannedEndTime");
        @ElementName(value="MfgOrderScheduledStartDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar mfgOrderScheduledStartDate;
        public static EntityField<Calendar, ProcessOrder> MFG_ORDER_SCHEDULED_START_DATE = new EntityField("MfgOrderScheduledStartDate");
        @ElementName(value="MfgOrderScheduledStartTime")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar mfgOrderScheduledStartTime;
        public static EntityField<Calendar, ProcessOrder> MFG_ORDER_SCHEDULED_START_TIME = new EntityField("MfgOrderScheduledStartTime");
        @ElementName(value="MfgOrderScheduledEndDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar mfgOrderScheduledEndDate;
        public static EntityField<Calendar, ProcessOrder> MFG_ORDER_SCHEDULED_END_DATE = new EntityField("MfgOrderScheduledEndDate");
        @ElementName(value="OrderIsCreated")
        private String orderIsCreated;
        public static EntityField<String, ProcessOrder> ORDER_IS_CREATED = new EntityField("OrderIsCreated");
        @ElementName(value="MfgOrderScheduledEndTime")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar mfgOrderScheduledEndTime;
        public static EntityField<Calendar, ProcessOrder> MFG_ORDER_SCHEDULED_END_TIME = new EntityField("MfgOrderScheduledEndTime");
        @ElementName(value="SalesOrder")
        private String salesOrder;
        public static EntityField<String, ProcessOrder> SALES_ORDER = new EntityField("SalesOrder");
        @ElementName(value="SalesOrderItem")
        private String salesOrderItem;
        public static EntityField<String, ProcessOrder> SALES_ORDER_ITEM = new EntityField("SalesOrderItem");
        @ElementName(value="PlannedOrder")
        private String plannedOrder;
        public static EntityField<String, ProcessOrder> PLANNED_ORDER = new EntityField("PlannedOrder");
        @ElementName(value="CustomerName")
        private String customerName;
        public static EntityField<String, ProcessOrder> CUSTOMER_NAME = new EntityField("CustomerName");
        @ElementName(value="WBSElement")
        private String wBSElement;
        public static EntityField<String, ProcessOrder> W_B_S_ELEMENT = new EntityField("WBSElement");
        @ElementName(value="WBSElementInternalID")
        private String wBSElementInternalID;
        public static EntityField<String, ProcessOrder> W_B_S_ELEMENT_INTERNAL_I_D = new EntityField("WBSElementInternalID");
        @ElementName(value="WBSDescription")
        private String wBSDescription;
        public static EntityField<String, ProcessOrder> W_B_S_DESCRIPTION = new EntityField("WBSDescription");
        @ElementName(value="CompanyCode")
        private String companyCode;
        public static EntityField<String, ProcessOrder> COMPANY_CODE = new EntityField("CompanyCode");
        @ElementName(value="FunctionalArea")
        private String functionalArea;
        public static EntityField<String, ProcessOrder> FUNCTIONAL_AREA = new EntityField("FunctionalArea");
        @ElementName(value="OrderIsReleased")
        private String orderIsReleased;
        public static EntityField<String, ProcessOrder> ORDER_IS_RELEASED = new EntityField("OrderIsReleased");
        @ElementName(value="PlannedCostsCostingVariant")
        private String plannedCostsCostingVariant;
        public static EntityField<String, ProcessOrder> PLANNED_COSTS_COSTING_VARIANT = new EntityField("PlannedCostsCostingVariant");
        @ElementName(value="ActualCostsCostingVariant")
        private String actualCostsCostingVariant;
        public static EntityField<String, ProcessOrder> ACTUAL_COSTS_COSTING_VARIANT = new EntityField("ActualCostsCostingVariant");
        @ElementName(value="UserID")
        private String userID;
        public static EntityField<String, ProcessOrder> USER_I_D = new EntityField("UserID");
        @ElementName(value="ProductionVersion")
        private String productionVersion;
        public static EntityField<String, ProcessOrder> PRODUCTION_VERSION = new EntityField("ProductionVersion");
        @ElementName(value="MRPController")
        private String mRPController;
        public static EntityField<String, ProcessOrder> M_R_P_CONTROLLER = new EntityField("MRPController");
        @ElementName(value="ProductionSupervisor")
        private String productionSupervisor;
        public static EntityField<String, ProcessOrder> PRODUCTION_SUPERVISOR = new EntityField("ProductionSupervisor");
        @ElementName(value="ManufacturingOrderCategory")
        private String manufacturingOrderCategory;
        public static EntityField<String, ProcessOrder> MANUFACTURING_ORDER_CATEGORY = new EntityField("ManufacturingOrderCategory");
        @ElementName(value="OrderIsPrinted")
        private String orderIsPrinted;
        public static EntityField<String, ProcessOrder> ORDER_IS_PRINTED = new EntityField("OrderIsPrinted");
        @ElementName(value="OrderIsConfirmed")
        private String orderIsConfirmed;
        public static EntityField<String, ProcessOrder> ORDER_IS_CONFIRMED = new EntityField("OrderIsConfirmed");
        @ElementName(value="OrderIsPartiallyConfirmed")
        private String orderIsPartiallyConfirmed;
        public static EntityField<String, ProcessOrder> ORDER_IS_PARTIALLY_CONFIRMED = new EntityField("OrderIsPartiallyConfirmed");
        @ElementName(value="OrderIsDelivered")
        private String orderIsDelivered;
        public static EntityField<String, ProcessOrder> ORDER_IS_DELIVERED = new EntityField("OrderIsDelivered");
        private static final transient String ODATA_ENDPOINT_URL = "/sap/opu/odata/sap/API_PROCESS_ORDERS";
        private static final transient String ODATA_ENTITY_COLLECTION = "A_ProcessOrder";
        private transient ErpConfigContext erpConfigContext;

        @JsonIgnore
        public List<ProcessOrderComponent> fetchProcessOrderComponent() throws ODataException {
            StringBuilder odataResourceUrl = new StringBuilder(ODATA_ENTITY_COLLECTION);
            odataResourceUrl.append("(");
            odataResourceUrl.append("ProcessOrder=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.processOrder));
            odataResourceUrl.append(")/");
            odataResourceUrl.append("to_ProcessOrderComponent");
            ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)ODATA_ENDPOINT_URL, (String)odataResourceUrl.toString());
            ODataQuery query = builder.build();
            ErpEndpoint erpEndpoint = new ErpEndpoint(this.erpConfigContext);
            ODataQueryResult result = query.execute((WithDestinationName)erpEndpoint);
            List entityList = result.asList(ProcessOrderComponent.class);
            for (ProcessOrderComponent entity : entityList) {
                entity.setErpConfigContext(this.erpConfigContext);
            }
            return entityList;
        }

        @JsonIgnore
        public List<ProcessOrderItem> fetchProcessOrderItem() throws ODataException {
            StringBuilder odataResourceUrl = new StringBuilder(ODATA_ENTITY_COLLECTION);
            odataResourceUrl.append("(");
            odataResourceUrl.append("ProcessOrder=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.processOrder));
            odataResourceUrl.append(")/");
            odataResourceUrl.append("to_ProcessOrderItem");
            ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)ODATA_ENDPOINT_URL, (String)odataResourceUrl.toString());
            ODataQuery query = builder.build();
            ErpEndpoint erpEndpoint = new ErpEndpoint(this.erpConfigContext);
            ODataQueryResult result = query.execute((WithDestinationName)erpEndpoint);
            List entityList = result.asList(ProcessOrderItem.class);
            for (ProcessOrderItem entity : entityList) {
                entity.setErpConfigContext(this.erpConfigContext);
            }
            return entityList;
        }

        @JsonIgnore
        public List<ProcessOrderOperation> fetchProcessOrderOperation() throws ODataException {
            StringBuilder odataResourceUrl = new StringBuilder(ODATA_ENTITY_COLLECTION);
            odataResourceUrl.append("(");
            odataResourceUrl.append("ProcessOrder=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.processOrder));
            odataResourceUrl.append(")/");
            odataResourceUrl.append("to_ProcessOrderOperation");
            ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)ODATA_ENDPOINT_URL, (String)odataResourceUrl.toString());
            ODataQuery query = builder.build();
            ErpEndpoint erpEndpoint = new ErpEndpoint(this.erpConfigContext);
            ODataQueryResult result = query.execute((WithDestinationName)erpEndpoint);
            List entityList = result.asList(ProcessOrderOperation.class);
            for (ProcessOrderOperation entity : entityList) {
                entity.setErpConfigContext(this.erpConfigContext);
            }
            return entityList;
        }

        @JsonIgnore
        public List<ProcessOrderStatus> fetchProcessOrderStatus() throws ODataException {
            StringBuilder odataResourceUrl = new StringBuilder(ODATA_ENTITY_COLLECTION);
            odataResourceUrl.append("(");
            odataResourceUrl.append("ProcessOrder=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.processOrder));
            odataResourceUrl.append(")/");
            odataResourceUrl.append("to_ProcessOrderStatus");
            ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)ODATA_ENDPOINT_URL, (String)odataResourceUrl.toString());
            ODataQuery query = builder.build();
            ErpEndpoint erpEndpoint = new ErpEndpoint(this.erpConfigContext);
            ODataQueryResult result = query.execute((WithDestinationName)erpEndpoint);
            List entityList = result.asList(ProcessOrderStatus.class);
            for (ProcessOrderStatus entity : entityList) {
                entity.setErpConfigContext(this.erpConfigContext);
            }
            return entityList;
        }

        public String toString() {
            return "ReadProcessOrdersNamespace.ProcessOrder(processOrder=" + this.processOrder + ", orderIsDeleted=" + this.orderIsDeleted + ", orderIsPreCosted=" + this.orderIsPreCosted + ", settlementRuleIsCreated=" + this.settlementRuleIsCreated + ", orderIsPartiallyReleased=" + this.orderIsPartiallyReleased + ", orderIsLocked=" + this.orderIsLocked + ", orderIsTechnicallyCompleted=" + this.orderIsTechnicallyCompleted + ", orderIsClosed=" + this.orderIsClosed + ", orderIsPartiallyDelivered=" + this.orderIsPartiallyDelivered + ", orderIsMarkedForDeletion=" + this.orderIsMarkedForDeletion + ", settlementRuleIsCrtedManually=" + this.settlementRuleIsCrtedManually + ", productionPlant=" + this.productionPlant + ", orderIsScheduled=" + this.orderIsScheduled + ", orderHasGeneratedOperations=" + this.orderHasGeneratedOperations + ", orderIsToBeHandledInBatches=" + this.orderIsToBeHandledInBatches + ", materialAvailyIsNotChecked=" + this.materialAvailyIsNotChecked + ", material=" + this.material + ", materialName=" + this.materialName + ", productionUnit=" + this.productionUnit + ", totalQuantity=" + this.totalQuantity + ", manufacturingOrderType=" + this.manufacturingOrderType + ", mRPArea=" + this.mRPArea + ", orderInternalBillOfOperations=" + this.orderInternalBillOfOperations + ", manufacturingObject=" + this.manufacturingObject + ", plant=" + this.plant + ", mfgOrderConfirmedYieldQty=" + this.mfgOrderConfirmedYieldQty + ", mfgOrderPlannedStartDate=" + this.mfgOrderPlannedStartDate + ", mfgOrderPlannedStartTime=" + this.mfgOrderPlannedStartTime + ", mfgOrderPlannedEndDate=" + this.mfgOrderPlannedEndDate + ", mfgOrderPlannedEndTime=" + this.mfgOrderPlannedEndTime + ", mfgOrderScheduledStartDate=" + this.mfgOrderScheduledStartDate + ", mfgOrderScheduledStartTime=" + this.mfgOrderScheduledStartTime + ", mfgOrderScheduledEndDate=" + this.mfgOrderScheduledEndDate + ", orderIsCreated=" + this.orderIsCreated + ", mfgOrderScheduledEndTime=" + this.mfgOrderScheduledEndTime + ", salesOrder=" + this.salesOrder + ", salesOrderItem=" + this.salesOrderItem + ", plannedOrder=" + this.plannedOrder + ", customerName=" + this.customerName + ", wBSElement=" + this.wBSElement + ", wBSElementInternalID=" + this.wBSElementInternalID + ", wBSDescription=" + this.wBSDescription + ", companyCode=" + this.companyCode + ", functionalArea=" + this.functionalArea + ", orderIsReleased=" + this.orderIsReleased + ", plannedCostsCostingVariant=" + this.plannedCostsCostingVariant + ", actualCostsCostingVariant=" + this.actualCostsCostingVariant + ", userID=" + this.userID + ", productionVersion=" + this.productionVersion + ", mRPController=" + this.mRPController + ", productionSupervisor=" + this.productionSupervisor + ", manufacturingOrderCategory=" + this.manufacturingOrderCategory + ", orderIsPrinted=" + this.orderIsPrinted + ", orderIsConfirmed=" + this.orderIsConfirmed + ", orderIsPartiallyConfirmed=" + this.orderIsPartiallyConfirmed + ", orderIsDelivered=" + this.orderIsDelivered + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProcessOrder)) {
                return false;
            }
            ProcessOrder other = (ProcessOrder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$processOrder = this.processOrder;
            String other$processOrder = other.processOrder;
            if (this$processOrder == null ? other$processOrder != null : !this$processOrder.equals(other$processOrder)) {
                return false;
            }
            String this$orderIsDeleted = this.orderIsDeleted;
            String other$orderIsDeleted = other.orderIsDeleted;
            if (this$orderIsDeleted == null ? other$orderIsDeleted != null : !this$orderIsDeleted.equals(other$orderIsDeleted)) {
                return false;
            }
            String this$orderIsPreCosted = this.orderIsPreCosted;
            String other$orderIsPreCosted = other.orderIsPreCosted;
            if (this$orderIsPreCosted == null ? other$orderIsPreCosted != null : !this$orderIsPreCosted.equals(other$orderIsPreCosted)) {
                return false;
            }
            String this$settlementRuleIsCreated = this.settlementRuleIsCreated;
            String other$settlementRuleIsCreated = other.settlementRuleIsCreated;
            if (this$settlementRuleIsCreated == null ? other$settlementRuleIsCreated != null : !this$settlementRuleIsCreated.equals(other$settlementRuleIsCreated)) {
                return false;
            }
            String this$orderIsPartiallyReleased = this.orderIsPartiallyReleased;
            String other$orderIsPartiallyReleased = other.orderIsPartiallyReleased;
            if (this$orderIsPartiallyReleased == null ? other$orderIsPartiallyReleased != null : !this$orderIsPartiallyReleased.equals(other$orderIsPartiallyReleased)) {
                return false;
            }
            String this$orderIsLocked = this.orderIsLocked;
            String other$orderIsLocked = other.orderIsLocked;
            if (this$orderIsLocked == null ? other$orderIsLocked != null : !this$orderIsLocked.equals(other$orderIsLocked)) {
                return false;
            }
            String this$orderIsTechnicallyCompleted = this.orderIsTechnicallyCompleted;
            String other$orderIsTechnicallyCompleted = other.orderIsTechnicallyCompleted;
            if (this$orderIsTechnicallyCompleted == null ? other$orderIsTechnicallyCompleted != null : !this$orderIsTechnicallyCompleted.equals(other$orderIsTechnicallyCompleted)) {
                return false;
            }
            String this$orderIsClosed = this.orderIsClosed;
            String other$orderIsClosed = other.orderIsClosed;
            if (this$orderIsClosed == null ? other$orderIsClosed != null : !this$orderIsClosed.equals(other$orderIsClosed)) {
                return false;
            }
            String this$orderIsPartiallyDelivered = this.orderIsPartiallyDelivered;
            String other$orderIsPartiallyDelivered = other.orderIsPartiallyDelivered;
            if (this$orderIsPartiallyDelivered == null ? other$orderIsPartiallyDelivered != null : !this$orderIsPartiallyDelivered.equals(other$orderIsPartiallyDelivered)) {
                return false;
            }
            String this$orderIsMarkedForDeletion = this.orderIsMarkedForDeletion;
            String other$orderIsMarkedForDeletion = other.orderIsMarkedForDeletion;
            if (this$orderIsMarkedForDeletion == null ? other$orderIsMarkedForDeletion != null : !this$orderIsMarkedForDeletion.equals(other$orderIsMarkedForDeletion)) {
                return false;
            }
            String this$settlementRuleIsCrtedManually = this.settlementRuleIsCrtedManually;
            String other$settlementRuleIsCrtedManually = other.settlementRuleIsCrtedManually;
            if (this$settlementRuleIsCrtedManually == null ? other$settlementRuleIsCrtedManually != null : !this$settlementRuleIsCrtedManually.equals(other$settlementRuleIsCrtedManually)) {
                return false;
            }
            String this$productionPlant = this.productionPlant;
            String other$productionPlant = other.productionPlant;
            if (this$productionPlant == null ? other$productionPlant != null : !this$productionPlant.equals(other$productionPlant)) {
                return false;
            }
            String this$orderIsScheduled = this.orderIsScheduled;
            String other$orderIsScheduled = other.orderIsScheduled;
            if (this$orderIsScheduled == null ? other$orderIsScheduled != null : !this$orderIsScheduled.equals(other$orderIsScheduled)) {
                return false;
            }
            String this$orderHasGeneratedOperations = this.orderHasGeneratedOperations;
            String other$orderHasGeneratedOperations = other.orderHasGeneratedOperations;
            if (this$orderHasGeneratedOperations == null ? other$orderHasGeneratedOperations != null : !this$orderHasGeneratedOperations.equals(other$orderHasGeneratedOperations)) {
                return false;
            }
            String this$orderIsToBeHandledInBatches = this.orderIsToBeHandledInBatches;
            String other$orderIsToBeHandledInBatches = other.orderIsToBeHandledInBatches;
            if (this$orderIsToBeHandledInBatches == null ? other$orderIsToBeHandledInBatches != null : !this$orderIsToBeHandledInBatches.equals(other$orderIsToBeHandledInBatches)) {
                return false;
            }
            String this$materialAvailyIsNotChecked = this.materialAvailyIsNotChecked;
            String other$materialAvailyIsNotChecked = other.materialAvailyIsNotChecked;
            if (this$materialAvailyIsNotChecked == null ? other$materialAvailyIsNotChecked != null : !this$materialAvailyIsNotChecked.equals(other$materialAvailyIsNotChecked)) {
                return false;
            }
            String this$material = this.material;
            String other$material = other.material;
            if (this$material == null ? other$material != null : !this$material.equals(other$material)) {
                return false;
            }
            String this$materialName = this.materialName;
            String other$materialName = other.materialName;
            if (this$materialName == null ? other$materialName != null : !this$materialName.equals(other$materialName)) {
                return false;
            }
            String this$productionUnit = this.productionUnit;
            String other$productionUnit = other.productionUnit;
            if (this$productionUnit == null ? other$productionUnit != null : !this$productionUnit.equals(other$productionUnit)) {
                return false;
            }
            BigDecimal this$totalQuantity = this.totalQuantity;
            BigDecimal other$totalQuantity = other.totalQuantity;
            if (this$totalQuantity == null ? other$totalQuantity != null : !((Object)this$totalQuantity).equals(other$totalQuantity)) {
                return false;
            }
            String this$manufacturingOrderType = this.manufacturingOrderType;
            String other$manufacturingOrderType = other.manufacturingOrderType;
            if (this$manufacturingOrderType == null ? other$manufacturingOrderType != null : !this$manufacturingOrderType.equals(other$manufacturingOrderType)) {
                return false;
            }
            String this$mRPArea = this.mRPArea;
            String other$mRPArea = other.mRPArea;
            if (this$mRPArea == null ? other$mRPArea != null : !this$mRPArea.equals(other$mRPArea)) {
                return false;
            }
            String this$orderInternalBillOfOperations = this.orderInternalBillOfOperations;
            String other$orderInternalBillOfOperations = other.orderInternalBillOfOperations;
            if (this$orderInternalBillOfOperations == null ? other$orderInternalBillOfOperations != null : !this$orderInternalBillOfOperations.equals(other$orderInternalBillOfOperations)) {
                return false;
            }
            String this$manufacturingObject = this.manufacturingObject;
            String other$manufacturingObject = other.manufacturingObject;
            if (this$manufacturingObject == null ? other$manufacturingObject != null : !this$manufacturingObject.equals(other$manufacturingObject)) {
                return false;
            }
            String this$plant = this.plant;
            String other$plant = other.plant;
            if (this$plant == null ? other$plant != null : !this$plant.equals(other$plant)) {
                return false;
            }
            BigDecimal this$mfgOrderConfirmedYieldQty = this.mfgOrderConfirmedYieldQty;
            BigDecimal other$mfgOrderConfirmedYieldQty = other.mfgOrderConfirmedYieldQty;
            if (this$mfgOrderConfirmedYieldQty == null ? other$mfgOrderConfirmedYieldQty != null : !((Object)this$mfgOrderConfirmedYieldQty).equals(other$mfgOrderConfirmedYieldQty)) {
                return false;
            }
            Calendar this$mfgOrderPlannedStartDate = this.mfgOrderPlannedStartDate;
            Calendar other$mfgOrderPlannedStartDate = other.mfgOrderPlannedStartDate;
            if (this$mfgOrderPlannedStartDate == null ? other$mfgOrderPlannedStartDate != null : !((Object)this$mfgOrderPlannedStartDate).equals(other$mfgOrderPlannedStartDate)) {
                return false;
            }
            Calendar this$mfgOrderPlannedStartTime = this.mfgOrderPlannedStartTime;
            Calendar other$mfgOrderPlannedStartTime = other.mfgOrderPlannedStartTime;
            if (this$mfgOrderPlannedStartTime == null ? other$mfgOrderPlannedStartTime != null : !((Object)this$mfgOrderPlannedStartTime).equals(other$mfgOrderPlannedStartTime)) {
                return false;
            }
            Calendar this$mfgOrderPlannedEndDate = this.mfgOrderPlannedEndDate;
            Calendar other$mfgOrderPlannedEndDate = other.mfgOrderPlannedEndDate;
            if (this$mfgOrderPlannedEndDate == null ? other$mfgOrderPlannedEndDate != null : !((Object)this$mfgOrderPlannedEndDate).equals(other$mfgOrderPlannedEndDate)) {
                return false;
            }
            Calendar this$mfgOrderPlannedEndTime = this.mfgOrderPlannedEndTime;
            Calendar other$mfgOrderPlannedEndTime = other.mfgOrderPlannedEndTime;
            if (this$mfgOrderPlannedEndTime == null ? other$mfgOrderPlannedEndTime != null : !((Object)this$mfgOrderPlannedEndTime).equals(other$mfgOrderPlannedEndTime)) {
                return false;
            }
            Calendar this$mfgOrderScheduledStartDate = this.mfgOrderScheduledStartDate;
            Calendar other$mfgOrderScheduledStartDate = other.mfgOrderScheduledStartDate;
            if (this$mfgOrderScheduledStartDate == null ? other$mfgOrderScheduledStartDate != null : !((Object)this$mfgOrderScheduledStartDate).equals(other$mfgOrderScheduledStartDate)) {
                return false;
            }
            Calendar this$mfgOrderScheduledStartTime = this.mfgOrderScheduledStartTime;
            Calendar other$mfgOrderScheduledStartTime = other.mfgOrderScheduledStartTime;
            if (this$mfgOrderScheduledStartTime == null ? other$mfgOrderScheduledStartTime != null : !((Object)this$mfgOrderScheduledStartTime).equals(other$mfgOrderScheduledStartTime)) {
                return false;
            }
            Calendar this$mfgOrderScheduledEndDate = this.mfgOrderScheduledEndDate;
            Calendar other$mfgOrderScheduledEndDate = other.mfgOrderScheduledEndDate;
            if (this$mfgOrderScheduledEndDate == null ? other$mfgOrderScheduledEndDate != null : !((Object)this$mfgOrderScheduledEndDate).equals(other$mfgOrderScheduledEndDate)) {
                return false;
            }
            String this$orderIsCreated = this.orderIsCreated;
            String other$orderIsCreated = other.orderIsCreated;
            if (this$orderIsCreated == null ? other$orderIsCreated != null : !this$orderIsCreated.equals(other$orderIsCreated)) {
                return false;
            }
            Calendar this$mfgOrderScheduledEndTime = this.mfgOrderScheduledEndTime;
            Calendar other$mfgOrderScheduledEndTime = other.mfgOrderScheduledEndTime;
            if (this$mfgOrderScheduledEndTime == null ? other$mfgOrderScheduledEndTime != null : !((Object)this$mfgOrderScheduledEndTime).equals(other$mfgOrderScheduledEndTime)) {
                return false;
            }
            String this$salesOrder = this.salesOrder;
            String other$salesOrder = other.salesOrder;
            if (this$salesOrder == null ? other$salesOrder != null : !this$salesOrder.equals(other$salesOrder)) {
                return false;
            }
            String this$salesOrderItem = this.salesOrderItem;
            String other$salesOrderItem = other.salesOrderItem;
            if (this$salesOrderItem == null ? other$salesOrderItem != null : !this$salesOrderItem.equals(other$salesOrderItem)) {
                return false;
            }
            String this$plannedOrder = this.plannedOrder;
            String other$plannedOrder = other.plannedOrder;
            if (this$plannedOrder == null ? other$plannedOrder != null : !this$plannedOrder.equals(other$plannedOrder)) {
                return false;
            }
            String this$customerName = this.customerName;
            String other$customerName = other.customerName;
            if (this$customerName == null ? other$customerName != null : !this$customerName.equals(other$customerName)) {
                return false;
            }
            String this$wBSElement = this.wBSElement;
            String other$wBSElement = other.wBSElement;
            if (this$wBSElement == null ? other$wBSElement != null : !this$wBSElement.equals(other$wBSElement)) {
                return false;
            }
            String this$wBSElementInternalID = this.wBSElementInternalID;
            String other$wBSElementInternalID = other.wBSElementInternalID;
            if (this$wBSElementInternalID == null ? other$wBSElementInternalID != null : !this$wBSElementInternalID.equals(other$wBSElementInternalID)) {
                return false;
            }
            String this$wBSDescription = this.wBSDescription;
            String other$wBSDescription = other.wBSDescription;
            if (this$wBSDescription == null ? other$wBSDescription != null : !this$wBSDescription.equals(other$wBSDescription)) {
                return false;
            }
            String this$companyCode = this.companyCode;
            String other$companyCode = other.companyCode;
            if (this$companyCode == null ? other$companyCode != null : !this$companyCode.equals(other$companyCode)) {
                return false;
            }
            String this$functionalArea = this.functionalArea;
            String other$functionalArea = other.functionalArea;
            if (this$functionalArea == null ? other$functionalArea != null : !this$functionalArea.equals(other$functionalArea)) {
                return false;
            }
            String this$orderIsReleased = this.orderIsReleased;
            String other$orderIsReleased = other.orderIsReleased;
            if (this$orderIsReleased == null ? other$orderIsReleased != null : !this$orderIsReleased.equals(other$orderIsReleased)) {
                return false;
            }
            String this$plannedCostsCostingVariant = this.plannedCostsCostingVariant;
            String other$plannedCostsCostingVariant = other.plannedCostsCostingVariant;
            if (this$plannedCostsCostingVariant == null ? other$plannedCostsCostingVariant != null : !this$plannedCostsCostingVariant.equals(other$plannedCostsCostingVariant)) {
                return false;
            }
            String this$actualCostsCostingVariant = this.actualCostsCostingVariant;
            String other$actualCostsCostingVariant = other.actualCostsCostingVariant;
            if (this$actualCostsCostingVariant == null ? other$actualCostsCostingVariant != null : !this$actualCostsCostingVariant.equals(other$actualCostsCostingVariant)) {
                return false;
            }
            String this$userID = this.userID;
            String other$userID = other.userID;
            if (this$userID == null ? other$userID != null : !this$userID.equals(other$userID)) {
                return false;
            }
            String this$productionVersion = this.productionVersion;
            String other$productionVersion = other.productionVersion;
            if (this$productionVersion == null ? other$productionVersion != null : !this$productionVersion.equals(other$productionVersion)) {
                return false;
            }
            String this$mRPController = this.mRPController;
            String other$mRPController = other.mRPController;
            if (this$mRPController == null ? other$mRPController != null : !this$mRPController.equals(other$mRPController)) {
                return false;
            }
            String this$productionSupervisor = this.productionSupervisor;
            String other$productionSupervisor = other.productionSupervisor;
            if (this$productionSupervisor == null ? other$productionSupervisor != null : !this$productionSupervisor.equals(other$productionSupervisor)) {
                return false;
            }
            String this$manufacturingOrderCategory = this.manufacturingOrderCategory;
            String other$manufacturingOrderCategory = other.manufacturingOrderCategory;
            if (this$manufacturingOrderCategory == null ? other$manufacturingOrderCategory != null : !this$manufacturingOrderCategory.equals(other$manufacturingOrderCategory)) {
                return false;
            }
            String this$orderIsPrinted = this.orderIsPrinted;
            String other$orderIsPrinted = other.orderIsPrinted;
            if (this$orderIsPrinted == null ? other$orderIsPrinted != null : !this$orderIsPrinted.equals(other$orderIsPrinted)) {
                return false;
            }
            String this$orderIsConfirmed = this.orderIsConfirmed;
            String other$orderIsConfirmed = other.orderIsConfirmed;
            if (this$orderIsConfirmed == null ? other$orderIsConfirmed != null : !this$orderIsConfirmed.equals(other$orderIsConfirmed)) {
                return false;
            }
            String this$orderIsPartiallyConfirmed = this.orderIsPartiallyConfirmed;
            String other$orderIsPartiallyConfirmed = other.orderIsPartiallyConfirmed;
            if (this$orderIsPartiallyConfirmed == null ? other$orderIsPartiallyConfirmed != null : !this$orderIsPartiallyConfirmed.equals(other$orderIsPartiallyConfirmed)) {
                return false;
            }
            String this$orderIsDelivered = this.orderIsDelivered;
            String other$orderIsDelivered = other.orderIsDelivered;
            return !(this$orderIsDelivered == null ? other$orderIsDelivered != null : !this$orderIsDelivered.equals(other$orderIsDelivered));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ProcessOrder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $processOrder = this.processOrder;
            result = result * 59 + ($processOrder == null ? 43 : $processOrder.hashCode());
            String $orderIsDeleted = this.orderIsDeleted;
            result = result * 59 + ($orderIsDeleted == null ? 43 : $orderIsDeleted.hashCode());
            String $orderIsPreCosted = this.orderIsPreCosted;
            result = result * 59 + ($orderIsPreCosted == null ? 43 : $orderIsPreCosted.hashCode());
            String $settlementRuleIsCreated = this.settlementRuleIsCreated;
            result = result * 59 + ($settlementRuleIsCreated == null ? 43 : $settlementRuleIsCreated.hashCode());
            String $orderIsPartiallyReleased = this.orderIsPartiallyReleased;
            result = result * 59 + ($orderIsPartiallyReleased == null ? 43 : $orderIsPartiallyReleased.hashCode());
            String $orderIsLocked = this.orderIsLocked;
            result = result * 59 + ($orderIsLocked == null ? 43 : $orderIsLocked.hashCode());
            String $orderIsTechnicallyCompleted = this.orderIsTechnicallyCompleted;
            result = result * 59 + ($orderIsTechnicallyCompleted == null ? 43 : $orderIsTechnicallyCompleted.hashCode());
            String $orderIsClosed = this.orderIsClosed;
            result = result * 59 + ($orderIsClosed == null ? 43 : $orderIsClosed.hashCode());
            String $orderIsPartiallyDelivered = this.orderIsPartiallyDelivered;
            result = result * 59 + ($orderIsPartiallyDelivered == null ? 43 : $orderIsPartiallyDelivered.hashCode());
            String $orderIsMarkedForDeletion = this.orderIsMarkedForDeletion;
            result = result * 59 + ($orderIsMarkedForDeletion == null ? 43 : $orderIsMarkedForDeletion.hashCode());
            String $settlementRuleIsCrtedManually = this.settlementRuleIsCrtedManually;
            result = result * 59 + ($settlementRuleIsCrtedManually == null ? 43 : $settlementRuleIsCrtedManually.hashCode());
            String $productionPlant = this.productionPlant;
            result = result * 59 + ($productionPlant == null ? 43 : $productionPlant.hashCode());
            String $orderIsScheduled = this.orderIsScheduled;
            result = result * 59 + ($orderIsScheduled == null ? 43 : $orderIsScheduled.hashCode());
            String $orderHasGeneratedOperations = this.orderHasGeneratedOperations;
            result = result * 59 + ($orderHasGeneratedOperations == null ? 43 : $orderHasGeneratedOperations.hashCode());
            String $orderIsToBeHandledInBatches = this.orderIsToBeHandledInBatches;
            result = result * 59 + ($orderIsToBeHandledInBatches == null ? 43 : $orderIsToBeHandledInBatches.hashCode());
            String $materialAvailyIsNotChecked = this.materialAvailyIsNotChecked;
            result = result * 59 + ($materialAvailyIsNotChecked == null ? 43 : $materialAvailyIsNotChecked.hashCode());
            String $material = this.material;
            result = result * 59 + ($material == null ? 43 : $material.hashCode());
            String $materialName = this.materialName;
            result = result * 59 + ($materialName == null ? 43 : $materialName.hashCode());
            String $productionUnit = this.productionUnit;
            result = result * 59 + ($productionUnit == null ? 43 : $productionUnit.hashCode());
            BigDecimal $totalQuantity = this.totalQuantity;
            result = result * 59 + ($totalQuantity == null ? 43 : ((Object)$totalQuantity).hashCode());
            String $manufacturingOrderType = this.manufacturingOrderType;
            result = result * 59 + ($manufacturingOrderType == null ? 43 : $manufacturingOrderType.hashCode());
            String $mRPArea = this.mRPArea;
            result = result * 59 + ($mRPArea == null ? 43 : $mRPArea.hashCode());
            String $orderInternalBillOfOperations = this.orderInternalBillOfOperations;
            result = result * 59 + ($orderInternalBillOfOperations == null ? 43 : $orderInternalBillOfOperations.hashCode());
            String $manufacturingObject = this.manufacturingObject;
            result = result * 59 + ($manufacturingObject == null ? 43 : $manufacturingObject.hashCode());
            String $plant = this.plant;
            result = result * 59 + ($plant == null ? 43 : $plant.hashCode());
            BigDecimal $mfgOrderConfirmedYieldQty = this.mfgOrderConfirmedYieldQty;
            result = result * 59 + ($mfgOrderConfirmedYieldQty == null ? 43 : ((Object)$mfgOrderConfirmedYieldQty).hashCode());
            Calendar $mfgOrderPlannedStartDate = this.mfgOrderPlannedStartDate;
            result = result * 59 + ($mfgOrderPlannedStartDate == null ? 43 : ((Object)$mfgOrderPlannedStartDate).hashCode());
            Calendar $mfgOrderPlannedStartTime = this.mfgOrderPlannedStartTime;
            result = result * 59 + ($mfgOrderPlannedStartTime == null ? 43 : ((Object)$mfgOrderPlannedStartTime).hashCode());
            Calendar $mfgOrderPlannedEndDate = this.mfgOrderPlannedEndDate;
            result = result * 59 + ($mfgOrderPlannedEndDate == null ? 43 : ((Object)$mfgOrderPlannedEndDate).hashCode());
            Calendar $mfgOrderPlannedEndTime = this.mfgOrderPlannedEndTime;
            result = result * 59 + ($mfgOrderPlannedEndTime == null ? 43 : ((Object)$mfgOrderPlannedEndTime).hashCode());
            Calendar $mfgOrderScheduledStartDate = this.mfgOrderScheduledStartDate;
            result = result * 59 + ($mfgOrderScheduledStartDate == null ? 43 : ((Object)$mfgOrderScheduledStartDate).hashCode());
            Calendar $mfgOrderScheduledStartTime = this.mfgOrderScheduledStartTime;
            result = result * 59 + ($mfgOrderScheduledStartTime == null ? 43 : ((Object)$mfgOrderScheduledStartTime).hashCode());
            Calendar $mfgOrderScheduledEndDate = this.mfgOrderScheduledEndDate;
            result = result * 59 + ($mfgOrderScheduledEndDate == null ? 43 : ((Object)$mfgOrderScheduledEndDate).hashCode());
            String $orderIsCreated = this.orderIsCreated;
            result = result * 59 + ($orderIsCreated == null ? 43 : $orderIsCreated.hashCode());
            Calendar $mfgOrderScheduledEndTime = this.mfgOrderScheduledEndTime;
            result = result * 59 + ($mfgOrderScheduledEndTime == null ? 43 : ((Object)$mfgOrderScheduledEndTime).hashCode());
            String $salesOrder = this.salesOrder;
            result = result * 59 + ($salesOrder == null ? 43 : $salesOrder.hashCode());
            String $salesOrderItem = this.salesOrderItem;
            result = result * 59 + ($salesOrderItem == null ? 43 : $salesOrderItem.hashCode());
            String $plannedOrder = this.plannedOrder;
            result = result * 59 + ($plannedOrder == null ? 43 : $plannedOrder.hashCode());
            String $customerName = this.customerName;
            result = result * 59 + ($customerName == null ? 43 : $customerName.hashCode());
            String $wBSElement = this.wBSElement;
            result = result * 59 + ($wBSElement == null ? 43 : $wBSElement.hashCode());
            String $wBSElementInternalID = this.wBSElementInternalID;
            result = result * 59 + ($wBSElementInternalID == null ? 43 : $wBSElementInternalID.hashCode());
            String $wBSDescription = this.wBSDescription;
            result = result * 59 + ($wBSDescription == null ? 43 : $wBSDescription.hashCode());
            String $companyCode = this.companyCode;
            result = result * 59 + ($companyCode == null ? 43 : $companyCode.hashCode());
            String $functionalArea = this.functionalArea;
            result = result * 59 + ($functionalArea == null ? 43 : $functionalArea.hashCode());
            String $orderIsReleased = this.orderIsReleased;
            result = result * 59 + ($orderIsReleased == null ? 43 : $orderIsReleased.hashCode());
            String $plannedCostsCostingVariant = this.plannedCostsCostingVariant;
            result = result * 59 + ($plannedCostsCostingVariant == null ? 43 : $plannedCostsCostingVariant.hashCode());
            String $actualCostsCostingVariant = this.actualCostsCostingVariant;
            result = result * 59 + ($actualCostsCostingVariant == null ? 43 : $actualCostsCostingVariant.hashCode());
            String $userID = this.userID;
            result = result * 59 + ($userID == null ? 43 : $userID.hashCode());
            String $productionVersion = this.productionVersion;
            result = result * 59 + ($productionVersion == null ? 43 : $productionVersion.hashCode());
            String $mRPController = this.mRPController;
            result = result * 59 + ($mRPController == null ? 43 : $mRPController.hashCode());
            String $productionSupervisor = this.productionSupervisor;
            result = result * 59 + ($productionSupervisor == null ? 43 : $productionSupervisor.hashCode());
            String $manufacturingOrderCategory = this.manufacturingOrderCategory;
            result = result * 59 + ($manufacturingOrderCategory == null ? 43 : $manufacturingOrderCategory.hashCode());
            String $orderIsPrinted = this.orderIsPrinted;
            result = result * 59 + ($orderIsPrinted == null ? 43 : $orderIsPrinted.hashCode());
            String $orderIsConfirmed = this.orderIsConfirmed;
            result = result * 59 + ($orderIsConfirmed == null ? 43 : $orderIsConfirmed.hashCode());
            String $orderIsPartiallyConfirmed = this.orderIsPartiallyConfirmed;
            result = result * 59 + ($orderIsPartiallyConfirmed == null ? 43 : $orderIsPartiallyConfirmed.hashCode());
            String $orderIsDelivered = this.orderIsDelivered;
            result = result * 59 + ($orderIsDelivered == null ? 43 : $orderIsDelivered.hashCode());
            return result;
        }

        public String getProcessOrder() {
            return this.processOrder;
        }

        public ProcessOrder setProcessOrder(String processOrder) {
            this.processOrder = processOrder;
            return this;
        }

        public String getOrderIsDeleted() {
            return this.orderIsDeleted;
        }

        public ProcessOrder setOrderIsDeleted(String orderIsDeleted) {
            this.orderIsDeleted = orderIsDeleted;
            return this;
        }

        public String getOrderIsPreCosted() {
            return this.orderIsPreCosted;
        }

        public ProcessOrder setOrderIsPreCosted(String orderIsPreCosted) {
            this.orderIsPreCosted = orderIsPreCosted;
            return this;
        }

        public String getSettlementRuleIsCreated() {
            return this.settlementRuleIsCreated;
        }

        public ProcessOrder setSettlementRuleIsCreated(String settlementRuleIsCreated) {
            this.settlementRuleIsCreated = settlementRuleIsCreated;
            return this;
        }

        public String getOrderIsPartiallyReleased() {
            return this.orderIsPartiallyReleased;
        }

        public ProcessOrder setOrderIsPartiallyReleased(String orderIsPartiallyReleased) {
            this.orderIsPartiallyReleased = orderIsPartiallyReleased;
            return this;
        }

        public String getOrderIsLocked() {
            return this.orderIsLocked;
        }

        public ProcessOrder setOrderIsLocked(String orderIsLocked) {
            this.orderIsLocked = orderIsLocked;
            return this;
        }

        public String getOrderIsTechnicallyCompleted() {
            return this.orderIsTechnicallyCompleted;
        }

        public ProcessOrder setOrderIsTechnicallyCompleted(String orderIsTechnicallyCompleted) {
            this.orderIsTechnicallyCompleted = orderIsTechnicallyCompleted;
            return this;
        }

        public String getOrderIsClosed() {
            return this.orderIsClosed;
        }

        public ProcessOrder setOrderIsClosed(String orderIsClosed) {
            this.orderIsClosed = orderIsClosed;
            return this;
        }

        public String getOrderIsPartiallyDelivered() {
            return this.orderIsPartiallyDelivered;
        }

        public ProcessOrder setOrderIsPartiallyDelivered(String orderIsPartiallyDelivered) {
            this.orderIsPartiallyDelivered = orderIsPartiallyDelivered;
            return this;
        }

        public String getOrderIsMarkedForDeletion() {
            return this.orderIsMarkedForDeletion;
        }

        public ProcessOrder setOrderIsMarkedForDeletion(String orderIsMarkedForDeletion) {
            this.orderIsMarkedForDeletion = orderIsMarkedForDeletion;
            return this;
        }

        public String getSettlementRuleIsCrtedManually() {
            return this.settlementRuleIsCrtedManually;
        }

        public ProcessOrder setSettlementRuleIsCrtedManually(String settlementRuleIsCrtedManually) {
            this.settlementRuleIsCrtedManually = settlementRuleIsCrtedManually;
            return this;
        }

        public String getProductionPlant() {
            return this.productionPlant;
        }

        public ProcessOrder setProductionPlant(String productionPlant) {
            this.productionPlant = productionPlant;
            return this;
        }

        public String getOrderIsScheduled() {
            return this.orderIsScheduled;
        }

        public ProcessOrder setOrderIsScheduled(String orderIsScheduled) {
            this.orderIsScheduled = orderIsScheduled;
            return this;
        }

        public String getOrderHasGeneratedOperations() {
            return this.orderHasGeneratedOperations;
        }

        public ProcessOrder setOrderHasGeneratedOperations(String orderHasGeneratedOperations) {
            this.orderHasGeneratedOperations = orderHasGeneratedOperations;
            return this;
        }

        public String getOrderIsToBeHandledInBatches() {
            return this.orderIsToBeHandledInBatches;
        }

        public ProcessOrder setOrderIsToBeHandledInBatches(String orderIsToBeHandledInBatches) {
            this.orderIsToBeHandledInBatches = orderIsToBeHandledInBatches;
            return this;
        }

        public String getMaterialAvailyIsNotChecked() {
            return this.materialAvailyIsNotChecked;
        }

        public ProcessOrder setMaterialAvailyIsNotChecked(String materialAvailyIsNotChecked) {
            this.materialAvailyIsNotChecked = materialAvailyIsNotChecked;
            return this;
        }

        public String getMaterial() {
            return this.material;
        }

        public ProcessOrder setMaterial(String material) {
            this.material = material;
            return this;
        }

        public String getMaterialName() {
            return this.materialName;
        }

        public ProcessOrder setMaterialName(String materialName) {
            this.materialName = materialName;
            return this;
        }

        public String getProductionUnit() {
            return this.productionUnit;
        }

        public ProcessOrder setProductionUnit(String productionUnit) {
            this.productionUnit = productionUnit;
            return this;
        }

        public BigDecimal getTotalQuantity() {
            return this.totalQuantity;
        }

        public ProcessOrder setTotalQuantity(BigDecimal totalQuantity) {
            this.totalQuantity = totalQuantity;
            return this;
        }

        public String getManufacturingOrderType() {
            return this.manufacturingOrderType;
        }

        public ProcessOrder setManufacturingOrderType(String manufacturingOrderType) {
            this.manufacturingOrderType = manufacturingOrderType;
            return this;
        }

        public String getMRPArea() {
            return this.mRPArea;
        }

        public ProcessOrder setMRPArea(String mRPArea) {
            this.mRPArea = mRPArea;
            return this;
        }

        public String getOrderInternalBillOfOperations() {
            return this.orderInternalBillOfOperations;
        }

        public ProcessOrder setOrderInternalBillOfOperations(String orderInternalBillOfOperations) {
            this.orderInternalBillOfOperations = orderInternalBillOfOperations;
            return this;
        }

        public String getManufacturingObject() {
            return this.manufacturingObject;
        }

        public ProcessOrder setManufacturingObject(String manufacturingObject) {
            this.manufacturingObject = manufacturingObject;
            return this;
        }

        public String getPlant() {
            return this.plant;
        }

        public ProcessOrder setPlant(String plant) {
            this.plant = plant;
            return this;
        }

        public BigDecimal getMfgOrderConfirmedYieldQty() {
            return this.mfgOrderConfirmedYieldQty;
        }

        public ProcessOrder setMfgOrderConfirmedYieldQty(BigDecimal mfgOrderConfirmedYieldQty) {
            this.mfgOrderConfirmedYieldQty = mfgOrderConfirmedYieldQty;
            return this;
        }

        public Calendar getMfgOrderPlannedStartDate() {
            return this.mfgOrderPlannedStartDate;
        }

        public ProcessOrder setMfgOrderPlannedStartDate(Calendar mfgOrderPlannedStartDate) {
            this.mfgOrderPlannedStartDate = mfgOrderPlannedStartDate;
            return this;
        }

        public Calendar getMfgOrderPlannedStartTime() {
            return this.mfgOrderPlannedStartTime;
        }

        public ProcessOrder setMfgOrderPlannedStartTime(Calendar mfgOrderPlannedStartTime) {
            this.mfgOrderPlannedStartTime = mfgOrderPlannedStartTime;
            return this;
        }

        public Calendar getMfgOrderPlannedEndDate() {
            return this.mfgOrderPlannedEndDate;
        }

        public ProcessOrder setMfgOrderPlannedEndDate(Calendar mfgOrderPlannedEndDate) {
            this.mfgOrderPlannedEndDate = mfgOrderPlannedEndDate;
            return this;
        }

        public Calendar getMfgOrderPlannedEndTime() {
            return this.mfgOrderPlannedEndTime;
        }

        public ProcessOrder setMfgOrderPlannedEndTime(Calendar mfgOrderPlannedEndTime) {
            this.mfgOrderPlannedEndTime = mfgOrderPlannedEndTime;
            return this;
        }

        public Calendar getMfgOrderScheduledStartDate() {
            return this.mfgOrderScheduledStartDate;
        }

        public ProcessOrder setMfgOrderScheduledStartDate(Calendar mfgOrderScheduledStartDate) {
            this.mfgOrderScheduledStartDate = mfgOrderScheduledStartDate;
            return this;
        }

        public Calendar getMfgOrderScheduledStartTime() {
            return this.mfgOrderScheduledStartTime;
        }

        public ProcessOrder setMfgOrderScheduledStartTime(Calendar mfgOrderScheduledStartTime) {
            this.mfgOrderScheduledStartTime = mfgOrderScheduledStartTime;
            return this;
        }

        public Calendar getMfgOrderScheduledEndDate() {
            return this.mfgOrderScheduledEndDate;
        }

        public ProcessOrder setMfgOrderScheduledEndDate(Calendar mfgOrderScheduledEndDate) {
            this.mfgOrderScheduledEndDate = mfgOrderScheduledEndDate;
            return this;
        }

        public String getOrderIsCreated() {
            return this.orderIsCreated;
        }

        public ProcessOrder setOrderIsCreated(String orderIsCreated) {
            this.orderIsCreated = orderIsCreated;
            return this;
        }

        public Calendar getMfgOrderScheduledEndTime() {
            return this.mfgOrderScheduledEndTime;
        }

        public ProcessOrder setMfgOrderScheduledEndTime(Calendar mfgOrderScheduledEndTime) {
            this.mfgOrderScheduledEndTime = mfgOrderScheduledEndTime;
            return this;
        }

        public String getSalesOrder() {
            return this.salesOrder;
        }

        public ProcessOrder setSalesOrder(String salesOrder) {
            this.salesOrder = salesOrder;
            return this;
        }

        public String getSalesOrderItem() {
            return this.salesOrderItem;
        }

        public ProcessOrder setSalesOrderItem(String salesOrderItem) {
            this.salesOrderItem = salesOrderItem;
            return this;
        }

        public String getPlannedOrder() {
            return this.plannedOrder;
        }

        public ProcessOrder setPlannedOrder(String plannedOrder) {
            this.plannedOrder = plannedOrder;
            return this;
        }

        public String getCustomerName() {
            return this.customerName;
        }

        public ProcessOrder setCustomerName(String customerName) {
            this.customerName = customerName;
            return this;
        }

        public String getWBSElement() {
            return this.wBSElement;
        }

        public ProcessOrder setWBSElement(String wBSElement) {
            this.wBSElement = wBSElement;
            return this;
        }

        public String getWBSElementInternalID() {
            return this.wBSElementInternalID;
        }

        public ProcessOrder setWBSElementInternalID(String wBSElementInternalID) {
            this.wBSElementInternalID = wBSElementInternalID;
            return this;
        }

        public String getWBSDescription() {
            return this.wBSDescription;
        }

        public ProcessOrder setWBSDescription(String wBSDescription) {
            this.wBSDescription = wBSDescription;
            return this;
        }

        public String getCompanyCode() {
            return this.companyCode;
        }

        public ProcessOrder setCompanyCode(String companyCode) {
            this.companyCode = companyCode;
            return this;
        }

        public String getFunctionalArea() {
            return this.functionalArea;
        }

        public ProcessOrder setFunctionalArea(String functionalArea) {
            this.functionalArea = functionalArea;
            return this;
        }

        public String getOrderIsReleased() {
            return this.orderIsReleased;
        }

        public ProcessOrder setOrderIsReleased(String orderIsReleased) {
            this.orderIsReleased = orderIsReleased;
            return this;
        }

        public String getPlannedCostsCostingVariant() {
            return this.plannedCostsCostingVariant;
        }

        public ProcessOrder setPlannedCostsCostingVariant(String plannedCostsCostingVariant) {
            this.plannedCostsCostingVariant = plannedCostsCostingVariant;
            return this;
        }

        public String getActualCostsCostingVariant() {
            return this.actualCostsCostingVariant;
        }

        public ProcessOrder setActualCostsCostingVariant(String actualCostsCostingVariant) {
            this.actualCostsCostingVariant = actualCostsCostingVariant;
            return this;
        }

        public String getUserID() {
            return this.userID;
        }

        public ProcessOrder setUserID(String userID) {
            this.userID = userID;
            return this;
        }

        public String getProductionVersion() {
            return this.productionVersion;
        }

        public ProcessOrder setProductionVersion(String productionVersion) {
            this.productionVersion = productionVersion;
            return this;
        }

        public String getMRPController() {
            return this.mRPController;
        }

        public ProcessOrder setMRPController(String mRPController) {
            this.mRPController = mRPController;
            return this;
        }

        public String getProductionSupervisor() {
            return this.productionSupervisor;
        }

        public ProcessOrder setProductionSupervisor(String productionSupervisor) {
            this.productionSupervisor = productionSupervisor;
            return this;
        }

        public String getManufacturingOrderCategory() {
            return this.manufacturingOrderCategory;
        }

        public ProcessOrder setManufacturingOrderCategory(String manufacturingOrderCategory) {
            this.manufacturingOrderCategory = manufacturingOrderCategory;
            return this;
        }

        public String getOrderIsPrinted() {
            return this.orderIsPrinted;
        }

        public ProcessOrder setOrderIsPrinted(String orderIsPrinted) {
            this.orderIsPrinted = orderIsPrinted;
            return this;
        }

        public String getOrderIsConfirmed() {
            return this.orderIsConfirmed;
        }

        public ProcessOrder setOrderIsConfirmed(String orderIsConfirmed) {
            this.orderIsConfirmed = orderIsConfirmed;
            return this;
        }

        public String getOrderIsPartiallyConfirmed() {
            return this.orderIsPartiallyConfirmed;
        }

        public ProcessOrder setOrderIsPartiallyConfirmed(String orderIsPartiallyConfirmed) {
            this.orderIsPartiallyConfirmed = orderIsPartiallyConfirmed;
            return this;
        }

        public String getOrderIsDelivered() {
            return this.orderIsDelivered;
        }

        public ProcessOrder setOrderIsDelivered(String orderIsDelivered) {
            this.orderIsDelivered = orderIsDelivered;
            return this;
        }

        public ProcessOrder setErpConfigContext(ErpConfigContext erpConfigContext) {
            this.erpConfigContext = erpConfigContext;
            return this;
        }
    }
}

