/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.cloudplatform.connectivity.WithDestinationName;
import com.sap.cloud.sdk.odatav2.connectivity.ErrorResultHandler;
import com.sap.cloud.sdk.odatav2.connectivity.FilterExpression;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQuery;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQueryBuilder;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQueryResult;
import com.sap.cloud.sdk.odatav2.connectivity.ODataType;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.connectivity.ErpConfigContext;
import com.sap.cloud.sdk.s4hana.connectivity.ErpEndpoint;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.EntityField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ExpressionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.FilterExpressionWrapper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ODataBooleanAdapter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ODataCalendarAdapter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ODataTypeValueSerializer;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ODataVdmErrorResultHandler;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.Order;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public class ReadPlannedOrdersNamespace {

    public static class PlannedOrderFluentHelper {
        private ODataQueryBuilder queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_PLANNED_ORDERS", (String)"A_PlannedOrder");
        private ErrorResultHandler<?> errorResultHandler = new ODataVdmErrorResultHandler();

        public PlannedOrderFluentHelper filter(ExpressionFluentHelper<PlannedOrder> expression) {
            for (FilterExpressionWrapper<?> filterExpressionWrapper : expression.evaluate()) {
                Object comparisonValue = filterExpressionWrapper.getComparisonValue();
                if (comparisonValue instanceof Integer) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Integer)((Integer)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof String) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((String)((String)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Long) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Long)((Long)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Double) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Double)((Double)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Float) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Float)((Float)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDate) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDate)((LocalDate)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDateTime)((LocalDateTime)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Date) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Date)((Date)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof DateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((DateTime)((DateTime)comparisonValue))));
                    continue;
                }
                this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of(comparisonValue)));
            }
            return this;
        }

        public PlannedOrderFluentHelper orderBy(EntityField<?, PlannedOrder> field, Order order) {
            String orderingDirection = order == Order.ASC ? " asc" : " desc";
            this.queryBuilder.param("orderby", (Object)(field.getFieldName() + orderingDirection));
            return this;
        }

        @SafeVarargs
        public final PlannedOrderFluentHelper select(EntityField<?, PlannedOrder> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public PlannedOrderFluentHelper top(Number top) {
            this.queryBuilder.top(top);
            return this;
        }

        public PlannedOrderFluentHelper skip(Number skip) {
            this.queryBuilder.skip(skip);
            return this;
        }

        public PlannedOrderFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.errorHandler(this.errorResultHandler).build();
        }

        public List<PlannedOrder> execute(ErpConfigContext erpConfigContext) throws ODataException {
            List entityList = this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).asList(PlannedOrder.class);
            for (PlannedOrder entity : entityList) {
                entity.setErpConfigContext(erpConfigContext);
            }
            return entityList;
        }
    }

    public static class PlannedOrderComponentFluentHelper {
        private ODataQueryBuilder queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_PLANNED_ORDERS", (String)"A_PlannedOrderComponent");
        private ErrorResultHandler<?> errorResultHandler = new ODataVdmErrorResultHandler();

        public PlannedOrderComponentFluentHelper filter(ExpressionFluentHelper<PlannedOrderComponent> expression) {
            for (FilterExpressionWrapper<?> filterExpressionWrapper : expression.evaluate()) {
                Object comparisonValue = filterExpressionWrapper.getComparisonValue();
                if (comparisonValue instanceof Integer) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Integer)((Integer)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof String) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((String)((String)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Long) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Long)((Long)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Double) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Double)((Double)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Float) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Float)((Float)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDate) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDate)((LocalDate)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDateTime)((LocalDateTime)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Date) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Date)((Date)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof DateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((DateTime)((DateTime)comparisonValue))));
                    continue;
                }
                this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of(comparisonValue)));
            }
            return this;
        }

        public PlannedOrderComponentFluentHelper orderBy(EntityField<?, PlannedOrderComponent> field, Order order) {
            String orderingDirection = order == Order.ASC ? " asc" : " desc";
            this.queryBuilder.param("orderby", (Object)(field.getFieldName() + orderingDirection));
            return this;
        }

        @SafeVarargs
        public final PlannedOrderComponentFluentHelper select(EntityField<?, PlannedOrderComponent> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public PlannedOrderComponentFluentHelper top(Number top) {
            this.queryBuilder.top(top);
            return this;
        }

        public PlannedOrderComponentFluentHelper skip(Number skip) {
            this.queryBuilder.skip(skip);
            return this;
        }

        public PlannedOrderComponentFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.errorHandler(this.errorResultHandler).build();
        }

        public List<PlannedOrderComponent> execute(ErpConfigContext erpConfigContext) throws ODataException {
            List entityList = this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).asList(PlannedOrderComponent.class);
            for (PlannedOrderComponent entity : entityList) {
                entity.setErpConfigContext(erpConfigContext);
            }
            return entityList;
        }
    }

    public static class PlannedOrderComponentByKeyFluentHelper {
        private ODataQueryBuilder queryBuilder;
        private ErrorResultHandler<?> errorResultHandler;
        private List<Object> values = new LinkedList<Object>();

        public PlannedOrderComponentByKeyFluentHelper(String reservation, String reservationItem) {
            this.values.add(reservation);
            this.values.add(reservationItem);
            this.queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_PLANNED_ORDERS", (String)"A_PlannedOrderComponent");
            HashMap<String, Object> keys = new HashMap<String, Object>();
            keys.put("Reservation", this.values.get(0));
            keys.put("ReservationItem", this.values.get(1));
            this.queryBuilder.keys(keys);
        }

        @SafeVarargs
        public final PlannedOrderComponentByKeyFluentHelper select(EntityField<?, PlannedOrderComponent> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.build();
        }

        public PlannedOrderComponentByKeyFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public PlannedOrderComponent execute(ErpConfigContext erpConfigContext) throws ODataException {
            PlannedOrderComponent entity = (PlannedOrderComponent)this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).as(PlannedOrderComponent.class);
            entity.setErpConfigContext(erpConfigContext);
            return entity;
        }
    }

    public static class PlannedOrderComponent {
        @ElementName(value="Reservation")
        private String reservation;
        public static EntityField<String, PlannedOrderComponent> RESERVATION = new EntityField("Reservation");
        @ElementName(value="BaseUnit")
        private String baseUnit;
        public static EntityField<String, PlannedOrderComponent> BASE_UNIT = new EntityField("BaseUnit");
        @ElementName(value="WithdrawnQuantity")
        private BigDecimal withdrawnQuantity;
        public static EntityField<BigDecimal, PlannedOrderComponent> WITHDRAWN_QUANTITY = new EntityField("WithdrawnQuantity");
        @ElementName(value="Plant")
        private String plant;
        public static EntityField<String, PlannedOrderComponent> PLANT = new EntityField("Plant");
        @ElementName(value="StorageLocation")
        private String storageLocation;
        public static EntityField<String, PlannedOrderComponent> STORAGE_LOCATION = new EntityField("StorageLocation");
        @ElementName(value="SupplyArea")
        private String supplyArea;
        public static EntityField<String, PlannedOrderComponent> SUPPLY_AREA = new EntityField("SupplyArea");
        @ElementName(value="MRPController")
        private String mRPController;
        public static EntityField<String, PlannedOrderComponent> M_R_P_CONTROLLER = new EntityField("MRPController");
        @ElementName(value="ReservationItem")
        private String reservationItem;
        public static EntityField<String, PlannedOrderComponent> RESERVATION_ITEM = new EntityField("ReservationItem");
        @ElementName(value="PlannedOrder")
        private String plannedOrder;
        public static EntityField<String, PlannedOrderComponent> PLANNED_ORDER = new EntityField("PlannedOrder");
        @ElementName(value="BOMItem")
        private String bOMItem;
        public static EntityField<String, PlannedOrderComponent> B_O_M_ITEM = new EntityField("BOMItem");
        @ElementName(value="BOMItemDescription")
        private String bOMItemDescription;
        public static EntityField<String, PlannedOrderComponent> B_O_M_ITEM_DESCRIPTION = new EntityField("BOMItemDescription");
        @ElementName(value="BillOfMaterialCategory")
        private String billOfMaterialCategory;
        public static EntityField<String, PlannedOrderComponent> BILL_OF_MATERIAL_CATEGORY = new EntityField("BillOfMaterialCategory");
        @ElementName(value="Material")
        private String material;
        public static EntityField<String, PlannedOrderComponent> MATERIAL = new EntityField("Material");
        @ElementName(value="MatlCompRequirementDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar matlCompRequirementDate;
        public static EntityField<Calendar, PlannedOrderComponent> MATL_COMP_REQUIREMENT_DATE = new EntityField("MatlCompRequirementDate");
        @ElementName(value="RequiredQuantity")
        private BigDecimal requiredQuantity;
        public static EntityField<BigDecimal, PlannedOrderComponent> REQUIRED_QUANTITY = new EntityField("RequiredQuantity");
        private static final transient String ODATA_ENDPOINT_URL = "/sap/opu/odata/sap/API_PLANNED_ORDERS";
        private static final transient String ODATA_ENTITY_COLLECTION = "A_PlannedOrderComponent";
        private transient ErpConfigContext erpConfigContext;

        public String toString() {
            return "ReadPlannedOrdersNamespace.PlannedOrderComponent(reservation=" + this.reservation + ", baseUnit=" + this.baseUnit + ", withdrawnQuantity=" + this.withdrawnQuantity + ", plant=" + this.plant + ", storageLocation=" + this.storageLocation + ", supplyArea=" + this.supplyArea + ", mRPController=" + this.mRPController + ", reservationItem=" + this.reservationItem + ", plannedOrder=" + this.plannedOrder + ", bOMItem=" + this.bOMItem + ", bOMItemDescription=" + this.bOMItemDescription + ", billOfMaterialCategory=" + this.billOfMaterialCategory + ", material=" + this.material + ", matlCompRequirementDate=" + this.matlCompRequirementDate + ", requiredQuantity=" + this.requiredQuantity + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PlannedOrderComponent)) {
                return false;
            }
            PlannedOrderComponent other = (PlannedOrderComponent)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$reservation = this.reservation;
            String other$reservation = other.reservation;
            if (this$reservation == null ? other$reservation != null : !this$reservation.equals(other$reservation)) {
                return false;
            }
            String this$baseUnit = this.baseUnit;
            String other$baseUnit = other.baseUnit;
            if (this$baseUnit == null ? other$baseUnit != null : !this$baseUnit.equals(other$baseUnit)) {
                return false;
            }
            BigDecimal this$withdrawnQuantity = this.withdrawnQuantity;
            BigDecimal other$withdrawnQuantity = other.withdrawnQuantity;
            if (this$withdrawnQuantity == null ? other$withdrawnQuantity != null : !((Object)this$withdrawnQuantity).equals(other$withdrawnQuantity)) {
                return false;
            }
            String this$plant = this.plant;
            String other$plant = other.plant;
            if (this$plant == null ? other$plant != null : !this$plant.equals(other$plant)) {
                return false;
            }
            String this$storageLocation = this.storageLocation;
            String other$storageLocation = other.storageLocation;
            if (this$storageLocation == null ? other$storageLocation != null : !this$storageLocation.equals(other$storageLocation)) {
                return false;
            }
            String this$supplyArea = this.supplyArea;
            String other$supplyArea = other.supplyArea;
            if (this$supplyArea == null ? other$supplyArea != null : !this$supplyArea.equals(other$supplyArea)) {
                return false;
            }
            String this$mRPController = this.mRPController;
            String other$mRPController = other.mRPController;
            if (this$mRPController == null ? other$mRPController != null : !this$mRPController.equals(other$mRPController)) {
                return false;
            }
            String this$reservationItem = this.reservationItem;
            String other$reservationItem = other.reservationItem;
            if (this$reservationItem == null ? other$reservationItem != null : !this$reservationItem.equals(other$reservationItem)) {
                return false;
            }
            String this$plannedOrder = this.plannedOrder;
            String other$plannedOrder = other.plannedOrder;
            if (this$plannedOrder == null ? other$plannedOrder != null : !this$plannedOrder.equals(other$plannedOrder)) {
                return false;
            }
            String this$bOMItem = this.bOMItem;
            String other$bOMItem = other.bOMItem;
            if (this$bOMItem == null ? other$bOMItem != null : !this$bOMItem.equals(other$bOMItem)) {
                return false;
            }
            String this$bOMItemDescription = this.bOMItemDescription;
            String other$bOMItemDescription = other.bOMItemDescription;
            if (this$bOMItemDescription == null ? other$bOMItemDescription != null : !this$bOMItemDescription.equals(other$bOMItemDescription)) {
                return false;
            }
            String this$billOfMaterialCategory = this.billOfMaterialCategory;
            String other$billOfMaterialCategory = other.billOfMaterialCategory;
            if (this$billOfMaterialCategory == null ? other$billOfMaterialCategory != null : !this$billOfMaterialCategory.equals(other$billOfMaterialCategory)) {
                return false;
            }
            String this$material = this.material;
            String other$material = other.material;
            if (this$material == null ? other$material != null : !this$material.equals(other$material)) {
                return false;
            }
            Calendar this$matlCompRequirementDate = this.matlCompRequirementDate;
            Calendar other$matlCompRequirementDate = other.matlCompRequirementDate;
            if (this$matlCompRequirementDate == null ? other$matlCompRequirementDate != null : !((Object)this$matlCompRequirementDate).equals(other$matlCompRequirementDate)) {
                return false;
            }
            BigDecimal this$requiredQuantity = this.requiredQuantity;
            BigDecimal other$requiredQuantity = other.requiredQuantity;
            return !(this$requiredQuantity == null ? other$requiredQuantity != null : !((Object)this$requiredQuantity).equals(other$requiredQuantity));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PlannedOrderComponent;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $reservation = this.reservation;
            result = result * 59 + ($reservation == null ? 43 : $reservation.hashCode());
            String $baseUnit = this.baseUnit;
            result = result * 59 + ($baseUnit == null ? 43 : $baseUnit.hashCode());
            BigDecimal $withdrawnQuantity = this.withdrawnQuantity;
            result = result * 59 + ($withdrawnQuantity == null ? 43 : ((Object)$withdrawnQuantity).hashCode());
            String $plant = this.plant;
            result = result * 59 + ($plant == null ? 43 : $plant.hashCode());
            String $storageLocation = this.storageLocation;
            result = result * 59 + ($storageLocation == null ? 43 : $storageLocation.hashCode());
            String $supplyArea = this.supplyArea;
            result = result * 59 + ($supplyArea == null ? 43 : $supplyArea.hashCode());
            String $mRPController = this.mRPController;
            result = result * 59 + ($mRPController == null ? 43 : $mRPController.hashCode());
            String $reservationItem = this.reservationItem;
            result = result * 59 + ($reservationItem == null ? 43 : $reservationItem.hashCode());
            String $plannedOrder = this.plannedOrder;
            result = result * 59 + ($plannedOrder == null ? 43 : $plannedOrder.hashCode());
            String $bOMItem = this.bOMItem;
            result = result * 59 + ($bOMItem == null ? 43 : $bOMItem.hashCode());
            String $bOMItemDescription = this.bOMItemDescription;
            result = result * 59 + ($bOMItemDescription == null ? 43 : $bOMItemDescription.hashCode());
            String $billOfMaterialCategory = this.billOfMaterialCategory;
            result = result * 59 + ($billOfMaterialCategory == null ? 43 : $billOfMaterialCategory.hashCode());
            String $material = this.material;
            result = result * 59 + ($material == null ? 43 : $material.hashCode());
            Calendar $matlCompRequirementDate = this.matlCompRequirementDate;
            result = result * 59 + ($matlCompRequirementDate == null ? 43 : ((Object)$matlCompRequirementDate).hashCode());
            BigDecimal $requiredQuantity = this.requiredQuantity;
            result = result * 59 + ($requiredQuantity == null ? 43 : ((Object)$requiredQuantity).hashCode());
            return result;
        }

        public String getReservation() {
            return this.reservation;
        }

        public PlannedOrderComponent setReservation(String reservation) {
            this.reservation = reservation;
            return this;
        }

        public String getBaseUnit() {
            return this.baseUnit;
        }

        public PlannedOrderComponent setBaseUnit(String baseUnit) {
            this.baseUnit = baseUnit;
            return this;
        }

        public BigDecimal getWithdrawnQuantity() {
            return this.withdrawnQuantity;
        }

        public PlannedOrderComponent setWithdrawnQuantity(BigDecimal withdrawnQuantity) {
            this.withdrawnQuantity = withdrawnQuantity;
            return this;
        }

        public String getPlant() {
            return this.plant;
        }

        public PlannedOrderComponent setPlant(String plant) {
            this.plant = plant;
            return this;
        }

        public String getStorageLocation() {
            return this.storageLocation;
        }

        public PlannedOrderComponent setStorageLocation(String storageLocation) {
            this.storageLocation = storageLocation;
            return this;
        }

        public String getSupplyArea() {
            return this.supplyArea;
        }

        public PlannedOrderComponent setSupplyArea(String supplyArea) {
            this.supplyArea = supplyArea;
            return this;
        }

        public String getMRPController() {
            return this.mRPController;
        }

        public PlannedOrderComponent setMRPController(String mRPController) {
            this.mRPController = mRPController;
            return this;
        }

        public String getReservationItem() {
            return this.reservationItem;
        }

        public PlannedOrderComponent setReservationItem(String reservationItem) {
            this.reservationItem = reservationItem;
            return this;
        }

        public String getPlannedOrder() {
            return this.plannedOrder;
        }

        public PlannedOrderComponent setPlannedOrder(String plannedOrder) {
            this.plannedOrder = plannedOrder;
            return this;
        }

        public String getBOMItem() {
            return this.bOMItem;
        }

        public PlannedOrderComponent setBOMItem(String bOMItem) {
            this.bOMItem = bOMItem;
            return this;
        }

        public String getBOMItemDescription() {
            return this.bOMItemDescription;
        }

        public PlannedOrderComponent setBOMItemDescription(String bOMItemDescription) {
            this.bOMItemDescription = bOMItemDescription;
            return this;
        }

        public String getBillOfMaterialCategory() {
            return this.billOfMaterialCategory;
        }

        public PlannedOrderComponent setBillOfMaterialCategory(String billOfMaterialCategory) {
            this.billOfMaterialCategory = billOfMaterialCategory;
            return this;
        }

        public String getMaterial() {
            return this.material;
        }

        public PlannedOrderComponent setMaterial(String material) {
            this.material = material;
            return this;
        }

        public Calendar getMatlCompRequirementDate() {
            return this.matlCompRequirementDate;
        }

        public PlannedOrderComponent setMatlCompRequirementDate(Calendar matlCompRequirementDate) {
            this.matlCompRequirementDate = matlCompRequirementDate;
            return this;
        }

        public BigDecimal getRequiredQuantity() {
            return this.requiredQuantity;
        }

        public PlannedOrderComponent setRequiredQuantity(BigDecimal requiredQuantity) {
            this.requiredQuantity = requiredQuantity;
            return this;
        }

        public PlannedOrderComponent setErpConfigContext(ErpConfigContext erpConfigContext) {
            this.erpConfigContext = erpConfigContext;
            return this;
        }
    }

    public static class PlannedOrderByKeyFluentHelper {
        private ODataQueryBuilder queryBuilder;
        private ErrorResultHandler<?> errorResultHandler;
        private List<Object> values = new LinkedList<Object>();

        public PlannedOrderByKeyFluentHelper(String plannedOrder) {
            this.values.add(plannedOrder);
            this.queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_PLANNED_ORDERS", (String)"A_PlannedOrder");
            HashMap<String, Object> keys = new HashMap<String, Object>();
            keys.put("PlannedOrder", this.values.get(0));
            this.queryBuilder.keys(keys);
        }

        @SafeVarargs
        public final PlannedOrderByKeyFluentHelper select(EntityField<?, PlannedOrder> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.build();
        }

        public PlannedOrderByKeyFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public PlannedOrder execute(ErpConfigContext erpConfigContext) throws ODataException {
            PlannedOrder entity = (PlannedOrder)this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).as(PlannedOrder.class);
            entity.setErpConfigContext(erpConfigContext);
            return entity;
        }
    }

    public static class PlannedOrder {
        @ElementName(value="PlannedOrder")
        private String plannedOrder;
        public static EntityField<String, PlannedOrder> PLANNED_ORDER = new EntityField("PlannedOrder");
        @ElementName(value="BaseUnit")
        private String baseUnit;
        public static EntityField<String, PlannedOrder> BASE_UNIT = new EntityField("BaseUnit");
        @ElementName(value="PlndOrderPlannedStartDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar plndOrderPlannedStartDate;
        public static EntityField<Calendar, PlannedOrder> PLND_ORDER_PLANNED_START_DATE = new EntityField("PlndOrderPlannedStartDate");
        @ElementName(value="PlndOrderPlannedStartTime")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar plndOrderPlannedStartTime;
        public static EntityField<Calendar, PlannedOrder> PLND_ORDER_PLANNED_START_TIME = new EntityField("PlndOrderPlannedStartTime");
        @ElementName(value="PlndOrderPlannedEndDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar plndOrderPlannedEndDate;
        public static EntityField<Calendar, PlannedOrder> PLND_ORDER_PLANNED_END_DATE = new EntityField("PlndOrderPlannedEndDate");
        @ElementName(value="PlndOrderPlannedEndTime")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar plndOrderPlannedEndTime;
        public static EntityField<Calendar, PlannedOrder> PLND_ORDER_PLANNED_END_TIME = new EntityField("PlndOrderPlannedEndTime");
        @ElementName(value="PlannedOrderOpeningDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar plannedOrderOpeningDate;
        public static EntityField<Calendar, PlannedOrder> PLANNED_ORDER_OPENING_DATE = new EntityField("PlannedOrderOpeningDate");
        @ElementName(value="ProductionStartDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar productionStartDate;
        public static EntityField<Calendar, PlannedOrder> PRODUCTION_START_DATE = new EntityField("ProductionStartDate");
        @ElementName(value="ProductionEndDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar productionEndDate;
        public static EntityField<Calendar, PlannedOrder> PRODUCTION_END_DATE = new EntityField("ProductionEndDate");
        @ElementName(value="SalesOrder")
        private String salesOrder;
        public static EntityField<String, PlannedOrder> SALES_ORDER = new EntityField("SalesOrder");
        @ElementName(value="SalesOrderItem")
        private String salesOrderItem;
        public static EntityField<String, PlannedOrder> SALES_ORDER_ITEM = new EntityField("SalesOrderItem");
        @ElementName(value="PlannedOrderType")
        private String plannedOrderType;
        public static EntityField<String, PlannedOrder> PLANNED_ORDER_TYPE = new EntityField("PlannedOrderType");
        @ElementName(value="Customer")
        private String customer;
        public static EntityField<String, PlannedOrder> CUSTOMER = new EntityField("Customer");
        @ElementName(value="WBSElementInternalID")
        private String wBSElementInternalID;
        public static EntityField<String, PlannedOrder> W_B_S_ELEMENT_INTERNAL_I_D = new EntityField("WBSElementInternalID");
        @ElementName(value="WBSElement")
        private String wBSElement;
        public static EntityField<String, PlannedOrder> W_B_S_ELEMENT = new EntityField("WBSElement");
        @ElementName(value="WBSDescription")
        private String wBSDescription;
        public static EntityField<String, PlannedOrder> W_B_S_DESCRIPTION = new EntityField("WBSDescription");
        @ElementName(value="MRPController")
        private String mRPController;
        public static EntityField<String, PlannedOrder> M_R_P_CONTROLLER = new EntityField("MRPController");
        @ElementName(value="ProductionSupervisor")
        private String productionSupervisor;
        public static EntityField<String, PlannedOrder> PRODUCTION_SUPERVISOR = new EntityField("ProductionSupervisor");
        @ElementName(value="PurchasingGroup")
        private String purchasingGroup;
        public static EntityField<String, PlannedOrder> PURCHASING_GROUP = new EntityField("PurchasingGroup");
        @ElementName(value="PurchasingOrganization")
        private String purchasingOrganization;
        public static EntityField<String, PlannedOrder> PURCHASING_ORGANIZATION = new EntityField("PurchasingOrganization");
        @ElementName(value="FixedSupplier")
        private String fixedSupplier;
        public static EntityField<String, PlannedOrder> FIXED_SUPPLIER = new EntityField("FixedSupplier");
        @ElementName(value="PurchasingDocument")
        private String purchasingDocument;
        public static EntityField<String, PlannedOrder> PURCHASING_DOCUMENT = new EntityField("PurchasingDocument");
        @ElementName(value="Material")
        private String material;
        public static EntityField<String, PlannedOrder> MATERIAL = new EntityField("Material");
        @ElementName(value="PurchasingDocumentItem")
        private String purchasingDocumentItem;
        public static EntityField<String, PlannedOrder> PURCHASING_DOCUMENT_ITEM = new EntityField("PurchasingDocumentItem");
        @ElementName(value="QuotaArrangement")
        private String quotaArrangement;
        public static EntityField<String, PlannedOrder> QUOTA_ARRANGEMENT = new EntityField("QuotaArrangement");
        @ElementName(value="SupplierName")
        private String supplierName;
        public static EntityField<String, PlannedOrder> SUPPLIER_NAME = new EntityField("SupplierName");
        @ElementName(value="PlannedOrderIsFirm")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean plannedOrderIsFirm;
        public static EntityField<Boolean, PlannedOrder> PLANNED_ORDER_IS_FIRM = new EntityField("PlannedOrderIsFirm");
        @ElementName(value="PlannedOrderIsConvertible")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean plannedOrderIsConvertible;
        public static EntityField<Boolean, PlannedOrder> PLANNED_ORDER_IS_CONVERTIBLE = new EntityField("PlannedOrderIsConvertible");
        @ElementName(value="MaterialName")
        private String materialName;
        public static EntityField<String, PlannedOrder> MATERIAL_NAME = new EntityField("MaterialName");
        @ElementName(value="ProductionPlant")
        private String productionPlant;
        public static EntityField<String, PlannedOrder> PRODUCTION_PLANT = new EntityField("ProductionPlant");
        @ElementName(value="MRPPlant")
        private String mRPPlant;
        public static EntityField<String, PlannedOrder> M_R_P_PLANT = new EntityField("MRPPlant");
        @ElementName(value="MRPArea")
        private String mRPArea;
        public static EntityField<String, PlannedOrder> M_R_P_AREA = new EntityField("MRPArea");
        @ElementName(value="ProductionVersion")
        private String productionVersion;
        public static EntityField<String, PlannedOrder> PRODUCTION_VERSION = new EntityField("ProductionVersion");
        @ElementName(value="TotalQuantity")
        private BigDecimal totalQuantity;
        public static EntityField<BigDecimal, PlannedOrder> TOTAL_QUANTITY = new EntityField("TotalQuantity");
        private static final transient String ODATA_ENDPOINT_URL = "/sap/opu/odata/sap/API_PLANNED_ORDERS";
        private static final transient String ODATA_ENTITY_COLLECTION = "A_PlannedOrder";
        private transient ErpConfigContext erpConfigContext;

        @JsonIgnore
        public List<PlannedOrderComponent> fetchPlannedOrderComponent() throws ODataException {
            StringBuilder odataResourceUrl = new StringBuilder(ODATA_ENTITY_COLLECTION);
            odataResourceUrl.append("(");
            odataResourceUrl.append("PlannedOrder=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.plannedOrder));
            odataResourceUrl.append(")/");
            odataResourceUrl.append("to_PlannedOrderComponent");
            ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)ODATA_ENDPOINT_URL, (String)odataResourceUrl.toString());
            ODataQuery query = builder.build();
            ErpEndpoint erpEndpoint = new ErpEndpoint(this.erpConfigContext);
            ODataQueryResult result = query.execute((WithDestinationName)erpEndpoint);
            List entityList = result.asList(PlannedOrderComponent.class);
            for (PlannedOrderComponent entity : entityList) {
                entity.setErpConfigContext(this.erpConfigContext);
            }
            return entityList;
        }

        public String toString() {
            return "ReadPlannedOrdersNamespace.PlannedOrder(plannedOrder=" + this.plannedOrder + ", baseUnit=" + this.baseUnit + ", plndOrderPlannedStartDate=" + this.plndOrderPlannedStartDate + ", plndOrderPlannedStartTime=" + this.plndOrderPlannedStartTime + ", plndOrderPlannedEndDate=" + this.plndOrderPlannedEndDate + ", plndOrderPlannedEndTime=" + this.plndOrderPlannedEndTime + ", plannedOrderOpeningDate=" + this.plannedOrderOpeningDate + ", productionStartDate=" + this.productionStartDate + ", productionEndDate=" + this.productionEndDate + ", salesOrder=" + this.salesOrder + ", salesOrderItem=" + this.salesOrderItem + ", plannedOrderType=" + this.plannedOrderType + ", customer=" + this.customer + ", wBSElementInternalID=" + this.wBSElementInternalID + ", wBSElement=" + this.wBSElement + ", wBSDescription=" + this.wBSDescription + ", mRPController=" + this.mRPController + ", productionSupervisor=" + this.productionSupervisor + ", purchasingGroup=" + this.purchasingGroup + ", purchasingOrganization=" + this.purchasingOrganization + ", fixedSupplier=" + this.fixedSupplier + ", purchasingDocument=" + this.purchasingDocument + ", material=" + this.material + ", purchasingDocumentItem=" + this.purchasingDocumentItem + ", quotaArrangement=" + this.quotaArrangement + ", supplierName=" + this.supplierName + ", plannedOrderIsFirm=" + this.plannedOrderIsFirm + ", plannedOrderIsConvertible=" + this.plannedOrderIsConvertible + ", materialName=" + this.materialName + ", productionPlant=" + this.productionPlant + ", mRPPlant=" + this.mRPPlant + ", mRPArea=" + this.mRPArea + ", productionVersion=" + this.productionVersion + ", totalQuantity=" + this.totalQuantity + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PlannedOrder)) {
                return false;
            }
            PlannedOrder other = (PlannedOrder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$plannedOrder = this.plannedOrder;
            String other$plannedOrder = other.plannedOrder;
            if (this$plannedOrder == null ? other$plannedOrder != null : !this$plannedOrder.equals(other$plannedOrder)) {
                return false;
            }
            String this$baseUnit = this.baseUnit;
            String other$baseUnit = other.baseUnit;
            if (this$baseUnit == null ? other$baseUnit != null : !this$baseUnit.equals(other$baseUnit)) {
                return false;
            }
            Calendar this$plndOrderPlannedStartDate = this.plndOrderPlannedStartDate;
            Calendar other$plndOrderPlannedStartDate = other.plndOrderPlannedStartDate;
            if (this$plndOrderPlannedStartDate == null ? other$plndOrderPlannedStartDate != null : !((Object)this$plndOrderPlannedStartDate).equals(other$plndOrderPlannedStartDate)) {
                return false;
            }
            Calendar this$plndOrderPlannedStartTime = this.plndOrderPlannedStartTime;
            Calendar other$plndOrderPlannedStartTime = other.plndOrderPlannedStartTime;
            if (this$plndOrderPlannedStartTime == null ? other$plndOrderPlannedStartTime != null : !((Object)this$plndOrderPlannedStartTime).equals(other$plndOrderPlannedStartTime)) {
                return false;
            }
            Calendar this$plndOrderPlannedEndDate = this.plndOrderPlannedEndDate;
            Calendar other$plndOrderPlannedEndDate = other.plndOrderPlannedEndDate;
            if (this$plndOrderPlannedEndDate == null ? other$plndOrderPlannedEndDate != null : !((Object)this$plndOrderPlannedEndDate).equals(other$plndOrderPlannedEndDate)) {
                return false;
            }
            Calendar this$plndOrderPlannedEndTime = this.plndOrderPlannedEndTime;
            Calendar other$plndOrderPlannedEndTime = other.plndOrderPlannedEndTime;
            if (this$plndOrderPlannedEndTime == null ? other$plndOrderPlannedEndTime != null : !((Object)this$plndOrderPlannedEndTime).equals(other$plndOrderPlannedEndTime)) {
                return false;
            }
            Calendar this$plannedOrderOpeningDate = this.plannedOrderOpeningDate;
            Calendar other$plannedOrderOpeningDate = other.plannedOrderOpeningDate;
            if (this$plannedOrderOpeningDate == null ? other$plannedOrderOpeningDate != null : !((Object)this$plannedOrderOpeningDate).equals(other$plannedOrderOpeningDate)) {
                return false;
            }
            Calendar this$productionStartDate = this.productionStartDate;
            Calendar other$productionStartDate = other.productionStartDate;
            if (this$productionStartDate == null ? other$productionStartDate != null : !((Object)this$productionStartDate).equals(other$productionStartDate)) {
                return false;
            }
            Calendar this$productionEndDate = this.productionEndDate;
            Calendar other$productionEndDate = other.productionEndDate;
            if (this$productionEndDate == null ? other$productionEndDate != null : !((Object)this$productionEndDate).equals(other$productionEndDate)) {
                return false;
            }
            String this$salesOrder = this.salesOrder;
            String other$salesOrder = other.salesOrder;
            if (this$salesOrder == null ? other$salesOrder != null : !this$salesOrder.equals(other$salesOrder)) {
                return false;
            }
            String this$salesOrderItem = this.salesOrderItem;
            String other$salesOrderItem = other.salesOrderItem;
            if (this$salesOrderItem == null ? other$salesOrderItem != null : !this$salesOrderItem.equals(other$salesOrderItem)) {
                return false;
            }
            String this$plannedOrderType = this.plannedOrderType;
            String other$plannedOrderType = other.plannedOrderType;
            if (this$plannedOrderType == null ? other$plannedOrderType != null : !this$plannedOrderType.equals(other$plannedOrderType)) {
                return false;
            }
            String this$customer = this.customer;
            String other$customer = other.customer;
            if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
                return false;
            }
            String this$wBSElementInternalID = this.wBSElementInternalID;
            String other$wBSElementInternalID = other.wBSElementInternalID;
            if (this$wBSElementInternalID == null ? other$wBSElementInternalID != null : !this$wBSElementInternalID.equals(other$wBSElementInternalID)) {
                return false;
            }
            String this$wBSElement = this.wBSElement;
            String other$wBSElement = other.wBSElement;
            if (this$wBSElement == null ? other$wBSElement != null : !this$wBSElement.equals(other$wBSElement)) {
                return false;
            }
            String this$wBSDescription = this.wBSDescription;
            String other$wBSDescription = other.wBSDescription;
            if (this$wBSDescription == null ? other$wBSDescription != null : !this$wBSDescription.equals(other$wBSDescription)) {
                return false;
            }
            String this$mRPController = this.mRPController;
            String other$mRPController = other.mRPController;
            if (this$mRPController == null ? other$mRPController != null : !this$mRPController.equals(other$mRPController)) {
                return false;
            }
            String this$productionSupervisor = this.productionSupervisor;
            String other$productionSupervisor = other.productionSupervisor;
            if (this$productionSupervisor == null ? other$productionSupervisor != null : !this$productionSupervisor.equals(other$productionSupervisor)) {
                return false;
            }
            String this$purchasingGroup = this.purchasingGroup;
            String other$purchasingGroup = other.purchasingGroup;
            if (this$purchasingGroup == null ? other$purchasingGroup != null : !this$purchasingGroup.equals(other$purchasingGroup)) {
                return false;
            }
            String this$purchasingOrganization = this.purchasingOrganization;
            String other$purchasingOrganization = other.purchasingOrganization;
            if (this$purchasingOrganization == null ? other$purchasingOrganization != null : !this$purchasingOrganization.equals(other$purchasingOrganization)) {
                return false;
            }
            String this$fixedSupplier = this.fixedSupplier;
            String other$fixedSupplier = other.fixedSupplier;
            if (this$fixedSupplier == null ? other$fixedSupplier != null : !this$fixedSupplier.equals(other$fixedSupplier)) {
                return false;
            }
            String this$purchasingDocument = this.purchasingDocument;
            String other$purchasingDocument = other.purchasingDocument;
            if (this$purchasingDocument == null ? other$purchasingDocument != null : !this$purchasingDocument.equals(other$purchasingDocument)) {
                return false;
            }
            String this$material = this.material;
            String other$material = other.material;
            if (this$material == null ? other$material != null : !this$material.equals(other$material)) {
                return false;
            }
            String this$purchasingDocumentItem = this.purchasingDocumentItem;
            String other$purchasingDocumentItem = other.purchasingDocumentItem;
            if (this$purchasingDocumentItem == null ? other$purchasingDocumentItem != null : !this$purchasingDocumentItem.equals(other$purchasingDocumentItem)) {
                return false;
            }
            String this$quotaArrangement = this.quotaArrangement;
            String other$quotaArrangement = other.quotaArrangement;
            if (this$quotaArrangement == null ? other$quotaArrangement != null : !this$quotaArrangement.equals(other$quotaArrangement)) {
                return false;
            }
            String this$supplierName = this.supplierName;
            String other$supplierName = other.supplierName;
            if (this$supplierName == null ? other$supplierName != null : !this$supplierName.equals(other$supplierName)) {
                return false;
            }
            Boolean this$plannedOrderIsFirm = this.plannedOrderIsFirm;
            Boolean other$plannedOrderIsFirm = other.plannedOrderIsFirm;
            if (this$plannedOrderIsFirm == null ? other$plannedOrderIsFirm != null : !((Object)this$plannedOrderIsFirm).equals(other$plannedOrderIsFirm)) {
                return false;
            }
            Boolean this$plannedOrderIsConvertible = this.plannedOrderIsConvertible;
            Boolean other$plannedOrderIsConvertible = other.plannedOrderIsConvertible;
            if (this$plannedOrderIsConvertible == null ? other$plannedOrderIsConvertible != null : !((Object)this$plannedOrderIsConvertible).equals(other$plannedOrderIsConvertible)) {
                return false;
            }
            String this$materialName = this.materialName;
            String other$materialName = other.materialName;
            if (this$materialName == null ? other$materialName != null : !this$materialName.equals(other$materialName)) {
                return false;
            }
            String this$productionPlant = this.productionPlant;
            String other$productionPlant = other.productionPlant;
            if (this$productionPlant == null ? other$productionPlant != null : !this$productionPlant.equals(other$productionPlant)) {
                return false;
            }
            String this$mRPPlant = this.mRPPlant;
            String other$mRPPlant = other.mRPPlant;
            if (this$mRPPlant == null ? other$mRPPlant != null : !this$mRPPlant.equals(other$mRPPlant)) {
                return false;
            }
            String this$mRPArea = this.mRPArea;
            String other$mRPArea = other.mRPArea;
            if (this$mRPArea == null ? other$mRPArea != null : !this$mRPArea.equals(other$mRPArea)) {
                return false;
            }
            String this$productionVersion = this.productionVersion;
            String other$productionVersion = other.productionVersion;
            if (this$productionVersion == null ? other$productionVersion != null : !this$productionVersion.equals(other$productionVersion)) {
                return false;
            }
            BigDecimal this$totalQuantity = this.totalQuantity;
            BigDecimal other$totalQuantity = other.totalQuantity;
            return !(this$totalQuantity == null ? other$totalQuantity != null : !((Object)this$totalQuantity).equals(other$totalQuantity));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PlannedOrder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $plannedOrder = this.plannedOrder;
            result = result * 59 + ($plannedOrder == null ? 43 : $plannedOrder.hashCode());
            String $baseUnit = this.baseUnit;
            result = result * 59 + ($baseUnit == null ? 43 : $baseUnit.hashCode());
            Calendar $plndOrderPlannedStartDate = this.plndOrderPlannedStartDate;
            result = result * 59 + ($plndOrderPlannedStartDate == null ? 43 : ((Object)$plndOrderPlannedStartDate).hashCode());
            Calendar $plndOrderPlannedStartTime = this.plndOrderPlannedStartTime;
            result = result * 59 + ($plndOrderPlannedStartTime == null ? 43 : ((Object)$plndOrderPlannedStartTime).hashCode());
            Calendar $plndOrderPlannedEndDate = this.plndOrderPlannedEndDate;
            result = result * 59 + ($plndOrderPlannedEndDate == null ? 43 : ((Object)$plndOrderPlannedEndDate).hashCode());
            Calendar $plndOrderPlannedEndTime = this.plndOrderPlannedEndTime;
            result = result * 59 + ($plndOrderPlannedEndTime == null ? 43 : ((Object)$plndOrderPlannedEndTime).hashCode());
            Calendar $plannedOrderOpeningDate = this.plannedOrderOpeningDate;
            result = result * 59 + ($plannedOrderOpeningDate == null ? 43 : ((Object)$plannedOrderOpeningDate).hashCode());
            Calendar $productionStartDate = this.productionStartDate;
            result = result * 59 + ($productionStartDate == null ? 43 : ((Object)$productionStartDate).hashCode());
            Calendar $productionEndDate = this.productionEndDate;
            result = result * 59 + ($productionEndDate == null ? 43 : ((Object)$productionEndDate).hashCode());
            String $salesOrder = this.salesOrder;
            result = result * 59 + ($salesOrder == null ? 43 : $salesOrder.hashCode());
            String $salesOrderItem = this.salesOrderItem;
            result = result * 59 + ($salesOrderItem == null ? 43 : $salesOrderItem.hashCode());
            String $plannedOrderType = this.plannedOrderType;
            result = result * 59 + ($plannedOrderType == null ? 43 : $plannedOrderType.hashCode());
            String $customer = this.customer;
            result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
            String $wBSElementInternalID = this.wBSElementInternalID;
            result = result * 59 + ($wBSElementInternalID == null ? 43 : $wBSElementInternalID.hashCode());
            String $wBSElement = this.wBSElement;
            result = result * 59 + ($wBSElement == null ? 43 : $wBSElement.hashCode());
            String $wBSDescription = this.wBSDescription;
            result = result * 59 + ($wBSDescription == null ? 43 : $wBSDescription.hashCode());
            String $mRPController = this.mRPController;
            result = result * 59 + ($mRPController == null ? 43 : $mRPController.hashCode());
            String $productionSupervisor = this.productionSupervisor;
            result = result * 59 + ($productionSupervisor == null ? 43 : $productionSupervisor.hashCode());
            String $purchasingGroup = this.purchasingGroup;
            result = result * 59 + ($purchasingGroup == null ? 43 : $purchasingGroup.hashCode());
            String $purchasingOrganization = this.purchasingOrganization;
            result = result * 59 + ($purchasingOrganization == null ? 43 : $purchasingOrganization.hashCode());
            String $fixedSupplier = this.fixedSupplier;
            result = result * 59 + ($fixedSupplier == null ? 43 : $fixedSupplier.hashCode());
            String $purchasingDocument = this.purchasingDocument;
            result = result * 59 + ($purchasingDocument == null ? 43 : $purchasingDocument.hashCode());
            String $material = this.material;
            result = result * 59 + ($material == null ? 43 : $material.hashCode());
            String $purchasingDocumentItem = this.purchasingDocumentItem;
            result = result * 59 + ($purchasingDocumentItem == null ? 43 : $purchasingDocumentItem.hashCode());
            String $quotaArrangement = this.quotaArrangement;
            result = result * 59 + ($quotaArrangement == null ? 43 : $quotaArrangement.hashCode());
            String $supplierName = this.supplierName;
            result = result * 59 + ($supplierName == null ? 43 : $supplierName.hashCode());
            Boolean $plannedOrderIsFirm = this.plannedOrderIsFirm;
            result = result * 59 + ($plannedOrderIsFirm == null ? 43 : ((Object)$plannedOrderIsFirm).hashCode());
            Boolean $plannedOrderIsConvertible = this.plannedOrderIsConvertible;
            result = result * 59 + ($plannedOrderIsConvertible == null ? 43 : ((Object)$plannedOrderIsConvertible).hashCode());
            String $materialName = this.materialName;
            result = result * 59 + ($materialName == null ? 43 : $materialName.hashCode());
            String $productionPlant = this.productionPlant;
            result = result * 59 + ($productionPlant == null ? 43 : $productionPlant.hashCode());
            String $mRPPlant = this.mRPPlant;
            result = result * 59 + ($mRPPlant == null ? 43 : $mRPPlant.hashCode());
            String $mRPArea = this.mRPArea;
            result = result * 59 + ($mRPArea == null ? 43 : $mRPArea.hashCode());
            String $productionVersion = this.productionVersion;
            result = result * 59 + ($productionVersion == null ? 43 : $productionVersion.hashCode());
            BigDecimal $totalQuantity = this.totalQuantity;
            result = result * 59 + ($totalQuantity == null ? 43 : ((Object)$totalQuantity).hashCode());
            return result;
        }

        public String getPlannedOrder() {
            return this.plannedOrder;
        }

        public PlannedOrder setPlannedOrder(String plannedOrder) {
            this.plannedOrder = plannedOrder;
            return this;
        }

        public String getBaseUnit() {
            return this.baseUnit;
        }

        public PlannedOrder setBaseUnit(String baseUnit) {
            this.baseUnit = baseUnit;
            return this;
        }

        public Calendar getPlndOrderPlannedStartDate() {
            return this.plndOrderPlannedStartDate;
        }

        public PlannedOrder setPlndOrderPlannedStartDate(Calendar plndOrderPlannedStartDate) {
            this.plndOrderPlannedStartDate = plndOrderPlannedStartDate;
            return this;
        }

        public Calendar getPlndOrderPlannedStartTime() {
            return this.plndOrderPlannedStartTime;
        }

        public PlannedOrder setPlndOrderPlannedStartTime(Calendar plndOrderPlannedStartTime) {
            this.plndOrderPlannedStartTime = plndOrderPlannedStartTime;
            return this;
        }

        public Calendar getPlndOrderPlannedEndDate() {
            return this.plndOrderPlannedEndDate;
        }

        public PlannedOrder setPlndOrderPlannedEndDate(Calendar plndOrderPlannedEndDate) {
            this.plndOrderPlannedEndDate = plndOrderPlannedEndDate;
            return this;
        }

        public Calendar getPlndOrderPlannedEndTime() {
            return this.plndOrderPlannedEndTime;
        }

        public PlannedOrder setPlndOrderPlannedEndTime(Calendar plndOrderPlannedEndTime) {
            this.plndOrderPlannedEndTime = plndOrderPlannedEndTime;
            return this;
        }

        public Calendar getPlannedOrderOpeningDate() {
            return this.plannedOrderOpeningDate;
        }

        public PlannedOrder setPlannedOrderOpeningDate(Calendar plannedOrderOpeningDate) {
            this.plannedOrderOpeningDate = plannedOrderOpeningDate;
            return this;
        }

        public Calendar getProductionStartDate() {
            return this.productionStartDate;
        }

        public PlannedOrder setProductionStartDate(Calendar productionStartDate) {
            this.productionStartDate = productionStartDate;
            return this;
        }

        public Calendar getProductionEndDate() {
            return this.productionEndDate;
        }

        public PlannedOrder setProductionEndDate(Calendar productionEndDate) {
            this.productionEndDate = productionEndDate;
            return this;
        }

        public String getSalesOrder() {
            return this.salesOrder;
        }

        public PlannedOrder setSalesOrder(String salesOrder) {
            this.salesOrder = salesOrder;
            return this;
        }

        public String getSalesOrderItem() {
            return this.salesOrderItem;
        }

        public PlannedOrder setSalesOrderItem(String salesOrderItem) {
            this.salesOrderItem = salesOrderItem;
            return this;
        }

        public String getPlannedOrderType() {
            return this.plannedOrderType;
        }

        public PlannedOrder setPlannedOrderType(String plannedOrderType) {
            this.plannedOrderType = plannedOrderType;
            return this;
        }

        public String getCustomer() {
            return this.customer;
        }

        public PlannedOrder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public String getWBSElementInternalID() {
            return this.wBSElementInternalID;
        }

        public PlannedOrder setWBSElementInternalID(String wBSElementInternalID) {
            this.wBSElementInternalID = wBSElementInternalID;
            return this;
        }

        public String getWBSElement() {
            return this.wBSElement;
        }

        public PlannedOrder setWBSElement(String wBSElement) {
            this.wBSElement = wBSElement;
            return this;
        }

        public String getWBSDescription() {
            return this.wBSDescription;
        }

        public PlannedOrder setWBSDescription(String wBSDescription) {
            this.wBSDescription = wBSDescription;
            return this;
        }

        public String getMRPController() {
            return this.mRPController;
        }

        public PlannedOrder setMRPController(String mRPController) {
            this.mRPController = mRPController;
            return this;
        }

        public String getProductionSupervisor() {
            return this.productionSupervisor;
        }

        public PlannedOrder setProductionSupervisor(String productionSupervisor) {
            this.productionSupervisor = productionSupervisor;
            return this;
        }

        public String getPurchasingGroup() {
            return this.purchasingGroup;
        }

        public PlannedOrder setPurchasingGroup(String purchasingGroup) {
            this.purchasingGroup = purchasingGroup;
            return this;
        }

        public String getPurchasingOrganization() {
            return this.purchasingOrganization;
        }

        public PlannedOrder setPurchasingOrganization(String purchasingOrganization) {
            this.purchasingOrganization = purchasingOrganization;
            return this;
        }

        public String getFixedSupplier() {
            return this.fixedSupplier;
        }

        public PlannedOrder setFixedSupplier(String fixedSupplier) {
            this.fixedSupplier = fixedSupplier;
            return this;
        }

        public String getPurchasingDocument() {
            return this.purchasingDocument;
        }

        public PlannedOrder setPurchasingDocument(String purchasingDocument) {
            this.purchasingDocument = purchasingDocument;
            return this;
        }

        public String getMaterial() {
            return this.material;
        }

        public PlannedOrder setMaterial(String material) {
            this.material = material;
            return this;
        }

        public String getPurchasingDocumentItem() {
            return this.purchasingDocumentItem;
        }

        public PlannedOrder setPurchasingDocumentItem(String purchasingDocumentItem) {
            this.purchasingDocumentItem = purchasingDocumentItem;
            return this;
        }

        public String getQuotaArrangement() {
            return this.quotaArrangement;
        }

        public PlannedOrder setQuotaArrangement(String quotaArrangement) {
            this.quotaArrangement = quotaArrangement;
            return this;
        }

        public String getSupplierName() {
            return this.supplierName;
        }

        public PlannedOrder setSupplierName(String supplierName) {
            this.supplierName = supplierName;
            return this;
        }

        public Boolean getPlannedOrderIsFirm() {
            return this.plannedOrderIsFirm;
        }

        public PlannedOrder setPlannedOrderIsFirm(Boolean plannedOrderIsFirm) {
            this.plannedOrderIsFirm = plannedOrderIsFirm;
            return this;
        }

        public Boolean getPlannedOrderIsConvertible() {
            return this.plannedOrderIsConvertible;
        }

        public PlannedOrder setPlannedOrderIsConvertible(Boolean plannedOrderIsConvertible) {
            this.plannedOrderIsConvertible = plannedOrderIsConvertible;
            return this;
        }

        public String getMaterialName() {
            return this.materialName;
        }

        public PlannedOrder setMaterialName(String materialName) {
            this.materialName = materialName;
            return this;
        }

        public String getProductionPlant() {
            return this.productionPlant;
        }

        public PlannedOrder setProductionPlant(String productionPlant) {
            this.productionPlant = productionPlant;
            return this;
        }

        public String getMRPPlant() {
            return this.mRPPlant;
        }

        public PlannedOrder setMRPPlant(String mRPPlant) {
            this.mRPPlant = mRPPlant;
            return this;
        }

        public String getMRPArea() {
            return this.mRPArea;
        }

        public PlannedOrder setMRPArea(String mRPArea) {
            this.mRPArea = mRPArea;
            return this;
        }

        public String getProductionVersion() {
            return this.productionVersion;
        }

        public PlannedOrder setProductionVersion(String productionVersion) {
            this.productionVersion = productionVersion;
            return this;
        }

        public BigDecimal getTotalQuantity() {
            return this.totalQuantity;
        }

        public PlannedOrder setTotalQuantity(BigDecimal totalQuantity) {
            this.totalQuantity = totalQuantity;
            return this;
        }

        public PlannedOrder setErpConfigContext(ErpConfigContext erpConfigContext) {
            this.erpConfigContext = erpConfigContext;
            return this;
        }
    }
}

