/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces;

import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.cloudplatform.connectivity.WithDestinationName;
import com.sap.cloud.sdk.odatav2.connectivity.ErrorResultHandler;
import com.sap.cloud.sdk.odatav2.connectivity.FilterExpression;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQuery;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQueryBuilder;
import com.sap.cloud.sdk.odatav2.connectivity.ODataType;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.connectivity.ErpConfigContext;
import com.sap.cloud.sdk.s4hana.connectivity.ErpEndpoint;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.EntityField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ExpressionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.FilterExpressionWrapper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ODataBooleanAdapter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ODataCalendarAdapter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ODataVdmErrorResultHandler;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.Order;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public class ReadMasterInspectionCharacteristicsNamespace {

    public static class InspectionSpecificationFluentHelper {
        private ODataQueryBuilder queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_MASTERINSPCHARACTERISTIC_SRV", (String)"A_InspectionSpecification");
        private ErrorResultHandler<?> errorResultHandler = new ODataVdmErrorResultHandler();

        public InspectionSpecificationFluentHelper filter(ExpressionFluentHelper<InspectionSpecification> expression) {
            for (FilterExpressionWrapper<?> filterExpressionWrapper : expression.evaluate()) {
                Object comparisonValue = filterExpressionWrapper.getComparisonValue();
                if (comparisonValue instanceof Integer) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Integer)((Integer)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof String) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((String)((String)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Long) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Long)((Long)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Double) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Double)((Double)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Float) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Float)((Float)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDate) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDate)((LocalDate)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDateTime)((LocalDateTime)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Date) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Date)((Date)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof DateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((DateTime)((DateTime)comparisonValue))));
                    continue;
                }
                this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of(comparisonValue)));
            }
            return this;
        }

        public InspectionSpecificationFluentHelper orderBy(EntityField<?, InspectionSpecification> field, Order order) {
            String orderingDirection = order == Order.ASC ? " asc" : " desc";
            this.queryBuilder.param("orderby", (Object)(field.getFieldName() + orderingDirection));
            return this;
        }

        @SafeVarargs
        public final InspectionSpecificationFluentHelper select(EntityField<?, InspectionSpecification> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public InspectionSpecificationFluentHelper top(Number top) {
            this.queryBuilder.top(top);
            return this;
        }

        public InspectionSpecificationFluentHelper skip(Number skip) {
            this.queryBuilder.skip(skip);
            return this;
        }

        public InspectionSpecificationFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.errorHandler(this.errorResultHandler).build();
        }

        public List<InspectionSpecification> execute(ErpConfigContext erpConfigContext) throws ODataException {
            List entityList = this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).asList(InspectionSpecification.class);
            for (InspectionSpecification entity : entityList) {
                entity.setErpConfigContext(erpConfigContext);
            }
            return entityList;
        }
    }

    public static class InspectionSpecificationByKeyFluentHelper {
        private ODataQueryBuilder queryBuilder;
        private ErrorResultHandler<?> errorResultHandler;
        private List<Object> values = new LinkedList<Object>();

        public InspectionSpecificationByKeyFluentHelper(String inspectionSpecification, String inspectionSpecificationVersion, String inspectionSpecificationPlant) {
            this.values.add(inspectionSpecification);
            this.values.add(inspectionSpecificationVersion);
            this.values.add(inspectionSpecificationPlant);
            this.queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_MASTERINSPCHARACTERISTIC_SRV", (String)"A_InspectionSpecification");
            HashMap<String, Object> keys = new HashMap<String, Object>();
            keys.put("InspectionSpecification", this.values.get(0));
            keys.put("InspectionSpecificationVersion", this.values.get(1));
            keys.put("InspectionSpecificationPlant", this.values.get(2));
            this.queryBuilder.keys(keys);
        }

        @SafeVarargs
        public final InspectionSpecificationByKeyFluentHelper select(EntityField<?, InspectionSpecification> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.build();
        }

        public InspectionSpecificationByKeyFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public InspectionSpecification execute(ErpConfigContext erpConfigContext) throws ODataException {
            InspectionSpecification entity = (InspectionSpecification)this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).as(InspectionSpecification.class);
            entity.setErpConfigContext(erpConfigContext);
            return entity;
        }
    }

    public static class InspectionSpecification {
        @ElementName(value="InspectionSpecification")
        private String inspectionSpecification;
        public static EntityField<String, InspectionSpecification> INSPECTION_SPECIFICATION = new EntityField("InspectionSpecification");
        @ElementName(value="InspSpecCreatedByUser")
        private String inspSpecCreatedByUser;
        public static EntityField<String, InspectionSpecification> INSP_SPEC_CREATED_BY_USER = new EntityField("InspSpecCreatedByUser");
        @ElementName(value="InspSpecCreationDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar inspSpecCreationDate;
        public static EntityField<Calendar, InspectionSpecification> INSP_SPEC_CREATION_DATE = new EntityField("InspSpecCreationDate");
        @ElementName(value="InspSpecChangedByUser")
        private String inspSpecChangedByUser;
        public static EntityField<String, InspectionSpecification> INSP_SPEC_CHANGED_BY_USER = new EntityField("InspSpecChangedByUser");
        @ElementName(value="InspSpecChangeDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar inspSpecChangeDate;
        public static EntityField<Calendar, InspectionSpecification> INSP_SPEC_CHANGE_DATE = new EntityField("InspSpecChangeDate");
        @ElementName(value="InspSpecIsQuantitative")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean inspSpecIsQuantitative;
        public static EntityField<Boolean, InspectionSpecification> INSP_SPEC_IS_QUANTITATIVE = new EntityField("InspSpecIsQuantitative");
        @ElementName(value="InspSpecCharacteristicType")
        private String inspSpecCharacteristicType;
        public static EntityField<String, InspectionSpecification> INSP_SPEC_CHARACTERISTIC_TYPE = new EntityField("InspSpecCharacteristicType");
        @ElementName(value="InspSpecIsMeasuredValueRqd")
        private String inspSpecIsMeasuredValueRqd;
        public static EntityField<String, InspectionSpecification> INSP_SPEC_IS_MEASURED_VALUE_RQD = new EntityField("InspSpecIsMeasuredValueRqd");
        @ElementName(value="InspSpecIsSelectedSetRequired")
        private String inspSpecIsSelectedSetRequired;
        public static EntityField<String, InspectionSpecification> INSP_SPEC_IS_SELECTED_SET_REQUIRED = new EntityField("InspSpecIsSelectedSetRequired");
        @ElementName(value="InspSpecIsUpperLimitRequired")
        private String inspSpecIsUpperLimitRequired;
        public static EntityField<String, InspectionSpecification> INSP_SPEC_IS_UPPER_LIMIT_REQUIRED = new EntityField("InspSpecIsUpperLimitRequired");
        @ElementName(value="InspSpecIsLowerLimitRequired")
        private String inspSpecIsLowerLimitRequired;
        public static EntityField<String, InspectionSpecification> INSP_SPEC_IS_LOWER_LIMIT_REQUIRED = new EntityField("InspSpecIsLowerLimitRequired");
        @ElementName(value="InspectionSpecificationVersion")
        private String inspectionSpecificationVersion;
        public static EntityField<String, InspectionSpecification> INSPECTION_SPECIFICATION_VERSION = new EntityField("InspectionSpecificationVersion");
        @ElementName(value="InspSpecIsTargetValueInLimit")
        private String inspSpecIsTargetValueInLimit;
        public static EntityField<String, InspectionSpecification> INSP_SPEC_IS_TARGET_VALUE_IN_LIMIT = new EntityField("InspSpecIsTargetValueInLimit");
        @ElementName(value="InspectionScope")
        private String inspectionScope;
        public static EntityField<String, InspectionSpecification> INSPECTION_SCOPE = new EntityField("InspectionScope");
        @ElementName(value="InspSpecIsLongTermInspection")
        private String inspSpecIsLongTermInspection;
        public static EntityField<String, InspectionSpecification> INSP_SPEC_IS_LONG_TERM_INSPECTION = new EntityField("InspSpecIsLongTermInspection");
        @ElementName(value="InspSpecRecordingType")
        private String inspSpecRecordingType;
        public static EntityField<String, InspectionSpecification> INSP_SPEC_RECORDING_TYPE = new EntityField("InspSpecRecordingType");
        @ElementName(value="InspResultIsDocumentationRqd")
        private String inspResultIsDocumentationRqd;
        public static EntityField<String, InspectionSpecification> INSP_RESULT_IS_DOCUMENTATION_RQD = new EntityField("InspResultIsDocumentationRqd");
        @ElementName(value="InspSpecCharcCategory")
        private String inspSpecCharcCategory;
        public static EntityField<String, InspectionSpecification> INSP_SPEC_CHARC_CATEGORY = new EntityField("InspSpecCharcCategory");
        @ElementName(value="InspSpecIsDefectsRecgAutomatic")
        private String inspSpecIsDefectsRecgAutomatic;
        public static EntityField<String, InspectionSpecification> INSP_SPEC_IS_DEFECTS_RECG_AUTOMATIC = new EntityField("InspSpecIsDefectsRecgAutomatic");
        @ElementName(value="InspSpecIsSampleQtyAdditive")
        private String inspSpecIsSampleQtyAdditive;
        public static EntityField<String, InspectionSpecification> INSP_SPEC_IS_SAMPLE_QTY_ADDITIVE = new EntityField("InspSpecIsSampleQtyAdditive");
        @ElementName(value="InspSpecIsDestructive")
        private String inspSpecIsDestructive;
        public static EntityField<String, InspectionSpecification> INSP_SPEC_IS_DESTRUCTIVE = new EntityField("InspSpecIsDestructive");
        @ElementName(value="InspSpecResultCalculation")
        private String inspSpecResultCalculation;
        public static EntityField<String, InspectionSpecification> INSP_SPEC_RESULT_CALCULATION = new EntityField("InspSpecResultCalculation");
        @ElementName(value="InspectionSpecificationPlant")
        private String inspectionSpecificationPlant;
        public static EntityField<String, InspectionSpecification> INSPECTION_SPECIFICATION_PLANT = new EntityField("InspectionSpecificationPlant");
        @ElementName(value="InspSpecIsSamplingProcedRqd")
        private String inspSpecIsSamplingProcedRqd;
        public static EntityField<String, InspectionSpecification> INSP_SPEC_IS_SAMPLING_PROCED_RQD = new EntityField("InspSpecIsSamplingProcedRqd");
        @ElementName(value="InspSpecIsScrapRelevant")
        private String inspSpecIsScrapRelevant;
        public static EntityField<String, InspectionSpecification> INSP_SPEC_IS_SCRAP_RELEVANT = new EntityField("InspSpecIsScrapRelevant");
        @ElementName(value="InspSpecIsTestEquipmentRqd")
        private String inspSpecIsTestEquipmentRqd;
        public static EntityField<String, InspectionSpecification> INSP_SPEC_IS_TEST_EQUIPMENT_RQD = new EntityField("InspSpecIsTestEquipmentRqd");
        @ElementName(value="InspSpecIsChgDocRequired")
        private String inspSpecIsChgDocRequired;
        public static EntityField<String, InspectionSpecification> INSP_SPEC_IS_CHG_DOC_REQUIRED = new EntityField("InspSpecIsChgDocRequired");
        @ElementName(value="InspSpecIsControlChartUsed")
        private String inspSpecIsControlChartUsed;
        public static EntityField<String, InspectionSpecification> INSP_SPEC_IS_CONTROL_CHART_USED = new EntityField("InspSpecIsControlChartUsed");
        @ElementName(value="InspSpecPrintControl")
        private String inspSpecPrintControl;
        public static EntityField<String, InspectionSpecification> INSP_SPEC_PRINT_CONTROL = new EntityField("InspSpecPrintControl");
        @ElementName(value="InspSpecImportanceCode")
        private String inspSpecImportanceCode;
        public static EntityField<String, InspectionSpecification> INSP_SPEC_IMPORTANCE_CODE = new EntityField("InspSpecImportanceCode");
        @ElementName(value="InspectorQualification")
        private String inspectorQualification;
        public static EntityField<String, InspectionSpecification> INSPECTOR_QUALIFICATION = new EntityField("InspectorQualification");
        @ElementName(value="InspSpecInformationField1")
        private String inspSpecInformationField1;
        public static EntityField<String, InspectionSpecification> INSP_SPEC_INFORMATION_FIELD1 = new EntityField("InspSpecInformationField1");
        @ElementName(value="InspSpecInformationField2")
        private String inspSpecInformationField2;
        public static EntityField<String, InspectionSpecification> INSP_SPEC_INFORMATION_FIELD2 = new EntityField("InspSpecInformationField2");
        @ElementName(value="Plant")
        private String plant;
        public static EntityField<String, InspectionSpecification> PLANT = new EntityField("Plant");
        @ElementName(value="InspSpecInformationField3")
        private String inspSpecInformationField3;
        public static EntityField<String, InspectionSpecification> INSP_SPEC_INFORMATION_FIELD3 = new EntityField("InspSpecInformationField3");
        @ElementName(value="QltyMstrDataAuthorizationGroup")
        private String qltyMstrDataAuthorizationGroup;
        public static EntityField<String, InspectionSpecification> QLTY_MSTR_DATA_AUTHORIZATION_GROUP = new EntityField("QltyMstrDataAuthorizationGroup");
        @ElementName(value="InspToleranceSpecification")
        private String inspToleranceSpecification;
        public static EntityField<String, InspectionSpecification> INSP_TOLERANCE_SPECIFICATION = new EntityField("InspToleranceSpecification");
        @ElementName(value="InspSpecDecimalPlaces")
        private Short inspSpecDecimalPlaces;
        public static EntityField<Short, InspectionSpecification> INSP_SPEC_DECIMAL_PLACES = new EntityField("InspSpecDecimalPlaces");
        @ElementName(value="InspectionSpecificationUnit")
        private String inspectionSpecificationUnit;
        public static EntityField<String, InspectionSpecification> INSPECTION_SPECIFICATION_UNIT = new EntityField("InspectionSpecificationUnit");
        @ElementName(value="InspSpecTargetValue")
        private Double inspSpecTargetValue;
        public static EntityField<Double, InspectionSpecification> INSP_SPEC_TARGET_VALUE = new EntityField("InspSpecTargetValue");
        @ElementName(value="InspSpecHasTargetValue")
        private String inspSpecHasTargetValue;
        public static EntityField<String, InspectionSpecification> INSP_SPEC_HAS_TARGET_VALUE = new EntityField("InspSpecHasTargetValue");
        @ElementName(value="InspSpecLowerLimit")
        private Double inspSpecLowerLimit;
        public static EntityField<Double, InspectionSpecification> INSP_SPEC_LOWER_LIMIT = new EntityField("InspSpecLowerLimit");
        @ElementName(value="InspSpecHasLowerLimit")
        private String inspSpecHasLowerLimit;
        public static EntityField<String, InspectionSpecification> INSP_SPEC_HAS_LOWER_LIMIT = new EntityField("InspSpecHasLowerLimit");
        @ElementName(value="InspSpecLowerPlausibilityLimit")
        private Double inspSpecLowerPlausibilityLimit;
        public static EntityField<Double, InspectionSpecification> INSP_SPEC_LOWER_PLAUSIBILITY_LIMIT = new EntityField("InspSpecLowerPlausibilityLimit");
        @ElementName(value="ValidityStartDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar validityStartDate;
        public static EntityField<Calendar, InspectionSpecification> VALIDITY_START_DATE = new EntityField("ValidityStartDate");
        @ElementName(value="InspSpecHasLowrPlausibilityLmt")
        private String inspSpecHasLowrPlausibilityLmt;
        public static EntityField<String, InspectionSpecification> INSP_SPEC_HAS_LOWR_PLAUSIBILITY_LMT = new EntityField("InspSpecHasLowrPlausibilityLmt");
        @ElementName(value="InspSpecFirstLowerSpecLimit")
        private Double inspSpecFirstLowerSpecLimit;
        public static EntityField<Double, InspectionSpecification> INSP_SPEC_FIRST_LOWER_SPEC_LIMIT = new EntityField("InspSpecFirstLowerSpecLimit");
        @ElementName(value="InspSpecHasFirstLowerSpecLimit")
        private String inspSpecHasFirstLowerSpecLimit;
        public static EntityField<String, InspectionSpecification> INSP_SPEC_HAS_FIRST_LOWER_SPEC_LIMIT = new EntityField("InspSpecHasFirstLowerSpecLimit");
        @ElementName(value="InspSpecSecondLowerSpecLimit")
        private Double inspSpecSecondLowerSpecLimit;
        public static EntityField<Double, InspectionSpecification> INSP_SPEC_SECOND_LOWER_SPEC_LIMIT = new EntityField("InspSpecSecondLowerSpecLimit");
        @ElementName(value="InspSpecHasSecondLowrSpecLimit")
        private String inspSpecHasSecondLowrSpecLimit;
        public static EntityField<String, InspectionSpecification> INSP_SPEC_HAS_SECOND_LOWR_SPEC_LIMIT = new EntityField("InspSpecHasSecondLowrSpecLimit");
        @ElementName(value="InspSpecLowerSpecLimitChange")
        private Double inspSpecLowerSpecLimitChange;
        public static EntityField<Double, InspectionSpecification> INSP_SPEC_LOWER_SPEC_LIMIT_CHANGE = new EntityField("InspSpecLowerSpecLimitChange");
        @ElementName(value="InspSpecHasLowrSpecLimitChange")
        private String inspSpecHasLowrSpecLimitChange;
        public static EntityField<String, InspectionSpecification> INSP_SPEC_HAS_LOWR_SPEC_LIMIT_CHANGE = new EntityField("InspSpecHasLowrSpecLimitChange");
        @ElementName(value="InspSpecUpperLimit")
        private Double inspSpecUpperLimit;
        public static EntityField<Double, InspectionSpecification> INSP_SPEC_UPPER_LIMIT = new EntityField("InspSpecUpperLimit");
        @ElementName(value="InspSpecHasUpperLimit")
        private String inspSpecHasUpperLimit;
        public static EntityField<String, InspectionSpecification> INSP_SPEC_HAS_UPPER_LIMIT = new EntityField("InspSpecHasUpperLimit");
        @ElementName(value="InspSpecUpperPlausibilityLimit")
        private Double inspSpecUpperPlausibilityLimit;
        public static EntityField<Double, InspectionSpecification> INSP_SPEC_UPPER_PLAUSIBILITY_LIMIT = new EntityField("InspSpecUpperPlausibilityLimit");
        @ElementName(value="InspectionSpecificationSrchTxt")
        private String inspectionSpecificationSrchTxt;
        public static EntityField<String, InspectionSpecification> INSPECTION_SPECIFICATION_SRCH_TXT = new EntityField("InspectionSpecificationSrchTxt");
        @ElementName(value="InspSpecHasUprPlausibilityLmt")
        private String inspSpecHasUprPlausibilityLmt;
        public static EntityField<String, InspectionSpecification> INSP_SPEC_HAS_UPR_PLAUSIBILITY_LMT = new EntityField("InspSpecHasUprPlausibilityLmt");
        @ElementName(value="InspSpecFirstUpperSpecLimit")
        private Double inspSpecFirstUpperSpecLimit;
        public static EntityField<Double, InspectionSpecification> INSP_SPEC_FIRST_UPPER_SPEC_LIMIT = new EntityField("InspSpecFirstUpperSpecLimit");
        @ElementName(value="InspSpecHasFirstUpperSpecLimit")
        private String inspSpecHasFirstUpperSpecLimit;
        public static EntityField<String, InspectionSpecification> INSP_SPEC_HAS_FIRST_UPPER_SPEC_LIMIT = new EntityField("InspSpecHasFirstUpperSpecLimit");
        @ElementName(value="InspSpecSecondUpperSpecLimit")
        private Double inspSpecSecondUpperSpecLimit;
        public static EntityField<Double, InspectionSpecification> INSP_SPEC_SECOND_UPPER_SPEC_LIMIT = new EntityField("InspSpecSecondUpperSpecLimit");
        @ElementName(value="InspSpecHasSecondUprSpecLimit")
        private String inspSpecHasSecondUprSpecLimit;
        public static EntityField<String, InspectionSpecification> INSP_SPEC_HAS_SECOND_UPR_SPEC_LIMIT = new EntityField("InspSpecHasSecondUprSpecLimit");
        @ElementName(value="InspSpecUpperSpecLimitChange")
        private Double inspSpecUpperSpecLimitChange;
        public static EntityField<Double, InspectionSpecification> INSP_SPEC_UPPER_SPEC_LIMIT_CHANGE = new EntityField("InspSpecUpperSpecLimitChange");
        @ElementName(value="InspSpecHasUprSpecLimitChange")
        private String inspSpecHasUprSpecLimitChange;
        public static EntityField<String, InspectionSpecification> INSP_SPEC_HAS_UPR_SPEC_LIMIT_CHANGE = new EntityField("InspSpecHasUprSpecLimitChange");
        @ElementName(value="InspSpecToleranceChgValidFrom")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar inspSpecToleranceChgValidFrom;
        public static EntityField<Calendar, InspectionSpecification> INSP_SPEC_TOLERANCE_CHG_VALID_FROM = new EntityField("InspSpecToleranceChgValidFrom");
        @ElementName(value="InspSpecToleranceChgValidTo")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar inspSpecToleranceChgValidTo;
        public static EntityField<Calendar, InspectionSpecification> INSP_SPEC_TOLERANCE_CHG_VALID_TO = new EntityField("InspSpecToleranceChgValidTo");
        @ElementName(value="InspSpecDefectCodeGrpRejection")
        private String inspSpecDefectCodeGrpRejection;
        public static EntityField<String, InspectionSpecification> INSP_SPEC_DEFECT_CODE_GRP_REJECTION = new EntityField("InspSpecDefectCodeGrpRejection");
        @ElementName(value="InspSpecGlobalName")
        private String inspSpecGlobalName;
        public static EntityField<String, InspectionSpecification> INSP_SPEC_GLOBAL_NAME = new EntityField("InspSpecGlobalName");
        @ElementName(value="InspSpecDefectCodeRejection")
        private String inspSpecDefectCodeRejection;
        public static EntityField<String, InspectionSpecification> INSP_SPEC_DEFECT_CODE_REJECTION = new EntityField("InspSpecDefectCodeRejection");
        @ElementName(value="InspSpecDefectCodeGrpRjcnUpper")
        private String inspSpecDefectCodeGrpRjcnUpper;
        public static EntityField<String, InspectionSpecification> INSP_SPEC_DEFECT_CODE_GRP_RJCN_UPPER = new EntityField("InspSpecDefectCodeGrpRjcnUpper");
        @ElementName(value="InspSpecDefectCodeRjcnUpper")
        private String inspSpecDefectCodeRjcnUpper;
        public static EntityField<String, InspectionSpecification> INSP_SPEC_DEFECT_CODE_RJCN_UPPER = new EntityField("InspSpecDefectCodeRjcnUpper");
        @ElementName(value="InspSpecDefectCodeGrpRjcnLower")
        private String inspSpecDefectCodeGrpRjcnLower;
        public static EntityField<String, InspectionSpecification> INSP_SPEC_DEFECT_CODE_GRP_RJCN_LOWER = new EntityField("InspSpecDefectCodeGrpRjcnLower");
        @ElementName(value="InspSpecDefectCodeRjcnLower")
        private String inspSpecDefectCodeRjcnLower;
        public static EntityField<String, InspectionSpecification> INSP_SPEC_DEFECT_CODE_RJCN_LOWER = new EntityField("InspSpecDefectCodeRjcnLower");
        @ElementName(value="CharacteristicInternalID")
        private String characteristicInternalID;
        public static EntityField<String, InspectionSpecification> CHARACTERISTIC_INTERNAL_I_D = new EntityField("CharacteristicInternalID");
        @ElementName(value="DefectFractionEstimationProced")
        private String defectFractionEstimationProced;
        public static EntityField<String, InspectionSpecification> DEFECT_FRACTION_ESTIMATION_PROCED = new EntityField("DefectFractionEstimationProced");
        @ElementName(value="InspectionSpecificationStatus")
        private String inspectionSpecificationStatus;
        public static EntityField<String, InspectionSpecification> INSPECTION_SPECIFICATION_STATUS = new EntityField("InspectionSpecificationStatus");
        @ElementName(value="InspSpecTransferType")
        private String inspSpecTransferType;
        public static EntityField<String, InspectionSpecification> INSP_SPEC_TRANSFER_TYPE = new EntityField("InspSpecTransferType");
        private static final transient String ODATA_ENDPOINT_URL = "/sap/opu/odata/sap/API_MASTERINSPCHARACTERISTIC_SRV";
        private static final transient String ODATA_ENTITY_COLLECTION = "A_InspectionSpecification";
        private transient ErpConfigContext erpConfigContext;

        public String toString() {
            return "ReadMasterInspectionCharacteristicsNamespace.InspectionSpecification(inspectionSpecification=" + this.inspectionSpecification + ", inspSpecCreatedByUser=" + this.inspSpecCreatedByUser + ", inspSpecCreationDate=" + this.inspSpecCreationDate + ", inspSpecChangedByUser=" + this.inspSpecChangedByUser + ", inspSpecChangeDate=" + this.inspSpecChangeDate + ", inspSpecIsQuantitative=" + this.inspSpecIsQuantitative + ", inspSpecCharacteristicType=" + this.inspSpecCharacteristicType + ", inspSpecIsMeasuredValueRqd=" + this.inspSpecIsMeasuredValueRqd + ", inspSpecIsSelectedSetRequired=" + this.inspSpecIsSelectedSetRequired + ", inspSpecIsUpperLimitRequired=" + this.inspSpecIsUpperLimitRequired + ", inspSpecIsLowerLimitRequired=" + this.inspSpecIsLowerLimitRequired + ", inspectionSpecificationVersion=" + this.inspectionSpecificationVersion + ", inspSpecIsTargetValueInLimit=" + this.inspSpecIsTargetValueInLimit + ", inspectionScope=" + this.inspectionScope + ", inspSpecIsLongTermInspection=" + this.inspSpecIsLongTermInspection + ", inspSpecRecordingType=" + this.inspSpecRecordingType + ", inspResultIsDocumentationRqd=" + this.inspResultIsDocumentationRqd + ", inspSpecCharcCategory=" + this.inspSpecCharcCategory + ", inspSpecIsDefectsRecgAutomatic=" + this.inspSpecIsDefectsRecgAutomatic + ", inspSpecIsSampleQtyAdditive=" + this.inspSpecIsSampleQtyAdditive + ", inspSpecIsDestructive=" + this.inspSpecIsDestructive + ", inspSpecResultCalculation=" + this.inspSpecResultCalculation + ", inspectionSpecificationPlant=" + this.inspectionSpecificationPlant + ", inspSpecIsSamplingProcedRqd=" + this.inspSpecIsSamplingProcedRqd + ", inspSpecIsScrapRelevant=" + this.inspSpecIsScrapRelevant + ", inspSpecIsTestEquipmentRqd=" + this.inspSpecIsTestEquipmentRqd + ", inspSpecIsChgDocRequired=" + this.inspSpecIsChgDocRequired + ", inspSpecIsControlChartUsed=" + this.inspSpecIsControlChartUsed + ", inspSpecPrintControl=" + this.inspSpecPrintControl + ", inspSpecImportanceCode=" + this.inspSpecImportanceCode + ", inspectorQualification=" + this.inspectorQualification + ", inspSpecInformationField1=" + this.inspSpecInformationField1 + ", inspSpecInformationField2=" + this.inspSpecInformationField2 + ", plant=" + this.plant + ", inspSpecInformationField3=" + this.inspSpecInformationField3 + ", qltyMstrDataAuthorizationGroup=" + this.qltyMstrDataAuthorizationGroup + ", inspToleranceSpecification=" + this.inspToleranceSpecification + ", inspSpecDecimalPlaces=" + this.inspSpecDecimalPlaces + ", inspectionSpecificationUnit=" + this.inspectionSpecificationUnit + ", inspSpecTargetValue=" + this.inspSpecTargetValue + ", inspSpecHasTargetValue=" + this.inspSpecHasTargetValue + ", inspSpecLowerLimit=" + this.inspSpecLowerLimit + ", inspSpecHasLowerLimit=" + this.inspSpecHasLowerLimit + ", inspSpecLowerPlausibilityLimit=" + this.inspSpecLowerPlausibilityLimit + ", validityStartDate=" + this.validityStartDate + ", inspSpecHasLowrPlausibilityLmt=" + this.inspSpecHasLowrPlausibilityLmt + ", inspSpecFirstLowerSpecLimit=" + this.inspSpecFirstLowerSpecLimit + ", inspSpecHasFirstLowerSpecLimit=" + this.inspSpecHasFirstLowerSpecLimit + ", inspSpecSecondLowerSpecLimit=" + this.inspSpecSecondLowerSpecLimit + ", inspSpecHasSecondLowrSpecLimit=" + this.inspSpecHasSecondLowrSpecLimit + ", inspSpecLowerSpecLimitChange=" + this.inspSpecLowerSpecLimitChange + ", inspSpecHasLowrSpecLimitChange=" + this.inspSpecHasLowrSpecLimitChange + ", inspSpecUpperLimit=" + this.inspSpecUpperLimit + ", inspSpecHasUpperLimit=" + this.inspSpecHasUpperLimit + ", inspSpecUpperPlausibilityLimit=" + this.inspSpecUpperPlausibilityLimit + ", inspectionSpecificationSrchTxt=" + this.inspectionSpecificationSrchTxt + ", inspSpecHasUprPlausibilityLmt=" + this.inspSpecHasUprPlausibilityLmt + ", inspSpecFirstUpperSpecLimit=" + this.inspSpecFirstUpperSpecLimit + ", inspSpecHasFirstUpperSpecLimit=" + this.inspSpecHasFirstUpperSpecLimit + ", inspSpecSecondUpperSpecLimit=" + this.inspSpecSecondUpperSpecLimit + ", inspSpecHasSecondUprSpecLimit=" + this.inspSpecHasSecondUprSpecLimit + ", inspSpecUpperSpecLimitChange=" + this.inspSpecUpperSpecLimitChange + ", inspSpecHasUprSpecLimitChange=" + this.inspSpecHasUprSpecLimitChange + ", inspSpecToleranceChgValidFrom=" + this.inspSpecToleranceChgValidFrom + ", inspSpecToleranceChgValidTo=" + this.inspSpecToleranceChgValidTo + ", inspSpecDefectCodeGrpRejection=" + this.inspSpecDefectCodeGrpRejection + ", inspSpecGlobalName=" + this.inspSpecGlobalName + ", inspSpecDefectCodeRejection=" + this.inspSpecDefectCodeRejection + ", inspSpecDefectCodeGrpRjcnUpper=" + this.inspSpecDefectCodeGrpRjcnUpper + ", inspSpecDefectCodeRjcnUpper=" + this.inspSpecDefectCodeRjcnUpper + ", inspSpecDefectCodeGrpRjcnLower=" + this.inspSpecDefectCodeGrpRjcnLower + ", inspSpecDefectCodeRjcnLower=" + this.inspSpecDefectCodeRjcnLower + ", characteristicInternalID=" + this.characteristicInternalID + ", defectFractionEstimationProced=" + this.defectFractionEstimationProced + ", inspectionSpecificationStatus=" + this.inspectionSpecificationStatus + ", inspSpecTransferType=" + this.inspSpecTransferType + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InspectionSpecification)) {
                return false;
            }
            InspectionSpecification other = (InspectionSpecification)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$inspectionSpecification = this.inspectionSpecification;
            String other$inspectionSpecification = other.inspectionSpecification;
            if (this$inspectionSpecification == null ? other$inspectionSpecification != null : !this$inspectionSpecification.equals(other$inspectionSpecification)) {
                return false;
            }
            String this$inspSpecCreatedByUser = this.inspSpecCreatedByUser;
            String other$inspSpecCreatedByUser = other.inspSpecCreatedByUser;
            if (this$inspSpecCreatedByUser == null ? other$inspSpecCreatedByUser != null : !this$inspSpecCreatedByUser.equals(other$inspSpecCreatedByUser)) {
                return false;
            }
            Calendar this$inspSpecCreationDate = this.inspSpecCreationDate;
            Calendar other$inspSpecCreationDate = other.inspSpecCreationDate;
            if (this$inspSpecCreationDate == null ? other$inspSpecCreationDate != null : !((Object)this$inspSpecCreationDate).equals(other$inspSpecCreationDate)) {
                return false;
            }
            String this$inspSpecChangedByUser = this.inspSpecChangedByUser;
            String other$inspSpecChangedByUser = other.inspSpecChangedByUser;
            if (this$inspSpecChangedByUser == null ? other$inspSpecChangedByUser != null : !this$inspSpecChangedByUser.equals(other$inspSpecChangedByUser)) {
                return false;
            }
            Calendar this$inspSpecChangeDate = this.inspSpecChangeDate;
            Calendar other$inspSpecChangeDate = other.inspSpecChangeDate;
            if (this$inspSpecChangeDate == null ? other$inspSpecChangeDate != null : !((Object)this$inspSpecChangeDate).equals(other$inspSpecChangeDate)) {
                return false;
            }
            Boolean this$inspSpecIsQuantitative = this.inspSpecIsQuantitative;
            Boolean other$inspSpecIsQuantitative = other.inspSpecIsQuantitative;
            if (this$inspSpecIsQuantitative == null ? other$inspSpecIsQuantitative != null : !((Object)this$inspSpecIsQuantitative).equals(other$inspSpecIsQuantitative)) {
                return false;
            }
            String this$inspSpecCharacteristicType = this.inspSpecCharacteristicType;
            String other$inspSpecCharacteristicType = other.inspSpecCharacteristicType;
            if (this$inspSpecCharacteristicType == null ? other$inspSpecCharacteristicType != null : !this$inspSpecCharacteristicType.equals(other$inspSpecCharacteristicType)) {
                return false;
            }
            String this$inspSpecIsMeasuredValueRqd = this.inspSpecIsMeasuredValueRqd;
            String other$inspSpecIsMeasuredValueRqd = other.inspSpecIsMeasuredValueRqd;
            if (this$inspSpecIsMeasuredValueRqd == null ? other$inspSpecIsMeasuredValueRqd != null : !this$inspSpecIsMeasuredValueRqd.equals(other$inspSpecIsMeasuredValueRqd)) {
                return false;
            }
            String this$inspSpecIsSelectedSetRequired = this.inspSpecIsSelectedSetRequired;
            String other$inspSpecIsSelectedSetRequired = other.inspSpecIsSelectedSetRequired;
            if (this$inspSpecIsSelectedSetRequired == null ? other$inspSpecIsSelectedSetRequired != null : !this$inspSpecIsSelectedSetRequired.equals(other$inspSpecIsSelectedSetRequired)) {
                return false;
            }
            String this$inspSpecIsUpperLimitRequired = this.inspSpecIsUpperLimitRequired;
            String other$inspSpecIsUpperLimitRequired = other.inspSpecIsUpperLimitRequired;
            if (this$inspSpecIsUpperLimitRequired == null ? other$inspSpecIsUpperLimitRequired != null : !this$inspSpecIsUpperLimitRequired.equals(other$inspSpecIsUpperLimitRequired)) {
                return false;
            }
            String this$inspSpecIsLowerLimitRequired = this.inspSpecIsLowerLimitRequired;
            String other$inspSpecIsLowerLimitRequired = other.inspSpecIsLowerLimitRequired;
            if (this$inspSpecIsLowerLimitRequired == null ? other$inspSpecIsLowerLimitRequired != null : !this$inspSpecIsLowerLimitRequired.equals(other$inspSpecIsLowerLimitRequired)) {
                return false;
            }
            String this$inspectionSpecificationVersion = this.inspectionSpecificationVersion;
            String other$inspectionSpecificationVersion = other.inspectionSpecificationVersion;
            if (this$inspectionSpecificationVersion == null ? other$inspectionSpecificationVersion != null : !this$inspectionSpecificationVersion.equals(other$inspectionSpecificationVersion)) {
                return false;
            }
            String this$inspSpecIsTargetValueInLimit = this.inspSpecIsTargetValueInLimit;
            String other$inspSpecIsTargetValueInLimit = other.inspSpecIsTargetValueInLimit;
            if (this$inspSpecIsTargetValueInLimit == null ? other$inspSpecIsTargetValueInLimit != null : !this$inspSpecIsTargetValueInLimit.equals(other$inspSpecIsTargetValueInLimit)) {
                return false;
            }
            String this$inspectionScope = this.inspectionScope;
            String other$inspectionScope = other.inspectionScope;
            if (this$inspectionScope == null ? other$inspectionScope != null : !this$inspectionScope.equals(other$inspectionScope)) {
                return false;
            }
            String this$inspSpecIsLongTermInspection = this.inspSpecIsLongTermInspection;
            String other$inspSpecIsLongTermInspection = other.inspSpecIsLongTermInspection;
            if (this$inspSpecIsLongTermInspection == null ? other$inspSpecIsLongTermInspection != null : !this$inspSpecIsLongTermInspection.equals(other$inspSpecIsLongTermInspection)) {
                return false;
            }
            String this$inspSpecRecordingType = this.inspSpecRecordingType;
            String other$inspSpecRecordingType = other.inspSpecRecordingType;
            if (this$inspSpecRecordingType == null ? other$inspSpecRecordingType != null : !this$inspSpecRecordingType.equals(other$inspSpecRecordingType)) {
                return false;
            }
            String this$inspResultIsDocumentationRqd = this.inspResultIsDocumentationRqd;
            String other$inspResultIsDocumentationRqd = other.inspResultIsDocumentationRqd;
            if (this$inspResultIsDocumentationRqd == null ? other$inspResultIsDocumentationRqd != null : !this$inspResultIsDocumentationRqd.equals(other$inspResultIsDocumentationRqd)) {
                return false;
            }
            String this$inspSpecCharcCategory = this.inspSpecCharcCategory;
            String other$inspSpecCharcCategory = other.inspSpecCharcCategory;
            if (this$inspSpecCharcCategory == null ? other$inspSpecCharcCategory != null : !this$inspSpecCharcCategory.equals(other$inspSpecCharcCategory)) {
                return false;
            }
            String this$inspSpecIsDefectsRecgAutomatic = this.inspSpecIsDefectsRecgAutomatic;
            String other$inspSpecIsDefectsRecgAutomatic = other.inspSpecIsDefectsRecgAutomatic;
            if (this$inspSpecIsDefectsRecgAutomatic == null ? other$inspSpecIsDefectsRecgAutomatic != null : !this$inspSpecIsDefectsRecgAutomatic.equals(other$inspSpecIsDefectsRecgAutomatic)) {
                return false;
            }
            String this$inspSpecIsSampleQtyAdditive = this.inspSpecIsSampleQtyAdditive;
            String other$inspSpecIsSampleQtyAdditive = other.inspSpecIsSampleQtyAdditive;
            if (this$inspSpecIsSampleQtyAdditive == null ? other$inspSpecIsSampleQtyAdditive != null : !this$inspSpecIsSampleQtyAdditive.equals(other$inspSpecIsSampleQtyAdditive)) {
                return false;
            }
            String this$inspSpecIsDestructive = this.inspSpecIsDestructive;
            String other$inspSpecIsDestructive = other.inspSpecIsDestructive;
            if (this$inspSpecIsDestructive == null ? other$inspSpecIsDestructive != null : !this$inspSpecIsDestructive.equals(other$inspSpecIsDestructive)) {
                return false;
            }
            String this$inspSpecResultCalculation = this.inspSpecResultCalculation;
            String other$inspSpecResultCalculation = other.inspSpecResultCalculation;
            if (this$inspSpecResultCalculation == null ? other$inspSpecResultCalculation != null : !this$inspSpecResultCalculation.equals(other$inspSpecResultCalculation)) {
                return false;
            }
            String this$inspectionSpecificationPlant = this.inspectionSpecificationPlant;
            String other$inspectionSpecificationPlant = other.inspectionSpecificationPlant;
            if (this$inspectionSpecificationPlant == null ? other$inspectionSpecificationPlant != null : !this$inspectionSpecificationPlant.equals(other$inspectionSpecificationPlant)) {
                return false;
            }
            String this$inspSpecIsSamplingProcedRqd = this.inspSpecIsSamplingProcedRqd;
            String other$inspSpecIsSamplingProcedRqd = other.inspSpecIsSamplingProcedRqd;
            if (this$inspSpecIsSamplingProcedRqd == null ? other$inspSpecIsSamplingProcedRqd != null : !this$inspSpecIsSamplingProcedRqd.equals(other$inspSpecIsSamplingProcedRqd)) {
                return false;
            }
            String this$inspSpecIsScrapRelevant = this.inspSpecIsScrapRelevant;
            String other$inspSpecIsScrapRelevant = other.inspSpecIsScrapRelevant;
            if (this$inspSpecIsScrapRelevant == null ? other$inspSpecIsScrapRelevant != null : !this$inspSpecIsScrapRelevant.equals(other$inspSpecIsScrapRelevant)) {
                return false;
            }
            String this$inspSpecIsTestEquipmentRqd = this.inspSpecIsTestEquipmentRqd;
            String other$inspSpecIsTestEquipmentRqd = other.inspSpecIsTestEquipmentRqd;
            if (this$inspSpecIsTestEquipmentRqd == null ? other$inspSpecIsTestEquipmentRqd != null : !this$inspSpecIsTestEquipmentRqd.equals(other$inspSpecIsTestEquipmentRqd)) {
                return false;
            }
            String this$inspSpecIsChgDocRequired = this.inspSpecIsChgDocRequired;
            String other$inspSpecIsChgDocRequired = other.inspSpecIsChgDocRequired;
            if (this$inspSpecIsChgDocRequired == null ? other$inspSpecIsChgDocRequired != null : !this$inspSpecIsChgDocRequired.equals(other$inspSpecIsChgDocRequired)) {
                return false;
            }
            String this$inspSpecIsControlChartUsed = this.inspSpecIsControlChartUsed;
            String other$inspSpecIsControlChartUsed = other.inspSpecIsControlChartUsed;
            if (this$inspSpecIsControlChartUsed == null ? other$inspSpecIsControlChartUsed != null : !this$inspSpecIsControlChartUsed.equals(other$inspSpecIsControlChartUsed)) {
                return false;
            }
            String this$inspSpecPrintControl = this.inspSpecPrintControl;
            String other$inspSpecPrintControl = other.inspSpecPrintControl;
            if (this$inspSpecPrintControl == null ? other$inspSpecPrintControl != null : !this$inspSpecPrintControl.equals(other$inspSpecPrintControl)) {
                return false;
            }
            String this$inspSpecImportanceCode = this.inspSpecImportanceCode;
            String other$inspSpecImportanceCode = other.inspSpecImportanceCode;
            if (this$inspSpecImportanceCode == null ? other$inspSpecImportanceCode != null : !this$inspSpecImportanceCode.equals(other$inspSpecImportanceCode)) {
                return false;
            }
            String this$inspectorQualification = this.inspectorQualification;
            String other$inspectorQualification = other.inspectorQualification;
            if (this$inspectorQualification == null ? other$inspectorQualification != null : !this$inspectorQualification.equals(other$inspectorQualification)) {
                return false;
            }
            String this$inspSpecInformationField1 = this.inspSpecInformationField1;
            String other$inspSpecInformationField1 = other.inspSpecInformationField1;
            if (this$inspSpecInformationField1 == null ? other$inspSpecInformationField1 != null : !this$inspSpecInformationField1.equals(other$inspSpecInformationField1)) {
                return false;
            }
            String this$inspSpecInformationField2 = this.inspSpecInformationField2;
            String other$inspSpecInformationField2 = other.inspSpecInformationField2;
            if (this$inspSpecInformationField2 == null ? other$inspSpecInformationField2 != null : !this$inspSpecInformationField2.equals(other$inspSpecInformationField2)) {
                return false;
            }
            String this$plant = this.plant;
            String other$plant = other.plant;
            if (this$plant == null ? other$plant != null : !this$plant.equals(other$plant)) {
                return false;
            }
            String this$inspSpecInformationField3 = this.inspSpecInformationField3;
            String other$inspSpecInformationField3 = other.inspSpecInformationField3;
            if (this$inspSpecInformationField3 == null ? other$inspSpecInformationField3 != null : !this$inspSpecInformationField3.equals(other$inspSpecInformationField3)) {
                return false;
            }
            String this$qltyMstrDataAuthorizationGroup = this.qltyMstrDataAuthorizationGroup;
            String other$qltyMstrDataAuthorizationGroup = other.qltyMstrDataAuthorizationGroup;
            if (this$qltyMstrDataAuthorizationGroup == null ? other$qltyMstrDataAuthorizationGroup != null : !this$qltyMstrDataAuthorizationGroup.equals(other$qltyMstrDataAuthorizationGroup)) {
                return false;
            }
            String this$inspToleranceSpecification = this.inspToleranceSpecification;
            String other$inspToleranceSpecification = other.inspToleranceSpecification;
            if (this$inspToleranceSpecification == null ? other$inspToleranceSpecification != null : !this$inspToleranceSpecification.equals(other$inspToleranceSpecification)) {
                return false;
            }
            Short this$inspSpecDecimalPlaces = this.inspSpecDecimalPlaces;
            Short other$inspSpecDecimalPlaces = other.inspSpecDecimalPlaces;
            if (this$inspSpecDecimalPlaces == null ? other$inspSpecDecimalPlaces != null : !((Object)this$inspSpecDecimalPlaces).equals(other$inspSpecDecimalPlaces)) {
                return false;
            }
            String this$inspectionSpecificationUnit = this.inspectionSpecificationUnit;
            String other$inspectionSpecificationUnit = other.inspectionSpecificationUnit;
            if (this$inspectionSpecificationUnit == null ? other$inspectionSpecificationUnit != null : !this$inspectionSpecificationUnit.equals(other$inspectionSpecificationUnit)) {
                return false;
            }
            Double this$inspSpecTargetValue = this.inspSpecTargetValue;
            Double other$inspSpecTargetValue = other.inspSpecTargetValue;
            if (this$inspSpecTargetValue == null ? other$inspSpecTargetValue != null : !((Object)this$inspSpecTargetValue).equals(other$inspSpecTargetValue)) {
                return false;
            }
            String this$inspSpecHasTargetValue = this.inspSpecHasTargetValue;
            String other$inspSpecHasTargetValue = other.inspSpecHasTargetValue;
            if (this$inspSpecHasTargetValue == null ? other$inspSpecHasTargetValue != null : !this$inspSpecHasTargetValue.equals(other$inspSpecHasTargetValue)) {
                return false;
            }
            Double this$inspSpecLowerLimit = this.inspSpecLowerLimit;
            Double other$inspSpecLowerLimit = other.inspSpecLowerLimit;
            if (this$inspSpecLowerLimit == null ? other$inspSpecLowerLimit != null : !((Object)this$inspSpecLowerLimit).equals(other$inspSpecLowerLimit)) {
                return false;
            }
            String this$inspSpecHasLowerLimit = this.inspSpecHasLowerLimit;
            String other$inspSpecHasLowerLimit = other.inspSpecHasLowerLimit;
            if (this$inspSpecHasLowerLimit == null ? other$inspSpecHasLowerLimit != null : !this$inspSpecHasLowerLimit.equals(other$inspSpecHasLowerLimit)) {
                return false;
            }
            Double this$inspSpecLowerPlausibilityLimit = this.inspSpecLowerPlausibilityLimit;
            Double other$inspSpecLowerPlausibilityLimit = other.inspSpecLowerPlausibilityLimit;
            if (this$inspSpecLowerPlausibilityLimit == null ? other$inspSpecLowerPlausibilityLimit != null : !((Object)this$inspSpecLowerPlausibilityLimit).equals(other$inspSpecLowerPlausibilityLimit)) {
                return false;
            }
            Calendar this$validityStartDate = this.validityStartDate;
            Calendar other$validityStartDate = other.validityStartDate;
            if (this$validityStartDate == null ? other$validityStartDate != null : !((Object)this$validityStartDate).equals(other$validityStartDate)) {
                return false;
            }
            String this$inspSpecHasLowrPlausibilityLmt = this.inspSpecHasLowrPlausibilityLmt;
            String other$inspSpecHasLowrPlausibilityLmt = other.inspSpecHasLowrPlausibilityLmt;
            if (this$inspSpecHasLowrPlausibilityLmt == null ? other$inspSpecHasLowrPlausibilityLmt != null : !this$inspSpecHasLowrPlausibilityLmt.equals(other$inspSpecHasLowrPlausibilityLmt)) {
                return false;
            }
            Double this$inspSpecFirstLowerSpecLimit = this.inspSpecFirstLowerSpecLimit;
            Double other$inspSpecFirstLowerSpecLimit = other.inspSpecFirstLowerSpecLimit;
            if (this$inspSpecFirstLowerSpecLimit == null ? other$inspSpecFirstLowerSpecLimit != null : !((Object)this$inspSpecFirstLowerSpecLimit).equals(other$inspSpecFirstLowerSpecLimit)) {
                return false;
            }
            String this$inspSpecHasFirstLowerSpecLimit = this.inspSpecHasFirstLowerSpecLimit;
            String other$inspSpecHasFirstLowerSpecLimit = other.inspSpecHasFirstLowerSpecLimit;
            if (this$inspSpecHasFirstLowerSpecLimit == null ? other$inspSpecHasFirstLowerSpecLimit != null : !this$inspSpecHasFirstLowerSpecLimit.equals(other$inspSpecHasFirstLowerSpecLimit)) {
                return false;
            }
            Double this$inspSpecSecondLowerSpecLimit = this.inspSpecSecondLowerSpecLimit;
            Double other$inspSpecSecondLowerSpecLimit = other.inspSpecSecondLowerSpecLimit;
            if (this$inspSpecSecondLowerSpecLimit == null ? other$inspSpecSecondLowerSpecLimit != null : !((Object)this$inspSpecSecondLowerSpecLimit).equals(other$inspSpecSecondLowerSpecLimit)) {
                return false;
            }
            String this$inspSpecHasSecondLowrSpecLimit = this.inspSpecHasSecondLowrSpecLimit;
            String other$inspSpecHasSecondLowrSpecLimit = other.inspSpecHasSecondLowrSpecLimit;
            if (this$inspSpecHasSecondLowrSpecLimit == null ? other$inspSpecHasSecondLowrSpecLimit != null : !this$inspSpecHasSecondLowrSpecLimit.equals(other$inspSpecHasSecondLowrSpecLimit)) {
                return false;
            }
            Double this$inspSpecLowerSpecLimitChange = this.inspSpecLowerSpecLimitChange;
            Double other$inspSpecLowerSpecLimitChange = other.inspSpecLowerSpecLimitChange;
            if (this$inspSpecLowerSpecLimitChange == null ? other$inspSpecLowerSpecLimitChange != null : !((Object)this$inspSpecLowerSpecLimitChange).equals(other$inspSpecLowerSpecLimitChange)) {
                return false;
            }
            String this$inspSpecHasLowrSpecLimitChange = this.inspSpecHasLowrSpecLimitChange;
            String other$inspSpecHasLowrSpecLimitChange = other.inspSpecHasLowrSpecLimitChange;
            if (this$inspSpecHasLowrSpecLimitChange == null ? other$inspSpecHasLowrSpecLimitChange != null : !this$inspSpecHasLowrSpecLimitChange.equals(other$inspSpecHasLowrSpecLimitChange)) {
                return false;
            }
            Double this$inspSpecUpperLimit = this.inspSpecUpperLimit;
            Double other$inspSpecUpperLimit = other.inspSpecUpperLimit;
            if (this$inspSpecUpperLimit == null ? other$inspSpecUpperLimit != null : !((Object)this$inspSpecUpperLimit).equals(other$inspSpecUpperLimit)) {
                return false;
            }
            String this$inspSpecHasUpperLimit = this.inspSpecHasUpperLimit;
            String other$inspSpecHasUpperLimit = other.inspSpecHasUpperLimit;
            if (this$inspSpecHasUpperLimit == null ? other$inspSpecHasUpperLimit != null : !this$inspSpecHasUpperLimit.equals(other$inspSpecHasUpperLimit)) {
                return false;
            }
            Double this$inspSpecUpperPlausibilityLimit = this.inspSpecUpperPlausibilityLimit;
            Double other$inspSpecUpperPlausibilityLimit = other.inspSpecUpperPlausibilityLimit;
            if (this$inspSpecUpperPlausibilityLimit == null ? other$inspSpecUpperPlausibilityLimit != null : !((Object)this$inspSpecUpperPlausibilityLimit).equals(other$inspSpecUpperPlausibilityLimit)) {
                return false;
            }
            String this$inspectionSpecificationSrchTxt = this.inspectionSpecificationSrchTxt;
            String other$inspectionSpecificationSrchTxt = other.inspectionSpecificationSrchTxt;
            if (this$inspectionSpecificationSrchTxt == null ? other$inspectionSpecificationSrchTxt != null : !this$inspectionSpecificationSrchTxt.equals(other$inspectionSpecificationSrchTxt)) {
                return false;
            }
            String this$inspSpecHasUprPlausibilityLmt = this.inspSpecHasUprPlausibilityLmt;
            String other$inspSpecHasUprPlausibilityLmt = other.inspSpecHasUprPlausibilityLmt;
            if (this$inspSpecHasUprPlausibilityLmt == null ? other$inspSpecHasUprPlausibilityLmt != null : !this$inspSpecHasUprPlausibilityLmt.equals(other$inspSpecHasUprPlausibilityLmt)) {
                return false;
            }
            Double this$inspSpecFirstUpperSpecLimit = this.inspSpecFirstUpperSpecLimit;
            Double other$inspSpecFirstUpperSpecLimit = other.inspSpecFirstUpperSpecLimit;
            if (this$inspSpecFirstUpperSpecLimit == null ? other$inspSpecFirstUpperSpecLimit != null : !((Object)this$inspSpecFirstUpperSpecLimit).equals(other$inspSpecFirstUpperSpecLimit)) {
                return false;
            }
            String this$inspSpecHasFirstUpperSpecLimit = this.inspSpecHasFirstUpperSpecLimit;
            String other$inspSpecHasFirstUpperSpecLimit = other.inspSpecHasFirstUpperSpecLimit;
            if (this$inspSpecHasFirstUpperSpecLimit == null ? other$inspSpecHasFirstUpperSpecLimit != null : !this$inspSpecHasFirstUpperSpecLimit.equals(other$inspSpecHasFirstUpperSpecLimit)) {
                return false;
            }
            Double this$inspSpecSecondUpperSpecLimit = this.inspSpecSecondUpperSpecLimit;
            Double other$inspSpecSecondUpperSpecLimit = other.inspSpecSecondUpperSpecLimit;
            if (this$inspSpecSecondUpperSpecLimit == null ? other$inspSpecSecondUpperSpecLimit != null : !((Object)this$inspSpecSecondUpperSpecLimit).equals(other$inspSpecSecondUpperSpecLimit)) {
                return false;
            }
            String this$inspSpecHasSecondUprSpecLimit = this.inspSpecHasSecondUprSpecLimit;
            String other$inspSpecHasSecondUprSpecLimit = other.inspSpecHasSecondUprSpecLimit;
            if (this$inspSpecHasSecondUprSpecLimit == null ? other$inspSpecHasSecondUprSpecLimit != null : !this$inspSpecHasSecondUprSpecLimit.equals(other$inspSpecHasSecondUprSpecLimit)) {
                return false;
            }
            Double this$inspSpecUpperSpecLimitChange = this.inspSpecUpperSpecLimitChange;
            Double other$inspSpecUpperSpecLimitChange = other.inspSpecUpperSpecLimitChange;
            if (this$inspSpecUpperSpecLimitChange == null ? other$inspSpecUpperSpecLimitChange != null : !((Object)this$inspSpecUpperSpecLimitChange).equals(other$inspSpecUpperSpecLimitChange)) {
                return false;
            }
            String this$inspSpecHasUprSpecLimitChange = this.inspSpecHasUprSpecLimitChange;
            String other$inspSpecHasUprSpecLimitChange = other.inspSpecHasUprSpecLimitChange;
            if (this$inspSpecHasUprSpecLimitChange == null ? other$inspSpecHasUprSpecLimitChange != null : !this$inspSpecHasUprSpecLimitChange.equals(other$inspSpecHasUprSpecLimitChange)) {
                return false;
            }
            Calendar this$inspSpecToleranceChgValidFrom = this.inspSpecToleranceChgValidFrom;
            Calendar other$inspSpecToleranceChgValidFrom = other.inspSpecToleranceChgValidFrom;
            if (this$inspSpecToleranceChgValidFrom == null ? other$inspSpecToleranceChgValidFrom != null : !((Object)this$inspSpecToleranceChgValidFrom).equals(other$inspSpecToleranceChgValidFrom)) {
                return false;
            }
            Calendar this$inspSpecToleranceChgValidTo = this.inspSpecToleranceChgValidTo;
            Calendar other$inspSpecToleranceChgValidTo = other.inspSpecToleranceChgValidTo;
            if (this$inspSpecToleranceChgValidTo == null ? other$inspSpecToleranceChgValidTo != null : !((Object)this$inspSpecToleranceChgValidTo).equals(other$inspSpecToleranceChgValidTo)) {
                return false;
            }
            String this$inspSpecDefectCodeGrpRejection = this.inspSpecDefectCodeGrpRejection;
            String other$inspSpecDefectCodeGrpRejection = other.inspSpecDefectCodeGrpRejection;
            if (this$inspSpecDefectCodeGrpRejection == null ? other$inspSpecDefectCodeGrpRejection != null : !this$inspSpecDefectCodeGrpRejection.equals(other$inspSpecDefectCodeGrpRejection)) {
                return false;
            }
            String this$inspSpecGlobalName = this.inspSpecGlobalName;
            String other$inspSpecGlobalName = other.inspSpecGlobalName;
            if (this$inspSpecGlobalName == null ? other$inspSpecGlobalName != null : !this$inspSpecGlobalName.equals(other$inspSpecGlobalName)) {
                return false;
            }
            String this$inspSpecDefectCodeRejection = this.inspSpecDefectCodeRejection;
            String other$inspSpecDefectCodeRejection = other.inspSpecDefectCodeRejection;
            if (this$inspSpecDefectCodeRejection == null ? other$inspSpecDefectCodeRejection != null : !this$inspSpecDefectCodeRejection.equals(other$inspSpecDefectCodeRejection)) {
                return false;
            }
            String this$inspSpecDefectCodeGrpRjcnUpper = this.inspSpecDefectCodeGrpRjcnUpper;
            String other$inspSpecDefectCodeGrpRjcnUpper = other.inspSpecDefectCodeGrpRjcnUpper;
            if (this$inspSpecDefectCodeGrpRjcnUpper == null ? other$inspSpecDefectCodeGrpRjcnUpper != null : !this$inspSpecDefectCodeGrpRjcnUpper.equals(other$inspSpecDefectCodeGrpRjcnUpper)) {
                return false;
            }
            String this$inspSpecDefectCodeRjcnUpper = this.inspSpecDefectCodeRjcnUpper;
            String other$inspSpecDefectCodeRjcnUpper = other.inspSpecDefectCodeRjcnUpper;
            if (this$inspSpecDefectCodeRjcnUpper == null ? other$inspSpecDefectCodeRjcnUpper != null : !this$inspSpecDefectCodeRjcnUpper.equals(other$inspSpecDefectCodeRjcnUpper)) {
                return false;
            }
            String this$inspSpecDefectCodeGrpRjcnLower = this.inspSpecDefectCodeGrpRjcnLower;
            String other$inspSpecDefectCodeGrpRjcnLower = other.inspSpecDefectCodeGrpRjcnLower;
            if (this$inspSpecDefectCodeGrpRjcnLower == null ? other$inspSpecDefectCodeGrpRjcnLower != null : !this$inspSpecDefectCodeGrpRjcnLower.equals(other$inspSpecDefectCodeGrpRjcnLower)) {
                return false;
            }
            String this$inspSpecDefectCodeRjcnLower = this.inspSpecDefectCodeRjcnLower;
            String other$inspSpecDefectCodeRjcnLower = other.inspSpecDefectCodeRjcnLower;
            if (this$inspSpecDefectCodeRjcnLower == null ? other$inspSpecDefectCodeRjcnLower != null : !this$inspSpecDefectCodeRjcnLower.equals(other$inspSpecDefectCodeRjcnLower)) {
                return false;
            }
            String this$characteristicInternalID = this.characteristicInternalID;
            String other$characteristicInternalID = other.characteristicInternalID;
            if (this$characteristicInternalID == null ? other$characteristicInternalID != null : !this$characteristicInternalID.equals(other$characteristicInternalID)) {
                return false;
            }
            String this$defectFractionEstimationProced = this.defectFractionEstimationProced;
            String other$defectFractionEstimationProced = other.defectFractionEstimationProced;
            if (this$defectFractionEstimationProced == null ? other$defectFractionEstimationProced != null : !this$defectFractionEstimationProced.equals(other$defectFractionEstimationProced)) {
                return false;
            }
            String this$inspectionSpecificationStatus = this.inspectionSpecificationStatus;
            String other$inspectionSpecificationStatus = other.inspectionSpecificationStatus;
            if (this$inspectionSpecificationStatus == null ? other$inspectionSpecificationStatus != null : !this$inspectionSpecificationStatus.equals(other$inspectionSpecificationStatus)) {
                return false;
            }
            String this$inspSpecTransferType = this.inspSpecTransferType;
            String other$inspSpecTransferType = other.inspSpecTransferType;
            return !(this$inspSpecTransferType == null ? other$inspSpecTransferType != null : !this$inspSpecTransferType.equals(other$inspSpecTransferType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof InspectionSpecification;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $inspectionSpecification = this.inspectionSpecification;
            result = result * 59 + ($inspectionSpecification == null ? 43 : $inspectionSpecification.hashCode());
            String $inspSpecCreatedByUser = this.inspSpecCreatedByUser;
            result = result * 59 + ($inspSpecCreatedByUser == null ? 43 : $inspSpecCreatedByUser.hashCode());
            Calendar $inspSpecCreationDate = this.inspSpecCreationDate;
            result = result * 59 + ($inspSpecCreationDate == null ? 43 : ((Object)$inspSpecCreationDate).hashCode());
            String $inspSpecChangedByUser = this.inspSpecChangedByUser;
            result = result * 59 + ($inspSpecChangedByUser == null ? 43 : $inspSpecChangedByUser.hashCode());
            Calendar $inspSpecChangeDate = this.inspSpecChangeDate;
            result = result * 59 + ($inspSpecChangeDate == null ? 43 : ((Object)$inspSpecChangeDate).hashCode());
            Boolean $inspSpecIsQuantitative = this.inspSpecIsQuantitative;
            result = result * 59 + ($inspSpecIsQuantitative == null ? 43 : ((Object)$inspSpecIsQuantitative).hashCode());
            String $inspSpecCharacteristicType = this.inspSpecCharacteristicType;
            result = result * 59 + ($inspSpecCharacteristicType == null ? 43 : $inspSpecCharacteristicType.hashCode());
            String $inspSpecIsMeasuredValueRqd = this.inspSpecIsMeasuredValueRqd;
            result = result * 59 + ($inspSpecIsMeasuredValueRqd == null ? 43 : $inspSpecIsMeasuredValueRqd.hashCode());
            String $inspSpecIsSelectedSetRequired = this.inspSpecIsSelectedSetRequired;
            result = result * 59 + ($inspSpecIsSelectedSetRequired == null ? 43 : $inspSpecIsSelectedSetRequired.hashCode());
            String $inspSpecIsUpperLimitRequired = this.inspSpecIsUpperLimitRequired;
            result = result * 59 + ($inspSpecIsUpperLimitRequired == null ? 43 : $inspSpecIsUpperLimitRequired.hashCode());
            String $inspSpecIsLowerLimitRequired = this.inspSpecIsLowerLimitRequired;
            result = result * 59 + ($inspSpecIsLowerLimitRequired == null ? 43 : $inspSpecIsLowerLimitRequired.hashCode());
            String $inspectionSpecificationVersion = this.inspectionSpecificationVersion;
            result = result * 59 + ($inspectionSpecificationVersion == null ? 43 : $inspectionSpecificationVersion.hashCode());
            String $inspSpecIsTargetValueInLimit = this.inspSpecIsTargetValueInLimit;
            result = result * 59 + ($inspSpecIsTargetValueInLimit == null ? 43 : $inspSpecIsTargetValueInLimit.hashCode());
            String $inspectionScope = this.inspectionScope;
            result = result * 59 + ($inspectionScope == null ? 43 : $inspectionScope.hashCode());
            String $inspSpecIsLongTermInspection = this.inspSpecIsLongTermInspection;
            result = result * 59 + ($inspSpecIsLongTermInspection == null ? 43 : $inspSpecIsLongTermInspection.hashCode());
            String $inspSpecRecordingType = this.inspSpecRecordingType;
            result = result * 59 + ($inspSpecRecordingType == null ? 43 : $inspSpecRecordingType.hashCode());
            String $inspResultIsDocumentationRqd = this.inspResultIsDocumentationRqd;
            result = result * 59 + ($inspResultIsDocumentationRqd == null ? 43 : $inspResultIsDocumentationRqd.hashCode());
            String $inspSpecCharcCategory = this.inspSpecCharcCategory;
            result = result * 59 + ($inspSpecCharcCategory == null ? 43 : $inspSpecCharcCategory.hashCode());
            String $inspSpecIsDefectsRecgAutomatic = this.inspSpecIsDefectsRecgAutomatic;
            result = result * 59 + ($inspSpecIsDefectsRecgAutomatic == null ? 43 : $inspSpecIsDefectsRecgAutomatic.hashCode());
            String $inspSpecIsSampleQtyAdditive = this.inspSpecIsSampleQtyAdditive;
            result = result * 59 + ($inspSpecIsSampleQtyAdditive == null ? 43 : $inspSpecIsSampleQtyAdditive.hashCode());
            String $inspSpecIsDestructive = this.inspSpecIsDestructive;
            result = result * 59 + ($inspSpecIsDestructive == null ? 43 : $inspSpecIsDestructive.hashCode());
            String $inspSpecResultCalculation = this.inspSpecResultCalculation;
            result = result * 59 + ($inspSpecResultCalculation == null ? 43 : $inspSpecResultCalculation.hashCode());
            String $inspectionSpecificationPlant = this.inspectionSpecificationPlant;
            result = result * 59 + ($inspectionSpecificationPlant == null ? 43 : $inspectionSpecificationPlant.hashCode());
            String $inspSpecIsSamplingProcedRqd = this.inspSpecIsSamplingProcedRqd;
            result = result * 59 + ($inspSpecIsSamplingProcedRqd == null ? 43 : $inspSpecIsSamplingProcedRqd.hashCode());
            String $inspSpecIsScrapRelevant = this.inspSpecIsScrapRelevant;
            result = result * 59 + ($inspSpecIsScrapRelevant == null ? 43 : $inspSpecIsScrapRelevant.hashCode());
            String $inspSpecIsTestEquipmentRqd = this.inspSpecIsTestEquipmentRqd;
            result = result * 59 + ($inspSpecIsTestEquipmentRqd == null ? 43 : $inspSpecIsTestEquipmentRqd.hashCode());
            String $inspSpecIsChgDocRequired = this.inspSpecIsChgDocRequired;
            result = result * 59 + ($inspSpecIsChgDocRequired == null ? 43 : $inspSpecIsChgDocRequired.hashCode());
            String $inspSpecIsControlChartUsed = this.inspSpecIsControlChartUsed;
            result = result * 59 + ($inspSpecIsControlChartUsed == null ? 43 : $inspSpecIsControlChartUsed.hashCode());
            String $inspSpecPrintControl = this.inspSpecPrintControl;
            result = result * 59 + ($inspSpecPrintControl == null ? 43 : $inspSpecPrintControl.hashCode());
            String $inspSpecImportanceCode = this.inspSpecImportanceCode;
            result = result * 59 + ($inspSpecImportanceCode == null ? 43 : $inspSpecImportanceCode.hashCode());
            String $inspectorQualification = this.inspectorQualification;
            result = result * 59 + ($inspectorQualification == null ? 43 : $inspectorQualification.hashCode());
            String $inspSpecInformationField1 = this.inspSpecInformationField1;
            result = result * 59 + ($inspSpecInformationField1 == null ? 43 : $inspSpecInformationField1.hashCode());
            String $inspSpecInformationField2 = this.inspSpecInformationField2;
            result = result * 59 + ($inspSpecInformationField2 == null ? 43 : $inspSpecInformationField2.hashCode());
            String $plant = this.plant;
            result = result * 59 + ($plant == null ? 43 : $plant.hashCode());
            String $inspSpecInformationField3 = this.inspSpecInformationField3;
            result = result * 59 + ($inspSpecInformationField3 == null ? 43 : $inspSpecInformationField3.hashCode());
            String $qltyMstrDataAuthorizationGroup = this.qltyMstrDataAuthorizationGroup;
            result = result * 59 + ($qltyMstrDataAuthorizationGroup == null ? 43 : $qltyMstrDataAuthorizationGroup.hashCode());
            String $inspToleranceSpecification = this.inspToleranceSpecification;
            result = result * 59 + ($inspToleranceSpecification == null ? 43 : $inspToleranceSpecification.hashCode());
            Short $inspSpecDecimalPlaces = this.inspSpecDecimalPlaces;
            result = result * 59 + ($inspSpecDecimalPlaces == null ? 43 : ((Object)$inspSpecDecimalPlaces).hashCode());
            String $inspectionSpecificationUnit = this.inspectionSpecificationUnit;
            result = result * 59 + ($inspectionSpecificationUnit == null ? 43 : $inspectionSpecificationUnit.hashCode());
            Double $inspSpecTargetValue = this.inspSpecTargetValue;
            result = result * 59 + ($inspSpecTargetValue == null ? 43 : ((Object)$inspSpecTargetValue).hashCode());
            String $inspSpecHasTargetValue = this.inspSpecHasTargetValue;
            result = result * 59 + ($inspSpecHasTargetValue == null ? 43 : $inspSpecHasTargetValue.hashCode());
            Double $inspSpecLowerLimit = this.inspSpecLowerLimit;
            result = result * 59 + ($inspSpecLowerLimit == null ? 43 : ((Object)$inspSpecLowerLimit).hashCode());
            String $inspSpecHasLowerLimit = this.inspSpecHasLowerLimit;
            result = result * 59 + ($inspSpecHasLowerLimit == null ? 43 : $inspSpecHasLowerLimit.hashCode());
            Double $inspSpecLowerPlausibilityLimit = this.inspSpecLowerPlausibilityLimit;
            result = result * 59 + ($inspSpecLowerPlausibilityLimit == null ? 43 : ((Object)$inspSpecLowerPlausibilityLimit).hashCode());
            Calendar $validityStartDate = this.validityStartDate;
            result = result * 59 + ($validityStartDate == null ? 43 : ((Object)$validityStartDate).hashCode());
            String $inspSpecHasLowrPlausibilityLmt = this.inspSpecHasLowrPlausibilityLmt;
            result = result * 59 + ($inspSpecHasLowrPlausibilityLmt == null ? 43 : $inspSpecHasLowrPlausibilityLmt.hashCode());
            Double $inspSpecFirstLowerSpecLimit = this.inspSpecFirstLowerSpecLimit;
            result = result * 59 + ($inspSpecFirstLowerSpecLimit == null ? 43 : ((Object)$inspSpecFirstLowerSpecLimit).hashCode());
            String $inspSpecHasFirstLowerSpecLimit = this.inspSpecHasFirstLowerSpecLimit;
            result = result * 59 + ($inspSpecHasFirstLowerSpecLimit == null ? 43 : $inspSpecHasFirstLowerSpecLimit.hashCode());
            Double $inspSpecSecondLowerSpecLimit = this.inspSpecSecondLowerSpecLimit;
            result = result * 59 + ($inspSpecSecondLowerSpecLimit == null ? 43 : ((Object)$inspSpecSecondLowerSpecLimit).hashCode());
            String $inspSpecHasSecondLowrSpecLimit = this.inspSpecHasSecondLowrSpecLimit;
            result = result * 59 + ($inspSpecHasSecondLowrSpecLimit == null ? 43 : $inspSpecHasSecondLowrSpecLimit.hashCode());
            Double $inspSpecLowerSpecLimitChange = this.inspSpecLowerSpecLimitChange;
            result = result * 59 + ($inspSpecLowerSpecLimitChange == null ? 43 : ((Object)$inspSpecLowerSpecLimitChange).hashCode());
            String $inspSpecHasLowrSpecLimitChange = this.inspSpecHasLowrSpecLimitChange;
            result = result * 59 + ($inspSpecHasLowrSpecLimitChange == null ? 43 : $inspSpecHasLowrSpecLimitChange.hashCode());
            Double $inspSpecUpperLimit = this.inspSpecUpperLimit;
            result = result * 59 + ($inspSpecUpperLimit == null ? 43 : ((Object)$inspSpecUpperLimit).hashCode());
            String $inspSpecHasUpperLimit = this.inspSpecHasUpperLimit;
            result = result * 59 + ($inspSpecHasUpperLimit == null ? 43 : $inspSpecHasUpperLimit.hashCode());
            Double $inspSpecUpperPlausibilityLimit = this.inspSpecUpperPlausibilityLimit;
            result = result * 59 + ($inspSpecUpperPlausibilityLimit == null ? 43 : ((Object)$inspSpecUpperPlausibilityLimit).hashCode());
            String $inspectionSpecificationSrchTxt = this.inspectionSpecificationSrchTxt;
            result = result * 59 + ($inspectionSpecificationSrchTxt == null ? 43 : $inspectionSpecificationSrchTxt.hashCode());
            String $inspSpecHasUprPlausibilityLmt = this.inspSpecHasUprPlausibilityLmt;
            result = result * 59 + ($inspSpecHasUprPlausibilityLmt == null ? 43 : $inspSpecHasUprPlausibilityLmt.hashCode());
            Double $inspSpecFirstUpperSpecLimit = this.inspSpecFirstUpperSpecLimit;
            result = result * 59 + ($inspSpecFirstUpperSpecLimit == null ? 43 : ((Object)$inspSpecFirstUpperSpecLimit).hashCode());
            String $inspSpecHasFirstUpperSpecLimit = this.inspSpecHasFirstUpperSpecLimit;
            result = result * 59 + ($inspSpecHasFirstUpperSpecLimit == null ? 43 : $inspSpecHasFirstUpperSpecLimit.hashCode());
            Double $inspSpecSecondUpperSpecLimit = this.inspSpecSecondUpperSpecLimit;
            result = result * 59 + ($inspSpecSecondUpperSpecLimit == null ? 43 : ((Object)$inspSpecSecondUpperSpecLimit).hashCode());
            String $inspSpecHasSecondUprSpecLimit = this.inspSpecHasSecondUprSpecLimit;
            result = result * 59 + ($inspSpecHasSecondUprSpecLimit == null ? 43 : $inspSpecHasSecondUprSpecLimit.hashCode());
            Double $inspSpecUpperSpecLimitChange = this.inspSpecUpperSpecLimitChange;
            result = result * 59 + ($inspSpecUpperSpecLimitChange == null ? 43 : ((Object)$inspSpecUpperSpecLimitChange).hashCode());
            String $inspSpecHasUprSpecLimitChange = this.inspSpecHasUprSpecLimitChange;
            result = result * 59 + ($inspSpecHasUprSpecLimitChange == null ? 43 : $inspSpecHasUprSpecLimitChange.hashCode());
            Calendar $inspSpecToleranceChgValidFrom = this.inspSpecToleranceChgValidFrom;
            result = result * 59 + ($inspSpecToleranceChgValidFrom == null ? 43 : ((Object)$inspSpecToleranceChgValidFrom).hashCode());
            Calendar $inspSpecToleranceChgValidTo = this.inspSpecToleranceChgValidTo;
            result = result * 59 + ($inspSpecToleranceChgValidTo == null ? 43 : ((Object)$inspSpecToleranceChgValidTo).hashCode());
            String $inspSpecDefectCodeGrpRejection = this.inspSpecDefectCodeGrpRejection;
            result = result * 59 + ($inspSpecDefectCodeGrpRejection == null ? 43 : $inspSpecDefectCodeGrpRejection.hashCode());
            String $inspSpecGlobalName = this.inspSpecGlobalName;
            result = result * 59 + ($inspSpecGlobalName == null ? 43 : $inspSpecGlobalName.hashCode());
            String $inspSpecDefectCodeRejection = this.inspSpecDefectCodeRejection;
            result = result * 59 + ($inspSpecDefectCodeRejection == null ? 43 : $inspSpecDefectCodeRejection.hashCode());
            String $inspSpecDefectCodeGrpRjcnUpper = this.inspSpecDefectCodeGrpRjcnUpper;
            result = result * 59 + ($inspSpecDefectCodeGrpRjcnUpper == null ? 43 : $inspSpecDefectCodeGrpRjcnUpper.hashCode());
            String $inspSpecDefectCodeRjcnUpper = this.inspSpecDefectCodeRjcnUpper;
            result = result * 59 + ($inspSpecDefectCodeRjcnUpper == null ? 43 : $inspSpecDefectCodeRjcnUpper.hashCode());
            String $inspSpecDefectCodeGrpRjcnLower = this.inspSpecDefectCodeGrpRjcnLower;
            result = result * 59 + ($inspSpecDefectCodeGrpRjcnLower == null ? 43 : $inspSpecDefectCodeGrpRjcnLower.hashCode());
            String $inspSpecDefectCodeRjcnLower = this.inspSpecDefectCodeRjcnLower;
            result = result * 59 + ($inspSpecDefectCodeRjcnLower == null ? 43 : $inspSpecDefectCodeRjcnLower.hashCode());
            String $characteristicInternalID = this.characteristicInternalID;
            result = result * 59 + ($characteristicInternalID == null ? 43 : $characteristicInternalID.hashCode());
            String $defectFractionEstimationProced = this.defectFractionEstimationProced;
            result = result * 59 + ($defectFractionEstimationProced == null ? 43 : $defectFractionEstimationProced.hashCode());
            String $inspectionSpecificationStatus = this.inspectionSpecificationStatus;
            result = result * 59 + ($inspectionSpecificationStatus == null ? 43 : $inspectionSpecificationStatus.hashCode());
            String $inspSpecTransferType = this.inspSpecTransferType;
            result = result * 59 + ($inspSpecTransferType == null ? 43 : $inspSpecTransferType.hashCode());
            return result;
        }

        public String getInspectionSpecification() {
            return this.inspectionSpecification;
        }

        public InspectionSpecification setInspectionSpecification(String inspectionSpecification) {
            this.inspectionSpecification = inspectionSpecification;
            return this;
        }

        public String getInspSpecCreatedByUser() {
            return this.inspSpecCreatedByUser;
        }

        public InspectionSpecification setInspSpecCreatedByUser(String inspSpecCreatedByUser) {
            this.inspSpecCreatedByUser = inspSpecCreatedByUser;
            return this;
        }

        public Calendar getInspSpecCreationDate() {
            return this.inspSpecCreationDate;
        }

        public InspectionSpecification setInspSpecCreationDate(Calendar inspSpecCreationDate) {
            this.inspSpecCreationDate = inspSpecCreationDate;
            return this;
        }

        public String getInspSpecChangedByUser() {
            return this.inspSpecChangedByUser;
        }

        public InspectionSpecification setInspSpecChangedByUser(String inspSpecChangedByUser) {
            this.inspSpecChangedByUser = inspSpecChangedByUser;
            return this;
        }

        public Calendar getInspSpecChangeDate() {
            return this.inspSpecChangeDate;
        }

        public InspectionSpecification setInspSpecChangeDate(Calendar inspSpecChangeDate) {
            this.inspSpecChangeDate = inspSpecChangeDate;
            return this;
        }

        public Boolean getInspSpecIsQuantitative() {
            return this.inspSpecIsQuantitative;
        }

        public InspectionSpecification setInspSpecIsQuantitative(Boolean inspSpecIsQuantitative) {
            this.inspSpecIsQuantitative = inspSpecIsQuantitative;
            return this;
        }

        public String getInspSpecCharacteristicType() {
            return this.inspSpecCharacteristicType;
        }

        public InspectionSpecification setInspSpecCharacteristicType(String inspSpecCharacteristicType) {
            this.inspSpecCharacteristicType = inspSpecCharacteristicType;
            return this;
        }

        public String getInspSpecIsMeasuredValueRqd() {
            return this.inspSpecIsMeasuredValueRqd;
        }

        public InspectionSpecification setInspSpecIsMeasuredValueRqd(String inspSpecIsMeasuredValueRqd) {
            this.inspSpecIsMeasuredValueRqd = inspSpecIsMeasuredValueRqd;
            return this;
        }

        public String getInspSpecIsSelectedSetRequired() {
            return this.inspSpecIsSelectedSetRequired;
        }

        public InspectionSpecification setInspSpecIsSelectedSetRequired(String inspSpecIsSelectedSetRequired) {
            this.inspSpecIsSelectedSetRequired = inspSpecIsSelectedSetRequired;
            return this;
        }

        public String getInspSpecIsUpperLimitRequired() {
            return this.inspSpecIsUpperLimitRequired;
        }

        public InspectionSpecification setInspSpecIsUpperLimitRequired(String inspSpecIsUpperLimitRequired) {
            this.inspSpecIsUpperLimitRequired = inspSpecIsUpperLimitRequired;
            return this;
        }

        public String getInspSpecIsLowerLimitRequired() {
            return this.inspSpecIsLowerLimitRequired;
        }

        public InspectionSpecification setInspSpecIsLowerLimitRequired(String inspSpecIsLowerLimitRequired) {
            this.inspSpecIsLowerLimitRequired = inspSpecIsLowerLimitRequired;
            return this;
        }

        public String getInspectionSpecificationVersion() {
            return this.inspectionSpecificationVersion;
        }

        public InspectionSpecification setInspectionSpecificationVersion(String inspectionSpecificationVersion) {
            this.inspectionSpecificationVersion = inspectionSpecificationVersion;
            return this;
        }

        public String getInspSpecIsTargetValueInLimit() {
            return this.inspSpecIsTargetValueInLimit;
        }

        public InspectionSpecification setInspSpecIsTargetValueInLimit(String inspSpecIsTargetValueInLimit) {
            this.inspSpecIsTargetValueInLimit = inspSpecIsTargetValueInLimit;
            return this;
        }

        public String getInspectionScope() {
            return this.inspectionScope;
        }

        public InspectionSpecification setInspectionScope(String inspectionScope) {
            this.inspectionScope = inspectionScope;
            return this;
        }

        public String getInspSpecIsLongTermInspection() {
            return this.inspSpecIsLongTermInspection;
        }

        public InspectionSpecification setInspSpecIsLongTermInspection(String inspSpecIsLongTermInspection) {
            this.inspSpecIsLongTermInspection = inspSpecIsLongTermInspection;
            return this;
        }

        public String getInspSpecRecordingType() {
            return this.inspSpecRecordingType;
        }

        public InspectionSpecification setInspSpecRecordingType(String inspSpecRecordingType) {
            this.inspSpecRecordingType = inspSpecRecordingType;
            return this;
        }

        public String getInspResultIsDocumentationRqd() {
            return this.inspResultIsDocumentationRqd;
        }

        public InspectionSpecification setInspResultIsDocumentationRqd(String inspResultIsDocumentationRqd) {
            this.inspResultIsDocumentationRqd = inspResultIsDocumentationRqd;
            return this;
        }

        public String getInspSpecCharcCategory() {
            return this.inspSpecCharcCategory;
        }

        public InspectionSpecification setInspSpecCharcCategory(String inspSpecCharcCategory) {
            this.inspSpecCharcCategory = inspSpecCharcCategory;
            return this;
        }

        public String getInspSpecIsDefectsRecgAutomatic() {
            return this.inspSpecIsDefectsRecgAutomatic;
        }

        public InspectionSpecification setInspSpecIsDefectsRecgAutomatic(String inspSpecIsDefectsRecgAutomatic) {
            this.inspSpecIsDefectsRecgAutomatic = inspSpecIsDefectsRecgAutomatic;
            return this;
        }

        public String getInspSpecIsSampleQtyAdditive() {
            return this.inspSpecIsSampleQtyAdditive;
        }

        public InspectionSpecification setInspSpecIsSampleQtyAdditive(String inspSpecIsSampleQtyAdditive) {
            this.inspSpecIsSampleQtyAdditive = inspSpecIsSampleQtyAdditive;
            return this;
        }

        public String getInspSpecIsDestructive() {
            return this.inspSpecIsDestructive;
        }

        public InspectionSpecification setInspSpecIsDestructive(String inspSpecIsDestructive) {
            this.inspSpecIsDestructive = inspSpecIsDestructive;
            return this;
        }

        public String getInspSpecResultCalculation() {
            return this.inspSpecResultCalculation;
        }

        public InspectionSpecification setInspSpecResultCalculation(String inspSpecResultCalculation) {
            this.inspSpecResultCalculation = inspSpecResultCalculation;
            return this;
        }

        public String getInspectionSpecificationPlant() {
            return this.inspectionSpecificationPlant;
        }

        public InspectionSpecification setInspectionSpecificationPlant(String inspectionSpecificationPlant) {
            this.inspectionSpecificationPlant = inspectionSpecificationPlant;
            return this;
        }

        public String getInspSpecIsSamplingProcedRqd() {
            return this.inspSpecIsSamplingProcedRqd;
        }

        public InspectionSpecification setInspSpecIsSamplingProcedRqd(String inspSpecIsSamplingProcedRqd) {
            this.inspSpecIsSamplingProcedRqd = inspSpecIsSamplingProcedRqd;
            return this;
        }

        public String getInspSpecIsScrapRelevant() {
            return this.inspSpecIsScrapRelevant;
        }

        public InspectionSpecification setInspSpecIsScrapRelevant(String inspSpecIsScrapRelevant) {
            this.inspSpecIsScrapRelevant = inspSpecIsScrapRelevant;
            return this;
        }

        public String getInspSpecIsTestEquipmentRqd() {
            return this.inspSpecIsTestEquipmentRqd;
        }

        public InspectionSpecification setInspSpecIsTestEquipmentRqd(String inspSpecIsTestEquipmentRqd) {
            this.inspSpecIsTestEquipmentRqd = inspSpecIsTestEquipmentRqd;
            return this;
        }

        public String getInspSpecIsChgDocRequired() {
            return this.inspSpecIsChgDocRequired;
        }

        public InspectionSpecification setInspSpecIsChgDocRequired(String inspSpecIsChgDocRequired) {
            this.inspSpecIsChgDocRequired = inspSpecIsChgDocRequired;
            return this;
        }

        public String getInspSpecIsControlChartUsed() {
            return this.inspSpecIsControlChartUsed;
        }

        public InspectionSpecification setInspSpecIsControlChartUsed(String inspSpecIsControlChartUsed) {
            this.inspSpecIsControlChartUsed = inspSpecIsControlChartUsed;
            return this;
        }

        public String getInspSpecPrintControl() {
            return this.inspSpecPrintControl;
        }

        public InspectionSpecification setInspSpecPrintControl(String inspSpecPrintControl) {
            this.inspSpecPrintControl = inspSpecPrintControl;
            return this;
        }

        public String getInspSpecImportanceCode() {
            return this.inspSpecImportanceCode;
        }

        public InspectionSpecification setInspSpecImportanceCode(String inspSpecImportanceCode) {
            this.inspSpecImportanceCode = inspSpecImportanceCode;
            return this;
        }

        public String getInspectorQualification() {
            return this.inspectorQualification;
        }

        public InspectionSpecification setInspectorQualification(String inspectorQualification) {
            this.inspectorQualification = inspectorQualification;
            return this;
        }

        public String getInspSpecInformationField1() {
            return this.inspSpecInformationField1;
        }

        public InspectionSpecification setInspSpecInformationField1(String inspSpecInformationField1) {
            this.inspSpecInformationField1 = inspSpecInformationField1;
            return this;
        }

        public String getInspSpecInformationField2() {
            return this.inspSpecInformationField2;
        }

        public InspectionSpecification setInspSpecInformationField2(String inspSpecInformationField2) {
            this.inspSpecInformationField2 = inspSpecInformationField2;
            return this;
        }

        public String getPlant() {
            return this.plant;
        }

        public InspectionSpecification setPlant(String plant) {
            this.plant = plant;
            return this;
        }

        public String getInspSpecInformationField3() {
            return this.inspSpecInformationField3;
        }

        public InspectionSpecification setInspSpecInformationField3(String inspSpecInformationField3) {
            this.inspSpecInformationField3 = inspSpecInformationField3;
            return this;
        }

        public String getQltyMstrDataAuthorizationGroup() {
            return this.qltyMstrDataAuthorizationGroup;
        }

        public InspectionSpecification setQltyMstrDataAuthorizationGroup(String qltyMstrDataAuthorizationGroup) {
            this.qltyMstrDataAuthorizationGroup = qltyMstrDataAuthorizationGroup;
            return this;
        }

        public String getInspToleranceSpecification() {
            return this.inspToleranceSpecification;
        }

        public InspectionSpecification setInspToleranceSpecification(String inspToleranceSpecification) {
            this.inspToleranceSpecification = inspToleranceSpecification;
            return this;
        }

        public Short getInspSpecDecimalPlaces() {
            return this.inspSpecDecimalPlaces;
        }

        public InspectionSpecification setInspSpecDecimalPlaces(Short inspSpecDecimalPlaces) {
            this.inspSpecDecimalPlaces = inspSpecDecimalPlaces;
            return this;
        }

        public String getInspectionSpecificationUnit() {
            return this.inspectionSpecificationUnit;
        }

        public InspectionSpecification setInspectionSpecificationUnit(String inspectionSpecificationUnit) {
            this.inspectionSpecificationUnit = inspectionSpecificationUnit;
            return this;
        }

        public Double getInspSpecTargetValue() {
            return this.inspSpecTargetValue;
        }

        public InspectionSpecification setInspSpecTargetValue(Double inspSpecTargetValue) {
            this.inspSpecTargetValue = inspSpecTargetValue;
            return this;
        }

        public String getInspSpecHasTargetValue() {
            return this.inspSpecHasTargetValue;
        }

        public InspectionSpecification setInspSpecHasTargetValue(String inspSpecHasTargetValue) {
            this.inspSpecHasTargetValue = inspSpecHasTargetValue;
            return this;
        }

        public Double getInspSpecLowerLimit() {
            return this.inspSpecLowerLimit;
        }

        public InspectionSpecification setInspSpecLowerLimit(Double inspSpecLowerLimit) {
            this.inspSpecLowerLimit = inspSpecLowerLimit;
            return this;
        }

        public String getInspSpecHasLowerLimit() {
            return this.inspSpecHasLowerLimit;
        }

        public InspectionSpecification setInspSpecHasLowerLimit(String inspSpecHasLowerLimit) {
            this.inspSpecHasLowerLimit = inspSpecHasLowerLimit;
            return this;
        }

        public Double getInspSpecLowerPlausibilityLimit() {
            return this.inspSpecLowerPlausibilityLimit;
        }

        public InspectionSpecification setInspSpecLowerPlausibilityLimit(Double inspSpecLowerPlausibilityLimit) {
            this.inspSpecLowerPlausibilityLimit = inspSpecLowerPlausibilityLimit;
            return this;
        }

        public Calendar getValidityStartDate() {
            return this.validityStartDate;
        }

        public InspectionSpecification setValidityStartDate(Calendar validityStartDate) {
            this.validityStartDate = validityStartDate;
            return this;
        }

        public String getInspSpecHasLowrPlausibilityLmt() {
            return this.inspSpecHasLowrPlausibilityLmt;
        }

        public InspectionSpecification setInspSpecHasLowrPlausibilityLmt(String inspSpecHasLowrPlausibilityLmt) {
            this.inspSpecHasLowrPlausibilityLmt = inspSpecHasLowrPlausibilityLmt;
            return this;
        }

        public Double getInspSpecFirstLowerSpecLimit() {
            return this.inspSpecFirstLowerSpecLimit;
        }

        public InspectionSpecification setInspSpecFirstLowerSpecLimit(Double inspSpecFirstLowerSpecLimit) {
            this.inspSpecFirstLowerSpecLimit = inspSpecFirstLowerSpecLimit;
            return this;
        }

        public String getInspSpecHasFirstLowerSpecLimit() {
            return this.inspSpecHasFirstLowerSpecLimit;
        }

        public InspectionSpecification setInspSpecHasFirstLowerSpecLimit(String inspSpecHasFirstLowerSpecLimit) {
            this.inspSpecHasFirstLowerSpecLimit = inspSpecHasFirstLowerSpecLimit;
            return this;
        }

        public Double getInspSpecSecondLowerSpecLimit() {
            return this.inspSpecSecondLowerSpecLimit;
        }

        public InspectionSpecification setInspSpecSecondLowerSpecLimit(Double inspSpecSecondLowerSpecLimit) {
            this.inspSpecSecondLowerSpecLimit = inspSpecSecondLowerSpecLimit;
            return this;
        }

        public String getInspSpecHasSecondLowrSpecLimit() {
            return this.inspSpecHasSecondLowrSpecLimit;
        }

        public InspectionSpecification setInspSpecHasSecondLowrSpecLimit(String inspSpecHasSecondLowrSpecLimit) {
            this.inspSpecHasSecondLowrSpecLimit = inspSpecHasSecondLowrSpecLimit;
            return this;
        }

        public Double getInspSpecLowerSpecLimitChange() {
            return this.inspSpecLowerSpecLimitChange;
        }

        public InspectionSpecification setInspSpecLowerSpecLimitChange(Double inspSpecLowerSpecLimitChange) {
            this.inspSpecLowerSpecLimitChange = inspSpecLowerSpecLimitChange;
            return this;
        }

        public String getInspSpecHasLowrSpecLimitChange() {
            return this.inspSpecHasLowrSpecLimitChange;
        }

        public InspectionSpecification setInspSpecHasLowrSpecLimitChange(String inspSpecHasLowrSpecLimitChange) {
            this.inspSpecHasLowrSpecLimitChange = inspSpecHasLowrSpecLimitChange;
            return this;
        }

        public Double getInspSpecUpperLimit() {
            return this.inspSpecUpperLimit;
        }

        public InspectionSpecification setInspSpecUpperLimit(Double inspSpecUpperLimit) {
            this.inspSpecUpperLimit = inspSpecUpperLimit;
            return this;
        }

        public String getInspSpecHasUpperLimit() {
            return this.inspSpecHasUpperLimit;
        }

        public InspectionSpecification setInspSpecHasUpperLimit(String inspSpecHasUpperLimit) {
            this.inspSpecHasUpperLimit = inspSpecHasUpperLimit;
            return this;
        }

        public Double getInspSpecUpperPlausibilityLimit() {
            return this.inspSpecUpperPlausibilityLimit;
        }

        public InspectionSpecification setInspSpecUpperPlausibilityLimit(Double inspSpecUpperPlausibilityLimit) {
            this.inspSpecUpperPlausibilityLimit = inspSpecUpperPlausibilityLimit;
            return this;
        }

        public String getInspectionSpecificationSrchTxt() {
            return this.inspectionSpecificationSrchTxt;
        }

        public InspectionSpecification setInspectionSpecificationSrchTxt(String inspectionSpecificationSrchTxt) {
            this.inspectionSpecificationSrchTxt = inspectionSpecificationSrchTxt;
            return this;
        }

        public String getInspSpecHasUprPlausibilityLmt() {
            return this.inspSpecHasUprPlausibilityLmt;
        }

        public InspectionSpecification setInspSpecHasUprPlausibilityLmt(String inspSpecHasUprPlausibilityLmt) {
            this.inspSpecHasUprPlausibilityLmt = inspSpecHasUprPlausibilityLmt;
            return this;
        }

        public Double getInspSpecFirstUpperSpecLimit() {
            return this.inspSpecFirstUpperSpecLimit;
        }

        public InspectionSpecification setInspSpecFirstUpperSpecLimit(Double inspSpecFirstUpperSpecLimit) {
            this.inspSpecFirstUpperSpecLimit = inspSpecFirstUpperSpecLimit;
            return this;
        }

        public String getInspSpecHasFirstUpperSpecLimit() {
            return this.inspSpecHasFirstUpperSpecLimit;
        }

        public InspectionSpecification setInspSpecHasFirstUpperSpecLimit(String inspSpecHasFirstUpperSpecLimit) {
            this.inspSpecHasFirstUpperSpecLimit = inspSpecHasFirstUpperSpecLimit;
            return this;
        }

        public Double getInspSpecSecondUpperSpecLimit() {
            return this.inspSpecSecondUpperSpecLimit;
        }

        public InspectionSpecification setInspSpecSecondUpperSpecLimit(Double inspSpecSecondUpperSpecLimit) {
            this.inspSpecSecondUpperSpecLimit = inspSpecSecondUpperSpecLimit;
            return this;
        }

        public String getInspSpecHasSecondUprSpecLimit() {
            return this.inspSpecHasSecondUprSpecLimit;
        }

        public InspectionSpecification setInspSpecHasSecondUprSpecLimit(String inspSpecHasSecondUprSpecLimit) {
            this.inspSpecHasSecondUprSpecLimit = inspSpecHasSecondUprSpecLimit;
            return this;
        }

        public Double getInspSpecUpperSpecLimitChange() {
            return this.inspSpecUpperSpecLimitChange;
        }

        public InspectionSpecification setInspSpecUpperSpecLimitChange(Double inspSpecUpperSpecLimitChange) {
            this.inspSpecUpperSpecLimitChange = inspSpecUpperSpecLimitChange;
            return this;
        }

        public String getInspSpecHasUprSpecLimitChange() {
            return this.inspSpecHasUprSpecLimitChange;
        }

        public InspectionSpecification setInspSpecHasUprSpecLimitChange(String inspSpecHasUprSpecLimitChange) {
            this.inspSpecHasUprSpecLimitChange = inspSpecHasUprSpecLimitChange;
            return this;
        }

        public Calendar getInspSpecToleranceChgValidFrom() {
            return this.inspSpecToleranceChgValidFrom;
        }

        public InspectionSpecification setInspSpecToleranceChgValidFrom(Calendar inspSpecToleranceChgValidFrom) {
            this.inspSpecToleranceChgValidFrom = inspSpecToleranceChgValidFrom;
            return this;
        }

        public Calendar getInspSpecToleranceChgValidTo() {
            return this.inspSpecToleranceChgValidTo;
        }

        public InspectionSpecification setInspSpecToleranceChgValidTo(Calendar inspSpecToleranceChgValidTo) {
            this.inspSpecToleranceChgValidTo = inspSpecToleranceChgValidTo;
            return this;
        }

        public String getInspSpecDefectCodeGrpRejection() {
            return this.inspSpecDefectCodeGrpRejection;
        }

        public InspectionSpecification setInspSpecDefectCodeGrpRejection(String inspSpecDefectCodeGrpRejection) {
            this.inspSpecDefectCodeGrpRejection = inspSpecDefectCodeGrpRejection;
            return this;
        }

        public String getInspSpecGlobalName() {
            return this.inspSpecGlobalName;
        }

        public InspectionSpecification setInspSpecGlobalName(String inspSpecGlobalName) {
            this.inspSpecGlobalName = inspSpecGlobalName;
            return this;
        }

        public String getInspSpecDefectCodeRejection() {
            return this.inspSpecDefectCodeRejection;
        }

        public InspectionSpecification setInspSpecDefectCodeRejection(String inspSpecDefectCodeRejection) {
            this.inspSpecDefectCodeRejection = inspSpecDefectCodeRejection;
            return this;
        }

        public String getInspSpecDefectCodeGrpRjcnUpper() {
            return this.inspSpecDefectCodeGrpRjcnUpper;
        }

        public InspectionSpecification setInspSpecDefectCodeGrpRjcnUpper(String inspSpecDefectCodeGrpRjcnUpper) {
            this.inspSpecDefectCodeGrpRjcnUpper = inspSpecDefectCodeGrpRjcnUpper;
            return this;
        }

        public String getInspSpecDefectCodeRjcnUpper() {
            return this.inspSpecDefectCodeRjcnUpper;
        }

        public InspectionSpecification setInspSpecDefectCodeRjcnUpper(String inspSpecDefectCodeRjcnUpper) {
            this.inspSpecDefectCodeRjcnUpper = inspSpecDefectCodeRjcnUpper;
            return this;
        }

        public String getInspSpecDefectCodeGrpRjcnLower() {
            return this.inspSpecDefectCodeGrpRjcnLower;
        }

        public InspectionSpecification setInspSpecDefectCodeGrpRjcnLower(String inspSpecDefectCodeGrpRjcnLower) {
            this.inspSpecDefectCodeGrpRjcnLower = inspSpecDefectCodeGrpRjcnLower;
            return this;
        }

        public String getInspSpecDefectCodeRjcnLower() {
            return this.inspSpecDefectCodeRjcnLower;
        }

        public InspectionSpecification setInspSpecDefectCodeRjcnLower(String inspSpecDefectCodeRjcnLower) {
            this.inspSpecDefectCodeRjcnLower = inspSpecDefectCodeRjcnLower;
            return this;
        }

        public String getCharacteristicInternalID() {
            return this.characteristicInternalID;
        }

        public InspectionSpecification setCharacteristicInternalID(String characteristicInternalID) {
            this.characteristicInternalID = characteristicInternalID;
            return this;
        }

        public String getDefectFractionEstimationProced() {
            return this.defectFractionEstimationProced;
        }

        public InspectionSpecification setDefectFractionEstimationProced(String defectFractionEstimationProced) {
            this.defectFractionEstimationProced = defectFractionEstimationProced;
            return this;
        }

        public String getInspectionSpecificationStatus() {
            return this.inspectionSpecificationStatus;
        }

        public InspectionSpecification setInspectionSpecificationStatus(String inspectionSpecificationStatus) {
            this.inspectionSpecificationStatus = inspectionSpecificationStatus;
            return this;
        }

        public String getInspSpecTransferType() {
            return this.inspSpecTransferType;
        }

        public InspectionSpecification setInspSpecTransferType(String inspSpecTransferType) {
            this.inspSpecTransferType = inspSpecTransferType;
            return this;
        }

        public InspectionSpecification setErpConfigContext(ErpConfigContext erpConfigContext) {
            this.erpConfigContext = erpConfigContext;
            return this;
        }
    }
}

