/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.cloudplatform.connectivity.WithDestinationName;
import com.sap.cloud.sdk.odatav2.connectivity.ErrorResultHandler;
import com.sap.cloud.sdk.odatav2.connectivity.FilterExpression;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQuery;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQueryBuilder;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQueryResult;
import com.sap.cloud.sdk.odatav2.connectivity.ODataType;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.connectivity.ErpConfigContext;
import com.sap.cloud.sdk.s4hana.connectivity.ErpEndpoint;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.EntityField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ExpressionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.FilterExpressionWrapper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ODataBooleanAdapter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ODataCalendarAdapter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ODataTypeValueSerializer;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ODataVdmErrorResultHandler;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.Order;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public class ReadDebitMemoRequestsNamespace {

    public static class DebitMemoRequestItemFluentHelper {
        private ODataQueryBuilder queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_DEBIT_MEMO_REQUEST_SRV", (String)"A_DebitMemoRequestItem");
        private ErrorResultHandler<?> errorResultHandler = new ODataVdmErrorResultHandler();

        public DebitMemoRequestItemFluentHelper filter(ExpressionFluentHelper<DebitMemoRequestItem> expression) {
            for (FilterExpressionWrapper<?> filterExpressionWrapper : expression.evaluate()) {
                Object comparisonValue = filterExpressionWrapper.getComparisonValue();
                if (comparisonValue instanceof Integer) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Integer)((Integer)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof String) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((String)((String)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Long) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Long)((Long)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Double) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Double)((Double)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Float) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Float)((Float)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDate) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDate)((LocalDate)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDateTime)((LocalDateTime)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Date) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Date)((Date)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof DateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((DateTime)((DateTime)comparisonValue))));
                    continue;
                }
                this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of(comparisonValue)));
            }
            return this;
        }

        public DebitMemoRequestItemFluentHelper orderBy(EntityField<?, DebitMemoRequestItem> field, Order order) {
            String orderingDirection = order == Order.ASC ? " asc" : " desc";
            this.queryBuilder.param("orderby", (Object)(field.getFieldName() + orderingDirection));
            return this;
        }

        @SafeVarargs
        public final DebitMemoRequestItemFluentHelper select(EntityField<?, DebitMemoRequestItem> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public DebitMemoRequestItemFluentHelper top(Number top) {
            this.queryBuilder.top(top);
            return this;
        }

        public DebitMemoRequestItemFluentHelper skip(Number skip) {
            this.queryBuilder.skip(skip);
            return this;
        }

        public DebitMemoRequestItemFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.errorHandler(this.errorResultHandler).build();
        }

        public List<DebitMemoRequestItem> execute(ErpConfigContext erpConfigContext) throws ODataException {
            List entityList = this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).asList(DebitMemoRequestItem.class);
            for (DebitMemoRequestItem entity : entityList) {
                entity.setErpConfigContext(erpConfigContext);
            }
            return entityList;
        }
    }

    public static class DebitMemoRequestItemByKeyFluentHelper {
        private ODataQueryBuilder queryBuilder;
        private ErrorResultHandler<?> errorResultHandler;
        private List<Object> values = new LinkedList<Object>();

        public DebitMemoRequestItemByKeyFluentHelper(String debitMemoRequest, String debitMemoRequestItem) {
            this.values.add(debitMemoRequest);
            this.values.add(debitMemoRequestItem);
            this.queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_DEBIT_MEMO_REQUEST_SRV", (String)"A_DebitMemoRequestItem");
            HashMap<String, Object> keys = new HashMap<String, Object>();
            keys.put("DebitMemoRequest", this.values.get(0));
            keys.put("DebitMemoRequestItem", this.values.get(1));
            this.queryBuilder.keys(keys);
        }

        @SafeVarargs
        public final DebitMemoRequestItemByKeyFluentHelper select(EntityField<?, DebitMemoRequestItem> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.build();
        }

        public DebitMemoRequestItemByKeyFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public DebitMemoRequestItem execute(ErpConfigContext erpConfigContext) throws ODataException {
            DebitMemoRequestItem entity = (DebitMemoRequestItem)this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).as(DebitMemoRequestItem.class);
            entity.setErpConfigContext(erpConfigContext);
            return entity;
        }
    }

    public static class DebitMemoRequestItem {
        @ElementName(value="DebitMemoRequest")
        private String debitMemoRequest;
        public static EntityField<String, DebitMemoRequestItem> DEBIT_MEMO_REQUEST = new EntityField("DebitMemoRequest");
        @ElementName(value="RequestedQuantityUnit")
        private String requestedQuantityUnit;
        public static EntityField<String, DebitMemoRequestItem> REQUESTED_QUANTITY_UNIT = new EntityField("RequestedQuantityUnit");
        @ElementName(value="ItemGrossWeight")
        private BigDecimal itemGrossWeight;
        public static EntityField<BigDecimal, DebitMemoRequestItem> ITEM_GROSS_WEIGHT = new EntityField("ItemGrossWeight");
        @ElementName(value="ItemNetWeight")
        private BigDecimal itemNetWeight;
        public static EntityField<BigDecimal, DebitMemoRequestItem> ITEM_NET_WEIGHT = new EntityField("ItemNetWeight");
        @ElementName(value="ItemWeightUnit")
        private String itemWeightUnit;
        public static EntityField<String, DebitMemoRequestItem> ITEM_WEIGHT_UNIT = new EntityField("ItemWeightUnit");
        @ElementName(value="ItemVolume")
        private BigDecimal itemVolume;
        public static EntityField<BigDecimal, DebitMemoRequestItem> ITEM_VOLUME = new EntityField("ItemVolume");
        @ElementName(value="ItemVolumeUnit")
        private String itemVolumeUnit;
        public static EntityField<String, DebitMemoRequestItem> ITEM_VOLUME_UNIT = new EntityField("ItemVolumeUnit");
        @ElementName(value="TransactionCurrency")
        private String transactionCurrency;
        public static EntityField<String, DebitMemoRequestItem> TRANSACTION_CURRENCY = new EntityField("TransactionCurrency");
        @ElementName(value="NetAmount")
        private BigDecimal netAmount;
        public static EntityField<BigDecimal, DebitMemoRequestItem> NET_AMOUNT = new EntityField("NetAmount");
        @ElementName(value="MaterialGroup")
        private String materialGroup;
        public static EntityField<String, DebitMemoRequestItem> MATERIAL_GROUP = new EntityField("MaterialGroup");
        @ElementName(value="IncotermsClassification")
        private String incotermsClassification;
        public static EntityField<String, DebitMemoRequestItem> INCOTERMS_CLASSIFICATION = new EntityField("IncotermsClassification");
        @ElementName(value="DebitMemoRequestItem")
        private String debitMemoRequestItem;
        public static EntityField<String, DebitMemoRequestItem> DEBIT_MEMO_REQUEST_ITEM = new EntityField("DebitMemoRequestItem");
        @ElementName(value="IncotermsTransferLocation")
        private String incotermsTransferLocation;
        public static EntityField<String, DebitMemoRequestItem> INCOTERMS_TRANSFER_LOCATION = new EntityField("IncotermsTransferLocation");
        @ElementName(value="CustomerPaymentTerms")
        private String customerPaymentTerms;
        public static EntityField<String, DebitMemoRequestItem> CUSTOMER_PAYMENT_TERMS = new EntityField("CustomerPaymentTerms");
        @ElementName(value="ItemBillingBlockReason")
        private String itemBillingBlockReason;
        public static EntityField<String, DebitMemoRequestItem> ITEM_BILLING_BLOCK_REASON = new EntityField("ItemBillingBlockReason");
        @ElementName(value="SalesDocumentRjcnReason")
        private String salesDocumentRjcnReason;
        public static EntityField<String, DebitMemoRequestItem> SALES_DOCUMENT_RJCN_REASON = new EntityField("SalesDocumentRjcnReason");
        @ElementName(value="SDProcessStatus")
        private String sDProcessStatus;
        public static EntityField<String, DebitMemoRequestItem> S_D_PROCESS_STATUS = new EntityField("SDProcessStatus");
        @ElementName(value="OrderRelatedBillingStatus")
        private String orderRelatedBillingStatus;
        public static EntityField<String, DebitMemoRequestItem> ORDER_RELATED_BILLING_STATUS = new EntityField("OrderRelatedBillingStatus");
        @ElementName(value="DebitMemoRequestItemCategory")
        private String debitMemoRequestItemCategory;
        public static EntityField<String, DebitMemoRequestItem> DEBIT_MEMO_REQUEST_ITEM_CATEGORY = new EntityField("DebitMemoRequestItemCategory");
        @ElementName(value="DebitMemoRequestItemText")
        private String debitMemoRequestItemText;
        public static EntityField<String, DebitMemoRequestItem> DEBIT_MEMO_REQUEST_ITEM_TEXT = new EntityField("DebitMemoRequestItemText");
        @ElementName(value="PurchaseOrderByCustomer")
        private String purchaseOrderByCustomer;
        public static EntityField<String, DebitMemoRequestItem> PURCHASE_ORDER_BY_CUSTOMER = new EntityField("PurchaseOrderByCustomer");
        @ElementName(value="Material")
        private String material;
        public static EntityField<String, DebitMemoRequestItem> MATERIAL = new EntityField("Material");
        @ElementName(value="MaterialByCustomer")
        private String materialByCustomer;
        public static EntityField<String, DebitMemoRequestItem> MATERIAL_BY_CUSTOMER = new EntityField("MaterialByCustomer");
        @ElementName(value="PricingDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar pricingDate;
        public static EntityField<Calendar, DebitMemoRequestItem> PRICING_DATE = new EntityField("PricingDate");
        @ElementName(value="RequestedQuantity")
        private BigDecimal requestedQuantity;
        public static EntityField<BigDecimal, DebitMemoRequestItem> REQUESTED_QUANTITY = new EntityField("RequestedQuantity");
        private static final transient String ODATA_ENDPOINT_URL = "/sap/opu/odata/sap/API_DEBIT_MEMO_REQUEST_SRV";
        private static final transient String ODATA_ENTITY_COLLECTION = "A_DebitMemoRequestItem";
        private transient ErpConfigContext erpConfigContext;

        @JsonIgnore
        public DebitMemoRequest fetchDebitMemoRequest() throws ODataException {
            StringBuilder odataResourceUrl = new StringBuilder(ODATA_ENTITY_COLLECTION);
            odataResourceUrl.append("(");
            odataResourceUrl.append("DebitMemoRequest=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.debitMemoRequest));
            odataResourceUrl.append(",DebitMemoRequestItem=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.debitMemoRequestItem));
            odataResourceUrl.append(")/");
            odataResourceUrl.append("to_DebitMemoRequest");
            ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)ODATA_ENDPOINT_URL, (String)odataResourceUrl.toString());
            ODataQuery query = builder.build();
            ErpEndpoint erpEndpoint = new ErpEndpoint(this.erpConfigContext);
            ODataQueryResult result = query.execute((WithDestinationName)erpEndpoint);
            DebitMemoRequest entityList = (DebitMemoRequest)result.as(DebitMemoRequest.class);
            entityList.setErpConfigContext(this.erpConfigContext);
            return entityList;
        }

        @JsonIgnore
        public List<DebitMemoReqItemPartner> fetchPartner() throws ODataException {
            StringBuilder odataResourceUrl = new StringBuilder(ODATA_ENTITY_COLLECTION);
            odataResourceUrl.append("(");
            odataResourceUrl.append("DebitMemoRequest=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.debitMemoRequest));
            odataResourceUrl.append(",DebitMemoRequestItem=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.debitMemoRequestItem));
            odataResourceUrl.append(")/");
            odataResourceUrl.append("to_Partner");
            ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)ODATA_ENDPOINT_URL, (String)odataResourceUrl.toString());
            ODataQuery query = builder.build();
            ErpEndpoint erpEndpoint = new ErpEndpoint(this.erpConfigContext);
            ODataQueryResult result = query.execute((WithDestinationName)erpEndpoint);
            List entityList = result.asList(DebitMemoReqItemPartner.class);
            for (DebitMemoReqItemPartner entity : entityList) {
                entity.setErpConfigContext(this.erpConfigContext);
            }
            return entityList;
        }

        @JsonIgnore
        public List<DebitMemoReqItemPrcgElmnt> fetchPricingElement() throws ODataException {
            StringBuilder odataResourceUrl = new StringBuilder(ODATA_ENTITY_COLLECTION);
            odataResourceUrl.append("(");
            odataResourceUrl.append("DebitMemoRequest=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.debitMemoRequest));
            odataResourceUrl.append(",DebitMemoRequestItem=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.debitMemoRequestItem));
            odataResourceUrl.append(")/");
            odataResourceUrl.append("to_PricingElement");
            ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)ODATA_ENDPOINT_URL, (String)odataResourceUrl.toString());
            ODataQuery query = builder.build();
            ErpEndpoint erpEndpoint = new ErpEndpoint(this.erpConfigContext);
            ODataQueryResult result = query.execute((WithDestinationName)erpEndpoint);
            List entityList = result.asList(DebitMemoReqItemPrcgElmnt.class);
            for (DebitMemoReqItemPrcgElmnt entity : entityList) {
                entity.setErpConfigContext(this.erpConfigContext);
            }
            return entityList;
        }

        public String toString() {
            return "ReadDebitMemoRequestsNamespace.DebitMemoRequestItem(debitMemoRequest=" + this.debitMemoRequest + ", requestedQuantityUnit=" + this.requestedQuantityUnit + ", itemGrossWeight=" + this.itemGrossWeight + ", itemNetWeight=" + this.itemNetWeight + ", itemWeightUnit=" + this.itemWeightUnit + ", itemVolume=" + this.itemVolume + ", itemVolumeUnit=" + this.itemVolumeUnit + ", transactionCurrency=" + this.transactionCurrency + ", netAmount=" + this.netAmount + ", materialGroup=" + this.materialGroup + ", incotermsClassification=" + this.incotermsClassification + ", debitMemoRequestItem=" + this.debitMemoRequestItem + ", incotermsTransferLocation=" + this.incotermsTransferLocation + ", customerPaymentTerms=" + this.customerPaymentTerms + ", itemBillingBlockReason=" + this.itemBillingBlockReason + ", salesDocumentRjcnReason=" + this.salesDocumentRjcnReason + ", sDProcessStatus=" + this.sDProcessStatus + ", orderRelatedBillingStatus=" + this.orderRelatedBillingStatus + ", debitMemoRequestItemCategory=" + this.debitMemoRequestItemCategory + ", debitMemoRequestItemText=" + this.debitMemoRequestItemText + ", purchaseOrderByCustomer=" + this.purchaseOrderByCustomer + ", material=" + this.material + ", materialByCustomer=" + this.materialByCustomer + ", pricingDate=" + this.pricingDate + ", requestedQuantity=" + this.requestedQuantity + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DebitMemoRequestItem)) {
                return false;
            }
            DebitMemoRequestItem other = (DebitMemoRequestItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$debitMemoRequest = this.debitMemoRequest;
            String other$debitMemoRequest = other.debitMemoRequest;
            if (this$debitMemoRequest == null ? other$debitMemoRequest != null : !this$debitMemoRequest.equals(other$debitMemoRequest)) {
                return false;
            }
            String this$requestedQuantityUnit = this.requestedQuantityUnit;
            String other$requestedQuantityUnit = other.requestedQuantityUnit;
            if (this$requestedQuantityUnit == null ? other$requestedQuantityUnit != null : !this$requestedQuantityUnit.equals(other$requestedQuantityUnit)) {
                return false;
            }
            BigDecimal this$itemGrossWeight = this.itemGrossWeight;
            BigDecimal other$itemGrossWeight = other.itemGrossWeight;
            if (this$itemGrossWeight == null ? other$itemGrossWeight != null : !((Object)this$itemGrossWeight).equals(other$itemGrossWeight)) {
                return false;
            }
            BigDecimal this$itemNetWeight = this.itemNetWeight;
            BigDecimal other$itemNetWeight = other.itemNetWeight;
            if (this$itemNetWeight == null ? other$itemNetWeight != null : !((Object)this$itemNetWeight).equals(other$itemNetWeight)) {
                return false;
            }
            String this$itemWeightUnit = this.itemWeightUnit;
            String other$itemWeightUnit = other.itemWeightUnit;
            if (this$itemWeightUnit == null ? other$itemWeightUnit != null : !this$itemWeightUnit.equals(other$itemWeightUnit)) {
                return false;
            }
            BigDecimal this$itemVolume = this.itemVolume;
            BigDecimal other$itemVolume = other.itemVolume;
            if (this$itemVolume == null ? other$itemVolume != null : !((Object)this$itemVolume).equals(other$itemVolume)) {
                return false;
            }
            String this$itemVolumeUnit = this.itemVolumeUnit;
            String other$itemVolumeUnit = other.itemVolumeUnit;
            if (this$itemVolumeUnit == null ? other$itemVolumeUnit != null : !this$itemVolumeUnit.equals(other$itemVolumeUnit)) {
                return false;
            }
            String this$transactionCurrency = this.transactionCurrency;
            String other$transactionCurrency = other.transactionCurrency;
            if (this$transactionCurrency == null ? other$transactionCurrency != null : !this$transactionCurrency.equals(other$transactionCurrency)) {
                return false;
            }
            BigDecimal this$netAmount = this.netAmount;
            BigDecimal other$netAmount = other.netAmount;
            if (this$netAmount == null ? other$netAmount != null : !((Object)this$netAmount).equals(other$netAmount)) {
                return false;
            }
            String this$materialGroup = this.materialGroup;
            String other$materialGroup = other.materialGroup;
            if (this$materialGroup == null ? other$materialGroup != null : !this$materialGroup.equals(other$materialGroup)) {
                return false;
            }
            String this$incotermsClassification = this.incotermsClassification;
            String other$incotermsClassification = other.incotermsClassification;
            if (this$incotermsClassification == null ? other$incotermsClassification != null : !this$incotermsClassification.equals(other$incotermsClassification)) {
                return false;
            }
            String this$debitMemoRequestItem = this.debitMemoRequestItem;
            String other$debitMemoRequestItem = other.debitMemoRequestItem;
            if (this$debitMemoRequestItem == null ? other$debitMemoRequestItem != null : !this$debitMemoRequestItem.equals(other$debitMemoRequestItem)) {
                return false;
            }
            String this$incotermsTransferLocation = this.incotermsTransferLocation;
            String other$incotermsTransferLocation = other.incotermsTransferLocation;
            if (this$incotermsTransferLocation == null ? other$incotermsTransferLocation != null : !this$incotermsTransferLocation.equals(other$incotermsTransferLocation)) {
                return false;
            }
            String this$customerPaymentTerms = this.customerPaymentTerms;
            String other$customerPaymentTerms = other.customerPaymentTerms;
            if (this$customerPaymentTerms == null ? other$customerPaymentTerms != null : !this$customerPaymentTerms.equals(other$customerPaymentTerms)) {
                return false;
            }
            String this$itemBillingBlockReason = this.itemBillingBlockReason;
            String other$itemBillingBlockReason = other.itemBillingBlockReason;
            if (this$itemBillingBlockReason == null ? other$itemBillingBlockReason != null : !this$itemBillingBlockReason.equals(other$itemBillingBlockReason)) {
                return false;
            }
            String this$salesDocumentRjcnReason = this.salesDocumentRjcnReason;
            String other$salesDocumentRjcnReason = other.salesDocumentRjcnReason;
            if (this$salesDocumentRjcnReason == null ? other$salesDocumentRjcnReason != null : !this$salesDocumentRjcnReason.equals(other$salesDocumentRjcnReason)) {
                return false;
            }
            String this$sDProcessStatus = this.sDProcessStatus;
            String other$sDProcessStatus = other.sDProcessStatus;
            if (this$sDProcessStatus == null ? other$sDProcessStatus != null : !this$sDProcessStatus.equals(other$sDProcessStatus)) {
                return false;
            }
            String this$orderRelatedBillingStatus = this.orderRelatedBillingStatus;
            String other$orderRelatedBillingStatus = other.orderRelatedBillingStatus;
            if (this$orderRelatedBillingStatus == null ? other$orderRelatedBillingStatus != null : !this$orderRelatedBillingStatus.equals(other$orderRelatedBillingStatus)) {
                return false;
            }
            String this$debitMemoRequestItemCategory = this.debitMemoRequestItemCategory;
            String other$debitMemoRequestItemCategory = other.debitMemoRequestItemCategory;
            if (this$debitMemoRequestItemCategory == null ? other$debitMemoRequestItemCategory != null : !this$debitMemoRequestItemCategory.equals(other$debitMemoRequestItemCategory)) {
                return false;
            }
            String this$debitMemoRequestItemText = this.debitMemoRequestItemText;
            String other$debitMemoRequestItemText = other.debitMemoRequestItemText;
            if (this$debitMemoRequestItemText == null ? other$debitMemoRequestItemText != null : !this$debitMemoRequestItemText.equals(other$debitMemoRequestItemText)) {
                return false;
            }
            String this$purchaseOrderByCustomer = this.purchaseOrderByCustomer;
            String other$purchaseOrderByCustomer = other.purchaseOrderByCustomer;
            if (this$purchaseOrderByCustomer == null ? other$purchaseOrderByCustomer != null : !this$purchaseOrderByCustomer.equals(other$purchaseOrderByCustomer)) {
                return false;
            }
            String this$material = this.material;
            String other$material = other.material;
            if (this$material == null ? other$material != null : !this$material.equals(other$material)) {
                return false;
            }
            String this$materialByCustomer = this.materialByCustomer;
            String other$materialByCustomer = other.materialByCustomer;
            if (this$materialByCustomer == null ? other$materialByCustomer != null : !this$materialByCustomer.equals(other$materialByCustomer)) {
                return false;
            }
            Calendar this$pricingDate = this.pricingDate;
            Calendar other$pricingDate = other.pricingDate;
            if (this$pricingDate == null ? other$pricingDate != null : !((Object)this$pricingDate).equals(other$pricingDate)) {
                return false;
            }
            BigDecimal this$requestedQuantity = this.requestedQuantity;
            BigDecimal other$requestedQuantity = other.requestedQuantity;
            return !(this$requestedQuantity == null ? other$requestedQuantity != null : !((Object)this$requestedQuantity).equals(other$requestedQuantity));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DebitMemoRequestItem;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $debitMemoRequest = this.debitMemoRequest;
            result = result * 59 + ($debitMemoRequest == null ? 43 : $debitMemoRequest.hashCode());
            String $requestedQuantityUnit = this.requestedQuantityUnit;
            result = result * 59 + ($requestedQuantityUnit == null ? 43 : $requestedQuantityUnit.hashCode());
            BigDecimal $itemGrossWeight = this.itemGrossWeight;
            result = result * 59 + ($itemGrossWeight == null ? 43 : ((Object)$itemGrossWeight).hashCode());
            BigDecimal $itemNetWeight = this.itemNetWeight;
            result = result * 59 + ($itemNetWeight == null ? 43 : ((Object)$itemNetWeight).hashCode());
            String $itemWeightUnit = this.itemWeightUnit;
            result = result * 59 + ($itemWeightUnit == null ? 43 : $itemWeightUnit.hashCode());
            BigDecimal $itemVolume = this.itemVolume;
            result = result * 59 + ($itemVolume == null ? 43 : ((Object)$itemVolume).hashCode());
            String $itemVolumeUnit = this.itemVolumeUnit;
            result = result * 59 + ($itemVolumeUnit == null ? 43 : $itemVolumeUnit.hashCode());
            String $transactionCurrency = this.transactionCurrency;
            result = result * 59 + ($transactionCurrency == null ? 43 : $transactionCurrency.hashCode());
            BigDecimal $netAmount = this.netAmount;
            result = result * 59 + ($netAmount == null ? 43 : ((Object)$netAmount).hashCode());
            String $materialGroup = this.materialGroup;
            result = result * 59 + ($materialGroup == null ? 43 : $materialGroup.hashCode());
            String $incotermsClassification = this.incotermsClassification;
            result = result * 59 + ($incotermsClassification == null ? 43 : $incotermsClassification.hashCode());
            String $debitMemoRequestItem = this.debitMemoRequestItem;
            result = result * 59 + ($debitMemoRequestItem == null ? 43 : $debitMemoRequestItem.hashCode());
            String $incotermsTransferLocation = this.incotermsTransferLocation;
            result = result * 59 + ($incotermsTransferLocation == null ? 43 : $incotermsTransferLocation.hashCode());
            String $customerPaymentTerms = this.customerPaymentTerms;
            result = result * 59 + ($customerPaymentTerms == null ? 43 : $customerPaymentTerms.hashCode());
            String $itemBillingBlockReason = this.itemBillingBlockReason;
            result = result * 59 + ($itemBillingBlockReason == null ? 43 : $itemBillingBlockReason.hashCode());
            String $salesDocumentRjcnReason = this.salesDocumentRjcnReason;
            result = result * 59 + ($salesDocumentRjcnReason == null ? 43 : $salesDocumentRjcnReason.hashCode());
            String $sDProcessStatus = this.sDProcessStatus;
            result = result * 59 + ($sDProcessStatus == null ? 43 : $sDProcessStatus.hashCode());
            String $orderRelatedBillingStatus = this.orderRelatedBillingStatus;
            result = result * 59 + ($orderRelatedBillingStatus == null ? 43 : $orderRelatedBillingStatus.hashCode());
            String $debitMemoRequestItemCategory = this.debitMemoRequestItemCategory;
            result = result * 59 + ($debitMemoRequestItemCategory == null ? 43 : $debitMemoRequestItemCategory.hashCode());
            String $debitMemoRequestItemText = this.debitMemoRequestItemText;
            result = result * 59 + ($debitMemoRequestItemText == null ? 43 : $debitMemoRequestItemText.hashCode());
            String $purchaseOrderByCustomer = this.purchaseOrderByCustomer;
            result = result * 59 + ($purchaseOrderByCustomer == null ? 43 : $purchaseOrderByCustomer.hashCode());
            String $material = this.material;
            result = result * 59 + ($material == null ? 43 : $material.hashCode());
            String $materialByCustomer = this.materialByCustomer;
            result = result * 59 + ($materialByCustomer == null ? 43 : $materialByCustomer.hashCode());
            Calendar $pricingDate = this.pricingDate;
            result = result * 59 + ($pricingDate == null ? 43 : ((Object)$pricingDate).hashCode());
            BigDecimal $requestedQuantity = this.requestedQuantity;
            result = result * 59 + ($requestedQuantity == null ? 43 : ((Object)$requestedQuantity).hashCode());
            return result;
        }

        public String getDebitMemoRequest() {
            return this.debitMemoRequest;
        }

        public DebitMemoRequestItem setDebitMemoRequest(String debitMemoRequest) {
            this.debitMemoRequest = debitMemoRequest;
            return this;
        }

        public String getRequestedQuantityUnit() {
            return this.requestedQuantityUnit;
        }

        public DebitMemoRequestItem setRequestedQuantityUnit(String requestedQuantityUnit) {
            this.requestedQuantityUnit = requestedQuantityUnit;
            return this;
        }

        public BigDecimal getItemGrossWeight() {
            return this.itemGrossWeight;
        }

        public DebitMemoRequestItem setItemGrossWeight(BigDecimal itemGrossWeight) {
            this.itemGrossWeight = itemGrossWeight;
            return this;
        }

        public BigDecimal getItemNetWeight() {
            return this.itemNetWeight;
        }

        public DebitMemoRequestItem setItemNetWeight(BigDecimal itemNetWeight) {
            this.itemNetWeight = itemNetWeight;
            return this;
        }

        public String getItemWeightUnit() {
            return this.itemWeightUnit;
        }

        public DebitMemoRequestItem setItemWeightUnit(String itemWeightUnit) {
            this.itemWeightUnit = itemWeightUnit;
            return this;
        }

        public BigDecimal getItemVolume() {
            return this.itemVolume;
        }

        public DebitMemoRequestItem setItemVolume(BigDecimal itemVolume) {
            this.itemVolume = itemVolume;
            return this;
        }

        public String getItemVolumeUnit() {
            return this.itemVolumeUnit;
        }

        public DebitMemoRequestItem setItemVolumeUnit(String itemVolumeUnit) {
            this.itemVolumeUnit = itemVolumeUnit;
            return this;
        }

        public String getTransactionCurrency() {
            return this.transactionCurrency;
        }

        public DebitMemoRequestItem setTransactionCurrency(String transactionCurrency) {
            this.transactionCurrency = transactionCurrency;
            return this;
        }

        public BigDecimal getNetAmount() {
            return this.netAmount;
        }

        public DebitMemoRequestItem setNetAmount(BigDecimal netAmount) {
            this.netAmount = netAmount;
            return this;
        }

        public String getMaterialGroup() {
            return this.materialGroup;
        }

        public DebitMemoRequestItem setMaterialGroup(String materialGroup) {
            this.materialGroup = materialGroup;
            return this;
        }

        public String getIncotermsClassification() {
            return this.incotermsClassification;
        }

        public DebitMemoRequestItem setIncotermsClassification(String incotermsClassification) {
            this.incotermsClassification = incotermsClassification;
            return this;
        }

        public String getDebitMemoRequestItem() {
            return this.debitMemoRequestItem;
        }

        public DebitMemoRequestItem setDebitMemoRequestItem(String debitMemoRequestItem) {
            this.debitMemoRequestItem = debitMemoRequestItem;
            return this;
        }

        public String getIncotermsTransferLocation() {
            return this.incotermsTransferLocation;
        }

        public DebitMemoRequestItem setIncotermsTransferLocation(String incotermsTransferLocation) {
            this.incotermsTransferLocation = incotermsTransferLocation;
            return this;
        }

        public String getCustomerPaymentTerms() {
            return this.customerPaymentTerms;
        }

        public DebitMemoRequestItem setCustomerPaymentTerms(String customerPaymentTerms) {
            this.customerPaymentTerms = customerPaymentTerms;
            return this;
        }

        public String getItemBillingBlockReason() {
            return this.itemBillingBlockReason;
        }

        public DebitMemoRequestItem setItemBillingBlockReason(String itemBillingBlockReason) {
            this.itemBillingBlockReason = itemBillingBlockReason;
            return this;
        }

        public String getSalesDocumentRjcnReason() {
            return this.salesDocumentRjcnReason;
        }

        public DebitMemoRequestItem setSalesDocumentRjcnReason(String salesDocumentRjcnReason) {
            this.salesDocumentRjcnReason = salesDocumentRjcnReason;
            return this;
        }

        public String getSDProcessStatus() {
            return this.sDProcessStatus;
        }

        public DebitMemoRequestItem setSDProcessStatus(String sDProcessStatus) {
            this.sDProcessStatus = sDProcessStatus;
            return this;
        }

        public String getOrderRelatedBillingStatus() {
            return this.orderRelatedBillingStatus;
        }

        public DebitMemoRequestItem setOrderRelatedBillingStatus(String orderRelatedBillingStatus) {
            this.orderRelatedBillingStatus = orderRelatedBillingStatus;
            return this;
        }

        public String getDebitMemoRequestItemCategory() {
            return this.debitMemoRequestItemCategory;
        }

        public DebitMemoRequestItem setDebitMemoRequestItemCategory(String debitMemoRequestItemCategory) {
            this.debitMemoRequestItemCategory = debitMemoRequestItemCategory;
            return this;
        }

        public String getDebitMemoRequestItemText() {
            return this.debitMemoRequestItemText;
        }

        public DebitMemoRequestItem setDebitMemoRequestItemText(String debitMemoRequestItemText) {
            this.debitMemoRequestItemText = debitMemoRequestItemText;
            return this;
        }

        public String getPurchaseOrderByCustomer() {
            return this.purchaseOrderByCustomer;
        }

        public DebitMemoRequestItem setPurchaseOrderByCustomer(String purchaseOrderByCustomer) {
            this.purchaseOrderByCustomer = purchaseOrderByCustomer;
            return this;
        }

        public String getMaterial() {
            return this.material;
        }

        public DebitMemoRequestItem setMaterial(String material) {
            this.material = material;
            return this;
        }

        public String getMaterialByCustomer() {
            return this.materialByCustomer;
        }

        public DebitMemoRequestItem setMaterialByCustomer(String materialByCustomer) {
            this.materialByCustomer = materialByCustomer;
            return this;
        }

        public Calendar getPricingDate() {
            return this.pricingDate;
        }

        public DebitMemoRequestItem setPricingDate(Calendar pricingDate) {
            this.pricingDate = pricingDate;
            return this;
        }

        public BigDecimal getRequestedQuantity() {
            return this.requestedQuantity;
        }

        public DebitMemoRequestItem setRequestedQuantity(BigDecimal requestedQuantity) {
            this.requestedQuantity = requestedQuantity;
            return this;
        }

        public DebitMemoRequestItem setErpConfigContext(ErpConfigContext erpConfigContext) {
            this.erpConfigContext = erpConfigContext;
            return this;
        }
    }

    public static class DebitMemoRequestFluentHelper {
        private ODataQueryBuilder queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_DEBIT_MEMO_REQUEST_SRV", (String)"A_DebitMemoRequest");
        private ErrorResultHandler<?> errorResultHandler = new ODataVdmErrorResultHandler();

        public DebitMemoRequestFluentHelper filter(ExpressionFluentHelper<DebitMemoRequest> expression) {
            for (FilterExpressionWrapper<?> filterExpressionWrapper : expression.evaluate()) {
                Object comparisonValue = filterExpressionWrapper.getComparisonValue();
                if (comparisonValue instanceof Integer) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Integer)((Integer)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof String) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((String)((String)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Long) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Long)((Long)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Double) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Double)((Double)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Float) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Float)((Float)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDate) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDate)((LocalDate)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDateTime)((LocalDateTime)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Date) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Date)((Date)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof DateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((DateTime)((DateTime)comparisonValue))));
                    continue;
                }
                this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of(comparisonValue)));
            }
            return this;
        }

        public DebitMemoRequestFluentHelper orderBy(EntityField<?, DebitMemoRequest> field, Order order) {
            String orderingDirection = order == Order.ASC ? " asc" : " desc";
            this.queryBuilder.param("orderby", (Object)(field.getFieldName() + orderingDirection));
            return this;
        }

        @SafeVarargs
        public final DebitMemoRequestFluentHelper select(EntityField<?, DebitMemoRequest> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public DebitMemoRequestFluentHelper top(Number top) {
            this.queryBuilder.top(top);
            return this;
        }

        public DebitMemoRequestFluentHelper skip(Number skip) {
            this.queryBuilder.skip(skip);
            return this;
        }

        public DebitMemoRequestFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.errorHandler(this.errorResultHandler).build();
        }

        public List<DebitMemoRequest> execute(ErpConfigContext erpConfigContext) throws ODataException {
            List entityList = this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).asList(DebitMemoRequest.class);
            for (DebitMemoRequest entity : entityList) {
                entity.setErpConfigContext(erpConfigContext);
            }
            return entityList;
        }
    }

    public static class DebitMemoRequestByKeyFluentHelper {
        private ODataQueryBuilder queryBuilder;
        private ErrorResultHandler<?> errorResultHandler;
        private List<Object> values = new LinkedList<Object>();

        public DebitMemoRequestByKeyFluentHelper(String debitMemoRequest) {
            this.values.add(debitMemoRequest);
            this.queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_DEBIT_MEMO_REQUEST_SRV", (String)"A_DebitMemoRequest");
            HashMap<String, Object> keys = new HashMap<String, Object>();
            keys.put("DebitMemoRequest", this.values.get(0));
            this.queryBuilder.keys(keys);
        }

        @SafeVarargs
        public final DebitMemoRequestByKeyFluentHelper select(EntityField<?, DebitMemoRequest> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.build();
        }

        public DebitMemoRequestByKeyFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public DebitMemoRequest execute(ErpConfigContext erpConfigContext) throws ODataException {
            DebitMemoRequest entity = (DebitMemoRequest)this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).as(DebitMemoRequest.class);
            entity.setErpConfigContext(erpConfigContext);
            return entity;
        }
    }

    public static class DebitMemoRequest {
        @ElementName(value="DebitMemoRequest")
        private String debitMemoRequest;
        public static EntityField<String, DebitMemoRequest> DEBIT_MEMO_REQUEST = new EntityField("DebitMemoRequest");
        @ElementName(value="CreationDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar creationDate;
        public static EntityField<Calendar, DebitMemoRequest> CREATION_DATE = new EntityField("CreationDate");
        @ElementName(value="CreatedByUser")
        private String createdByUser;
        public static EntityField<String, DebitMemoRequest> CREATED_BY_USER = new EntityField("CreatedByUser");
        @ElementName(value="LastChangeDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar lastChangeDate;
        public static EntityField<Calendar, DebitMemoRequest> LAST_CHANGE_DATE = new EntityField("LastChangeDate");
        @ElementName(value="LastChangeDateTime")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar lastChangeDateTime;
        public static EntityField<Calendar, DebitMemoRequest> LAST_CHANGE_DATE_TIME = new EntityField("LastChangeDateTime");
        @ElementName(value="PurchaseOrderByCustomer")
        private String purchaseOrderByCustomer;
        public static EntityField<String, DebitMemoRequest> PURCHASE_ORDER_BY_CUSTOMER = new EntityField("PurchaseOrderByCustomer");
        @ElementName(value="CustomerPurchaseOrderType")
        private String customerPurchaseOrderType;
        public static EntityField<String, DebitMemoRequest> CUSTOMER_PURCHASE_ORDER_TYPE = new EntityField("CustomerPurchaseOrderType");
        @ElementName(value="CustomerPurchaseOrderDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar customerPurchaseOrderDate;
        public static EntityField<Calendar, DebitMemoRequest> CUSTOMER_PURCHASE_ORDER_DATE = new EntityField("CustomerPurchaseOrderDate");
        @ElementName(value="DebitMemoRequestDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar debitMemoRequestDate;
        public static EntityField<Calendar, DebitMemoRequest> DEBIT_MEMO_REQUEST_DATE = new EntityField("DebitMemoRequestDate");
        @ElementName(value="TotalNetAmount")
        private BigDecimal totalNetAmount;
        public static EntityField<BigDecimal, DebitMemoRequest> TOTAL_NET_AMOUNT = new EntityField("TotalNetAmount");
        @ElementName(value="TransactionCurrency")
        private String transactionCurrency;
        public static EntityField<String, DebitMemoRequest> TRANSACTION_CURRENCY = new EntityField("TransactionCurrency");
        @ElementName(value="DebitMemoRequestType")
        private String debitMemoRequestType;
        public static EntityField<String, DebitMemoRequest> DEBIT_MEMO_REQUEST_TYPE = new EntityField("DebitMemoRequestType");
        @ElementName(value="SDDocumentReason")
        private String sDDocumentReason;
        public static EntityField<String, DebitMemoRequest> S_D_DOCUMENT_REASON = new EntityField("SDDocumentReason");
        @ElementName(value="PricingDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar pricingDate;
        public static EntityField<Calendar, DebitMemoRequest> PRICING_DATE = new EntityField("PricingDate");
        @ElementName(value="HeaderBillingBlockReason")
        private String headerBillingBlockReason;
        public static EntityField<String, DebitMemoRequest> HEADER_BILLING_BLOCK_REASON = new EntityField("HeaderBillingBlockReason");
        @ElementName(value="CustomerPaymentTerms")
        private String customerPaymentTerms;
        public static EntityField<String, DebitMemoRequest> CUSTOMER_PAYMENT_TERMS = new EntityField("CustomerPaymentTerms");
        @ElementName(value="PaymentMethod")
        private String paymentMethod;
        public static EntityField<String, DebitMemoRequest> PAYMENT_METHOD = new EntityField("PaymentMethod");
        @ElementName(value="BillingDocumentDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar billingDocumentDate;
        public static EntityField<Calendar, DebitMemoRequest> BILLING_DOCUMENT_DATE = new EntityField("BillingDocumentDate");
        @ElementName(value="ServicesRenderedDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar servicesRenderedDate;
        public static EntityField<Calendar, DebitMemoRequest> SERVICES_RENDERED_DATE = new EntityField("ServicesRenderedDate");
        @ElementName(value="OverallSDProcessStatus")
        private String overallSDProcessStatus;
        public static EntityField<String, DebitMemoRequest> OVERALL_S_D_PROCESS_STATUS = new EntityField("OverallSDProcessStatus");
        @ElementName(value="TotalCreditCheckStatus")
        private String totalCreditCheckStatus;
        public static EntityField<String, DebitMemoRequest> TOTAL_CREDIT_CHECK_STATUS = new EntityField("TotalCreditCheckStatus");
        @ElementName(value="OverallSDDocumentRejectionSts")
        private String overallSDDocumentRejectionSts;
        public static EntityField<String, DebitMemoRequest> OVERALL_S_D_DOCUMENT_REJECTION_STS = new EntityField("OverallSDDocumentRejectionSts");
        @ElementName(value="SalesOrganization")
        private String salesOrganization;
        public static EntityField<String, DebitMemoRequest> SALES_ORGANIZATION = new EntityField("SalesOrganization");
        @ElementName(value="OverallOrdReltdBillgStatus")
        private String overallOrdReltdBillgStatus;
        public static EntityField<String, DebitMemoRequest> OVERALL_ORD_RELTD_BILLG_STATUS = new EntityField("OverallOrdReltdBillgStatus");
        @ElementName(value="DistributionChannel")
        private String distributionChannel;
        public static EntityField<String, DebitMemoRequest> DISTRIBUTION_CHANNEL = new EntityField("DistributionChannel");
        @ElementName(value="OrganizationDivision")
        private String organizationDivision;
        public static EntityField<String, DebitMemoRequest> ORGANIZATION_DIVISION = new EntityField("OrganizationDivision");
        @ElementName(value="SalesGroup")
        private String salesGroup;
        public static EntityField<String, DebitMemoRequest> SALES_GROUP = new EntityField("SalesGroup");
        @ElementName(value="SalesOffice")
        private String salesOffice;
        public static EntityField<String, DebitMemoRequest> SALES_OFFICE = new EntityField("SalesOffice");
        @ElementName(value="SalesDistrict")
        private String salesDistrict;
        public static EntityField<String, DebitMemoRequest> SALES_DISTRICT = new EntityField("SalesDistrict");
        @ElementName(value="SoldToParty")
        private String soldToParty;
        public static EntityField<String, DebitMemoRequest> SOLD_TO_PARTY = new EntityField("SoldToParty");
        private static final transient String ODATA_ENDPOINT_URL = "/sap/opu/odata/sap/API_DEBIT_MEMO_REQUEST_SRV";
        private static final transient String ODATA_ENTITY_COLLECTION = "A_DebitMemoRequest";
        private transient ErpConfigContext erpConfigContext;

        @JsonIgnore
        public List<DebitMemoRequestItem> fetchItem() throws ODataException {
            StringBuilder odataResourceUrl = new StringBuilder(ODATA_ENTITY_COLLECTION);
            odataResourceUrl.append("(");
            odataResourceUrl.append("DebitMemoRequest=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.debitMemoRequest));
            odataResourceUrl.append(")/");
            odataResourceUrl.append("to_Item");
            ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)ODATA_ENDPOINT_URL, (String)odataResourceUrl.toString());
            ODataQuery query = builder.build();
            ErpEndpoint erpEndpoint = new ErpEndpoint(this.erpConfigContext);
            ODataQueryResult result = query.execute((WithDestinationName)erpEndpoint);
            List entityList = result.asList(DebitMemoRequestItem.class);
            for (DebitMemoRequestItem entity : entityList) {
                entity.setErpConfigContext(this.erpConfigContext);
            }
            return entityList;
        }

        @JsonIgnore
        public List<DebitMemoReqPartner> fetchPartner() throws ODataException {
            StringBuilder odataResourceUrl = new StringBuilder(ODATA_ENTITY_COLLECTION);
            odataResourceUrl.append("(");
            odataResourceUrl.append("DebitMemoRequest=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.debitMemoRequest));
            odataResourceUrl.append(")/");
            odataResourceUrl.append("to_Partner");
            ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)ODATA_ENDPOINT_URL, (String)odataResourceUrl.toString());
            ODataQuery query = builder.build();
            ErpEndpoint erpEndpoint = new ErpEndpoint(this.erpConfigContext);
            ODataQueryResult result = query.execute((WithDestinationName)erpEndpoint);
            List entityList = result.asList(DebitMemoReqPartner.class);
            for (DebitMemoReqPartner entity : entityList) {
                entity.setErpConfigContext(this.erpConfigContext);
            }
            return entityList;
        }

        @JsonIgnore
        public List<DebitMemoReqPrcgElmnt> fetchPricingElement() throws ODataException {
            StringBuilder odataResourceUrl = new StringBuilder(ODATA_ENTITY_COLLECTION);
            odataResourceUrl.append("(");
            odataResourceUrl.append("DebitMemoRequest=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.debitMemoRequest));
            odataResourceUrl.append(")/");
            odataResourceUrl.append("to_PricingElement");
            ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)ODATA_ENDPOINT_URL, (String)odataResourceUrl.toString());
            ODataQuery query = builder.build();
            ErpEndpoint erpEndpoint = new ErpEndpoint(this.erpConfigContext);
            ODataQueryResult result = query.execute((WithDestinationName)erpEndpoint);
            List entityList = result.asList(DebitMemoReqPrcgElmnt.class);
            for (DebitMemoReqPrcgElmnt entity : entityList) {
                entity.setErpConfigContext(this.erpConfigContext);
            }
            return entityList;
        }

        public String toString() {
            return "ReadDebitMemoRequestsNamespace.DebitMemoRequest(debitMemoRequest=" + this.debitMemoRequest + ", creationDate=" + this.creationDate + ", createdByUser=" + this.createdByUser + ", lastChangeDate=" + this.lastChangeDate + ", lastChangeDateTime=" + this.lastChangeDateTime + ", purchaseOrderByCustomer=" + this.purchaseOrderByCustomer + ", customerPurchaseOrderType=" + this.customerPurchaseOrderType + ", customerPurchaseOrderDate=" + this.customerPurchaseOrderDate + ", debitMemoRequestDate=" + this.debitMemoRequestDate + ", totalNetAmount=" + this.totalNetAmount + ", transactionCurrency=" + this.transactionCurrency + ", debitMemoRequestType=" + this.debitMemoRequestType + ", sDDocumentReason=" + this.sDDocumentReason + ", pricingDate=" + this.pricingDate + ", headerBillingBlockReason=" + this.headerBillingBlockReason + ", customerPaymentTerms=" + this.customerPaymentTerms + ", paymentMethod=" + this.paymentMethod + ", billingDocumentDate=" + this.billingDocumentDate + ", servicesRenderedDate=" + this.servicesRenderedDate + ", overallSDProcessStatus=" + this.overallSDProcessStatus + ", totalCreditCheckStatus=" + this.totalCreditCheckStatus + ", overallSDDocumentRejectionSts=" + this.overallSDDocumentRejectionSts + ", salesOrganization=" + this.salesOrganization + ", overallOrdReltdBillgStatus=" + this.overallOrdReltdBillgStatus + ", distributionChannel=" + this.distributionChannel + ", organizationDivision=" + this.organizationDivision + ", salesGroup=" + this.salesGroup + ", salesOffice=" + this.salesOffice + ", salesDistrict=" + this.salesDistrict + ", soldToParty=" + this.soldToParty + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DebitMemoRequest)) {
                return false;
            }
            DebitMemoRequest other = (DebitMemoRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$debitMemoRequest = this.debitMemoRequest;
            String other$debitMemoRequest = other.debitMemoRequest;
            if (this$debitMemoRequest == null ? other$debitMemoRequest != null : !this$debitMemoRequest.equals(other$debitMemoRequest)) {
                return false;
            }
            Calendar this$creationDate = this.creationDate;
            Calendar other$creationDate = other.creationDate;
            if (this$creationDate == null ? other$creationDate != null : !((Object)this$creationDate).equals(other$creationDate)) {
                return false;
            }
            String this$createdByUser = this.createdByUser;
            String other$createdByUser = other.createdByUser;
            if (this$createdByUser == null ? other$createdByUser != null : !this$createdByUser.equals(other$createdByUser)) {
                return false;
            }
            Calendar this$lastChangeDate = this.lastChangeDate;
            Calendar other$lastChangeDate = other.lastChangeDate;
            if (this$lastChangeDate == null ? other$lastChangeDate != null : !((Object)this$lastChangeDate).equals(other$lastChangeDate)) {
                return false;
            }
            Calendar this$lastChangeDateTime = this.lastChangeDateTime;
            Calendar other$lastChangeDateTime = other.lastChangeDateTime;
            if (this$lastChangeDateTime == null ? other$lastChangeDateTime != null : !((Object)this$lastChangeDateTime).equals(other$lastChangeDateTime)) {
                return false;
            }
            String this$purchaseOrderByCustomer = this.purchaseOrderByCustomer;
            String other$purchaseOrderByCustomer = other.purchaseOrderByCustomer;
            if (this$purchaseOrderByCustomer == null ? other$purchaseOrderByCustomer != null : !this$purchaseOrderByCustomer.equals(other$purchaseOrderByCustomer)) {
                return false;
            }
            String this$customerPurchaseOrderType = this.customerPurchaseOrderType;
            String other$customerPurchaseOrderType = other.customerPurchaseOrderType;
            if (this$customerPurchaseOrderType == null ? other$customerPurchaseOrderType != null : !this$customerPurchaseOrderType.equals(other$customerPurchaseOrderType)) {
                return false;
            }
            Calendar this$customerPurchaseOrderDate = this.customerPurchaseOrderDate;
            Calendar other$customerPurchaseOrderDate = other.customerPurchaseOrderDate;
            if (this$customerPurchaseOrderDate == null ? other$customerPurchaseOrderDate != null : !((Object)this$customerPurchaseOrderDate).equals(other$customerPurchaseOrderDate)) {
                return false;
            }
            Calendar this$debitMemoRequestDate = this.debitMemoRequestDate;
            Calendar other$debitMemoRequestDate = other.debitMemoRequestDate;
            if (this$debitMemoRequestDate == null ? other$debitMemoRequestDate != null : !((Object)this$debitMemoRequestDate).equals(other$debitMemoRequestDate)) {
                return false;
            }
            BigDecimal this$totalNetAmount = this.totalNetAmount;
            BigDecimal other$totalNetAmount = other.totalNetAmount;
            if (this$totalNetAmount == null ? other$totalNetAmount != null : !((Object)this$totalNetAmount).equals(other$totalNetAmount)) {
                return false;
            }
            String this$transactionCurrency = this.transactionCurrency;
            String other$transactionCurrency = other.transactionCurrency;
            if (this$transactionCurrency == null ? other$transactionCurrency != null : !this$transactionCurrency.equals(other$transactionCurrency)) {
                return false;
            }
            String this$debitMemoRequestType = this.debitMemoRequestType;
            String other$debitMemoRequestType = other.debitMemoRequestType;
            if (this$debitMemoRequestType == null ? other$debitMemoRequestType != null : !this$debitMemoRequestType.equals(other$debitMemoRequestType)) {
                return false;
            }
            String this$sDDocumentReason = this.sDDocumentReason;
            String other$sDDocumentReason = other.sDDocumentReason;
            if (this$sDDocumentReason == null ? other$sDDocumentReason != null : !this$sDDocumentReason.equals(other$sDDocumentReason)) {
                return false;
            }
            Calendar this$pricingDate = this.pricingDate;
            Calendar other$pricingDate = other.pricingDate;
            if (this$pricingDate == null ? other$pricingDate != null : !((Object)this$pricingDate).equals(other$pricingDate)) {
                return false;
            }
            String this$headerBillingBlockReason = this.headerBillingBlockReason;
            String other$headerBillingBlockReason = other.headerBillingBlockReason;
            if (this$headerBillingBlockReason == null ? other$headerBillingBlockReason != null : !this$headerBillingBlockReason.equals(other$headerBillingBlockReason)) {
                return false;
            }
            String this$customerPaymentTerms = this.customerPaymentTerms;
            String other$customerPaymentTerms = other.customerPaymentTerms;
            if (this$customerPaymentTerms == null ? other$customerPaymentTerms != null : !this$customerPaymentTerms.equals(other$customerPaymentTerms)) {
                return false;
            }
            String this$paymentMethod = this.paymentMethod;
            String other$paymentMethod = other.paymentMethod;
            if (this$paymentMethod == null ? other$paymentMethod != null : !this$paymentMethod.equals(other$paymentMethod)) {
                return false;
            }
            Calendar this$billingDocumentDate = this.billingDocumentDate;
            Calendar other$billingDocumentDate = other.billingDocumentDate;
            if (this$billingDocumentDate == null ? other$billingDocumentDate != null : !((Object)this$billingDocumentDate).equals(other$billingDocumentDate)) {
                return false;
            }
            Calendar this$servicesRenderedDate = this.servicesRenderedDate;
            Calendar other$servicesRenderedDate = other.servicesRenderedDate;
            if (this$servicesRenderedDate == null ? other$servicesRenderedDate != null : !((Object)this$servicesRenderedDate).equals(other$servicesRenderedDate)) {
                return false;
            }
            String this$overallSDProcessStatus = this.overallSDProcessStatus;
            String other$overallSDProcessStatus = other.overallSDProcessStatus;
            if (this$overallSDProcessStatus == null ? other$overallSDProcessStatus != null : !this$overallSDProcessStatus.equals(other$overallSDProcessStatus)) {
                return false;
            }
            String this$totalCreditCheckStatus = this.totalCreditCheckStatus;
            String other$totalCreditCheckStatus = other.totalCreditCheckStatus;
            if (this$totalCreditCheckStatus == null ? other$totalCreditCheckStatus != null : !this$totalCreditCheckStatus.equals(other$totalCreditCheckStatus)) {
                return false;
            }
            String this$overallSDDocumentRejectionSts = this.overallSDDocumentRejectionSts;
            String other$overallSDDocumentRejectionSts = other.overallSDDocumentRejectionSts;
            if (this$overallSDDocumentRejectionSts == null ? other$overallSDDocumentRejectionSts != null : !this$overallSDDocumentRejectionSts.equals(other$overallSDDocumentRejectionSts)) {
                return false;
            }
            String this$salesOrganization = this.salesOrganization;
            String other$salesOrganization = other.salesOrganization;
            if (this$salesOrganization == null ? other$salesOrganization != null : !this$salesOrganization.equals(other$salesOrganization)) {
                return false;
            }
            String this$overallOrdReltdBillgStatus = this.overallOrdReltdBillgStatus;
            String other$overallOrdReltdBillgStatus = other.overallOrdReltdBillgStatus;
            if (this$overallOrdReltdBillgStatus == null ? other$overallOrdReltdBillgStatus != null : !this$overallOrdReltdBillgStatus.equals(other$overallOrdReltdBillgStatus)) {
                return false;
            }
            String this$distributionChannel = this.distributionChannel;
            String other$distributionChannel = other.distributionChannel;
            if (this$distributionChannel == null ? other$distributionChannel != null : !this$distributionChannel.equals(other$distributionChannel)) {
                return false;
            }
            String this$organizationDivision = this.organizationDivision;
            String other$organizationDivision = other.organizationDivision;
            if (this$organizationDivision == null ? other$organizationDivision != null : !this$organizationDivision.equals(other$organizationDivision)) {
                return false;
            }
            String this$salesGroup = this.salesGroup;
            String other$salesGroup = other.salesGroup;
            if (this$salesGroup == null ? other$salesGroup != null : !this$salesGroup.equals(other$salesGroup)) {
                return false;
            }
            String this$salesOffice = this.salesOffice;
            String other$salesOffice = other.salesOffice;
            if (this$salesOffice == null ? other$salesOffice != null : !this$salesOffice.equals(other$salesOffice)) {
                return false;
            }
            String this$salesDistrict = this.salesDistrict;
            String other$salesDistrict = other.salesDistrict;
            if (this$salesDistrict == null ? other$salesDistrict != null : !this$salesDistrict.equals(other$salesDistrict)) {
                return false;
            }
            String this$soldToParty = this.soldToParty;
            String other$soldToParty = other.soldToParty;
            return !(this$soldToParty == null ? other$soldToParty != null : !this$soldToParty.equals(other$soldToParty));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DebitMemoRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $debitMemoRequest = this.debitMemoRequest;
            result = result * 59 + ($debitMemoRequest == null ? 43 : $debitMemoRequest.hashCode());
            Calendar $creationDate = this.creationDate;
            result = result * 59 + ($creationDate == null ? 43 : ((Object)$creationDate).hashCode());
            String $createdByUser = this.createdByUser;
            result = result * 59 + ($createdByUser == null ? 43 : $createdByUser.hashCode());
            Calendar $lastChangeDate = this.lastChangeDate;
            result = result * 59 + ($lastChangeDate == null ? 43 : ((Object)$lastChangeDate).hashCode());
            Calendar $lastChangeDateTime = this.lastChangeDateTime;
            result = result * 59 + ($lastChangeDateTime == null ? 43 : ((Object)$lastChangeDateTime).hashCode());
            String $purchaseOrderByCustomer = this.purchaseOrderByCustomer;
            result = result * 59 + ($purchaseOrderByCustomer == null ? 43 : $purchaseOrderByCustomer.hashCode());
            String $customerPurchaseOrderType = this.customerPurchaseOrderType;
            result = result * 59 + ($customerPurchaseOrderType == null ? 43 : $customerPurchaseOrderType.hashCode());
            Calendar $customerPurchaseOrderDate = this.customerPurchaseOrderDate;
            result = result * 59 + ($customerPurchaseOrderDate == null ? 43 : ((Object)$customerPurchaseOrderDate).hashCode());
            Calendar $debitMemoRequestDate = this.debitMemoRequestDate;
            result = result * 59 + ($debitMemoRequestDate == null ? 43 : ((Object)$debitMemoRequestDate).hashCode());
            BigDecimal $totalNetAmount = this.totalNetAmount;
            result = result * 59 + ($totalNetAmount == null ? 43 : ((Object)$totalNetAmount).hashCode());
            String $transactionCurrency = this.transactionCurrency;
            result = result * 59 + ($transactionCurrency == null ? 43 : $transactionCurrency.hashCode());
            String $debitMemoRequestType = this.debitMemoRequestType;
            result = result * 59 + ($debitMemoRequestType == null ? 43 : $debitMemoRequestType.hashCode());
            String $sDDocumentReason = this.sDDocumentReason;
            result = result * 59 + ($sDDocumentReason == null ? 43 : $sDDocumentReason.hashCode());
            Calendar $pricingDate = this.pricingDate;
            result = result * 59 + ($pricingDate == null ? 43 : ((Object)$pricingDate).hashCode());
            String $headerBillingBlockReason = this.headerBillingBlockReason;
            result = result * 59 + ($headerBillingBlockReason == null ? 43 : $headerBillingBlockReason.hashCode());
            String $customerPaymentTerms = this.customerPaymentTerms;
            result = result * 59 + ($customerPaymentTerms == null ? 43 : $customerPaymentTerms.hashCode());
            String $paymentMethod = this.paymentMethod;
            result = result * 59 + ($paymentMethod == null ? 43 : $paymentMethod.hashCode());
            Calendar $billingDocumentDate = this.billingDocumentDate;
            result = result * 59 + ($billingDocumentDate == null ? 43 : ((Object)$billingDocumentDate).hashCode());
            Calendar $servicesRenderedDate = this.servicesRenderedDate;
            result = result * 59 + ($servicesRenderedDate == null ? 43 : ((Object)$servicesRenderedDate).hashCode());
            String $overallSDProcessStatus = this.overallSDProcessStatus;
            result = result * 59 + ($overallSDProcessStatus == null ? 43 : $overallSDProcessStatus.hashCode());
            String $totalCreditCheckStatus = this.totalCreditCheckStatus;
            result = result * 59 + ($totalCreditCheckStatus == null ? 43 : $totalCreditCheckStatus.hashCode());
            String $overallSDDocumentRejectionSts = this.overallSDDocumentRejectionSts;
            result = result * 59 + ($overallSDDocumentRejectionSts == null ? 43 : $overallSDDocumentRejectionSts.hashCode());
            String $salesOrganization = this.salesOrganization;
            result = result * 59 + ($salesOrganization == null ? 43 : $salesOrganization.hashCode());
            String $overallOrdReltdBillgStatus = this.overallOrdReltdBillgStatus;
            result = result * 59 + ($overallOrdReltdBillgStatus == null ? 43 : $overallOrdReltdBillgStatus.hashCode());
            String $distributionChannel = this.distributionChannel;
            result = result * 59 + ($distributionChannel == null ? 43 : $distributionChannel.hashCode());
            String $organizationDivision = this.organizationDivision;
            result = result * 59 + ($organizationDivision == null ? 43 : $organizationDivision.hashCode());
            String $salesGroup = this.salesGroup;
            result = result * 59 + ($salesGroup == null ? 43 : $salesGroup.hashCode());
            String $salesOffice = this.salesOffice;
            result = result * 59 + ($salesOffice == null ? 43 : $salesOffice.hashCode());
            String $salesDistrict = this.salesDistrict;
            result = result * 59 + ($salesDistrict == null ? 43 : $salesDistrict.hashCode());
            String $soldToParty = this.soldToParty;
            result = result * 59 + ($soldToParty == null ? 43 : $soldToParty.hashCode());
            return result;
        }

        public String getDebitMemoRequest() {
            return this.debitMemoRequest;
        }

        public DebitMemoRequest setDebitMemoRequest(String debitMemoRequest) {
            this.debitMemoRequest = debitMemoRequest;
            return this;
        }

        public Calendar getCreationDate() {
            return this.creationDate;
        }

        public DebitMemoRequest setCreationDate(Calendar creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public String getCreatedByUser() {
            return this.createdByUser;
        }

        public DebitMemoRequest setCreatedByUser(String createdByUser) {
            this.createdByUser = createdByUser;
            return this;
        }

        public Calendar getLastChangeDate() {
            return this.lastChangeDate;
        }

        public DebitMemoRequest setLastChangeDate(Calendar lastChangeDate) {
            this.lastChangeDate = lastChangeDate;
            return this;
        }

        public Calendar getLastChangeDateTime() {
            return this.lastChangeDateTime;
        }

        public DebitMemoRequest setLastChangeDateTime(Calendar lastChangeDateTime) {
            this.lastChangeDateTime = lastChangeDateTime;
            return this;
        }

        public String getPurchaseOrderByCustomer() {
            return this.purchaseOrderByCustomer;
        }

        public DebitMemoRequest setPurchaseOrderByCustomer(String purchaseOrderByCustomer) {
            this.purchaseOrderByCustomer = purchaseOrderByCustomer;
            return this;
        }

        public String getCustomerPurchaseOrderType() {
            return this.customerPurchaseOrderType;
        }

        public DebitMemoRequest setCustomerPurchaseOrderType(String customerPurchaseOrderType) {
            this.customerPurchaseOrderType = customerPurchaseOrderType;
            return this;
        }

        public Calendar getCustomerPurchaseOrderDate() {
            return this.customerPurchaseOrderDate;
        }

        public DebitMemoRequest setCustomerPurchaseOrderDate(Calendar customerPurchaseOrderDate) {
            this.customerPurchaseOrderDate = customerPurchaseOrderDate;
            return this;
        }

        public Calendar getDebitMemoRequestDate() {
            return this.debitMemoRequestDate;
        }

        public DebitMemoRequest setDebitMemoRequestDate(Calendar debitMemoRequestDate) {
            this.debitMemoRequestDate = debitMemoRequestDate;
            return this;
        }

        public BigDecimal getTotalNetAmount() {
            return this.totalNetAmount;
        }

        public DebitMemoRequest setTotalNetAmount(BigDecimal totalNetAmount) {
            this.totalNetAmount = totalNetAmount;
            return this;
        }

        public String getTransactionCurrency() {
            return this.transactionCurrency;
        }

        public DebitMemoRequest setTransactionCurrency(String transactionCurrency) {
            this.transactionCurrency = transactionCurrency;
            return this;
        }

        public String getDebitMemoRequestType() {
            return this.debitMemoRequestType;
        }

        public DebitMemoRequest setDebitMemoRequestType(String debitMemoRequestType) {
            this.debitMemoRequestType = debitMemoRequestType;
            return this;
        }

        public String getSDDocumentReason() {
            return this.sDDocumentReason;
        }

        public DebitMemoRequest setSDDocumentReason(String sDDocumentReason) {
            this.sDDocumentReason = sDDocumentReason;
            return this;
        }

        public Calendar getPricingDate() {
            return this.pricingDate;
        }

        public DebitMemoRequest setPricingDate(Calendar pricingDate) {
            this.pricingDate = pricingDate;
            return this;
        }

        public String getHeaderBillingBlockReason() {
            return this.headerBillingBlockReason;
        }

        public DebitMemoRequest setHeaderBillingBlockReason(String headerBillingBlockReason) {
            this.headerBillingBlockReason = headerBillingBlockReason;
            return this;
        }

        public String getCustomerPaymentTerms() {
            return this.customerPaymentTerms;
        }

        public DebitMemoRequest setCustomerPaymentTerms(String customerPaymentTerms) {
            this.customerPaymentTerms = customerPaymentTerms;
            return this;
        }

        public String getPaymentMethod() {
            return this.paymentMethod;
        }

        public DebitMemoRequest setPaymentMethod(String paymentMethod) {
            this.paymentMethod = paymentMethod;
            return this;
        }

        public Calendar getBillingDocumentDate() {
            return this.billingDocumentDate;
        }

        public DebitMemoRequest setBillingDocumentDate(Calendar billingDocumentDate) {
            this.billingDocumentDate = billingDocumentDate;
            return this;
        }

        public Calendar getServicesRenderedDate() {
            return this.servicesRenderedDate;
        }

        public DebitMemoRequest setServicesRenderedDate(Calendar servicesRenderedDate) {
            this.servicesRenderedDate = servicesRenderedDate;
            return this;
        }

        public String getOverallSDProcessStatus() {
            return this.overallSDProcessStatus;
        }

        public DebitMemoRequest setOverallSDProcessStatus(String overallSDProcessStatus) {
            this.overallSDProcessStatus = overallSDProcessStatus;
            return this;
        }

        public String getTotalCreditCheckStatus() {
            return this.totalCreditCheckStatus;
        }

        public DebitMemoRequest setTotalCreditCheckStatus(String totalCreditCheckStatus) {
            this.totalCreditCheckStatus = totalCreditCheckStatus;
            return this;
        }

        public String getOverallSDDocumentRejectionSts() {
            return this.overallSDDocumentRejectionSts;
        }

        public DebitMemoRequest setOverallSDDocumentRejectionSts(String overallSDDocumentRejectionSts) {
            this.overallSDDocumentRejectionSts = overallSDDocumentRejectionSts;
            return this;
        }

        public String getSalesOrganization() {
            return this.salesOrganization;
        }

        public DebitMemoRequest setSalesOrganization(String salesOrganization) {
            this.salesOrganization = salesOrganization;
            return this;
        }

        public String getOverallOrdReltdBillgStatus() {
            return this.overallOrdReltdBillgStatus;
        }

        public DebitMemoRequest setOverallOrdReltdBillgStatus(String overallOrdReltdBillgStatus) {
            this.overallOrdReltdBillgStatus = overallOrdReltdBillgStatus;
            return this;
        }

        public String getDistributionChannel() {
            return this.distributionChannel;
        }

        public DebitMemoRequest setDistributionChannel(String distributionChannel) {
            this.distributionChannel = distributionChannel;
            return this;
        }

        public String getOrganizationDivision() {
            return this.organizationDivision;
        }

        public DebitMemoRequest setOrganizationDivision(String organizationDivision) {
            this.organizationDivision = organizationDivision;
            return this;
        }

        public String getSalesGroup() {
            return this.salesGroup;
        }

        public DebitMemoRequest setSalesGroup(String salesGroup) {
            this.salesGroup = salesGroup;
            return this;
        }

        public String getSalesOffice() {
            return this.salesOffice;
        }

        public DebitMemoRequest setSalesOffice(String salesOffice) {
            this.salesOffice = salesOffice;
            return this;
        }

        public String getSalesDistrict() {
            return this.salesDistrict;
        }

        public DebitMemoRequest setSalesDistrict(String salesDistrict) {
            this.salesDistrict = salesDistrict;
            return this;
        }

        public String getSoldToParty() {
            return this.soldToParty;
        }

        public DebitMemoRequest setSoldToParty(String soldToParty) {
            this.soldToParty = soldToParty;
            return this;
        }

        public DebitMemoRequest setErpConfigContext(ErpConfigContext erpConfigContext) {
            this.erpConfigContext = erpConfigContext;
            return this;
        }
    }

    public static class DebitMemoReqPrcgElmntFluentHelper {
        private ODataQueryBuilder queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_DEBIT_MEMO_REQUEST_SRV", (String)"A_DebitMemoReqPrcgElmnt");
        private ErrorResultHandler<?> errorResultHandler = new ODataVdmErrorResultHandler();

        public DebitMemoReqPrcgElmntFluentHelper filter(ExpressionFluentHelper<DebitMemoReqPrcgElmnt> expression) {
            for (FilterExpressionWrapper<?> filterExpressionWrapper : expression.evaluate()) {
                Object comparisonValue = filterExpressionWrapper.getComparisonValue();
                if (comparisonValue instanceof Integer) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Integer)((Integer)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof String) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((String)((String)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Long) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Long)((Long)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Double) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Double)((Double)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Float) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Float)((Float)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDate) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDate)((LocalDate)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDateTime)((LocalDateTime)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Date) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Date)((Date)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof DateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((DateTime)((DateTime)comparisonValue))));
                    continue;
                }
                this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of(comparisonValue)));
            }
            return this;
        }

        public DebitMemoReqPrcgElmntFluentHelper orderBy(EntityField<?, DebitMemoReqPrcgElmnt> field, Order order) {
            String orderingDirection = order == Order.ASC ? " asc" : " desc";
            this.queryBuilder.param("orderby", (Object)(field.getFieldName() + orderingDirection));
            return this;
        }

        @SafeVarargs
        public final DebitMemoReqPrcgElmntFluentHelper select(EntityField<?, DebitMemoReqPrcgElmnt> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public DebitMemoReqPrcgElmntFluentHelper top(Number top) {
            this.queryBuilder.top(top);
            return this;
        }

        public DebitMemoReqPrcgElmntFluentHelper skip(Number skip) {
            this.queryBuilder.skip(skip);
            return this;
        }

        public DebitMemoReqPrcgElmntFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.errorHandler(this.errorResultHandler).build();
        }

        public List<DebitMemoReqPrcgElmnt> execute(ErpConfigContext erpConfigContext) throws ODataException {
            List entityList = this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).asList(DebitMemoReqPrcgElmnt.class);
            for (DebitMemoReqPrcgElmnt entity : entityList) {
                entity.setErpConfigContext(erpConfigContext);
            }
            return entityList;
        }
    }

    public static class DebitMemoReqPrcgElmntByKeyFluentHelper {
        private ODataQueryBuilder queryBuilder;
        private ErrorResultHandler<?> errorResultHandler;
        private List<Object> values = new LinkedList<Object>();

        public DebitMemoReqPrcgElmntByKeyFluentHelper(String debitMemoRequest, String pricingProcedureStep, String pricingProcedureCounter) {
            this.values.add(debitMemoRequest);
            this.values.add(pricingProcedureStep);
            this.values.add(pricingProcedureCounter);
            this.queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_DEBIT_MEMO_REQUEST_SRV", (String)"A_DebitMemoReqPrcgElmnt");
            HashMap<String, Object> keys = new HashMap<String, Object>();
            keys.put("DebitMemoRequest", this.values.get(0));
            keys.put("PricingProcedureStep", this.values.get(1));
            keys.put("PricingProcedureCounter", this.values.get(2));
            this.queryBuilder.keys(keys);
        }

        @SafeVarargs
        public final DebitMemoReqPrcgElmntByKeyFluentHelper select(EntityField<?, DebitMemoReqPrcgElmnt> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.build();
        }

        public DebitMemoReqPrcgElmntByKeyFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public DebitMemoReqPrcgElmnt execute(ErpConfigContext erpConfigContext) throws ODataException {
            DebitMemoReqPrcgElmnt entity = (DebitMemoReqPrcgElmnt)this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).as(DebitMemoReqPrcgElmnt.class);
            entity.setErpConfigContext(erpConfigContext);
            return entity;
        }
    }

    public static class DebitMemoReqPrcgElmnt {
        @ElementName(value="DebitMemoRequest")
        private String debitMemoRequest;
        public static EntityField<String, DebitMemoReqPrcgElmnt> DEBIT_MEMO_REQUEST = new EntityField("DebitMemoRequest");
        @ElementName(value="ConditionCurrency")
        private String conditionCurrency;
        public static EntityField<String, DebitMemoReqPrcgElmnt> CONDITION_CURRENCY = new EntityField("ConditionCurrency");
        @ElementName(value="ConditionQuantity")
        private BigDecimal conditionQuantity;
        public static EntityField<BigDecimal, DebitMemoReqPrcgElmnt> CONDITION_QUANTITY = new EntityField("ConditionQuantity");
        @ElementName(value="ConditionQuantityUnit")
        private String conditionQuantityUnit;
        public static EntityField<String, DebitMemoReqPrcgElmnt> CONDITION_QUANTITY_UNIT = new EntityField("ConditionQuantityUnit");
        @ElementName(value="ConditionToBaseQtyNmrtr")
        private BigDecimal conditionToBaseQtyNmrtr;
        public static EntityField<BigDecimal, DebitMemoReqPrcgElmnt> CONDITION_TO_BASE_QTY_NMRTR = new EntityField("ConditionToBaseQtyNmrtr");
        @ElementName(value="ConditionToBaseQtyDnmntr")
        private BigDecimal conditionToBaseQtyDnmntr;
        public static EntityField<BigDecimal, DebitMemoReqPrcgElmnt> CONDITION_TO_BASE_QTY_DNMNTR = new EntityField("ConditionToBaseQtyDnmntr");
        @ElementName(value="ConditionCategory")
        private String conditionCategory;
        public static EntityField<String, DebitMemoReqPrcgElmnt> CONDITION_CATEGORY = new EntityField("ConditionCategory");
        @ElementName(value="ConditionIsForStatistics")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean conditionIsForStatistics;
        public static EntityField<Boolean, DebitMemoReqPrcgElmnt> CONDITION_IS_FOR_STATISTICS = new EntityField("ConditionIsForStatistics");
        @ElementName(value="PricingScaleType")
        private String pricingScaleType;
        public static EntityField<String, DebitMemoReqPrcgElmnt> PRICING_SCALE_TYPE = new EntityField("PricingScaleType");
        @ElementName(value="IsRelevantForAccrual")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean isRelevantForAccrual;
        public static EntityField<Boolean, DebitMemoReqPrcgElmnt> IS_RELEVANT_FOR_ACCRUAL = new EntityField("IsRelevantForAccrual");
        @ElementName(value="CndnIsRelevantForInvoiceList")
        private String cndnIsRelevantForInvoiceList;
        public static EntityField<String, DebitMemoReqPrcgElmnt> CNDN_IS_RELEVANT_FOR_INVOICE_LIST = new EntityField("CndnIsRelevantForInvoiceList");
        @ElementName(value="PricingProcedureStep")
        private String pricingProcedureStep;
        public static EntityField<String, DebitMemoReqPrcgElmnt> PRICING_PROCEDURE_STEP = new EntityField("PricingProcedureStep");
        @ElementName(value="ConditionOrigin")
        private String conditionOrigin;
        public static EntityField<String, DebitMemoReqPrcgElmnt> CONDITION_ORIGIN = new EntityField("ConditionOrigin");
        @ElementName(value="IsGroupCondition")
        private String isGroupCondition;
        public static EntityField<String, DebitMemoReqPrcgElmnt> IS_GROUP_CONDITION = new EntityField("IsGroupCondition");
        @ElementName(value="AccessNumberOfAccessSequence")
        private String accessNumberOfAccessSequence;
        public static EntityField<String, DebitMemoReqPrcgElmnt> ACCESS_NUMBER_OF_ACCESS_SEQUENCE = new EntityField("AccessNumberOfAccessSequence");
        @ElementName(value="ConditionRecord")
        private String conditionRecord;
        public static EntityField<String, DebitMemoReqPrcgElmnt> CONDITION_RECORD = new EntityField("ConditionRecord");
        @ElementName(value="ConditionSequentialNumber")
        private String conditionSequentialNumber;
        public static EntityField<String, DebitMemoReqPrcgElmnt> CONDITION_SEQUENTIAL_NUMBER = new EntityField("ConditionSequentialNumber");
        @ElementName(value="TaxCode")
        private String taxCode;
        public static EntityField<String, DebitMemoReqPrcgElmnt> TAX_CODE = new EntityField("TaxCode");
        @ElementName(value="WithholdingTaxCode")
        private String withholdingTaxCode;
        public static EntityField<String, DebitMemoReqPrcgElmnt> WITHHOLDING_TAX_CODE = new EntityField("WithholdingTaxCode");
        @ElementName(value="CndnRoundingOffDiffAmount")
        private BigDecimal cndnRoundingOffDiffAmount;
        public static EntityField<BigDecimal, DebitMemoReqPrcgElmnt> CNDN_ROUNDING_OFF_DIFF_AMOUNT = new EntityField("CndnRoundingOffDiffAmount");
        @ElementName(value="ConditionAmount")
        private BigDecimal conditionAmount;
        public static EntityField<BigDecimal, DebitMemoReqPrcgElmnt> CONDITION_AMOUNT = new EntityField("ConditionAmount");
        @ElementName(value="TransactionCurrency")
        private String transactionCurrency;
        public static EntityField<String, DebitMemoReqPrcgElmnt> TRANSACTION_CURRENCY = new EntityField("TransactionCurrency");
        @ElementName(value="PricingProcedureCounter")
        private String pricingProcedureCounter;
        public static EntityField<String, DebitMemoReqPrcgElmnt> PRICING_PROCEDURE_COUNTER = new EntityField("PricingProcedureCounter");
        @ElementName(value="ConditionControl")
        private String conditionControl;
        public static EntityField<String, DebitMemoReqPrcgElmnt> CONDITION_CONTROL = new EntityField("ConditionControl");
        @ElementName(value="ConditionInactiveReason")
        private String conditionInactiveReason;
        public static EntityField<String, DebitMemoReqPrcgElmnt> CONDITION_INACTIVE_REASON = new EntityField("ConditionInactiveReason");
        @ElementName(value="ConditionClass")
        private String conditionClass;
        public static EntityField<String, DebitMemoReqPrcgElmnt> CONDITION_CLASS = new EntityField("ConditionClass");
        @ElementName(value="PrcgProcedureCounterForHeader")
        private String prcgProcedureCounterForHeader;
        public static EntityField<String, DebitMemoReqPrcgElmnt> PRCG_PROCEDURE_COUNTER_FOR_HEADER = new EntityField("PrcgProcedureCounterForHeader");
        @ElementName(value="FactorForConditionBasisValue")
        private Double factorForConditionBasisValue;
        public static EntityField<Double, DebitMemoReqPrcgElmnt> FACTOR_FOR_CONDITION_BASIS_VALUE = new EntityField("FactorForConditionBasisValue");
        @ElementName(value="StructureCondition")
        private String structureCondition;
        public static EntityField<String, DebitMemoReqPrcgElmnt> STRUCTURE_CONDITION = new EntityField("StructureCondition");
        @ElementName(value="PeriodFactorForCndnBasisValue")
        private Double periodFactorForCndnBasisValue;
        public static EntityField<Double, DebitMemoReqPrcgElmnt> PERIOD_FACTOR_FOR_CNDN_BASIS_VALUE = new EntityField("PeriodFactorForCndnBasisValue");
        @ElementName(value="PricingScaleBasis")
        private String pricingScaleBasis;
        public static EntityField<String, DebitMemoReqPrcgElmnt> PRICING_SCALE_BASIS = new EntityField("PricingScaleBasis");
        @ElementName(value="ConditionScaleBasisValue")
        private BigDecimal conditionScaleBasisValue;
        public static EntityField<BigDecimal, DebitMemoReqPrcgElmnt> CONDITION_SCALE_BASIS_VALUE = new EntityField("ConditionScaleBasisValue");
        @ElementName(value="ConditionScaleBasisUnit")
        private String conditionScaleBasisUnit;
        public static EntityField<String, DebitMemoReqPrcgElmnt> CONDITION_SCALE_BASIS_UNIT = new EntityField("ConditionScaleBasisUnit");
        @ElementName(value="ConditionApplication")
        private String conditionApplication;
        public static EntityField<String, DebitMemoReqPrcgElmnt> CONDITION_APPLICATION = new EntityField("ConditionApplication");
        @ElementName(value="ConditionScaleBasisCurrency")
        private String conditionScaleBasisCurrency;
        public static EntityField<String, DebitMemoReqPrcgElmnt> CONDITION_SCALE_BASIS_CURRENCY = new EntityField("ConditionScaleBasisCurrency");
        @ElementName(value="ConditionAlternativeCurrency")
        private String conditionAlternativeCurrency;
        public static EntityField<String, DebitMemoReqPrcgElmnt> CONDITION_ALTERNATIVE_CURRENCY = new EntityField("ConditionAlternativeCurrency");
        @ElementName(value="ConditionAmountInLocalCrcy")
        private BigDecimal conditionAmountInLocalCrcy;
        public static EntityField<BigDecimal, DebitMemoReqPrcgElmnt> CONDITION_AMOUNT_IN_LOCAL_CRCY = new EntityField("ConditionAmountInLocalCrcy");
        @ElementName(value="CndnIsRelevantForIntcoBilling")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean cndnIsRelevantForIntcoBilling;
        public static EntityField<Boolean, DebitMemoReqPrcgElmnt> CNDN_IS_RELEVANT_FOR_INTCO_BILLING = new EntityField("CndnIsRelevantForIntcoBilling");
        @ElementName(value="ConditionIsManuallyChanged")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean conditionIsManuallyChanged;
        public static EntityField<Boolean, DebitMemoReqPrcgElmnt> CONDITION_IS_MANUALLY_CHANGED = new EntityField("ConditionIsManuallyChanged");
        @ElementName(value="CumulatedConditionBasisValue")
        private BigDecimal cumulatedConditionBasisValue;
        public static EntityField<BigDecimal, DebitMemoReqPrcgElmnt> CUMULATED_CONDITION_BASIS_VALUE = new EntityField("CumulatedConditionBasisValue");
        @ElementName(value="ConditionIsForConfiguration")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean conditionIsForConfiguration;
        public static EntityField<Boolean, DebitMemoReqPrcgElmnt> CONDITION_IS_FOR_CONFIGURATION = new EntityField("ConditionIsForConfiguration");
        @ElementName(value="VariantCondition")
        private String variantCondition;
        public static EntityField<String, DebitMemoReqPrcgElmnt> VARIANT_CONDITION = new EntityField("VariantCondition");
        @ElementName(value="ConditionType")
        private String conditionType;
        public static EntityField<String, DebitMemoReqPrcgElmnt> CONDITION_TYPE = new EntityField("ConditionType");
        @ElementName(value="PricingDateTime")
        private String pricingDateTime;
        public static EntityField<String, DebitMemoReqPrcgElmnt> PRICING_DATE_TIME = new EntityField("PricingDateTime");
        @ElementName(value="ConditionCalculationType")
        private String conditionCalculationType;
        public static EntityField<String, DebitMemoReqPrcgElmnt> CONDITION_CALCULATION_TYPE = new EntityField("ConditionCalculationType");
        @ElementName(value="ConditionBaseValue")
        private BigDecimal conditionBaseValue;
        public static EntityField<BigDecimal, DebitMemoReqPrcgElmnt> CONDITION_BASE_VALUE = new EntityField("ConditionBaseValue");
        @ElementName(value="ConditionRateValue")
        private BigDecimal conditionRateValue;
        public static EntityField<BigDecimal, DebitMemoReqPrcgElmnt> CONDITION_RATE_VALUE = new EntityField("ConditionRateValue");
        private static final transient String ODATA_ENDPOINT_URL = "/sap/opu/odata/sap/API_DEBIT_MEMO_REQUEST_SRV";
        private static final transient String ODATA_ENTITY_COLLECTION = "A_DebitMemoReqPrcgElmnt";
        private transient ErpConfigContext erpConfigContext;

        @JsonIgnore
        public DebitMemoRequest fetchDebitMemoRequest() throws ODataException {
            StringBuilder odataResourceUrl = new StringBuilder(ODATA_ENTITY_COLLECTION);
            odataResourceUrl.append("(");
            odataResourceUrl.append("DebitMemoRequest=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.debitMemoRequest));
            odataResourceUrl.append(",PricingProcedureStep=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.pricingProcedureStep));
            odataResourceUrl.append(",PricingProcedureCounter=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.pricingProcedureCounter));
            odataResourceUrl.append(")/");
            odataResourceUrl.append("to_DebitMemoRequest");
            ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)ODATA_ENDPOINT_URL, (String)odataResourceUrl.toString());
            ODataQuery query = builder.build();
            ErpEndpoint erpEndpoint = new ErpEndpoint(this.erpConfigContext);
            ODataQueryResult result = query.execute((WithDestinationName)erpEndpoint);
            DebitMemoRequest entityList = (DebitMemoRequest)result.as(DebitMemoRequest.class);
            entityList.setErpConfigContext(this.erpConfigContext);
            return entityList;
        }

        public String toString() {
            return "ReadDebitMemoRequestsNamespace.DebitMemoReqPrcgElmnt(debitMemoRequest=" + this.debitMemoRequest + ", conditionCurrency=" + this.conditionCurrency + ", conditionQuantity=" + this.conditionQuantity + ", conditionQuantityUnit=" + this.conditionQuantityUnit + ", conditionToBaseQtyNmrtr=" + this.conditionToBaseQtyNmrtr + ", conditionToBaseQtyDnmntr=" + this.conditionToBaseQtyDnmntr + ", conditionCategory=" + this.conditionCategory + ", conditionIsForStatistics=" + this.conditionIsForStatistics + ", pricingScaleType=" + this.pricingScaleType + ", isRelevantForAccrual=" + this.isRelevantForAccrual + ", cndnIsRelevantForInvoiceList=" + this.cndnIsRelevantForInvoiceList + ", pricingProcedureStep=" + this.pricingProcedureStep + ", conditionOrigin=" + this.conditionOrigin + ", isGroupCondition=" + this.isGroupCondition + ", accessNumberOfAccessSequence=" + this.accessNumberOfAccessSequence + ", conditionRecord=" + this.conditionRecord + ", conditionSequentialNumber=" + this.conditionSequentialNumber + ", taxCode=" + this.taxCode + ", withholdingTaxCode=" + this.withholdingTaxCode + ", cndnRoundingOffDiffAmount=" + this.cndnRoundingOffDiffAmount + ", conditionAmount=" + this.conditionAmount + ", transactionCurrency=" + this.transactionCurrency + ", pricingProcedureCounter=" + this.pricingProcedureCounter + ", conditionControl=" + this.conditionControl + ", conditionInactiveReason=" + this.conditionInactiveReason + ", conditionClass=" + this.conditionClass + ", prcgProcedureCounterForHeader=" + this.prcgProcedureCounterForHeader + ", factorForConditionBasisValue=" + this.factorForConditionBasisValue + ", structureCondition=" + this.structureCondition + ", periodFactorForCndnBasisValue=" + this.periodFactorForCndnBasisValue + ", pricingScaleBasis=" + this.pricingScaleBasis + ", conditionScaleBasisValue=" + this.conditionScaleBasisValue + ", conditionScaleBasisUnit=" + this.conditionScaleBasisUnit + ", conditionApplication=" + this.conditionApplication + ", conditionScaleBasisCurrency=" + this.conditionScaleBasisCurrency + ", conditionAlternativeCurrency=" + this.conditionAlternativeCurrency + ", conditionAmountInLocalCrcy=" + this.conditionAmountInLocalCrcy + ", cndnIsRelevantForIntcoBilling=" + this.cndnIsRelevantForIntcoBilling + ", conditionIsManuallyChanged=" + this.conditionIsManuallyChanged + ", cumulatedConditionBasisValue=" + this.cumulatedConditionBasisValue + ", conditionIsForConfiguration=" + this.conditionIsForConfiguration + ", variantCondition=" + this.variantCondition + ", conditionType=" + this.conditionType + ", pricingDateTime=" + this.pricingDateTime + ", conditionCalculationType=" + this.conditionCalculationType + ", conditionBaseValue=" + this.conditionBaseValue + ", conditionRateValue=" + this.conditionRateValue + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DebitMemoReqPrcgElmnt)) {
                return false;
            }
            DebitMemoReqPrcgElmnt other = (DebitMemoReqPrcgElmnt)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$debitMemoRequest = this.debitMemoRequest;
            String other$debitMemoRequest = other.debitMemoRequest;
            if (this$debitMemoRequest == null ? other$debitMemoRequest != null : !this$debitMemoRequest.equals(other$debitMemoRequest)) {
                return false;
            }
            String this$conditionCurrency = this.conditionCurrency;
            String other$conditionCurrency = other.conditionCurrency;
            if (this$conditionCurrency == null ? other$conditionCurrency != null : !this$conditionCurrency.equals(other$conditionCurrency)) {
                return false;
            }
            BigDecimal this$conditionQuantity = this.conditionQuantity;
            BigDecimal other$conditionQuantity = other.conditionQuantity;
            if (this$conditionQuantity == null ? other$conditionQuantity != null : !((Object)this$conditionQuantity).equals(other$conditionQuantity)) {
                return false;
            }
            String this$conditionQuantityUnit = this.conditionQuantityUnit;
            String other$conditionQuantityUnit = other.conditionQuantityUnit;
            if (this$conditionQuantityUnit == null ? other$conditionQuantityUnit != null : !this$conditionQuantityUnit.equals(other$conditionQuantityUnit)) {
                return false;
            }
            BigDecimal this$conditionToBaseQtyNmrtr = this.conditionToBaseQtyNmrtr;
            BigDecimal other$conditionToBaseQtyNmrtr = other.conditionToBaseQtyNmrtr;
            if (this$conditionToBaseQtyNmrtr == null ? other$conditionToBaseQtyNmrtr != null : !((Object)this$conditionToBaseQtyNmrtr).equals(other$conditionToBaseQtyNmrtr)) {
                return false;
            }
            BigDecimal this$conditionToBaseQtyDnmntr = this.conditionToBaseQtyDnmntr;
            BigDecimal other$conditionToBaseQtyDnmntr = other.conditionToBaseQtyDnmntr;
            if (this$conditionToBaseQtyDnmntr == null ? other$conditionToBaseQtyDnmntr != null : !((Object)this$conditionToBaseQtyDnmntr).equals(other$conditionToBaseQtyDnmntr)) {
                return false;
            }
            String this$conditionCategory = this.conditionCategory;
            String other$conditionCategory = other.conditionCategory;
            if (this$conditionCategory == null ? other$conditionCategory != null : !this$conditionCategory.equals(other$conditionCategory)) {
                return false;
            }
            Boolean this$conditionIsForStatistics = this.conditionIsForStatistics;
            Boolean other$conditionIsForStatistics = other.conditionIsForStatistics;
            if (this$conditionIsForStatistics == null ? other$conditionIsForStatistics != null : !((Object)this$conditionIsForStatistics).equals(other$conditionIsForStatistics)) {
                return false;
            }
            String this$pricingScaleType = this.pricingScaleType;
            String other$pricingScaleType = other.pricingScaleType;
            if (this$pricingScaleType == null ? other$pricingScaleType != null : !this$pricingScaleType.equals(other$pricingScaleType)) {
                return false;
            }
            Boolean this$isRelevantForAccrual = this.isRelevantForAccrual;
            Boolean other$isRelevantForAccrual = other.isRelevantForAccrual;
            if (this$isRelevantForAccrual == null ? other$isRelevantForAccrual != null : !((Object)this$isRelevantForAccrual).equals(other$isRelevantForAccrual)) {
                return false;
            }
            String this$cndnIsRelevantForInvoiceList = this.cndnIsRelevantForInvoiceList;
            String other$cndnIsRelevantForInvoiceList = other.cndnIsRelevantForInvoiceList;
            if (this$cndnIsRelevantForInvoiceList == null ? other$cndnIsRelevantForInvoiceList != null : !this$cndnIsRelevantForInvoiceList.equals(other$cndnIsRelevantForInvoiceList)) {
                return false;
            }
            String this$pricingProcedureStep = this.pricingProcedureStep;
            String other$pricingProcedureStep = other.pricingProcedureStep;
            if (this$pricingProcedureStep == null ? other$pricingProcedureStep != null : !this$pricingProcedureStep.equals(other$pricingProcedureStep)) {
                return false;
            }
            String this$conditionOrigin = this.conditionOrigin;
            String other$conditionOrigin = other.conditionOrigin;
            if (this$conditionOrigin == null ? other$conditionOrigin != null : !this$conditionOrigin.equals(other$conditionOrigin)) {
                return false;
            }
            String this$isGroupCondition = this.isGroupCondition;
            String other$isGroupCondition = other.isGroupCondition;
            if (this$isGroupCondition == null ? other$isGroupCondition != null : !this$isGroupCondition.equals(other$isGroupCondition)) {
                return false;
            }
            String this$accessNumberOfAccessSequence = this.accessNumberOfAccessSequence;
            String other$accessNumberOfAccessSequence = other.accessNumberOfAccessSequence;
            if (this$accessNumberOfAccessSequence == null ? other$accessNumberOfAccessSequence != null : !this$accessNumberOfAccessSequence.equals(other$accessNumberOfAccessSequence)) {
                return false;
            }
            String this$conditionRecord = this.conditionRecord;
            String other$conditionRecord = other.conditionRecord;
            if (this$conditionRecord == null ? other$conditionRecord != null : !this$conditionRecord.equals(other$conditionRecord)) {
                return false;
            }
            String this$conditionSequentialNumber = this.conditionSequentialNumber;
            String other$conditionSequentialNumber = other.conditionSequentialNumber;
            if (this$conditionSequentialNumber == null ? other$conditionSequentialNumber != null : !this$conditionSequentialNumber.equals(other$conditionSequentialNumber)) {
                return false;
            }
            String this$taxCode = this.taxCode;
            String other$taxCode = other.taxCode;
            if (this$taxCode == null ? other$taxCode != null : !this$taxCode.equals(other$taxCode)) {
                return false;
            }
            String this$withholdingTaxCode = this.withholdingTaxCode;
            String other$withholdingTaxCode = other.withholdingTaxCode;
            if (this$withholdingTaxCode == null ? other$withholdingTaxCode != null : !this$withholdingTaxCode.equals(other$withholdingTaxCode)) {
                return false;
            }
            BigDecimal this$cndnRoundingOffDiffAmount = this.cndnRoundingOffDiffAmount;
            BigDecimal other$cndnRoundingOffDiffAmount = other.cndnRoundingOffDiffAmount;
            if (this$cndnRoundingOffDiffAmount == null ? other$cndnRoundingOffDiffAmount != null : !((Object)this$cndnRoundingOffDiffAmount).equals(other$cndnRoundingOffDiffAmount)) {
                return false;
            }
            BigDecimal this$conditionAmount = this.conditionAmount;
            BigDecimal other$conditionAmount = other.conditionAmount;
            if (this$conditionAmount == null ? other$conditionAmount != null : !((Object)this$conditionAmount).equals(other$conditionAmount)) {
                return false;
            }
            String this$transactionCurrency = this.transactionCurrency;
            String other$transactionCurrency = other.transactionCurrency;
            if (this$transactionCurrency == null ? other$transactionCurrency != null : !this$transactionCurrency.equals(other$transactionCurrency)) {
                return false;
            }
            String this$pricingProcedureCounter = this.pricingProcedureCounter;
            String other$pricingProcedureCounter = other.pricingProcedureCounter;
            if (this$pricingProcedureCounter == null ? other$pricingProcedureCounter != null : !this$pricingProcedureCounter.equals(other$pricingProcedureCounter)) {
                return false;
            }
            String this$conditionControl = this.conditionControl;
            String other$conditionControl = other.conditionControl;
            if (this$conditionControl == null ? other$conditionControl != null : !this$conditionControl.equals(other$conditionControl)) {
                return false;
            }
            String this$conditionInactiveReason = this.conditionInactiveReason;
            String other$conditionInactiveReason = other.conditionInactiveReason;
            if (this$conditionInactiveReason == null ? other$conditionInactiveReason != null : !this$conditionInactiveReason.equals(other$conditionInactiveReason)) {
                return false;
            }
            String this$conditionClass = this.conditionClass;
            String other$conditionClass = other.conditionClass;
            if (this$conditionClass == null ? other$conditionClass != null : !this$conditionClass.equals(other$conditionClass)) {
                return false;
            }
            String this$prcgProcedureCounterForHeader = this.prcgProcedureCounterForHeader;
            String other$prcgProcedureCounterForHeader = other.prcgProcedureCounterForHeader;
            if (this$prcgProcedureCounterForHeader == null ? other$prcgProcedureCounterForHeader != null : !this$prcgProcedureCounterForHeader.equals(other$prcgProcedureCounterForHeader)) {
                return false;
            }
            Double this$factorForConditionBasisValue = this.factorForConditionBasisValue;
            Double other$factorForConditionBasisValue = other.factorForConditionBasisValue;
            if (this$factorForConditionBasisValue == null ? other$factorForConditionBasisValue != null : !((Object)this$factorForConditionBasisValue).equals(other$factorForConditionBasisValue)) {
                return false;
            }
            String this$structureCondition = this.structureCondition;
            String other$structureCondition = other.structureCondition;
            if (this$structureCondition == null ? other$structureCondition != null : !this$structureCondition.equals(other$structureCondition)) {
                return false;
            }
            Double this$periodFactorForCndnBasisValue = this.periodFactorForCndnBasisValue;
            Double other$periodFactorForCndnBasisValue = other.periodFactorForCndnBasisValue;
            if (this$periodFactorForCndnBasisValue == null ? other$periodFactorForCndnBasisValue != null : !((Object)this$periodFactorForCndnBasisValue).equals(other$periodFactorForCndnBasisValue)) {
                return false;
            }
            String this$pricingScaleBasis = this.pricingScaleBasis;
            String other$pricingScaleBasis = other.pricingScaleBasis;
            if (this$pricingScaleBasis == null ? other$pricingScaleBasis != null : !this$pricingScaleBasis.equals(other$pricingScaleBasis)) {
                return false;
            }
            BigDecimal this$conditionScaleBasisValue = this.conditionScaleBasisValue;
            BigDecimal other$conditionScaleBasisValue = other.conditionScaleBasisValue;
            if (this$conditionScaleBasisValue == null ? other$conditionScaleBasisValue != null : !((Object)this$conditionScaleBasisValue).equals(other$conditionScaleBasisValue)) {
                return false;
            }
            String this$conditionScaleBasisUnit = this.conditionScaleBasisUnit;
            String other$conditionScaleBasisUnit = other.conditionScaleBasisUnit;
            if (this$conditionScaleBasisUnit == null ? other$conditionScaleBasisUnit != null : !this$conditionScaleBasisUnit.equals(other$conditionScaleBasisUnit)) {
                return false;
            }
            String this$conditionApplication = this.conditionApplication;
            String other$conditionApplication = other.conditionApplication;
            if (this$conditionApplication == null ? other$conditionApplication != null : !this$conditionApplication.equals(other$conditionApplication)) {
                return false;
            }
            String this$conditionScaleBasisCurrency = this.conditionScaleBasisCurrency;
            String other$conditionScaleBasisCurrency = other.conditionScaleBasisCurrency;
            if (this$conditionScaleBasisCurrency == null ? other$conditionScaleBasisCurrency != null : !this$conditionScaleBasisCurrency.equals(other$conditionScaleBasisCurrency)) {
                return false;
            }
            String this$conditionAlternativeCurrency = this.conditionAlternativeCurrency;
            String other$conditionAlternativeCurrency = other.conditionAlternativeCurrency;
            if (this$conditionAlternativeCurrency == null ? other$conditionAlternativeCurrency != null : !this$conditionAlternativeCurrency.equals(other$conditionAlternativeCurrency)) {
                return false;
            }
            BigDecimal this$conditionAmountInLocalCrcy = this.conditionAmountInLocalCrcy;
            BigDecimal other$conditionAmountInLocalCrcy = other.conditionAmountInLocalCrcy;
            if (this$conditionAmountInLocalCrcy == null ? other$conditionAmountInLocalCrcy != null : !((Object)this$conditionAmountInLocalCrcy).equals(other$conditionAmountInLocalCrcy)) {
                return false;
            }
            Boolean this$cndnIsRelevantForIntcoBilling = this.cndnIsRelevantForIntcoBilling;
            Boolean other$cndnIsRelevantForIntcoBilling = other.cndnIsRelevantForIntcoBilling;
            if (this$cndnIsRelevantForIntcoBilling == null ? other$cndnIsRelevantForIntcoBilling != null : !((Object)this$cndnIsRelevantForIntcoBilling).equals(other$cndnIsRelevantForIntcoBilling)) {
                return false;
            }
            Boolean this$conditionIsManuallyChanged = this.conditionIsManuallyChanged;
            Boolean other$conditionIsManuallyChanged = other.conditionIsManuallyChanged;
            if (this$conditionIsManuallyChanged == null ? other$conditionIsManuallyChanged != null : !((Object)this$conditionIsManuallyChanged).equals(other$conditionIsManuallyChanged)) {
                return false;
            }
            BigDecimal this$cumulatedConditionBasisValue = this.cumulatedConditionBasisValue;
            BigDecimal other$cumulatedConditionBasisValue = other.cumulatedConditionBasisValue;
            if (this$cumulatedConditionBasisValue == null ? other$cumulatedConditionBasisValue != null : !((Object)this$cumulatedConditionBasisValue).equals(other$cumulatedConditionBasisValue)) {
                return false;
            }
            Boolean this$conditionIsForConfiguration = this.conditionIsForConfiguration;
            Boolean other$conditionIsForConfiguration = other.conditionIsForConfiguration;
            if (this$conditionIsForConfiguration == null ? other$conditionIsForConfiguration != null : !((Object)this$conditionIsForConfiguration).equals(other$conditionIsForConfiguration)) {
                return false;
            }
            String this$variantCondition = this.variantCondition;
            String other$variantCondition = other.variantCondition;
            if (this$variantCondition == null ? other$variantCondition != null : !this$variantCondition.equals(other$variantCondition)) {
                return false;
            }
            String this$conditionType = this.conditionType;
            String other$conditionType = other.conditionType;
            if (this$conditionType == null ? other$conditionType != null : !this$conditionType.equals(other$conditionType)) {
                return false;
            }
            String this$pricingDateTime = this.pricingDateTime;
            String other$pricingDateTime = other.pricingDateTime;
            if (this$pricingDateTime == null ? other$pricingDateTime != null : !this$pricingDateTime.equals(other$pricingDateTime)) {
                return false;
            }
            String this$conditionCalculationType = this.conditionCalculationType;
            String other$conditionCalculationType = other.conditionCalculationType;
            if (this$conditionCalculationType == null ? other$conditionCalculationType != null : !this$conditionCalculationType.equals(other$conditionCalculationType)) {
                return false;
            }
            BigDecimal this$conditionBaseValue = this.conditionBaseValue;
            BigDecimal other$conditionBaseValue = other.conditionBaseValue;
            if (this$conditionBaseValue == null ? other$conditionBaseValue != null : !((Object)this$conditionBaseValue).equals(other$conditionBaseValue)) {
                return false;
            }
            BigDecimal this$conditionRateValue = this.conditionRateValue;
            BigDecimal other$conditionRateValue = other.conditionRateValue;
            return !(this$conditionRateValue == null ? other$conditionRateValue != null : !((Object)this$conditionRateValue).equals(other$conditionRateValue));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DebitMemoReqPrcgElmnt;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $debitMemoRequest = this.debitMemoRequest;
            result = result * 59 + ($debitMemoRequest == null ? 43 : $debitMemoRequest.hashCode());
            String $conditionCurrency = this.conditionCurrency;
            result = result * 59 + ($conditionCurrency == null ? 43 : $conditionCurrency.hashCode());
            BigDecimal $conditionQuantity = this.conditionQuantity;
            result = result * 59 + ($conditionQuantity == null ? 43 : ((Object)$conditionQuantity).hashCode());
            String $conditionQuantityUnit = this.conditionQuantityUnit;
            result = result * 59 + ($conditionQuantityUnit == null ? 43 : $conditionQuantityUnit.hashCode());
            BigDecimal $conditionToBaseQtyNmrtr = this.conditionToBaseQtyNmrtr;
            result = result * 59 + ($conditionToBaseQtyNmrtr == null ? 43 : ((Object)$conditionToBaseQtyNmrtr).hashCode());
            BigDecimal $conditionToBaseQtyDnmntr = this.conditionToBaseQtyDnmntr;
            result = result * 59 + ($conditionToBaseQtyDnmntr == null ? 43 : ((Object)$conditionToBaseQtyDnmntr).hashCode());
            String $conditionCategory = this.conditionCategory;
            result = result * 59 + ($conditionCategory == null ? 43 : $conditionCategory.hashCode());
            Boolean $conditionIsForStatistics = this.conditionIsForStatistics;
            result = result * 59 + ($conditionIsForStatistics == null ? 43 : ((Object)$conditionIsForStatistics).hashCode());
            String $pricingScaleType = this.pricingScaleType;
            result = result * 59 + ($pricingScaleType == null ? 43 : $pricingScaleType.hashCode());
            Boolean $isRelevantForAccrual = this.isRelevantForAccrual;
            result = result * 59 + ($isRelevantForAccrual == null ? 43 : ((Object)$isRelevantForAccrual).hashCode());
            String $cndnIsRelevantForInvoiceList = this.cndnIsRelevantForInvoiceList;
            result = result * 59 + ($cndnIsRelevantForInvoiceList == null ? 43 : $cndnIsRelevantForInvoiceList.hashCode());
            String $pricingProcedureStep = this.pricingProcedureStep;
            result = result * 59 + ($pricingProcedureStep == null ? 43 : $pricingProcedureStep.hashCode());
            String $conditionOrigin = this.conditionOrigin;
            result = result * 59 + ($conditionOrigin == null ? 43 : $conditionOrigin.hashCode());
            String $isGroupCondition = this.isGroupCondition;
            result = result * 59 + ($isGroupCondition == null ? 43 : $isGroupCondition.hashCode());
            String $accessNumberOfAccessSequence = this.accessNumberOfAccessSequence;
            result = result * 59 + ($accessNumberOfAccessSequence == null ? 43 : $accessNumberOfAccessSequence.hashCode());
            String $conditionRecord = this.conditionRecord;
            result = result * 59 + ($conditionRecord == null ? 43 : $conditionRecord.hashCode());
            String $conditionSequentialNumber = this.conditionSequentialNumber;
            result = result * 59 + ($conditionSequentialNumber == null ? 43 : $conditionSequentialNumber.hashCode());
            String $taxCode = this.taxCode;
            result = result * 59 + ($taxCode == null ? 43 : $taxCode.hashCode());
            String $withholdingTaxCode = this.withholdingTaxCode;
            result = result * 59 + ($withholdingTaxCode == null ? 43 : $withholdingTaxCode.hashCode());
            BigDecimal $cndnRoundingOffDiffAmount = this.cndnRoundingOffDiffAmount;
            result = result * 59 + ($cndnRoundingOffDiffAmount == null ? 43 : ((Object)$cndnRoundingOffDiffAmount).hashCode());
            BigDecimal $conditionAmount = this.conditionAmount;
            result = result * 59 + ($conditionAmount == null ? 43 : ((Object)$conditionAmount).hashCode());
            String $transactionCurrency = this.transactionCurrency;
            result = result * 59 + ($transactionCurrency == null ? 43 : $transactionCurrency.hashCode());
            String $pricingProcedureCounter = this.pricingProcedureCounter;
            result = result * 59 + ($pricingProcedureCounter == null ? 43 : $pricingProcedureCounter.hashCode());
            String $conditionControl = this.conditionControl;
            result = result * 59 + ($conditionControl == null ? 43 : $conditionControl.hashCode());
            String $conditionInactiveReason = this.conditionInactiveReason;
            result = result * 59 + ($conditionInactiveReason == null ? 43 : $conditionInactiveReason.hashCode());
            String $conditionClass = this.conditionClass;
            result = result * 59 + ($conditionClass == null ? 43 : $conditionClass.hashCode());
            String $prcgProcedureCounterForHeader = this.prcgProcedureCounterForHeader;
            result = result * 59 + ($prcgProcedureCounterForHeader == null ? 43 : $prcgProcedureCounterForHeader.hashCode());
            Double $factorForConditionBasisValue = this.factorForConditionBasisValue;
            result = result * 59 + ($factorForConditionBasisValue == null ? 43 : ((Object)$factorForConditionBasisValue).hashCode());
            String $structureCondition = this.structureCondition;
            result = result * 59 + ($structureCondition == null ? 43 : $structureCondition.hashCode());
            Double $periodFactorForCndnBasisValue = this.periodFactorForCndnBasisValue;
            result = result * 59 + ($periodFactorForCndnBasisValue == null ? 43 : ((Object)$periodFactorForCndnBasisValue).hashCode());
            String $pricingScaleBasis = this.pricingScaleBasis;
            result = result * 59 + ($pricingScaleBasis == null ? 43 : $pricingScaleBasis.hashCode());
            BigDecimal $conditionScaleBasisValue = this.conditionScaleBasisValue;
            result = result * 59 + ($conditionScaleBasisValue == null ? 43 : ((Object)$conditionScaleBasisValue).hashCode());
            String $conditionScaleBasisUnit = this.conditionScaleBasisUnit;
            result = result * 59 + ($conditionScaleBasisUnit == null ? 43 : $conditionScaleBasisUnit.hashCode());
            String $conditionApplication = this.conditionApplication;
            result = result * 59 + ($conditionApplication == null ? 43 : $conditionApplication.hashCode());
            String $conditionScaleBasisCurrency = this.conditionScaleBasisCurrency;
            result = result * 59 + ($conditionScaleBasisCurrency == null ? 43 : $conditionScaleBasisCurrency.hashCode());
            String $conditionAlternativeCurrency = this.conditionAlternativeCurrency;
            result = result * 59 + ($conditionAlternativeCurrency == null ? 43 : $conditionAlternativeCurrency.hashCode());
            BigDecimal $conditionAmountInLocalCrcy = this.conditionAmountInLocalCrcy;
            result = result * 59 + ($conditionAmountInLocalCrcy == null ? 43 : ((Object)$conditionAmountInLocalCrcy).hashCode());
            Boolean $cndnIsRelevantForIntcoBilling = this.cndnIsRelevantForIntcoBilling;
            result = result * 59 + ($cndnIsRelevantForIntcoBilling == null ? 43 : ((Object)$cndnIsRelevantForIntcoBilling).hashCode());
            Boolean $conditionIsManuallyChanged = this.conditionIsManuallyChanged;
            result = result * 59 + ($conditionIsManuallyChanged == null ? 43 : ((Object)$conditionIsManuallyChanged).hashCode());
            BigDecimal $cumulatedConditionBasisValue = this.cumulatedConditionBasisValue;
            result = result * 59 + ($cumulatedConditionBasisValue == null ? 43 : ((Object)$cumulatedConditionBasisValue).hashCode());
            Boolean $conditionIsForConfiguration = this.conditionIsForConfiguration;
            result = result * 59 + ($conditionIsForConfiguration == null ? 43 : ((Object)$conditionIsForConfiguration).hashCode());
            String $variantCondition = this.variantCondition;
            result = result * 59 + ($variantCondition == null ? 43 : $variantCondition.hashCode());
            String $conditionType = this.conditionType;
            result = result * 59 + ($conditionType == null ? 43 : $conditionType.hashCode());
            String $pricingDateTime = this.pricingDateTime;
            result = result * 59 + ($pricingDateTime == null ? 43 : $pricingDateTime.hashCode());
            String $conditionCalculationType = this.conditionCalculationType;
            result = result * 59 + ($conditionCalculationType == null ? 43 : $conditionCalculationType.hashCode());
            BigDecimal $conditionBaseValue = this.conditionBaseValue;
            result = result * 59 + ($conditionBaseValue == null ? 43 : ((Object)$conditionBaseValue).hashCode());
            BigDecimal $conditionRateValue = this.conditionRateValue;
            result = result * 59 + ($conditionRateValue == null ? 43 : ((Object)$conditionRateValue).hashCode());
            return result;
        }

        public String getDebitMemoRequest() {
            return this.debitMemoRequest;
        }

        public DebitMemoReqPrcgElmnt setDebitMemoRequest(String debitMemoRequest) {
            this.debitMemoRequest = debitMemoRequest;
            return this;
        }

        public String getConditionCurrency() {
            return this.conditionCurrency;
        }

        public DebitMemoReqPrcgElmnt setConditionCurrency(String conditionCurrency) {
            this.conditionCurrency = conditionCurrency;
            return this;
        }

        public BigDecimal getConditionQuantity() {
            return this.conditionQuantity;
        }

        public DebitMemoReqPrcgElmnt setConditionQuantity(BigDecimal conditionQuantity) {
            this.conditionQuantity = conditionQuantity;
            return this;
        }

        public String getConditionQuantityUnit() {
            return this.conditionQuantityUnit;
        }

        public DebitMemoReqPrcgElmnt setConditionQuantityUnit(String conditionQuantityUnit) {
            this.conditionQuantityUnit = conditionQuantityUnit;
            return this;
        }

        public BigDecimal getConditionToBaseQtyNmrtr() {
            return this.conditionToBaseQtyNmrtr;
        }

        public DebitMemoReqPrcgElmnt setConditionToBaseQtyNmrtr(BigDecimal conditionToBaseQtyNmrtr) {
            this.conditionToBaseQtyNmrtr = conditionToBaseQtyNmrtr;
            return this;
        }

        public BigDecimal getConditionToBaseQtyDnmntr() {
            return this.conditionToBaseQtyDnmntr;
        }

        public DebitMemoReqPrcgElmnt setConditionToBaseQtyDnmntr(BigDecimal conditionToBaseQtyDnmntr) {
            this.conditionToBaseQtyDnmntr = conditionToBaseQtyDnmntr;
            return this;
        }

        public String getConditionCategory() {
            return this.conditionCategory;
        }

        public DebitMemoReqPrcgElmnt setConditionCategory(String conditionCategory) {
            this.conditionCategory = conditionCategory;
            return this;
        }

        public Boolean getConditionIsForStatistics() {
            return this.conditionIsForStatistics;
        }

        public DebitMemoReqPrcgElmnt setConditionIsForStatistics(Boolean conditionIsForStatistics) {
            this.conditionIsForStatistics = conditionIsForStatistics;
            return this;
        }

        public String getPricingScaleType() {
            return this.pricingScaleType;
        }

        public DebitMemoReqPrcgElmnt setPricingScaleType(String pricingScaleType) {
            this.pricingScaleType = pricingScaleType;
            return this;
        }

        public Boolean getIsRelevantForAccrual() {
            return this.isRelevantForAccrual;
        }

        public DebitMemoReqPrcgElmnt setIsRelevantForAccrual(Boolean isRelevantForAccrual) {
            this.isRelevantForAccrual = isRelevantForAccrual;
            return this;
        }

        public String getCndnIsRelevantForInvoiceList() {
            return this.cndnIsRelevantForInvoiceList;
        }

        public DebitMemoReqPrcgElmnt setCndnIsRelevantForInvoiceList(String cndnIsRelevantForInvoiceList) {
            this.cndnIsRelevantForInvoiceList = cndnIsRelevantForInvoiceList;
            return this;
        }

        public String getPricingProcedureStep() {
            return this.pricingProcedureStep;
        }

        public DebitMemoReqPrcgElmnt setPricingProcedureStep(String pricingProcedureStep) {
            this.pricingProcedureStep = pricingProcedureStep;
            return this;
        }

        public String getConditionOrigin() {
            return this.conditionOrigin;
        }

        public DebitMemoReqPrcgElmnt setConditionOrigin(String conditionOrigin) {
            this.conditionOrigin = conditionOrigin;
            return this;
        }

        public String getIsGroupCondition() {
            return this.isGroupCondition;
        }

        public DebitMemoReqPrcgElmnt setIsGroupCondition(String isGroupCondition) {
            this.isGroupCondition = isGroupCondition;
            return this;
        }

        public String getAccessNumberOfAccessSequence() {
            return this.accessNumberOfAccessSequence;
        }

        public DebitMemoReqPrcgElmnt setAccessNumberOfAccessSequence(String accessNumberOfAccessSequence) {
            this.accessNumberOfAccessSequence = accessNumberOfAccessSequence;
            return this;
        }

        public String getConditionRecord() {
            return this.conditionRecord;
        }

        public DebitMemoReqPrcgElmnt setConditionRecord(String conditionRecord) {
            this.conditionRecord = conditionRecord;
            return this;
        }

        public String getConditionSequentialNumber() {
            return this.conditionSequentialNumber;
        }

        public DebitMemoReqPrcgElmnt setConditionSequentialNumber(String conditionSequentialNumber) {
            this.conditionSequentialNumber = conditionSequentialNumber;
            return this;
        }

        public String getTaxCode() {
            return this.taxCode;
        }

        public DebitMemoReqPrcgElmnt setTaxCode(String taxCode) {
            this.taxCode = taxCode;
            return this;
        }

        public String getWithholdingTaxCode() {
            return this.withholdingTaxCode;
        }

        public DebitMemoReqPrcgElmnt setWithholdingTaxCode(String withholdingTaxCode) {
            this.withholdingTaxCode = withholdingTaxCode;
            return this;
        }

        public BigDecimal getCndnRoundingOffDiffAmount() {
            return this.cndnRoundingOffDiffAmount;
        }

        public DebitMemoReqPrcgElmnt setCndnRoundingOffDiffAmount(BigDecimal cndnRoundingOffDiffAmount) {
            this.cndnRoundingOffDiffAmount = cndnRoundingOffDiffAmount;
            return this;
        }

        public BigDecimal getConditionAmount() {
            return this.conditionAmount;
        }

        public DebitMemoReqPrcgElmnt setConditionAmount(BigDecimal conditionAmount) {
            this.conditionAmount = conditionAmount;
            return this;
        }

        public String getTransactionCurrency() {
            return this.transactionCurrency;
        }

        public DebitMemoReqPrcgElmnt setTransactionCurrency(String transactionCurrency) {
            this.transactionCurrency = transactionCurrency;
            return this;
        }

        public String getPricingProcedureCounter() {
            return this.pricingProcedureCounter;
        }

        public DebitMemoReqPrcgElmnt setPricingProcedureCounter(String pricingProcedureCounter) {
            this.pricingProcedureCounter = pricingProcedureCounter;
            return this;
        }

        public String getConditionControl() {
            return this.conditionControl;
        }

        public DebitMemoReqPrcgElmnt setConditionControl(String conditionControl) {
            this.conditionControl = conditionControl;
            return this;
        }

        public String getConditionInactiveReason() {
            return this.conditionInactiveReason;
        }

        public DebitMemoReqPrcgElmnt setConditionInactiveReason(String conditionInactiveReason) {
            this.conditionInactiveReason = conditionInactiveReason;
            return this;
        }

        public String getConditionClass() {
            return this.conditionClass;
        }

        public DebitMemoReqPrcgElmnt setConditionClass(String conditionClass) {
            this.conditionClass = conditionClass;
            return this;
        }

        public String getPrcgProcedureCounterForHeader() {
            return this.prcgProcedureCounterForHeader;
        }

        public DebitMemoReqPrcgElmnt setPrcgProcedureCounterForHeader(String prcgProcedureCounterForHeader) {
            this.prcgProcedureCounterForHeader = prcgProcedureCounterForHeader;
            return this;
        }

        public Double getFactorForConditionBasisValue() {
            return this.factorForConditionBasisValue;
        }

        public DebitMemoReqPrcgElmnt setFactorForConditionBasisValue(Double factorForConditionBasisValue) {
            this.factorForConditionBasisValue = factorForConditionBasisValue;
            return this;
        }

        public String getStructureCondition() {
            return this.structureCondition;
        }

        public DebitMemoReqPrcgElmnt setStructureCondition(String structureCondition) {
            this.structureCondition = structureCondition;
            return this;
        }

        public Double getPeriodFactorForCndnBasisValue() {
            return this.periodFactorForCndnBasisValue;
        }

        public DebitMemoReqPrcgElmnt setPeriodFactorForCndnBasisValue(Double periodFactorForCndnBasisValue) {
            this.periodFactorForCndnBasisValue = periodFactorForCndnBasisValue;
            return this;
        }

        public String getPricingScaleBasis() {
            return this.pricingScaleBasis;
        }

        public DebitMemoReqPrcgElmnt setPricingScaleBasis(String pricingScaleBasis) {
            this.pricingScaleBasis = pricingScaleBasis;
            return this;
        }

        public BigDecimal getConditionScaleBasisValue() {
            return this.conditionScaleBasisValue;
        }

        public DebitMemoReqPrcgElmnt setConditionScaleBasisValue(BigDecimal conditionScaleBasisValue) {
            this.conditionScaleBasisValue = conditionScaleBasisValue;
            return this;
        }

        public String getConditionScaleBasisUnit() {
            return this.conditionScaleBasisUnit;
        }

        public DebitMemoReqPrcgElmnt setConditionScaleBasisUnit(String conditionScaleBasisUnit) {
            this.conditionScaleBasisUnit = conditionScaleBasisUnit;
            return this;
        }

        public String getConditionApplication() {
            return this.conditionApplication;
        }

        public DebitMemoReqPrcgElmnt setConditionApplication(String conditionApplication) {
            this.conditionApplication = conditionApplication;
            return this;
        }

        public String getConditionScaleBasisCurrency() {
            return this.conditionScaleBasisCurrency;
        }

        public DebitMemoReqPrcgElmnt setConditionScaleBasisCurrency(String conditionScaleBasisCurrency) {
            this.conditionScaleBasisCurrency = conditionScaleBasisCurrency;
            return this;
        }

        public String getConditionAlternativeCurrency() {
            return this.conditionAlternativeCurrency;
        }

        public DebitMemoReqPrcgElmnt setConditionAlternativeCurrency(String conditionAlternativeCurrency) {
            this.conditionAlternativeCurrency = conditionAlternativeCurrency;
            return this;
        }

        public BigDecimal getConditionAmountInLocalCrcy() {
            return this.conditionAmountInLocalCrcy;
        }

        public DebitMemoReqPrcgElmnt setConditionAmountInLocalCrcy(BigDecimal conditionAmountInLocalCrcy) {
            this.conditionAmountInLocalCrcy = conditionAmountInLocalCrcy;
            return this;
        }

        public Boolean getCndnIsRelevantForIntcoBilling() {
            return this.cndnIsRelevantForIntcoBilling;
        }

        public DebitMemoReqPrcgElmnt setCndnIsRelevantForIntcoBilling(Boolean cndnIsRelevantForIntcoBilling) {
            this.cndnIsRelevantForIntcoBilling = cndnIsRelevantForIntcoBilling;
            return this;
        }

        public Boolean getConditionIsManuallyChanged() {
            return this.conditionIsManuallyChanged;
        }

        public DebitMemoReqPrcgElmnt setConditionIsManuallyChanged(Boolean conditionIsManuallyChanged) {
            this.conditionIsManuallyChanged = conditionIsManuallyChanged;
            return this;
        }

        public BigDecimal getCumulatedConditionBasisValue() {
            return this.cumulatedConditionBasisValue;
        }

        public DebitMemoReqPrcgElmnt setCumulatedConditionBasisValue(BigDecimal cumulatedConditionBasisValue) {
            this.cumulatedConditionBasisValue = cumulatedConditionBasisValue;
            return this;
        }

        public Boolean getConditionIsForConfiguration() {
            return this.conditionIsForConfiguration;
        }

        public DebitMemoReqPrcgElmnt setConditionIsForConfiguration(Boolean conditionIsForConfiguration) {
            this.conditionIsForConfiguration = conditionIsForConfiguration;
            return this;
        }

        public String getVariantCondition() {
            return this.variantCondition;
        }

        public DebitMemoReqPrcgElmnt setVariantCondition(String variantCondition) {
            this.variantCondition = variantCondition;
            return this;
        }

        public String getConditionType() {
            return this.conditionType;
        }

        public DebitMemoReqPrcgElmnt setConditionType(String conditionType) {
            this.conditionType = conditionType;
            return this;
        }

        public String getPricingDateTime() {
            return this.pricingDateTime;
        }

        public DebitMemoReqPrcgElmnt setPricingDateTime(String pricingDateTime) {
            this.pricingDateTime = pricingDateTime;
            return this;
        }

        public String getConditionCalculationType() {
            return this.conditionCalculationType;
        }

        public DebitMemoReqPrcgElmnt setConditionCalculationType(String conditionCalculationType) {
            this.conditionCalculationType = conditionCalculationType;
            return this;
        }

        public BigDecimal getConditionBaseValue() {
            return this.conditionBaseValue;
        }

        public DebitMemoReqPrcgElmnt setConditionBaseValue(BigDecimal conditionBaseValue) {
            this.conditionBaseValue = conditionBaseValue;
            return this;
        }

        public BigDecimal getConditionRateValue() {
            return this.conditionRateValue;
        }

        public DebitMemoReqPrcgElmnt setConditionRateValue(BigDecimal conditionRateValue) {
            this.conditionRateValue = conditionRateValue;
            return this;
        }

        public DebitMemoReqPrcgElmnt setErpConfigContext(ErpConfigContext erpConfigContext) {
            this.erpConfigContext = erpConfigContext;
            return this;
        }
    }

    public static class DebitMemoReqPartnerFluentHelper {
        private ODataQueryBuilder queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_DEBIT_MEMO_REQUEST_SRV", (String)"A_DebitMemoReqPartner");
        private ErrorResultHandler<?> errorResultHandler = new ODataVdmErrorResultHandler();

        public DebitMemoReqPartnerFluentHelper filter(ExpressionFluentHelper<DebitMemoReqPartner> expression) {
            for (FilterExpressionWrapper<?> filterExpressionWrapper : expression.evaluate()) {
                Object comparisonValue = filterExpressionWrapper.getComparisonValue();
                if (comparisonValue instanceof Integer) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Integer)((Integer)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof String) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((String)((String)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Long) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Long)((Long)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Double) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Double)((Double)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Float) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Float)((Float)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDate) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDate)((LocalDate)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDateTime)((LocalDateTime)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Date) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Date)((Date)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof DateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((DateTime)((DateTime)comparisonValue))));
                    continue;
                }
                this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of(comparisonValue)));
            }
            return this;
        }

        public DebitMemoReqPartnerFluentHelper orderBy(EntityField<?, DebitMemoReqPartner> field, Order order) {
            String orderingDirection = order == Order.ASC ? " asc" : " desc";
            this.queryBuilder.param("orderby", (Object)(field.getFieldName() + orderingDirection));
            return this;
        }

        @SafeVarargs
        public final DebitMemoReqPartnerFluentHelper select(EntityField<?, DebitMemoReqPartner> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public DebitMemoReqPartnerFluentHelper top(Number top) {
            this.queryBuilder.top(top);
            return this;
        }

        public DebitMemoReqPartnerFluentHelper skip(Number skip) {
            this.queryBuilder.skip(skip);
            return this;
        }

        public DebitMemoReqPartnerFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.errorHandler(this.errorResultHandler).build();
        }

        public List<DebitMemoReqPartner> execute(ErpConfigContext erpConfigContext) throws ODataException {
            List entityList = this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).asList(DebitMemoReqPartner.class);
            for (DebitMemoReqPartner entity : entityList) {
                entity.setErpConfigContext(erpConfigContext);
            }
            return entityList;
        }
    }

    public static class DebitMemoReqPartnerByKeyFluentHelper {
        private ODataQueryBuilder queryBuilder;
        private ErrorResultHandler<?> errorResultHandler;
        private List<Object> values = new LinkedList<Object>();

        public DebitMemoReqPartnerByKeyFluentHelper(String debitMemoRequest, String partnerFunction) {
            this.values.add(debitMemoRequest);
            this.values.add(partnerFunction);
            this.queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_DEBIT_MEMO_REQUEST_SRV", (String)"A_DebitMemoReqPartner");
            HashMap<String, Object> keys = new HashMap<String, Object>();
            keys.put("DebitMemoRequest", this.values.get(0));
            keys.put("PartnerFunction", this.values.get(1));
            this.queryBuilder.keys(keys);
        }

        @SafeVarargs
        public final DebitMemoReqPartnerByKeyFluentHelper select(EntityField<?, DebitMemoReqPartner> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.build();
        }

        public DebitMemoReqPartnerByKeyFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public DebitMemoReqPartner execute(ErpConfigContext erpConfigContext) throws ODataException {
            DebitMemoReqPartner entity = (DebitMemoReqPartner)this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).as(DebitMemoReqPartner.class);
            entity.setErpConfigContext(erpConfigContext);
            return entity;
        }
    }

    public static class DebitMemoReqPartner {
        @ElementName(value="DebitMemoRequest")
        private String debitMemoRequest;
        public static EntityField<String, DebitMemoReqPartner> DEBIT_MEMO_REQUEST = new EntityField("DebitMemoRequest");
        @ElementName(value="PartnerFunction")
        private String partnerFunction;
        public static EntityField<String, DebitMemoReqPartner> PARTNER_FUNCTION = new EntityField("PartnerFunction");
        @ElementName(value="Customer")
        private String customer;
        public static EntityField<String, DebitMemoReqPartner> CUSTOMER = new EntityField("Customer");
        @ElementName(value="Supplier")
        private String supplier;
        public static EntityField<String, DebitMemoReqPartner> SUPPLIER = new EntityField("Supplier");
        @ElementName(value="Personnel")
        private String personnel;
        public static EntityField<String, DebitMemoReqPartner> PERSONNEL = new EntityField("Personnel");
        @ElementName(value="ContactPerson")
        private String contactPerson;
        public static EntityField<String, DebitMemoReqPartner> CONTACT_PERSON = new EntityField("ContactPerson");
        private static final transient String ODATA_ENDPOINT_URL = "/sap/opu/odata/sap/API_DEBIT_MEMO_REQUEST_SRV";
        private static final transient String ODATA_ENTITY_COLLECTION = "A_DebitMemoReqPartner";
        private transient ErpConfigContext erpConfigContext;

        @JsonIgnore
        public DebitMemoRequest fetchDebitMemoRequest() throws ODataException {
            StringBuilder odataResourceUrl = new StringBuilder(ODATA_ENTITY_COLLECTION);
            odataResourceUrl.append("(");
            odataResourceUrl.append("DebitMemoRequest=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.debitMemoRequest));
            odataResourceUrl.append(",PartnerFunction=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.partnerFunction));
            odataResourceUrl.append(")/");
            odataResourceUrl.append("to_DebitMemoRequest");
            ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)ODATA_ENDPOINT_URL, (String)odataResourceUrl.toString());
            ODataQuery query = builder.build();
            ErpEndpoint erpEndpoint = new ErpEndpoint(this.erpConfigContext);
            ODataQueryResult result = query.execute((WithDestinationName)erpEndpoint);
            DebitMemoRequest entityList = (DebitMemoRequest)result.as(DebitMemoRequest.class);
            entityList.setErpConfigContext(this.erpConfigContext);
            return entityList;
        }

        public String toString() {
            return "ReadDebitMemoRequestsNamespace.DebitMemoReqPartner(debitMemoRequest=" + this.debitMemoRequest + ", partnerFunction=" + this.partnerFunction + ", customer=" + this.customer + ", supplier=" + this.supplier + ", personnel=" + this.personnel + ", contactPerson=" + this.contactPerson + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DebitMemoReqPartner)) {
                return false;
            }
            DebitMemoReqPartner other = (DebitMemoReqPartner)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$debitMemoRequest = this.debitMemoRequest;
            String other$debitMemoRequest = other.debitMemoRequest;
            if (this$debitMemoRequest == null ? other$debitMemoRequest != null : !this$debitMemoRequest.equals(other$debitMemoRequest)) {
                return false;
            }
            String this$partnerFunction = this.partnerFunction;
            String other$partnerFunction = other.partnerFunction;
            if (this$partnerFunction == null ? other$partnerFunction != null : !this$partnerFunction.equals(other$partnerFunction)) {
                return false;
            }
            String this$customer = this.customer;
            String other$customer = other.customer;
            if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
                return false;
            }
            String this$supplier = this.supplier;
            String other$supplier = other.supplier;
            if (this$supplier == null ? other$supplier != null : !this$supplier.equals(other$supplier)) {
                return false;
            }
            String this$personnel = this.personnel;
            String other$personnel = other.personnel;
            if (this$personnel == null ? other$personnel != null : !this$personnel.equals(other$personnel)) {
                return false;
            }
            String this$contactPerson = this.contactPerson;
            String other$contactPerson = other.contactPerson;
            return !(this$contactPerson == null ? other$contactPerson != null : !this$contactPerson.equals(other$contactPerson));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DebitMemoReqPartner;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $debitMemoRequest = this.debitMemoRequest;
            result = result * 59 + ($debitMemoRequest == null ? 43 : $debitMemoRequest.hashCode());
            String $partnerFunction = this.partnerFunction;
            result = result * 59 + ($partnerFunction == null ? 43 : $partnerFunction.hashCode());
            String $customer = this.customer;
            result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
            String $supplier = this.supplier;
            result = result * 59 + ($supplier == null ? 43 : $supplier.hashCode());
            String $personnel = this.personnel;
            result = result * 59 + ($personnel == null ? 43 : $personnel.hashCode());
            String $contactPerson = this.contactPerson;
            result = result * 59 + ($contactPerson == null ? 43 : $contactPerson.hashCode());
            return result;
        }

        public String getDebitMemoRequest() {
            return this.debitMemoRequest;
        }

        public DebitMemoReqPartner setDebitMemoRequest(String debitMemoRequest) {
            this.debitMemoRequest = debitMemoRequest;
            return this;
        }

        public String getPartnerFunction() {
            return this.partnerFunction;
        }

        public DebitMemoReqPartner setPartnerFunction(String partnerFunction) {
            this.partnerFunction = partnerFunction;
            return this;
        }

        public String getCustomer() {
            return this.customer;
        }

        public DebitMemoReqPartner setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public String getSupplier() {
            return this.supplier;
        }

        public DebitMemoReqPartner setSupplier(String supplier) {
            this.supplier = supplier;
            return this;
        }

        public String getPersonnel() {
            return this.personnel;
        }

        public DebitMemoReqPartner setPersonnel(String personnel) {
            this.personnel = personnel;
            return this;
        }

        public String getContactPerson() {
            return this.contactPerson;
        }

        public DebitMemoReqPartner setContactPerson(String contactPerson) {
            this.contactPerson = contactPerson;
            return this;
        }

        public DebitMemoReqPartner setErpConfigContext(ErpConfigContext erpConfigContext) {
            this.erpConfigContext = erpConfigContext;
            return this;
        }
    }

    public static class DebitMemoReqItemPrcgElmntFluentHelper {
        private ODataQueryBuilder queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_DEBIT_MEMO_REQUEST_SRV", (String)"A_DebitMemoReqItemPrcgElmnt");
        private ErrorResultHandler<?> errorResultHandler = new ODataVdmErrorResultHandler();

        public DebitMemoReqItemPrcgElmntFluentHelper filter(ExpressionFluentHelper<DebitMemoReqItemPrcgElmnt> expression) {
            for (FilterExpressionWrapper<?> filterExpressionWrapper : expression.evaluate()) {
                Object comparisonValue = filterExpressionWrapper.getComparisonValue();
                if (comparisonValue instanceof Integer) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Integer)((Integer)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof String) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((String)((String)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Long) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Long)((Long)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Double) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Double)((Double)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Float) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Float)((Float)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDate) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDate)((LocalDate)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDateTime)((LocalDateTime)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Date) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Date)((Date)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof DateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((DateTime)((DateTime)comparisonValue))));
                    continue;
                }
                this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of(comparisonValue)));
            }
            return this;
        }

        public DebitMemoReqItemPrcgElmntFluentHelper orderBy(EntityField<?, DebitMemoReqItemPrcgElmnt> field, Order order) {
            String orderingDirection = order == Order.ASC ? " asc" : " desc";
            this.queryBuilder.param("orderby", (Object)(field.getFieldName() + orderingDirection));
            return this;
        }

        @SafeVarargs
        public final DebitMemoReqItemPrcgElmntFluentHelper select(EntityField<?, DebitMemoReqItemPrcgElmnt> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public DebitMemoReqItemPrcgElmntFluentHelper top(Number top) {
            this.queryBuilder.top(top);
            return this;
        }

        public DebitMemoReqItemPrcgElmntFluentHelper skip(Number skip) {
            this.queryBuilder.skip(skip);
            return this;
        }

        public DebitMemoReqItemPrcgElmntFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.errorHandler(this.errorResultHandler).build();
        }

        public List<DebitMemoReqItemPrcgElmnt> execute(ErpConfigContext erpConfigContext) throws ODataException {
            List entityList = this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).asList(DebitMemoReqItemPrcgElmnt.class);
            for (DebitMemoReqItemPrcgElmnt entity : entityList) {
                entity.setErpConfigContext(erpConfigContext);
            }
            return entityList;
        }
    }

    public static class DebitMemoReqItemPrcgElmntByKeyFluentHelper {
        private ODataQueryBuilder queryBuilder;
        private ErrorResultHandler<?> errorResultHandler;
        private List<Object> values = new LinkedList<Object>();

        public DebitMemoReqItemPrcgElmntByKeyFluentHelper(String debitMemoRequest, String debitMemoRequestItem, String pricingProcedureStep, String pricingProcedureCounter) {
            this.values.add(debitMemoRequest);
            this.values.add(debitMemoRequestItem);
            this.values.add(pricingProcedureStep);
            this.values.add(pricingProcedureCounter);
            this.queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_DEBIT_MEMO_REQUEST_SRV", (String)"A_DebitMemoReqItemPrcgElmnt");
            HashMap<String, Object> keys = new HashMap<String, Object>();
            keys.put("DebitMemoRequest", this.values.get(0));
            keys.put("DebitMemoRequestItem", this.values.get(1));
            keys.put("PricingProcedureStep", this.values.get(2));
            keys.put("PricingProcedureCounter", this.values.get(3));
            this.queryBuilder.keys(keys);
        }

        @SafeVarargs
        public final DebitMemoReqItemPrcgElmntByKeyFluentHelper select(EntityField<?, DebitMemoReqItemPrcgElmnt> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.build();
        }

        public DebitMemoReqItemPrcgElmntByKeyFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public DebitMemoReqItemPrcgElmnt execute(ErpConfigContext erpConfigContext) throws ODataException {
            DebitMemoReqItemPrcgElmnt entity = (DebitMemoReqItemPrcgElmnt)this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).as(DebitMemoReqItemPrcgElmnt.class);
            entity.setErpConfigContext(erpConfigContext);
            return entity;
        }
    }

    public static class DebitMemoReqItemPrcgElmnt {
        @ElementName(value="DebitMemoRequest")
        private String debitMemoRequest;
        public static EntityField<String, DebitMemoReqItemPrcgElmnt> DEBIT_MEMO_REQUEST = new EntityField("DebitMemoRequest");
        @ElementName(value="ConditionRateValue")
        private BigDecimal conditionRateValue;
        public static EntityField<BigDecimal, DebitMemoReqItemPrcgElmnt> CONDITION_RATE_VALUE = new EntityField("ConditionRateValue");
        @ElementName(value="ConditionCurrency")
        private String conditionCurrency;
        public static EntityField<String, DebitMemoReqItemPrcgElmnt> CONDITION_CURRENCY = new EntityField("ConditionCurrency");
        @ElementName(value="ConditionQuantity")
        private BigDecimal conditionQuantity;
        public static EntityField<BigDecimal, DebitMemoReqItemPrcgElmnt> CONDITION_QUANTITY = new EntityField("ConditionQuantity");
        @ElementName(value="ConditionQuantityUnit")
        private String conditionQuantityUnit;
        public static EntityField<String, DebitMemoReqItemPrcgElmnt> CONDITION_QUANTITY_UNIT = new EntityField("ConditionQuantityUnit");
        @ElementName(value="ConditionToBaseQtyNmrtr")
        private BigDecimal conditionToBaseQtyNmrtr;
        public static EntityField<BigDecimal, DebitMemoReqItemPrcgElmnt> CONDITION_TO_BASE_QTY_NMRTR = new EntityField("ConditionToBaseQtyNmrtr");
        @ElementName(value="ConditionToBaseQtyDnmntr")
        private BigDecimal conditionToBaseQtyDnmntr;
        public static EntityField<BigDecimal, DebitMemoReqItemPrcgElmnt> CONDITION_TO_BASE_QTY_DNMNTR = new EntityField("ConditionToBaseQtyDnmntr");
        @ElementName(value="ConditionCategory")
        private String conditionCategory;
        public static EntityField<String, DebitMemoReqItemPrcgElmnt> CONDITION_CATEGORY = new EntityField("ConditionCategory");
        @ElementName(value="ConditionIsForStatistics")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean conditionIsForStatistics;
        public static EntityField<Boolean, DebitMemoReqItemPrcgElmnt> CONDITION_IS_FOR_STATISTICS = new EntityField("ConditionIsForStatistics");
        @ElementName(value="PricingScaleType")
        private String pricingScaleType;
        public static EntityField<String, DebitMemoReqItemPrcgElmnt> PRICING_SCALE_TYPE = new EntityField("PricingScaleType");
        @ElementName(value="IsRelevantForAccrual")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean isRelevantForAccrual;
        public static EntityField<Boolean, DebitMemoReqItemPrcgElmnt> IS_RELEVANT_FOR_ACCRUAL = new EntityField("IsRelevantForAccrual");
        @ElementName(value="DebitMemoRequestItem")
        private String debitMemoRequestItem;
        public static EntityField<String, DebitMemoReqItemPrcgElmnt> DEBIT_MEMO_REQUEST_ITEM = new EntityField("DebitMemoRequestItem");
        @ElementName(value="CndnIsRelevantForInvoiceList")
        private String cndnIsRelevantForInvoiceList;
        public static EntityField<String, DebitMemoReqItemPrcgElmnt> CNDN_IS_RELEVANT_FOR_INVOICE_LIST = new EntityField("CndnIsRelevantForInvoiceList");
        @ElementName(value="ConditionOrigin")
        private String conditionOrigin;
        public static EntityField<String, DebitMemoReqItemPrcgElmnt> CONDITION_ORIGIN = new EntityField("ConditionOrigin");
        @ElementName(value="IsGroupCondition")
        private String isGroupCondition;
        public static EntityField<String, DebitMemoReqItemPrcgElmnt> IS_GROUP_CONDITION = new EntityField("IsGroupCondition");
        @ElementName(value="AccessNumberOfAccessSequence")
        private String accessNumberOfAccessSequence;
        public static EntityField<String, DebitMemoReqItemPrcgElmnt> ACCESS_NUMBER_OF_ACCESS_SEQUENCE = new EntityField("AccessNumberOfAccessSequence");
        @ElementName(value="ConditionRecord")
        private String conditionRecord;
        public static EntityField<String, DebitMemoReqItemPrcgElmnt> CONDITION_RECORD = new EntityField("ConditionRecord");
        @ElementName(value="ConditionSequentialNumber")
        private String conditionSequentialNumber;
        public static EntityField<String, DebitMemoReqItemPrcgElmnt> CONDITION_SEQUENTIAL_NUMBER = new EntityField("ConditionSequentialNumber");
        @ElementName(value="TaxCode")
        private String taxCode;
        public static EntityField<String, DebitMemoReqItemPrcgElmnt> TAX_CODE = new EntityField("TaxCode");
        @ElementName(value="WithholdingTaxCode")
        private String withholdingTaxCode;
        public static EntityField<String, DebitMemoReqItemPrcgElmnt> WITHHOLDING_TAX_CODE = new EntityField("WithholdingTaxCode");
        @ElementName(value="CndnRoundingOffDiffAmount")
        private BigDecimal cndnRoundingOffDiffAmount;
        public static EntityField<BigDecimal, DebitMemoReqItemPrcgElmnt> CNDN_ROUNDING_OFF_DIFF_AMOUNT = new EntityField("CndnRoundingOffDiffAmount");
        @ElementName(value="ConditionAmount")
        private BigDecimal conditionAmount;
        public static EntityField<BigDecimal, DebitMemoReqItemPrcgElmnt> CONDITION_AMOUNT = new EntityField("ConditionAmount");
        @ElementName(value="PricingProcedureStep")
        private String pricingProcedureStep;
        public static EntityField<String, DebitMemoReqItemPrcgElmnt> PRICING_PROCEDURE_STEP = new EntityField("PricingProcedureStep");
        @ElementName(value="TransactionCurrency")
        private String transactionCurrency;
        public static EntityField<String, DebitMemoReqItemPrcgElmnt> TRANSACTION_CURRENCY = new EntityField("TransactionCurrency");
        @ElementName(value="ConditionControl")
        private String conditionControl;
        public static EntityField<String, DebitMemoReqItemPrcgElmnt> CONDITION_CONTROL = new EntityField("ConditionControl");
        @ElementName(value="ConditionInactiveReason")
        private String conditionInactiveReason;
        public static EntityField<String, DebitMemoReqItemPrcgElmnt> CONDITION_INACTIVE_REASON = new EntityField("ConditionInactiveReason");
        @ElementName(value="ConditionClass")
        private String conditionClass;
        public static EntityField<String, DebitMemoReqItemPrcgElmnt> CONDITION_CLASS = new EntityField("ConditionClass");
        @ElementName(value="PrcgProcedureCounterForHeader")
        private String prcgProcedureCounterForHeader;
        public static EntityField<String, DebitMemoReqItemPrcgElmnt> PRCG_PROCEDURE_COUNTER_FOR_HEADER = new EntityField("PrcgProcedureCounterForHeader");
        @ElementName(value="FactorForConditionBasisValue")
        private Double factorForConditionBasisValue;
        public static EntityField<Double, DebitMemoReqItemPrcgElmnt> FACTOR_FOR_CONDITION_BASIS_VALUE = new EntityField("FactorForConditionBasisValue");
        @ElementName(value="StructureCondition")
        private String structureCondition;
        public static EntityField<String, DebitMemoReqItemPrcgElmnt> STRUCTURE_CONDITION = new EntityField("StructureCondition");
        @ElementName(value="PeriodFactorForCndnBasisValue")
        private Double periodFactorForCndnBasisValue;
        public static EntityField<Double, DebitMemoReqItemPrcgElmnt> PERIOD_FACTOR_FOR_CNDN_BASIS_VALUE = new EntityField("PeriodFactorForCndnBasisValue");
        @ElementName(value="PricingScaleBasis")
        private String pricingScaleBasis;
        public static EntityField<String, DebitMemoReqItemPrcgElmnt> PRICING_SCALE_BASIS = new EntityField("PricingScaleBasis");
        @ElementName(value="ConditionScaleBasisValue")
        private BigDecimal conditionScaleBasisValue;
        public static EntityField<BigDecimal, DebitMemoReqItemPrcgElmnt> CONDITION_SCALE_BASIS_VALUE = new EntityField("ConditionScaleBasisValue");
        @ElementName(value="PricingProcedureCounter")
        private String pricingProcedureCounter;
        public static EntityField<String, DebitMemoReqItemPrcgElmnt> PRICING_PROCEDURE_COUNTER = new EntityField("PricingProcedureCounter");
        @ElementName(value="ConditionScaleBasisUnit")
        private String conditionScaleBasisUnit;
        public static EntityField<String, DebitMemoReqItemPrcgElmnt> CONDITION_SCALE_BASIS_UNIT = new EntityField("ConditionScaleBasisUnit");
        @ElementName(value="ConditionScaleBasisCurrency")
        private String conditionScaleBasisCurrency;
        public static EntityField<String, DebitMemoReqItemPrcgElmnt> CONDITION_SCALE_BASIS_CURRENCY = new EntityField("ConditionScaleBasisCurrency");
        @ElementName(value="ConditionAlternativeCurrency")
        private String conditionAlternativeCurrency;
        public static EntityField<String, DebitMemoReqItemPrcgElmnt> CONDITION_ALTERNATIVE_CURRENCY = new EntityField("ConditionAlternativeCurrency");
        @ElementName(value="ConditionAmountInLocalCrcy")
        private BigDecimal conditionAmountInLocalCrcy;
        public static EntityField<BigDecimal, DebitMemoReqItemPrcgElmnt> CONDITION_AMOUNT_IN_LOCAL_CRCY = new EntityField("ConditionAmountInLocalCrcy");
        @ElementName(value="CndnIsRelevantForIntcoBilling")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean cndnIsRelevantForIntcoBilling;
        public static EntityField<Boolean, DebitMemoReqItemPrcgElmnt> CNDN_IS_RELEVANT_FOR_INTCO_BILLING = new EntityField("CndnIsRelevantForIntcoBilling");
        @ElementName(value="ConditionIsManuallyChanged")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean conditionIsManuallyChanged;
        public static EntityField<Boolean, DebitMemoReqItemPrcgElmnt> CONDITION_IS_MANUALLY_CHANGED = new EntityField("ConditionIsManuallyChanged");
        @ElementName(value="CumulatedConditionBasisValue")
        private BigDecimal cumulatedConditionBasisValue;
        public static EntityField<BigDecimal, DebitMemoReqItemPrcgElmnt> CUMULATED_CONDITION_BASIS_VALUE = new EntityField("CumulatedConditionBasisValue");
        @ElementName(value="ConditionIsForConfiguration")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean conditionIsForConfiguration;
        public static EntityField<Boolean, DebitMemoReqItemPrcgElmnt> CONDITION_IS_FOR_CONFIGURATION = new EntityField("ConditionIsForConfiguration");
        @ElementName(value="VariantCondition")
        private String variantCondition;
        public static EntityField<String, DebitMemoReqItemPrcgElmnt> VARIANT_CONDITION = new EntityField("VariantCondition");
        @ElementName(value="ConditionApplication")
        private String conditionApplication;
        public static EntityField<String, DebitMemoReqItemPrcgElmnt> CONDITION_APPLICATION = new EntityField("ConditionApplication");
        @ElementName(value="ConditionType")
        private String conditionType;
        public static EntityField<String, DebitMemoReqItemPrcgElmnt> CONDITION_TYPE = new EntityField("ConditionType");
        @ElementName(value="PricingDateTime")
        private String pricingDateTime;
        public static EntityField<String, DebitMemoReqItemPrcgElmnt> PRICING_DATE_TIME = new EntityField("PricingDateTime");
        @ElementName(value="ConditionCalculationType")
        private String conditionCalculationType;
        public static EntityField<String, DebitMemoReqItemPrcgElmnt> CONDITION_CALCULATION_TYPE = new EntityField("ConditionCalculationType");
        @ElementName(value="ConditionBaseValue")
        private BigDecimal conditionBaseValue;
        public static EntityField<BigDecimal, DebitMemoReqItemPrcgElmnt> CONDITION_BASE_VALUE = new EntityField("ConditionBaseValue");
        private static final transient String ODATA_ENDPOINT_URL = "/sap/opu/odata/sap/API_DEBIT_MEMO_REQUEST_SRV";
        private static final transient String ODATA_ENTITY_COLLECTION = "A_DebitMemoReqItemPrcgElmnt";
        private transient ErpConfigContext erpConfigContext;

        @JsonIgnore
        public DebitMemoRequest fetchDebitMemoRequest() throws ODataException {
            StringBuilder odataResourceUrl = new StringBuilder(ODATA_ENTITY_COLLECTION);
            odataResourceUrl.append("(");
            odataResourceUrl.append("DebitMemoRequest=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.debitMemoRequest));
            odataResourceUrl.append(",DebitMemoRequestItem=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.debitMemoRequestItem));
            odataResourceUrl.append(",PricingProcedureStep=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.pricingProcedureStep));
            odataResourceUrl.append(",PricingProcedureCounter=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.pricingProcedureCounter));
            odataResourceUrl.append(")/");
            odataResourceUrl.append("to_DebitMemoRequest");
            ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)ODATA_ENDPOINT_URL, (String)odataResourceUrl.toString());
            ODataQuery query = builder.build();
            ErpEndpoint erpEndpoint = new ErpEndpoint(this.erpConfigContext);
            ODataQueryResult result = query.execute((WithDestinationName)erpEndpoint);
            DebitMemoRequest entityList = (DebitMemoRequest)result.as(DebitMemoRequest.class);
            entityList.setErpConfigContext(this.erpConfigContext);
            return entityList;
        }

        @JsonIgnore
        public DebitMemoRequestItem fetchDebitMemoRequestItem() throws ODataException {
            StringBuilder odataResourceUrl = new StringBuilder(ODATA_ENTITY_COLLECTION);
            odataResourceUrl.append("(");
            odataResourceUrl.append("DebitMemoRequest=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.debitMemoRequest));
            odataResourceUrl.append(",DebitMemoRequestItem=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.debitMemoRequestItem));
            odataResourceUrl.append(",PricingProcedureStep=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.pricingProcedureStep));
            odataResourceUrl.append(",PricingProcedureCounter=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.pricingProcedureCounter));
            odataResourceUrl.append(")/");
            odataResourceUrl.append("to_DebitMemoRequestItem");
            ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)ODATA_ENDPOINT_URL, (String)odataResourceUrl.toString());
            ODataQuery query = builder.build();
            ErpEndpoint erpEndpoint = new ErpEndpoint(this.erpConfigContext);
            ODataQueryResult result = query.execute((WithDestinationName)erpEndpoint);
            DebitMemoRequestItem entityList = (DebitMemoRequestItem)result.as(DebitMemoRequestItem.class);
            entityList.setErpConfigContext(this.erpConfigContext);
            return entityList;
        }

        public String toString() {
            return "ReadDebitMemoRequestsNamespace.DebitMemoReqItemPrcgElmnt(debitMemoRequest=" + this.debitMemoRequest + ", conditionRateValue=" + this.conditionRateValue + ", conditionCurrency=" + this.conditionCurrency + ", conditionQuantity=" + this.conditionQuantity + ", conditionQuantityUnit=" + this.conditionQuantityUnit + ", conditionToBaseQtyNmrtr=" + this.conditionToBaseQtyNmrtr + ", conditionToBaseQtyDnmntr=" + this.conditionToBaseQtyDnmntr + ", conditionCategory=" + this.conditionCategory + ", conditionIsForStatistics=" + this.conditionIsForStatistics + ", pricingScaleType=" + this.pricingScaleType + ", isRelevantForAccrual=" + this.isRelevantForAccrual + ", debitMemoRequestItem=" + this.debitMemoRequestItem + ", cndnIsRelevantForInvoiceList=" + this.cndnIsRelevantForInvoiceList + ", conditionOrigin=" + this.conditionOrigin + ", isGroupCondition=" + this.isGroupCondition + ", accessNumberOfAccessSequence=" + this.accessNumberOfAccessSequence + ", conditionRecord=" + this.conditionRecord + ", conditionSequentialNumber=" + this.conditionSequentialNumber + ", taxCode=" + this.taxCode + ", withholdingTaxCode=" + this.withholdingTaxCode + ", cndnRoundingOffDiffAmount=" + this.cndnRoundingOffDiffAmount + ", conditionAmount=" + this.conditionAmount + ", pricingProcedureStep=" + this.pricingProcedureStep + ", transactionCurrency=" + this.transactionCurrency + ", conditionControl=" + this.conditionControl + ", conditionInactiveReason=" + this.conditionInactiveReason + ", conditionClass=" + this.conditionClass + ", prcgProcedureCounterForHeader=" + this.prcgProcedureCounterForHeader + ", factorForConditionBasisValue=" + this.factorForConditionBasisValue + ", structureCondition=" + this.structureCondition + ", periodFactorForCndnBasisValue=" + this.periodFactorForCndnBasisValue + ", pricingScaleBasis=" + this.pricingScaleBasis + ", conditionScaleBasisValue=" + this.conditionScaleBasisValue + ", pricingProcedureCounter=" + this.pricingProcedureCounter + ", conditionScaleBasisUnit=" + this.conditionScaleBasisUnit + ", conditionScaleBasisCurrency=" + this.conditionScaleBasisCurrency + ", conditionAlternativeCurrency=" + this.conditionAlternativeCurrency + ", conditionAmountInLocalCrcy=" + this.conditionAmountInLocalCrcy + ", cndnIsRelevantForIntcoBilling=" + this.cndnIsRelevantForIntcoBilling + ", conditionIsManuallyChanged=" + this.conditionIsManuallyChanged + ", cumulatedConditionBasisValue=" + this.cumulatedConditionBasisValue + ", conditionIsForConfiguration=" + this.conditionIsForConfiguration + ", variantCondition=" + this.variantCondition + ", conditionApplication=" + this.conditionApplication + ", conditionType=" + this.conditionType + ", pricingDateTime=" + this.pricingDateTime + ", conditionCalculationType=" + this.conditionCalculationType + ", conditionBaseValue=" + this.conditionBaseValue + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DebitMemoReqItemPrcgElmnt)) {
                return false;
            }
            DebitMemoReqItemPrcgElmnt other = (DebitMemoReqItemPrcgElmnt)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$debitMemoRequest = this.debitMemoRequest;
            String other$debitMemoRequest = other.debitMemoRequest;
            if (this$debitMemoRequest == null ? other$debitMemoRequest != null : !this$debitMemoRequest.equals(other$debitMemoRequest)) {
                return false;
            }
            BigDecimal this$conditionRateValue = this.conditionRateValue;
            BigDecimal other$conditionRateValue = other.conditionRateValue;
            if (this$conditionRateValue == null ? other$conditionRateValue != null : !((Object)this$conditionRateValue).equals(other$conditionRateValue)) {
                return false;
            }
            String this$conditionCurrency = this.conditionCurrency;
            String other$conditionCurrency = other.conditionCurrency;
            if (this$conditionCurrency == null ? other$conditionCurrency != null : !this$conditionCurrency.equals(other$conditionCurrency)) {
                return false;
            }
            BigDecimal this$conditionQuantity = this.conditionQuantity;
            BigDecimal other$conditionQuantity = other.conditionQuantity;
            if (this$conditionQuantity == null ? other$conditionQuantity != null : !((Object)this$conditionQuantity).equals(other$conditionQuantity)) {
                return false;
            }
            String this$conditionQuantityUnit = this.conditionQuantityUnit;
            String other$conditionQuantityUnit = other.conditionQuantityUnit;
            if (this$conditionQuantityUnit == null ? other$conditionQuantityUnit != null : !this$conditionQuantityUnit.equals(other$conditionQuantityUnit)) {
                return false;
            }
            BigDecimal this$conditionToBaseQtyNmrtr = this.conditionToBaseQtyNmrtr;
            BigDecimal other$conditionToBaseQtyNmrtr = other.conditionToBaseQtyNmrtr;
            if (this$conditionToBaseQtyNmrtr == null ? other$conditionToBaseQtyNmrtr != null : !((Object)this$conditionToBaseQtyNmrtr).equals(other$conditionToBaseQtyNmrtr)) {
                return false;
            }
            BigDecimal this$conditionToBaseQtyDnmntr = this.conditionToBaseQtyDnmntr;
            BigDecimal other$conditionToBaseQtyDnmntr = other.conditionToBaseQtyDnmntr;
            if (this$conditionToBaseQtyDnmntr == null ? other$conditionToBaseQtyDnmntr != null : !((Object)this$conditionToBaseQtyDnmntr).equals(other$conditionToBaseQtyDnmntr)) {
                return false;
            }
            String this$conditionCategory = this.conditionCategory;
            String other$conditionCategory = other.conditionCategory;
            if (this$conditionCategory == null ? other$conditionCategory != null : !this$conditionCategory.equals(other$conditionCategory)) {
                return false;
            }
            Boolean this$conditionIsForStatistics = this.conditionIsForStatistics;
            Boolean other$conditionIsForStatistics = other.conditionIsForStatistics;
            if (this$conditionIsForStatistics == null ? other$conditionIsForStatistics != null : !((Object)this$conditionIsForStatistics).equals(other$conditionIsForStatistics)) {
                return false;
            }
            String this$pricingScaleType = this.pricingScaleType;
            String other$pricingScaleType = other.pricingScaleType;
            if (this$pricingScaleType == null ? other$pricingScaleType != null : !this$pricingScaleType.equals(other$pricingScaleType)) {
                return false;
            }
            Boolean this$isRelevantForAccrual = this.isRelevantForAccrual;
            Boolean other$isRelevantForAccrual = other.isRelevantForAccrual;
            if (this$isRelevantForAccrual == null ? other$isRelevantForAccrual != null : !((Object)this$isRelevantForAccrual).equals(other$isRelevantForAccrual)) {
                return false;
            }
            String this$debitMemoRequestItem = this.debitMemoRequestItem;
            String other$debitMemoRequestItem = other.debitMemoRequestItem;
            if (this$debitMemoRequestItem == null ? other$debitMemoRequestItem != null : !this$debitMemoRequestItem.equals(other$debitMemoRequestItem)) {
                return false;
            }
            String this$cndnIsRelevantForInvoiceList = this.cndnIsRelevantForInvoiceList;
            String other$cndnIsRelevantForInvoiceList = other.cndnIsRelevantForInvoiceList;
            if (this$cndnIsRelevantForInvoiceList == null ? other$cndnIsRelevantForInvoiceList != null : !this$cndnIsRelevantForInvoiceList.equals(other$cndnIsRelevantForInvoiceList)) {
                return false;
            }
            String this$conditionOrigin = this.conditionOrigin;
            String other$conditionOrigin = other.conditionOrigin;
            if (this$conditionOrigin == null ? other$conditionOrigin != null : !this$conditionOrigin.equals(other$conditionOrigin)) {
                return false;
            }
            String this$isGroupCondition = this.isGroupCondition;
            String other$isGroupCondition = other.isGroupCondition;
            if (this$isGroupCondition == null ? other$isGroupCondition != null : !this$isGroupCondition.equals(other$isGroupCondition)) {
                return false;
            }
            String this$accessNumberOfAccessSequence = this.accessNumberOfAccessSequence;
            String other$accessNumberOfAccessSequence = other.accessNumberOfAccessSequence;
            if (this$accessNumberOfAccessSequence == null ? other$accessNumberOfAccessSequence != null : !this$accessNumberOfAccessSequence.equals(other$accessNumberOfAccessSequence)) {
                return false;
            }
            String this$conditionRecord = this.conditionRecord;
            String other$conditionRecord = other.conditionRecord;
            if (this$conditionRecord == null ? other$conditionRecord != null : !this$conditionRecord.equals(other$conditionRecord)) {
                return false;
            }
            String this$conditionSequentialNumber = this.conditionSequentialNumber;
            String other$conditionSequentialNumber = other.conditionSequentialNumber;
            if (this$conditionSequentialNumber == null ? other$conditionSequentialNumber != null : !this$conditionSequentialNumber.equals(other$conditionSequentialNumber)) {
                return false;
            }
            String this$taxCode = this.taxCode;
            String other$taxCode = other.taxCode;
            if (this$taxCode == null ? other$taxCode != null : !this$taxCode.equals(other$taxCode)) {
                return false;
            }
            String this$withholdingTaxCode = this.withholdingTaxCode;
            String other$withholdingTaxCode = other.withholdingTaxCode;
            if (this$withholdingTaxCode == null ? other$withholdingTaxCode != null : !this$withholdingTaxCode.equals(other$withholdingTaxCode)) {
                return false;
            }
            BigDecimal this$cndnRoundingOffDiffAmount = this.cndnRoundingOffDiffAmount;
            BigDecimal other$cndnRoundingOffDiffAmount = other.cndnRoundingOffDiffAmount;
            if (this$cndnRoundingOffDiffAmount == null ? other$cndnRoundingOffDiffAmount != null : !((Object)this$cndnRoundingOffDiffAmount).equals(other$cndnRoundingOffDiffAmount)) {
                return false;
            }
            BigDecimal this$conditionAmount = this.conditionAmount;
            BigDecimal other$conditionAmount = other.conditionAmount;
            if (this$conditionAmount == null ? other$conditionAmount != null : !((Object)this$conditionAmount).equals(other$conditionAmount)) {
                return false;
            }
            String this$pricingProcedureStep = this.pricingProcedureStep;
            String other$pricingProcedureStep = other.pricingProcedureStep;
            if (this$pricingProcedureStep == null ? other$pricingProcedureStep != null : !this$pricingProcedureStep.equals(other$pricingProcedureStep)) {
                return false;
            }
            String this$transactionCurrency = this.transactionCurrency;
            String other$transactionCurrency = other.transactionCurrency;
            if (this$transactionCurrency == null ? other$transactionCurrency != null : !this$transactionCurrency.equals(other$transactionCurrency)) {
                return false;
            }
            String this$conditionControl = this.conditionControl;
            String other$conditionControl = other.conditionControl;
            if (this$conditionControl == null ? other$conditionControl != null : !this$conditionControl.equals(other$conditionControl)) {
                return false;
            }
            String this$conditionInactiveReason = this.conditionInactiveReason;
            String other$conditionInactiveReason = other.conditionInactiveReason;
            if (this$conditionInactiveReason == null ? other$conditionInactiveReason != null : !this$conditionInactiveReason.equals(other$conditionInactiveReason)) {
                return false;
            }
            String this$conditionClass = this.conditionClass;
            String other$conditionClass = other.conditionClass;
            if (this$conditionClass == null ? other$conditionClass != null : !this$conditionClass.equals(other$conditionClass)) {
                return false;
            }
            String this$prcgProcedureCounterForHeader = this.prcgProcedureCounterForHeader;
            String other$prcgProcedureCounterForHeader = other.prcgProcedureCounterForHeader;
            if (this$prcgProcedureCounterForHeader == null ? other$prcgProcedureCounterForHeader != null : !this$prcgProcedureCounterForHeader.equals(other$prcgProcedureCounterForHeader)) {
                return false;
            }
            Double this$factorForConditionBasisValue = this.factorForConditionBasisValue;
            Double other$factorForConditionBasisValue = other.factorForConditionBasisValue;
            if (this$factorForConditionBasisValue == null ? other$factorForConditionBasisValue != null : !((Object)this$factorForConditionBasisValue).equals(other$factorForConditionBasisValue)) {
                return false;
            }
            String this$structureCondition = this.structureCondition;
            String other$structureCondition = other.structureCondition;
            if (this$structureCondition == null ? other$structureCondition != null : !this$structureCondition.equals(other$structureCondition)) {
                return false;
            }
            Double this$periodFactorForCndnBasisValue = this.periodFactorForCndnBasisValue;
            Double other$periodFactorForCndnBasisValue = other.periodFactorForCndnBasisValue;
            if (this$periodFactorForCndnBasisValue == null ? other$periodFactorForCndnBasisValue != null : !((Object)this$periodFactorForCndnBasisValue).equals(other$periodFactorForCndnBasisValue)) {
                return false;
            }
            String this$pricingScaleBasis = this.pricingScaleBasis;
            String other$pricingScaleBasis = other.pricingScaleBasis;
            if (this$pricingScaleBasis == null ? other$pricingScaleBasis != null : !this$pricingScaleBasis.equals(other$pricingScaleBasis)) {
                return false;
            }
            BigDecimal this$conditionScaleBasisValue = this.conditionScaleBasisValue;
            BigDecimal other$conditionScaleBasisValue = other.conditionScaleBasisValue;
            if (this$conditionScaleBasisValue == null ? other$conditionScaleBasisValue != null : !((Object)this$conditionScaleBasisValue).equals(other$conditionScaleBasisValue)) {
                return false;
            }
            String this$pricingProcedureCounter = this.pricingProcedureCounter;
            String other$pricingProcedureCounter = other.pricingProcedureCounter;
            if (this$pricingProcedureCounter == null ? other$pricingProcedureCounter != null : !this$pricingProcedureCounter.equals(other$pricingProcedureCounter)) {
                return false;
            }
            String this$conditionScaleBasisUnit = this.conditionScaleBasisUnit;
            String other$conditionScaleBasisUnit = other.conditionScaleBasisUnit;
            if (this$conditionScaleBasisUnit == null ? other$conditionScaleBasisUnit != null : !this$conditionScaleBasisUnit.equals(other$conditionScaleBasisUnit)) {
                return false;
            }
            String this$conditionScaleBasisCurrency = this.conditionScaleBasisCurrency;
            String other$conditionScaleBasisCurrency = other.conditionScaleBasisCurrency;
            if (this$conditionScaleBasisCurrency == null ? other$conditionScaleBasisCurrency != null : !this$conditionScaleBasisCurrency.equals(other$conditionScaleBasisCurrency)) {
                return false;
            }
            String this$conditionAlternativeCurrency = this.conditionAlternativeCurrency;
            String other$conditionAlternativeCurrency = other.conditionAlternativeCurrency;
            if (this$conditionAlternativeCurrency == null ? other$conditionAlternativeCurrency != null : !this$conditionAlternativeCurrency.equals(other$conditionAlternativeCurrency)) {
                return false;
            }
            BigDecimal this$conditionAmountInLocalCrcy = this.conditionAmountInLocalCrcy;
            BigDecimal other$conditionAmountInLocalCrcy = other.conditionAmountInLocalCrcy;
            if (this$conditionAmountInLocalCrcy == null ? other$conditionAmountInLocalCrcy != null : !((Object)this$conditionAmountInLocalCrcy).equals(other$conditionAmountInLocalCrcy)) {
                return false;
            }
            Boolean this$cndnIsRelevantForIntcoBilling = this.cndnIsRelevantForIntcoBilling;
            Boolean other$cndnIsRelevantForIntcoBilling = other.cndnIsRelevantForIntcoBilling;
            if (this$cndnIsRelevantForIntcoBilling == null ? other$cndnIsRelevantForIntcoBilling != null : !((Object)this$cndnIsRelevantForIntcoBilling).equals(other$cndnIsRelevantForIntcoBilling)) {
                return false;
            }
            Boolean this$conditionIsManuallyChanged = this.conditionIsManuallyChanged;
            Boolean other$conditionIsManuallyChanged = other.conditionIsManuallyChanged;
            if (this$conditionIsManuallyChanged == null ? other$conditionIsManuallyChanged != null : !((Object)this$conditionIsManuallyChanged).equals(other$conditionIsManuallyChanged)) {
                return false;
            }
            BigDecimal this$cumulatedConditionBasisValue = this.cumulatedConditionBasisValue;
            BigDecimal other$cumulatedConditionBasisValue = other.cumulatedConditionBasisValue;
            if (this$cumulatedConditionBasisValue == null ? other$cumulatedConditionBasisValue != null : !((Object)this$cumulatedConditionBasisValue).equals(other$cumulatedConditionBasisValue)) {
                return false;
            }
            Boolean this$conditionIsForConfiguration = this.conditionIsForConfiguration;
            Boolean other$conditionIsForConfiguration = other.conditionIsForConfiguration;
            if (this$conditionIsForConfiguration == null ? other$conditionIsForConfiguration != null : !((Object)this$conditionIsForConfiguration).equals(other$conditionIsForConfiguration)) {
                return false;
            }
            String this$variantCondition = this.variantCondition;
            String other$variantCondition = other.variantCondition;
            if (this$variantCondition == null ? other$variantCondition != null : !this$variantCondition.equals(other$variantCondition)) {
                return false;
            }
            String this$conditionApplication = this.conditionApplication;
            String other$conditionApplication = other.conditionApplication;
            if (this$conditionApplication == null ? other$conditionApplication != null : !this$conditionApplication.equals(other$conditionApplication)) {
                return false;
            }
            String this$conditionType = this.conditionType;
            String other$conditionType = other.conditionType;
            if (this$conditionType == null ? other$conditionType != null : !this$conditionType.equals(other$conditionType)) {
                return false;
            }
            String this$pricingDateTime = this.pricingDateTime;
            String other$pricingDateTime = other.pricingDateTime;
            if (this$pricingDateTime == null ? other$pricingDateTime != null : !this$pricingDateTime.equals(other$pricingDateTime)) {
                return false;
            }
            String this$conditionCalculationType = this.conditionCalculationType;
            String other$conditionCalculationType = other.conditionCalculationType;
            if (this$conditionCalculationType == null ? other$conditionCalculationType != null : !this$conditionCalculationType.equals(other$conditionCalculationType)) {
                return false;
            }
            BigDecimal this$conditionBaseValue = this.conditionBaseValue;
            BigDecimal other$conditionBaseValue = other.conditionBaseValue;
            return !(this$conditionBaseValue == null ? other$conditionBaseValue != null : !((Object)this$conditionBaseValue).equals(other$conditionBaseValue));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DebitMemoReqItemPrcgElmnt;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $debitMemoRequest = this.debitMemoRequest;
            result = result * 59 + ($debitMemoRequest == null ? 43 : $debitMemoRequest.hashCode());
            BigDecimal $conditionRateValue = this.conditionRateValue;
            result = result * 59 + ($conditionRateValue == null ? 43 : ((Object)$conditionRateValue).hashCode());
            String $conditionCurrency = this.conditionCurrency;
            result = result * 59 + ($conditionCurrency == null ? 43 : $conditionCurrency.hashCode());
            BigDecimal $conditionQuantity = this.conditionQuantity;
            result = result * 59 + ($conditionQuantity == null ? 43 : ((Object)$conditionQuantity).hashCode());
            String $conditionQuantityUnit = this.conditionQuantityUnit;
            result = result * 59 + ($conditionQuantityUnit == null ? 43 : $conditionQuantityUnit.hashCode());
            BigDecimal $conditionToBaseQtyNmrtr = this.conditionToBaseQtyNmrtr;
            result = result * 59 + ($conditionToBaseQtyNmrtr == null ? 43 : ((Object)$conditionToBaseQtyNmrtr).hashCode());
            BigDecimal $conditionToBaseQtyDnmntr = this.conditionToBaseQtyDnmntr;
            result = result * 59 + ($conditionToBaseQtyDnmntr == null ? 43 : ((Object)$conditionToBaseQtyDnmntr).hashCode());
            String $conditionCategory = this.conditionCategory;
            result = result * 59 + ($conditionCategory == null ? 43 : $conditionCategory.hashCode());
            Boolean $conditionIsForStatistics = this.conditionIsForStatistics;
            result = result * 59 + ($conditionIsForStatistics == null ? 43 : ((Object)$conditionIsForStatistics).hashCode());
            String $pricingScaleType = this.pricingScaleType;
            result = result * 59 + ($pricingScaleType == null ? 43 : $pricingScaleType.hashCode());
            Boolean $isRelevantForAccrual = this.isRelevantForAccrual;
            result = result * 59 + ($isRelevantForAccrual == null ? 43 : ((Object)$isRelevantForAccrual).hashCode());
            String $debitMemoRequestItem = this.debitMemoRequestItem;
            result = result * 59 + ($debitMemoRequestItem == null ? 43 : $debitMemoRequestItem.hashCode());
            String $cndnIsRelevantForInvoiceList = this.cndnIsRelevantForInvoiceList;
            result = result * 59 + ($cndnIsRelevantForInvoiceList == null ? 43 : $cndnIsRelevantForInvoiceList.hashCode());
            String $conditionOrigin = this.conditionOrigin;
            result = result * 59 + ($conditionOrigin == null ? 43 : $conditionOrigin.hashCode());
            String $isGroupCondition = this.isGroupCondition;
            result = result * 59 + ($isGroupCondition == null ? 43 : $isGroupCondition.hashCode());
            String $accessNumberOfAccessSequence = this.accessNumberOfAccessSequence;
            result = result * 59 + ($accessNumberOfAccessSequence == null ? 43 : $accessNumberOfAccessSequence.hashCode());
            String $conditionRecord = this.conditionRecord;
            result = result * 59 + ($conditionRecord == null ? 43 : $conditionRecord.hashCode());
            String $conditionSequentialNumber = this.conditionSequentialNumber;
            result = result * 59 + ($conditionSequentialNumber == null ? 43 : $conditionSequentialNumber.hashCode());
            String $taxCode = this.taxCode;
            result = result * 59 + ($taxCode == null ? 43 : $taxCode.hashCode());
            String $withholdingTaxCode = this.withholdingTaxCode;
            result = result * 59 + ($withholdingTaxCode == null ? 43 : $withholdingTaxCode.hashCode());
            BigDecimal $cndnRoundingOffDiffAmount = this.cndnRoundingOffDiffAmount;
            result = result * 59 + ($cndnRoundingOffDiffAmount == null ? 43 : ((Object)$cndnRoundingOffDiffAmount).hashCode());
            BigDecimal $conditionAmount = this.conditionAmount;
            result = result * 59 + ($conditionAmount == null ? 43 : ((Object)$conditionAmount).hashCode());
            String $pricingProcedureStep = this.pricingProcedureStep;
            result = result * 59 + ($pricingProcedureStep == null ? 43 : $pricingProcedureStep.hashCode());
            String $transactionCurrency = this.transactionCurrency;
            result = result * 59 + ($transactionCurrency == null ? 43 : $transactionCurrency.hashCode());
            String $conditionControl = this.conditionControl;
            result = result * 59 + ($conditionControl == null ? 43 : $conditionControl.hashCode());
            String $conditionInactiveReason = this.conditionInactiveReason;
            result = result * 59 + ($conditionInactiveReason == null ? 43 : $conditionInactiveReason.hashCode());
            String $conditionClass = this.conditionClass;
            result = result * 59 + ($conditionClass == null ? 43 : $conditionClass.hashCode());
            String $prcgProcedureCounterForHeader = this.prcgProcedureCounterForHeader;
            result = result * 59 + ($prcgProcedureCounterForHeader == null ? 43 : $prcgProcedureCounterForHeader.hashCode());
            Double $factorForConditionBasisValue = this.factorForConditionBasisValue;
            result = result * 59 + ($factorForConditionBasisValue == null ? 43 : ((Object)$factorForConditionBasisValue).hashCode());
            String $structureCondition = this.structureCondition;
            result = result * 59 + ($structureCondition == null ? 43 : $structureCondition.hashCode());
            Double $periodFactorForCndnBasisValue = this.periodFactorForCndnBasisValue;
            result = result * 59 + ($periodFactorForCndnBasisValue == null ? 43 : ((Object)$periodFactorForCndnBasisValue).hashCode());
            String $pricingScaleBasis = this.pricingScaleBasis;
            result = result * 59 + ($pricingScaleBasis == null ? 43 : $pricingScaleBasis.hashCode());
            BigDecimal $conditionScaleBasisValue = this.conditionScaleBasisValue;
            result = result * 59 + ($conditionScaleBasisValue == null ? 43 : ((Object)$conditionScaleBasisValue).hashCode());
            String $pricingProcedureCounter = this.pricingProcedureCounter;
            result = result * 59 + ($pricingProcedureCounter == null ? 43 : $pricingProcedureCounter.hashCode());
            String $conditionScaleBasisUnit = this.conditionScaleBasisUnit;
            result = result * 59 + ($conditionScaleBasisUnit == null ? 43 : $conditionScaleBasisUnit.hashCode());
            String $conditionScaleBasisCurrency = this.conditionScaleBasisCurrency;
            result = result * 59 + ($conditionScaleBasisCurrency == null ? 43 : $conditionScaleBasisCurrency.hashCode());
            String $conditionAlternativeCurrency = this.conditionAlternativeCurrency;
            result = result * 59 + ($conditionAlternativeCurrency == null ? 43 : $conditionAlternativeCurrency.hashCode());
            BigDecimal $conditionAmountInLocalCrcy = this.conditionAmountInLocalCrcy;
            result = result * 59 + ($conditionAmountInLocalCrcy == null ? 43 : ((Object)$conditionAmountInLocalCrcy).hashCode());
            Boolean $cndnIsRelevantForIntcoBilling = this.cndnIsRelevantForIntcoBilling;
            result = result * 59 + ($cndnIsRelevantForIntcoBilling == null ? 43 : ((Object)$cndnIsRelevantForIntcoBilling).hashCode());
            Boolean $conditionIsManuallyChanged = this.conditionIsManuallyChanged;
            result = result * 59 + ($conditionIsManuallyChanged == null ? 43 : ((Object)$conditionIsManuallyChanged).hashCode());
            BigDecimal $cumulatedConditionBasisValue = this.cumulatedConditionBasisValue;
            result = result * 59 + ($cumulatedConditionBasisValue == null ? 43 : ((Object)$cumulatedConditionBasisValue).hashCode());
            Boolean $conditionIsForConfiguration = this.conditionIsForConfiguration;
            result = result * 59 + ($conditionIsForConfiguration == null ? 43 : ((Object)$conditionIsForConfiguration).hashCode());
            String $variantCondition = this.variantCondition;
            result = result * 59 + ($variantCondition == null ? 43 : $variantCondition.hashCode());
            String $conditionApplication = this.conditionApplication;
            result = result * 59 + ($conditionApplication == null ? 43 : $conditionApplication.hashCode());
            String $conditionType = this.conditionType;
            result = result * 59 + ($conditionType == null ? 43 : $conditionType.hashCode());
            String $pricingDateTime = this.pricingDateTime;
            result = result * 59 + ($pricingDateTime == null ? 43 : $pricingDateTime.hashCode());
            String $conditionCalculationType = this.conditionCalculationType;
            result = result * 59 + ($conditionCalculationType == null ? 43 : $conditionCalculationType.hashCode());
            BigDecimal $conditionBaseValue = this.conditionBaseValue;
            result = result * 59 + ($conditionBaseValue == null ? 43 : ((Object)$conditionBaseValue).hashCode());
            return result;
        }

        public String getDebitMemoRequest() {
            return this.debitMemoRequest;
        }

        public DebitMemoReqItemPrcgElmnt setDebitMemoRequest(String debitMemoRequest) {
            this.debitMemoRequest = debitMemoRequest;
            return this;
        }

        public BigDecimal getConditionRateValue() {
            return this.conditionRateValue;
        }

        public DebitMemoReqItemPrcgElmnt setConditionRateValue(BigDecimal conditionRateValue) {
            this.conditionRateValue = conditionRateValue;
            return this;
        }

        public String getConditionCurrency() {
            return this.conditionCurrency;
        }

        public DebitMemoReqItemPrcgElmnt setConditionCurrency(String conditionCurrency) {
            this.conditionCurrency = conditionCurrency;
            return this;
        }

        public BigDecimal getConditionQuantity() {
            return this.conditionQuantity;
        }

        public DebitMemoReqItemPrcgElmnt setConditionQuantity(BigDecimal conditionQuantity) {
            this.conditionQuantity = conditionQuantity;
            return this;
        }

        public String getConditionQuantityUnit() {
            return this.conditionQuantityUnit;
        }

        public DebitMemoReqItemPrcgElmnt setConditionQuantityUnit(String conditionQuantityUnit) {
            this.conditionQuantityUnit = conditionQuantityUnit;
            return this;
        }

        public BigDecimal getConditionToBaseQtyNmrtr() {
            return this.conditionToBaseQtyNmrtr;
        }

        public DebitMemoReqItemPrcgElmnt setConditionToBaseQtyNmrtr(BigDecimal conditionToBaseQtyNmrtr) {
            this.conditionToBaseQtyNmrtr = conditionToBaseQtyNmrtr;
            return this;
        }

        public BigDecimal getConditionToBaseQtyDnmntr() {
            return this.conditionToBaseQtyDnmntr;
        }

        public DebitMemoReqItemPrcgElmnt setConditionToBaseQtyDnmntr(BigDecimal conditionToBaseQtyDnmntr) {
            this.conditionToBaseQtyDnmntr = conditionToBaseQtyDnmntr;
            return this;
        }

        public String getConditionCategory() {
            return this.conditionCategory;
        }

        public DebitMemoReqItemPrcgElmnt setConditionCategory(String conditionCategory) {
            this.conditionCategory = conditionCategory;
            return this;
        }

        public Boolean getConditionIsForStatistics() {
            return this.conditionIsForStatistics;
        }

        public DebitMemoReqItemPrcgElmnt setConditionIsForStatistics(Boolean conditionIsForStatistics) {
            this.conditionIsForStatistics = conditionIsForStatistics;
            return this;
        }

        public String getPricingScaleType() {
            return this.pricingScaleType;
        }

        public DebitMemoReqItemPrcgElmnt setPricingScaleType(String pricingScaleType) {
            this.pricingScaleType = pricingScaleType;
            return this;
        }

        public Boolean getIsRelevantForAccrual() {
            return this.isRelevantForAccrual;
        }

        public DebitMemoReqItemPrcgElmnt setIsRelevantForAccrual(Boolean isRelevantForAccrual) {
            this.isRelevantForAccrual = isRelevantForAccrual;
            return this;
        }

        public String getDebitMemoRequestItem() {
            return this.debitMemoRequestItem;
        }

        public DebitMemoReqItemPrcgElmnt setDebitMemoRequestItem(String debitMemoRequestItem) {
            this.debitMemoRequestItem = debitMemoRequestItem;
            return this;
        }

        public String getCndnIsRelevantForInvoiceList() {
            return this.cndnIsRelevantForInvoiceList;
        }

        public DebitMemoReqItemPrcgElmnt setCndnIsRelevantForInvoiceList(String cndnIsRelevantForInvoiceList) {
            this.cndnIsRelevantForInvoiceList = cndnIsRelevantForInvoiceList;
            return this;
        }

        public String getConditionOrigin() {
            return this.conditionOrigin;
        }

        public DebitMemoReqItemPrcgElmnt setConditionOrigin(String conditionOrigin) {
            this.conditionOrigin = conditionOrigin;
            return this;
        }

        public String getIsGroupCondition() {
            return this.isGroupCondition;
        }

        public DebitMemoReqItemPrcgElmnt setIsGroupCondition(String isGroupCondition) {
            this.isGroupCondition = isGroupCondition;
            return this;
        }

        public String getAccessNumberOfAccessSequence() {
            return this.accessNumberOfAccessSequence;
        }

        public DebitMemoReqItemPrcgElmnt setAccessNumberOfAccessSequence(String accessNumberOfAccessSequence) {
            this.accessNumberOfAccessSequence = accessNumberOfAccessSequence;
            return this;
        }

        public String getConditionRecord() {
            return this.conditionRecord;
        }

        public DebitMemoReqItemPrcgElmnt setConditionRecord(String conditionRecord) {
            this.conditionRecord = conditionRecord;
            return this;
        }

        public String getConditionSequentialNumber() {
            return this.conditionSequentialNumber;
        }

        public DebitMemoReqItemPrcgElmnt setConditionSequentialNumber(String conditionSequentialNumber) {
            this.conditionSequentialNumber = conditionSequentialNumber;
            return this;
        }

        public String getTaxCode() {
            return this.taxCode;
        }

        public DebitMemoReqItemPrcgElmnt setTaxCode(String taxCode) {
            this.taxCode = taxCode;
            return this;
        }

        public String getWithholdingTaxCode() {
            return this.withholdingTaxCode;
        }

        public DebitMemoReqItemPrcgElmnt setWithholdingTaxCode(String withholdingTaxCode) {
            this.withholdingTaxCode = withholdingTaxCode;
            return this;
        }

        public BigDecimal getCndnRoundingOffDiffAmount() {
            return this.cndnRoundingOffDiffAmount;
        }

        public DebitMemoReqItemPrcgElmnt setCndnRoundingOffDiffAmount(BigDecimal cndnRoundingOffDiffAmount) {
            this.cndnRoundingOffDiffAmount = cndnRoundingOffDiffAmount;
            return this;
        }

        public BigDecimal getConditionAmount() {
            return this.conditionAmount;
        }

        public DebitMemoReqItemPrcgElmnt setConditionAmount(BigDecimal conditionAmount) {
            this.conditionAmount = conditionAmount;
            return this;
        }

        public String getPricingProcedureStep() {
            return this.pricingProcedureStep;
        }

        public DebitMemoReqItemPrcgElmnt setPricingProcedureStep(String pricingProcedureStep) {
            this.pricingProcedureStep = pricingProcedureStep;
            return this;
        }

        public String getTransactionCurrency() {
            return this.transactionCurrency;
        }

        public DebitMemoReqItemPrcgElmnt setTransactionCurrency(String transactionCurrency) {
            this.transactionCurrency = transactionCurrency;
            return this;
        }

        public String getConditionControl() {
            return this.conditionControl;
        }

        public DebitMemoReqItemPrcgElmnt setConditionControl(String conditionControl) {
            this.conditionControl = conditionControl;
            return this;
        }

        public String getConditionInactiveReason() {
            return this.conditionInactiveReason;
        }

        public DebitMemoReqItemPrcgElmnt setConditionInactiveReason(String conditionInactiveReason) {
            this.conditionInactiveReason = conditionInactiveReason;
            return this;
        }

        public String getConditionClass() {
            return this.conditionClass;
        }

        public DebitMemoReqItemPrcgElmnt setConditionClass(String conditionClass) {
            this.conditionClass = conditionClass;
            return this;
        }

        public String getPrcgProcedureCounterForHeader() {
            return this.prcgProcedureCounterForHeader;
        }

        public DebitMemoReqItemPrcgElmnt setPrcgProcedureCounterForHeader(String prcgProcedureCounterForHeader) {
            this.prcgProcedureCounterForHeader = prcgProcedureCounterForHeader;
            return this;
        }

        public Double getFactorForConditionBasisValue() {
            return this.factorForConditionBasisValue;
        }

        public DebitMemoReqItemPrcgElmnt setFactorForConditionBasisValue(Double factorForConditionBasisValue) {
            this.factorForConditionBasisValue = factorForConditionBasisValue;
            return this;
        }

        public String getStructureCondition() {
            return this.structureCondition;
        }

        public DebitMemoReqItemPrcgElmnt setStructureCondition(String structureCondition) {
            this.structureCondition = structureCondition;
            return this;
        }

        public Double getPeriodFactorForCndnBasisValue() {
            return this.periodFactorForCndnBasisValue;
        }

        public DebitMemoReqItemPrcgElmnt setPeriodFactorForCndnBasisValue(Double periodFactorForCndnBasisValue) {
            this.periodFactorForCndnBasisValue = periodFactorForCndnBasisValue;
            return this;
        }

        public String getPricingScaleBasis() {
            return this.pricingScaleBasis;
        }

        public DebitMemoReqItemPrcgElmnt setPricingScaleBasis(String pricingScaleBasis) {
            this.pricingScaleBasis = pricingScaleBasis;
            return this;
        }

        public BigDecimal getConditionScaleBasisValue() {
            return this.conditionScaleBasisValue;
        }

        public DebitMemoReqItemPrcgElmnt setConditionScaleBasisValue(BigDecimal conditionScaleBasisValue) {
            this.conditionScaleBasisValue = conditionScaleBasisValue;
            return this;
        }

        public String getPricingProcedureCounter() {
            return this.pricingProcedureCounter;
        }

        public DebitMemoReqItemPrcgElmnt setPricingProcedureCounter(String pricingProcedureCounter) {
            this.pricingProcedureCounter = pricingProcedureCounter;
            return this;
        }

        public String getConditionScaleBasisUnit() {
            return this.conditionScaleBasisUnit;
        }

        public DebitMemoReqItemPrcgElmnt setConditionScaleBasisUnit(String conditionScaleBasisUnit) {
            this.conditionScaleBasisUnit = conditionScaleBasisUnit;
            return this;
        }

        public String getConditionScaleBasisCurrency() {
            return this.conditionScaleBasisCurrency;
        }

        public DebitMemoReqItemPrcgElmnt setConditionScaleBasisCurrency(String conditionScaleBasisCurrency) {
            this.conditionScaleBasisCurrency = conditionScaleBasisCurrency;
            return this;
        }

        public String getConditionAlternativeCurrency() {
            return this.conditionAlternativeCurrency;
        }

        public DebitMemoReqItemPrcgElmnt setConditionAlternativeCurrency(String conditionAlternativeCurrency) {
            this.conditionAlternativeCurrency = conditionAlternativeCurrency;
            return this;
        }

        public BigDecimal getConditionAmountInLocalCrcy() {
            return this.conditionAmountInLocalCrcy;
        }

        public DebitMemoReqItemPrcgElmnt setConditionAmountInLocalCrcy(BigDecimal conditionAmountInLocalCrcy) {
            this.conditionAmountInLocalCrcy = conditionAmountInLocalCrcy;
            return this;
        }

        public Boolean getCndnIsRelevantForIntcoBilling() {
            return this.cndnIsRelevantForIntcoBilling;
        }

        public DebitMemoReqItemPrcgElmnt setCndnIsRelevantForIntcoBilling(Boolean cndnIsRelevantForIntcoBilling) {
            this.cndnIsRelevantForIntcoBilling = cndnIsRelevantForIntcoBilling;
            return this;
        }

        public Boolean getConditionIsManuallyChanged() {
            return this.conditionIsManuallyChanged;
        }

        public DebitMemoReqItemPrcgElmnt setConditionIsManuallyChanged(Boolean conditionIsManuallyChanged) {
            this.conditionIsManuallyChanged = conditionIsManuallyChanged;
            return this;
        }

        public BigDecimal getCumulatedConditionBasisValue() {
            return this.cumulatedConditionBasisValue;
        }

        public DebitMemoReqItemPrcgElmnt setCumulatedConditionBasisValue(BigDecimal cumulatedConditionBasisValue) {
            this.cumulatedConditionBasisValue = cumulatedConditionBasisValue;
            return this;
        }

        public Boolean getConditionIsForConfiguration() {
            return this.conditionIsForConfiguration;
        }

        public DebitMemoReqItemPrcgElmnt setConditionIsForConfiguration(Boolean conditionIsForConfiguration) {
            this.conditionIsForConfiguration = conditionIsForConfiguration;
            return this;
        }

        public String getVariantCondition() {
            return this.variantCondition;
        }

        public DebitMemoReqItemPrcgElmnt setVariantCondition(String variantCondition) {
            this.variantCondition = variantCondition;
            return this;
        }

        public String getConditionApplication() {
            return this.conditionApplication;
        }

        public DebitMemoReqItemPrcgElmnt setConditionApplication(String conditionApplication) {
            this.conditionApplication = conditionApplication;
            return this;
        }

        public String getConditionType() {
            return this.conditionType;
        }

        public DebitMemoReqItemPrcgElmnt setConditionType(String conditionType) {
            this.conditionType = conditionType;
            return this;
        }

        public String getPricingDateTime() {
            return this.pricingDateTime;
        }

        public DebitMemoReqItemPrcgElmnt setPricingDateTime(String pricingDateTime) {
            this.pricingDateTime = pricingDateTime;
            return this;
        }

        public String getConditionCalculationType() {
            return this.conditionCalculationType;
        }

        public DebitMemoReqItemPrcgElmnt setConditionCalculationType(String conditionCalculationType) {
            this.conditionCalculationType = conditionCalculationType;
            return this;
        }

        public BigDecimal getConditionBaseValue() {
            return this.conditionBaseValue;
        }

        public DebitMemoReqItemPrcgElmnt setConditionBaseValue(BigDecimal conditionBaseValue) {
            this.conditionBaseValue = conditionBaseValue;
            return this;
        }

        public DebitMemoReqItemPrcgElmnt setErpConfigContext(ErpConfigContext erpConfigContext) {
            this.erpConfigContext = erpConfigContext;
            return this;
        }
    }

    public static class DebitMemoReqItemPartnerFluentHelper {
        private ODataQueryBuilder queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_DEBIT_MEMO_REQUEST_SRV", (String)"A_DebitMemoReqItemPartner");
        private ErrorResultHandler<?> errorResultHandler = new ODataVdmErrorResultHandler();

        public DebitMemoReqItemPartnerFluentHelper filter(ExpressionFluentHelper<DebitMemoReqItemPartner> expression) {
            for (FilterExpressionWrapper<?> filterExpressionWrapper : expression.evaluate()) {
                Object comparisonValue = filterExpressionWrapper.getComparisonValue();
                if (comparisonValue instanceof Integer) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Integer)((Integer)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof String) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((String)((String)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Long) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Long)((Long)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Double) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Double)((Double)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Float) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Float)((Float)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDate) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDate)((LocalDate)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDateTime)((LocalDateTime)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Date) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Date)((Date)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof DateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((DateTime)((DateTime)comparisonValue))));
                    continue;
                }
                this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of(comparisonValue)));
            }
            return this;
        }

        public DebitMemoReqItemPartnerFluentHelper orderBy(EntityField<?, DebitMemoReqItemPartner> field, Order order) {
            String orderingDirection = order == Order.ASC ? " asc" : " desc";
            this.queryBuilder.param("orderby", (Object)(field.getFieldName() + orderingDirection));
            return this;
        }

        @SafeVarargs
        public final DebitMemoReqItemPartnerFluentHelper select(EntityField<?, DebitMemoReqItemPartner> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public DebitMemoReqItemPartnerFluentHelper top(Number top) {
            this.queryBuilder.top(top);
            return this;
        }

        public DebitMemoReqItemPartnerFluentHelper skip(Number skip) {
            this.queryBuilder.skip(skip);
            return this;
        }

        public DebitMemoReqItemPartnerFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.errorHandler(this.errorResultHandler).build();
        }

        public List<DebitMemoReqItemPartner> execute(ErpConfigContext erpConfigContext) throws ODataException {
            List entityList = this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).asList(DebitMemoReqItemPartner.class);
            for (DebitMemoReqItemPartner entity : entityList) {
                entity.setErpConfigContext(erpConfigContext);
            }
            return entityList;
        }
    }

    public static class DebitMemoReqItemPartnerByKeyFluentHelper {
        private ODataQueryBuilder queryBuilder;
        private ErrorResultHandler<?> errorResultHandler;
        private List<Object> values = new LinkedList<Object>();

        public DebitMemoReqItemPartnerByKeyFluentHelper(String debitMemoRequest, String debitMemoRequestItem, String partnerFunction) {
            this.values.add(debitMemoRequest);
            this.values.add(debitMemoRequestItem);
            this.values.add(partnerFunction);
            this.queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_DEBIT_MEMO_REQUEST_SRV", (String)"A_DebitMemoReqItemPartner");
            HashMap<String, Object> keys = new HashMap<String, Object>();
            keys.put("DebitMemoRequest", this.values.get(0));
            keys.put("DebitMemoRequestItem", this.values.get(1));
            keys.put("PartnerFunction", this.values.get(2));
            this.queryBuilder.keys(keys);
        }

        @SafeVarargs
        public final DebitMemoReqItemPartnerByKeyFluentHelper select(EntityField<?, DebitMemoReqItemPartner> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.build();
        }

        public DebitMemoReqItemPartnerByKeyFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public DebitMemoReqItemPartner execute(ErpConfigContext erpConfigContext) throws ODataException {
            DebitMemoReqItemPartner entity = (DebitMemoReqItemPartner)this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).as(DebitMemoReqItemPartner.class);
            entity.setErpConfigContext(erpConfigContext);
            return entity;
        }
    }

    public static class DebitMemoReqItemPartner {
        @ElementName(value="DebitMemoRequest")
        private String debitMemoRequest;
        public static EntityField<String, DebitMemoReqItemPartner> DEBIT_MEMO_REQUEST = new EntityField("DebitMemoRequest");
        @ElementName(value="DebitMemoRequestItem")
        private String debitMemoRequestItem;
        public static EntityField<String, DebitMemoReqItemPartner> DEBIT_MEMO_REQUEST_ITEM = new EntityField("DebitMemoRequestItem");
        @ElementName(value="PartnerFunction")
        private String partnerFunction;
        public static EntityField<String, DebitMemoReqItemPartner> PARTNER_FUNCTION = new EntityField("PartnerFunction");
        @ElementName(value="Customer")
        private String customer;
        public static EntityField<String, DebitMemoReqItemPartner> CUSTOMER = new EntityField("Customer");
        @ElementName(value="Supplier")
        private String supplier;
        public static EntityField<String, DebitMemoReqItemPartner> SUPPLIER = new EntityField("Supplier");
        @ElementName(value="Personnel")
        private String personnel;
        public static EntityField<String, DebitMemoReqItemPartner> PERSONNEL = new EntityField("Personnel");
        @ElementName(value="ContactPerson")
        private String contactPerson;
        public static EntityField<String, DebitMemoReqItemPartner> CONTACT_PERSON = new EntityField("ContactPerson");
        private static final transient String ODATA_ENDPOINT_URL = "/sap/opu/odata/sap/API_DEBIT_MEMO_REQUEST_SRV";
        private static final transient String ODATA_ENTITY_COLLECTION = "A_DebitMemoReqItemPartner";
        private transient ErpConfigContext erpConfigContext;

        @JsonIgnore
        public DebitMemoRequest fetchDebitMemoRequest() throws ODataException {
            StringBuilder odataResourceUrl = new StringBuilder(ODATA_ENTITY_COLLECTION);
            odataResourceUrl.append("(");
            odataResourceUrl.append("DebitMemoRequest=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.debitMemoRequest));
            odataResourceUrl.append(",DebitMemoRequestItem=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.debitMemoRequestItem));
            odataResourceUrl.append(",PartnerFunction=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.partnerFunction));
            odataResourceUrl.append(")/");
            odataResourceUrl.append("to_DebitMemoRequest");
            ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)ODATA_ENDPOINT_URL, (String)odataResourceUrl.toString());
            ODataQuery query = builder.build();
            ErpEndpoint erpEndpoint = new ErpEndpoint(this.erpConfigContext);
            ODataQueryResult result = query.execute((WithDestinationName)erpEndpoint);
            DebitMemoRequest entityList = (DebitMemoRequest)result.as(DebitMemoRequest.class);
            entityList.setErpConfigContext(this.erpConfigContext);
            return entityList;
        }

        @JsonIgnore
        public DebitMemoRequestItem fetchDebitMemoRequestItem() throws ODataException {
            StringBuilder odataResourceUrl = new StringBuilder(ODATA_ENTITY_COLLECTION);
            odataResourceUrl.append("(");
            odataResourceUrl.append("DebitMemoRequest=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.debitMemoRequest));
            odataResourceUrl.append(",DebitMemoRequestItem=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.debitMemoRequestItem));
            odataResourceUrl.append(",PartnerFunction=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.partnerFunction));
            odataResourceUrl.append(")/");
            odataResourceUrl.append("to_DebitMemoRequestItem");
            ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)ODATA_ENDPOINT_URL, (String)odataResourceUrl.toString());
            ODataQuery query = builder.build();
            ErpEndpoint erpEndpoint = new ErpEndpoint(this.erpConfigContext);
            ODataQueryResult result = query.execute((WithDestinationName)erpEndpoint);
            DebitMemoRequestItem entityList = (DebitMemoRequestItem)result.as(DebitMemoRequestItem.class);
            entityList.setErpConfigContext(this.erpConfigContext);
            return entityList;
        }

        public String toString() {
            return "ReadDebitMemoRequestsNamespace.DebitMemoReqItemPartner(debitMemoRequest=" + this.debitMemoRequest + ", debitMemoRequestItem=" + this.debitMemoRequestItem + ", partnerFunction=" + this.partnerFunction + ", customer=" + this.customer + ", supplier=" + this.supplier + ", personnel=" + this.personnel + ", contactPerson=" + this.contactPerson + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DebitMemoReqItemPartner)) {
                return false;
            }
            DebitMemoReqItemPartner other = (DebitMemoReqItemPartner)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$debitMemoRequest = this.debitMemoRequest;
            String other$debitMemoRequest = other.debitMemoRequest;
            if (this$debitMemoRequest == null ? other$debitMemoRequest != null : !this$debitMemoRequest.equals(other$debitMemoRequest)) {
                return false;
            }
            String this$debitMemoRequestItem = this.debitMemoRequestItem;
            String other$debitMemoRequestItem = other.debitMemoRequestItem;
            if (this$debitMemoRequestItem == null ? other$debitMemoRequestItem != null : !this$debitMemoRequestItem.equals(other$debitMemoRequestItem)) {
                return false;
            }
            String this$partnerFunction = this.partnerFunction;
            String other$partnerFunction = other.partnerFunction;
            if (this$partnerFunction == null ? other$partnerFunction != null : !this$partnerFunction.equals(other$partnerFunction)) {
                return false;
            }
            String this$customer = this.customer;
            String other$customer = other.customer;
            if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
                return false;
            }
            String this$supplier = this.supplier;
            String other$supplier = other.supplier;
            if (this$supplier == null ? other$supplier != null : !this$supplier.equals(other$supplier)) {
                return false;
            }
            String this$personnel = this.personnel;
            String other$personnel = other.personnel;
            if (this$personnel == null ? other$personnel != null : !this$personnel.equals(other$personnel)) {
                return false;
            }
            String this$contactPerson = this.contactPerson;
            String other$contactPerson = other.contactPerson;
            return !(this$contactPerson == null ? other$contactPerson != null : !this$contactPerson.equals(other$contactPerson));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DebitMemoReqItemPartner;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $debitMemoRequest = this.debitMemoRequest;
            result = result * 59 + ($debitMemoRequest == null ? 43 : $debitMemoRequest.hashCode());
            String $debitMemoRequestItem = this.debitMemoRequestItem;
            result = result * 59 + ($debitMemoRequestItem == null ? 43 : $debitMemoRequestItem.hashCode());
            String $partnerFunction = this.partnerFunction;
            result = result * 59 + ($partnerFunction == null ? 43 : $partnerFunction.hashCode());
            String $customer = this.customer;
            result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
            String $supplier = this.supplier;
            result = result * 59 + ($supplier == null ? 43 : $supplier.hashCode());
            String $personnel = this.personnel;
            result = result * 59 + ($personnel == null ? 43 : $personnel.hashCode());
            String $contactPerson = this.contactPerson;
            result = result * 59 + ($contactPerson == null ? 43 : $contactPerson.hashCode());
            return result;
        }

        public String getDebitMemoRequest() {
            return this.debitMemoRequest;
        }

        public DebitMemoReqItemPartner setDebitMemoRequest(String debitMemoRequest) {
            this.debitMemoRequest = debitMemoRequest;
            return this;
        }

        public String getDebitMemoRequestItem() {
            return this.debitMemoRequestItem;
        }

        public DebitMemoReqItemPartner setDebitMemoRequestItem(String debitMemoRequestItem) {
            this.debitMemoRequestItem = debitMemoRequestItem;
            return this;
        }

        public String getPartnerFunction() {
            return this.partnerFunction;
        }

        public DebitMemoReqItemPartner setPartnerFunction(String partnerFunction) {
            this.partnerFunction = partnerFunction;
            return this;
        }

        public String getCustomer() {
            return this.customer;
        }

        public DebitMemoReqItemPartner setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public String getSupplier() {
            return this.supplier;
        }

        public DebitMemoReqItemPartner setSupplier(String supplier) {
            this.supplier = supplier;
            return this;
        }

        public String getPersonnel() {
            return this.personnel;
        }

        public DebitMemoReqItemPartner setPersonnel(String personnel) {
            this.personnel = personnel;
            return this;
        }

        public String getContactPerson() {
            return this.contactPerson;
        }

        public DebitMemoReqItemPartner setContactPerson(String contactPerson) {
            this.contactPerson = contactPerson;
            return this;
        }

        public DebitMemoReqItemPartner setErpConfigContext(ErpConfigContext erpConfigContext) {
            this.erpConfigContext = erpConfigContext;
            return this;
        }
    }
}

